(ns sgr-sound.utils
  (:import  [javax.sound.sampled AudioSystem AudioFormat AudioFormat$Encoding]))

(defn getFormat [audioFileFormat]
  (.getFormat audioFileFormat))

(defn getAudioFileFormat [file]
  (AudioSystem/getAudioFileFormat file))

(defn getChannels
  "Obtains the number of channels."
  [audioFormat]
  (.getChannels audioFormat))

(defn getEncoding
  "Obtains the type of encoding for sounds in this format."
  [audioFormat]
  (.getEncofing audioFormat))

(defn getFrameRate
  "Obtains the frame rate in frames per second."
  [audioFormat]
  (.getFrameRate audioFormat))

(defn getFrameSize
  "Obtains the frame size in bytes."
  [audioFormat]
  (.getFrameSize audioFormat))

(defn getSampleRate
  "Obtains the sample rate."
  [audioFormat]
  (.getSampleRate audioFormat))

(defn getSampleSizeInBits
  "Obtains the size of a sample."
  [audioFormat]
  (.getSampleSizeInBits audioFormat))

(defn isBigEndian
  "Indicates whether the audio data is stored in big-endian or little-endian byte order."
  [audioFormat]
  (.isBigEndian audioFormat))

(defn matches
  "Indicates whether this format matches the one specified."
  [firstAudioFormat secondAudioFormat]
  (.matches firstAudioFormat secondAudioFormat))

(defn toString
  "Returns a string that describes the format, such as: 'PCM SIGNED 22050 Hz 16 bit mono big-endian'."
  [audioFormat]
  (.toString audioFormat))

(defn getAudioInputStream
  ([file]
   (AudioSystem/getAudioInputStream file))
  ([targetFormat sourceStream]
   (AudioSystem/getAudioInputStream targetFormat sourceStream)))

(defn isConversionSupported [targetFormat sourceFormat]
  (AudioSystem/isConversionSupported targetFormat sourceFormat))

(defn newAudioFormat
  "Constructs an AudioFormat with the given parameters.
   float sampleRate, int sampleSizeInBits, int channels, boolean signed, boolean bigEndian"
  [sampleRate sampleSizeInBits channels signed bigEndian]
  (AudioFormat. sampleRate sampleSizeInBits channels signed bigEndian))

(defn writeAudioStream [inputStream type targetFile]
  (AudioSystem/write inputStream type targetFile))
