(ns sgr-db.config
  (:require [monger.core :as mg])
  (:import [com.mongodb MongoOptions ServerAddress]))

(def db-config {:db               "sgr"
                :users-coll     "users"
                :records-coll "records"})

(def ^MongoOptions  opts (mg/mongo-options {:threads-allowed-to-block-for-connection-multiplier 300}))
(def ^ServerAddress sa   (mg/server-address "127.0.0.1" 27017))
(def                conn (mg/connect sa opts))
