(ns sgr-db.models
  (:require [schema.core :as s]))

(def RecordRevision
  "Metadata about a file at a particular point in time"
  {:revision-id s/Str
   :grid-id     s/Str
   (s/optional-key :created-on) org.joda.time.DateTime
   (s/optional-key :sha256    ) s/Str})

(def Record
  "Attributes about a record"
  {:record-id s/Str
   :converted? s/Bool
   :revisions RecordRevision
   (s/optional-key :mfcc) [s/Num]
   (s/optional-key :path)  s/Str
   (s/optional-key :type)  s/Str})

(def User
  "Attributes about a user"
  {:user-id  s/Str
   :records [Record]
   (s/optional-key :created-on) org.joda.time.DateTime
   (s/optional-key :name      ) s/Str
   (s/optional-key :gender    ) s/Str
   (s/optional-key :genderSVM ) s/Str
   (s/optional-key :SVM?      ) s/Bool})

