/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.garden.javanativeloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NativeLoader {
    private static final Collection<SystemPatternCollPair> SystemPatterns;
    private static final Collection<ArchPatternCollPair> ArchPatterns;

    private NativeLoader() {
    }

    public static Arch detectArch(boolean throwWhenNotFound) {
        String archString = java.lang.System.getProperty("os.arch");
        for (ArchPatternCollPair apPair : ArchPatterns) {
            for (Pattern p : apPair.pats) {
                Matcher m = p.matcher(archString);
                if (!m.find()) continue;
                return apPair.arch;
            }
        }
        if (throwWhenNotFound) {
            throw new ArchNotDetectedException(archString);
        }
        return Arch.Unknown;
    }

    public static System detectSystem(boolean throwWhenNotFound) {
        String systemString = java.lang.System.getProperty("os.name");
        for (SystemPatternCollPair spPair : SystemPatterns) {
            for (Pattern p : spPair.pats) {
                Matcher m = p.matcher(systemString);
                if (!m.find()) continue;
                return spPair.system;
            }
        }
        if (throwWhenNotFound) {
            throw new SystemNotDetectedException(systemString);
        }
        return System.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String saveResourceInTempFolder(String name) {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            if (is == null) {
                throw new RuntimeException(String.format("Could not find the resource %s in the classpath", name));
            }
            try {
                String string;
                File tmpFile = File.createTempFile("javaNativeLoaderLib_", null);
                tmpFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tmpFile);
                try {
                    byte[] buffer = new byte[8192];
                    int read = is.read(buffer);
                    while (read != -1) {
                        fos.write(buffer, 0, read);
                        read = is.read(buffer);
                    }
                    string = tmpFile.getCanonicalPath();
                }
                catch (Throwable throwable) {
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return string;
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadLibrary(String name) {
        java.lang.System.load(NativeLoader.saveResourceInTempFolder(name));
    }

    public static void loadLibrary(Collection<LibraryLoadInfo> loadInfos) {
        Arch arch = NativeLoader.detectArch(true);
        System sys = NativeLoader.detectSystem(true);
        for (LibraryLoadInfo info : loadInfos) {
            if (!info.arch.equals((Object)arch) || !info.system.equals((Object)sys)) continue;
            NativeLoader.loadLibrary(info.name);
            return;
        }
        throw new NoLibraryFoundException(sys.name(), arch.name());
    }

    static {
        ArrayList<SystemPatternCollPair> sysPats = new ArrayList<SystemPatternCollPair>(3);
        ArrayList<Pattern> pats = new ArrayList<Pattern>(2);
        pats.add(Pattern.compile("Mac OS X"));
        pats.add(Pattern.compile("Darwin"));
        sysPats.add(new SystemPatternCollPair(System.MacOSX, Collections.unmodifiableCollection(pats)));
        pats = new ArrayList(1);
        pats.add(Pattern.compile("Windows"));
        sysPats.add(new SystemPatternCollPair(System.Windows, Collections.unmodifiableCollection(pats)));
        pats = new ArrayList(1);
        pats.add(Pattern.compile("Linux"));
        sysPats.add(new SystemPatternCollPair(System.Linux, Collections.unmodifiableCollection(pats)));
        SystemPatterns = Collections.unmodifiableCollection(sysPats);
        ArrayList<ArchPatternCollPair> archPats = new ArrayList<ArchPatternCollPair>(2);
        pats = new ArrayList(2);
        pats.add(Pattern.compile("x86[^_]"));
        pats.add(Pattern.compile("i386"));
        archPats.add(new ArchPatternCollPair(Arch.i386, Collections.unmodifiableCollection(pats)));
        pats = new ArrayList(2);
        pats.add(Pattern.compile("x86_64"));
        pats.add(Pattern.compile("amd64"));
        archPats.add(new ArchPatternCollPair(Arch.x64, Collections.unmodifiableCollection(pats)));
        ArchPatterns = Collections.unmodifiableCollection(archPats);
    }

    private static final class SystemPatternCollPair {
        public final System system;
        public final Collection<Pattern> pats;

        public SystemPatternCollPair(System system, Collection<Pattern> pats) {
            this.pats = pats;
            this.system = system;
        }
    }

    private static final class ArchPatternCollPair {
        public final Arch arch;
        public final Collection<Pattern> pats;

        public ArchPatternCollPair(Arch arch, Collection<Pattern> pats) {
            this.arch = arch;
            this.pats = pats;
        }
    }

    public static final class NoLibraryFoundException
    extends RuntimeException {
        public NoLibraryFoundException(String sysName, String archName) {
            super(String.format("Could not find a library for the system+arch combination: %s + %s", sysName, archName));
        }
    }

    public static final class SystemNotDetectedException
    extends RuntimeException {
        public SystemNotDetectedException(String actual) {
            super(String.format("Failed to detect system, found: %s", actual));
        }
    }

    public static final class ArchNotDetectedException
    extends RuntimeException {
        public ArchNotDetectedException(String actual) {
            super(String.format("Failed to detect architecture, found: %s", actual));
        }
    }

    public static final class LibraryLoadInfo {
        public final String name;
        public final System system;
        public final Arch arch;

        public LibraryLoadInfo(String name, System system, Arch arch) {
            this.name = name;
            this.arch = arch;
            this.system = system;
        }
    }

    public static enum Arch {
        i386,
        x64,
        Unknown;

    }

    public static enum System {
        Windows,
        Linux,
        MacOSX,
        Unknown;

    }
}

