/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.sim.server;

import com.botbox.util.ArrayUtils;
import com.botbox.util.ThreadPool;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Logger;
import se.sics.isl.inet.InetServer;
import se.sics.isl.transport.Context;
import se.sics.isl.transport.ContextFactory;
import se.sics.isl.util.AMonitor;
import se.sics.isl.util.AdminMonitor;
import se.sics.isl.util.ConfigManager;
import se.sics.tasim.props.AdminContent;
import se.sics.tasim.sim.Gateway;
import se.sics.tasim.sim.server.TACTChannel;

public class TACTGateway
extends Gateway
implements AMonitor {
    private static final String CONF = "sim.gateway.";
    private static final Logger log = Logger.getLogger(TACTGateway.class.getName());
    private static final String STATUS_NAME = "TACT";
    private Context transportContext;
    private ThreadPool threadPool;
    private TACTServer server;
    private TACTChannel[] agentConnections;
    private boolean isRunning = true;

    protected void initGateway() {
        this.transportContext = AdminContent.createContext();
        ConfigManager config = this.getConfig();
        String name = this.getName();
        String contextFactoryClassName = config.getProperty(CONF + name + ".contextFactory", config.getProperty("server.contextFactory"));
        try {
            ContextFactory contextFactory = (ContextFactory)Class.forName(contextFactoryClassName).newInstance();
            this.transportContext = contextFactory.createContext(this.transportContext);
        }
        catch (ClassNotFoundException e) {
            log.severe("server " + this.getName() + " unable to load context factory: Class not found");
        }
        catch (InstantiationException e) {
            log.severe("server " + this.getName() + " unable to load context factory: Class cannot be instantiated");
        }
        catch (IllegalAccessException e) {
            log.severe("server " + this.getName() + " unable to load context factory: Illegal access exception");
        }
    }

    protected void startGateway() throws IOException {
        if (!this.isRunning || this.server != null) {
            return;
        }
        ConfigManager config = this.getConfig();
        String name = this.getName();
        String host = config.getProperty(CONF + name + ".host", config.getProperty("server.host"));
        int port = config.getPropertyAsInt(CONF + name + ".port", 6502);
        int minThreads = config.getPropertyAsInt(CONF + name + ".minThreads", 5);
        int maxThreads = config.getPropertyAsInt(CONF + name + ".maxThreads", 50);
        int maxIdleThreads = config.getPropertyAsInt(CONF + name + ".maxIdleThreads", 25);
        this.threadPool = ThreadPool.getThreadPool("viewer");
        this.threadPool.setMinThreads(minThreads);
        this.threadPool.setMaxThreads(maxThreads);
        this.threadPool.setMaxIdleThreads(maxIdleThreads);
        this.threadPool.setInterruptThreadsAfter(120000);
        this.server = new TACTServer(this, "tact", host, port);
        this.server.start();
        log.info("TACT Server started at " + this.server.getBindAddress());
        AdminMonitor adminMonitor = AdminMonitor.getDefault();
        if (adminMonitor != null) {
            adminMonitor.addMonitor(STATUS_NAME, this);
        }
    }

    protected void stopGateway() {
        TACTChannel[] connections;
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        TACTServer server = this.server;
        if (server != null) {
            this.server = null;
            server.stop();
        }
        if ((connections = this.agentConnections) != null) {
            int n = connections.length;
            for (int i = 0; i < n; ++i) {
                connections[i].close();
            }
        }
    }

    public String getStatus(String propertyName) {
        if (propertyName != STATUS_NAME) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("--- TACT Gateway ---");
        TACTChannel[] connections = this.agentConnections;
        if (connections != null) {
            int n = connections.length;
            for (int i = 0; i < n; ++i) {
                TACTChannel channel = connections[i];
                sb.append('\n').append(i + 1).append(": ").append(channel.getName()).append(" (").append(channel.getAddress()).append(',').append(channel.getRemoteHost()).append(':').append(channel.getRemotePort()).append(')');
            }
        } else {
            sb.append("\n<no connections>");
        }
        return sb.toString();
    }

    final ThreadPool getThreadPool() {
        return this.threadPool;
    }

    final Context getContext() {
        return this.transportContext;
    }

    final void loginAgentChannel(TACTChannel channel, String name, String password) {
        super.loginAgentChannel(channel, name, password);
    }

    public synchronized void addAgentConnection(TACTChannel connection) {
        this.agentConnections = (TACTChannel[])ArrayUtils.add(TACTChannel.class, this.agentConnections, connection);
    }

    public synchronized void removeAgentConnection(TACTChannel connection) {
        this.agentConnections = (TACTChannel[])ArrayUtils.remove((Object[])this.agentConnections, connection);
    }

    private static class TACTServer
    extends InetServer {
        private TACTGateway gateway;

        public TACTServer(TACTGateway gateway, String name, String host, int port) {
            super(name, host, port);
            this.gateway = gateway;
        }

        protected void serverStarted() {
        }

        protected void serverShutdown() {
            if (this.gateway.isRunning) {
                log.severe("server " + this.getName() + " died!!!");
            }
        }

        protected void newConnection(Socket socket) throws IOException {
            new TACTChannel(this.gateway, socket);
        }
    }
}

