/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.sim;

import com.botbox.util.ArrayUtils;
import java.util.logging.Logger;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.Agent;
import se.sics.tasim.aw.AgentService;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.TimeListener;
import se.sics.tasim.sim.AgentChannel;
import se.sics.tasim.sim.MessageListener;
import se.sics.tasim.sim.Simulation;

public class SimulationAgent
extends AgentService {
    private Simulation simulation;
    private boolean isRunning = false;
    private boolean hasAgentBeenActive = false;
    private boolean isBlocked = false;
    private int index;
    private int role;
    private int participantID = -1;
    private boolean isProxy = false;
    private AgentChannel channel;
    private MessageListener[] messageListeners;

    public SimulationAgent(Agent agent, String name) {
        super(agent, name);
    }

    final void setup(Simulation simulation, int index, String address, int role, int participantID) {
        if (simulation == null || address == null) {
            throw new NullPointerException();
        }
        this.index = index;
        this.simulation = simulation;
        this.role = role;
        this.participantID = participantID;
        this.isRunning = true;
        this.isBlocked = false;
        this.initializeAgent();
        this.simulationSetup(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() {
        try {
            this.simulationStopped();
            Object var2_1 = null;
            this.isRunning = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isRunning = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdown() {
        try {
            this.simulationFinished();
            Object var2_1 = null;
            AgentChannel channel = this.channel;
            this.channel = null;
            if (channel != null) {
                channel.removeProxyAgent(this);
            }
            this.simulation = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            AgentChannel channel = this.channel;
            this.channel = null;
            if (channel != null) {
                channel.removeProxyAgent(this);
            }
            this.simulation = null;
            throw throwable;
        }
    }

    int getParticipantID() {
        return this.participantID;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    void setProxy(boolean isProxy) {
        this.isProxy = isProxy;
    }

    boolean isBlocked() {
        return this.isBlocked;
    }

    void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    boolean hasAgentChannel() {
        return this.channel != null;
    }

    AgentChannel getAgentChannel() {
        return this.channel;
    }

    synchronized void setAgentChannel(AgentChannel channel, boolean recover) {
        if (channel != this.channel) {
            if (!this.isProxy) {
                throw new IllegalStateException("proxy mode not supported in " + this.getName());
            }
            if (channel == null) {
                throw new NullPointerException();
            }
            if (this.channel != null) {
                this.channel.removeProxyAgent(this);
            }
            this.channel = channel;
            channel.setProxyAgent(this);
            channel.setSimulationThreadPool(this.simulation.getSimulationThreadPool());
            if (this.simulation != null && recover) {
                this.simulation.requestAgentRecovery(this);
            }
        }
    }

    synchronized void removeAgentChannel(AgentChannel channel) {
        if (channel == this.channel) {
            this.channel = null;
        }
    }

    public boolean isSupported(String name) {
        AgentChannel channel = this.channel;
        return channel != null ? channel.isSupported(name) : false;
    }

    public void requestPing() {
        AgentChannel channel = this.channel;
        if (channel != null) {
            channel.requestPing();
        }
    }

    public int getPingCount() {
        AgentChannel channel = this.channel;
        return channel != null ? channel.getPingCount() : 0;
    }

    public long getLastResponseTime() {
        AgentChannel channel = this.channel;
        return channel != null ? channel.getLastResponseTime() : 0L;
    }

    public long getAverageResponseTime() {
        AgentChannel channel = this.channel;
        return channel != null ? channel.getAverageResponseTime() : 0L;
    }

    public boolean hasAgentBeenActive() {
        return this.hasAgentBeenActive;
    }

    public int getIndex() {
        return this.index;
    }

    public int getRole() {
        return this.role;
    }

    protected long getServerTime() {
        return this.simulation.getServerTime();
    }

    protected void addTimeListener(TimeListener listener) {
        this.simulation.addTimeListener(listener);
    }

    protected void removeTimeListener(TimeListener listener) {
        this.simulation.removeTimeListener(listener);
    }

    protected void deliverFromAgent(Message message) {
        super.sendMessage(message);
    }

    protected void deliverToServer(Message message) {
        if (this.isRunning) {
            this.hasAgentBeenActive = true;
            this.fireMessageSent(message);
            this.simulation.deliverMessage(message);
        }
    }

    protected void deliverToServer(int role, Transportable content) {
        if (this.isRunning) {
            this.hasAgentBeenActive = true;
            this.fireMessageSent(role, content);
            this.simulation.deliverMessageToRole(this, role, content);
        }
    }

    final void messageReceived(Simulation simulation, Message message) {
        if (simulation != this.simulation) {
            throw new SecurityException("message from wrong simulation");
        }
        this.fireMessageReceived(message);
        if (!this.isBlocked) {
            if (this.isProxy) {
                AgentChannel channel = this.channel;
                if (channel != null) {
                    channel.deliverToAgent(message);
                }
            } else {
                this.deliverToAgent(message);
            }
        }
    }

    public synchronized void addMessageListener(MessageListener listener) {
        this.messageListeners = (MessageListener[])ArrayUtils.add(MessageListener.class, this.messageListeners, listener);
    }

    public synchronized void removeMessageListener(MessageListener listener) {
        this.messageListeners = (MessageListener[])ArrayUtils.remove((Object[])this.messageListeners, listener);
    }

    private void fireMessageReceived(Message message) {
        MessageListener[] listeners = this.messageListeners;
        if (listeners != null) {
            String sender = message.getSender();
            Transportable content = message.getContent();
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].messageReceived(this, sender, content);
            }
        }
    }

    private void fireMessageSent(Message message) {
        MessageListener[] listeners = this.messageListeners;
        if (listeners != null) {
            String receiver = message.getReceiver();
            Transportable content = message.getContent();
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].messageSent(this, receiver, content);
            }
        }
    }

    private void fireMessageSent(int role, Transportable content) {
        MessageListener[] listeners = this.messageListeners;
        if (listeners != null) {
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].messageSent(this, role, content);
            }
        }
    }

    static int indexOf(SimulationAgent[] array, int participantID) {
        if (array != null) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                SimulationAgent a = array[i];
                if (a.participantID != participantID) continue;
                return i;
            }
        }
        return -1;
    }

    protected void finalize() throws Throwable {
        Logger.global.info("SIMULATIONAGENT " + this.getName() + " (" + this.getAddress() + ',' + this.participantID + ") IS BEING GARBAGED");
        super.finalize();
    }
}

