/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.is.common;

import com.botbox.util.ArrayQueue;
import java.util.logging.Logger;
import se.sics.tasim.is.common.SimServer;

public class SimulationArchiver
implements Runnable {
    private static final Logger log = Logger.getLogger(SimulationArchiver.class.getName());
    private ArrayQueue simulationQueue = new ArrayQueue();
    private boolean isRunning = false;

    public synchronized void addSimulation(SimServer simServer, int simulationID) {
        this.simulationQueue.add(simServer);
        this.simulationQueue.add(new Integer(simulationID));
        if (!this.isRunning) {
            this.isRunning = true;
            new Thread((Runnable)this, "gameArchiver").start();
        } else {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                int simulationID;
                SimServer simServer;
                SimulationArchiver simulationArchiver = this;
                synchronized (simulationArchiver) {
                    while (this.simulationQueue.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    simServer = (SimServer)this.simulationQueue.remove(0);
                    if (simServer == null) {
                        break;
                    }
                    simulationID = (Integer)this.simulationQueue.remove(0);
                }
                this.generateResults(simServer, simulationID);
            }
        }
        finally {
            this.isRunning = false;
        }
    }

    private void generateResults(SimServer simServer, int simulationID) {
        simServer.generateResults(simulationID, true);
    }
}

