/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.is.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.ByteArrayISO8859Writer;
import se.sics.tasim.is.common.HttpPage;
import se.sics.tasim.is.common.SimServer;

public class HistoryPage
extends HttpPage {
    private static final Logger log = Logger.getLogger(HistoryPage.class.getName());
    private final String pathInfo;
    private final SimServer simServer;
    private final String gamePath;
    private int simulationsPerPage;
    private String simTablePrefix;

    public HistoryPage(String pathInfo, SimServer simServer, String gamePath, String simTablePrefix, int simulationsPerPage) {
        this.pathInfo = pathInfo;
        this.simServer = simServer;
        if (gamePath.length() > 0 && !gamePath.endsWith(File.separator)) {
            gamePath = gamePath + File.separator;
        }
        this.gamePath = gamePath;
        this.simTablePrefix = simTablePrefix;
        this.simulationsPerPage = simulationsPerPage;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (!this.pathInfo.equals(pathInContext)) {
            return;
        }
        String gameStr = request.getParameter("id");
        if ("last".equals(gameStr)) {
            this.showLastGame(response);
            return;
        }
        int lastGameID = this.simServer.getLastPlayedSimulationID();
        StringBuffer game = new StringBuffer();
        game.append("<html><body bgcolor=white link='#204020' vlink='#204020'><font face='Arial,Helvetica,sans-serif' size='+2'><b>Game History for ").append(this.simServer.getServerName()).append("</b></font><p>\r\n");
        if (lastGameID == -1) {
            game.append("<font face='Arial,Helvetica,sans-serif' size='+1'>No games played</font><p>\r\n");
        } else {
            int gameID = lastGameID;
            if (gameStr != null) {
                try {
                    gameID = Integer.parseInt(gameStr);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int id = 1 + (--gameID - gameID % this.simulationsPerPage);
            StringBuffer sb = new StringBuffer();
            sb.append("<font face='Arial,Helvetica,sans-serif' size=2>");
            this.link(sb, "First", 1, id > 1);
            this.link(sb, "Previous", id - this.simulationsPerPage, id > 1);
            this.link(sb, "Next", id + this.simulationsPerPage, id + this.simulationsPerPage <= lastGameID);
            this.link(sb, "Last", lastGameID, id + this.simulationsPerPage <= lastGameID);
            sb.append("</font>");
            String links = sb.toString();
            game.append("<form><table border=0 width='100%'><tr><td>").append(links).append("</td><td align=right><font face='Arial,Helvetica,sans-serif' size=2>Go to page with game <input type=text name=id size=5 border=0><input type=submit value=Go></font></td></tr></table></form>\r\n<p>\r\n<table border=1 width='100%'><colgroup span=1 align=right></colgroup><colgroup span=2></colgroup><tr><th>Game</th><th>Start Time (Duration)</th><th>Participants</th></tr>");
            this.readPage(game, (id - 1) / this.simulationsPerPage + 1);
            game.append("</table>\r\n<p>\r\n").append(links);
        }
        game.append("</body></html>\r\n");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
        writer.write(game.toString());
        response.setContentType("text/html");
        response.setContentLength(writer.size());
        writer.writeTo(response.getOutputStream());
        response.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPage(StringBuffer data, int id) {
        int len;
        InputStreamReader file = null;
        char[] readChars = new char[2048];
        file = new FileReader(this.gamePath + this.simTablePrefix + id + ".html");
        while ((len = file.read(readChars, 0, 2048)) > 0) {
            data.append(readChars, 0, len);
        }
        Object var7_8 = null;
        if (file == null) return;
        try {
            file.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (FileNotFoundException e) {
                System.err.println("could not find " + this.gamePath + this.simTablePrefix + id + ".html");
                data.append("<tr><td colspan='4' align='center'>&nbsp;</td></tr>");
                Object var7_9 = null;
                if (file == null) return;
                try {
                    file.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "could not read game page " + id, e);
                data.append("<tr><td colspan='4' align='center'>[<font color=red>could not read game data</font>]</td></tr>");
                Object var7_10 = null;
                if (file == null) return;
                try {
                    file.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (file == null) throw throwable;
            try {
                file.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void showLastGame(HttpResponse response) throws HttpException, IOException {
        int lastGameID = this.simServer.getLastPlayedSimulationID();
        StringBuffer page = new StringBuffer();
        int delay = this.simServer.getSecondsToNextSimulationEnd();
        page.append("<html><head><title>").append("Last game played at ").append(this.simServer.getServerName()).append("</title>\r\n<META http-equiv=\"refresh\" content=\"").append(delay).append(this.pathInfo).append("?id=last\">\r\n</head>\r\n");
        if (lastGameID < 1) {
            page.append("<body>Waiting for first game</body></html>\r\n");
        } else {
            this.readResultPage(page, lastGameID);
        }
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
        writer.write(page.toString());
        response.setContentType("text/html");
        response.setContentLength(writer.size());
        writer.writeTo(response.getOutputStream());
        response.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readResultPage(StringBuffer data, int id) {
        int len;
        InputStreamReader file = null;
        char[] readChars = new char[2048];
        file = new FileReader(this.gamePath + id + "/index.html");
        while ((len = file.read(readChars, 0, 2048)) > 0) {
            data.append(readChars, 0, len);
        }
        Object var7_8 = null;
        if (file == null) return;
        try {
            file.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (FileNotFoundException e) {
                data.append("Could not find results for game ").append(id);
                Object var7_9 = null;
                if (file == null) return;
                try {
                    file.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "could not read result page for " + id, e);
                data.append("Could not read result page for " + id + ": " + e);
                Object var7_10 = null;
                if (file == null) return;
                try {
                    file.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (file == null) throw throwable;
            try {
                file.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void link(StringBuffer sb, String title, int pos, boolean link) {
        if (link) {
            sb.append("<a href='?id=").append(pos).append("'>").append(title).append("</a> &nbsp; ");
        } else {
            sb.append(title).append(" &nbsp; ");
        }
    }
}

