/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.is.common;

import org.mortbay.http.HashUserRealm;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserPrincipal;
import se.sics.tasim.is.common.InfoServer;

public class AgentRealm
extends HashUserRealm {
    public static final String ADMIN_ROLE = "admin";
    private InfoServer infoServer;

    public AgentRealm(InfoServer infoServer, String realmName) {
        super(realmName);
        this.infoServer = infoServer;
    }

    void setAdminUser(String name, String password) {
        this.put(name, password);
        this.addUserToRole(name, ADMIN_ROLE);
    }

    public UserPrincipal authenticate(String username, Object credentials, HttpRequest request) {
        if (this.get(username) == null) {
            this.updateUser(username);
        }
        return super.authenticate(username, credentials, request);
    }

    public void updateUser(String name) {
        String password = this.infoServer.getUserPassword(name);
        if (password != null) {
            this.put(name, password);
        }
    }
}

