/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.tact;

import com.botbox.util.ArrayQueue;
import com.botbox.util.JobStatus;
import com.botbox.util.ThreadPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TACTConnection {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    private static final Logger log = Logger.getLogger(TACTConnection.class.getName());
    private static final byte[] TACT_HEADER = new byte[]{84, 65, 67, 84, 0, 0, 0, 0};
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private ThreadPool threadPool;
    private String name;
    private String fullName;
    private String userName;
    private long connectTime;
    private Socket socket;
    private DataInputStream input;
    private DataOutputStream output;
    private String remoteHost;
    private int remotePort;
    private boolean isServerConnection;
    private int maxBuffer = 0x200000;
    private long sentBytes;
    private long requestedSentBytes;
    private ArrayQueue outBuffer;
    private boolean writerRunning = false;
    private boolean isOpen = false;
    private boolean isClosed = false;
    private TACTWriter tactWriter;
    private TACTReader tactReader;

    public TACTConnection(String name, String host, int port) {
        this.name = name;
        this.fullName = name;
        this.remoteHost = host;
        this.remotePort = port;
        this.isServerConnection = false;
        this.connectTime = System.currentTimeMillis();
    }

    public TACTConnection(String name, Socket socket) {
        this.name = name;
        this.fullName = name;
        this.socket = socket;
        this.isServerConnection = true;
        this.connectTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.fullName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException();
        }
        this.fullName = userName + '@' + this.name;
        this.userName = userName;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getMaxBuffer() {
        return this.maxBuffer;
    }

    public void setMaxBuffer(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    public ThreadPool getThreadPool() {
        ThreadPool pool = this.threadPool;
        if (pool == null) {
            pool = this.threadPool = ThreadPool.getDefaultThreadPool();
        }
        return pool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public final void start() throws IOException {
        if (this.input != null) {
            return;
        }
        if (this.isServerConnection) {
            InetAddress remoteAddress = this.socket.getInetAddress();
            this.remoteHost = remoteAddress.getHostAddress();
            this.remotePort = this.socket.getPort();
            log.finest(this.fullName + ": new connection from " + this.remoteHost + ':' + this.remotePort);
        } else {
            this.socket = new Socket(this.remoteHost, this.remotePort);
        }
        this.input = new DataInputStream(this.socket.getInputStream());
        this.output = new DataOutputStream(this.socket.getOutputStream());
        if (!this.isServerConnection) {
            this.output.write(TACT_HEADER);
        }
        this.isOpen = true;
        this.outBuffer = new ArrayQueue();
        this.tactReader = new TACTReader(this);
        this.tactReader.start();
        this.connectionOpened();
    }

    public void write(byte[] data) {
        if (this.isOpen && data != null) {
            this.requestedSentBytes += (long)data.length;
            if (this.requestedSentBytes - this.sentBytes > (long)this.maxBuffer) {
                log.log(Level.SEVERE, this.fullName + ": could not send data", new IOException("out buffer overflow: " + (this.requestedSentBytes - this.sentBytes)));
                this.closeImmediately();
            } else {
                this.addOutBuffer(data);
            }
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.addOutBuffer(null);
        }
    }

    public void closeImmediately() {
        this.closeImmediately(true);
    }

    private void closeImmediately(boolean useThread) {
        if (!this.isClosed) {
            this.isOpen = false;
            this.isClosed = true;
            if (useThread) {
                this.getThreadPool().invokeLater(new ConnectionCloser(this));
            } else {
                this.doClose();
            }
        }
    }

    private void doClose() {
        log.finest(this.fullName + ": connection closed from " + this.remoteHost);
        try {
            this.connectionClosed();
        }
        catch (Exception e) {
            log.log(Level.WARNING, this.fullName + ": failed to close connection", e);
        }
        try {
            this.tactReader.interrupt();
            this.output.close();
            this.input.close();
            this.socket.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, this.fullName + ": could not close connection", e);
        }
    }

    protected abstract void connectionOpened();

    protected abstract void connectionClosed();

    protected abstract void dataRead(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutBuffer(byte[] data) {
        ArrayQueue arrayQueue = this.outBuffer;
        synchronized (arrayQueue) {
            this.outBuffer.add(data);
            if (!this.writerRunning) {
                if (this.tactWriter == null) {
                    this.tactWriter = new TACTWriter(this);
                }
                this.writerRunning = true;
                this.getThreadPool().invokeLater(this.tactWriter);
            } else {
                this.outBuffer.notify();
            }
        }
    }

    private static class ConnectionCloser
    implements Runnable {
        private final TACTConnection connection;

        public ConnectionCloser(TACTConnection connection) {
            this.connection = connection;
        }

        public void run() {
            this.connection.doClose();
        }

        public String toString() {
            return "ConnectionCloser[" + this.connection.fullName + ',' + this.connection.remoteHost + ']';
        }
    }

    private static class TACTReader
    extends Thread {
        private TACTConnection connection;

        TACTReader(TACTConnection connection) {
            super(connection.name);
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            byte[] buffer = new byte[8192];
            try {
                try {
                    this.connection.input.readFully(buffer, 0, TACT_HEADER.length);
                    for (int i = 0; i < 4; ++i) {
                        if (buffer[i] == TACT_HEADER[i]) continue;
                        throw new IOException("illegal protocol header: " + new String(buffer, 0, 8));
                    }
                }
                catch (EOFException e) {
                    log.severe(this.connection.fullName + ": closed from other side");
                    Object var7_7 = null;
                    if (!this.connection.isOpen) return;
                    this.connection.closeImmediately(false);
                    return;
                }
                catch (Throwable e) {
                    if (this.connection.isOpen) {
                        log.log(Level.SEVERE, this.connection.fullName + ": reading error ", e);
                    }
                    Object var7_8 = null;
                    if (!this.connection.isOpen) return;
                    this.connection.closeImmediately(false);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!this.connection.isOpen) throw throwable;
                this.connection.closeImmediately(false);
                throw throwable;
            }
            while (this.connection.isOpen) {
                int size = this.connection.input.readInt();
                if (size > buffer.length) {
                    if (size > this.connection.getMaxBuffer()) {
                        throw new IOException("in buffer overflow: " + size);
                    }
                    buffer = new byte[size + 8192];
                }
                this.connection.input.readFully(buffer, 0, size);
                try {
                    this.connection.dataRead(buffer, 0, size);
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, this.connection.fullName + ": could not deliver data: " + size, e);
                }
            }
            Object var7_6 = null;
            if (!this.connection.isOpen) return;
            this.connection.closeImmediately(false);
        }
    }

    private static class TACTWriter
    implements Runnable {
        private TACTConnection connection;

        TACTWriter(TACTConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            byte[] data = null;
            boolean ok = false;
            JobStatus jobStatus = ThreadPool.getJobStatus();
            try {
                try {}
                catch (Throwable e) {
                    log.log(Level.SEVERE, this.connection.fullName + ": could not send data", e);
                    this.connection.closeImmediately(false);
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Object var8_9 = null;
                    if (ok) return;
                    ArrayQueue arrayQueue = this.connection.outBuffer;
                    // MONITORENTER : arrayQueue
                    if (!this.connection.outBuffer.isEmpty() && !this.connection.isClosed) {
                        log.warning("reinvoking writer for " + this.connection.fullName);
                        this.connection.getThreadPool().invokeLater(this);
                        return;
                    }
                    log.warning("writer for " + this.connection.fullName + " exiting");
                    this.connection.writerRunning = false;
                    // MONITOREXIT : arrayQueue
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (ok) throw throwable;
                ArrayQueue arrayQueue = this.connection.outBuffer;
                // MONITORENTER : arrayQueue
                if (!this.connection.outBuffer.isEmpty() && !this.connection.isClosed) {
                    log.warning("reinvoking writer for " + this.connection.fullName);
                    this.connection.getThreadPool().invokeLater(this);
                    throw throwable;
                }
                log.warning("writer for " + this.connection.fullName + " exiting");
                this.connection.writerRunning = false;
                // MONITOREXIT : arrayQueue
                throw throwable;
            }
            while (!this.connection.isClosed) {
                block24: {
                    block25: {
                        block23: {
                            ArrayQueue arrayQueue = this.connection.outBuffer;
                            // MONITORENTER : arrayQueue
                            if (this.connection.outBuffer.isEmpty()) {
                                try {
                                    this.connection.outBuffer.wait(800L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (this.connection.outBuffer.isEmpty()) break block23;
                            data = (byte[])this.connection.outBuffer.remove(0);
                            // MONITOREXIT : arrayQueue
                            if (data != null) break block24;
                            break block25;
                        }
                        this.connection.writerRunning = false;
                        ok = true;
                        // MONITOREXIT : arrayQueue
                        Object var8_7 = null;
                        if (ok) return;
                        ArrayQueue arrayQueue = this.connection.outBuffer;
                        // MONITORENTER : arrayQueue
                        if (!this.connection.outBuffer.isEmpty() && !this.connection.isClosed) {
                            log.warning("reinvoking writer for " + this.connection.fullName);
                            this.connection.getThreadPool().invokeLater(this);
                            return;
                        }
                        log.warning("writer for " + this.connection.fullName + " exiting");
                        this.connection.writerRunning = false;
                        // MONITOREXIT : arrayQueue
                        return;
                    }
                    this.connection.closeImmediately(false);
                    break;
                }
                if (jobStatus != null) {
                    jobStatus.stillAlive();
                }
                this.connection.sentBytes += data.length;
                this.connection.output.writeInt(data.length);
                this.connection.output.write(data);
                this.connection.output.flush();
            }
            ok = true;
            Object var8_8 = null;
            if (ok) return;
            ArrayQueue arrayQueue = this.connection.outBuffer;
            // MONITORENTER : arrayQueue
            if (!this.connection.outBuffer.isEmpty() && !this.connection.isClosed) {
                log.warning("reinvoking writer for " + this.connection.fullName);
                this.connection.getThreadPool().invokeLater(this);
                return;
            }
            log.warning("writer for " + this.connection.fullName + " exiting");
            this.connection.writerRunning = false;
            // MONITOREXIT : arrayQueue
        }

        public String toString() {
            return "TACTWriter[" + this.connection.fullName + ',' + this.connection.outBuffer.size() + ',' + this.connection.remoteHost + ']';
        }
    }
}

