/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.inet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InetServer {
    private static final Logger log = Logger.getLogger(InetServer.class.getName());
    private String name;
    private String host;
    private Server server;
    private int port;
    private static String localHostAddress;
    private static String localHostAddress2;
    private static String localHostName;
    private static String localHostName2;

    public InetServer(String name, int port) {
        this(name, null, port);
    }

    public InetServer(String name, String host, int port) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.host = host;
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public String getBindAddress() {
        return (this.host == null ? "*" : this.host) + ':' + this.port;
    }

    public String getHost() {
        return this.host == null ? InetServer.getLocalHostName() : this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public final void start() throws IOException {
        if (this.server == null) {
            this.server = new Server(this, this.host, this.port);
            this.server.start();
            this.serverStarted();
        }
    }

    public final void stop() {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
            this.serverShutdown();
        }
    }

    protected abstract void serverStarted();

    protected abstract void serverShutdown();

    protected abstract void newConnection(Socket var1) throws IOException;

    public static String getLocalHostName() {
        if (localHostAddress == null) {
            InetAddress localHost;
            String address = null;
            try {
                localHost = InetAddress.getLocalHost();
                address = localHost.getHostAddress();
                localHostName = localHost.getHostName();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "could not retrieve local host", e);
            }
            if (address == null) {
                address = "127.0.0.1";
            }
            try {
                localHost = InetAddress.getByName(address);
                localHostAddress2 = localHost.getHostAddress();
                localHostName2 = localHost.getHostName();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "could not retrieve local host", e);
            }
            if (localHostName2 == null) {
                localHostName2 = localHostAddress2 != null ? localHostAddress2 : (localHostName != null ? localHostName : address);
            }
            if (localHostName != null && localHostName.equalsIgnoreCase(localHostName2)) {
                localHostName = null;
            }
            if (localHostAddress2 != null && localHostAddress2.equalsIgnoreCase(address)) {
                localHostAddress2 = null;
            }
            localHostAddress = address;
        }
        return localHostName2;
    }

    private static class Server
    extends Thread {
        private boolean stopped = false;
        private ServerSocket socket;
        private InetServer inet;

        Server(InetServer inet, String host, int port) throws IOException {
            super(inet.name);
            if (host != null) {
                this.socket = new ServerSocket();
                this.socket.bind(new InetSocketAddress(host, port));
            } else {
                this.socket = new ServerSocket(port);
            }
            this.inet = inet;
        }

        void shutdown() {
            if (!this.stopped) {
                this.stopped = true;
                try {
                    this.interrupt();
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                block16: while (true) {
                    try {
                        while (!this.stopped) {
                            Socket connection = this.socket.accept();
                            try {
                                this.inet.newConnection(connection);
                                continue block16;
                            }
                            catch (ThreadDeath e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                log.log(Level.SEVERE, this.inet.name + ": failed to handle new connection", e);
                                try {
                                    connection.close();
                                    continue block16;
                                }
                                catch (Exception exception) {
                                }
                            }
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        log.log(Level.SEVERE, this.inet.name + ": listening error", exception);
                        break block18;
                    }
                }
                finally {
                    this.stopped = true;
                    try {
                        this.socket.close();
                        this.inet.stop();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

