/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.inet;

import com.botbox.util.ArrayQueue;
import com.botbox.util.JobStatus;
import com.botbox.util.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InetConnection {
    private static final Logger log = Logger.getLogger(InetConnection.class.getName());
    private static final Object CLOSE_MESSAGE = new Object();
    private String name;
    private String fullName;
    private String userName;
    private long connectTime;
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    private String remoteHost;
    private int remotePort;
    private final boolean isServerConnection;
    private boolean isDeliveryBuffered = false;
    private boolean delivererRunning = false;
    private boolean isWriteBuffered = false;
    private boolean writerRunning = false;
    private boolean isOpen = false;
    private boolean isClosed = true;
    private ArrayQueue inBuffer;
    private ArrayQueue outBuffer;
    private ThreadPool threadPool;
    private MessageWriter messageWriter;
    private MessageDeliverer messageDeliverer;
    private MessageReader messageReader;

    public InetConnection(String name, Socket socket) {
        this.isServerConnection = true;
        this.name = name;
        this.fullName = name;
        this.socket = socket;
        this.connectTime = System.currentTimeMillis();
    }

    public InetConnection(String name, String host, int port) {
        this.isServerConnection = false;
        this.name = name;
        this.fullName = name;
        this.remoteHost = host;
        this.remotePort = port;
        this.connectTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.fullName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException();
        }
        this.fullName = userName + '@' + this.name;
        this.userName = userName;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public boolean isServerConnection() {
        return this.isServerConnection;
    }

    public boolean isDeliveryBuffered() {
        return this.isDeliveryBuffered;
    }

    public void setDeliveryBuffered(boolean isDeliveryBuffered) {
        if (isDeliveryBuffered && this.inBuffer == null) {
            this.inBuffer = new ArrayQueue();
        }
        this.isDeliveryBuffered = isDeliveryBuffered;
    }

    public boolean isWriteBuffered() {
        return this.isWriteBuffered;
    }

    public void setWriteBuffered(boolean isWriteBuffered) {
        if (isWriteBuffered && this.outBuffer == null) {
            this.outBuffer = new ArrayQueue();
        }
        this.isWriteBuffered = isWriteBuffered;
    }

    public ThreadPool getThreadPool() {
        ThreadPool pool = this.threadPool;
        if (pool == null) {
            pool = this.threadPool = ThreadPool.getDefaultThreadPool();
        }
        return pool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public final void start() throws IOException {
        if (this.input != null) {
            return;
        }
        if (this.socket != null) {
            InetAddress remoteAddress = this.socket.getInetAddress();
            this.remoteHost = remoteAddress.getHostAddress();
            this.remotePort = this.socket.getPort();
        } else {
            this.socket = new Socket(this.remoteHost, this.remotePort);
        }
        this.input = this.socket.getInputStream();
        this.output = this.socket.getOutputStream();
        this.isClosed = false;
        this.isOpen = true;
        this.messageReader = new MessageReader(this.name, this);
        this.connectionOpened();
        this.messageReader.start();
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.sendMessage(CLOSE_MESSAGE);
        }
    }

    public void closeImmediately() {
        this.closeImmediately(true);
    }

    private void closeImmediately(boolean useThread) {
        if (!this.isClosed) {
            this.isOpen = false;
            this.isClosed = true;
            if (useThread) {
                this.getThreadPool().invokeLater(new ConnectionCloser(this));
            } else {
                this.doClose();
            }
        }
    }

    private void doClose() {
        log.finest(this.fullName + ": connection closed from " + this.remoteHost);
        this.messageReader.interrupt();
        try {
            this.connectionClosed();
        }
        catch (Exception e) {
            log.log(Level.WARNING, this.fullName + ": failed to close connection", e);
        }
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Object message) {
        block11: {
            if (this.isWriteBuffered) {
                ArrayQueue arrayQueue = this.outBuffer;
                synchronized (arrayQueue) {
                    this.outBuffer.add(message);
                    if (!this.writerRunning) {
                        if (this.messageWriter == null) {
                            this.messageWriter = new MessageWriter(this);
                        }
                        this.writerRunning = true;
                        this.getThreadPool().invokeLater(this.messageWriter);
                    } else {
                        this.outBuffer.notify();
                    }
                }
            }
            if (message == CLOSE_MESSAGE) {
                this.closeImmediately();
            } else {
                try {
                    this.doSendMessage(message);
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, this.fullName + ": could not send " + message, e);
                    this.closeImmediately();
                    if (!(e instanceof ThreadDeath)) break block11;
                    throw (ThreadDeath)e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverMessage(Object message) {
        if (this.isDeliveryBuffered) {
            ArrayQueue arrayQueue = this.inBuffer;
            synchronized (arrayQueue) {
                this.inBuffer.add(message);
                if (!this.delivererRunning) {
                    if (this.messageDeliverer == null) {
                        this.messageDeliverer = new MessageDeliverer(this);
                    }
                    this.delivererRunning = true;
                    this.getThreadPool().invokeLater(this.messageDeliverer);
                } else {
                    this.inBuffer.notify();
                }
            }
        } else {
            this.doDeliverMessage(message);
        }
    }

    protected abstract void connectionOpened() throws IOException;

    protected abstract void connectionClosed() throws IOException;

    protected abstract void doReadMessages() throws IOException;

    protected abstract void doDeliverMessage(Object var1);

    protected abstract void doSendMessage(Object var1) throws IOException;

    private static class ConnectionCloser
    implements Runnable {
        private final InetConnection connection;

        public ConnectionCloser(InetConnection connection) {
            this.connection = connection;
        }

        public void run() {
            this.connection.doClose();
        }

        public String toString() {
            return "ConnectionCloser[" + this.connection.fullName + ',' + this.connection.remoteHost + ']';
        }
    }

    private static class MessageDeliverer
    implements Runnable {
        private final InetConnection connection;

        public MessageDeliverer(InetConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object message = null;
            boolean ok = false;
            JobStatus jobStatus = ThreadPool.getJobStatus();
            ArrayQueue inBuffer = this.connection.inBuffer;
            try {
                try {}
                catch (Throwable e) {
                    log.log(Level.SEVERE, this.connection.fullName + ": could not deliver " + message, e);
                    Object var9_9 = null;
                    if (ok) return;
                    ArrayQueue arrayQueue = inBuffer;
                    // MONITORENTER : arrayQueue
                    if (!inBuffer.isEmpty()) {
                        log.warning("reinvoking deliverer for " + this.connection.fullName);
                        this.connection.getThreadPool().invokeLater(this);
                        return;
                    }
                    log.warning("deliverer for " + this.connection.fullName + " exiting");
                    this.connection.delivererRunning = false;
                    // MONITOREXIT : arrayQueue
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (ok) throw throwable;
                ArrayQueue arrayQueue = inBuffer;
                // MONITORENTER : arrayQueue
                if (!inBuffer.isEmpty()) {
                    log.warning("reinvoking deliverer for " + this.connection.fullName);
                    this.connection.getThreadPool().invokeLater(this);
                    throw throwable;
                }
                log.warning("deliverer for " + this.connection.fullName + " exiting");
                this.connection.delivererRunning = false;
                // MONITOREXIT : arrayQueue
                throw throwable;
            }
            while (true) {
                block20: {
                    block21: {
                        block19: {
                            ArrayQueue arrayQueue = inBuffer;
                            // MONITORENTER : arrayQueue
                            if (inBuffer.isEmpty()) {
                                try {
                                    inBuffer.wait(800L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (inBuffer.isEmpty()) break block19;
                            message = inBuffer.remove(0);
                            // MONITOREXIT : arrayQueue
                            if (jobStatus == null) break block20;
                            break block21;
                        }
                        this.connection.delivererRunning = false;
                        ok = true;
                        // MONITOREXIT : arrayQueue
                        Object var9_8 = null;
                        if (ok) return;
                        ArrayQueue arrayQueue = inBuffer;
                        // MONITORENTER : arrayQueue
                        if (!inBuffer.isEmpty()) {
                            log.warning("reinvoking deliverer for " + this.connection.fullName);
                            this.connection.getThreadPool().invokeLater(this);
                            return;
                        }
                        log.warning("deliverer for " + this.connection.fullName + " exiting");
                        this.connection.delivererRunning = false;
                        // MONITOREXIT : arrayQueue
                        return;
                    }
                    jobStatus.stillAlive();
                }
                this.connection.doDeliverMessage(message);
            }
        }

        public String toString() {
            return "MessageDeliverer[" + this.connection.fullName + ',' + this.connection.inBuffer.size() + ',' + this.connection.remoteHost + ']';
        }
    }

    private static class MessageReader
    extends Thread {
        private final InetConnection connection;

        MessageReader(String name, InetConnection connection) {
            super(name);
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.connection.doReadMessages();
                }
                catch (Throwable e) {
                    if (this.connection.isOpen) {
                        log.log(Level.SEVERE, this.connection.fullName + ": message reader error", e);
                    }
                    Object var3_2 = null;
                    if (!this.connection.isOpen) return;
                    log.warning(this.connection.fullName + ": connection closed");
                    this.connection.closeImmediately(false);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (!this.connection.isOpen) throw throwable;
                log.warning(this.connection.fullName + ": connection closed");
                this.connection.closeImmediately(false);
                throw throwable;
            }
            if (!this.connection.isOpen) return;
            log.warning(this.connection.fullName + ": connection closed");
            this.connection.closeImmediately(false);
        }
    }

    private static class MessageWriter
    implements Runnable {
        private final InetConnection connection;

        MessageWriter(InetConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object message = null;
            boolean ok = false;
            JobStatus jobStatus = ThreadPool.getJobStatus();
            ArrayQueue outBuffer = this.connection.outBuffer;
            try {
                try {}
                catch (Throwable e) {
                    log.log(Level.SEVERE, this.connection.fullName + ": could not send " + message, e);
                    this.connection.closeImmediately(false);
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Object var9_10 = null;
                    if (ok) return;
                    ArrayQueue arrayQueue = this.connection.outBuffer;
                    // MONITORENTER : arrayQueue
                    if (!outBuffer.isEmpty() && !this.connection.isClosed) {
                        log.warning("reinvoking writer for " + this.connection.fullName);
                        this.connection.getThreadPool().invokeLater(this);
                        return;
                    }
                    log.warning("writer for " + this.connection.fullName + " exiting");
                    this.connection.writerRunning = false;
                    // MONITOREXIT : arrayQueue
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ok) throw throwable;
                ArrayQueue arrayQueue = this.connection.outBuffer;
                // MONITORENTER : arrayQueue
                if (!outBuffer.isEmpty() && !this.connection.isClosed) {
                    log.warning("reinvoking writer for " + this.connection.fullName);
                    this.connection.getThreadPool().invokeLater(this);
                    throw throwable;
                }
                log.warning("writer for " + this.connection.fullName + " exiting");
                this.connection.writerRunning = false;
                // MONITOREXIT : arrayQueue
                throw throwable;
            }
            while (!this.connection.isClosed) {
                block24: {
                    block25: {
                        block23: {
                            ArrayQueue arrayQueue = outBuffer;
                            // MONITORENTER : arrayQueue
                            if (outBuffer.isEmpty()) {
                                try {
                                    outBuffer.wait(800L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (outBuffer.isEmpty()) break block23;
                            message = outBuffer.remove(0);
                            // MONITOREXIT : arrayQueue
                            if (message != CLOSE_MESSAGE) break block24;
                            break block25;
                        }
                        this.connection.writerRunning = false;
                        ok = true;
                        // MONITOREXIT : arrayQueue
                        Object var9_8 = null;
                        if (ok) return;
                        ArrayQueue arrayQueue = this.connection.outBuffer;
                        // MONITORENTER : arrayQueue
                        if (!outBuffer.isEmpty() && !this.connection.isClosed) {
                            log.warning("reinvoking writer for " + this.connection.fullName);
                            this.connection.getThreadPool().invokeLater(this);
                            return;
                        }
                        log.warning("writer for " + this.connection.fullName + " exiting");
                        this.connection.writerRunning = false;
                        // MONITOREXIT : arrayQueue
                        return;
                    }
                    this.connection.closeImmediately(false);
                    break;
                }
                if (jobStatus != null) {
                    jobStatus.stillAlive();
                }
                this.connection.doSendMessage(message);
            }
            ok = true;
            Object var9_9 = null;
            if (ok) return;
            ArrayQueue arrayQueue = this.connection.outBuffer;
            // MONITORENTER : arrayQueue
            if (!outBuffer.isEmpty() && !this.connection.isClosed) {
                log.warning("reinvoking writer for " + this.connection.fullName);
                this.connection.getThreadPool().invokeLater(this);
                return;
            }
            log.warning("writer for " + this.connection.fullName + " exiting");
            this.connection.writerRunning = false;
            // MONITOREXIT : arrayQueue
        }

        public String toString() {
            return "MessageWriter[" + this.connection.fullName + ',' + this.connection.outBuffer.size() + ',' + this.connection.remoteHost + ']';
        }
    }
}

