/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.db.sql;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sics.isl.db.DBField;
import se.sics.isl.db.DBResult;
import se.sics.isl.db.sql.SQLDBTable;

public class SQLDBResult
extends DBResult {
    private static final Logger log = Logger.getLogger(SQLDBResult.class.getName());
    private SQLDBTable table;
    private Statement stm;
    private ResultSet rs;

    public SQLDBResult(SQLDBTable table, Statement stm, ResultSet rs) {
        this.table = table;
        this.stm = stm;
        this.rs = rs;
    }

    public int getFieldCount() {
        return this.table.getFieldCount();
    }

    public DBField getField(int index) {
        return this.table.getField(index);
    }

    public int getInt(String name) {
        try {
            return this.rs.getInt(name);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not getInt " + name, e);
            return 0;
        }
    }

    public long getLong(String name) {
        try {
            return this.rs.getLong(name);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not getLong " + name, e);
            return 0L;
        }
    }

    public double getDouble(String name) {
        try {
            return this.rs.getDouble(name);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not getDouble " + name, e);
            return 0.0;
        }
    }

    public String getString(String name) {
        try {
            return this.rs.getString(name);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not getString " + name, e);
            return null;
        }
    }

    public Object getObject(String name) {
        try {
            return this.rs.getObject(name);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not getObject " + name, e);
            return null;
        }
    }

    public long getTimestamp(String name) {
        try {
            Timestamp ts = this.rs.getTimestamp(name);
            return ts != null ? ts.getTime() : 0L;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not getTimestamp " + name, e);
            return 0L;
        }
    }

    public boolean next() {
        boolean hasNext = false;
        try {
            hasNext = this.rs.next();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "could not next", e);
        }
        return hasNext;
    }

    public void close() {
        try {
            this.rs.close();
            this.stm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

