/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.db.file;

import com.botbox.util.ArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sics.isl.db.DBField;
import se.sics.isl.db.DBMatcher;
import se.sics.isl.db.DBObject;
import se.sics.isl.db.DBResult;
import se.sics.isl.db.DBTable;
import se.sics.isl.db.file.DoubleField;
import se.sics.isl.db.file.FileDBField;
import se.sics.isl.db.file.FileDBResult;
import se.sics.isl.db.file.FileDatabase;
import se.sics.isl.db.file.IntField;
import se.sics.isl.db.file.LongField;
import se.sics.isl.db.file.NameFilter;
import se.sics.isl.db.file.ObjectField;

public class FileDBTable
extends DBTable {
    private static final String BAK_EXT = ".~1~";
    private static final Logger log = Logger.getLogger(FileDBTable.class.getName());
    protected final FileDatabase database;
    private final String fileFields;
    private final String fileObjects;
    private FileDBField[] fields;
    private int fieldNumber = 0;
    private int objectNumber = 0;
    private boolean dirtyFields = false;
    private boolean dirtyObjects = false;
    private boolean isDropped = false;
    private boolean objectsLoaded = false;
    private boolean exists = false;
    private int changeCount = 0;

    protected FileDBTable(FileDatabase database, String name, boolean create) {
        super(name);
        this.database = database;
        File root = database.getDatabaseRoot();
        this.fileFields = new File(root, name + ".db").getAbsolutePath();
        this.fileObjects = new File(root, name + ".dat").getAbsolutePath();
        if (!create) {
            this.loadFields();
        } else {
            this.objectsLoaded = true;
        }
    }

    boolean exists() {
        return this.exists;
    }

    public boolean hasField(String name) {
        return DBField.indexOf(this.fields, 0, this.fieldNumber, name) >= 0;
    }

    public DBField createField(String name, int type, int size, int flags, Object defaultValue) {
        if (this.isDropped) {
            throw new IllegalStateException("table " + this.name + " has been dropped");
        }
        if (DBField.indexOf(this.fields, 0, this.fieldNumber, name) >= 0) {
            throw new IllegalArgumentException("field already exists");
        }
        this.database.validateName(name);
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        FileDBField field = this.newField(name, type, size, flags, defaultValue);
        if (this.objectNumber > 0) {
            field.ensureCapacity(this.objectNumber);
        }
        if (this.fields == null) {
            this.fields = new FileDBField[5];
        } else if (this.fields.length == this.fieldNumber) {
            this.fields = (FileDBField[])ArrayUtils.setSize(this.fields, this.fieldNumber + 5);
        }
        this.fields[this.fieldNumber++] = field;
        this.dirtyFields = true;
        ++this.changeCount;
        return field;
    }

    private FileDBField newField(String name, int type, int size, int flags, Object defaultValue) {
        switch (type) {
            case 0: {
                return new IntField(this, name, type, size, flags, defaultValue);
            }
            case 1: 
            case 2: {
                return new LongField(this, name, type, size, flags, defaultValue);
            }
            case 3: {
                return new DoubleField(this, name, type, size, flags, defaultValue);
            }
            case 4: 
            case 5: {
                return new ObjectField(this, name, type, size, flags, defaultValue);
            }
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    public void drop() {
        if (this.dropTable()) {
            log.finest(this.name + ": table dropped");
            this.database.tableDropped(this);
            File[] files = this.database.getDatabaseRoot().listFiles(new NameFilter(this.name));
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                files[i].delete();
            }
        }
    }

    protected boolean dropTable() {
        if (this.isDropped) {
            return false;
        }
        this.isDropped = true;
        this.objectNumber = 0;
        this.fieldNumber = 0;
        this.dirtyObjects = false;
        this.dirtyFields = false;
        this.exists = false;
        this.fields = null;
        return true;
    }

    public int getFieldCount() {
        return this.fieldNumber;
    }

    public DBField getField(int index) {
        if (index >= this.fieldNumber) {
            throw new IndexOutOfBoundsException("index=" + index + ",size=" + this.fieldNumber);
        }
        return this.fields[index];
    }

    public int getObjectCount() {
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        return this.objectNumber;
    }

    public void insert(DBObject object) throws NumberFormatException {
        int i;
        if (this.isDropped) {
            throw new IllegalStateException("table " + this.name + " has been dropped");
        }
        this.validate(object);
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        int n = this.fieldNumber;
        for (i = 0; i < n; ++i) {
            FileDBField field = this.fields[i];
            field.prepareSet(this.objectNumber, object.getObject(field.getName()));
        }
        n = this.fieldNumber;
        for (i = 0; i < n; ++i) {
            this.fields[i].set();
        }
        ++this.objectNumber;
        this.dirtyObjects = true;
        ++this.changeCount;
    }

    public int update(DBMatcher matcher, DBObject object) {
        if (this.isDropped) {
            throw new IllegalStateException("table " + this.name + " has been dropped");
        }
        this.validate(object);
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        FileDBResult result = (FileDBResult)this.select(matcher);
        int objectsChanged = 0;
        while (result.next()) {
            int i;
            int lastIndex = result.getLastIndex();
            int n = this.fieldNumber;
            for (i = 0; i < n; ++i) {
                FileDBField field = this.fields[i];
                Object v = object.getObject(field.getName());
                if (v == null) continue;
                field.prepareSet(lastIndex, v);
            }
            n = this.fieldNumber;
            for (i = 0; i < n; ++i) {
                this.fields[i].set();
            }
            this.dirtyObjects = true;
            ++this.changeCount;
            ++objectsChanged;
            result.setChangeID(this.changeCount);
        }
        return objectsChanged;
    }

    public int remove(DBMatcher matcher) {
        if (this.isDropped) {
            throw new IllegalStateException("table " + this.name + " has been dropped");
        }
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        FileDBResult result = (FileDBResult)this.select(matcher);
        int objectsRemoved = 0;
        while (result.next()) {
            int lastIndex = result.getLastIndex();
            if (lastIndex + 1 < this.objectNumber) {
                int n = this.fieldNumber;
                for (int i = 0; i < n; ++i) {
                    this.fields[i].remove(lastIndex);
                }
                result.setLastIndex(lastIndex - 1);
            }
            this.dirtyObjects = true;
            ++this.changeCount;
            --this.objectNumber;
            ++objectsRemoved;
            result.setChangeID(this.changeCount);
        }
        return objectsRemoved;
    }

    public DBResult select() {
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        return new FileDBResult(null, this, null, null);
    }

    public DBResult select(DBMatcher matcher) {
        Object[] matchValues;
        int[] fieldIndex;
        int matchNumber;
        if (matcher == null) {
            return this.select();
        }
        if (!this.objectsLoaded) {
            this.loadObjects();
        }
        if ((matchNumber = matcher.getFieldCount()) == 0) {
            fieldIndex = null;
            matchValues = null;
        } else {
            fieldIndex = new int[matchNumber];
            matchValues = new Object[matchNumber];
            for (int i = 0; i < matchNumber; ++i) {
                String fname = matcher.getFieldName(i);
                fieldIndex[i] = DBField.indexOf(this.fields, 0, this.fieldNumber, fname);
                if (fieldIndex[i] < 0) {
                    throw new IllegalArgumentException("unknown field '" + fname + '\'');
                }
                matchValues[i] = matcher.getObject(fname);
            }
        }
        return new FileDBResult(matcher, this, fieldIndex, matchValues);
    }

    public void flush() {
        if (this.dirtyFields) {
            this.saveFields();
            if (this.objectNumber > 0) {
                this.saveObjects();
            }
        }
        if (this.dirtyObjects) {
            this.saveObjects();
        }
    }

    private void validate(DBObject object) {
        int n = object.getFieldCount();
        for (int i = 0; i < n; ++i) {
            if (DBField.indexOf(this.fields, 0, this.fieldNumber, object.getFieldName(i)) >= 0) continue;
            throw new IllegalArgumentException("unknown field '" + object.getFieldName(i) + '\'');
        }
    }

    int getChangeCount() {
        return this.changeCount;
    }

    FileDBField getField(String name) {
        int index = DBField.indexOf(this.fields, 0, this.fieldNumber, name);
        if (index >= 0) {
            return this.fields[index];
        }
        throw new IllegalArgumentException("unknown field '" + name + '\'');
    }

    int next(int[] fieldIndex, Object[] matchValues, int lastIndex) {
        int startIndex;
        lastIndex = lastIndex < 0 ? 0 : ++lastIndex;
        if (lastIndex >= this.objectNumber) {
            return this.objectNumber;
        }
        if (fieldIndex == null) {
            return lastIndex;
        }
        if (this.fieldNumber == 0) {
            return this.objectNumber;
        }
        int endIndex = lastIndex;
        int matchNumber = fieldIndex.length;
        do {
            if ((endIndex = (startIndex = this.fields[fieldIndex[0]].indexOf(matchValues[0], endIndex, this.objectNumber))) < 0) {
                return this.objectNumber;
            }
            for (int i = 1; i < matchNumber; ++i) {
                if ((endIndex = this.fields[fieldIndex[i]].indexOf(matchValues[i], endIndex, this.objectNumber)) >= 0) continue;
                return this.objectNumber;
            }
        } while (endIndex > startIndex);
        return endIndex;
    }

    protected void loadFields() {
        this.loadState(this.fileFields, true);
    }

    protected void saveFields() {
        this.saveState(this.fileFields);
    }

    protected void loadObjects() {
        this.objectsLoaded = true;
        this.loadState(this.fileObjects, true);
    }

    protected void saveObjects() {
        this.saveState(this.fileObjects);
    }

    private void loadState(String name, boolean revert) {
        block3: {
            try {
                InputStream in = this.getInputStream(name);
                this.loadState(name, in);
                this.exists = true;
            }
            catch (FileNotFoundException e) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, this.name + ": could not load data from " + name, e);
                this.exists = true;
                if (!revert || !this.revertFile(name)) break block3;
                this.loadState(name, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState(String name, InputStream in) throws ClassNotFoundException, IOException {
        ObjectInputStream oin = null;
        try {
            oin = new ObjectInputStream(in);
            if (name == this.fileFields) {
                int number = oin.readInt();
                FileDBField[] fields = new FileDBField[number];
                for (int i = 0; i < number; ++i) {
                    int type = oin.readInt();
                    int size = oin.readInt();
                    int flags = oin.readInt();
                    String fieldName = (String)oin.readObject();
                    Object defaultValue = oin.readObject();
                    fields[i] = this.newField(fieldName, type, size, flags, defaultValue);
                }
                this.fields = fields;
                this.fieldNumber = number;
            } else {
                int number = oin.readInt();
                for (int i = 0; i < this.fieldNumber; ++i) {
                    this.fields[i].loadState(oin, number);
                }
                this.objectNumber = number;
            }
        }
        finally {
            if (oin != null) {
                oin.close();
            } else {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(String name) {
        OutputStream out = null;
        ObjectOutputStream oout = null;
        try {
            out = this.getOutputStream(name);
            oout = new ObjectOutputStream(out);
            if (name == this.fileObjects) {
                this.dirtyObjects = false;
                oout.writeInt(this.objectNumber);
                for (int i = 0; i < this.fieldNumber; ++i) {
                    this.fields[i].saveState(oout);
                }
            } else {
                this.dirtyFields = false;
                oout.writeInt(this.fieldNumber);
                for (int i = 0; i < this.fieldNumber; ++i) {
                    FileDBField field = this.fields[i];
                    Object defaultValue = field.getDefaultValue();
                    oout.writeInt(field.getType());
                    oout.writeInt(field.getSize());
                    oout.writeInt(field.getFlags());
                    oout.writeObject(field.getName());
                    oout.writeObject(defaultValue == null ? null : defaultValue.toString());
                }
                this.exists = true;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, this.name + ": could not save data to " + name, e);
            if (name == this.fileObjects) {
                this.dirtyObjects = true;
            } else {
                this.dirtyFields = true;
            }
        }
        finally {
            try {
                if (oout != null) {
                    oout.close();
                } else if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private InputStream getInputStream(String filename) throws IOException {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            String bakName = filename + BAK_EXT;
            if (new File(bakName).renameTo(new File(filename))) {
                return new FileInputStream(filename);
            }
            throw e;
        }
    }

    private OutputStream getOutputStream(String filename) throws IOException {
        String bakName = filename + BAK_EXT;
        File fp = new File(filename);
        if (fp.exists()) {
            File bakFp = new File(bakName);
            bakFp.delete();
            fp.renameTo(bakFp);
        }
        return new FileOutputStream(filename);
    }

    private boolean revertFile(String name) {
        File bakFp = new File(name + BAK_EXT);
        File fp = new File(name);
        if (fp.exists() && !fp.delete()) {
            log.severe(this.name + ": could not remove old file " + fp + " when reverting (will retry)" + bakFp);
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Runtime.getRuntime().gc();
            if (!fp.delete()) {
                log.severe(this.name + ": could not remove old file " + fp + " when reverting " + bakFp);
                int nr = 1;
                File rFp = new File(name + ".~" + ++nr + '~');
                while (rFp.exists() && !rFp.delete() && ++nr < 10) {
                    log.severe(this.name + ": could not remove old removed file " + rFp + " when reverting attribute");
                    rFp = new File(name + ".~" + nr + '~');
                }
                if (!fp.renameTo(rFp)) {
                    log.severe(this.name + ": could not rename old file " + fp + " to " + rFp + " when reverting");
                }
            }
        }
        return bakFp.renameTo(fp);
    }
}

