/*
 * Decompiled with CFR 0.152.
 */
package se.raek.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import se.raek.charset.NonAsciiByteDecoder;

public final class Utf8WithFallbackCharsetDecoder
extends CharsetDecoder {
    private final NonAsciiByteDecoder byteDecoder;
    private boolean lookaheadRead;
    private byte lookahead;
    private State state;

    private byte peek(ByteBuffer in) {
        if (!this.lookaheadRead) {
            this.lookahead = in.get();
            this.lookaheadRead = true;
        }
        return this.lookahead;
    }

    private byte take(ByteBuffer in) {
        if (this.lookaheadRead) {
            this.lookaheadRead = false;
            return this.lookahead;
        }
        return in.get();
    }

    public Utf8WithFallbackCharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte, NonAsciiByteDecoder byteDecoder) {
        super(cs, averageCharsPerByte, maxCharsPerByte);
        this.byteDecoder = byteDecoder;
        this.implReset();
    }

    @Override
    protected void implReset() {
        this.lookaheadRead = false;
        this.state = new Start();
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (this.lookaheadRead || in.hasRemaining()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            this.state = this.state.next(in, out);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        this.state = this.state.flush();
        while (!this.state.isFinal()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            this.state = this.state.next(null, out);
        }
        return CoderResult.UNDERFLOW;
    }

    private char decodeFallback(byte b) {
        return this.byteDecoder.decodeByte(b);
    }

    private static boolean isAscii(byte b) {
        return (b & 0x80) == 0;
    }

    private static char decodeAscii(byte b) {
        return (char)b;
    }

    private static boolean isContinuation(byte b) {
        return (b & 0xC0) == 128;
    }

    private static int continuationData(byte b) {
        return b & 0x3F;
    }

    private static int addContinuationData(int value, byte b) {
        return (value << 6) + Utf8WithFallbackCharsetDecoder.continuationData(b);
    }

    private static boolean isTwoByteStart(byte b) {
        return (b & 0xE0) == 192;
    }

    private static int twoByteStartData(byte b) {
        return b & 0x1F;
    }

    private static boolean isThreeByteStart(byte b) {
        return (b & 0xF0) == 224;
    }

    private static int threeByteStartData(byte b) {
        return b & 0xF;
    }

    private static boolean isFourByteStart(byte b) {
        return (b & 0xF8) == 240;
    }

    private static int fourByteStartData(byte b) {
        return b & 7;
    }

    private static int bytesRequired(int codePoint) {
        if (codePoint < 128 && codePoint >= 0) {
            return 1;
        }
        if (codePoint < 2048) {
            return 2;
        }
        if (codePoint < 65536) {
            return 3;
        }
        if (codePoint < 0x110000) {
            return 4;
        }
        return -1;
    }

    private final class FlushBytes
    implements State {
        private ByteBuffer buffer;

        public FlushBytes(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public State next(ByteBuffer in, CharBuffer out) {
            out.put(Utf8WithFallbackCharsetDecoder.this.decodeFallback(this.buffer.get()));
            if (this.buffer.hasRemaining()) {
                return this;
            }
            return new Start();
        }

        @Override
        public State flush() {
            return this;
        }
    }

    private final class FlushSurrogate
    implements State {
        private char c;

        public FlushSurrogate(char c) {
            this.c = c;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public State next(ByteBuffer in, CharBuffer out) {
            out.put(this.c);
            return new Start();
        }

        @Override
        public State flush() {
            return this;
        }
    }

    private final class Partial
    implements State {
        private ByteBuffer buffer;
        private int value;

        public Partial(byte start) {
            int length;
            if (Utf8WithFallbackCharsetDecoder.isTwoByteStart(start)) {
                length = 2;
                this.value = Utf8WithFallbackCharsetDecoder.twoByteStartData(start);
            } else if (Utf8WithFallbackCharsetDecoder.isThreeByteStart(start)) {
                length = 3;
                this.value = Utf8WithFallbackCharsetDecoder.threeByteStartData(start);
            } else if (Utf8WithFallbackCharsetDecoder.isFourByteStart(start)) {
                length = 4;
                this.value = Utf8WithFallbackCharsetDecoder.fourByteStartData(start);
            } else {
                length = -1;
                assert (false);
            }
            this.buffer = ByteBuffer.allocateDirect(length);
            this.buffer.put(start);
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public State next(ByteBuffer in, CharBuffer out) {
            if (!Utf8WithFallbackCharsetDecoder.isContinuation(Utf8WithFallbackCharsetDecoder.this.peek(in))) {
                this.buffer.flip();
                return new FlushBytes(this.buffer);
            }
            byte b = Utf8WithFallbackCharsetDecoder.this.take(in);
            this.buffer.put(b);
            this.value = Utf8WithFallbackCharsetDecoder.addContinuationData(this.value, b);
            if (this.buffer.hasRemaining()) {
                return this;
            }
            int requiredLength = Utf8WithFallbackCharsetDecoder.bytesRequired(this.value);
            if (requiredLength == -1 || this.buffer.capacity() != requiredLength) {
                this.buffer.flip();
                return new FlushBytes(this.buffer);
            }
            char[] chars = Character.toChars(this.value);
            out.put(chars[0]);
            if (chars.length == 2) {
                return new FlushSurrogate(chars[1]);
            }
            return new Start();
        }

        @Override
        public State flush() {
            this.buffer.flip();
            return new FlushBytes(this.buffer);
        }
    }

    private class Start
    implements State {
        private Start() {
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public State next(ByteBuffer in, CharBuffer out) {
            byte b = Utf8WithFallbackCharsetDecoder.this.take(in);
            if (Utf8WithFallbackCharsetDecoder.isAscii(b)) {
                out.put(Utf8WithFallbackCharsetDecoder.decodeAscii(b));
                return this;
            }
            if (Utf8WithFallbackCharsetDecoder.isTwoByteStart(b)) {
                return new Partial(b);
            }
            if (Utf8WithFallbackCharsetDecoder.isThreeByteStart(b)) {
                return new Partial(b);
            }
            if (Utf8WithFallbackCharsetDecoder.isFourByteStart(b)) {
                return new Partial(b);
            }
            out.put(Utf8WithFallbackCharsetDecoder.this.decodeFallback(b));
            return this;
        }

        @Override
        public State flush() {
            return this;
        }
    }

    private static interface State {
        public boolean isFinal();

        public State next(ByteBuffer var1, CharBuffer var2);

        public State flush();
    }
}

