/*
 * Decompiled with CFR 0.152.
 */
package se.fishtank.css.selectors.dom.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.Selector;
import se.fishtank.css.selectors.dom.DOMHelper;
import se.fishtank.css.selectors.dom.internal.NodeTraversalChecker;
import se.fishtank.css.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagChecker
extends NodeTraversalChecker {
    private final Selector selector;
    private Set<Node> nodes;
    private Set<Node> result;

    public TagChecker(Selector selector) {
        Assert.notNull(selector, "selector is null!");
        this.selector = selector;
    }

    @Override
    public Set<Node> check(Set<Node> nodes, Node root) throws NodeSelectorException {
        Assert.notNull(nodes, "nodes is null!");
        this.nodes = nodes;
        this.result = new LinkedHashSet<Node>();
        switch (this.selector.getCombinator()) {
            case DESCENDANT: {
                this.addDescentantElements();
                break;
            }
            case CHILD: {
                this.addChildElements();
                break;
            }
            case ADJACENT_SIBLING: {
                this.addAdjacentSiblingElements();
                break;
            }
            case GENERAL_SIBLING: {
                this.addGeneralSiblingElements();
            }
        }
        return this.result;
    }

    private void addDescentantElements() throws NodeSelectorException {
        for (Node node : this.nodes) {
            NodeList nl;
            if (node.getNodeType() == 9) {
                nl = ((Document)node).getElementsByTagName(this.selector.getTagName());
            } else if (node.getNodeType() == 1) {
                nl = ((Element)node).getElementsByTagName(this.selector.getTagName());
            } else {
                throw new NodeSelectorException("Only document and element nodes allowed!");
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                this.result.add(nl.item(i));
            }
        }
    }

    private void addChildElements() {
        for (Node node : this.nodes) {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                String tag;
                node = nl.item(i);
                if (node.getNodeType() != 1 || !(tag = this.selector.getTagName()).equals(node.getNodeName()) && !tag.equals("*")) continue;
                this.result.add(node);
            }
        }
    }

    private void addAdjacentSiblingElements() {
        for (Node node : this.nodes) {
            String tag;
            Element n = DOMHelper.getNextSiblingElement(node);
            if (n == null || !(tag = this.selector.getTagName()).equals(n.getNodeName()) && !tag.equals("*")) continue;
            this.result.add(n);
        }
    }

    private void addGeneralSiblingElements() {
        for (Node node : this.nodes) {
            Element n = DOMHelper.getNextSiblingElement(node);
            while (n != null) {
                if (this.selector.getTagName().equals(n.getNodeName()) || this.selector.getTagName().equals("*")) {
                    this.result.add(n);
                }
                n = DOMHelper.getNextSiblingElement(n);
            }
        }
    }
}

