(ns leiningen.new.screen6
  (:require
   [leiningen.new.templates :refer [renderer
                                    name-to-path
                                    ->files
                                    sanitize-ns
                                    project-name]]
   [leiningen.core.main :as main]))

(def render (renderer "screen6"))

(defn screen6
  "Template for Screen6 Clojure projects"
  [name]
  (let [data {:name (project-name name)
              :sanitized (name-to-path name)
              :sanitized-ns (sanitize-ns name)}
        base-file (format "src/%s.clj" (name-to-path name))
        test-file (format "test/%s_test.clj" (name-to-path name))]
    (main/info "Generating fresh 'lein new' Screen6 project.")
    (->files data
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)]
             [base-file (render "base.clj" data)]
             [test-file (render "test.clj" data)])))
