(ns leiningen.new.screen6
  (:require
   [leiningen.new.templates :refer [renderer
                                    name-to-path
                                    ->files
                                    sanitize-ns]]
   [leiningen.core.main :as main]))

(def render (renderer "screen6"))

(defn screen6
  "Template for Screen6 Clojure projects"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              :sanitized-ns (sanitize-ns name)}]
    (main/info "Generating fresh 'lein new' Screen6 project.")
    (->files data
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)])))
