(ns tablecloth.column.api
  ;;Autogenerated from tablecloth.column.api.api-template-- DO NOT EDIT
  "Tablecloth Column API"
  (:require [tablecloth.column.api.api-template]
            [tablecloth.column.api.column]
            [tablecloth.column.api.missing]
            [tablecloth.column.api.operators]
            [tech.v3.dataset.column])
  (:refer-clojure :exclude [* + - / < <= >= > abs and bit-and bit-and-not bit-clear bit-flip bit-not bit-or bit-set bit-shift-left bit-shift-right bit-xor even? identity infinite? max min neg? not odd? or pos? quot rem unsigned-bit-shift-right zero?]))

(defn *
  ([x y]
  (tablecloth.column.api.operators/* x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/* x y args)))


(defn +
  ([x]
  (tablecloth.column.api.operators/+ x))
  ([x y]
  (tablecloth.column.api.operators/+ x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/+ x y args)))


(defn -
  ([x]
  (tablecloth.column.api.operators/- x))
  ([x y]
  (tablecloth.column.api.operators/- x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/- x y args)))


(defn /
  ([x]
  (tablecloth.column.api.operators// x))
  ([x y]
  (tablecloth.column.api.operators// x y))
  ([x y & args]
  (apply tablecloth.column.api.operators// x y args)))


(defn <
  ([x y z]
  (tablecloth.column.api.operators/< x y z))
  ([x y]
  (tablecloth.column.api.operators/< x y)))


(defn <=
  ([x y z]
  (tablecloth.column.api.operators/<= x y z))
  ([x y]
  (tablecloth.column.api.operators/<= x y)))


(defn >
  ([x y z]
  (tablecloth.column.api.operators/> x y z))
  ([x y]
  (tablecloth.column.api.operators/> x y)))


(defn >=
  ([x y z]
  (tablecloth.column.api.operators/>= x y z))
  ([x y]
  (tablecloth.column.api.operators/>= x y)))


(defn abs
  ([x options]
  (tablecloth.column.api.operators/abs x options))
  ([x]
  (tablecloth.column.api.operators/abs x)))


(defn acos
  ([x options]
  (tablecloth.column.api.operators/acos x options))
  ([x]
  (tablecloth.column.api.operators/acos x)))


(defn and
  ([x y]
  (tablecloth.column.api.operators/and x y)))


(defn asin
  ([x options]
  (tablecloth.column.api.operators/asin x options))
  ([x]
  (tablecloth.column.api.operators/asin x)))


(defn atan
  ([x options]
  (tablecloth.column.api.operators/atan x options))
  ([x]
  (tablecloth.column.api.operators/atan x)))


(defn atan2
  ([x y]
  (tablecloth.column.api.operators/atan2 x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/atan2 x y args)))


(defn bit-and
  ([x y]
  (tablecloth.column.api.operators/bit-and x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-and x y args)))


(defn bit-and-not
  ([x y]
  (tablecloth.column.api.operators/bit-and-not x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-and-not x y args)))


(defn bit-clear
  ([x y]
  (tablecloth.column.api.operators/bit-clear x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-clear x y args)))


(defn bit-flip
  ([x y]
  (tablecloth.column.api.operators/bit-flip x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-flip x y args)))


(defn bit-not
  ([x options]
  (tablecloth.column.api.operators/bit-not x options))
  ([x]
  (tablecloth.column.api.operators/bit-not x)))


(defn bit-or
  ([x y]
  (tablecloth.column.api.operators/bit-or x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-or x y args)))


(defn bit-set
  ([x y]
  (tablecloth.column.api.operators/bit-set x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-set x y args)))


(defn bit-shift-left
  ([x y]
  (tablecloth.column.api.operators/bit-shift-left x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-shift-left x y args)))


(defn bit-shift-right
  ([x y]
  (tablecloth.column.api.operators/bit-shift-right x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-shift-right x y args)))


(defn bit-xor
  ([x y]
  (tablecloth.column.api.operators/bit-xor x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/bit-xor x y args)))


(defn cbrt
  ([x options]
  (tablecloth.column.api.operators/cbrt x options))
  ([x]
  (tablecloth.column.api.operators/cbrt x)))


(defn ceil
  ([x options]
  (tablecloth.column.api.operators/ceil x options))
  ([x]
  (tablecloth.column.api.operators/ceil x)))


(defn column
  "Create a `column` from a vector or sequence. "
  ([]
  (tablecloth.column.api.column/column ))
  ([data]
  (tablecloth.column.api.column/column data))
  ([data options]
  (tablecloth.column.api.column/column data options)))


(defn column-map
  "Applies a map function `map-fn` to one or more columns. If `col` is
  a vector of columns, `map-fn` must have an arity equal to the number
  of columns. The datatype of the resulting column will be inferred,
  unless specified in the `options` map. Missing values can be handled
  by providing a `:missing-fn` in the options map.

  options:
  - :datatype   - The desired datatype of the resulting column. The datatype
                  is inferred if not provided
  - :missing-fn - A function that takes a sequence of columns, and returns a
                  set of missing index positions."
  ([col map-fn]
  (tablecloth.column.api.column/column-map col map-fn))
  ([col map-fn options]
  (tablecloth.column.api.column/column-map col map-fn options)))


(defn column?
  "Return true or false `item` is a column."
  ([item]
  (tablecloth.column.api.column/column? item)))


(defn cos
  ([x options]
  (tablecloth.column.api.operators/cos x options))
  ([x]
  (tablecloth.column.api.operators/cos x)))


(defn cosh
  ([x options]
  (tablecloth.column.api.operators/cosh x options))
  ([x]
  (tablecloth.column.api.operators/cosh x)))


(defn count-missing
  "Returns the number of missing values in column `col`. "
  ([col]
  (tablecloth.column.api.missing/count-missing col)))


(defn cummax
  "Cumulative running max; returns result in double space.

  Options:

  * `:nan-strategy` - one of `:keep`, `:remove`, `:exception`.  Defaults to `:remove`."
  ([x options]
  (tablecloth.column.api.operators/cummax x options))
  ([x]
  (tablecloth.column.api.operators/cummax x)))


(defn cummin
  "Cumulative running min; returns result in double space.

  Options:

  * `:nan-strategy` - one of `:keep`, `:remove`, `:exception`.  Defaults to `:remove`."
  ([x options]
  (tablecloth.column.api.operators/cummin x options))
  ([x]
  (tablecloth.column.api.operators/cummin x)))


(defn cumprod
  "Cumulative running product; returns result in double space.

  Options:

  * `:nan-strategy` - one of `:keep`, `:remove`, `:exception`.  Defaults to `:remove`."
  ([x options]
  (tablecloth.column.api.operators/cumprod x options))
  ([x]
  (tablecloth.column.api.operators/cumprod x)))


(defn cumsum
  "Cumulative running summation; returns result in double space.

  Options:

  * `:nan-strategy` - one of `:keep`, `:remove`, `:exception`.  Defaults to `:remove`."
  ([x options]
  (tablecloth.column.api.operators/cumsum x options))
  ([x]
  (tablecloth.column.api.operators/cumsum x)))


(defn descriptive-statistics
  "Calculate a set of descriptive statistics on a single reader.

  Available stats:
  #{:min :quartile-1 :sum :mean :mode :median :quartile-3 :max
    :variance :standard-deviation :skew :n-elems :kurtosis}

  options
    - `:nan-strategy` - defaults to :remove, one of
    [:keep :remove :exception]. The fastest option is :keep but this
    may result in your results having NaN's in them.  You can also pass
  in a double predicate to filter custom double values."
  ([x stats-names stats-data options]
  (tablecloth.column.api.operators/descriptive-statistics x stats-names stats-data options))
  ([x stats-names options]
  (tablecloth.column.api.operators/descriptive-statistics x stats-names options))
  ([x stats-names]
  (tablecloth.column.api.operators/descriptive-statistics x stats-names))
  ([x]
  (tablecloth.column.api.operators/descriptive-statistics x)))


(defn distance
  ([x y]
  (tablecloth.column.api.operators/distance x y)))


(defn distance-squared
  ([x y]
  (tablecloth.column.api.operators/distance-squared x y)))


(defn dot-product
  ([x y]
  (tablecloth.column.api.operators/dot-product x y)))


(defn drop-missing
  "Remove missing values from column `col`."
  ([col]
  (tablecloth.column.api.missing/drop-missing col)))


(defn eq
  ([x y]
  (tablecloth.column.api.operators/eq x y)))


(defn equals
  ([x y & args]
  (apply tablecloth.column.api.operators/equals x y args)))


(defn even?
  ([x options]
  (tablecloth.column.api.operators/even? x options))
  ([x]
  (tablecloth.column.api.operators/even? x)))


(defn exp
  ([x options]
  (tablecloth.column.api.operators/exp x options))
  ([x]
  (tablecloth.column.api.operators/exp x)))


(defn expm1
  ([x options]
  (tablecloth.column.api.operators/expm1 x options))
  ([x]
  (tablecloth.column.api.operators/expm1 x)))


(defn fill-range
  "Given a reader of numeric data and a max span amount, produce
  a new reader where the difference between any two consecutive elements
  is less than or equal to the max span amount.  Also return a bitmap of the added
  indexes.  Uses linear interpolation to fill in areas, operates in double space.
  Returns
  {:result :missing}"
  ([x max-span]
  (tablecloth.column.api.operators/fill-range x max-span)))


(defn finite?
  ([x options]
  (tablecloth.column.api.operators/finite? x options))
  ([x]
  (tablecloth.column.api.operators/finite? x)))


(defn floor
  ([x options]
  (tablecloth.column.api.operators/floor x options))
  ([x]
  (tablecloth.column.api.operators/floor x)))


(defn get-significand
  ([x options]
  (tablecloth.column.api.operators/get-significand x options))
  ([x]
  (tablecloth.column.api.operators/get-significand x)))


(defn hypot
  ([x y]
  (tablecloth.column.api.operators/hypot x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/hypot x y args)))


(defn identity
  ([x options]
  (tablecloth.column.api.operators/identity x options))
  ([x]
  (tablecloth.column.api.operators/identity x)))


(defn ieee-remainder
  ([x y]
  (tablecloth.column.api.operators/ieee-remainder x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/ieee-remainder x y args)))


(defn infinite?
  ([x options]
  (tablecloth.column.api.operators/infinite? x options))
  ([x]
  (tablecloth.column.api.operators/infinite? x)))


(defn is-missing?
  "Return true if this index is missing."
  ([col idx]
  (tech.v3.dataset.column/is-missing? col idx)))


(defn kendalls-correlation
  ([x y options]
  (tablecloth.column.api.operators/kendalls-correlation x y options))
  ([x y]
  (tablecloth.column.api.operators/kendalls-correlation x y)))


(defn kurtosis
  ([x options]
  (tablecloth.column.api.operators/kurtosis x options))
  ([x]
  (tablecloth.column.api.operators/kurtosis x)))


(defn log
  ([x options]
  (tablecloth.column.api.operators/log x options))
  ([x]
  (tablecloth.column.api.operators/log x)))


(defn log10
  ([x options]
  (tablecloth.column.api.operators/log10 x options))
  ([x]
  (tablecloth.column.api.operators/log10 x)))


(defn log1p
  ([x options]
  (tablecloth.column.api.operators/log1p x options))
  ([x]
  (tablecloth.column.api.operators/log1p x)))


(defn logistic
  ([x options]
  (tablecloth.column.api.operators/logistic x options))
  ([x]
  (tablecloth.column.api.operators/logistic x)))


(defn magnitude
  ([x]
  (tablecloth.column.api.operators/magnitude x)))


(defn magnitude-squared
  ([x]
  (tablecloth.column.api.operators/magnitude-squared x)))


(defn mathematical-integer?
  ([x options]
  (tablecloth.column.api.operators/mathematical-integer? x options))
  ([x]
  (tablecloth.column.api.operators/mathematical-integer? x)))


(defn max
  ([x]
  (tablecloth.column.api.operators/max x))
  ([x y]
  (tablecloth.column.api.operators/max x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/max x y args)))


(defn mean
  "double mean of x"
  ([x options]
  (tablecloth.column.api.operators/mean x options))
  ([x]
  (tablecloth.column.api.operators/mean x)))


(defn mean-fast
  "Take the mean of the x.  This operation doesn't know anything about nan hence it is
  a bit faster than the base [[mean]] fn."
  ([x]
  (tablecloth.column.api.operators/mean-fast x)))


(defn median
  ([x options]
  (tablecloth.column.api.operators/median x options))
  ([x]
  (tablecloth.column.api.operators/median x)))


(defn min
  ([x]
  (tablecloth.column.api.operators/min x))
  ([x y]
  (tablecloth.column.api.operators/min x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/min x y args)))


(defn missing
  "Indexes of missing values.  Both iterable and reader."
  (^{:tag org.roaringbitmap.RoaringBitmap} [col]
  (tech.v3.dataset.column/missing col)))


(defn nan?
  ([x options]
  (tablecloth.column.api.operators/nan? x options))
  ([x]
  (tablecloth.column.api.operators/nan? x)))


(defn neg?
  ([x options]
  (tablecloth.column.api.operators/neg? x options))
  ([x]
  (tablecloth.column.api.operators/neg? x)))


(defn next-down
  ([x options]
  (tablecloth.column.api.operators/next-down x options))
  ([x]
  (tablecloth.column.api.operators/next-down x)))


(defn next-up
  ([x options]
  (tablecloth.column.api.operators/next-up x options))
  ([x]
  (tablecloth.column.api.operators/next-up x)))


(defn normalize
  ([x]
  (tablecloth.column.api.operators/normalize x)))


(defn not
  ([x options]
  (tablecloth.column.api.operators/not x options))
  ([x]
  (tablecloth.column.api.operators/not x)))


(defn not-eq
  ([x y]
  (tablecloth.column.api.operators/not-eq x y)))


(defn odd?
  ([x options]
  (tablecloth.column.api.operators/odd? x options))
  ([x]
  (tablecloth.column.api.operators/odd? x)))


(defn ones
  "Creates a new column filled with `n-ones`"
  ([n-ones]
  (tablecloth.column.api.column/ones n-ones)))


(defn or
  ([x y]
  (tablecloth.column.api.operators/or x y)))


(defn pearsons-correlation
  ([x y options]
  (tablecloth.column.api.operators/pearsons-correlation x y options))
  ([x y]
  (tablecloth.column.api.operators/pearsons-correlation x y)))


(defn percentiles
  "Create a reader of percentile values, one for each percentage passed in.
  Estimation types are in the set of #{:r1,r2...legacy} and are described
  here: https://commons.apache.org/proper/commons-math/javadocs/api-3.3/index.html.

  nan-strategy can be one of [:keep :remove :exception] and defaults to :exception."
  ([x percentages options]
  (tablecloth.column.api.operators/percentiles x percentages options))
  ([x percentages]
  (tablecloth.column.api.operators/percentiles x percentages)))


(defn pos?
  ([x options]
  (tablecloth.column.api.operators/pos? x options))
  ([x]
  (tablecloth.column.api.operators/pos? x)))


(defn pow
  ([x y]
  (tablecloth.column.api.operators/pow x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/pow x y args)))


(defn quartile-1
  ([x options]
  (tablecloth.column.api.operators/quartile-1 x options))
  ([x]
  (tablecloth.column.api.operators/quartile-1 x)))


(defn quartile-3
  ([x options]
  (tablecloth.column.api.operators/quartile-3 x options))
  ([x]
  (tablecloth.column.api.operators/quartile-3 x)))


(defn quartiles
  "return [min, 25 50 75 max] of item"
  ([x]
  (tablecloth.column.api.operators/quartiles x))
  ([x options]
  (tablecloth.column.api.operators/quartiles x options)))


(defn quot
  ([x y]
  (tablecloth.column.api.operators/quot x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/quot x y args)))


(defn reduce-*
  ([x]
  (tablecloth.column.api.operators/reduce-* x)))


(defn reduce-+
  ([x]
  (tablecloth.column.api.operators/reduce-+ x)))


(defn reduce-max
  ([x]
  (tablecloth.column.api.operators/reduce-max x)))


(defn reduce-min
  ([x]
  (tablecloth.column.api.operators/reduce-min x)))


(defn rem
  ([x y]
  (tablecloth.column.api.operators/rem x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/rem x y args)))


(defn replace-missing
  "Replace missing values in column `col` with give `strategy`.

    Strategies may be:

    - `:down` -	Take the previous value, or use provided value.
    - `:up` - Take the next value, or use provided value.
    - `:downup` - Take the previous value, otherwise take the next value.
    - `:updown` - Take the next value, otherwise take the previous value.
    - `:nearest` - Use the nearest of next or previous values. (Strategy `:mid` is an alias for `:nearest`).
    - `:midpoint` - Use the midpoint of averaged values between previous and next (non-missing) values.
    - `:abb` - Impute missing value with approximate Bayesian bootstrap.
               See [r's ABB](https://search.r-project.org/CRAN/refmans/LaplacesDemon/html/ABB.html).
    - `:lerp` - Linearly interpolate values between previous and next nonmissing rows.
    - `:value` - Provide a value explicitly.  Value may be a function in which
                 case it will be called on the column with missing values elided
                 and the return will be used to as the filler."
  ([col]
  (tablecloth.column.api.missing/replace-missing col))
  ([col strategy]
  (tablecloth.column.api.missing/replace-missing col strategy))
  ([col strategy value]
  (tablecloth.column.api.missing/replace-missing col strategy value)))


(defn rint
  ([x options]
  (tablecloth.column.api.operators/rint x options))
  ([x]
  (tablecloth.column.api.operators/rint x)))


(defn round
  "Vectorized implementation of Math/round.  Operates in double space
  but returns a long or long reader."
  ([x options]
  (tablecloth.column.api.operators/round x options))
  ([x]
  (tablecloth.column.api.operators/round x)))


(defn select
  "Return a new column with the subset of indexes based on the provided `selection`.
  `selection` can be a list of indexes to select or boolean values where the index
  position of each true element indicates a index to select. When supplying a list
  of indices, duplicates are possible and will select the specified position more
  than once."
  ([col selection]
  (tech.v3.dataset.column/select col selection)))


(defn shift
  "Shift by n and fill in with the first element for n>0 or last element for n<0.

  Examples:

```clojure
user> (dfn/shift (range 10) 2)
[0 0 0 1 2 3 4 5 6 7]
user> (dfn/shift (range 10) -2)
[2 3 4 5 6 7 8 9 9 9]
```"
  ([x n]
  (tablecloth.column.api.operators/shift x n)))


(defn signum
  ([x options]
  (tablecloth.column.api.operators/signum x options))
  ([x]
  (tablecloth.column.api.operators/signum x)))


(defn sin
  ([x options]
  (tablecloth.column.api.operators/sin x options))
  ([x]
  (tablecloth.column.api.operators/sin x)))


(defn sinh
  ([x options]
  (tablecloth.column.api.operators/sinh x options))
  ([x]
  (tablecloth.column.api.operators/sinh x)))


(defn skew
  ([x options]
  (tablecloth.column.api.operators/skew x options))
  ([x]
  (tablecloth.column.api.operators/skew x)))


(defn slice
  "Returns a subset of the column defined by the inclusive `from` and
  `to` indexes. If `to` is not provided, slices to the end of the
  column. If `from` is not provided (i.e. is `nil`), slices from the
  beginning of the column. If either `from` or `to` is a negative
  number, it is treated as an index from the end of the column. The
  `:start` and `:end` keywords can be used to represent the start and
  end of the column, respectively.

  Examples:
  (def column [1 2 3 4 5])
  (slice column 1 3)     ;=> [2 3]
  (slice column 2)        ;=> [3 4 5]
  (slice column -3 -1)    ;=> [3 4 5]
  (slice column :start 2) ;=> [1 2 3 4 5]
  (slice column 2 :end)   ;=> [3 4 5]
  (slice column -2 :end)  ;=> [4 5]"
  ([col from]
  (tablecloth.column.api.column/slice col from))
  ([col from to]
  (tablecloth.column.api.column/slice col from to))
  ([col from to step]
  (tablecloth.column.api.column/slice col from to step)))


(defn sort-column
  "Returns a sorted version of the column `col`. You can supply the ordering
  keywords `:asc` or `:desc` or a comparator function to `order-or-comparator`.
  If no comparator function is provided, the column will be sorted in
  ascending order."
  ([col]
  (tablecloth.column.api.column/sort-column col))
  ([col order-or-comparator]
  (tablecloth.column.api.column/sort-column col order-or-comparator)))


(defn spearmans-correlation
  ([x y options]
  (tablecloth.column.api.operators/spearmans-correlation x y options))
  ([x y]
  (tablecloth.column.api.operators/spearmans-correlation x y)))


(defn sq
  ([x options]
  (tablecloth.column.api.operators/sq x options))
  ([x]
  (tablecloth.column.api.operators/sq x)))


(defn sqrt
  ([x options]
  (tablecloth.column.api.operators/sqrt x options))
  ([x]
  (tablecloth.column.api.operators/sqrt x)))


(defn standard-deviation
  ([x options]
  (tablecloth.column.api.operators/standard-deviation x options))
  ([x]
  (tablecloth.column.api.operators/standard-deviation x)))


(defn sum
  "Double sum of data using
  [Kahan compensated summation](https://en.wikipedia.org/wiki/Kahan_summation_algorithm)."
  ([x options]
  (tablecloth.column.api.operators/sum x options))
  ([x]
  (tablecloth.column.api.operators/sum x)))


(defn sum-fast
  "Find the sum of the data.  This operation is neither nan-aware nor does it implement
  kahans compensation although via parallelization it implements pairwise summation
  compensation.  For a more but slightly slower but far more correct sum operator,
  use [[sum]]."
  ([x]
  (tablecloth.column.api.operators/sum-fast x)))


(defn tan
  ([x options]
  (tablecloth.column.api.operators/tan x options))
  ([x]
  (tablecloth.column.api.operators/tan x)))


(defn tanh
  ([x options]
  (tablecloth.column.api.operators/tanh x options))
  ([x]
  (tablecloth.column.api.operators/tanh x)))


(defn to-degrees
  ([x options]
  (tablecloth.column.api.operators/to-degrees x options))
  ([x]
  (tablecloth.column.api.operators/to-degrees x)))


(defn to-radians
  ([x options]
  (tablecloth.column.api.operators/to-radians x options))
  ([x]
  (tablecloth.column.api.operators/to-radians x)))


(defn typeof
  "Returns the concrete type of the elements within the column `col`."
  ([col]
  (tablecloth.column.api.column/typeof col)))


(defn typeof?
  "True|false the column's elements are of the provided type `datatype`. Can check
   both concrete types (e.g. :int32) or general types (:numerical, :textual, etc)."
  ([col datatype]
  (tablecloth.column.api.column/typeof? col datatype)))


(defn ulp
  ([x options]
  (tablecloth.column.api.operators/ulp x options))
  ([x]
  (tablecloth.column.api.operators/ulp x)))


(defn unsigned-bit-shift-right
  ([x y]
  (tablecloth.column.api.operators/unsigned-bit-shift-right x y))
  ([x y & args]
  (apply tablecloth.column.api.operators/unsigned-bit-shift-right x y args)))


(defn variance
  ([x options]
  (tablecloth.column.api.operators/variance x options))
  ([x]
  (tablecloth.column.api.operators/variance x)))


(defn zero?
  ([x options]
  (tablecloth.column.api.operators/zero? x options))
  ([x]
  (tablecloth.column.api.operators/zero? x)))


(defn zeros
  "Create a new column filled wth `n-zeros`."
  ([n-zeros]
  (tablecloth.column.api.column/zeros n-zeros)))


