(ns scicloj.ml.dataset
  ;;Autogenerated from scicloj.ml.template.dataset-- DO NOT EDIT
  "
  This namespace contains functions which operate on a dataset
  and mostly return a dataset.

  The namespaces scicloj.ml.metamorph and scicloj.ml.dataset contain
  functions with the same name. But they operate on either a context
  map (ns metamorph) or on a dataset (ns dataset)

  The functions in tis namespace are re-exported from:

  * tabecloth.api - docs at https://scicloj.github.io/tablecloth/
  * tech.v3.dataset.modelling
  * tech.v3.dataset.column-filters
"
  (:require [scicloj.ml.template.dataset]
            [tablecloth.api]
            [tech.v3.dataset]
            [tech.v3.dataset.categorical]
            [tech.v3.dataset.column-filters]
            [tech.v3.dataset.modelling]))

(defn ->CategoricalMap
  "Positional factory function for class tech.v3.dataset.categorical.CategoricalMap."
  ([lookup-table src-column result-datatype]
  (tech.v3.dataset.categorical/->CategoricalMap lookup-table src-column result-datatype)))


(defn ->OneHotMap
  "Positional factory function for class tech.v3.dataset.categorical.OneHotMap."
  ([one-hot-table src-column result-datatype]
  (tech.v3.dataset.categorical/->OneHotMap one-hot-table src-column result-datatype)))


(defn ->array
  "Convert numerical column(s) to java array"
  ([ds colname]
  (tablecloth.api/->array ds colname))
  ([ds colname datatype]
  (tablecloth.api/->array ds colname datatype)))


(defn add-column
  "Add or update (modify) column under `column-name`.

  `column` can be sequence of values or generator function (which gets `ds` as input).

  * `ds` - a dataset
  * `column-name` - if it's existing column name, column will be replaced
  * `column` - can be column (from other dataset), sequence, single value or function (taking a dataset). Too big columns are always trimmed. Too small are cycled or extended with missing values (according to `size-strategy` argument)
  * `size-strategy` (optional) - when new column is shorter than dataset row count, following strategies are applied:
    - `:cycle` - repeat data
    - `:na` - append missing values
    - `:strict` - (default) throws an exception when sizes mismatch"
  ([ds column-name column]
  (tablecloth.api/add-column ds column-name column))
  ([ds column-name column size-strategy]
  (tablecloth.api/add-column ds column-name column size-strategy)))


(defn add-columns
  "Add or updade (modify) columns defined in `columns-map` (mapping: name -> column) "
  ([ds columns-map]
  (tablecloth.api/add-columns ds columns-map))
  ([ds columns-map size-strategy]
  (tablecloth.api/add-columns ds columns-map size-strategy)))


(defn add-or-replace-column
  ([ds column-name column]
  (tablecloth.api/add-or-replace-column ds column-name column))
  ([ds column-name column size-strategy]
  (tablecloth.api/add-or-replace-column ds column-name column size-strategy)))


(defn add-or-replace-columns
  ([ds columns-map]
  (tablecloth.api/add-or-replace-columns ds columns-map))
  ([ds columns-map size-strategy]
  (tablecloth.api/add-or-replace-columns ds columns-map size-strategy)))


(defn aggregate
  "Aggregate dataset by providing:

  - aggregation function
  - map with column names and functions
  - sequence of aggregation functions

  Aggregation functions can return:
  - single value
  - seq of values
  - map of values with column names"
  ([ds aggregator]
  (tablecloth.api/aggregate ds aggregator))
  ([ds aggregator options]
  (tablecloth.api/aggregate ds aggregator options)))


(defn aggregate-columns
  "Aggregates each column separately"
  ([ds columns-aggregators]
  (tablecloth.api/aggregate-columns ds columns-aggregators))
  ([ds columns-selector column-aggregators]
  (tablecloth.api/aggregate-columns ds columns-selector column-aggregators))
  ([ds columns-selector column-aggregators options]
  (tablecloth.api/aggregate-columns ds columns-selector column-aggregators options)))


(defn anti-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api/anti-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/anti-join ds-left ds-right columns-selector options)))


(defn append
  "Concats columns of several datasets"
  ([ds & args]
  (apply tablecloth.api/append ds args)))


(defn array-column->columns
  "Converts a column of type java array into several columns,
  one for each element of the array of all rows. The source column is dropped afterwards.
  The function assumes that arrays in all rows have same type and length and are numeric.

  `ds` Datset to operate on.
  `src-column` The (array) column to convert
  `opts` can contain:
    `prefix` newly created column will get prefix before column number
  "
  ([ds src-column opts]
  (tablecloth.api/array-column->columns ds src-column opts))
  ([ds src-column]
  (tablecloth.api/array-column->columns ds src-column)))


(defn as-regular-dataset
  "Remove grouping tag"
  ([ds]
  (tablecloth.api/as-regular-dataset ds)))


(defn asof-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api/asof-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/asof-join ds-left ds-right columns-selector options)))


(defn bind
  ([ds & args]
  (apply tablecloth.api/bind ds args)))


(defn boolean
  "Return a dataset containing only the boolean columns."
  ([dataset]
  (tech.v3.dataset.column-filters/boolean dataset)))


(defn by-rank
  "Select rows using `rank` on a column, ties are resolved using `:dense` method.

  See [R docs](https://www.rdocumentation.org/packages/base/versions/3.6.1/topics/rank).
  Rank uses 0 based indexing.
  
  Possible `:ties` strategies: `:average`, `:first`, `:last`, `:random`, `:min`, `:max`, `:dense`.
  `:dense` is the same as in `data.table::frank` from R

  `:desc?` set to true (default) order descending before calculating rank"
  ([ds columns-selector rank-predicate]
  (tablecloth.api/by-rank ds columns-selector rank-predicate))
  ([ds columns-selector rank-predicate options]
  (tablecloth.api/by-rank ds columns-selector rank-predicate options)))


(defn categorical
  "Return a dataset containing only the categorical columns."
  ([dataset]
  (tech.v3.dataset.column-filters/categorical dataset)))


(defn categorical->number
  "Convert columns into a discrete , numeric representation
  See tech.v3.dataset.categorical/fit-categorical-map."
  ([dataset filter-fn-or-ds]
  (tech.v3.dataset/categorical->number dataset filter-fn-or-ds))
  ([dataset filter-fn-or-ds table-args]
  (tech.v3.dataset/categorical->number dataset filter-fn-or-ds table-args))
  ([dataset filter-fn-or-ds table-args result-datatype]
  (tech.v3.dataset/categorical->number dataset filter-fn-or-ds table-args result-datatype)))


(defn categorical->one-hot
  "Convert string columns to numeric columns.
  See tech.v3.dataset.categorical/fit-one-hot"
  ([dataset filter-fn-or-ds]
  (tech.v3.dataset/categorical->one-hot dataset filter-fn-or-ds))
  ([dataset filter-fn-or-ds table-args]
  (tech.v3.dataset/categorical->one-hot dataset filter-fn-or-ds table-args))
  ([dataset filter-fn-or-ds table-args result-datatype]
  (tech.v3.dataset/categorical->one-hot dataset filter-fn-or-ds table-args result-datatype)))


(defn clone
  "Clone an object.  Can clone anything convertible to a reader."
  ([item]
  (tablecloth.api/clone item)))


(defn column
  ([dataset colname]
  (tablecloth.api/column dataset colname)))


(defn column-count
  (^{:tag long} [dataset]
  (tablecloth.api/column-count dataset)))


(defn column-filter
  "Return a dataset with only the columns for which the filter function returns a truthy
  value."
  ([dataset filter-fn]
  (tech.v3.dataset.column-filters/column-filter dataset filter-fn)))


(defn column-names
  "Returns column names, given a selector.
  Columns-selector can be one of the following:

  * :all keyword - selects all columns
  * column name - for single column
  * sequence of column names - for collection of columns
  * regex - to apply pattern on column names or datatype
  * filter predicate - to filter column names or datatype
  * type namespaced keyword for specific datatype or group of datatypes

  Column name can be anything.

column-names function returns names according to columns-selector
  and optional meta-field. meta-field is one of the following:

  * `:name` (default) - to operate on column names
  * `:datatype` - to operated on column types
  * `:all` - if you want to process all metadata

  Datatype groups are:

  * `:type/numerical` - any numerical type
  * `:type/float` - floating point number (:float32 and :float64)
  * `:type/integer` - any integer
  * `:type/datetime` - any datetime type

  If qualified keyword starts with :!type, complement set is used.


  "
  ([ds]
  (tablecloth.api/column-names ds))
  ([ds columns-selector]
  (tablecloth.api/column-names ds columns-selector))
  ([ds columns-selector meta-field]
  (tablecloth.api/column-names ds columns-selector meta-field)))


(defn column-values->categorical
  "Given a column encoded via either string->number or one-hot, reverse
  map to the a sequence of the original string column values.
  In the case of one-hot mappings, src-column must be the original
  column name before the one-hot map"
  ([dataset src-column]
  (tech.v3.dataset.modelling/column-values->categorical dataset src-column)))


(defn columns
  "Returns columns of dataset. Result type can be any of:
  * `:as-map`
  * `:as-double-arrays`
  * `:as-seqs`
  "
  ([ds]
  (tablecloth.api/columns ds))
  ([ds result-type]
  (tablecloth.api/columns ds result-type)))


(defn columns->array-column
  "Converts several columns to a single column of type array.
   The src columns are dropped afterwards.

  `ds` Dataset to operate on.
  `column-selector` anything supported by [[select-columns]]
  `new-column` new column to create
  "
  ([ds column-selector new-column]
  (tablecloth.api/columns->array-column ds column-selector new-column)))


(defn complete
  "TidyR complete.

  Fills a dataset with all possible combinations of selected columns. When a given combination doesn't exist, missing values are created."
  ([ds columns-selector & args]
  (apply tablecloth.api/complete ds columns-selector args)))


(defn concat
  "Joins rows from other datasets"
  ([dataset & args]
  (apply tablecloth.api/concat dataset args)))


(defn concat-copying
  "Joins rows from other datasets via a copy of data"
  ([dataset & args]
  (apply tablecloth.api/concat-copying dataset args)))


(defn convert-types
  "Convert type of the column to the other type."
  ([ds coltype-map-or-columns-selector]
  (tablecloth.api/convert-types ds coltype-map-or-columns-selector))
  ([ds columns-selector new-types]
  (tablecloth.api/convert-types ds columns-selector new-types)))


(defn create-categorical-map
  ([lookup-table src-colname result-datatype]
  (tech.v3.dataset.categorical/create-categorical-map lookup-table src-colname result-datatype)))


(defn cross-join
  "Cross product from selected columns"
  ([ds-left ds-right]
  (tablecloth.api/cross-join ds-left ds-right))
  ([ds-left ds-right columns-selector]
  (tablecloth.api/cross-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/cross-join ds-left ds-right columns-selector options)))


(defn crosstab
  "Cross tabulation of two sets of columns.

  Creates grouped dataset by [row-selector, col-selector] pairs and calls aggregation on each group.

  Options:

  * pivot? - create pivot table or just flat structure (default: true)
  * replace-missing? - replace missing values? (default: true)
  * missing-value - a missing value (default: 0)
  * aggregator - aggregating function (default: row-count)
  * marginal-rows, marginal-cols - adds row and/or cols, it's a sum if true. Can be a custom fn."
  ([ds row-selector col-selector]
  (tablecloth.api/crosstab ds row-selector col-selector))
  ([ds row-selector col-selector options]
  (tablecloth.api/crosstab ds row-selector col-selector options)))


(defn dataset
  "Create a `dataset`.
  
  Dataset can be created from:

  * map of values and/or sequences
  * sequence of maps
  * sequence of columns
  * file or url
  * array of arrays
  * single value

  Single value is set only when it's not possible to find a path for given data. If tech.ml.dataset throws an exception, it's won;t be printed. To print a stack trace, set `stack-trace?` option to `true`.

  ds/->dataset documentation:

  Create a dataset from either csv/tsv or a sequence of maps.

   * A `String` be interpreted as a file (or gzipped file if it
     ends with .gz) of tsv or csv data.  The system will attempt to autodetect if this
     is csv or tsv and then engineering around detecting datatypes all of which can
     be overridden.

  * InputStreams have no file type and thus a `file-type` must be provided in the
    options.

  * A sequence of maps may be passed in in which case the first N maps are scanned in
    order to derive the column datatypes before the actual columns are created.

  Parquet, xlsx, and xls formats require that you require the appropriate libraries
  which are `tech.v3.libs.parquet` for parquet, `tech.v3.libs.fastexcel` for xlsx,
  and `tech.v3.libs.poi` for xls.


  Arrow support is provided via the tech.v3.libs.Arrow namespace not via a file-type
  overload as the Arrow project current has 3 different file types and it is not clear
  what their final suffix will be or which of the three file types it will indicate.
  Please see documentation in the `tech.v3.libs.arrow` namespace for further information
  on Arrow file types.

  Options:

  - `:dataset-name` - set the name of the dataset.
  - `:file-type` - Override filetype discovery mechanism for strings or force a particular
      parser for an input stream.  Note that parquet must have paths on disk
      and cannot currently load from input stream.  Acceptible file types are:
      #{:csv :tsv :xlsx :xls :parquet}.
  - `:gzipped?` - for file formats that support it, override autodetection and force
     creation of a gzipped input stream as opposed to a normal input stream.
  - `:column-whitelist` - either sequence of string column names or sequence of column
     indices of columns to whitelist.
  - `:column-blacklist` - either sequence of string column names or sequence of column
     indices of columns to blacklist.
  - `:num-rows` - Number of rows to read
  - `:header-row?` - Defaults to true, indicates the first row is a header.
  - `:key-fn` - function to be applied to column names.  Typical use is:
     `:key-fn keyword`.
  - `:separator` - Add a character separator to the list of separators to auto-detect.
  - `:csv-parser` - Implementation of univocity's AbstractParser to use.  If not
     provided a default permissive parser is used.  This way you parse anything that
     univocity supports (so flat files and such).
  - `:bad-row-policy` - One of three options: :skip, :error, :carry-on.  Defaults to
     :carry-on.  Some csv data has ragged rows and in this case we have several
     options. If the option is :carry-on then we either create a new column or add
     missing values for columns that had no data for that row.
  - `:skip-bad-rows?` - Legacy option.  Use :bad-row-policy.
  - `:disable-comment-skipping?` - As default, the `#` character is recognised as a
     line comment when found in the beginning of a line of text in a CSV file,
     and the row will be ignored. Set `true` to disable this behavior.
  - `:max-chars-per-column` - Defaults to 4096.  Columns with more characters that this
     will result in an exception.
  - `:max-num-columns` - Defaults to 8192.  CSV,TSV files with more columns than this
     will fail to parse.  For more information on this option, please visit:
     https://github.com/uniVocity/univocity-parsers/issues/301
  - `:text-temp-dir` - The temporary directory to use for file-backed text.  Setting
    this value to boolean 'false' turns off file backed text which is the default.  If a
    tech.v3.resource stack context is opened the file will be deleted when the context
    closes else it will be deleted when the gc cleans up the dataset.  A shutdown hook is
    added as a last resort to ensure the file is cleaned up.
  - `:n-initial-skip-rows` - Skip N rows initially.  This currently may include the
     header row.  Works across both csv and spreadsheet datasets.
  - `:parser-type` - Default parser to use if no parser-fn is specified for that column.
     For csv files, the default parser type is `:string` which indicates a promotional
     string parser.  For sequences of maps, the default parser type is :object.  It can
     be useful in some contexts to use the `:string` parser with sequences of maps or
     maps of columns.
  - `:parser-fn` -
      - `keyword?` - all columns parsed to this datatype. For example:
        `{:parser-fn :string}`
      - `map?` - `{column-name parse-method}` parse each column with specified
        `parse-method`.
        The `parse-method` can be:
          - `keyword?` - parse the specified column to this datatype. For example:
            `{:parser-fn {:answer :boolean :id :int32}}`
          - tuple - pair of `[datatype parse-data]` in which case container of type
            `[datatype]` will be created. `parse-data` can be one of:
              - `:relaxed?` - data will be parsed such that parse failures of the standard
                 parse functions do not stop the parsing process.  :unparsed-values and
                 :unparsed-indexes are available in the metadata of the column that tell
                 you the values that failed to parse and their respective indexes.
              - `fn?` - function from str-> one of `:tech.v3.dataset/missing`,
                 `:tech.v3.dataset/parse-failure`, or the parsed value.
                 Exceptions here always kill the parse process.  :missing will get marked
                 in the missing indexes, and :parse-failure will result in the index being
                 added to missing, the unparsed the column's :unparsed-values and
                 :unparsed-indexes will be updated.
              - `string?` - for datetime types, this will turned into a DateTimeFormatter via
                 DateTimeFormatter/ofPattern.  For `:text` you can specify the backing file
                 to use.
              - `DateTimeFormatter` - use with the appropriate temporal parse static function
                 to parse the value.

   - `map?` - the header-name-or-idx is used to lookup value.  If not nil, then
           value can be any of the above options.  Else the default column parser
           is used.

  Returns a new dataset"
  ([]
  (tablecloth.api/dataset ))
  ([data]
  (tablecloth.api/dataset data))
  ([data options]
  (tablecloth.api/dataset data options)))


(defn dataset->categorical-maps
  "Given a dataset, return a map of column names to categorical label maps.
  This aids in inverting all of the label maps in a dataset.
  The source column name is src-column."
  ([dataset]
  (tech.v3.dataset.categorical/dataset->categorical-maps dataset)))


(defn dataset->categorical-xforms
  "Given a dataset, return a map of column-name->xform information."
  ([ds]
  (tech.v3.dataset.modelling/dataset->categorical-xforms ds)))


(defn dataset->one-hot-maps
  "Given a dataset, return a sequence of applied on-hot transformations."
  ([dataset]
  (tech.v3.dataset.categorical/dataset->one-hot-maps dataset)))


(defn dataset->str
  "Convert a dataset to a string.  Prints a single line header and then calls
  dataset-data->str.

  For options documentation see dataset-data->str."
  ([ds options]
  (tablecloth.api/dataset->str ds options))
  ([ds]
  (tablecloth.api/dataset->str ds)))


(defn dataset-name
  ([dataset]
  (tablecloth.api/dataset-name dataset)))


(defn dataset?
  "Is `ds` a `dataset` type?"
  ([ds]
  (tablecloth.api/dataset? ds)))


(defn datetime
  "Return a dataset containing only the datetime columns."
  ([dataset]
  (tech.v3.dataset.column-filters/datetime dataset)))


(defn difference
  ([ds-left ds-right]
  (tablecloth.api/difference ds-left ds-right))
  ([ds-left ds-right options]
  (tablecloth.api/difference ds-left ds-right options)))


(defn drop
  "Drop columns and rows."
  ([ds columns-selector rows-selector]
  (tablecloth.api/drop ds columns-selector rows-selector)))


(defn drop-columns
  "Drop columns by (returns dataset):

  - name
  - sequence of names
  - map of names with new names (rename)
  - function which filter names (via column metadata)"
  ([ds]
  (tablecloth.api/drop-columns ds))
  ([ds columns-selector]
  (tablecloth.api/drop-columns ds columns-selector))
  ([ds columns-selector meta-field]
  (tablecloth.api/drop-columns ds columns-selector meta-field)))


(defn drop-missing
  "Drop rows with missing values

 `columns-selector` selects columns to look at missing values"
  ([ds]
  (tablecloth.api/drop-missing ds))
  ([ds columns-selector]
  (tablecloth.api/drop-missing ds columns-selector)))


(defn drop-rows
  "Drop rows using:

  - row id
  - seq of row ids
  - seq of true/false
  - fn with predicate"
  ([ds]
  (tablecloth.api/drop-rows ds))
  ([ds rows-selector]
  (tablecloth.api/drop-rows ds rows-selector))
  ([ds rows-selector options]
  (tablecloth.api/drop-rows ds rows-selector options)))


(defn empty-ds?
  ([ds]
  (tablecloth.api/empty-ds? ds)))


(defn expand
  "TidyR expand.

  Creates all possible combinations of selected columns."
  ([ds columns-selector & args]
  (apply tablecloth.api/expand ds columns-selector args)))


(defn feature
  "Return a dataset container only the columns which have not been marked as inference
  columns."
  ([dataset]
  (tech.v3.dataset.column-filters/feature dataset)))


(defn feature-ecount
  "Number of feature columns.  Feature columns are columns that are not
  inference targets."
  (^{:tag long} [dataset]
  (tech.v3.dataset.modelling/feature-ecount dataset)))


(defn fill-range-replace
  "Fill missing up with lacking values. Accepts
  * dataset
  * column name
  * expected step (max-span, milliseconds in case of datetime column)
  * (optional) missing-strategy - how to replace missing, default :down (set to nil if none)
  * (optional) missing-value - optional value for replace missing
"
  ([ds colname max-span]
  (tablecloth.api/fill-range-replace ds colname max-span))
  ([ds colname max-span missing-strategy]
  (tablecloth.api/fill-range-replace ds colname max-span missing-strategy))
  ([ds colname max-span missing-strategy missing-value]
  (tablecloth.api/fill-range-replace ds colname max-span missing-strategy missing-value)))


(defn first
  "First row"
  ([ds]
  (tablecloth.api/first ds)))


(defn fit-categorical-map
  "Given a column, map it into an numeric space via a discrete map of values
  to integers.  This fits the categorical transformation onto the column and returns
  the transformation.

  If `table-args` is not given, the distinct column values will be mapped into 0..x without any specific order.

  'table-args` allows to specify the precise mapping as a sequence of pairs of [val idx] or as a sorted seq of values.
"
  (^{:tag tech.v3.dataset.categorical.CategoricalMap} [dataset colname & args]
  (apply tech.v3.dataset.categorical/fit-categorical-map dataset colname args)))


(defn fit-one-hot
  "Fit a one hot transformation to a column.  Returns a reusable transformation.
  Maps each unique value to a column with 1 every time the value appears in the
  original column and 0 otherwise."
  (^{:tag tech.v3.dataset.categorical.OneHotMap} [dataset colname & args]
  (apply tech.v3.dataset.categorical/fit-one-hot dataset colname args)))


(defn fold-by
  "Group-by and pack columns into vector - the output data set has a row for each unique combination
  of the provided columns while each remaining column has its valu(es) collected into a vector, similar
  to how clojure.core/group-by works.
  See https://scicloj.github.io/tablecloth/index.html#Fold-by"
  ([ds columns-selector]
  (tablecloth.api/fold-by ds columns-selector))
  ([ds columns-selector folding-function]
  (tablecloth.api/fold-by ds columns-selector folding-function)))


(defn full-join
  "Join keeping all rows"
  ([ds-left ds-right columns-selector]
  (tablecloth.api/full-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/full-join ds-left ds-right columns-selector options)))


(defn get-entry
  "Returns a single value from given column and row"
  ([ds column row]
  (tablecloth.api/get-entry ds column row)))


(defn group-by
  "Group dataset by:

  - column name
  - list of columns
  - map of keys and row indexes
  - function getting map of values

  Options are:

  - select-keys - when grouping is done by function, you can limit fields to a `select-keys` seq.
  - result-type - return results as dataset (`:as-dataset`, default) or as map of datasets (`:as-map`) or as map of row indexes (`:as-indexes`) or as sequence of (sub)datasets
  - other parameters which are passed to `dataset` fn

  When dataset is returned, meta contains `:grouped?` set to true. Columns in dataset:

  - name - group name
  - group-id - id of the group (int)
  - data - group as dataset"
  ([ds grouping-selector]
  (tablecloth.api/group-by ds grouping-selector))
  ([ds grouping-selector options]
  (tablecloth.api/group-by ds grouping-selector options)))


(defn grouped?
  "Is `dataset` represents grouped dataset (result of `group-by`)?"
  ([ds]
  (tablecloth.api/grouped? ds)))


(defn groups->map
  "Convert grouped dataset to the map of groups"
  ([ds]
  (tablecloth.api/groups->map ds)))


(defn groups->seq
  "Convert grouped dataset to seq of the groups"
  ([ds]
  (tablecloth.api/groups->seq ds)))


(defn has-column?
  ([dataset column-name]
  (tablecloth.api/has-column? dataset column-name)))


(defn head
  "First n rows (default 5)"
  ([ds]
  (tablecloth.api/head ds))
  ([ds n]
  (tablecloth.api/head ds n)))


(defn inference-column?
  ([col]
  (tech.v3.dataset.modelling/inference-column? col)))


(defn inference-target-column-names
  "Return the names of the columns that are inference targets."
  ([ds]
  (tech.v3.dataset.modelling/inference-target-column-names ds)))


(defn inference-target-ds
  "Given a dataset return reverse-mapped inference target columns or nil
  in the case where there are no inference targets."
  ([dataset]
  (tech.v3.dataset.modelling/inference-target-ds dataset)))


(defn inference-target-label-inverse-map
  "Given options generated during ETL operations and annotated with :label-columns
  sequence container 1 label column, generate a reverse map that maps from a dataset
  value back to the label that generated that value."
  ([dataset & args]
  (apply tech.v3.dataset.modelling/inference-target-label-inverse-map dataset args)))


(defn inference-target-label-map
  ([dataset & args]
  (apply tech.v3.dataset.modelling/inference-target-label-map dataset args)))


(defn info
  "Returns a statistcial information about the columns of a dataset.
  `result-type ` can be :descriptive or :columns"
  ([ds]
  (tablecloth.api/info ds))
  ([ds result-type]
  (tablecloth.api/info ds result-type)))


(defn inner-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api/inner-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/inner-join ds-left ds-right columns-selector options)))


(defn intersect
  ([ds-left ds-right]
  (tablecloth.api/intersect ds-left ds-right))
  ([ds-left ds-right options]
  (tablecloth.api/intersect ds-left ds-right options)))


(defn intersection
  "Return only columns for rhs for which an equivalently named column exists in lhs."
  ([lhs-ds rhs-ds]
  (tech.v3.dataset.column-filters/intersection lhs-ds rhs-ds)))


(defn invert-categorical-map
  "Invert a categorical map returning the column to the original set of values."
  ([dataset opts]
  (tech.v3.dataset.categorical/invert-categorical-map dataset opts)))


(defn invert-one-hot-map
  "Invert a one-hot transformation removing the one-hot columns and adding back the
  original column."
  ([dataset opts]
  (tech.v3.dataset.categorical/invert-one-hot-map dataset opts)))


(defn join-columns
  "Join clumns of dataset. Accepts:
  dataset
  column selector (as in select-columns)
  options
  `:separator` (default -)
  `:drop-columns?` - whether to drop source columns or not (default true)
  `:result-type`
     `:map` - packs data into map
     `:seq` - packs data into sequence
     `:string` - join strings with separator (default)
     or custom function which gets row as a vector
  `:missing-subst` - substitution for missing value
  "
  ([ds target-column columns-selector]
  (tablecloth.api/join-columns ds target-column columns-selector))
  ([ds target-column columns-selector conf]
  (tablecloth.api/join-columns ds target-column columns-selector conf)))


(defn k-fold-datasets
  "Given 1 dataset, prepary K datasets using the k-fold algorithm.
  Randomize dataset defaults to true which will realize the entire dataset
  so use with care if you have large datasets.

  Returns a sequence of {:test-ds :train-ds}

  Options:

  * `:randomize-dataset?` - When true, shuffle the dataset.  In that case 'seed' may be
     provided.  Defaults to true.
  * `:seed` -  when `:randomize-dataset?` is true then this can either be an
     implementation of java.util.Random or an integer seed which will be used to
     construct java.util.Random."
  ([dataset k options]
  (tech.v3.dataset.modelling/k-fold-datasets dataset k options))
  ([dataset k]
  (tech.v3.dataset.modelling/k-fold-datasets dataset k)))


(defn labels
  "Return the labels.  The labels sequence is the reverse mapped inference
  column.  This returns a single column of data or errors out."
  ([dataset]
  (tech.v3.dataset.modelling/labels dataset)))


(defn last
  "Last row"
  ([ds]
  (tablecloth.api/last ds)))


(defn left-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api/left-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/left-join ds-left ds-right columns-selector options)))


(defn map->CategoricalMap
  "Factory function for class tech.v3.dataset.categorical.CategoricalMap, taking a map of keywords to field values."
  ([m__7972__auto__]
  (tech.v3.dataset.categorical/map->CategoricalMap m__7972__auto__)))


(defn map->OneHotMap
  "Factory function for class tech.v3.dataset.categorical.OneHotMap, taking a map of keywords to field values."
  ([m__7972__auto__]
  (tech.v3.dataset.categorical/map->OneHotMap m__7972__auto__)))


(defn map-columns
  "Map over rows using a map function. The arity should match the columns selected."
  ([ds column-name map-fn]
  (tablecloth.api/map-columns ds column-name map-fn))
  ([ds column-name columns-selector map-fn]
  (tablecloth.api/map-columns ds column-name columns-selector map-fn))
  ([ds column-name new-type columns-selector map-fn]
  (tablecloth.api/map-columns ds column-name new-type columns-selector map-fn)))


(defn map-rows
  "Map a function across the rows of the dataset producing a new dataset that is merged back into the original potentially replacing existing columns."
  ([ds map-fn]
  (tablecloth.api/map-rows ds map-fn))
  ([ds map-fn options]
  (tablecloth.api/map-rows ds map-fn options)))


(defn mark-as-group
  "Add grouping tag"
  ([ds]
  (tablecloth.api/mark-as-group ds)))


(defn metadata-filter
  "Return a dataset with only the columns for which, given the column metadata,
  the filter function returns a truthy value."
  ([dataset filter-fn]
  (tech.v3.dataset.column-filters/metadata-filter dataset filter-fn)))


(defn missing
  "Return a dataset with only columns have have missing values"
  ([dataset]
  (tech.v3.dataset.column-filters/missing dataset)))


(defn model-type
  "Check the label column after dataset processing.
  Return either
  :regression
  :classification"
  ([dataset & args]
  (apply tech.v3.dataset.modelling/model-type dataset args)))


(defn no-missing
  "Return a dataset with only columns that have no missing values."
  ([dataset]
  (tech.v3.dataset.column-filters/no-missing dataset)))


(defn num-inference-classes
  "Given a dataset and correctly built options from pipeline operations,
  return the number of classes used for the label.  Error if not classification
  dataset."
  (^{:tag long} [dataset]
  (tech.v3.dataset.modelling/num-inference-classes dataset)))


(defn numeric
  "Return a dataset containing only the numeric columns."
  ([dataset]
  (tech.v3.dataset.column-filters/numeric dataset)))


(defn of-datatype
  "Return a dataset containing only the columns of a specific datatype."
  ([dataset datatype]
  (tech.v3.dataset.column-filters/of-datatype dataset datatype)))


(defn order-by
  "Order dataset by:
  - column name
  - columns (as sequence of names)
  - key-fn
  - sequence of columns / key-fn
  Additionally you can ask the order by:
  - :asc
  - :desc
  - custom comparator function"
  ([ds columns-or-fn]
  (tablecloth.api/order-by ds columns-or-fn))
  ([ds columns-or-fn comparators]
  (tablecloth.api/order-by ds columns-or-fn comparators))
  ([ds columns-or-fn comparators options]
  (tablecloth.api/order-by ds columns-or-fn comparators options)))


(defn pivot->longer
  "`tidyr` pivot_longer api"
  ([ds]
  (tablecloth.api/pivot->longer ds))
  ([ds columns-selector]
  (tablecloth.api/pivot->longer ds columns-selector))
  ([ds columns-selector options]
  (tablecloth.api/pivot->longer ds columns-selector options)))


(defn pivot->wider
  "Converts columns to rows. Arguments:
  * dataset
  * columns selector
  * options:
    `:target-columns` - names of the columns created or columns pattern (see below) (default: :$column)
    `:value-column-name` - name of the column for values (default: :$value)
    `:splitter` - string, regular expression or function which splits source column names into data
    `:drop-missing?` - remove rows with missing? (default: true)
    `:datatypes` - map of target columns data types
    `:coerce-to-number` - try to convert extracted values to numbers if possible (default: true)

  * target-columns - can be:

    * column name - source columns names are put there as a data
    * column names as seqence - source columns names after split are put separately into :target-columns as data
    * pattern - is a sequence of names, where some of the names are nil. nil is replaced by a name taken from splitter and such column is used for values.
  "
  ([ds columns-selector value-columns]
  (tablecloth.api/pivot->wider ds columns-selector value-columns))
  ([ds columns-selector value-columns options]
  (tablecloth.api/pivot->wider ds columns-selector value-columns options)))


(defn prediction
  "Return the columns of the dataset marked as predictions."
  ([dataset]
  (tech.v3.dataset.column-filters/prediction dataset)))


(defn print-dataset
  "Prints dataset into console. For options see
  tech.v3.dataset.print/dataset-data->str
  "
  ([ds]
  (tablecloth.api/print-dataset ds))
  ([ds options]
  (tablecloth.api/print-dataset ds options)))


(defn probability-distribution
  "Return the columns of the dataset that comprise the probability distribution
  after classification."
  ([dataset]
  (tech.v3.dataset.column-filters/probability-distribution dataset)))


(defn probability-distributions->label-column
  "Given a dataset that has columns in which the column names describe labels and the
  rows describe a probability distribution, create a label column by taking the max
  value in each row and assign column that row value."
  ([prob-ds dst-colname]
  (tech.v3.dataset.modelling/probability-distributions->label-column prob-ds dst-colname)))


(defn process-group-data
  "Internal: The passed-in function is applied on all groups"
  ([ds f]
  (tablecloth.api/process-group-data ds f))
  ([ds f parallel?]
  (tablecloth.api/process-group-data ds f parallel?)))


(defn rand-nth
  "Returns single random row"
  ([ds]
  (tablecloth.api/rand-nth ds))
  ([ds options]
  (tablecloth.api/rand-nth ds options)))


(defn random
  "Returns (n) random rows with repetition"
  ([ds]
  (tablecloth.api/random ds))
  ([ds n]
  (tablecloth.api/random ds n))
  ([ds n options]
  (tablecloth.api/random ds n options)))


(defn read-nippy
  ([filename]
  (tablecloth.api/read-nippy filename)))


(defn rename-columns
  "Rename columns with provided old -> new name map"
  ([ds columns-selector columns-map-fn]
  (tablecloth.api/rename-columns ds columns-selector columns-map-fn))
  ([ds columns-mapping]
  (tablecloth.api/rename-columns ds columns-mapping)))


(defn reorder-columns
  "Reorder columns using column selector(s). When column names are incomplete, the missing will be attached at the end."
  ([ds columns-selector & args]
  (apply tablecloth.api/reorder-columns ds columns-selector args)))


(defn replace-missing
  "Replaces missing values. Accepts

  * dataset
  * column selector, default: :all
  * strategy, default: :nearest
  * value (optional)
  * single value
  * sequence of values (cycled)
  * function, applied on column(s) with stripped missings

  Strategies are:

  `:value` - replace with given value
  `:up` - copy values up
  `:down` - copy values down
  `:updown` - copy values up and then down for missing values at the end
  `:downup` - copy values down and then up for missing values at the beginning
  `:mid` or `:nearest` - copy values around known values
  `:midpoint` - use average value from previous and next non-missing
  `:lerp` - trying to lineary approximate values, works for numbers and datetime, otherwise applies :nearest. For numbers always results in float datatype.
  "
  ([ds]
  (tablecloth.api/replace-missing ds))
  ([ds strategy]
  (tablecloth.api/replace-missing ds strategy))
  ([ds columns-selector strategy]
  (tablecloth.api/replace-missing ds columns-selector strategy))
  ([ds columns-selector strategy value]
  (tablecloth.api/replace-missing ds columns-selector strategy value)))


(defn reverse-map-categorical-xforms
  "Given a dataset where we have converted columns from a categorical representation
  to either a numeric reprsentation or a one-hot representation, reverse map
  back to the original dataset given the reverse mapping of label->number in
  the column's metadata."
  ([dataset]
  (tech.v3.dataset.categorical/reverse-map-categorical-xforms dataset)))


(defn right-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api/right-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/right-join ds-left ds-right columns-selector options)))


(defn row-count
  (^{:tag long} [dataset-or-col]
  (tablecloth.api/row-count dataset-or-col)))


(defn rows
  "Returns rows of dataset. Result type can be any of:
  * `:as-maps` - maps
  * `:as-double-arrays` - double arrays
  * `:as-seqs` - reader (sequence, default)
  * `:as-vecs` - vectors

  If you want to elide nils in maps set `:nil-missing?` option to false (default: `true`).
  Another option - `:copying?` - when true row values are copied on read (default: `false`)."
  ([ds]
  (tablecloth.api/rows ds))
  ([ds result-type]
  (tablecloth.api/rows ds result-type))
  ([ds result-type options]
  (tablecloth.api/rows ds result-type options)))


(defn select
  "Select columns and rows."
  ([ds columns-selector rows-selector]
  (tablecloth.api/select ds columns-selector rows-selector)))


(defn select-columns
  "Select columns by (returns dataset):

  - name
  - sequence of names
  - map of names with new names (rename)
  - function which filter names (via column metadata)"
  ([ds]
  (tablecloth.api/select-columns ds))
  ([ds columns-selector]
  (tablecloth.api/select-columns ds columns-selector))
  ([ds columns-selector meta-field]
  (tablecloth.api/select-columns ds columns-selector meta-field)))


(defn select-missing
  "Select rows with missing values

 `columns-selector` selects columns to look at missing values"
  ([ds]
  (tablecloth.api/select-missing ds))
  ([ds columns-selector]
  (tablecloth.api/select-missing ds columns-selector)))


(defn select-rows
  "Select rows using:

  - row id
  - seq of row ids
  - seq of true/false
  - fn with predicate"
  ([ds]
  (tablecloth.api/select-rows ds))
  ([ds rows-selector]
  (tablecloth.api/select-rows ds rows-selector))
  ([ds rows-selector options]
  (tablecloth.api/select-rows ds rows-selector options)))


(defn semi-join
  ([ds-left ds-right columns-selector]
  (tablecloth.api/semi-join ds-left ds-right columns-selector))
  ([ds-left ds-right columns-selector options]
  (tablecloth.api/semi-join ds-left ds-right columns-selector options)))


(defn separate-column
  ([ds column]
  (tablecloth.api/separate-column ds column))
  ([ds column separator]
  (tablecloth.api/separate-column ds column separator))
  ([ds column target-columns separator]
  (tablecloth.api/separate-column ds column target-columns separator))
  ([ds column target-columns separator conf]
  (tablecloth.api/separate-column ds column target-columns separator conf)))


(defn set-dataset-name
  ([dataset ds-name]
  (tablecloth.api/set-dataset-name dataset ds-name)))


(defn set-inference-target
  "Set the inference target on the column.  This sets the :column-type member
  of the column metadata to :inference-target?."
  ([dataset target-name-or-target-name-seq]
  (tech.v3.dataset.modelling/set-inference-target dataset target-name-or-target-name-seq)))


(defn shape
  "Returns shape of the dataset [rows, cols]"
  ([ds]
  (tablecloth.api/shape ds)))


(defn shuffle
  "Shuffle dataset (with seed)"
  ([ds]
  (tablecloth.api/shuffle ds))
  ([ds options]
  (tablecloth.api/shuffle ds options)))


(defn split
  "Split given dataset into 2 or more (holdout) splits

  As the result two new columns are added:

  * `:$split-name` - with subgroup name
  * `:$split-id` - fold id/repetition id

  `split-type` can be one of the following:

  * `:kfold` - k-fold strategy, `:k` defines number of folds (defaults to `5`), produces `k` splits
  * `:bootstrap` - `:ratio` defines ratio of observations put into result (defaults to `1.0`), produces `1` split
  * `:holdout` - split into two parts with given ratio (defaults to `2/3`), produces `1` split
  * `:loo` - leave one out, produces the same number of splits as number of observations

  `:holdout` can accept also probabilites or ratios and can split to more than 2 subdatasets
  
  Additionally you can provide:

  * `:seed` - for random number generator
  * `:repeats` - repeat procedure `:repeats` times
  * `:partition-selector` - same as in `group-by` for stratified splitting to reflect dataset structure in splits.
  * `:split-names` names of subdatasets different than default, ie. `[:train :test :split-2 ...]`
  * `:split-col-name` - a column where name of split is stored, either `:train` or `:test` values (default: `:$split-name`)
  * `:split-id-col-name` - a column where id of the train/test pair is stored (default: `:$split-id`)
  * `:ratio` - specify a list of split ratios for `:holdout`. Need to have same size then `:split-names` (example: [0.2 0.2 0.6])

  Rows are shuffled before splitting.
  
  In case of grouped dataset each group is processed separately.

  See [more](https://www.mitpressjournals.org/doi/pdf/10.1162/EVCO_a_00069)"
  ([ds]
  (tablecloth.api/split ds))
  ([ds split-type]
  (tablecloth.api/split ds split-type))
  ([ds split-type options]
  (tablecloth.api/split ds split-type options)))


(defn split->seq
  "Returns split as a sequence of train/test datasets or map of sequences (grouped dataset)"
  ([ds]
  (tablecloth.api/split->seq ds))
  ([ds split-type]
  (tablecloth.api/split->seq ds split-type))
  ([ds split-type options]
  (tablecloth.api/split->seq ds split-type options)))


(defn string
  "Return a dataset containing only the string columns."
  ([dataset]
  (tech.v3.dataset.column-filters/string dataset)))


(defn tail
  "Last n rows (default 5)"
  ([ds]
  (tablecloth.api/tail ds))
  ([ds n]
  (tablecloth.api/tail ds n)))


(defn target
  "Return a dataset containing only the columns that have been marked as inference
  targets."
  ([dataset]
  (tech.v3.dataset.column-filters/target dataset)))


(defn train-test-split
  "Probabilistically split the dataset returning a map of `{:train-ds :test-ds}`.

  Options:

  * `:randomize-dataset?` - When true, shuffle the dataset.  In that case 'seed' may be
     provided.  Defaults to true.
  * `:seed` -  when `:randomize-dataset?` is true then this can either be an
     implementation of java.util.Random or an integer seed which will be used to
     construct java.util.Random.
  * `:train-fraction` - Fraction of the dataset to use as training set.  Defaults to
     0.7."
  ([dataset options]
  (tech.v3.dataset.modelling/train-test-split dataset options))
  ([dataset]
  (tech.v3.dataset.modelling/train-test-split dataset)))


(defn transform-categorical-map
  "Apply a categorical mapping transformation fit with fit-categorical-map."
  ([dataset fit-data]
  (tech.v3.dataset.categorical/transform-categorical-map dataset fit-data)))


(defn transform-one-hot
  "Apply a one-hot transformation to a dataset"
  ([dataset one-hot-fit-data]
  (tech.v3.dataset.categorical/transform-one-hot dataset one-hot-fit-data)))


(defn ungroup
  "Concat groups into dataset.

  When `add-group-as-column` or `add-group-id-as-column` is set to `true` or name(s), columns with group name(s) or group id is added to the result.

  Before joining the groups groups can be sorted by group name."
  ([ds]
  (tablecloth.api/ungroup ds))
  ([ds options]
  (tablecloth.api/ungroup ds options)))


(defn union
  ([ds & args]
  (apply tablecloth.api/union ds args)))


(defn unique-by
  "Remove rows which contains the same data
  `column-selector` Select columns for uniqueness
  `strategy` There are 4 strategies defined to handle duplicates

    `:first` - select first row (default)
    `:last` - select last row
    `:random` - select random row
    any function - apply function to a columns which are subject of uniqueness"
  ([ds]
  (tablecloth.api/unique-by ds))
  ([ds columns-selector]
  (tablecloth.api/unique-by ds columns-selector))
  ([ds columns-selector options]
  (tablecloth.api/unique-by ds columns-selector options)))


(defn unmark-group
  "Remove grouping tag"
  ([ds]
  (tablecloth.api/unmark-group ds)))


(defn unroll
  "Unfolds sequences stored inside a column(s), turning it into multiple columns. Opposite of [[fold-by]].
  Add each of the provided columns to the set that defines the \"uniqe key\" of each row.
  Thus there will be a new row for each value inside the target column(s)' value sequence.
  If you want instead to split the content of the columns into a set of new _columns_, look at [[separate-column]].
  See https://scicloj.github.io/tablecloth/index.html#Unroll"
  ([ds columns-selector]
  (tablecloth.api/unroll ds columns-selector))
  ([ds columns-selector options]
  (tablecloth.api/unroll ds columns-selector options)))


(defn update-columns
  ([ds columns-map]
  (tablecloth.api/update-columns ds columns-map))
  ([ds columns-selector update-functions]
  (tablecloth.api/update-columns ds columns-selector update-functions)))


(defn write!
  "Write a dataset out to a file.  Supported forms are:

```clojure
(ds/write! test-ds \"test.csv\")
(ds/write! test-ds \"test.tsv\")
(ds/write! test-ds \"test.tsv.gz\")
(ds/write! test-ds \"test.nippy\")
(ds/write! test-ds out-stream)
```

Options:

  * `:max-chars-per-column` - csv,tsv specific, defaults to 65536 - values longer than this will
     cause an exception during serialization.
  * `:max-num-columns` - csv,tsv specific, defaults to 8192 - If the dataset has more than this number of
     columns an exception will be thrown during serialization.
  * `:quoted-columns` - csv specific - sequence of columns names that you would like to always have quoted.
  * `:file-type` - Manually specify the file type.  This is usually inferred from the filename but if you
     pass in an output stream then you will need to specify the file type.
  * `:headers?` - if csv headers are written, defaults to true."
  ([dataset output-path options]
  (tablecloth.api/write! dataset output-path options))
  ([dataset output-path]
  (tablecloth.api/write! dataset output-path)))


(def write-csv! tablecloth.api/write-csv!)
(defn write-nippy!
  ([ds filename]
  (tablecloth.api/write-nippy! ds filename)))


