goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_50381 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_50381(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_50386 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_50386(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__49346 = coll;
var G__49347 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__49346,G__49347) : shadow.dom.lazy_native_coll_seq.call(null,G__49346,G__49347));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4160__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__49375 = arguments.length;
switch (G__49375) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__49380 = arguments.length;
switch (G__49380) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__49385 = arguments.length;
switch (G__49385) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__49390 = arguments.length;
switch (G__49390) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__49407 = arguments.length;
switch (G__49407) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__49418 = arguments.length;
switch (G__49418) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e49425){if((e49425 instanceof Object)){
var e = e49425;
return console.log("didnt support attachEvent",el,e);
} else {
throw e49425;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__49436 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__49437 = null;
var count__49438 = (0);
var i__49439 = (0);
while(true){
if((i__49439 < count__49438)){
var el = chunk__49437.cljs$core$IIndexed$_nth$arity$2(null,i__49439);
var handler_50468__$1 = ((function (seq__49436,chunk__49437,count__49438,i__49439,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__49436,chunk__49437,count__49438,i__49439,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_50468__$1);


var G__50469 = seq__49436;
var G__50470 = chunk__49437;
var G__50471 = count__49438;
var G__50472 = (i__49439 + (1));
seq__49436 = G__50469;
chunk__49437 = G__50470;
count__49438 = G__50471;
i__49439 = G__50472;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49436);
if(temp__5754__auto__){
var seq__49436__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49436__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49436__$1);
var G__50475 = cljs.core.chunk_rest(seq__49436__$1);
var G__50476 = c__4591__auto__;
var G__50477 = cljs.core.count(c__4591__auto__);
var G__50478 = (0);
seq__49436 = G__50475;
chunk__49437 = G__50476;
count__49438 = G__50477;
i__49439 = G__50478;
continue;
} else {
var el = cljs.core.first(seq__49436__$1);
var handler_50480__$1 = ((function (seq__49436,chunk__49437,count__49438,i__49439,el,seq__49436__$1,temp__5754__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__49436,chunk__49437,count__49438,i__49439,el,seq__49436__$1,temp__5754__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_50480__$1);


var G__50481 = cljs.core.next(seq__49436__$1);
var G__50482 = null;
var G__50483 = (0);
var G__50484 = (0);
seq__49436 = G__50481;
chunk__49437 = G__50482;
count__49438 = G__50483;
i__49439 = G__50484;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__49448 = arguments.length;
switch (G__49448) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__49457 = cljs.core.seq(events);
var chunk__49458 = null;
var count__49459 = (0);
var i__49460 = (0);
while(true){
if((i__49460 < count__49459)){
var vec__49472 = chunk__49458.cljs$core$IIndexed$_nth$arity$2(null,i__49460);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49472,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49472,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50492 = seq__49457;
var G__50493 = chunk__49458;
var G__50494 = count__49459;
var G__50495 = (i__49460 + (1));
seq__49457 = G__50492;
chunk__49458 = G__50493;
count__49459 = G__50494;
i__49460 = G__50495;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49457);
if(temp__5754__auto__){
var seq__49457__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49457__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49457__$1);
var G__50503 = cljs.core.chunk_rest(seq__49457__$1);
var G__50504 = c__4591__auto__;
var G__50505 = cljs.core.count(c__4591__auto__);
var G__50506 = (0);
seq__49457 = G__50503;
chunk__49458 = G__50504;
count__49459 = G__50505;
i__49460 = G__50506;
continue;
} else {
var vec__49478 = cljs.core.first(seq__49457__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49478,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49478,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50514 = cljs.core.next(seq__49457__$1);
var G__50515 = null;
var G__50516 = (0);
var G__50517 = (0);
seq__49457 = G__50514;
chunk__49458 = G__50515;
count__49459 = G__50516;
i__49460 = G__50517;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__49484 = cljs.core.seq(styles);
var chunk__49485 = null;
var count__49486 = (0);
var i__49487 = (0);
while(true){
if((i__49487 < count__49486)){
var vec__49499 = chunk__49485.cljs$core$IIndexed$_nth$arity$2(null,i__49487);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49499,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49499,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50526 = seq__49484;
var G__50527 = chunk__49485;
var G__50528 = count__49486;
var G__50529 = (i__49487 + (1));
seq__49484 = G__50526;
chunk__49485 = G__50527;
count__49486 = G__50528;
i__49487 = G__50529;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49484);
if(temp__5754__auto__){
var seq__49484__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49484__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49484__$1);
var G__50531 = cljs.core.chunk_rest(seq__49484__$1);
var G__50532 = c__4591__auto__;
var G__50533 = cljs.core.count(c__4591__auto__);
var G__50534 = (0);
seq__49484 = G__50531;
chunk__49485 = G__50532;
count__49486 = G__50533;
i__49487 = G__50534;
continue;
} else {
var vec__49504 = cljs.core.first(seq__49484__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49504,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49504,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50536 = cljs.core.next(seq__49484__$1);
var G__50537 = null;
var G__50538 = (0);
var G__50539 = (0);
seq__49484 = G__50536;
chunk__49485 = G__50537;
count__49486 = G__50538;
i__49487 = G__50539;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__49512_50540 = key;
var G__49512_50541__$1 = (((G__49512_50540 instanceof cljs.core.Keyword))?G__49512_50540.fqn:null);
switch (G__49512_50541__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_50547 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4160__auto__ = goog.string.startsWith(ks_50547,"data-");
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return goog.string.startsWith(ks_50547,"aria-");
}
})())){
el.setAttribute(ks_50547,value);
} else {
(el[ks_50547] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__49531){
var map__49533 = p__49531;
var map__49533__$1 = cljs.core.__destructure_map(map__49533);
var props = map__49533__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49533__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__49535 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49535,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49535,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49535,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__49541 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__49541,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__49541;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__49545 = arguments.length;
switch (G__49545) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__49553){
var vec__49555 = p__49553;
var seq__49556 = cljs.core.seq(vec__49555);
var first__49557 = cljs.core.first(seq__49556);
var seq__49556__$1 = cljs.core.next(seq__49556);
var nn = first__49557;
var first__49557__$1 = cljs.core.first(seq__49556__$1);
var seq__49556__$2 = cljs.core.next(seq__49556__$1);
var np = first__49557__$1;
var nc = seq__49556__$2;
var node = vec__49555;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49562 = nn;
var G__49563 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49562,G__49563) : create_fn.call(null,G__49562,G__49563));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49565 = nn;
var G__49566 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49565,G__49566) : create_fn.call(null,G__49565,G__49566));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__49569 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49569,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49569,(1),null);
var seq__49573_50574 = cljs.core.seq(node_children);
var chunk__49574_50575 = null;
var count__49575_50576 = (0);
var i__49576_50577 = (0);
while(true){
if((i__49576_50577 < count__49575_50576)){
var child_struct_50579 = chunk__49574_50575.cljs$core$IIndexed$_nth$arity$2(null,i__49576_50577);
var children_50580 = shadow.dom.dom_node(child_struct_50579);
if(cljs.core.seq_QMARK_(children_50580)){
var seq__49616_50582 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50580));
var chunk__49618_50583 = null;
var count__49619_50584 = (0);
var i__49620_50585 = (0);
while(true){
if((i__49620_50585 < count__49619_50584)){
var child_50588 = chunk__49618_50583.cljs$core$IIndexed$_nth$arity$2(null,i__49620_50585);
if(cljs.core.truth_(child_50588)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50588);


var G__50589 = seq__49616_50582;
var G__50590 = chunk__49618_50583;
var G__50591 = count__49619_50584;
var G__50592 = (i__49620_50585 + (1));
seq__49616_50582 = G__50589;
chunk__49618_50583 = G__50590;
count__49619_50584 = G__50591;
i__49620_50585 = G__50592;
continue;
} else {
var G__50593 = seq__49616_50582;
var G__50594 = chunk__49618_50583;
var G__50595 = count__49619_50584;
var G__50596 = (i__49620_50585 + (1));
seq__49616_50582 = G__50593;
chunk__49618_50583 = G__50594;
count__49619_50584 = G__50595;
i__49620_50585 = G__50596;
continue;
}
} else {
var temp__5754__auto___50597 = cljs.core.seq(seq__49616_50582);
if(temp__5754__auto___50597){
var seq__49616_50598__$1 = temp__5754__auto___50597;
if(cljs.core.chunked_seq_QMARK_(seq__49616_50598__$1)){
var c__4591__auto___50599 = cljs.core.chunk_first(seq__49616_50598__$1);
var G__50600 = cljs.core.chunk_rest(seq__49616_50598__$1);
var G__50601 = c__4591__auto___50599;
var G__50602 = cljs.core.count(c__4591__auto___50599);
var G__50603 = (0);
seq__49616_50582 = G__50600;
chunk__49618_50583 = G__50601;
count__49619_50584 = G__50602;
i__49620_50585 = G__50603;
continue;
} else {
var child_50605 = cljs.core.first(seq__49616_50598__$1);
if(cljs.core.truth_(child_50605)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50605);


var G__50606 = cljs.core.next(seq__49616_50598__$1);
var G__50607 = null;
var G__50608 = (0);
var G__50609 = (0);
seq__49616_50582 = G__50606;
chunk__49618_50583 = G__50607;
count__49619_50584 = G__50608;
i__49620_50585 = G__50609;
continue;
} else {
var G__50610 = cljs.core.next(seq__49616_50598__$1);
var G__50611 = null;
var G__50612 = (0);
var G__50613 = (0);
seq__49616_50582 = G__50610;
chunk__49618_50583 = G__50611;
count__49619_50584 = G__50612;
i__49620_50585 = G__50613;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50580);
}


var G__50615 = seq__49573_50574;
var G__50616 = chunk__49574_50575;
var G__50617 = count__49575_50576;
var G__50618 = (i__49576_50577 + (1));
seq__49573_50574 = G__50615;
chunk__49574_50575 = G__50616;
count__49575_50576 = G__50617;
i__49576_50577 = G__50618;
continue;
} else {
var temp__5754__auto___50619 = cljs.core.seq(seq__49573_50574);
if(temp__5754__auto___50619){
var seq__49573_50622__$1 = temp__5754__auto___50619;
if(cljs.core.chunked_seq_QMARK_(seq__49573_50622__$1)){
var c__4591__auto___50624 = cljs.core.chunk_first(seq__49573_50622__$1);
var G__50625 = cljs.core.chunk_rest(seq__49573_50622__$1);
var G__50626 = c__4591__auto___50624;
var G__50627 = cljs.core.count(c__4591__auto___50624);
var G__50628 = (0);
seq__49573_50574 = G__50625;
chunk__49574_50575 = G__50626;
count__49575_50576 = G__50627;
i__49576_50577 = G__50628;
continue;
} else {
var child_struct_50629 = cljs.core.first(seq__49573_50622__$1);
var children_50631 = shadow.dom.dom_node(child_struct_50629);
if(cljs.core.seq_QMARK_(children_50631)){
var seq__49647_50632 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50631));
var chunk__49649_50633 = null;
var count__49650_50634 = (0);
var i__49651_50635 = (0);
while(true){
if((i__49651_50635 < count__49650_50634)){
var child_50636 = chunk__49649_50633.cljs$core$IIndexed$_nth$arity$2(null,i__49651_50635);
if(cljs.core.truth_(child_50636)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50636);


var G__50640 = seq__49647_50632;
var G__50641 = chunk__49649_50633;
var G__50642 = count__49650_50634;
var G__50643 = (i__49651_50635 + (1));
seq__49647_50632 = G__50640;
chunk__49649_50633 = G__50641;
count__49650_50634 = G__50642;
i__49651_50635 = G__50643;
continue;
} else {
var G__50646 = seq__49647_50632;
var G__50647 = chunk__49649_50633;
var G__50648 = count__49650_50634;
var G__50649 = (i__49651_50635 + (1));
seq__49647_50632 = G__50646;
chunk__49649_50633 = G__50647;
count__49650_50634 = G__50648;
i__49651_50635 = G__50649;
continue;
}
} else {
var temp__5754__auto___50651__$1 = cljs.core.seq(seq__49647_50632);
if(temp__5754__auto___50651__$1){
var seq__49647_50653__$1 = temp__5754__auto___50651__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49647_50653__$1)){
var c__4591__auto___50655 = cljs.core.chunk_first(seq__49647_50653__$1);
var G__50656 = cljs.core.chunk_rest(seq__49647_50653__$1);
var G__50657 = c__4591__auto___50655;
var G__50658 = cljs.core.count(c__4591__auto___50655);
var G__50659 = (0);
seq__49647_50632 = G__50656;
chunk__49649_50633 = G__50657;
count__49650_50634 = G__50658;
i__49651_50635 = G__50659;
continue;
} else {
var child_50660 = cljs.core.first(seq__49647_50653__$1);
if(cljs.core.truth_(child_50660)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50660);


var G__50661 = cljs.core.next(seq__49647_50653__$1);
var G__50662 = null;
var G__50663 = (0);
var G__50664 = (0);
seq__49647_50632 = G__50661;
chunk__49649_50633 = G__50662;
count__49650_50634 = G__50663;
i__49651_50635 = G__50664;
continue;
} else {
var G__50665 = cljs.core.next(seq__49647_50653__$1);
var G__50666 = null;
var G__50667 = (0);
var G__50668 = (0);
seq__49647_50632 = G__50665;
chunk__49649_50633 = G__50666;
count__49650_50634 = G__50667;
i__49651_50635 = G__50668;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50631);
}


var G__50673 = cljs.core.next(seq__49573_50622__$1);
var G__50674 = null;
var G__50675 = (0);
var G__50676 = (0);
seq__49573_50574 = G__50673;
chunk__49574_50575 = G__50674;
count__49575_50576 = G__50675;
i__49576_50577 = G__50676;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__49687 = cljs.core.seq(node);
var chunk__49688 = null;
var count__49689 = (0);
var i__49690 = (0);
while(true){
if((i__49690 < count__49689)){
var n = chunk__49688.cljs$core$IIndexed$_nth$arity$2(null,i__49690);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50681 = seq__49687;
var G__50682 = chunk__49688;
var G__50683 = count__49689;
var G__50684 = (i__49690 + (1));
seq__49687 = G__50681;
chunk__49688 = G__50682;
count__49689 = G__50683;
i__49690 = G__50684;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49687);
if(temp__5754__auto__){
var seq__49687__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49687__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49687__$1);
var G__50686 = cljs.core.chunk_rest(seq__49687__$1);
var G__50687 = c__4591__auto__;
var G__50688 = cljs.core.count(c__4591__auto__);
var G__50689 = (0);
seq__49687 = G__50686;
chunk__49688 = G__50687;
count__49689 = G__50688;
i__49690 = G__50689;
continue;
} else {
var n = cljs.core.first(seq__49687__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50691 = cljs.core.next(seq__49687__$1);
var G__50692 = null;
var G__50693 = (0);
var G__50694 = (0);
seq__49687 = G__50691;
chunk__49688 = G__50692;
count__49689 = G__50693;
i__49690 = G__50694;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49719 = arguments.length;
switch (G__49719) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49739 = arguments.length;
switch (G__49739) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49783 = arguments.length;
switch (G__49783) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4160__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4777__auto__ = [];
var len__4771__auto___50735 = arguments.length;
var i__4772__auto___50736 = (0);
while(true){
if((i__4772__auto___50736 < len__4771__auto___50735)){
args__4777__auto__.push((arguments[i__4772__auto___50736]));

var G__50739 = (i__4772__auto___50736 + (1));
i__4772__auto___50736 = G__50739;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49814_50742 = cljs.core.seq(nodes);
var chunk__49815_50743 = null;
var count__49816_50744 = (0);
var i__49817_50745 = (0);
while(true){
if((i__49817_50745 < count__49816_50744)){
var node_50746 = chunk__49815_50743.cljs$core$IIndexed$_nth$arity$2(null,i__49817_50745);
fragment.appendChild(shadow.dom._to_dom(node_50746));


var G__50750 = seq__49814_50742;
var G__50751 = chunk__49815_50743;
var G__50752 = count__49816_50744;
var G__50753 = (i__49817_50745 + (1));
seq__49814_50742 = G__50750;
chunk__49815_50743 = G__50751;
count__49816_50744 = G__50752;
i__49817_50745 = G__50753;
continue;
} else {
var temp__5754__auto___50759 = cljs.core.seq(seq__49814_50742);
if(temp__5754__auto___50759){
var seq__49814_50760__$1 = temp__5754__auto___50759;
if(cljs.core.chunked_seq_QMARK_(seq__49814_50760__$1)){
var c__4591__auto___50761 = cljs.core.chunk_first(seq__49814_50760__$1);
var G__50762 = cljs.core.chunk_rest(seq__49814_50760__$1);
var G__50763 = c__4591__auto___50761;
var G__50764 = cljs.core.count(c__4591__auto___50761);
var G__50765 = (0);
seq__49814_50742 = G__50762;
chunk__49815_50743 = G__50763;
count__49816_50744 = G__50764;
i__49817_50745 = G__50765;
continue;
} else {
var node_50766 = cljs.core.first(seq__49814_50760__$1);
fragment.appendChild(shadow.dom._to_dom(node_50766));


var G__50768 = cljs.core.next(seq__49814_50760__$1);
var G__50769 = null;
var G__50770 = (0);
var G__50771 = (0);
seq__49814_50742 = G__50768;
chunk__49815_50743 = G__50769;
count__49816_50744 = G__50770;
i__49817_50745 = G__50771;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49809){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49809));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49830_50777 = cljs.core.seq(scripts);
var chunk__49831_50778 = null;
var count__49832_50779 = (0);
var i__49833_50780 = (0);
while(true){
if((i__49833_50780 < count__49832_50779)){
var vec__49850_50781 = chunk__49831_50778.cljs$core$IIndexed$_nth$arity$2(null,i__49833_50780);
var script_tag_50782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49850_50781,(0),null);
var script_body_50783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49850_50781,(1),null);
eval(script_body_50783);


var G__50789 = seq__49830_50777;
var G__50790 = chunk__49831_50778;
var G__50791 = count__49832_50779;
var G__50792 = (i__49833_50780 + (1));
seq__49830_50777 = G__50789;
chunk__49831_50778 = G__50790;
count__49832_50779 = G__50791;
i__49833_50780 = G__50792;
continue;
} else {
var temp__5754__auto___50797 = cljs.core.seq(seq__49830_50777);
if(temp__5754__auto___50797){
var seq__49830_50799__$1 = temp__5754__auto___50797;
if(cljs.core.chunked_seq_QMARK_(seq__49830_50799__$1)){
var c__4591__auto___50800 = cljs.core.chunk_first(seq__49830_50799__$1);
var G__50803 = cljs.core.chunk_rest(seq__49830_50799__$1);
var G__50804 = c__4591__auto___50800;
var G__50805 = cljs.core.count(c__4591__auto___50800);
var G__50806 = (0);
seq__49830_50777 = G__50803;
chunk__49831_50778 = G__50804;
count__49832_50779 = G__50805;
i__49833_50780 = G__50806;
continue;
} else {
var vec__49855_50807 = cljs.core.first(seq__49830_50799__$1);
var script_tag_50808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49855_50807,(0),null);
var script_body_50809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49855_50807,(1),null);
eval(script_body_50809);


var G__50818 = cljs.core.next(seq__49830_50799__$1);
var G__50819 = null;
var G__50820 = (0);
var G__50821 = (0);
seq__49830_50777 = G__50818;
chunk__49831_50778 = G__50819;
count__49832_50779 = G__50820;
i__49833_50780 = G__50821;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49859){
var vec__49861 = p__49859;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49861,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49861,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49880 = arguments.length;
switch (G__49880) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49926 = cljs.core.seq(style_keys);
var chunk__49927 = null;
var count__49928 = (0);
var i__49929 = (0);
while(true){
if((i__49929 < count__49928)){
var it = chunk__49927.cljs$core$IIndexed$_nth$arity$2(null,i__49929);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50851 = seq__49926;
var G__50852 = chunk__49927;
var G__50853 = count__49928;
var G__50854 = (i__49929 + (1));
seq__49926 = G__50851;
chunk__49927 = G__50852;
count__49928 = G__50853;
i__49929 = G__50854;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__49926);
if(temp__5754__auto__){
var seq__49926__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49926__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__49926__$1);
var G__50855 = cljs.core.chunk_rest(seq__49926__$1);
var G__50856 = c__4591__auto__;
var G__50857 = cljs.core.count(c__4591__auto__);
var G__50858 = (0);
seq__49926 = G__50855;
chunk__49927 = G__50856;
count__49928 = G__50857;
i__49929 = G__50858;
continue;
} else {
var it = cljs.core.first(seq__49926__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50863 = cljs.core.next(seq__49926__$1);
var G__50864 = null;
var G__50865 = (0);
var G__50866 = (0);
seq__49926 = G__50863;
chunk__49927 = G__50864;
count__49928 = G__50865;
i__49929 = G__50866;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k49939,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__49954 = k49939;
var G__49954__$1 = (((G__49954 instanceof cljs.core.Keyword))?G__49954.fqn:null);
switch (G__49954__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49939,else__4418__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__49963){
var vec__49965 = p__49963;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49965,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49965,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49938){
var self__ = this;
var G__49938__$1 = this;
return (new cljs.core.RecordIter((0),G__49938__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49940,other49941){
var self__ = this;
var this49940__$1 = this;
return (((!((other49941 == null)))) && ((this49940__$1.constructor === other49941.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49940__$1.x,other49941.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49940__$1.y,other49941.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49940__$1.__extmap,other49941.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__49938){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__50003 = cljs.core.keyword_identical_QMARK_;
var expr__50004 = k__4423__auto__;
if(cljs.core.truth_((pred__50003.cljs$core$IFn$_invoke$arity$2 ? pred__50003.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__50004) : pred__50003.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__50004)))){
return (new shadow.dom.Coordinate(G__49938,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__50003.cljs$core$IFn$_invoke$arity$2 ? pred__50003.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__50004) : pred__50003.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__50004)))){
return (new shadow.dom.Coordinate(self__.x,G__49938,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__49938),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__49938){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49938,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49943){
var extmap__4454__auto__ = (function (){var G__50027 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49943,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49943)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__50027);
} else {
return G__50027;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49943),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49943),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k50045,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__50055 = k50045;
var G__50055__$1 = (((G__50055 instanceof cljs.core.Keyword))?G__50055.fqn:null);
switch (G__50055__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k50045,else__4418__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__50059){
var vec__50060 = p__50059;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50060,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50060,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Size{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50044){
var self__ = this;
var G__50044__$1 = this;
return (new cljs.core.RecordIter((0),G__50044__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50046,other50047){
var self__ = this;
var this50046__$1 = this;
return (((!((other50047 == null)))) && ((this50046__$1.constructor === other50047.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50046__$1.w,other50047.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50046__$1.h,other50047.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50046__$1.__extmap,other50047.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__50044){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__50078 = cljs.core.keyword_identical_QMARK_;
var expr__50079 = k__4423__auto__;
if(cljs.core.truth_((pred__50078.cljs$core$IFn$_invoke$arity$2 ? pred__50078.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__50079) : pred__50078.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__50079)))){
return (new shadow.dom.Size(G__50044,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__50078.cljs$core$IFn$_invoke$arity$2 ? pred__50078.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__50079) : pred__50078.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__50079)))){
return (new shadow.dom.Size(self__.w,G__50044,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__50044),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__50044){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__50044,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__50049){
var extmap__4454__auto__ = (function (){var G__50093 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__50049,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__50049)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__50093);
} else {
return G__50093;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__50049),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__50049),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4645__auto__ = opts;
var l__4646__auto__ = a__4645__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4646__auto__)){
var G__50971 = (i + (1));
var G__50972 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50971;
ret = G__50972;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__50119){
var vec__50124 = p__50119;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50124,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50124,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__50131 = arguments.length;
switch (G__50131) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5752__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5752__auto__)){
var child = temp__5752__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50984 = ps;
var G__50985 = (i + (1));
el__$1 = G__50984;
i = G__50985;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__50168 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50168,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50168,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50168,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__50175_50996 = cljs.core.seq(props);
var chunk__50176_50997 = null;
var count__50177_50998 = (0);
var i__50178_50999 = (0);
while(true){
if((i__50178_50999 < count__50177_50998)){
var vec__50198_51000 = chunk__50176_50997.cljs$core$IIndexed$_nth$arity$2(null,i__50178_50999);
var k_51001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50198_51000,(0),null);
var v_51002 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50198_51000,(1),null);
el.setAttributeNS((function (){var temp__5754__auto__ = cljs.core.namespace(k_51001);
if(cljs.core.truth_(temp__5754__auto__)){
var ns = temp__5754__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_51001),v_51002);


var G__51004 = seq__50175_50996;
var G__51005 = chunk__50176_50997;
var G__51006 = count__50177_50998;
var G__51007 = (i__50178_50999 + (1));
seq__50175_50996 = G__51004;
chunk__50176_50997 = G__51005;
count__50177_50998 = G__51006;
i__50178_50999 = G__51007;
continue;
} else {
var temp__5754__auto___51008 = cljs.core.seq(seq__50175_50996);
if(temp__5754__auto___51008){
var seq__50175_51009__$1 = temp__5754__auto___51008;
if(cljs.core.chunked_seq_QMARK_(seq__50175_51009__$1)){
var c__4591__auto___51010 = cljs.core.chunk_first(seq__50175_51009__$1);
var G__51011 = cljs.core.chunk_rest(seq__50175_51009__$1);
var G__51012 = c__4591__auto___51010;
var G__51013 = cljs.core.count(c__4591__auto___51010);
var G__51014 = (0);
seq__50175_50996 = G__51011;
chunk__50176_50997 = G__51012;
count__50177_50998 = G__51013;
i__50178_50999 = G__51014;
continue;
} else {
var vec__50208_51015 = cljs.core.first(seq__50175_51009__$1);
var k_51016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50208_51015,(0),null);
var v_51017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50208_51015,(1),null);
el.setAttributeNS((function (){var temp__5754__auto____$1 = cljs.core.namespace(k_51016);
if(cljs.core.truth_(temp__5754__auto____$1)){
var ns = temp__5754__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_51016),v_51017);


var G__51022 = cljs.core.next(seq__50175_51009__$1);
var G__51023 = null;
var G__51024 = (0);
var G__51025 = (0);
seq__50175_50996 = G__51022;
chunk__50176_50997 = G__51023;
count__50177_50998 = G__51024;
i__50178_50999 = G__51025;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__50220 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50220,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50220,(1),null);
var seq__50223_51030 = cljs.core.seq(node_children);
var chunk__50225_51031 = null;
var count__50226_51032 = (0);
var i__50227_51033 = (0);
while(true){
if((i__50227_51033 < count__50226_51032)){
var child_struct_51034 = chunk__50225_51031.cljs$core$IIndexed$_nth$arity$2(null,i__50227_51033);
if((!((child_struct_51034 == null)))){
if(typeof child_struct_51034 === 'string'){
var text_51035 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51035),child_struct_51034].join(''));
} else {
var children_51036 = shadow.dom.svg_node(child_struct_51034);
if(cljs.core.seq_QMARK_(children_51036)){
var seq__50262_51037 = cljs.core.seq(children_51036);
var chunk__50264_51038 = null;
var count__50265_51039 = (0);
var i__50266_51040 = (0);
while(true){
if((i__50266_51040 < count__50265_51039)){
var child_51041 = chunk__50264_51038.cljs$core$IIndexed$_nth$arity$2(null,i__50266_51040);
if(cljs.core.truth_(child_51041)){
node.appendChild(child_51041);


var G__51042 = seq__50262_51037;
var G__51043 = chunk__50264_51038;
var G__51044 = count__50265_51039;
var G__51045 = (i__50266_51040 + (1));
seq__50262_51037 = G__51042;
chunk__50264_51038 = G__51043;
count__50265_51039 = G__51044;
i__50266_51040 = G__51045;
continue;
} else {
var G__51046 = seq__50262_51037;
var G__51047 = chunk__50264_51038;
var G__51048 = count__50265_51039;
var G__51049 = (i__50266_51040 + (1));
seq__50262_51037 = G__51046;
chunk__50264_51038 = G__51047;
count__50265_51039 = G__51048;
i__50266_51040 = G__51049;
continue;
}
} else {
var temp__5754__auto___51050 = cljs.core.seq(seq__50262_51037);
if(temp__5754__auto___51050){
var seq__50262_51051__$1 = temp__5754__auto___51050;
if(cljs.core.chunked_seq_QMARK_(seq__50262_51051__$1)){
var c__4591__auto___51052 = cljs.core.chunk_first(seq__50262_51051__$1);
var G__51054 = cljs.core.chunk_rest(seq__50262_51051__$1);
var G__51055 = c__4591__auto___51052;
var G__51056 = cljs.core.count(c__4591__auto___51052);
var G__51057 = (0);
seq__50262_51037 = G__51054;
chunk__50264_51038 = G__51055;
count__50265_51039 = G__51056;
i__50266_51040 = G__51057;
continue;
} else {
var child_51059 = cljs.core.first(seq__50262_51051__$1);
if(cljs.core.truth_(child_51059)){
node.appendChild(child_51059);


var G__51060 = cljs.core.next(seq__50262_51051__$1);
var G__51061 = null;
var G__51062 = (0);
var G__51063 = (0);
seq__50262_51037 = G__51060;
chunk__50264_51038 = G__51061;
count__50265_51039 = G__51062;
i__50266_51040 = G__51063;
continue;
} else {
var G__51064 = cljs.core.next(seq__50262_51051__$1);
var G__51065 = null;
var G__51066 = (0);
var G__51067 = (0);
seq__50262_51037 = G__51064;
chunk__50264_51038 = G__51065;
count__50265_51039 = G__51066;
i__50266_51040 = G__51067;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51036);
}
}


var G__51069 = seq__50223_51030;
var G__51070 = chunk__50225_51031;
var G__51071 = count__50226_51032;
var G__51072 = (i__50227_51033 + (1));
seq__50223_51030 = G__51069;
chunk__50225_51031 = G__51070;
count__50226_51032 = G__51071;
i__50227_51033 = G__51072;
continue;
} else {
var G__51073 = seq__50223_51030;
var G__51074 = chunk__50225_51031;
var G__51075 = count__50226_51032;
var G__51076 = (i__50227_51033 + (1));
seq__50223_51030 = G__51073;
chunk__50225_51031 = G__51074;
count__50226_51032 = G__51075;
i__50227_51033 = G__51076;
continue;
}
} else {
var temp__5754__auto___51078 = cljs.core.seq(seq__50223_51030);
if(temp__5754__auto___51078){
var seq__50223_51079__$1 = temp__5754__auto___51078;
if(cljs.core.chunked_seq_QMARK_(seq__50223_51079__$1)){
var c__4591__auto___51080 = cljs.core.chunk_first(seq__50223_51079__$1);
var G__51081 = cljs.core.chunk_rest(seq__50223_51079__$1);
var G__51082 = c__4591__auto___51080;
var G__51083 = cljs.core.count(c__4591__auto___51080);
var G__51084 = (0);
seq__50223_51030 = G__51081;
chunk__50225_51031 = G__51082;
count__50226_51032 = G__51083;
i__50227_51033 = G__51084;
continue;
} else {
var child_struct_51085 = cljs.core.first(seq__50223_51079__$1);
if((!((child_struct_51085 == null)))){
if(typeof child_struct_51085 === 'string'){
var text_51086 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51086),child_struct_51085].join(''));
} else {
var children_51087 = shadow.dom.svg_node(child_struct_51085);
if(cljs.core.seq_QMARK_(children_51087)){
var seq__50287_51088 = cljs.core.seq(children_51087);
var chunk__50289_51089 = null;
var count__50290_51090 = (0);
var i__50291_51091 = (0);
while(true){
if((i__50291_51091 < count__50290_51090)){
var child_51092 = chunk__50289_51089.cljs$core$IIndexed$_nth$arity$2(null,i__50291_51091);
if(cljs.core.truth_(child_51092)){
node.appendChild(child_51092);


var G__51093 = seq__50287_51088;
var G__51094 = chunk__50289_51089;
var G__51095 = count__50290_51090;
var G__51096 = (i__50291_51091 + (1));
seq__50287_51088 = G__51093;
chunk__50289_51089 = G__51094;
count__50290_51090 = G__51095;
i__50291_51091 = G__51096;
continue;
} else {
var G__51097 = seq__50287_51088;
var G__51098 = chunk__50289_51089;
var G__51099 = count__50290_51090;
var G__51100 = (i__50291_51091 + (1));
seq__50287_51088 = G__51097;
chunk__50289_51089 = G__51098;
count__50290_51090 = G__51099;
i__50291_51091 = G__51100;
continue;
}
} else {
var temp__5754__auto___51101__$1 = cljs.core.seq(seq__50287_51088);
if(temp__5754__auto___51101__$1){
var seq__50287_51102__$1 = temp__5754__auto___51101__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50287_51102__$1)){
var c__4591__auto___51103 = cljs.core.chunk_first(seq__50287_51102__$1);
var G__51104 = cljs.core.chunk_rest(seq__50287_51102__$1);
var G__51105 = c__4591__auto___51103;
var G__51106 = cljs.core.count(c__4591__auto___51103);
var G__51107 = (0);
seq__50287_51088 = G__51104;
chunk__50289_51089 = G__51105;
count__50290_51090 = G__51106;
i__50291_51091 = G__51107;
continue;
} else {
var child_51111 = cljs.core.first(seq__50287_51102__$1);
if(cljs.core.truth_(child_51111)){
node.appendChild(child_51111);


var G__51112 = cljs.core.next(seq__50287_51102__$1);
var G__51113 = null;
var G__51114 = (0);
var G__51115 = (0);
seq__50287_51088 = G__51112;
chunk__50289_51089 = G__51113;
count__50290_51090 = G__51114;
i__50291_51091 = G__51115;
continue;
} else {
var G__51116 = cljs.core.next(seq__50287_51102__$1);
var G__51117 = null;
var G__51118 = (0);
var G__51119 = (0);
seq__50287_51088 = G__51116;
chunk__50289_51089 = G__51117;
count__50290_51090 = G__51118;
i__50291_51091 = G__51119;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51087);
}
}


var G__51120 = cljs.core.next(seq__50223_51079__$1);
var G__51121 = null;
var G__51122 = (0);
var G__51123 = (0);
seq__50223_51030 = G__51120;
chunk__50225_51031 = G__51121;
count__50226_51032 = G__51122;
i__50227_51033 = G__51123;
continue;
} else {
var G__51124 = cljs.core.next(seq__50223_51079__$1);
var G__51125 = null;
var G__51126 = (0);
var G__51127 = (0);
seq__50223_51030 = G__51124;
chunk__50225_51031 = G__51125;
count__50226_51032 = G__51126;
i__50227_51033 = G__51127;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4777__auto__ = [];
var len__4771__auto___51129 = arguments.length;
var i__4772__auto___51130 = (0);
while(true){
if((i__4772__auto___51130 < len__4771__auto___51129)){
args__4777__auto__.push((arguments[i__4772__auto___51130]));

var G__51131 = (i__4772__auto___51130 + (1));
i__4772__auto___51130 = G__51131;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq50315){
var G__50316 = cljs.core.first(seq50315);
var seq50315__$1 = cljs.core.next(seq50315);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50316,seq50315__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__50329 = arguments.length;
switch (G__50329) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4149__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4149__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4149__auto__;
}
})())){
var c__47046__auto___51139 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_50347){
var state_val_50348 = (state_50347[(1)]);
if((state_val_50348 === (1))){
var state_50347__$1 = state_50347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50347__$1,(2),once_or_cleanup);
} else {
if((state_val_50348 === (2))){
var inst_50343 = (state_50347[(2)]);
var inst_50344 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_50347__$1 = (function (){var statearr_50354 = state_50347;
(statearr_50354[(7)] = inst_50343);

return statearr_50354;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50347__$1,inst_50344);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__46357__auto__ = null;
var shadow$dom$state_machine__46357__auto____0 = (function (){
var statearr_50355 = [null,null,null,null,null,null,null,null];
(statearr_50355[(0)] = shadow$dom$state_machine__46357__auto__);

(statearr_50355[(1)] = (1));

return statearr_50355;
});
var shadow$dom$state_machine__46357__auto____1 = (function (state_50347){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_50347);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e50360){var ex__46360__auto__ = e50360;
var statearr_50362_51140 = state_50347;
(statearr_50362_51140[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_50347[(4)]))){
var statearr_50364_51141 = state_50347;
(statearr_50364_51141[(1)] = cljs.core.first((state_50347[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51142 = state_50347;
state_50347 = G__51142;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
shadow$dom$state_machine__46357__auto__ = function(state_50347){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__46357__auto____0.call(this);
case 1:
return shadow$dom$state_machine__46357__auto____1.call(this,state_50347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__46357__auto____0;
shadow$dom$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__46357__auto____1;
return shadow$dom$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_50368 = f__47047__auto__();
(statearr_50368[(6)] = c__47046__auto___51139);

return statearr_50368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
