goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e55205){var e = e55205;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4777__auto__ = [];
var len__4771__auto___55351 = arguments.length;
var i__4772__auto___55352 = (0);
while(true){
if((i__4772__auto___55352 < len__4771__auto___55351)){
args__4777__auto__.push((arguments[i__4772__auto___55352]));

var G__55353 = (i__4772__auto___55352 + (1));
i__4772__auto___55352 = G__55353;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__55218){
var vec__55219 = p__55218;
var map__55222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55219,(0),null);
var map__55222__$1 = cljs.core.__destructure_map(map__55222);
var opts = map__55222__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55222__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55222__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55222__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55222__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__55224 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4160__auto__ = read_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4160__auto__ = write_ch;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__55224__$1 = cljs.core.__destructure_map(map__55224);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55224__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55224__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__55208_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__55208_SHARP_);
}));

(web_socket.onclose = (function (p1__55209_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__55209_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__47046__auto___55354 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_55297){
var state_val_55298 = (state_55297[(1)]);
if((state_val_55298 === (7))){
var inst_55293 = (state_55297[(2)]);
var state_55297__$1 = state_55297;
var statearr_55299_55355 = state_55297__$1;
(statearr_55299_55355[(2)] = inst_55293);

(statearr_55299_55355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (20))){
var state_55297__$1 = state_55297;
var statearr_55300_55356 = state_55297__$1;
(statearr_55300_55356[(2)] = null);

(statearr_55300_55356[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (1))){
var inst_55227 = false;
var state_55297__$1 = (function (){var statearr_55301 = state_55297;
(statearr_55301[(7)] = inst_55227);

return statearr_55301;
})();
var statearr_55302_55357 = state_55297__$1;
(statearr_55302_55357[(2)] = null);

(statearr_55302_55357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (4))){
var inst_55237 = (state_55297[(8)]);
var inst_55245 = (state_55297[(9)]);
var inst_55243 = (state_55297[(10)]);
var inst_55243__$1 = (state_55297[(2)]);
var inst_55244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55243__$1,(0),null);
var inst_55245__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55243__$1,(1),null);
var inst_55246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55245__$1,inst_55237);
var state_55297__$1 = (function (){var statearr_55303 = state_55297;
(statearr_55303[(9)] = inst_55245__$1);

(statearr_55303[(10)] = inst_55243__$1);

(statearr_55303[(11)] = inst_55244);

return statearr_55303;
})();
if(inst_55246){
var statearr_55304_55361 = state_55297__$1;
(statearr_55304_55361[(1)] = (5));

} else {
var statearr_55305_55362 = state_55297__$1;
(statearr_55305_55362[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (15))){
var inst_55277 = (state_55297[(2)]);
var state_55297__$1 = state_55297;
var statearr_55307_55363 = state_55297__$1;
(statearr_55307_55363[(2)] = inst_55277);

(statearr_55307_55363[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (21))){
var inst_55289 = (state_55297[(2)]);
var state_55297__$1 = state_55297;
var statearr_55310_55364 = state_55297__$1;
(statearr_55310_55364[(2)] = inst_55289);

(statearr_55310_55364[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (13))){
var state_55297__$1 = state_55297;
var statearr_55311_55367 = state_55297__$1;
(statearr_55311_55367[(2)] = null);

(statearr_55311_55367[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (6))){
var inst_55245 = (state_55297[(9)]);
var inst_55238 = (state_55297[(12)]);
var inst_55261 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55245,inst_55238);
var state_55297__$1 = state_55297;
if(inst_55261){
var statearr_55312_55369 = state_55297__$1;
(statearr_55312_55369[(1)] = (9));

} else {
var statearr_55313_55370 = state_55297__$1;
(statearr_55313_55370[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (17))){
var state_55297__$1 = state_55297;
var statearr_55314_55371 = state_55297__$1;
(statearr_55314_55371[(2)] = initial_ch);

(statearr_55314_55371[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (3))){
var inst_55295 = (state_55297[(2)]);
var state_55297__$1 = state_55297;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55297__$1,inst_55295);
} else {
if((state_val_55298 === (12))){
var inst_55227 = (state_55297[(7)]);
var state_55297__$1 = state_55297;
if(cljs.core.truth_(inst_55227)){
var statearr_55315_55375 = state_55297__$1;
(statearr_55315_55375[(1)] = (16));

} else {
var statearr_55317_55376 = state_55297__$1;
(statearr_55317_55376[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (2))){
var inst_55237 = (state_55297[(8)]);
var inst_55238 = (state_55297[(12)]);
var inst_55237__$1 = open_ch;
var inst_55238__$1 = close_ch;
var inst_55239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55240 = [inst_55237__$1,inst_55238__$1];
var inst_55241 = (new cljs.core.PersistentVector(null,2,(5),inst_55239,inst_55240,null));
var state_55297__$1 = (function (){var statearr_55318 = state_55297;
(statearr_55318[(8)] = inst_55237__$1);

(statearr_55318[(12)] = inst_55238__$1);

return statearr_55318;
})();
return cljs.core.async.ioc_alts_BANG_(state_55297__$1,(4),inst_55241);
} else {
if((state_val_55298 === (19))){
var inst_55244 = (state_55297[(11)]);
var state_55297__$1 = state_55297;
var statearr_55320_55381 = state_55297__$1;
(statearr_55320_55381[(2)] = inst_55244);

(statearr_55320_55381[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (11))){
var inst_55291 = (state_55297[(2)]);
var state_55297__$1 = state_55297;
var statearr_55321_55383 = state_55297__$1;
(statearr_55321_55383[(2)] = inst_55291);

(statearr_55321_55383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (9))){
var inst_55243 = (state_55297[(10)]);
var inst_55267 = (state_55297[(13)]);
var inst_55266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55243,(0),null);
var inst_55267__$1 = chord.client.close_event__GT_maybe_error(inst_55266);
var state_55297__$1 = (function (){var statearr_55323 = state_55297;
(statearr_55323[(13)] = inst_55267__$1);

return statearr_55323;
})();
if(cljs.core.truth_(inst_55267__$1)){
var statearr_55324_55385 = state_55297__$1;
(statearr_55324_55385[(1)] = (12));

} else {
var statearr_55325_55386 = state_55297__$1;
(statearr_55325_55386[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (5))){
var inst_55243 = (state_55297[(10)]);
var inst_55251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55243,(0),null);
var inst_55252 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_55254 = [ws_chan];
var inst_55255 = cljs.core.PersistentHashMap.fromArrays(inst_55252,inst_55254);
var state_55297__$1 = (function (){var statearr_55327 = state_55297;
(statearr_55327[(14)] = inst_55251);

return statearr_55327;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_55297__$1,(8),initial_ch,inst_55255);
} else {
if((state_val_55298 === (14))){
var inst_55280 = (state_55297[(2)]);
var inst_55281 = cljs.core.async.close_BANG_(ws_chan);
var inst_55282 = cljs.core.async.close_BANG_(initial_ch);
var state_55297__$1 = (function (){var statearr_55329 = state_55297;
(statearr_55329[(15)] = inst_55280);

(statearr_55329[(16)] = inst_55281);

return statearr_55329;
})();
var statearr_55330_55388 = state_55297__$1;
(statearr_55330_55388[(2)] = inst_55282);

(statearr_55330_55388[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (16))){
var state_55297__$1 = state_55297;
var statearr_55331_55389 = state_55297__$1;
(statearr_55331_55389[(2)] = read_ch__$1);

(statearr_55331_55389[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (10))){
var inst_55245 = (state_55297[(9)]);
var inst_55284 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_55245,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_55297__$1 = state_55297;
if(inst_55284){
var statearr_55332_55391 = state_55297__$1;
(statearr_55332_55391[(1)] = (19));

} else {
var statearr_55333_55392 = state_55297__$1;
(statearr_55333_55392[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55298 === (18))){
var inst_55267 = (state_55297[(13)]);
var inst_55272 = (state_55297[(2)]);
var inst_55273 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_55274 = [inst_55267];
var inst_55275 = cljs.core.PersistentHashMap.fromArrays(inst_55273,inst_55274);
var state_55297__$1 = state_55297;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_55297__$1,(15),inst_55272,inst_55275);
} else {
if((state_val_55298 === (8))){
var inst_55257 = (state_55297[(2)]);
var inst_55258 = cljs.core.async.close_BANG_(initial_ch);
var inst_55227 = true;
var state_55297__$1 = (function (){var statearr_55334 = state_55297;
(statearr_55334[(17)] = inst_55257);

(statearr_55334[(18)] = inst_55258);

(statearr_55334[(7)] = inst_55227);

return statearr_55334;
})();
var statearr_55338_55395 = state_55297__$1;
(statearr_55338_55395[(2)] = null);

(statearr_55338_55395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__46357__auto__ = null;
var chord$client$state_machine__46357__auto____0 = (function (){
var statearr_55339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55339[(0)] = chord$client$state_machine__46357__auto__);

(statearr_55339[(1)] = (1));

return statearr_55339;
});
var chord$client$state_machine__46357__auto____1 = (function (state_55297){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_55297);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e55340){var ex__46360__auto__ = e55340;
var statearr_55344_55396 = state_55297;
(statearr_55344_55396[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_55297[(4)]))){
var statearr_55345_55397 = state_55297;
(statearr_55345_55397[(1)] = cljs.core.first((state_55297[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55398 = state_55297;
state_55297 = G__55398;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
chord$client$state_machine__46357__auto__ = function(state_55297){
switch(arguments.length){
case 0:
return chord$client$state_machine__46357__auto____0.call(this);
case 1:
return chord$client$state_machine__46357__auto____1.call(this,state_55297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__46357__auto____0;
chord$client$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__46357__auto____1;
return chord$client$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_55348 = f__47047__auto__();
(statearr_55348[(6)] = c__47046__auto___55354);

return statearr_55348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq55211){
var G__55212 = cljs.core.first(seq55211);
var seq55211__$1 = cljs.core.next(seq55211);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55212,seq55211__$1);
}));


//# sourceMappingURL=chord.client.js.map
