goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44103 = arguments.length;
switch (G__44103) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44109 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44109 = (function (f,blockable,meta44110){
this.f = f;
this.blockable = blockable;
this.meta44110 = meta44110;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44109.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44111,meta44110__$1){
var self__ = this;
var _44111__$1 = this;
return (new cljs.core.async.t_cljs$core$async44109(self__.f,self__.blockable,meta44110__$1));
}));

(cljs.core.async.t_cljs$core$async44109.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44111){
var self__ = this;
var _44111__$1 = this;
return self__.meta44110;
}));

(cljs.core.async.t_cljs$core$async44109.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44109.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44109.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44109.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44109.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44110","meta44110",1606457985,null)], null);
}));

(cljs.core.async.t_cljs$core$async44109.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44109.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44109");

(cljs.core.async.t_cljs$core$async44109.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44109");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44109.
 */
cljs.core.async.__GT_t_cljs$core$async44109 = (function cljs$core$async$__GT_t_cljs$core$async44109(f__$1,blockable__$1,meta44110){
return (new cljs.core.async.t_cljs$core$async44109(f__$1,blockable__$1,meta44110));
});

}

return (new cljs.core.async.t_cljs$core$async44109(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44210 = arguments.length;
switch (G__44210) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44229 = arguments.length;
switch (G__44229) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44249 = arguments.length;
switch (G__44249) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_46874 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46874) : fn1.call(null,val_46874));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46874) : fn1.call(null,val_46874));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44259 = arguments.length;
switch (G__44259) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___46882 = n;
var x_46883 = (0);
while(true){
if((x_46883 < n__4613__auto___46882)){
(a[x_46883] = x_46883);

var G__46884 = (x_46883 + (1));
x_46883 = G__46884;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44282 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44282 = (function (flag,meta44283){
this.flag = flag;
this.meta44283 = meta44283;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44282.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44284,meta44283__$1){
var self__ = this;
var _44284__$1 = this;
return (new cljs.core.async.t_cljs$core$async44282(self__.flag,meta44283__$1));
}));

(cljs.core.async.t_cljs$core$async44282.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44284){
var self__ = this;
var _44284__$1 = this;
return self__.meta44283;
}));

(cljs.core.async.t_cljs$core$async44282.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44282.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44282.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44282.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44282.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44283","meta44283",-2077106784,null)], null);
}));

(cljs.core.async.t_cljs$core$async44282.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44282.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44282");

(cljs.core.async.t_cljs$core$async44282.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44282");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44282.
 */
cljs.core.async.__GT_t_cljs$core$async44282 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44282(flag__$1,meta44283){
return (new cljs.core.async.t_cljs$core$async44282(flag__$1,meta44283));
});

}

return (new cljs.core.async.t_cljs$core$async44282(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44298 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44298 = (function (flag,cb,meta44299){
this.flag = flag;
this.cb = cb;
this.meta44299 = meta44299;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44298.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44300,meta44299__$1){
var self__ = this;
var _44300__$1 = this;
return (new cljs.core.async.t_cljs$core$async44298(self__.flag,self__.cb,meta44299__$1));
}));

(cljs.core.async.t_cljs$core$async44298.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44300){
var self__ = this;
var _44300__$1 = this;
return self__.meta44299;
}));

(cljs.core.async.t_cljs$core$async44298.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44298.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44298.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44298.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44298.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44299","meta44299",1862008998,null)], null);
}));

(cljs.core.async.t_cljs$core$async44298.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44298.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44298");

(cljs.core.async.t_cljs$core$async44298.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async44298");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44298.
 */
cljs.core.async.__GT_t_cljs$core$async44298 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44298(flag__$1,cb__$1,meta44299){
return (new cljs.core.async.t_cljs$core$async44298(flag__$1,cb__$1,meta44299));
});

}

return (new cljs.core.async.t_cljs$core$async44298(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44321_SHARP_){
var G__44323 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44321_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44323) : fret.call(null,G__44323));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44322_SHARP_){
var G__44328 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44322_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44328) : fret.call(null,G__44328));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46904 = (i + (1));
i = G__46904;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46910 = arguments.length;
var i__4737__auto___46911 = (0);
while(true){
if((i__4737__auto___46911 < len__4736__auto___46910)){
args__4742__auto__.push((arguments[i__4737__auto___46911]));

var G__46913 = (i__4737__auto___46911 + (1));
i__4737__auto___46911 = G__46913;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44335){
var map__44336 = p__44335;
var map__44336__$1 = (((((!((map__44336 == null))))?(((((map__44336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44336.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44336):map__44336);
var opts = map__44336__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44329){
var G__44330 = cljs.core.first(seq44329);
var seq44329__$1 = cljs.core.next(seq44329);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44330,seq44329__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44344 = arguments.length;
switch (G__44344) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44004__auto___46919 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44396){
var state_val_44397 = (state_44396[(1)]);
if((state_val_44397 === (7))){
var inst_44392 = (state_44396[(2)]);
var state_44396__$1 = state_44396;
var statearr_44400_46921 = state_44396__$1;
(statearr_44400_46921[(2)] = inst_44392);

(statearr_44400_46921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (1))){
var state_44396__$1 = state_44396;
var statearr_44401_46922 = state_44396__$1;
(statearr_44401_46922[(2)] = null);

(statearr_44401_46922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (4))){
var inst_44363 = (state_44396[(7)]);
var inst_44363__$1 = (state_44396[(2)]);
var inst_44364 = (inst_44363__$1 == null);
var state_44396__$1 = (function (){var statearr_44406 = state_44396;
(statearr_44406[(7)] = inst_44363__$1);

return statearr_44406;
})();
if(cljs.core.truth_(inst_44364)){
var statearr_44407_46924 = state_44396__$1;
(statearr_44407_46924[(1)] = (5));

} else {
var statearr_44408_46925 = state_44396__$1;
(statearr_44408_46925[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (13))){
var state_44396__$1 = state_44396;
var statearr_44409_46928 = state_44396__$1;
(statearr_44409_46928[(2)] = null);

(statearr_44409_46928[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (6))){
var inst_44363 = (state_44396[(7)]);
var state_44396__$1 = state_44396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44396__$1,(11),to,inst_44363);
} else {
if((state_val_44397 === (3))){
var inst_44394 = (state_44396[(2)]);
var state_44396__$1 = state_44396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44396__$1,inst_44394);
} else {
if((state_val_44397 === (12))){
var state_44396__$1 = state_44396;
var statearr_44410_46930 = state_44396__$1;
(statearr_44410_46930[(2)] = null);

(statearr_44410_46930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (2))){
var state_44396__$1 = state_44396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44396__$1,(4),from);
} else {
if((state_val_44397 === (11))){
var inst_44373 = (state_44396[(2)]);
var state_44396__$1 = state_44396;
if(cljs.core.truth_(inst_44373)){
var statearr_44414_46931 = state_44396__$1;
(statearr_44414_46931[(1)] = (12));

} else {
var statearr_44415_46932 = state_44396__$1;
(statearr_44415_46932[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (9))){
var state_44396__$1 = state_44396;
var statearr_44416_46933 = state_44396__$1;
(statearr_44416_46933[(2)] = null);

(statearr_44416_46933[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (5))){
var state_44396__$1 = state_44396;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44417_46935 = state_44396__$1;
(statearr_44417_46935[(1)] = (8));

} else {
var statearr_44418_46938 = state_44396__$1;
(statearr_44418_46938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (14))){
var inst_44390 = (state_44396[(2)]);
var state_44396__$1 = state_44396;
var statearr_44419_46940 = state_44396__$1;
(statearr_44419_46940[(2)] = inst_44390);

(statearr_44419_46940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (10))){
var inst_44370 = (state_44396[(2)]);
var state_44396__$1 = state_44396;
var statearr_44420_46942 = state_44396__$1;
(statearr_44420_46942[(2)] = inst_44370);

(statearr_44420_46942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44397 === (8))){
var inst_44367 = cljs.core.async.close_BANG_(to);
var state_44396__$1 = state_44396;
var statearr_44421_46943 = state_44396__$1;
(statearr_44421_46943[(2)] = inst_44367);

(statearr_44421_46943[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_44422 = [null,null,null,null,null,null,null,null];
(statearr_44422[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_44422[(1)] = (1));

return statearr_44422;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_44396){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44396);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44427){var ex__43873__auto__ = e44427;
var statearr_44428_46944 = state_44396;
(statearr_44428_46944[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44396[(4)]))){
var statearr_44435_46946 = state_44396;
(statearr_44435_46946[(1)] = cljs.core.first((state_44396[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46947 = state_44396;
state_44396 = G__46947;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_44396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_44396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44436 = f__44005__auto__();
(statearr_44436[(6)] = c__44004__auto___46919);

return statearr_44436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__44437){
var vec__44438 = p__44437;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44438,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44438,(1),null);
var job = vec__44438;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44004__auto___46950 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44447){
var state_val_44448 = (state_44447[(1)]);
if((state_val_44448 === (1))){
var state_44447__$1 = state_44447;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44447__$1,(2),res,v);
} else {
if((state_val_44448 === (2))){
var inst_44442 = (state_44447[(2)]);
var inst_44443 = cljs.core.async.close_BANG_(res);
var state_44447__$1 = (function (){var statearr_44454 = state_44447;
(statearr_44454[(7)] = inst_44442);

return statearr_44454;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44447__$1,inst_44443);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0 = (function (){
var statearr_44456 = [null,null,null,null,null,null,null,null];
(statearr_44456[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__);

(statearr_44456[(1)] = (1));

return statearr_44456;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1 = (function (state_44447){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44447);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44457){var ex__43873__auto__ = e44457;
var statearr_44458_46952 = state_44447;
(statearr_44458_46952[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44447[(4)]))){
var statearr_44459_46953 = state_44447;
(statearr_44459_46953[(1)] = cljs.core.first((state_44447[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46954 = state_44447;
state_44447 = G__46954;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = function(state_44447){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1.call(this,state_44447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44460 = f__44005__auto__();
(statearr_44460[(6)] = c__44004__auto___46950);

return statearr_44460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__44461){
var vec__44462 = p__44461;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44462,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44462,(1),null);
var job = vec__44462;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___46963 = n;
var __46964 = (0);
while(true){
if((__46964 < n__4613__auto___46963)){
var G__44467_46965 = type;
var G__44467_46966__$1 = (((G__44467_46965 instanceof cljs.core.Keyword))?G__44467_46965.fqn:null);
switch (G__44467_46966__$1) {
case "compute":
var c__44004__auto___46968 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46964,c__44004__auto___46968,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async){
return (function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = ((function (__46964,c__44004__auto___46968,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async){
return (function (state_44480){
var state_val_44481 = (state_44480[(1)]);
if((state_val_44481 === (1))){
var state_44480__$1 = state_44480;
var statearr_44484_46969 = state_44480__$1;
(statearr_44484_46969[(2)] = null);

(statearr_44484_46969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (2))){
var state_44480__$1 = state_44480;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44480__$1,(4),jobs);
} else {
if((state_val_44481 === (3))){
var inst_44478 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44480__$1,inst_44478);
} else {
if((state_val_44481 === (4))){
var inst_44470 = (state_44480[(2)]);
var inst_44471 = process(inst_44470);
var state_44480__$1 = state_44480;
if(cljs.core.truth_(inst_44471)){
var statearr_44485_46978 = state_44480__$1;
(statearr_44485_46978[(1)] = (5));

} else {
var statearr_44486_46999 = state_44480__$1;
(statearr_44486_46999[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (5))){
var state_44480__$1 = state_44480;
var statearr_44493_47000 = state_44480__$1;
(statearr_44493_47000[(2)] = null);

(statearr_44493_47000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (6))){
var state_44480__$1 = state_44480;
var statearr_44496_47002 = state_44480__$1;
(statearr_44496_47002[(2)] = null);

(statearr_44496_47002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44481 === (7))){
var inst_44476 = (state_44480[(2)]);
var state_44480__$1 = state_44480;
var statearr_44497_47005 = state_44480__$1;
(statearr_44497_47005[(2)] = inst_44476);

(statearr_44497_47005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46964,c__44004__auto___46968,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async))
;
return ((function (__46964,switch__43869__auto__,c__44004__auto___46968,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0 = (function (){
var statearr_44499 = [null,null,null,null,null,null,null];
(statearr_44499[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__);

(statearr_44499[(1)] = (1));

return statearr_44499;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1 = (function (state_44480){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44480);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44500){var ex__43873__auto__ = e44500;
var statearr_44501_47006 = state_44480;
(statearr_44501_47006[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44480[(4)]))){
var statearr_44502_47007 = state_44480;
(statearr_44502_47007[(1)] = cljs.core.first((state_44480[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47008 = state_44480;
state_44480 = G__47008;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = function(state_44480){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1.call(this,state_44480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__;
})()
;})(__46964,switch__43869__auto__,c__44004__auto___46968,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async))
})();
var state__44006__auto__ = (function (){var statearr_44505 = f__44005__auto__();
(statearr_44505[(6)] = c__44004__auto___46968);

return statearr_44505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
});})(__46964,c__44004__auto___46968,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async))
);


break;
case "async":
var c__44004__auto___47015 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46964,c__44004__auto___47015,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async){
return (function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = ((function (__46964,c__44004__auto___47015,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async){
return (function (state_44520){
var state_val_44521 = (state_44520[(1)]);
if((state_val_44521 === (1))){
var state_44520__$1 = state_44520;
var statearr_44522_47017 = state_44520__$1;
(statearr_44522_47017[(2)] = null);

(statearr_44522_47017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44521 === (2))){
var state_44520__$1 = state_44520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44520__$1,(4),jobs);
} else {
if((state_val_44521 === (3))){
var inst_44518 = (state_44520[(2)]);
var state_44520__$1 = state_44520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44520__$1,inst_44518);
} else {
if((state_val_44521 === (4))){
var inst_44510 = (state_44520[(2)]);
var inst_44511 = async(inst_44510);
var state_44520__$1 = state_44520;
if(cljs.core.truth_(inst_44511)){
var statearr_44528_47020 = state_44520__$1;
(statearr_44528_47020[(1)] = (5));

} else {
var statearr_44529_47021 = state_44520__$1;
(statearr_44529_47021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44521 === (5))){
var state_44520__$1 = state_44520;
var statearr_44530_47022 = state_44520__$1;
(statearr_44530_47022[(2)] = null);

(statearr_44530_47022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44521 === (6))){
var state_44520__$1 = state_44520;
var statearr_44535_47023 = state_44520__$1;
(statearr_44535_47023[(2)] = null);

(statearr_44535_47023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44521 === (7))){
var inst_44516 = (state_44520[(2)]);
var state_44520__$1 = state_44520;
var statearr_44536_47025 = state_44520__$1;
(statearr_44536_47025[(2)] = inst_44516);

(statearr_44536_47025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46964,c__44004__auto___47015,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async))
;
return ((function (__46964,switch__43869__auto__,c__44004__auto___47015,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0 = (function (){
var statearr_44537 = [null,null,null,null,null,null,null];
(statearr_44537[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__);

(statearr_44537[(1)] = (1));

return statearr_44537;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1 = (function (state_44520){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44520);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44538){var ex__43873__auto__ = e44538;
var statearr_44539_47030 = state_44520;
(statearr_44539_47030[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44520[(4)]))){
var statearr_44540_47031 = state_44520;
(statearr_44540_47031[(1)] = cljs.core.first((state_44520[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47032 = state_44520;
state_44520 = G__47032;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = function(state_44520){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1.call(this,state_44520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__;
})()
;})(__46964,switch__43869__auto__,c__44004__auto___47015,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async))
})();
var state__44006__auto__ = (function (){var statearr_44545 = f__44005__auto__();
(statearr_44545[(6)] = c__44004__auto___47015);

return statearr_44545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
});})(__46964,c__44004__auto___47015,G__44467_46965,G__44467_46966__$1,n__4613__auto___46963,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44467_46966__$1)].join('')));

}

var G__47033 = (__46964 + (1));
__46964 = G__47033;
continue;
} else {
}
break;
}

var c__44004__auto___47035 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44568){
var state_val_44569 = (state_44568[(1)]);
if((state_val_44569 === (7))){
var inst_44564 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44574_47036 = state_44568__$1;
(statearr_44574_47036[(2)] = inst_44564);

(statearr_44574_47036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (1))){
var state_44568__$1 = state_44568;
var statearr_44575_47037 = state_44568__$1;
(statearr_44575_47037[(2)] = null);

(statearr_44575_47037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (4))){
var inst_44549 = (state_44568[(7)]);
var inst_44549__$1 = (state_44568[(2)]);
var inst_44550 = (inst_44549__$1 == null);
var state_44568__$1 = (function (){var statearr_44577 = state_44568;
(statearr_44577[(7)] = inst_44549__$1);

return statearr_44577;
})();
if(cljs.core.truth_(inst_44550)){
var statearr_44580_47038 = state_44568__$1;
(statearr_44580_47038[(1)] = (5));

} else {
var statearr_44581_47039 = state_44568__$1;
(statearr_44581_47039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (6))){
var inst_44554 = (state_44568[(8)]);
var inst_44549 = (state_44568[(7)]);
var inst_44554__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44556 = [inst_44549,inst_44554__$1];
var inst_44557 = (new cljs.core.PersistentVector(null,2,(5),inst_44555,inst_44556,null));
var state_44568__$1 = (function (){var statearr_44583 = state_44568;
(statearr_44583[(8)] = inst_44554__$1);

return statearr_44583;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44568__$1,(8),jobs,inst_44557);
} else {
if((state_val_44569 === (3))){
var inst_44566 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44568__$1,inst_44566);
} else {
if((state_val_44569 === (2))){
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44568__$1,(4),from);
} else {
if((state_val_44569 === (9))){
var inst_44561 = (state_44568[(2)]);
var state_44568__$1 = (function (){var statearr_44589 = state_44568;
(statearr_44589[(9)] = inst_44561);

return statearr_44589;
})();
var statearr_44590_47043 = state_44568__$1;
(statearr_44590_47043[(2)] = null);

(statearr_44590_47043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (5))){
var inst_44552 = cljs.core.async.close_BANG_(jobs);
var state_44568__$1 = state_44568;
var statearr_44595_47044 = state_44568__$1;
(statearr_44595_47044[(2)] = inst_44552);

(statearr_44595_47044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (8))){
var inst_44554 = (state_44568[(8)]);
var inst_44559 = (state_44568[(2)]);
var state_44568__$1 = (function (){var statearr_44600 = state_44568;
(statearr_44600[(10)] = inst_44559);

return statearr_44600;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44568__$1,(9),results,inst_44554);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0 = (function (){
var statearr_44601 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44601[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__);

(statearr_44601[(1)] = (1));

return statearr_44601;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1 = (function (state_44568){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44568);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44602){var ex__43873__auto__ = e44602;
var statearr_44603_47047 = state_44568;
(statearr_44603_47047[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44568[(4)]))){
var statearr_44604_47048 = state_44568;
(statearr_44604_47048[(1)] = cljs.core.first((state_44568[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47050 = state_44568;
state_44568 = G__47050;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = function(state_44568){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1.call(this,state_44568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44605 = f__44005__auto__();
(statearr_44605[(6)] = c__44004__auto___47035);

return statearr_44605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


var c__44004__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44643){
var state_val_44644 = (state_44643[(1)]);
if((state_val_44644 === (7))){
var inst_44639 = (state_44643[(2)]);
var state_44643__$1 = state_44643;
var statearr_44651_47054 = state_44643__$1;
(statearr_44651_47054[(2)] = inst_44639);

(statearr_44651_47054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (20))){
var state_44643__$1 = state_44643;
var statearr_44654_47055 = state_44643__$1;
(statearr_44654_47055[(2)] = null);

(statearr_44654_47055[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (1))){
var state_44643__$1 = state_44643;
var statearr_44655_47056 = state_44643__$1;
(statearr_44655_47056[(2)] = null);

(statearr_44655_47056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (4))){
var inst_44608 = (state_44643[(7)]);
var inst_44608__$1 = (state_44643[(2)]);
var inst_44609 = (inst_44608__$1 == null);
var state_44643__$1 = (function (){var statearr_44661 = state_44643;
(statearr_44661[(7)] = inst_44608__$1);

return statearr_44661;
})();
if(cljs.core.truth_(inst_44609)){
var statearr_44663_47059 = state_44643__$1;
(statearr_44663_47059[(1)] = (5));

} else {
var statearr_44664_47060 = state_44643__$1;
(statearr_44664_47060[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (15))){
var inst_44621 = (state_44643[(8)]);
var state_44643__$1 = state_44643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44643__$1,(18),to,inst_44621);
} else {
if((state_val_44644 === (21))){
var inst_44634 = (state_44643[(2)]);
var state_44643__$1 = state_44643;
var statearr_44666_47067 = state_44643__$1;
(statearr_44666_47067[(2)] = inst_44634);

(statearr_44666_47067[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (13))){
var inst_44636 = (state_44643[(2)]);
var state_44643__$1 = (function (){var statearr_44667 = state_44643;
(statearr_44667[(9)] = inst_44636);

return statearr_44667;
})();
var statearr_44668_47071 = state_44643__$1;
(statearr_44668_47071[(2)] = null);

(statearr_44668_47071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (6))){
var inst_44608 = (state_44643[(7)]);
var state_44643__$1 = state_44643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44643__$1,(11),inst_44608);
} else {
if((state_val_44644 === (17))){
var inst_44629 = (state_44643[(2)]);
var state_44643__$1 = state_44643;
if(cljs.core.truth_(inst_44629)){
var statearr_44669_47072 = state_44643__$1;
(statearr_44669_47072[(1)] = (19));

} else {
var statearr_44670_47073 = state_44643__$1;
(statearr_44670_47073[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (3))){
var inst_44641 = (state_44643[(2)]);
var state_44643__$1 = state_44643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44643__$1,inst_44641);
} else {
if((state_val_44644 === (12))){
var inst_44618 = (state_44643[(10)]);
var state_44643__$1 = state_44643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44643__$1,(14),inst_44618);
} else {
if((state_val_44644 === (2))){
var state_44643__$1 = state_44643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44643__$1,(4),results);
} else {
if((state_val_44644 === (19))){
var state_44643__$1 = state_44643;
var statearr_44671_47081 = state_44643__$1;
(statearr_44671_47081[(2)] = null);

(statearr_44671_47081[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (11))){
var inst_44618 = (state_44643[(2)]);
var state_44643__$1 = (function (){var statearr_44673 = state_44643;
(statearr_44673[(10)] = inst_44618);

return statearr_44673;
})();
var statearr_44674_47088 = state_44643__$1;
(statearr_44674_47088[(2)] = null);

(statearr_44674_47088[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (9))){
var state_44643__$1 = state_44643;
var statearr_44675_47089 = state_44643__$1;
(statearr_44675_47089[(2)] = null);

(statearr_44675_47089[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (5))){
var state_44643__$1 = state_44643;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44676_47090 = state_44643__$1;
(statearr_44676_47090[(1)] = (8));

} else {
var statearr_44677_47091 = state_44643__$1;
(statearr_44677_47091[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (14))){
var inst_44621 = (state_44643[(8)]);
var inst_44621__$1 = (state_44643[(2)]);
var inst_44622 = (inst_44621__$1 == null);
var inst_44623 = cljs.core.not(inst_44622);
var state_44643__$1 = (function (){var statearr_44678 = state_44643;
(statearr_44678[(8)] = inst_44621__$1);

return statearr_44678;
})();
if(inst_44623){
var statearr_44679_47095 = state_44643__$1;
(statearr_44679_47095[(1)] = (15));

} else {
var statearr_44681_47096 = state_44643__$1;
(statearr_44681_47096[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (16))){
var state_44643__$1 = state_44643;
var statearr_44682_47097 = state_44643__$1;
(statearr_44682_47097[(2)] = false);

(statearr_44682_47097[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (10))){
var inst_44615 = (state_44643[(2)]);
var state_44643__$1 = state_44643;
var statearr_44683_47100 = state_44643__$1;
(statearr_44683_47100[(2)] = inst_44615);

(statearr_44683_47100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (18))){
var inst_44626 = (state_44643[(2)]);
var state_44643__$1 = state_44643;
var statearr_44684_47105 = state_44643__$1;
(statearr_44684_47105[(2)] = inst_44626);

(statearr_44684_47105[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44644 === (8))){
var inst_44612 = cljs.core.async.close_BANG_(to);
var state_44643__$1 = state_44643;
var statearr_44685_47106 = state_44643__$1;
(statearr_44685_47106[(2)] = inst_44612);

(statearr_44685_47106[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0 = (function (){
var statearr_44686 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44686[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__);

(statearr_44686[(1)] = (1));

return statearr_44686;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1 = (function (state_44643){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44643);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44687){var ex__43873__auto__ = e44687;
var statearr_44688_47113 = state_44643;
(statearr_44688_47113[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44643[(4)]))){
var statearr_44689_47114 = state_44643;
(statearr_44689_47114[(1)] = cljs.core.first((state_44643[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47118 = state_44643;
state_44643 = G__47118;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__ = function(state_44643){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1.call(this,state_44643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43870__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44696 = f__44005__auto__();
(statearr_44696[(6)] = c__44004__auto__);

return statearr_44696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));

return c__44004__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44702 = arguments.length;
switch (G__44702) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44714 = arguments.length;
switch (G__44714) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44718 = arguments.length;
switch (G__44718) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44004__auto___47135 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44753){
var state_val_44754 = (state_44753[(1)]);
if((state_val_44754 === (7))){
var inst_44740 = (state_44753[(2)]);
var state_44753__$1 = state_44753;
var statearr_44756_47143 = state_44753__$1;
(statearr_44756_47143[(2)] = inst_44740);

(statearr_44756_47143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (1))){
var state_44753__$1 = state_44753;
var statearr_44762_47144 = state_44753__$1;
(statearr_44762_47144[(2)] = null);

(statearr_44762_47144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (4))){
var inst_44721 = (state_44753[(7)]);
var inst_44721__$1 = (state_44753[(2)]);
var inst_44722 = (inst_44721__$1 == null);
var state_44753__$1 = (function (){var statearr_44767 = state_44753;
(statearr_44767[(7)] = inst_44721__$1);

return statearr_44767;
})();
if(cljs.core.truth_(inst_44722)){
var statearr_44769_47145 = state_44753__$1;
(statearr_44769_47145[(1)] = (5));

} else {
var statearr_44770_47146 = state_44753__$1;
(statearr_44770_47146[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (13))){
var state_44753__$1 = state_44753;
var statearr_44776_47147 = state_44753__$1;
(statearr_44776_47147[(2)] = null);

(statearr_44776_47147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (6))){
var inst_44721 = (state_44753[(7)]);
var inst_44727 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44721) : p.call(null,inst_44721));
var state_44753__$1 = state_44753;
if(cljs.core.truth_(inst_44727)){
var statearr_44778_47150 = state_44753__$1;
(statearr_44778_47150[(1)] = (9));

} else {
var statearr_44779_47152 = state_44753__$1;
(statearr_44779_47152[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (3))){
var inst_44742 = (state_44753[(2)]);
var state_44753__$1 = state_44753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44753__$1,inst_44742);
} else {
if((state_val_44754 === (12))){
var state_44753__$1 = state_44753;
var statearr_44783_47154 = state_44753__$1;
(statearr_44783_47154[(2)] = null);

(statearr_44783_47154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (2))){
var state_44753__$1 = state_44753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44753__$1,(4),ch);
} else {
if((state_val_44754 === (11))){
var inst_44721 = (state_44753[(7)]);
var inst_44731 = (state_44753[(2)]);
var state_44753__$1 = state_44753;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44753__$1,(8),inst_44731,inst_44721);
} else {
if((state_val_44754 === (9))){
var state_44753__$1 = state_44753;
var statearr_44787_47158 = state_44753__$1;
(statearr_44787_47158[(2)] = tc);

(statearr_44787_47158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (5))){
var inst_44724 = cljs.core.async.close_BANG_(tc);
var inst_44725 = cljs.core.async.close_BANG_(fc);
var state_44753__$1 = (function (){var statearr_44789 = state_44753;
(statearr_44789[(8)] = inst_44724);

return statearr_44789;
})();
var statearr_44790_47161 = state_44753__$1;
(statearr_44790_47161[(2)] = inst_44725);

(statearr_44790_47161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (14))){
var inst_44738 = (state_44753[(2)]);
var state_44753__$1 = state_44753;
var statearr_44791_47163 = state_44753__$1;
(statearr_44791_47163[(2)] = inst_44738);

(statearr_44791_47163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (10))){
var state_44753__$1 = state_44753;
var statearr_44795_47165 = state_44753__$1;
(statearr_44795_47165[(2)] = fc);

(statearr_44795_47165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44754 === (8))){
var inst_44733 = (state_44753[(2)]);
var state_44753__$1 = state_44753;
if(cljs.core.truth_(inst_44733)){
var statearr_44796_47167 = state_44753__$1;
(statearr_44796_47167[(1)] = (12));

} else {
var statearr_44797_47168 = state_44753__$1;
(statearr_44797_47168[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_44798 = [null,null,null,null,null,null,null,null,null];
(statearr_44798[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_44798[(1)] = (1));

return statearr_44798;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_44753){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44753);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44799){var ex__43873__auto__ = e44799;
var statearr_44800_47170 = state_44753;
(statearr_44800_47170[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44753[(4)]))){
var statearr_44801_47171 = state_44753;
(statearr_44801_47171[(1)] = cljs.core.first((state_44753[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47174 = state_44753;
state_44753 = G__47174;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_44753){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_44753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44802 = f__44005__auto__();
(statearr_44802[(6)] = c__44004__auto___47135);

return statearr_44802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44004__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44826){
var state_val_44827 = (state_44826[(1)]);
if((state_val_44827 === (7))){
var inst_44822 = (state_44826[(2)]);
var state_44826__$1 = state_44826;
var statearr_44829_47179 = state_44826__$1;
(statearr_44829_47179[(2)] = inst_44822);

(statearr_44829_47179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (1))){
var inst_44804 = init;
var inst_44805 = inst_44804;
var state_44826__$1 = (function (){var statearr_44830 = state_44826;
(statearr_44830[(7)] = inst_44805);

return statearr_44830;
})();
var statearr_44831_47181 = state_44826__$1;
(statearr_44831_47181[(2)] = null);

(statearr_44831_47181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (4))){
var inst_44809 = (state_44826[(8)]);
var inst_44809__$1 = (state_44826[(2)]);
var inst_44810 = (inst_44809__$1 == null);
var state_44826__$1 = (function (){var statearr_44844 = state_44826;
(statearr_44844[(8)] = inst_44809__$1);

return statearr_44844;
})();
if(cljs.core.truth_(inst_44810)){
var statearr_44845_47189 = state_44826__$1;
(statearr_44845_47189[(1)] = (5));

} else {
var statearr_44846_47190 = state_44826__$1;
(statearr_44846_47190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (6))){
var inst_44813 = (state_44826[(9)]);
var inst_44805 = (state_44826[(7)]);
var inst_44809 = (state_44826[(8)]);
var inst_44813__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44805,inst_44809) : f.call(null,inst_44805,inst_44809));
var inst_44814 = cljs.core.reduced_QMARK_(inst_44813__$1);
var state_44826__$1 = (function (){var statearr_44852 = state_44826;
(statearr_44852[(9)] = inst_44813__$1);

return statearr_44852;
})();
if(inst_44814){
var statearr_44855_47193 = state_44826__$1;
(statearr_44855_47193[(1)] = (8));

} else {
var statearr_44856_47194 = state_44826__$1;
(statearr_44856_47194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (3))){
var inst_44824 = (state_44826[(2)]);
var state_44826__$1 = state_44826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44826__$1,inst_44824);
} else {
if((state_val_44827 === (2))){
var state_44826__$1 = state_44826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44826__$1,(4),ch);
} else {
if((state_val_44827 === (9))){
var inst_44813 = (state_44826[(9)]);
var inst_44805 = inst_44813;
var state_44826__$1 = (function (){var statearr_44858 = state_44826;
(statearr_44858[(7)] = inst_44805);

return statearr_44858;
})();
var statearr_44859_47198 = state_44826__$1;
(statearr_44859_47198[(2)] = null);

(statearr_44859_47198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (5))){
var inst_44805 = (state_44826[(7)]);
var state_44826__$1 = state_44826;
var statearr_44860_47201 = state_44826__$1;
(statearr_44860_47201[(2)] = inst_44805);

(statearr_44860_47201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (10))){
var inst_44820 = (state_44826[(2)]);
var state_44826__$1 = state_44826;
var statearr_44861_47203 = state_44826__$1;
(statearr_44861_47203[(2)] = inst_44820);

(statearr_44861_47203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44827 === (8))){
var inst_44813 = (state_44826[(9)]);
var inst_44816 = cljs.core.deref(inst_44813);
var state_44826__$1 = state_44826;
var statearr_44862_47204 = state_44826__$1;
(statearr_44862_47204[(2)] = inst_44816);

(statearr_44862_47204[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43870__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43870__auto____0 = (function (){
var statearr_44863 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44863[(0)] = cljs$core$async$reduce_$_state_machine__43870__auto__);

(statearr_44863[(1)] = (1));

return statearr_44863;
});
var cljs$core$async$reduce_$_state_machine__43870__auto____1 = (function (state_44826){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44826);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44864){var ex__43873__auto__ = e44864;
var statearr_44865_47206 = state_44826;
(statearr_44865_47206[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44826[(4)]))){
var statearr_44866_47207 = state_44826;
(statearr_44866_47207[(1)] = cljs.core.first((state_44826[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47209 = state_44826;
state_44826 = G__47209;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43870__auto__ = function(state_44826){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43870__auto____1.call(this,state_44826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43870__auto____0;
cljs$core$async$reduce_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43870__auto____1;
return cljs$core$async$reduce_$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44873 = f__44005__auto__();
(statearr_44873[(6)] = c__44004__auto__);

return statearr_44873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));

return c__44004__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44004__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44886){
var state_val_44887 = (state_44886[(1)]);
if((state_val_44887 === (1))){
var inst_44881 = cljs.core.async.reduce(f__$1,init,ch);
var state_44886__$1 = state_44886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44886__$1,(2),inst_44881);
} else {
if((state_val_44887 === (2))){
var inst_44883 = (state_44886[(2)]);
var inst_44884 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_44883) : f__$1.call(null,inst_44883));
var state_44886__$1 = state_44886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44886__$1,inst_44884);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43870__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43870__auto____0 = (function (){
var statearr_44894 = [null,null,null,null,null,null,null];
(statearr_44894[(0)] = cljs$core$async$transduce_$_state_machine__43870__auto__);

(statearr_44894[(1)] = (1));

return statearr_44894;
});
var cljs$core$async$transduce_$_state_machine__43870__auto____1 = (function (state_44886){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44886);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44896){var ex__43873__auto__ = e44896;
var statearr_44897_47220 = state_44886;
(statearr_44897_47220[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44886[(4)]))){
var statearr_44899_47222 = state_44886;
(statearr_44899_47222[(1)] = cljs.core.first((state_44886[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47226 = state_44886;
state_44886 = G__47226;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43870__auto__ = function(state_44886){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43870__auto____1.call(this,state_44886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43870__auto____0;
cljs$core$async$transduce_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43870__auto____1;
return cljs$core$async$transduce_$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44902 = f__44005__auto__();
(statearr_44902[(6)] = c__44004__auto__);

return statearr_44902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));

return c__44004__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__44906 = arguments.length;
switch (G__44906) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44004__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_44936){
var state_val_44937 = (state_44936[(1)]);
if((state_val_44937 === (7))){
var inst_44917 = (state_44936[(2)]);
var state_44936__$1 = state_44936;
var statearr_44943_47246 = state_44936__$1;
(statearr_44943_47246[(2)] = inst_44917);

(statearr_44943_47246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (1))){
var inst_44909 = cljs.core.seq(coll);
var inst_44910 = inst_44909;
var state_44936__$1 = (function (){var statearr_44949 = state_44936;
(statearr_44949[(7)] = inst_44910);

return statearr_44949;
})();
var statearr_44950_47247 = state_44936__$1;
(statearr_44950_47247[(2)] = null);

(statearr_44950_47247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (4))){
var inst_44910 = (state_44936[(7)]);
var inst_44915 = cljs.core.first(inst_44910);
var state_44936__$1 = state_44936;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44936__$1,(7),ch,inst_44915);
} else {
if((state_val_44937 === (13))){
var inst_44930 = (state_44936[(2)]);
var state_44936__$1 = state_44936;
var statearr_44951_47249 = state_44936__$1;
(statearr_44951_47249[(2)] = inst_44930);

(statearr_44951_47249[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (6))){
var inst_44920 = (state_44936[(2)]);
var state_44936__$1 = state_44936;
if(cljs.core.truth_(inst_44920)){
var statearr_44953_47253 = state_44936__$1;
(statearr_44953_47253[(1)] = (8));

} else {
var statearr_44954_47255 = state_44936__$1;
(statearr_44954_47255[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (3))){
var inst_44934 = (state_44936[(2)]);
var state_44936__$1 = state_44936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44936__$1,inst_44934);
} else {
if((state_val_44937 === (12))){
var state_44936__$1 = state_44936;
var statearr_44957_47256 = state_44936__$1;
(statearr_44957_47256[(2)] = null);

(statearr_44957_47256[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (2))){
var inst_44910 = (state_44936[(7)]);
var state_44936__$1 = state_44936;
if(cljs.core.truth_(inst_44910)){
var statearr_44958_47258 = state_44936__$1;
(statearr_44958_47258[(1)] = (4));

} else {
var statearr_44959_47259 = state_44936__$1;
(statearr_44959_47259[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (11))){
var inst_44927 = cljs.core.async.close_BANG_(ch);
var state_44936__$1 = state_44936;
var statearr_44966_47260 = state_44936__$1;
(statearr_44966_47260[(2)] = inst_44927);

(statearr_44966_47260[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (9))){
var state_44936__$1 = state_44936;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44968_47263 = state_44936__$1;
(statearr_44968_47263[(1)] = (11));

} else {
var statearr_44969_47264 = state_44936__$1;
(statearr_44969_47264[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (5))){
var inst_44910 = (state_44936[(7)]);
var state_44936__$1 = state_44936;
var statearr_44975_47267 = state_44936__$1;
(statearr_44975_47267[(2)] = inst_44910);

(statearr_44975_47267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (10))){
var inst_44932 = (state_44936[(2)]);
var state_44936__$1 = state_44936;
var statearr_44977_47272 = state_44936__$1;
(statearr_44977_47272[(2)] = inst_44932);

(statearr_44977_47272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44937 === (8))){
var inst_44910 = (state_44936[(7)]);
var inst_44922 = cljs.core.next(inst_44910);
var inst_44910__$1 = inst_44922;
var state_44936__$1 = (function (){var statearr_44978 = state_44936;
(statearr_44978[(7)] = inst_44910__$1);

return statearr_44978;
})();
var statearr_44979_47280 = state_44936__$1;
(statearr_44979_47280[(2)] = null);

(statearr_44979_47280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_44981 = [null,null,null,null,null,null,null,null];
(statearr_44981[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_44981[(1)] = (1));

return statearr_44981;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_44936){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_44936);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e44982){var ex__43873__auto__ = e44982;
var statearr_44983_47290 = state_44936;
(statearr_44983_47290[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_44936[(4)]))){
var statearr_44984_47291 = state_44936;
(statearr_44984_47291[(1)] = cljs.core.first((state_44936[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47293 = state_44936;
state_44936 = G__47293;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_44936){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_44936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_44989 = f__44005__auto__();
(statearr_44989[(6)] = c__44004__auto__);

return statearr_44989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));

return c__44004__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__44998 = arguments.length;
switch (G__44998) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_47312 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_47312(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_47318 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_47318(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_47328 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_47328(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_47343 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_47343(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45055 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45055 = (function (ch,cs,meta45056){
this.ch = ch;
this.cs = cs;
this.meta45056 = meta45056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45057,meta45056__$1){
var self__ = this;
var _45057__$1 = this;
return (new cljs.core.async.t_cljs$core$async45055(self__.ch,self__.cs,meta45056__$1));
}));

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45057){
var self__ = this;
var _45057__$1 = this;
return self__.meta45056;
}));

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async45055.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async45055.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45056","meta45056",-677074257,null)], null);
}));

(cljs.core.async.t_cljs$core$async45055.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45055");

(cljs.core.async.t_cljs$core$async45055.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45055");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45055.
 */
cljs.core.async.__GT_t_cljs$core$async45055 = (function cljs$core$async$mult_$___GT_t_cljs$core$async45055(ch__$1,cs__$1,meta45056){
return (new cljs.core.async.t_cljs$core$async45055(ch__$1,cs__$1,meta45056));
});

}

return (new cljs.core.async.t_cljs$core$async45055(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44004__auto___47362 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_45263){
var state_val_45264 = (state_45263[(1)]);
if((state_val_45264 === (7))){
var inst_45247 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45277_47363 = state_45263__$1;
(statearr_45277_47363[(2)] = inst_45247);

(statearr_45277_47363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (20))){
var inst_45126 = (state_45263[(7)]);
var inst_45144 = cljs.core.first(inst_45126);
var inst_45149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45144,(0),null);
var inst_45150 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45144,(1),null);
var state_45263__$1 = (function (){var statearr_45282 = state_45263;
(statearr_45282[(8)] = inst_45149);

return statearr_45282;
})();
if(cljs.core.truth_(inst_45150)){
var statearr_45286_47372 = state_45263__$1;
(statearr_45286_47372[(1)] = (22));

} else {
var statearr_45287_47373 = state_45263__$1;
(statearr_45287_47373[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (27))){
var inst_45181 = (state_45263[(9)]);
var inst_45188 = (state_45263[(10)]);
var inst_45183 = (state_45263[(11)]);
var inst_45082 = (state_45263[(12)]);
var inst_45188__$1 = cljs.core._nth(inst_45181,inst_45183);
var inst_45190 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45188__$1,inst_45082,done);
var state_45263__$1 = (function (){var statearr_45294 = state_45263;
(statearr_45294[(10)] = inst_45188__$1);

return statearr_45294;
})();
if(cljs.core.truth_(inst_45190)){
var statearr_45303_47376 = state_45263__$1;
(statearr_45303_47376[(1)] = (30));

} else {
var statearr_45304_47378 = state_45263__$1;
(statearr_45304_47378[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (1))){
var state_45263__$1 = state_45263;
var statearr_45309_47379 = state_45263__$1;
(statearr_45309_47379[(2)] = null);

(statearr_45309_47379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (24))){
var inst_45126 = (state_45263[(7)]);
var inst_45156 = (state_45263[(2)]);
var inst_45157 = cljs.core.next(inst_45126);
var inst_45096 = inst_45157;
var inst_45097 = null;
var inst_45098 = (0);
var inst_45099 = (0);
var state_45263__$1 = (function (){var statearr_45316 = state_45263;
(statearr_45316[(13)] = inst_45097);

(statearr_45316[(14)] = inst_45099);

(statearr_45316[(15)] = inst_45096);

(statearr_45316[(16)] = inst_45098);

(statearr_45316[(17)] = inst_45156);

return statearr_45316;
})();
var statearr_45323_47385 = state_45263__$1;
(statearr_45323_47385[(2)] = null);

(statearr_45323_47385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (39))){
var state_45263__$1 = state_45263;
var statearr_45328_47387 = state_45263__$1;
(statearr_45328_47387[(2)] = null);

(statearr_45328_47387[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (4))){
var inst_45082 = (state_45263[(12)]);
var inst_45082__$1 = (state_45263[(2)]);
var inst_45084 = (inst_45082__$1 == null);
var state_45263__$1 = (function (){var statearr_45330 = state_45263;
(statearr_45330[(12)] = inst_45082__$1);

return statearr_45330;
})();
if(cljs.core.truth_(inst_45084)){
var statearr_45331_47393 = state_45263__$1;
(statearr_45331_47393[(1)] = (5));

} else {
var statearr_45332_47394 = state_45263__$1;
(statearr_45332_47394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (15))){
var inst_45097 = (state_45263[(13)]);
var inst_45099 = (state_45263[(14)]);
var inst_45096 = (state_45263[(15)]);
var inst_45098 = (state_45263[(16)]);
var inst_45121 = (state_45263[(2)]);
var inst_45122 = (inst_45099 + (1));
var tmp45325 = inst_45097;
var tmp45326 = inst_45096;
var tmp45327 = inst_45098;
var inst_45096__$1 = tmp45326;
var inst_45097__$1 = tmp45325;
var inst_45098__$1 = tmp45327;
var inst_45099__$1 = inst_45122;
var state_45263__$1 = (function (){var statearr_45333 = state_45263;
(statearr_45333[(13)] = inst_45097__$1);

(statearr_45333[(14)] = inst_45099__$1);

(statearr_45333[(15)] = inst_45096__$1);

(statearr_45333[(18)] = inst_45121);

(statearr_45333[(16)] = inst_45098__$1);

return statearr_45333;
})();
var statearr_45334_47403 = state_45263__$1;
(statearr_45334_47403[(2)] = null);

(statearr_45334_47403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (21))){
var inst_45160 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45338_47405 = state_45263__$1;
(statearr_45338_47405[(2)] = inst_45160);

(statearr_45338_47405[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (31))){
var inst_45188 = (state_45263[(10)]);
var inst_45196 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45188);
var state_45263__$1 = state_45263;
var statearr_45341_47411 = state_45263__$1;
(statearr_45341_47411[(2)] = inst_45196);

(statearr_45341_47411[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (32))){
var inst_45180 = (state_45263[(19)]);
var inst_45181 = (state_45263[(9)]);
var inst_45182 = (state_45263[(20)]);
var inst_45183 = (state_45263[(11)]);
var inst_45198 = (state_45263[(2)]);
var inst_45199 = (inst_45183 + (1));
var tmp45335 = inst_45180;
var tmp45336 = inst_45181;
var tmp45337 = inst_45182;
var inst_45180__$1 = tmp45335;
var inst_45181__$1 = tmp45336;
var inst_45182__$1 = tmp45337;
var inst_45183__$1 = inst_45199;
var state_45263__$1 = (function (){var statearr_45343 = state_45263;
(statearr_45343[(19)] = inst_45180__$1);

(statearr_45343[(9)] = inst_45181__$1);

(statearr_45343[(21)] = inst_45198);

(statearr_45343[(20)] = inst_45182__$1);

(statearr_45343[(11)] = inst_45183__$1);

return statearr_45343;
})();
var statearr_45345_47421 = state_45263__$1;
(statearr_45345_47421[(2)] = null);

(statearr_45345_47421[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (40))){
var inst_45218 = (state_45263[(22)]);
var inst_45222 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_45218);
var state_45263__$1 = state_45263;
var statearr_45346_47423 = state_45263__$1;
(statearr_45346_47423[(2)] = inst_45222);

(statearr_45346_47423[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (33))){
var inst_45202 = (state_45263[(23)]);
var inst_45204 = cljs.core.chunked_seq_QMARK_(inst_45202);
var state_45263__$1 = state_45263;
if(inst_45204){
var statearr_45348_47430 = state_45263__$1;
(statearr_45348_47430[(1)] = (36));

} else {
var statearr_45349_47432 = state_45263__$1;
(statearr_45349_47432[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (13))){
var inst_45110 = (state_45263[(24)]);
var inst_45118 = cljs.core.async.close_BANG_(inst_45110);
var state_45263__$1 = state_45263;
var statearr_45351_47435 = state_45263__$1;
(statearr_45351_47435[(2)] = inst_45118);

(statearr_45351_47435[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (22))){
var inst_45149 = (state_45263[(8)]);
var inst_45153 = cljs.core.async.close_BANG_(inst_45149);
var state_45263__$1 = state_45263;
var statearr_45352_47439 = state_45263__$1;
(statearr_45352_47439[(2)] = inst_45153);

(statearr_45352_47439[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (36))){
var inst_45202 = (state_45263[(23)]);
var inst_45206 = cljs.core.chunk_first(inst_45202);
var inst_45207 = cljs.core.chunk_rest(inst_45202);
var inst_45208 = cljs.core.count(inst_45206);
var inst_45180 = inst_45207;
var inst_45181 = inst_45206;
var inst_45182 = inst_45208;
var inst_45183 = (0);
var state_45263__$1 = (function (){var statearr_45353 = state_45263;
(statearr_45353[(19)] = inst_45180);

(statearr_45353[(9)] = inst_45181);

(statearr_45353[(20)] = inst_45182);

(statearr_45353[(11)] = inst_45183);

return statearr_45353;
})();
var statearr_45354_47440 = state_45263__$1;
(statearr_45354_47440[(2)] = null);

(statearr_45354_47440[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (41))){
var inst_45202 = (state_45263[(23)]);
var inst_45225 = (state_45263[(2)]);
var inst_45226 = cljs.core.next(inst_45202);
var inst_45180 = inst_45226;
var inst_45181 = null;
var inst_45182 = (0);
var inst_45183 = (0);
var state_45263__$1 = (function (){var statearr_45358 = state_45263;
(statearr_45358[(19)] = inst_45180);

(statearr_45358[(9)] = inst_45181);

(statearr_45358[(20)] = inst_45182);

(statearr_45358[(25)] = inst_45225);

(statearr_45358[(11)] = inst_45183);

return statearr_45358;
})();
var statearr_45360_47445 = state_45263__$1;
(statearr_45360_47445[(2)] = null);

(statearr_45360_47445[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (43))){
var state_45263__$1 = state_45263;
var statearr_45361_47446 = state_45263__$1;
(statearr_45361_47446[(2)] = null);

(statearr_45361_47446[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (29))){
var inst_45234 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45362_47448 = state_45263__$1;
(statearr_45362_47448[(2)] = inst_45234);

(statearr_45362_47448[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (44))){
var inst_45244 = (state_45263[(2)]);
var state_45263__$1 = (function (){var statearr_45367 = state_45263;
(statearr_45367[(26)] = inst_45244);

return statearr_45367;
})();
var statearr_45370_47451 = state_45263__$1;
(statearr_45370_47451[(2)] = null);

(statearr_45370_47451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (6))){
var inst_45170 = (state_45263[(27)]);
var inst_45169 = cljs.core.deref(cs);
var inst_45170__$1 = cljs.core.keys(inst_45169);
var inst_45171 = cljs.core.count(inst_45170__$1);
var inst_45172 = cljs.core.reset_BANG_(dctr,inst_45171);
var inst_45178 = cljs.core.seq(inst_45170__$1);
var inst_45180 = inst_45178;
var inst_45181 = null;
var inst_45182 = (0);
var inst_45183 = (0);
var state_45263__$1 = (function (){var statearr_45376 = state_45263;
(statearr_45376[(19)] = inst_45180);

(statearr_45376[(9)] = inst_45181);

(statearr_45376[(20)] = inst_45182);

(statearr_45376[(28)] = inst_45172);

(statearr_45376[(27)] = inst_45170__$1);

(statearr_45376[(11)] = inst_45183);

return statearr_45376;
})();
var statearr_45379_47456 = state_45263__$1;
(statearr_45379_47456[(2)] = null);

(statearr_45379_47456[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (28))){
var inst_45180 = (state_45263[(19)]);
var inst_45202 = (state_45263[(23)]);
var inst_45202__$1 = cljs.core.seq(inst_45180);
var state_45263__$1 = (function (){var statearr_45385 = state_45263;
(statearr_45385[(23)] = inst_45202__$1);

return statearr_45385;
})();
if(inst_45202__$1){
var statearr_45386_47465 = state_45263__$1;
(statearr_45386_47465[(1)] = (33));

} else {
var statearr_45391_47466 = state_45263__$1;
(statearr_45391_47466[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (25))){
var inst_45182 = (state_45263[(20)]);
var inst_45183 = (state_45263[(11)]);
var inst_45185 = (inst_45183 < inst_45182);
var inst_45186 = inst_45185;
var state_45263__$1 = state_45263;
if(cljs.core.truth_(inst_45186)){
var statearr_45396_47472 = state_45263__$1;
(statearr_45396_47472[(1)] = (27));

} else {
var statearr_45397_47474 = state_45263__$1;
(statearr_45397_47474[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (34))){
var state_45263__$1 = state_45263;
var statearr_45399_47483 = state_45263__$1;
(statearr_45399_47483[(2)] = null);

(statearr_45399_47483[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (17))){
var state_45263__$1 = state_45263;
var statearr_45400_47488 = state_45263__$1;
(statearr_45400_47488[(2)] = null);

(statearr_45400_47488[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (3))){
var inst_45249 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45263__$1,inst_45249);
} else {
if((state_val_45264 === (12))){
var inst_45165 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45405_47494 = state_45263__$1;
(statearr_45405_47494[(2)] = inst_45165);

(statearr_45405_47494[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (2))){
var state_45263__$1 = state_45263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45263__$1,(4),ch);
} else {
if((state_val_45264 === (23))){
var state_45263__$1 = state_45263;
var statearr_45408_47501 = state_45263__$1;
(statearr_45408_47501[(2)] = null);

(statearr_45408_47501[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (35))){
var inst_45232 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45410_47507 = state_45263__$1;
(statearr_45410_47507[(2)] = inst_45232);

(statearr_45410_47507[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (19))){
var inst_45126 = (state_45263[(7)]);
var inst_45135 = cljs.core.chunk_first(inst_45126);
var inst_45136 = cljs.core.chunk_rest(inst_45126);
var inst_45137 = cljs.core.count(inst_45135);
var inst_45096 = inst_45136;
var inst_45097 = inst_45135;
var inst_45098 = inst_45137;
var inst_45099 = (0);
var state_45263__$1 = (function (){var statearr_45413 = state_45263;
(statearr_45413[(13)] = inst_45097);

(statearr_45413[(14)] = inst_45099);

(statearr_45413[(15)] = inst_45096);

(statearr_45413[(16)] = inst_45098);

return statearr_45413;
})();
var statearr_45416_47513 = state_45263__$1;
(statearr_45416_47513[(2)] = null);

(statearr_45416_47513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (11))){
var inst_45126 = (state_45263[(7)]);
var inst_45096 = (state_45263[(15)]);
var inst_45126__$1 = cljs.core.seq(inst_45096);
var state_45263__$1 = (function (){var statearr_45420 = state_45263;
(statearr_45420[(7)] = inst_45126__$1);

return statearr_45420;
})();
if(inst_45126__$1){
var statearr_45421_47517 = state_45263__$1;
(statearr_45421_47517[(1)] = (16));

} else {
var statearr_45422_47518 = state_45263__$1;
(statearr_45422_47518[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (9))){
var inst_45167 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45423_47524 = state_45263__$1;
(statearr_45423_47524[(2)] = inst_45167);

(statearr_45423_47524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (5))){
var inst_45094 = cljs.core.deref(cs);
var inst_45095 = cljs.core.seq(inst_45094);
var inst_45096 = inst_45095;
var inst_45097 = null;
var inst_45098 = (0);
var inst_45099 = (0);
var state_45263__$1 = (function (){var statearr_45427 = state_45263;
(statearr_45427[(13)] = inst_45097);

(statearr_45427[(14)] = inst_45099);

(statearr_45427[(15)] = inst_45096);

(statearr_45427[(16)] = inst_45098);

return statearr_45427;
})();
var statearr_45431_47537 = state_45263__$1;
(statearr_45431_47537[(2)] = null);

(statearr_45431_47537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (14))){
var state_45263__$1 = state_45263;
var statearr_45434_47540 = state_45263__$1;
(statearr_45434_47540[(2)] = null);

(statearr_45434_47540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (45))){
var inst_45241 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45441_47543 = state_45263__$1;
(statearr_45441_47543[(2)] = inst_45241);

(statearr_45441_47543[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (26))){
var inst_45170 = (state_45263[(27)]);
var inst_45236 = (state_45263[(2)]);
var inst_45237 = cljs.core.seq(inst_45170);
var state_45263__$1 = (function (){var statearr_45445 = state_45263;
(statearr_45445[(29)] = inst_45236);

return statearr_45445;
})();
if(inst_45237){
var statearr_45447_47548 = state_45263__$1;
(statearr_45447_47548[(1)] = (42));

} else {
var statearr_45448_47549 = state_45263__$1;
(statearr_45448_47549[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (16))){
var inst_45126 = (state_45263[(7)]);
var inst_45133 = cljs.core.chunked_seq_QMARK_(inst_45126);
var state_45263__$1 = state_45263;
if(inst_45133){
var statearr_45449_47560 = state_45263__$1;
(statearr_45449_47560[(1)] = (19));

} else {
var statearr_45450_47562 = state_45263__$1;
(statearr_45450_47562[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (38))){
var inst_45229 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45452_47563 = state_45263__$1;
(statearr_45452_47563[(2)] = inst_45229);

(statearr_45452_47563[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (30))){
var state_45263__$1 = state_45263;
var statearr_45454_47567 = state_45263__$1;
(statearr_45454_47567[(2)] = null);

(statearr_45454_47567[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (10))){
var inst_45097 = (state_45263[(13)]);
var inst_45099 = (state_45263[(14)]);
var inst_45109 = cljs.core._nth(inst_45097,inst_45099);
var inst_45110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45109,(0),null);
var inst_45112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45109,(1),null);
var state_45263__$1 = (function (){var statearr_45456 = state_45263;
(statearr_45456[(24)] = inst_45110);

return statearr_45456;
})();
if(cljs.core.truth_(inst_45112)){
var statearr_45458_47572 = state_45263__$1;
(statearr_45458_47572[(1)] = (13));

} else {
var statearr_45460_47578 = state_45263__$1;
(statearr_45460_47578[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (18))){
var inst_45163 = (state_45263[(2)]);
var state_45263__$1 = state_45263;
var statearr_45462_47580 = state_45263__$1;
(statearr_45462_47580[(2)] = inst_45163);

(statearr_45462_47580[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (42))){
var state_45263__$1 = state_45263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45263__$1,(45),dchan);
} else {
if((state_val_45264 === (37))){
var inst_45202 = (state_45263[(23)]);
var inst_45218 = (state_45263[(22)]);
var inst_45082 = (state_45263[(12)]);
var inst_45218__$1 = cljs.core.first(inst_45202);
var inst_45219 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_45218__$1,inst_45082,done);
var state_45263__$1 = (function (){var statearr_45463 = state_45263;
(statearr_45463[(22)] = inst_45218__$1);

return statearr_45463;
})();
if(cljs.core.truth_(inst_45219)){
var statearr_45464_47584 = state_45263__$1;
(statearr_45464_47584[(1)] = (39));

} else {
var statearr_45465_47587 = state_45263__$1;
(statearr_45465_47587[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45264 === (8))){
var inst_45099 = (state_45263[(14)]);
var inst_45098 = (state_45263[(16)]);
var inst_45101 = (inst_45099 < inst_45098);
var inst_45102 = inst_45101;
var state_45263__$1 = state_45263;
if(cljs.core.truth_(inst_45102)){
var statearr_45466_47594 = state_45263__$1;
(statearr_45466_47594[(1)] = (10));

} else {
var statearr_45468_47595 = state_45263__$1;
(statearr_45468_47595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43870__auto__ = null;
var cljs$core$async$mult_$_state_machine__43870__auto____0 = (function (){
var statearr_45472 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45472[(0)] = cljs$core$async$mult_$_state_machine__43870__auto__);

(statearr_45472[(1)] = (1));

return statearr_45472;
});
var cljs$core$async$mult_$_state_machine__43870__auto____1 = (function (state_45263){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_45263);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e45476){var ex__43873__auto__ = e45476;
var statearr_45477_47604 = state_45263;
(statearr_45477_47604[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_45263[(4)]))){
var statearr_45478_47608 = state_45263;
(statearr_45478_47608[(1)] = cljs.core.first((state_45263[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47612 = state_45263;
state_45263 = G__47612;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43870__auto__ = function(state_45263){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43870__auto____1.call(this,state_45263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43870__auto____0;
cljs$core$async$mult_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43870__auto____1;
return cljs$core$async$mult_$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_45482 = f__44005__auto__();
(statearr_45482[(6)] = c__44004__auto___47362);

return statearr_45482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45490 = arguments.length;
switch (G__45490) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_47626 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_47626(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_47632 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_47632(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_47639 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_47639(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_47647 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_47647(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_47659 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_47659(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47672 = arguments.length;
var i__4737__auto___47674 = (0);
while(true){
if((i__4737__auto___47674 < len__4736__auto___47672)){
args__4742__auto__.push((arguments[i__4737__auto___47674]));

var G__47676 = (i__4737__auto___47674 + (1));
i__4737__auto___47674 = G__47676;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45531){
var map__45532 = p__45531;
var map__45532__$1 = (((((!((map__45532 == null))))?(((((map__45532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45532):map__45532);
var opts = map__45532__$1;
var statearr_45537_47693 = state;
(statearr_45537_47693[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_45540_47694 = state;
(statearr_45540_47694[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_45545_47701 = state;
(statearr_45545_47701[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45520){
var G__45522 = cljs.core.first(seq45520);
var seq45520__$1 = cljs.core.next(seq45520);
var G__45523 = cljs.core.first(seq45520__$1);
var seq45520__$2 = cljs.core.next(seq45520__$1);
var G__45524 = cljs.core.first(seq45520__$2);
var seq45520__$3 = cljs.core.next(seq45520__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45522,G__45523,G__45524,seq45520__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45562 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45562 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45563){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45563 = meta45563;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45564,meta45563__$1){
var self__ = this;
var _45564__$1 = this;
return (new cljs.core.async.t_cljs$core$async45562(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45563__$1));
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45564){
var self__ = this;
var _45564__$1 = this;
return self__.meta45563;
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45562.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async45562.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45563","meta45563",1172165385,null)], null);
}));

(cljs.core.async.t_cljs$core$async45562.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45562.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45562");

(cljs.core.async.t_cljs$core$async45562.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45562");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45562.
 */
cljs.core.async.__GT_t_cljs$core$async45562 = (function cljs$core$async$mix_$___GT_t_cljs$core$async45562(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45563){
return (new cljs.core.async.t_cljs$core$async45562(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45563));
});

}

return (new cljs.core.async.t_cljs$core$async45562(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44004__auto___47732 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_45702){
var state_val_45703 = (state_45702[(1)]);
if((state_val_45703 === (7))){
var inst_45608 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
var statearr_45706_47733 = state_45702__$1;
(statearr_45706_47733[(2)] = inst_45608);

(statearr_45706_47733[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (20))){
var inst_45620 = (state_45702[(7)]);
var state_45702__$1 = state_45702;
var statearr_45707_47739 = state_45702__$1;
(statearr_45707_47739[(2)] = inst_45620);

(statearr_45707_47739[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (27))){
var state_45702__$1 = state_45702;
var statearr_45708_47741 = state_45702__$1;
(statearr_45708_47741[(2)] = null);

(statearr_45708_47741[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (1))){
var inst_45595 = (state_45702[(8)]);
var inst_45595__$1 = calc_state();
var inst_45597 = (inst_45595__$1 == null);
var inst_45598 = cljs.core.not(inst_45597);
var state_45702__$1 = (function (){var statearr_45709 = state_45702;
(statearr_45709[(8)] = inst_45595__$1);

return statearr_45709;
})();
if(inst_45598){
var statearr_45710_47745 = state_45702__$1;
(statearr_45710_47745[(1)] = (2));

} else {
var statearr_45711_47746 = state_45702__$1;
(statearr_45711_47746[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (24))){
var inst_45673 = (state_45702[(9)]);
var inst_45646 = (state_45702[(10)]);
var inst_45658 = (state_45702[(11)]);
var inst_45673__$1 = (inst_45646.cljs$core$IFn$_invoke$arity$1 ? inst_45646.cljs$core$IFn$_invoke$arity$1(inst_45658) : inst_45646.call(null,inst_45658));
var state_45702__$1 = (function (){var statearr_45713 = state_45702;
(statearr_45713[(9)] = inst_45673__$1);

return statearr_45713;
})();
if(cljs.core.truth_(inst_45673__$1)){
var statearr_45714_47751 = state_45702__$1;
(statearr_45714_47751[(1)] = (29));

} else {
var statearr_45715_47753 = state_45702__$1;
(statearr_45715_47753[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (4))){
var inst_45611 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45611)){
var statearr_45718_47754 = state_45702__$1;
(statearr_45718_47754[(1)] = (8));

} else {
var statearr_45719_47755 = state_45702__$1;
(statearr_45719_47755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (15))){
var inst_45640 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45640)){
var statearr_45722_47756 = state_45702__$1;
(statearr_45722_47756[(1)] = (19));

} else {
var statearr_45723_47757 = state_45702__$1;
(statearr_45723_47757[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (21))){
var inst_45645 = (state_45702[(12)]);
var inst_45645__$1 = (state_45702[(2)]);
var inst_45646 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45645__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45645__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45645__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45702__$1 = (function (){var statearr_45724 = state_45702;
(statearr_45724[(12)] = inst_45645__$1);

(statearr_45724[(13)] = inst_45648);

(statearr_45724[(10)] = inst_45646);

return statearr_45724;
})();
return cljs.core.async.ioc_alts_BANG_(state_45702__$1,(22),inst_45649);
} else {
if((state_val_45703 === (31))){
var inst_45682 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45682)){
var statearr_45725_47758 = state_45702__$1;
(statearr_45725_47758[(1)] = (32));

} else {
var statearr_45726_47759 = state_45702__$1;
(statearr_45726_47759[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (32))){
var inst_45657 = (state_45702[(14)]);
var state_45702__$1 = state_45702;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45702__$1,(35),out,inst_45657);
} else {
if((state_val_45703 === (33))){
var inst_45645 = (state_45702[(12)]);
var inst_45620 = inst_45645;
var state_45702__$1 = (function (){var statearr_45727 = state_45702;
(statearr_45727[(7)] = inst_45620);

return statearr_45727;
})();
var statearr_45728_47766 = state_45702__$1;
(statearr_45728_47766[(2)] = null);

(statearr_45728_47766[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (13))){
var inst_45620 = (state_45702[(7)]);
var inst_45628 = inst_45620.cljs$lang$protocol_mask$partition0$;
var inst_45629 = (inst_45628 & (64));
var inst_45631 = inst_45620.cljs$core$ISeq$;
var inst_45632 = (cljs.core.PROTOCOL_SENTINEL === inst_45631);
var inst_45633 = ((inst_45629) || (inst_45632));
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45633)){
var statearr_45732_47767 = state_45702__$1;
(statearr_45732_47767[(1)] = (16));

} else {
var statearr_45733_47769 = state_45702__$1;
(statearr_45733_47769[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (22))){
var inst_45657 = (state_45702[(14)]);
var inst_45658 = (state_45702[(11)]);
var inst_45656 = (state_45702[(2)]);
var inst_45657__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45656,(0),null);
var inst_45658__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45656,(1),null);
var inst_45659 = (inst_45657__$1 == null);
var inst_45660 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45658__$1,change);
var inst_45661 = ((inst_45659) || (inst_45660));
var state_45702__$1 = (function (){var statearr_45735 = state_45702;
(statearr_45735[(14)] = inst_45657__$1);

(statearr_45735[(11)] = inst_45658__$1);

return statearr_45735;
})();
if(cljs.core.truth_(inst_45661)){
var statearr_45736_47770 = state_45702__$1;
(statearr_45736_47770[(1)] = (23));

} else {
var statearr_45737_47771 = state_45702__$1;
(statearr_45737_47771[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (36))){
var inst_45645 = (state_45702[(12)]);
var inst_45620 = inst_45645;
var state_45702__$1 = (function (){var statearr_45740 = state_45702;
(statearr_45740[(7)] = inst_45620);

return statearr_45740;
})();
var statearr_45741_47772 = state_45702__$1;
(statearr_45741_47772[(2)] = null);

(statearr_45741_47772[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (29))){
var inst_45673 = (state_45702[(9)]);
var state_45702__$1 = state_45702;
var statearr_45745_47773 = state_45702__$1;
(statearr_45745_47773[(2)] = inst_45673);

(statearr_45745_47773[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (6))){
var state_45702__$1 = state_45702;
var statearr_45746_47774 = state_45702__$1;
(statearr_45746_47774[(2)] = false);

(statearr_45746_47774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (28))){
var inst_45668 = (state_45702[(2)]);
var inst_45670 = calc_state();
var inst_45620 = inst_45670;
var state_45702__$1 = (function (){var statearr_45748 = state_45702;
(statearr_45748[(7)] = inst_45620);

(statearr_45748[(15)] = inst_45668);

return statearr_45748;
})();
var statearr_45751_47775 = state_45702__$1;
(statearr_45751_47775[(2)] = null);

(statearr_45751_47775[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (25))){
var inst_45697 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
var statearr_45752_47778 = state_45702__$1;
(statearr_45752_47778[(2)] = inst_45697);

(statearr_45752_47778[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (34))){
var inst_45695 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
var statearr_45756_47779 = state_45702__$1;
(statearr_45756_47779[(2)] = inst_45695);

(statearr_45756_47779[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (17))){
var state_45702__$1 = state_45702;
var statearr_45758_47780 = state_45702__$1;
(statearr_45758_47780[(2)] = false);

(statearr_45758_47780[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (3))){
var state_45702__$1 = state_45702;
var statearr_45761_47782 = state_45702__$1;
(statearr_45761_47782[(2)] = false);

(statearr_45761_47782[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (12))){
var inst_45699 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45702__$1,inst_45699);
} else {
if((state_val_45703 === (2))){
var inst_45595 = (state_45702[(8)]);
var inst_45600 = inst_45595.cljs$lang$protocol_mask$partition0$;
var inst_45601 = (inst_45600 & (64));
var inst_45602 = inst_45595.cljs$core$ISeq$;
var inst_45603 = (cljs.core.PROTOCOL_SENTINEL === inst_45602);
var inst_45604 = ((inst_45601) || (inst_45603));
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45604)){
var statearr_45765_47788 = state_45702__$1;
(statearr_45765_47788[(1)] = (5));

} else {
var statearr_45766_47789 = state_45702__$1;
(statearr_45766_47789[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (23))){
var inst_45657 = (state_45702[(14)]);
var inst_45663 = (inst_45657 == null);
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45663)){
var statearr_45767_47791 = state_45702__$1;
(statearr_45767_47791[(1)] = (26));

} else {
var statearr_45769_47792 = state_45702__$1;
(statearr_45769_47792[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (35))){
var inst_45685 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
if(cljs.core.truth_(inst_45685)){
var statearr_45771_47793 = state_45702__$1;
(statearr_45771_47793[(1)] = (36));

} else {
var statearr_45774_47794 = state_45702__$1;
(statearr_45774_47794[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (19))){
var inst_45620 = (state_45702[(7)]);
var inst_45642 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45620);
var state_45702__$1 = state_45702;
var statearr_45776_47795 = state_45702__$1;
(statearr_45776_47795[(2)] = inst_45642);

(statearr_45776_47795[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (11))){
var inst_45620 = (state_45702[(7)]);
var inst_45624 = (inst_45620 == null);
var inst_45625 = cljs.core.not(inst_45624);
var state_45702__$1 = state_45702;
if(inst_45625){
var statearr_45779_47797 = state_45702__$1;
(statearr_45779_47797[(1)] = (13));

} else {
var statearr_45780_47798 = state_45702__$1;
(statearr_45780_47798[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (9))){
var inst_45595 = (state_45702[(8)]);
var state_45702__$1 = state_45702;
var statearr_45783_47799 = state_45702__$1;
(statearr_45783_47799[(2)] = inst_45595);

(statearr_45783_47799[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (5))){
var state_45702__$1 = state_45702;
var statearr_45786_47804 = state_45702__$1;
(statearr_45786_47804[(2)] = true);

(statearr_45786_47804[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (14))){
var state_45702__$1 = state_45702;
var statearr_45787_47806 = state_45702__$1;
(statearr_45787_47806[(2)] = false);

(statearr_45787_47806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (26))){
var inst_45658 = (state_45702[(11)]);
var inst_45665 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_45658);
var state_45702__$1 = state_45702;
var statearr_45790_47808 = state_45702__$1;
(statearr_45790_47808[(2)] = inst_45665);

(statearr_45790_47808[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (16))){
var state_45702__$1 = state_45702;
var statearr_45793_47809 = state_45702__$1;
(statearr_45793_47809[(2)] = true);

(statearr_45793_47809[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (38))){
var inst_45690 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
var statearr_45795_47810 = state_45702__$1;
(statearr_45795_47810[(2)] = inst_45690);

(statearr_45795_47810[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (30))){
var inst_45648 = (state_45702[(13)]);
var inst_45646 = (state_45702[(10)]);
var inst_45658 = (state_45702[(11)]);
var inst_45677 = cljs.core.empty_QMARK_(inst_45646);
var inst_45678 = (inst_45648.cljs$core$IFn$_invoke$arity$1 ? inst_45648.cljs$core$IFn$_invoke$arity$1(inst_45658) : inst_45648.call(null,inst_45658));
var inst_45679 = cljs.core.not(inst_45678);
var inst_45680 = ((inst_45677) && (inst_45679));
var state_45702__$1 = state_45702;
var statearr_45796_47811 = state_45702__$1;
(statearr_45796_47811[(2)] = inst_45680);

(statearr_45796_47811[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (10))){
var inst_45595 = (state_45702[(8)]);
var inst_45616 = (state_45702[(2)]);
var inst_45617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45616,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45616,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45616,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45620 = inst_45595;
var state_45702__$1 = (function (){var statearr_45797 = state_45702;
(statearr_45797[(7)] = inst_45620);

(statearr_45797[(16)] = inst_45618);

(statearr_45797[(17)] = inst_45617);

(statearr_45797[(18)] = inst_45619);

return statearr_45797;
})();
var statearr_45798_47812 = state_45702__$1;
(statearr_45798_47812[(2)] = null);

(statearr_45798_47812[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (18))){
var inst_45637 = (state_45702[(2)]);
var state_45702__$1 = state_45702;
var statearr_45799_47813 = state_45702__$1;
(statearr_45799_47813[(2)] = inst_45637);

(statearr_45799_47813[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (37))){
var state_45702__$1 = state_45702;
var statearr_45804_47815 = state_45702__$1;
(statearr_45804_47815[(2)] = null);

(statearr_45804_47815[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45703 === (8))){
var inst_45595 = (state_45702[(8)]);
var inst_45613 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_45595);
var state_45702__$1 = state_45702;
var statearr_45809_47817 = state_45702__$1;
(statearr_45809_47817[(2)] = inst_45613);

(statearr_45809_47817[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43870__auto__ = null;
var cljs$core$async$mix_$_state_machine__43870__auto____0 = (function (){
var statearr_45814 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45814[(0)] = cljs$core$async$mix_$_state_machine__43870__auto__);

(statearr_45814[(1)] = (1));

return statearr_45814;
});
var cljs$core$async$mix_$_state_machine__43870__auto____1 = (function (state_45702){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_45702);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e45816){var ex__43873__auto__ = e45816;
var statearr_45817_47826 = state_45702;
(statearr_45817_47826[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_45702[(4)]))){
var statearr_45818_47827 = state_45702;
(statearr_45818_47827[(1)] = cljs.core.first((state_45702[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47831 = state_45702;
state_45702 = G__47831;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43870__auto__ = function(state_45702){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43870__auto____1.call(this,state_45702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43870__auto____0;
cljs$core$async$mix_$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43870__auto____1;
return cljs$core$async$mix_$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_45820 = f__44005__auto__();
(statearr_45820[(6)] = c__44004__auto___47732);

return statearr_45820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47848 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47848(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47852 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47852(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47859 = (function() {
var G__47860 = null;
var G__47860__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__47860__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__47860 = function(p,v){
switch(arguments.length){
case 1:
return G__47860__1.call(this,p);
case 2:
return G__47860__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47860.cljs$core$IFn$_invoke$arity$1 = G__47860__1;
G__47860.cljs$core$IFn$_invoke$arity$2 = G__47860__2;
return G__47860;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45838 = arguments.length;
switch (G__45838) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47859(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47859(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45843 = arguments.length;
switch (G__45843) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__45841_SHARP_){
if(cljs.core.truth_((p1__45841_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45841_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__45841_SHARP_.call(null,topic)))){
return p1__45841_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__45841_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45846 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45846 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45847){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45847 = meta45847;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45848,meta45847__$1){
var self__ = this;
var _45848__$1 = this;
return (new cljs.core.async.t_cljs$core$async45846(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45847__$1));
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45848){
var self__ = this;
var _45848__$1 = this;
return self__.meta45847;
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45846.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45846.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45847","meta45847",1508364703,null)], null);
}));

(cljs.core.async.t_cljs$core$async45846.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45846.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45846");

(cljs.core.async.t_cljs$core$async45846.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45846");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45846.
 */
cljs.core.async.__GT_t_cljs$core$async45846 = (function cljs$core$async$__GT_t_cljs$core$async45846(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45847){
return (new cljs.core.async.t_cljs$core$async45846(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45847));
});

}

return (new cljs.core.async.t_cljs$core$async45846(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44004__auto___47912 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_45928){
var state_val_45929 = (state_45928[(1)]);
if((state_val_45929 === (7))){
var inst_45923 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
var statearr_45931_47914 = state_45928__$1;
(statearr_45931_47914[(2)] = inst_45923);

(statearr_45931_47914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (20))){
var state_45928__$1 = state_45928;
var statearr_45932_47919 = state_45928__$1;
(statearr_45932_47919[(2)] = null);

(statearr_45932_47919[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (1))){
var state_45928__$1 = state_45928;
var statearr_45933_47923 = state_45928__$1;
(statearr_45933_47923[(2)] = null);

(statearr_45933_47923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (24))){
var inst_45906 = (state_45928[(7)]);
var inst_45915 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_45906);
var state_45928__$1 = state_45928;
var statearr_45934_47925 = state_45928__$1;
(statearr_45934_47925[(2)] = inst_45915);

(statearr_45934_47925[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (4))){
var inst_45857 = (state_45928[(8)]);
var inst_45857__$1 = (state_45928[(2)]);
var inst_45859 = (inst_45857__$1 == null);
var state_45928__$1 = (function (){var statearr_45935 = state_45928;
(statearr_45935[(8)] = inst_45857__$1);

return statearr_45935;
})();
if(cljs.core.truth_(inst_45859)){
var statearr_45936_47929 = state_45928__$1;
(statearr_45936_47929[(1)] = (5));

} else {
var statearr_45937_47930 = state_45928__$1;
(statearr_45937_47930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (15))){
var inst_45900 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
var statearr_45938_47935 = state_45928__$1;
(statearr_45938_47935[(2)] = inst_45900);

(statearr_45938_47935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (21))){
var inst_45920 = (state_45928[(2)]);
var state_45928__$1 = (function (){var statearr_45939 = state_45928;
(statearr_45939[(9)] = inst_45920);

return statearr_45939;
})();
var statearr_45940_47942 = state_45928__$1;
(statearr_45940_47942[(2)] = null);

(statearr_45940_47942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (13))){
var inst_45882 = (state_45928[(10)]);
var inst_45884 = cljs.core.chunked_seq_QMARK_(inst_45882);
var state_45928__$1 = state_45928;
if(inst_45884){
var statearr_45941_47951 = state_45928__$1;
(statearr_45941_47951[(1)] = (16));

} else {
var statearr_45942_47952 = state_45928__$1;
(statearr_45942_47952[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (22))){
var inst_45912 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
if(cljs.core.truth_(inst_45912)){
var statearr_45943_47956 = state_45928__$1;
(statearr_45943_47956[(1)] = (23));

} else {
var statearr_45944_47958 = state_45928__$1;
(statearr_45944_47958[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (6))){
var inst_45908 = (state_45928[(11)]);
var inst_45906 = (state_45928[(7)]);
var inst_45857 = (state_45928[(8)]);
var inst_45906__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_45857) : topic_fn.call(null,inst_45857));
var inst_45907 = cljs.core.deref(mults);
var inst_45908__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45907,inst_45906__$1);
var state_45928__$1 = (function (){var statearr_45946 = state_45928;
(statearr_45946[(11)] = inst_45908__$1);

(statearr_45946[(7)] = inst_45906__$1);

return statearr_45946;
})();
if(cljs.core.truth_(inst_45908__$1)){
var statearr_45947_47980 = state_45928__$1;
(statearr_45947_47980[(1)] = (19));

} else {
var statearr_45948_47989 = state_45928__$1;
(statearr_45948_47989[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (25))){
var inst_45917 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
var statearr_45951_47990 = state_45928__$1;
(statearr_45951_47990[(2)] = inst_45917);

(statearr_45951_47990[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (17))){
var inst_45882 = (state_45928[(10)]);
var inst_45891 = cljs.core.first(inst_45882);
var inst_45892 = cljs.core.async.muxch_STAR_(inst_45891);
var inst_45893 = cljs.core.async.close_BANG_(inst_45892);
var inst_45894 = cljs.core.next(inst_45882);
var inst_45868 = inst_45894;
var inst_45869 = null;
var inst_45870 = (0);
var inst_45871 = (0);
var state_45928__$1 = (function (){var statearr_45952 = state_45928;
(statearr_45952[(12)] = inst_45870);

(statearr_45952[(13)] = inst_45868);

(statearr_45952[(14)] = inst_45893);

(statearr_45952[(15)] = inst_45869);

(statearr_45952[(16)] = inst_45871);

return statearr_45952;
})();
var statearr_45953_48009 = state_45928__$1;
(statearr_45953_48009[(2)] = null);

(statearr_45953_48009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (3))){
var inst_45925 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45928__$1,inst_45925);
} else {
if((state_val_45929 === (12))){
var inst_45902 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
var statearr_45955_48014 = state_45928__$1;
(statearr_45955_48014[(2)] = inst_45902);

(statearr_45955_48014[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (2))){
var state_45928__$1 = state_45928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45928__$1,(4),ch);
} else {
if((state_val_45929 === (23))){
var state_45928__$1 = state_45928;
var statearr_45958_48027 = state_45928__$1;
(statearr_45958_48027[(2)] = null);

(statearr_45958_48027[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (19))){
var inst_45908 = (state_45928[(11)]);
var inst_45857 = (state_45928[(8)]);
var inst_45910 = cljs.core.async.muxch_STAR_(inst_45908);
var state_45928__$1 = state_45928;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45928__$1,(22),inst_45910,inst_45857);
} else {
if((state_val_45929 === (11))){
var inst_45868 = (state_45928[(13)]);
var inst_45882 = (state_45928[(10)]);
var inst_45882__$1 = cljs.core.seq(inst_45868);
var state_45928__$1 = (function (){var statearr_45959 = state_45928;
(statearr_45959[(10)] = inst_45882__$1);

return statearr_45959;
})();
if(inst_45882__$1){
var statearr_45960_48032 = state_45928__$1;
(statearr_45960_48032[(1)] = (13));

} else {
var statearr_45961_48034 = state_45928__$1;
(statearr_45961_48034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (9))){
var inst_45904 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
var statearr_45963_48039 = state_45928__$1;
(statearr_45963_48039[(2)] = inst_45904);

(statearr_45963_48039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (5))){
var inst_45865 = cljs.core.deref(mults);
var inst_45866 = cljs.core.vals(inst_45865);
var inst_45867 = cljs.core.seq(inst_45866);
var inst_45868 = inst_45867;
var inst_45869 = null;
var inst_45870 = (0);
var inst_45871 = (0);
var state_45928__$1 = (function (){var statearr_45964 = state_45928;
(statearr_45964[(12)] = inst_45870);

(statearr_45964[(13)] = inst_45868);

(statearr_45964[(15)] = inst_45869);

(statearr_45964[(16)] = inst_45871);

return statearr_45964;
})();
var statearr_45965_48053 = state_45928__$1;
(statearr_45965_48053[(2)] = null);

(statearr_45965_48053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (14))){
var state_45928__$1 = state_45928;
var statearr_45969_48054 = state_45928__$1;
(statearr_45969_48054[(2)] = null);

(statearr_45969_48054[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (16))){
var inst_45882 = (state_45928[(10)]);
var inst_45886 = cljs.core.chunk_first(inst_45882);
var inst_45887 = cljs.core.chunk_rest(inst_45882);
var inst_45888 = cljs.core.count(inst_45886);
var inst_45868 = inst_45887;
var inst_45869 = inst_45886;
var inst_45870 = inst_45888;
var inst_45871 = (0);
var state_45928__$1 = (function (){var statearr_45970 = state_45928;
(statearr_45970[(12)] = inst_45870);

(statearr_45970[(13)] = inst_45868);

(statearr_45970[(15)] = inst_45869);

(statearr_45970[(16)] = inst_45871);

return statearr_45970;
})();
var statearr_45971_48070 = state_45928__$1;
(statearr_45971_48070[(2)] = null);

(statearr_45971_48070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (10))){
var inst_45870 = (state_45928[(12)]);
var inst_45868 = (state_45928[(13)]);
var inst_45869 = (state_45928[(15)]);
var inst_45871 = (state_45928[(16)]);
var inst_45876 = cljs.core._nth(inst_45869,inst_45871);
var inst_45877 = cljs.core.async.muxch_STAR_(inst_45876);
var inst_45878 = cljs.core.async.close_BANG_(inst_45877);
var inst_45879 = (inst_45871 + (1));
var tmp45966 = inst_45870;
var tmp45967 = inst_45868;
var tmp45968 = inst_45869;
var inst_45868__$1 = tmp45967;
var inst_45869__$1 = tmp45968;
var inst_45870__$1 = tmp45966;
var inst_45871__$1 = inst_45879;
var state_45928__$1 = (function (){var statearr_45973 = state_45928;
(statearr_45973[(17)] = inst_45878);

(statearr_45973[(12)] = inst_45870__$1);

(statearr_45973[(13)] = inst_45868__$1);

(statearr_45973[(15)] = inst_45869__$1);

(statearr_45973[(16)] = inst_45871__$1);

return statearr_45973;
})();
var statearr_45974_48081 = state_45928__$1;
(statearr_45974_48081[(2)] = null);

(statearr_45974_48081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (18))){
var inst_45897 = (state_45928[(2)]);
var state_45928__$1 = state_45928;
var statearr_45975_48092 = state_45928__$1;
(statearr_45975_48092[(2)] = inst_45897);

(statearr_45975_48092[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45929 === (8))){
var inst_45870 = (state_45928[(12)]);
var inst_45871 = (state_45928[(16)]);
var inst_45873 = (inst_45871 < inst_45870);
var inst_45874 = inst_45873;
var state_45928__$1 = state_45928;
if(cljs.core.truth_(inst_45874)){
var statearr_45976_48096 = state_45928__$1;
(statearr_45976_48096[(1)] = (10));

} else {
var statearr_45977_48097 = state_45928__$1;
(statearr_45977_48097[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_45980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45980[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_45980[(1)] = (1));

return statearr_45980;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_45928){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_45928);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e45981){var ex__43873__auto__ = e45981;
var statearr_45982_48105 = state_45928;
(statearr_45982_48105[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_45928[(4)]))){
var statearr_45983_48106 = state_45928;
(statearr_45983_48106[(1)] = cljs.core.first((state_45928[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48109 = state_45928;
state_45928 = G__48109;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_45928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_45928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_45984 = f__44005__auto__();
(statearr_45984[(6)] = c__44004__auto___47912);

return statearr_45984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45986 = arguments.length;
switch (G__45986) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45990 = arguments.length;
switch (G__45990) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45994 = arguments.length;
switch (G__45994) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__44004__auto___48151 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46039){
var state_val_46040 = (state_46039[(1)]);
if((state_val_46040 === (7))){
var state_46039__$1 = state_46039;
var statearr_46044_48155 = state_46039__$1;
(statearr_46044_48155[(2)] = null);

(statearr_46044_48155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (1))){
var state_46039__$1 = state_46039;
var statearr_46045_48161 = state_46039__$1;
(statearr_46045_48161[(2)] = null);

(statearr_46045_48161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (4))){
var inst_45998 = (state_46039[(7)]);
var inst_45999 = (state_46039[(8)]);
var inst_46001 = (inst_45999 < inst_45998);
var state_46039__$1 = state_46039;
if(cljs.core.truth_(inst_46001)){
var statearr_46046_48166 = state_46039__$1;
(statearr_46046_48166[(1)] = (6));

} else {
var statearr_46047_48167 = state_46039__$1;
(statearr_46047_48167[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (15))){
var inst_46024 = (state_46039[(9)]);
var inst_46029 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_46024);
var state_46039__$1 = state_46039;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46039__$1,(17),out,inst_46029);
} else {
if((state_val_46040 === (13))){
var inst_46024 = (state_46039[(9)]);
var inst_46024__$1 = (state_46039[(2)]);
var inst_46025 = cljs.core.some(cljs.core.nil_QMARK_,inst_46024__$1);
var state_46039__$1 = (function (){var statearr_46048 = state_46039;
(statearr_46048[(9)] = inst_46024__$1);

return statearr_46048;
})();
if(cljs.core.truth_(inst_46025)){
var statearr_46049_48178 = state_46039__$1;
(statearr_46049_48178[(1)] = (14));

} else {
var statearr_46050_48180 = state_46039__$1;
(statearr_46050_48180[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (6))){
var state_46039__$1 = state_46039;
var statearr_46051_48188 = state_46039__$1;
(statearr_46051_48188[(2)] = null);

(statearr_46051_48188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (17))){
var inst_46031 = (state_46039[(2)]);
var state_46039__$1 = (function (){var statearr_46058 = state_46039;
(statearr_46058[(10)] = inst_46031);

return statearr_46058;
})();
var statearr_46059_48191 = state_46039__$1;
(statearr_46059_48191[(2)] = null);

(statearr_46059_48191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (3))){
var inst_46036 = (state_46039[(2)]);
var state_46039__$1 = state_46039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46039__$1,inst_46036);
} else {
if((state_val_46040 === (12))){
var _ = (function (){var statearr_46062 = state_46039;
(statearr_46062[(4)] = cljs.core.rest((state_46039[(4)])));

return statearr_46062;
})();
var state_46039__$1 = state_46039;
var ex46056 = (state_46039__$1[(2)]);
var statearr_46064_48196 = state_46039__$1;
(statearr_46064_48196[(5)] = ex46056);


if((ex46056 instanceof Object)){
var statearr_46065_48200 = state_46039__$1;
(statearr_46065_48200[(1)] = (11));

(statearr_46065_48200[(5)] = null);

} else {
throw ex46056;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (2))){
var inst_45997 = cljs.core.reset_BANG_(dctr,cnt);
var inst_45998 = cnt;
var inst_45999 = (0);
var state_46039__$1 = (function (){var statearr_46066 = state_46039;
(statearr_46066[(11)] = inst_45997);

(statearr_46066[(7)] = inst_45998);

(statearr_46066[(8)] = inst_45999);

return statearr_46066;
})();
var statearr_46067_48207 = state_46039__$1;
(statearr_46067_48207[(2)] = null);

(statearr_46067_48207[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (11))){
var inst_46003 = (state_46039[(2)]);
var inst_46004 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_46039__$1 = (function (){var statearr_46068 = state_46039;
(statearr_46068[(12)] = inst_46003);

return statearr_46068;
})();
var statearr_46069_48216 = state_46039__$1;
(statearr_46069_48216[(2)] = inst_46004);

(statearr_46069_48216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (9))){
var inst_45999 = (state_46039[(8)]);
var _ = (function (){var statearr_46070 = state_46039;
(statearr_46070[(4)] = cljs.core.cons((12),(state_46039[(4)])));

return statearr_46070;
})();
var inst_46010 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_45999) : chs__$1.call(null,inst_45999));
var inst_46011 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_45999) : done.call(null,inst_45999));
var inst_46012 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_46010,inst_46011);
var ___$1 = (function (){var statearr_46071 = state_46039;
(statearr_46071[(4)] = cljs.core.rest((state_46039[(4)])));

return statearr_46071;
})();
var state_46039__$1 = state_46039;
var statearr_46072_48225 = state_46039__$1;
(statearr_46072_48225[(2)] = inst_46012);

(statearr_46072_48225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (5))){
var inst_46022 = (state_46039[(2)]);
var state_46039__$1 = (function (){var statearr_46073 = state_46039;
(statearr_46073[(13)] = inst_46022);

return statearr_46073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46039__$1,(13),dchan);
} else {
if((state_val_46040 === (14))){
var inst_46027 = cljs.core.async.close_BANG_(out);
var state_46039__$1 = state_46039;
var statearr_46074_48227 = state_46039__$1;
(statearr_46074_48227[(2)] = inst_46027);

(statearr_46074_48227[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (16))){
var inst_46034 = (state_46039[(2)]);
var state_46039__$1 = state_46039;
var statearr_46079_48233 = state_46039__$1;
(statearr_46079_48233[(2)] = inst_46034);

(statearr_46079_48233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (10))){
var inst_45999 = (state_46039[(8)]);
var inst_46015 = (state_46039[(2)]);
var inst_46016 = (inst_45999 + (1));
var inst_45999__$1 = inst_46016;
var state_46039__$1 = (function (){var statearr_46082 = state_46039;
(statearr_46082[(14)] = inst_46015);

(statearr_46082[(8)] = inst_45999__$1);

return statearr_46082;
})();
var statearr_46083_48242 = state_46039__$1;
(statearr_46083_48242[(2)] = null);

(statearr_46083_48242[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46040 === (8))){
var inst_46020 = (state_46039[(2)]);
var state_46039__$1 = state_46039;
var statearr_46084_48251 = state_46039__$1;
(statearr_46084_48251[(2)] = inst_46020);

(statearr_46084_48251[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46087[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46087[(1)] = (1));

return statearr_46087;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46039){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46039);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46088){var ex__43873__auto__ = e46088;
var statearr_46089_48257 = state_46039;
(statearr_46089_48257[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46039[(4)]))){
var statearr_46090_48258 = state_46039;
(statearr_46090_48258[(1)] = cljs.core.first((state_46039[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48261 = state_46039;
state_46039 = G__48261;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46039){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46096 = f__44005__auto__();
(statearr_46096[(6)] = c__44004__auto___48151);

return statearr_46096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46105 = arguments.length;
switch (G__46105) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44004__auto___48266 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46151){
var state_val_46152 = (state_46151[(1)]);
if((state_val_46152 === (7))){
var inst_46124 = (state_46151[(7)]);
var inst_46125 = (state_46151[(8)]);
var inst_46124__$1 = (state_46151[(2)]);
var inst_46125__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46124__$1,(0),null);
var inst_46126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46124__$1,(1),null);
var inst_46127 = (inst_46125__$1 == null);
var state_46151__$1 = (function (){var statearr_46159 = state_46151;
(statearr_46159[(9)] = inst_46126);

(statearr_46159[(7)] = inst_46124__$1);

(statearr_46159[(8)] = inst_46125__$1);

return statearr_46159;
})();
if(cljs.core.truth_(inst_46127)){
var statearr_46160_48271 = state_46151__$1;
(statearr_46160_48271[(1)] = (8));

} else {
var statearr_46161_48272 = state_46151__$1;
(statearr_46161_48272[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (1))){
var inst_46114 = cljs.core.vec(chs);
var inst_46115 = inst_46114;
var state_46151__$1 = (function (){var statearr_46165 = state_46151;
(statearr_46165[(10)] = inst_46115);

return statearr_46165;
})();
var statearr_46166_48276 = state_46151__$1;
(statearr_46166_48276[(2)] = null);

(statearr_46166_48276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (4))){
var inst_46115 = (state_46151[(10)]);
var state_46151__$1 = state_46151;
return cljs.core.async.ioc_alts_BANG_(state_46151__$1,(7),inst_46115);
} else {
if((state_val_46152 === (6))){
var inst_46144 = (state_46151[(2)]);
var state_46151__$1 = state_46151;
var statearr_46168_48278 = state_46151__$1;
(statearr_46168_48278[(2)] = inst_46144);

(statearr_46168_48278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (3))){
var inst_46146 = (state_46151[(2)]);
var state_46151__$1 = state_46151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46151__$1,inst_46146);
} else {
if((state_val_46152 === (2))){
var inst_46115 = (state_46151[(10)]);
var inst_46117 = cljs.core.count(inst_46115);
var inst_46118 = (inst_46117 > (0));
var state_46151__$1 = state_46151;
if(cljs.core.truth_(inst_46118)){
var statearr_46173_48281 = state_46151__$1;
(statearr_46173_48281[(1)] = (4));

} else {
var statearr_46174_48282 = state_46151__$1;
(statearr_46174_48282[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (11))){
var inst_46115 = (state_46151[(10)]);
var inst_46136 = (state_46151[(2)]);
var tmp46169 = inst_46115;
var inst_46115__$1 = tmp46169;
var state_46151__$1 = (function (){var statearr_46183 = state_46151;
(statearr_46183[(11)] = inst_46136);

(statearr_46183[(10)] = inst_46115__$1);

return statearr_46183;
})();
var statearr_46184_48284 = state_46151__$1;
(statearr_46184_48284[(2)] = null);

(statearr_46184_48284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (9))){
var inst_46125 = (state_46151[(8)]);
var state_46151__$1 = state_46151;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46151__$1,(11),out,inst_46125);
} else {
if((state_val_46152 === (5))){
var inst_46142 = cljs.core.async.close_BANG_(out);
var state_46151__$1 = state_46151;
var statearr_46185_48286 = state_46151__$1;
(statearr_46185_48286[(2)] = inst_46142);

(statearr_46185_48286[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (10))){
var inst_46140 = (state_46151[(2)]);
var state_46151__$1 = state_46151;
var statearr_46186_48288 = state_46151__$1;
(statearr_46186_48288[(2)] = inst_46140);

(statearr_46186_48288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46152 === (8))){
var inst_46126 = (state_46151[(9)]);
var inst_46124 = (state_46151[(7)]);
var inst_46125 = (state_46151[(8)]);
var inst_46115 = (state_46151[(10)]);
var inst_46130 = (function (){var cs = inst_46115;
var vec__46120 = inst_46124;
var v = inst_46125;
var c = inst_46126;
return (function (p1__46101_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__46101_SHARP_);
});
})();
var inst_46131 = cljs.core.filterv(inst_46130,inst_46115);
var inst_46115__$1 = inst_46131;
var state_46151__$1 = (function (){var statearr_46188 = state_46151;
(statearr_46188[(10)] = inst_46115__$1);

return statearr_46188;
})();
var statearr_46189_48291 = state_46151__$1;
(statearr_46189_48291[(2)] = null);

(statearr_46189_48291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46190 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46190[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46190[(1)] = (1));

return statearr_46190;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46151){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46151);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46191){var ex__43873__auto__ = e46191;
var statearr_46192_48297 = state_46151;
(statearr_46192_48297[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46151[(4)]))){
var statearr_46193_48298 = state_46151;
(statearr_46193_48298[(1)] = cljs.core.first((state_46151[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48303 = state_46151;
state_46151 = G__48303;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46151){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46194 = f__44005__auto__();
(statearr_46194[(6)] = c__44004__auto___48266);

return statearr_46194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__46202 = arguments.length;
switch (G__46202) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44004__auto___48319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46233){
var state_val_46235 = (state_46233[(1)]);
if((state_val_46235 === (7))){
var inst_46214 = (state_46233[(7)]);
var inst_46214__$1 = (state_46233[(2)]);
var inst_46216 = (inst_46214__$1 == null);
var inst_46217 = cljs.core.not(inst_46216);
var state_46233__$1 = (function (){var statearr_46239 = state_46233;
(statearr_46239[(7)] = inst_46214__$1);

return statearr_46239;
})();
if(inst_46217){
var statearr_46240_48320 = state_46233__$1;
(statearr_46240_48320[(1)] = (8));

} else {
var statearr_46241_48321 = state_46233__$1;
(statearr_46241_48321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (1))){
var inst_46209 = (0);
var state_46233__$1 = (function (){var statearr_46242 = state_46233;
(statearr_46242[(8)] = inst_46209);

return statearr_46242;
})();
var statearr_46243_48327 = state_46233__$1;
(statearr_46243_48327[(2)] = null);

(statearr_46243_48327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (4))){
var state_46233__$1 = state_46233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46233__$1,(7),ch);
} else {
if((state_val_46235 === (6))){
var inst_46228 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46247_48340 = state_46233__$1;
(statearr_46247_48340[(2)] = inst_46228);

(statearr_46247_48340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (3))){
var inst_46230 = (state_46233[(2)]);
var inst_46231 = cljs.core.async.close_BANG_(out);
var state_46233__$1 = (function (){var statearr_46248 = state_46233;
(statearr_46248[(9)] = inst_46230);

return statearr_46248;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46233__$1,inst_46231);
} else {
if((state_val_46235 === (2))){
var inst_46209 = (state_46233[(8)]);
var inst_46211 = (inst_46209 < n);
var state_46233__$1 = state_46233;
if(cljs.core.truth_(inst_46211)){
var statearr_46249_48351 = state_46233__$1;
(statearr_46249_48351[(1)] = (4));

} else {
var statearr_46250_48352 = state_46233__$1;
(statearr_46250_48352[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (11))){
var inst_46209 = (state_46233[(8)]);
var inst_46220 = (state_46233[(2)]);
var inst_46221 = (inst_46209 + (1));
var inst_46209__$1 = inst_46221;
var state_46233__$1 = (function (){var statearr_46251 = state_46233;
(statearr_46251[(10)] = inst_46220);

(statearr_46251[(8)] = inst_46209__$1);

return statearr_46251;
})();
var statearr_46252_48357 = state_46233__$1;
(statearr_46252_48357[(2)] = null);

(statearr_46252_48357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (9))){
var state_46233__$1 = state_46233;
var statearr_46253_48358 = state_46233__$1;
(statearr_46253_48358[(2)] = null);

(statearr_46253_48358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (5))){
var state_46233__$1 = state_46233;
var statearr_46254_48359 = state_46233__$1;
(statearr_46254_48359[(2)] = null);

(statearr_46254_48359[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (10))){
var inst_46225 = (state_46233[(2)]);
var state_46233__$1 = state_46233;
var statearr_46257_48360 = state_46233__$1;
(statearr_46257_48360[(2)] = inst_46225);

(statearr_46257_48360[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46235 === (8))){
var inst_46214 = (state_46233[(7)]);
var state_46233__$1 = state_46233;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46233__$1,(11),out,inst_46214);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46263 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46263[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46263[(1)] = (1));

return statearr_46263;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46233){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46233);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46265){var ex__43873__auto__ = e46265;
var statearr_46266_48379 = state_46233;
(statearr_46266_48379[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46233[(4)]))){
var statearr_46269_48384 = state_46233;
(statearr_46269_48384[(1)] = cljs.core.first((state_46233[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48389 = state_46233;
state_46233 = G__48389;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46233){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46273 = f__44005__auto__();
(statearr_46273[(6)] = c__44004__auto___48319);

return statearr_46273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46277 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46277 = (function (f,ch,meta46278){
this.f = f;
this.ch = ch;
this.meta46278 = meta46278;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46279,meta46278__$1){
var self__ = this;
var _46279__$1 = this;
return (new cljs.core.async.t_cljs$core$async46277(self__.f,self__.ch,meta46278__$1));
}));

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46279){
var self__ = this;
var _46279__$1 = this;
return self__.meta46278;
}));

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46295 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46295 = (function (f,ch,meta46278,_,fn1,meta46296){
this.f = f;
this.ch = ch;
this.meta46278 = meta46278;
this._ = _;
this.fn1 = fn1;
this.meta46296 = meta46296;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46295.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46297,meta46296__$1){
var self__ = this;
var _46297__$1 = this;
return (new cljs.core.async.t_cljs$core$async46295(self__.f,self__.ch,self__.meta46278,self__._,self__.fn1,meta46296__$1));
}));

(cljs.core.async.t_cljs$core$async46295.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46297){
var self__ = this;
var _46297__$1 = this;
return self__.meta46296;
}));

(cljs.core.async.t_cljs$core$async46295.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46295.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async46295.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async46295.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__46275_SHARP_){
var G__46310 = (((p1__46275_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__46275_SHARP_) : self__.f.call(null,p1__46275_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__46310) : f1.call(null,G__46310));
});
}));

(cljs.core.async.t_cljs$core$async46295.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46278","meta46278",-1897814425,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async46277","cljs.core.async/t_cljs$core$async46277",278073168,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta46296","meta46296",945974210,null)], null);
}));

(cljs.core.async.t_cljs$core$async46295.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46295.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46295");

(cljs.core.async.t_cljs$core$async46295.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46295");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46295.
 */
cljs.core.async.__GT_t_cljs$core$async46295 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46295(f__$1,ch__$1,meta46278__$1,___$2,fn1__$1,meta46296){
return (new cljs.core.async.t_cljs$core$async46295(f__$1,ch__$1,meta46278__$1,___$2,fn1__$1,meta46296));
});

}

return (new cljs.core.async.t_cljs$core$async46295(self__.f,self__.ch,self__.meta46278,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__46326 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__46326) : self__.f.call(null,G__46326));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46277.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async46277.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46278","meta46278",-1897814425,null)], null);
}));

(cljs.core.async.t_cljs$core$async46277.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46277.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46277");

(cljs.core.async.t_cljs$core$async46277.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46277");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46277.
 */
cljs.core.async.__GT_t_cljs$core$async46277 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46277(f__$1,ch__$1,meta46278){
return (new cljs.core.async.t_cljs$core$async46277(f__$1,ch__$1,meta46278));
});

}

return (new cljs.core.async.t_cljs$core$async46277(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46337 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46337 = (function (f,ch,meta46338){
this.f = f;
this.ch = ch;
this.meta46338 = meta46338;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46339,meta46338__$1){
var self__ = this;
var _46339__$1 = this;
return (new cljs.core.async.t_cljs$core$async46337(self__.f,self__.ch,meta46338__$1));
}));

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46339){
var self__ = this;
var _46339__$1 = this;
return self__.meta46338;
}));

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46337.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async46337.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46338","meta46338",301388419,null)], null);
}));

(cljs.core.async.t_cljs$core$async46337.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46337.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46337");

(cljs.core.async.t_cljs$core$async46337.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46337");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46337.
 */
cljs.core.async.__GT_t_cljs$core$async46337 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async46337(f__$1,ch__$1,meta46338){
return (new cljs.core.async.t_cljs$core$async46337(f__$1,ch__$1,meta46338));
});

}

return (new cljs.core.async.t_cljs$core$async46337(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46347 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46347 = (function (p,ch,meta46348){
this.p = p;
this.ch = ch;
this.meta46348 = meta46348;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46349,meta46348__$1){
var self__ = this;
var _46349__$1 = this;
return (new cljs.core.async.t_cljs$core$async46347(self__.p,self__.ch,meta46348__$1));
}));

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46349){
var self__ = this;
var _46349__$1 = this;
return self__.meta46348;
}));

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46347.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async46347.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46348","meta46348",-1423285223,null)], null);
}));

(cljs.core.async.t_cljs$core$async46347.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46347.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46347");

(cljs.core.async.t_cljs$core$async46347.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46347");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46347.
 */
cljs.core.async.__GT_t_cljs$core$async46347 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async46347(p__$1,ch__$1,meta46348){
return (new cljs.core.async.t_cljs$core$async46347(p__$1,ch__$1,meta46348));
});

}

return (new cljs.core.async.t_cljs$core$async46347(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__46361 = arguments.length;
switch (G__46361) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44004__auto___48477 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46387){
var state_val_46388 = (state_46387[(1)]);
if((state_val_46388 === (7))){
var inst_46383 = (state_46387[(2)]);
var state_46387__$1 = state_46387;
var statearr_46389_48486 = state_46387__$1;
(statearr_46389_48486[(2)] = inst_46383);

(statearr_46389_48486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (1))){
var state_46387__$1 = state_46387;
var statearr_46393_48493 = state_46387__$1;
(statearr_46393_48493[(2)] = null);

(statearr_46393_48493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (4))){
var inst_46369 = (state_46387[(7)]);
var inst_46369__$1 = (state_46387[(2)]);
var inst_46370 = (inst_46369__$1 == null);
var state_46387__$1 = (function (){var statearr_46396 = state_46387;
(statearr_46396[(7)] = inst_46369__$1);

return statearr_46396;
})();
if(cljs.core.truth_(inst_46370)){
var statearr_46397_48512 = state_46387__$1;
(statearr_46397_48512[(1)] = (5));

} else {
var statearr_46398_48513 = state_46387__$1;
(statearr_46398_48513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (6))){
var inst_46369 = (state_46387[(7)]);
var inst_46374 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46369) : p.call(null,inst_46369));
var state_46387__$1 = state_46387;
if(cljs.core.truth_(inst_46374)){
var statearr_46400_48518 = state_46387__$1;
(statearr_46400_48518[(1)] = (8));

} else {
var statearr_46401_48520 = state_46387__$1;
(statearr_46401_48520[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (3))){
var inst_46385 = (state_46387[(2)]);
var state_46387__$1 = state_46387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46387__$1,inst_46385);
} else {
if((state_val_46388 === (2))){
var state_46387__$1 = state_46387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46387__$1,(4),ch);
} else {
if((state_val_46388 === (11))){
var inst_46377 = (state_46387[(2)]);
var state_46387__$1 = state_46387;
var statearr_46405_48526 = state_46387__$1;
(statearr_46405_48526[(2)] = inst_46377);

(statearr_46405_48526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (9))){
var state_46387__$1 = state_46387;
var statearr_46406_48531 = state_46387__$1;
(statearr_46406_48531[(2)] = null);

(statearr_46406_48531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (5))){
var inst_46372 = cljs.core.async.close_BANG_(out);
var state_46387__$1 = state_46387;
var statearr_46407_48532 = state_46387__$1;
(statearr_46407_48532[(2)] = inst_46372);

(statearr_46407_48532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (10))){
var inst_46380 = (state_46387[(2)]);
var state_46387__$1 = (function (){var statearr_46408 = state_46387;
(statearr_46408[(8)] = inst_46380);

return statearr_46408;
})();
var statearr_46409_48533 = state_46387__$1;
(statearr_46409_48533[(2)] = null);

(statearr_46409_48533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46388 === (8))){
var inst_46369 = (state_46387[(7)]);
var state_46387__$1 = state_46387;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46387__$1,(11),out,inst_46369);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46410 = [null,null,null,null,null,null,null,null,null];
(statearr_46410[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46410[(1)] = (1));

return statearr_46410;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46387){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46387);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46413){var ex__43873__auto__ = e46413;
var statearr_46414_48546 = state_46387;
(statearr_46414_48546[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46387[(4)]))){
var statearr_46415_48547 = state_46387;
(statearr_46415_48547[(1)] = cljs.core.first((state_46387[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48549 = state_46387;
state_46387 = G__48549;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46387){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46416 = f__44005__auto__();
(statearr_46416[(6)] = c__44004__auto___48477);

return statearr_46416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__46418 = arguments.length;
switch (G__46418) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44004__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46484){
var state_val_46485 = (state_46484[(1)]);
if((state_val_46485 === (7))){
var inst_46480 = (state_46484[(2)]);
var state_46484__$1 = state_46484;
var statearr_46504_48552 = state_46484__$1;
(statearr_46504_48552[(2)] = inst_46480);

(statearr_46504_48552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (20))){
var inst_46450 = (state_46484[(7)]);
var inst_46461 = (state_46484[(2)]);
var inst_46462 = cljs.core.next(inst_46450);
var inst_46436 = inst_46462;
var inst_46437 = null;
var inst_46438 = (0);
var inst_46439 = (0);
var state_46484__$1 = (function (){var statearr_46510 = state_46484;
(statearr_46510[(8)] = inst_46437);

(statearr_46510[(9)] = inst_46461);

(statearr_46510[(10)] = inst_46438);

(statearr_46510[(11)] = inst_46436);

(statearr_46510[(12)] = inst_46439);

return statearr_46510;
})();
var statearr_46515_48553 = state_46484__$1;
(statearr_46515_48553[(2)] = null);

(statearr_46515_48553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (1))){
var state_46484__$1 = state_46484;
var statearr_46517_48554 = state_46484__$1;
(statearr_46517_48554[(2)] = null);

(statearr_46517_48554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (4))){
var inst_46425 = (state_46484[(13)]);
var inst_46425__$1 = (state_46484[(2)]);
var inst_46426 = (inst_46425__$1 == null);
var state_46484__$1 = (function (){var statearr_46518 = state_46484;
(statearr_46518[(13)] = inst_46425__$1);

return statearr_46518;
})();
if(cljs.core.truth_(inst_46426)){
var statearr_46519_48569 = state_46484__$1;
(statearr_46519_48569[(1)] = (5));

} else {
var statearr_46521_48570 = state_46484__$1;
(statearr_46521_48570[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (15))){
var state_46484__$1 = state_46484;
var statearr_46525_48577 = state_46484__$1;
(statearr_46525_48577[(2)] = null);

(statearr_46525_48577[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (21))){
var state_46484__$1 = state_46484;
var statearr_46526_48578 = state_46484__$1;
(statearr_46526_48578[(2)] = null);

(statearr_46526_48578[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (13))){
var inst_46437 = (state_46484[(8)]);
var inst_46438 = (state_46484[(10)]);
var inst_46436 = (state_46484[(11)]);
var inst_46439 = (state_46484[(12)]);
var inst_46446 = (state_46484[(2)]);
var inst_46447 = (inst_46439 + (1));
var tmp46522 = inst_46437;
var tmp46523 = inst_46438;
var tmp46524 = inst_46436;
var inst_46436__$1 = tmp46524;
var inst_46437__$1 = tmp46522;
var inst_46438__$1 = tmp46523;
var inst_46439__$1 = inst_46447;
var state_46484__$1 = (function (){var statearr_46530 = state_46484;
(statearr_46530[(8)] = inst_46437__$1);

(statearr_46530[(10)] = inst_46438__$1);

(statearr_46530[(11)] = inst_46436__$1);

(statearr_46530[(12)] = inst_46439__$1);

(statearr_46530[(14)] = inst_46446);

return statearr_46530;
})();
var statearr_46531_48592 = state_46484__$1;
(statearr_46531_48592[(2)] = null);

(statearr_46531_48592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (22))){
var state_46484__$1 = state_46484;
var statearr_46532_48599 = state_46484__$1;
(statearr_46532_48599[(2)] = null);

(statearr_46532_48599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (6))){
var inst_46425 = (state_46484[(13)]);
var inst_46434 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46425) : f.call(null,inst_46425));
var inst_46435 = cljs.core.seq(inst_46434);
var inst_46436 = inst_46435;
var inst_46437 = null;
var inst_46438 = (0);
var inst_46439 = (0);
var state_46484__$1 = (function (){var statearr_46535 = state_46484;
(statearr_46535[(8)] = inst_46437);

(statearr_46535[(10)] = inst_46438);

(statearr_46535[(11)] = inst_46436);

(statearr_46535[(12)] = inst_46439);

return statearr_46535;
})();
var statearr_46536_48606 = state_46484__$1;
(statearr_46536_48606[(2)] = null);

(statearr_46536_48606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (17))){
var inst_46450 = (state_46484[(7)]);
var inst_46454 = cljs.core.chunk_first(inst_46450);
var inst_46455 = cljs.core.chunk_rest(inst_46450);
var inst_46456 = cljs.core.count(inst_46454);
var inst_46436 = inst_46455;
var inst_46437 = inst_46454;
var inst_46438 = inst_46456;
var inst_46439 = (0);
var state_46484__$1 = (function (){var statearr_46539 = state_46484;
(statearr_46539[(8)] = inst_46437);

(statearr_46539[(10)] = inst_46438);

(statearr_46539[(11)] = inst_46436);

(statearr_46539[(12)] = inst_46439);

return statearr_46539;
})();
var statearr_46542_48610 = state_46484__$1;
(statearr_46542_48610[(2)] = null);

(statearr_46542_48610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (3))){
var inst_46482 = (state_46484[(2)]);
var state_46484__$1 = state_46484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46484__$1,inst_46482);
} else {
if((state_val_46485 === (12))){
var inst_46470 = (state_46484[(2)]);
var state_46484__$1 = state_46484;
var statearr_46546_48617 = state_46484__$1;
(statearr_46546_48617[(2)] = inst_46470);

(statearr_46546_48617[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (2))){
var state_46484__$1 = state_46484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46484__$1,(4),in$);
} else {
if((state_val_46485 === (23))){
var inst_46478 = (state_46484[(2)]);
var state_46484__$1 = state_46484;
var statearr_46547_48626 = state_46484__$1;
(statearr_46547_48626[(2)] = inst_46478);

(statearr_46547_48626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (19))){
var inst_46465 = (state_46484[(2)]);
var state_46484__$1 = state_46484;
var statearr_46548_48632 = state_46484__$1;
(statearr_46548_48632[(2)] = inst_46465);

(statearr_46548_48632[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (11))){
var inst_46436 = (state_46484[(11)]);
var inst_46450 = (state_46484[(7)]);
var inst_46450__$1 = cljs.core.seq(inst_46436);
var state_46484__$1 = (function (){var statearr_46549 = state_46484;
(statearr_46549[(7)] = inst_46450__$1);

return statearr_46549;
})();
if(inst_46450__$1){
var statearr_46550_48639 = state_46484__$1;
(statearr_46550_48639[(1)] = (14));

} else {
var statearr_46551_48640 = state_46484__$1;
(statearr_46551_48640[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (9))){
var inst_46472 = (state_46484[(2)]);
var inst_46473 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_46484__$1 = (function (){var statearr_46553 = state_46484;
(statearr_46553[(15)] = inst_46472);

return statearr_46553;
})();
if(cljs.core.truth_(inst_46473)){
var statearr_46555_48642 = state_46484__$1;
(statearr_46555_48642[(1)] = (21));

} else {
var statearr_46556_48643 = state_46484__$1;
(statearr_46556_48643[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (5))){
var inst_46428 = cljs.core.async.close_BANG_(out);
var state_46484__$1 = state_46484;
var statearr_46557_48655 = state_46484__$1;
(statearr_46557_48655[(2)] = inst_46428);

(statearr_46557_48655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (14))){
var inst_46450 = (state_46484[(7)]);
var inst_46452 = cljs.core.chunked_seq_QMARK_(inst_46450);
var state_46484__$1 = state_46484;
if(inst_46452){
var statearr_46558_48660 = state_46484__$1;
(statearr_46558_48660[(1)] = (17));

} else {
var statearr_46559_48663 = state_46484__$1;
(statearr_46559_48663[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (16))){
var inst_46468 = (state_46484[(2)]);
var state_46484__$1 = state_46484;
var statearr_46562_48669 = state_46484__$1;
(statearr_46562_48669[(2)] = inst_46468);

(statearr_46562_48669[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46485 === (10))){
var inst_46437 = (state_46484[(8)]);
var inst_46439 = (state_46484[(12)]);
var inst_46444 = cljs.core._nth(inst_46437,inst_46439);
var state_46484__$1 = state_46484;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46484__$1,(13),out,inst_46444);
} else {
if((state_val_46485 === (18))){
var inst_46450 = (state_46484[(7)]);
var inst_46459 = cljs.core.first(inst_46450);
var state_46484__$1 = state_46484;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46484__$1,(20),out,inst_46459);
} else {
if((state_val_46485 === (8))){
var inst_46438 = (state_46484[(10)]);
var inst_46439 = (state_46484[(12)]);
var inst_46441 = (inst_46439 < inst_46438);
var inst_46442 = inst_46441;
var state_46484__$1 = state_46484;
if(cljs.core.truth_(inst_46442)){
var statearr_46564_48680 = state_46484__$1;
(statearr_46564_48680[(1)] = (10));

} else {
var statearr_46565_48681 = state_46484__$1;
(statearr_46565_48681[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43870__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43870__auto____0 = (function (){
var statearr_46567 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46567[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43870__auto__);

(statearr_46567[(1)] = (1));

return statearr_46567;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43870__auto____1 = (function (state_46484){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46484);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46568){var ex__43873__auto__ = e46568;
var statearr_46569_48683 = state_46484;
(statearr_46569_48683[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46484[(4)]))){
var statearr_46570_48684 = state_46484;
(statearr_46570_48684[(1)] = cljs.core.first((state_46484[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48685 = state_46484;
state_46484 = G__48685;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43870__auto__ = function(state_46484){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43870__auto____1.call(this,state_46484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43870__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43870__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46571 = f__44005__auto__();
(statearr_46571[(6)] = c__44004__auto__);

return statearr_46571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));

return c__44004__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46576 = arguments.length;
switch (G__46576) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46582 = arguments.length;
switch (G__46582) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__46587 = arguments.length;
switch (G__46587) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44004__auto___48705 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46613){
var state_val_46614 = (state_46613[(1)]);
if((state_val_46614 === (7))){
var inst_46608 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
var statearr_46615_48706 = state_46613__$1;
(statearr_46615_48706[(2)] = inst_46608);

(statearr_46615_48706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (1))){
var inst_46590 = null;
var state_46613__$1 = (function (){var statearr_46616 = state_46613;
(statearr_46616[(7)] = inst_46590);

return statearr_46616;
})();
var statearr_46617_48707 = state_46613__$1;
(statearr_46617_48707[(2)] = null);

(statearr_46617_48707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (4))){
var inst_46593 = (state_46613[(8)]);
var inst_46593__$1 = (state_46613[(2)]);
var inst_46594 = (inst_46593__$1 == null);
var inst_46595 = cljs.core.not(inst_46594);
var state_46613__$1 = (function (){var statearr_46621 = state_46613;
(statearr_46621[(8)] = inst_46593__$1);

return statearr_46621;
})();
if(inst_46595){
var statearr_46622_48712 = state_46613__$1;
(statearr_46622_48712[(1)] = (5));

} else {
var statearr_46623_48713 = state_46613__$1;
(statearr_46623_48713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (6))){
var state_46613__$1 = state_46613;
var statearr_46626_48714 = state_46613__$1;
(statearr_46626_48714[(2)] = null);

(statearr_46626_48714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (3))){
var inst_46610 = (state_46613[(2)]);
var inst_46611 = cljs.core.async.close_BANG_(out);
var state_46613__$1 = (function (){var statearr_46627 = state_46613;
(statearr_46627[(9)] = inst_46610);

return statearr_46627;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46613__$1,inst_46611);
} else {
if((state_val_46614 === (2))){
var state_46613__$1 = state_46613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46613__$1,(4),ch);
} else {
if((state_val_46614 === (11))){
var inst_46593 = (state_46613[(8)]);
var inst_46602 = (state_46613[(2)]);
var inst_46590 = inst_46593;
var state_46613__$1 = (function (){var statearr_46628 = state_46613;
(statearr_46628[(7)] = inst_46590);

(statearr_46628[(10)] = inst_46602);

return statearr_46628;
})();
var statearr_46630_48715 = state_46613__$1;
(statearr_46630_48715[(2)] = null);

(statearr_46630_48715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (9))){
var inst_46593 = (state_46613[(8)]);
var state_46613__$1 = state_46613;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46613__$1,(11),out,inst_46593);
} else {
if((state_val_46614 === (5))){
var inst_46593 = (state_46613[(8)]);
var inst_46590 = (state_46613[(7)]);
var inst_46597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46593,inst_46590);
var state_46613__$1 = state_46613;
if(inst_46597){
var statearr_46640_48717 = state_46613__$1;
(statearr_46640_48717[(1)] = (8));

} else {
var statearr_46641_48718 = state_46613__$1;
(statearr_46641_48718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (10))){
var inst_46605 = (state_46613[(2)]);
var state_46613__$1 = state_46613;
var statearr_46646_48720 = state_46613__$1;
(statearr_46646_48720[(2)] = inst_46605);

(statearr_46646_48720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46614 === (8))){
var inst_46590 = (state_46613[(7)]);
var tmp46639 = inst_46590;
var inst_46590__$1 = tmp46639;
var state_46613__$1 = (function (){var statearr_46647 = state_46613;
(statearr_46647[(7)] = inst_46590__$1);

return statearr_46647;
})();
var statearr_46648_48730 = state_46613__$1;
(statearr_46648_48730[(2)] = null);

(statearr_46648_48730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46649 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46649[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46649[(1)] = (1));

return statearr_46649;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46613){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46613);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46654){var ex__43873__auto__ = e46654;
var statearr_46659_48734 = state_46613;
(statearr_46659_48734[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46613[(4)]))){
var statearr_46660_48737 = state_46613;
(statearr_46660_48737[(1)] = cljs.core.first((state_46613[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48738 = state_46613;
state_46613 = G__48738;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46613){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46662 = f__44005__auto__();
(statearr_46662[(6)] = c__44004__auto___48705);

return statearr_46662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__46664 = arguments.length;
switch (G__46664) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44004__auto___48742 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46703){
var state_val_46704 = (state_46703[(1)]);
if((state_val_46704 === (7))){
var inst_46699 = (state_46703[(2)]);
var state_46703__$1 = state_46703;
var statearr_46705_48743 = state_46703__$1;
(statearr_46705_48743[(2)] = inst_46699);

(statearr_46705_48743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (1))){
var inst_46666 = (new Array(n));
var inst_46667 = inst_46666;
var inst_46668 = (0);
var state_46703__$1 = (function (){var statearr_46707 = state_46703;
(statearr_46707[(7)] = inst_46667);

(statearr_46707[(8)] = inst_46668);

return statearr_46707;
})();
var statearr_46708_48760 = state_46703__$1;
(statearr_46708_48760[(2)] = null);

(statearr_46708_48760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (4))){
var inst_46671 = (state_46703[(9)]);
var inst_46671__$1 = (state_46703[(2)]);
var inst_46672 = (inst_46671__$1 == null);
var inst_46673 = cljs.core.not(inst_46672);
var state_46703__$1 = (function (){var statearr_46709 = state_46703;
(statearr_46709[(9)] = inst_46671__$1);

return statearr_46709;
})();
if(inst_46673){
var statearr_46710_48761 = state_46703__$1;
(statearr_46710_48761[(1)] = (5));

} else {
var statearr_46711_48762 = state_46703__$1;
(statearr_46711_48762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (15))){
var inst_46693 = (state_46703[(2)]);
var state_46703__$1 = state_46703;
var statearr_46714_48763 = state_46703__$1;
(statearr_46714_48763[(2)] = inst_46693);

(statearr_46714_48763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (13))){
var state_46703__$1 = state_46703;
var statearr_46717_48764 = state_46703__$1;
(statearr_46717_48764[(2)] = null);

(statearr_46717_48764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (6))){
var inst_46668 = (state_46703[(8)]);
var inst_46689 = (inst_46668 > (0));
var state_46703__$1 = state_46703;
if(cljs.core.truth_(inst_46689)){
var statearr_46718_48765 = state_46703__$1;
(statearr_46718_48765[(1)] = (12));

} else {
var statearr_46719_48766 = state_46703__$1;
(statearr_46719_48766[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (3))){
var inst_46701 = (state_46703[(2)]);
var state_46703__$1 = state_46703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46703__$1,inst_46701);
} else {
if((state_val_46704 === (12))){
var inst_46667 = (state_46703[(7)]);
var inst_46691 = cljs.core.vec(inst_46667);
var state_46703__$1 = state_46703;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46703__$1,(15),out,inst_46691);
} else {
if((state_val_46704 === (2))){
var state_46703__$1 = state_46703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46703__$1,(4),ch);
} else {
if((state_val_46704 === (11))){
var inst_46683 = (state_46703[(2)]);
var inst_46684 = (new Array(n));
var inst_46667 = inst_46684;
var inst_46668 = (0);
var state_46703__$1 = (function (){var statearr_46721 = state_46703;
(statearr_46721[(7)] = inst_46667);

(statearr_46721[(8)] = inst_46668);

(statearr_46721[(10)] = inst_46683);

return statearr_46721;
})();
var statearr_46722_48771 = state_46703__$1;
(statearr_46722_48771[(2)] = null);

(statearr_46722_48771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (9))){
var inst_46667 = (state_46703[(7)]);
var inst_46681 = cljs.core.vec(inst_46667);
var state_46703__$1 = state_46703;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46703__$1,(11),out,inst_46681);
} else {
if((state_val_46704 === (5))){
var inst_46667 = (state_46703[(7)]);
var inst_46676 = (state_46703[(11)]);
var inst_46668 = (state_46703[(8)]);
var inst_46671 = (state_46703[(9)]);
var inst_46675 = (inst_46667[inst_46668] = inst_46671);
var inst_46676__$1 = (inst_46668 + (1));
var inst_46677 = (inst_46676__$1 < n);
var state_46703__$1 = (function (){var statearr_46726 = state_46703;
(statearr_46726[(11)] = inst_46676__$1);

(statearr_46726[(12)] = inst_46675);

return statearr_46726;
})();
if(cljs.core.truth_(inst_46677)){
var statearr_46728_48776 = state_46703__$1;
(statearr_46728_48776[(1)] = (8));

} else {
var statearr_46730_48777 = state_46703__$1;
(statearr_46730_48777[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (14))){
var inst_46696 = (state_46703[(2)]);
var inst_46697 = cljs.core.async.close_BANG_(out);
var state_46703__$1 = (function (){var statearr_46732 = state_46703;
(statearr_46732[(13)] = inst_46696);

return statearr_46732;
})();
var statearr_46733_48799 = state_46703__$1;
(statearr_46733_48799[(2)] = inst_46697);

(statearr_46733_48799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (10))){
var inst_46687 = (state_46703[(2)]);
var state_46703__$1 = state_46703;
var statearr_46735_48801 = state_46703__$1;
(statearr_46735_48801[(2)] = inst_46687);

(statearr_46735_48801[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46704 === (8))){
var inst_46667 = (state_46703[(7)]);
var inst_46676 = (state_46703[(11)]);
var tmp46731 = inst_46667;
var inst_46667__$1 = tmp46731;
var inst_46668 = inst_46676;
var state_46703__$1 = (function (){var statearr_46736 = state_46703;
(statearr_46736[(7)] = inst_46667__$1);

(statearr_46736[(8)] = inst_46668);

return statearr_46736;
})();
var statearr_46737_48813 = state_46703__$1;
(statearr_46737_48813[(2)] = null);

(statearr_46737_48813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46738 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46738[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46738[(1)] = (1));

return statearr_46738;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46703){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46703);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46739){var ex__43873__auto__ = e46739;
var statearr_46740_48821 = state_46703;
(statearr_46740_48821[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46703[(4)]))){
var statearr_46741_48822 = state_46703;
(statearr_46741_48822[(1)] = cljs.core.first((state_46703[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48827 = state_46703;
state_46703 = G__48827;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46703){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46743 = f__44005__auto__();
(statearr_46743[(6)] = c__44004__auto___48742);

return statearr_46743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46747 = arguments.length;
switch (G__46747) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44004__auto___48843 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_46793){
var state_val_46794 = (state_46793[(1)]);
if((state_val_46794 === (7))){
var inst_46789 = (state_46793[(2)]);
var state_46793__$1 = state_46793;
var statearr_46796_48849 = state_46793__$1;
(statearr_46796_48849[(2)] = inst_46789);

(statearr_46796_48849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (1))){
var inst_46751 = [];
var inst_46752 = inst_46751;
var inst_46753 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_46793__$1 = (function (){var statearr_46797 = state_46793;
(statearr_46797[(7)] = inst_46753);

(statearr_46797[(8)] = inst_46752);

return statearr_46797;
})();
var statearr_46798_48857 = state_46793__$1;
(statearr_46798_48857[(2)] = null);

(statearr_46798_48857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (4))){
var inst_46756 = (state_46793[(9)]);
var inst_46756__$1 = (state_46793[(2)]);
var inst_46758 = (inst_46756__$1 == null);
var inst_46759 = cljs.core.not(inst_46758);
var state_46793__$1 = (function (){var statearr_46800 = state_46793;
(statearr_46800[(9)] = inst_46756__$1);

return statearr_46800;
})();
if(inst_46759){
var statearr_46802_48944 = state_46793__$1;
(statearr_46802_48944[(1)] = (5));

} else {
var statearr_46803_48945 = state_46793__$1;
(statearr_46803_48945[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (15))){
var inst_46783 = (state_46793[(2)]);
var state_46793__$1 = state_46793;
var statearr_46804_48946 = state_46793__$1;
(statearr_46804_48946[(2)] = inst_46783);

(statearr_46804_48946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (13))){
var state_46793__$1 = state_46793;
var statearr_46805_48949 = state_46793__$1;
(statearr_46805_48949[(2)] = null);

(statearr_46805_48949[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (6))){
var inst_46752 = (state_46793[(8)]);
var inst_46778 = inst_46752.length;
var inst_46779 = (inst_46778 > (0));
var state_46793__$1 = state_46793;
if(cljs.core.truth_(inst_46779)){
var statearr_46807_48953 = state_46793__$1;
(statearr_46807_48953[(1)] = (12));

} else {
var statearr_46808_48957 = state_46793__$1;
(statearr_46808_48957[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (3))){
var inst_46791 = (state_46793[(2)]);
var state_46793__$1 = state_46793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46793__$1,inst_46791);
} else {
if((state_val_46794 === (12))){
var inst_46752 = (state_46793[(8)]);
var inst_46781 = cljs.core.vec(inst_46752);
var state_46793__$1 = state_46793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46793__$1,(15),out,inst_46781);
} else {
if((state_val_46794 === (2))){
var state_46793__$1 = state_46793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46793__$1,(4),ch);
} else {
if((state_val_46794 === (11))){
var inst_46761 = (state_46793[(10)]);
var inst_46756 = (state_46793[(9)]);
var inst_46771 = (state_46793[(2)]);
var inst_46772 = [];
var inst_46773 = inst_46772.push(inst_46756);
var inst_46752 = inst_46772;
var inst_46753 = inst_46761;
var state_46793__$1 = (function (){var statearr_46809 = state_46793;
(statearr_46809[(11)] = inst_46773);

(statearr_46809[(7)] = inst_46753);

(statearr_46809[(8)] = inst_46752);

(statearr_46809[(12)] = inst_46771);

return statearr_46809;
})();
var statearr_46810_48959 = state_46793__$1;
(statearr_46810_48959[(2)] = null);

(statearr_46810_48959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (9))){
var inst_46752 = (state_46793[(8)]);
var inst_46769 = cljs.core.vec(inst_46752);
var state_46793__$1 = state_46793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46793__$1,(11),out,inst_46769);
} else {
if((state_val_46794 === (5))){
var inst_46761 = (state_46793[(10)]);
var inst_46753 = (state_46793[(7)]);
var inst_46756 = (state_46793[(9)]);
var inst_46761__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46756) : f.call(null,inst_46756));
var inst_46762 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46761__$1,inst_46753);
var inst_46763 = cljs.core.keyword_identical_QMARK_(inst_46753,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_46764 = ((inst_46762) || (inst_46763));
var state_46793__$1 = (function (){var statearr_46812 = state_46793;
(statearr_46812[(10)] = inst_46761__$1);

return statearr_46812;
})();
if(cljs.core.truth_(inst_46764)){
var statearr_46813_48968 = state_46793__$1;
(statearr_46813_48968[(1)] = (8));

} else {
var statearr_46814_48972 = state_46793__$1;
(statearr_46814_48972[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (14))){
var inst_46786 = (state_46793[(2)]);
var inst_46787 = cljs.core.async.close_BANG_(out);
var state_46793__$1 = (function (){var statearr_46816 = state_46793;
(statearr_46816[(13)] = inst_46786);

return statearr_46816;
})();
var statearr_46817_48976 = state_46793__$1;
(statearr_46817_48976[(2)] = inst_46787);

(statearr_46817_48976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (10))){
var inst_46776 = (state_46793[(2)]);
var state_46793__$1 = state_46793;
var statearr_46818_48980 = state_46793__$1;
(statearr_46818_48980[(2)] = inst_46776);

(statearr_46818_48980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46794 === (8))){
var inst_46761 = (state_46793[(10)]);
var inst_46752 = (state_46793[(8)]);
var inst_46756 = (state_46793[(9)]);
var inst_46766 = inst_46752.push(inst_46756);
var tmp46815 = inst_46752;
var inst_46752__$1 = tmp46815;
var inst_46753 = inst_46761;
var state_46793__$1 = (function (){var statearr_46819 = state_46793;
(statearr_46819[(14)] = inst_46766);

(statearr_46819[(7)] = inst_46753);

(statearr_46819[(8)] = inst_46752__$1);

return statearr_46819;
})();
var statearr_46821_48983 = state_46793__$1;
(statearr_46821_48983[(2)] = null);

(statearr_46821_48983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43870__auto__ = null;
var cljs$core$async$state_machine__43870__auto____0 = (function (){
var statearr_46822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46822[(0)] = cljs$core$async$state_machine__43870__auto__);

(statearr_46822[(1)] = (1));

return statearr_46822;
});
var cljs$core$async$state_machine__43870__auto____1 = (function (state_46793){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_46793);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e46823){var ex__43873__auto__ = e46823;
var statearr_46824_48998 = state_46793;
(statearr_46824_48998[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_46793[(4)]))){
var statearr_46826_48999 = state_46793;
(statearr_46826_48999[(1)] = cljs.core.first((state_46793[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49019 = state_46793;
state_46793 = G__49019;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
cljs$core$async$state_machine__43870__auto__ = function(state_46793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43870__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43870__auto____1.call(this,state_46793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43870__auto____0;
cljs$core$async$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43870__auto____1;
return cljs$core$async$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_46827 = f__44005__auto__();
(statearr_46827[(6)] = c__44004__auto___48843);

return statearr_46827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
