goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_48263 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_48263(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_48265 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_48265(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__46893 = coll;
var G__46894 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__46893,G__46894) : shadow.dom.lazy_native_coll_seq.call(null,G__46893,G__46894));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46920 = arguments.length;
switch (G__46920) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46929 = arguments.length;
switch (G__46929) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46941 = arguments.length;
switch (G__46941) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46949 = arguments.length;
switch (G__46949) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46956 = arguments.length;
switch (G__46956) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__47004 = arguments.length;
switch (G__47004) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e47018){if((e47018 instanceof Object)){
var e = e47018;
return console.log("didnt support attachEvent",el,e);
} else {
throw e47018;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__47026 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__47027 = null;
var count__47028 = (0);
var i__47029 = (0);
while(true){
if((i__47029 < count__47028)){
var el = chunk__47027.cljs$core$IIndexed$_nth$arity$2(null,i__47029);
var handler_48322__$1 = ((function (seq__47026,chunk__47027,count__47028,i__47029,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47026,chunk__47027,count__47028,i__47029,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48322__$1);


var G__48328 = seq__47026;
var G__48329 = chunk__47027;
var G__48330 = count__47028;
var G__48331 = (i__47029 + (1));
seq__47026 = G__48328;
chunk__47027 = G__48329;
count__47028 = G__48330;
i__47029 = G__48331;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__47026);
if(temp__5720__auto__){
var seq__47026__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47026__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__47026__$1);
var G__48336 = cljs.core.chunk_rest(seq__47026__$1);
var G__48337 = c__4556__auto__;
var G__48338 = cljs.core.count(c__4556__auto__);
var G__48339 = (0);
seq__47026 = G__48336;
chunk__47027 = G__48337;
count__47028 = G__48338;
i__47029 = G__48339;
continue;
} else {
var el = cljs.core.first(seq__47026__$1);
var handler_48345__$1 = ((function (seq__47026,chunk__47027,count__47028,i__47029,el,seq__47026__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47026,chunk__47027,count__47028,i__47029,el,seq__47026__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48345__$1);


var G__48346 = cljs.core.next(seq__47026__$1);
var G__48347 = null;
var G__48348 = (0);
var G__48349 = (0);
seq__47026 = G__48346;
chunk__47027 = G__48347;
count__47028 = G__48348;
i__47029 = G__48349;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__47046 = arguments.length;
switch (G__47046) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__47063 = cljs.core.seq(events);
var chunk__47064 = null;
var count__47065 = (0);
var i__47066 = (0);
while(true){
if((i__47066 < count__47065)){
var vec__47084 = chunk__47064.cljs$core$IIndexed$_nth$arity$2(null,i__47066);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47084,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47084,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48364 = seq__47063;
var G__48365 = chunk__47064;
var G__48366 = count__47065;
var G__48367 = (i__47066 + (1));
seq__47063 = G__48364;
chunk__47064 = G__48365;
count__47065 = G__48366;
i__47066 = G__48367;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__47063);
if(temp__5720__auto__){
var seq__47063__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47063__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__47063__$1);
var G__48368 = cljs.core.chunk_rest(seq__47063__$1);
var G__48369 = c__4556__auto__;
var G__48370 = cljs.core.count(c__4556__auto__);
var G__48371 = (0);
seq__47063 = G__48368;
chunk__47064 = G__48369;
count__47065 = G__48370;
i__47066 = G__48371;
continue;
} else {
var vec__47092 = cljs.core.first(seq__47063__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47092,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47092,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48374 = cljs.core.next(seq__47063__$1);
var G__48375 = null;
var G__48376 = (0);
var G__48377 = (0);
seq__47063 = G__48374;
chunk__47064 = G__48375;
count__47065 = G__48376;
i__47066 = G__48377;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__47101 = cljs.core.seq(styles);
var chunk__47102 = null;
var count__47103 = (0);
var i__47104 = (0);
while(true){
if((i__47104 < count__47103)){
var vec__47121 = chunk__47102.cljs$core$IIndexed$_nth$arity$2(null,i__47104);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47121,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47121,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48380 = seq__47101;
var G__48381 = chunk__47102;
var G__48382 = count__47103;
var G__48383 = (i__47104 + (1));
seq__47101 = G__48380;
chunk__47102 = G__48381;
count__47103 = G__48382;
i__47104 = G__48383;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__47101);
if(temp__5720__auto__){
var seq__47101__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47101__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__47101__$1);
var G__48385 = cljs.core.chunk_rest(seq__47101__$1);
var G__48386 = c__4556__auto__;
var G__48387 = cljs.core.count(c__4556__auto__);
var G__48388 = (0);
seq__47101 = G__48385;
chunk__47102 = G__48386;
count__47103 = G__48387;
i__47104 = G__48388;
continue;
} else {
var vec__47125 = cljs.core.first(seq__47101__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47125,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47125,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48390 = cljs.core.next(seq__47101__$1);
var G__48391 = null;
var G__48392 = (0);
var G__48393 = (0);
seq__47101 = G__48390;
chunk__47102 = G__48391;
count__47103 = G__48392;
i__47104 = G__48393;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__47129_48394 = key;
var G__47129_48395__$1 = (((G__47129_48394 instanceof cljs.core.Keyword))?G__47129_48394.fqn:null);
switch (G__47129_48395__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_48399 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_48399,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_48399,"aria-");
}
})())){
el.setAttribute(ks_48399,value);
} else {
(el[ks_48399] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__47176){
var map__47177 = p__47176;
var map__47177__$1 = (((((!((map__47177 == null))))?(((((map__47177.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47177.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47177):map__47177);
var props = map__47177__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47177__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__47182 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47182,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47182,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47182,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__47192 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__47192,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__47192;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__47197 = arguments.length;
switch (G__47197) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__47212){
var vec__47213 = p__47212;
var seq__47214 = cljs.core.seq(vec__47213);
var first__47215 = cljs.core.first(seq__47214);
var seq__47214__$1 = cljs.core.next(seq__47214);
var nn = first__47215;
var first__47215__$1 = cljs.core.first(seq__47214__$1);
var seq__47214__$2 = cljs.core.next(seq__47214__$1);
var np = first__47215__$1;
var nc = seq__47214__$2;
var node = vec__47213;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47217 = nn;
var G__47218 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47217,G__47218) : create_fn.call(null,G__47217,G__47218));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47224 = nn;
var G__47225 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47224,G__47225) : create_fn.call(null,G__47224,G__47225));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__47230 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47230,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47230,(1),null);
var seq__47233_48418 = cljs.core.seq(node_children);
var chunk__47234_48419 = null;
var count__47235_48420 = (0);
var i__47236_48421 = (0);
while(true){
if((i__47236_48421 < count__47235_48420)){
var child_struct_48423 = chunk__47234_48419.cljs$core$IIndexed$_nth$arity$2(null,i__47236_48421);
var children_48424 = shadow.dom.dom_node(child_struct_48423);
if(cljs.core.seq_QMARK_(children_48424)){
var seq__47303_48426 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_48424));
var chunk__47305_48427 = null;
var count__47306_48428 = (0);
var i__47307_48429 = (0);
while(true){
if((i__47307_48429 < count__47306_48428)){
var child_48431 = chunk__47305_48427.cljs$core$IIndexed$_nth$arity$2(null,i__47307_48429);
if(cljs.core.truth_(child_48431)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48431);


var G__48432 = seq__47303_48426;
var G__48433 = chunk__47305_48427;
var G__48434 = count__47306_48428;
var G__48435 = (i__47307_48429 + (1));
seq__47303_48426 = G__48432;
chunk__47305_48427 = G__48433;
count__47306_48428 = G__48434;
i__47307_48429 = G__48435;
continue;
} else {
var G__48436 = seq__47303_48426;
var G__48437 = chunk__47305_48427;
var G__48438 = count__47306_48428;
var G__48439 = (i__47307_48429 + (1));
seq__47303_48426 = G__48436;
chunk__47305_48427 = G__48437;
count__47306_48428 = G__48438;
i__47307_48429 = G__48439;
continue;
}
} else {
var temp__5720__auto___48441 = cljs.core.seq(seq__47303_48426);
if(temp__5720__auto___48441){
var seq__47303_48442__$1 = temp__5720__auto___48441;
if(cljs.core.chunked_seq_QMARK_(seq__47303_48442__$1)){
var c__4556__auto___48443 = cljs.core.chunk_first(seq__47303_48442__$1);
var G__48444 = cljs.core.chunk_rest(seq__47303_48442__$1);
var G__48445 = c__4556__auto___48443;
var G__48446 = cljs.core.count(c__4556__auto___48443);
var G__48447 = (0);
seq__47303_48426 = G__48444;
chunk__47305_48427 = G__48445;
count__47306_48428 = G__48446;
i__47307_48429 = G__48447;
continue;
} else {
var child_48448 = cljs.core.first(seq__47303_48442__$1);
if(cljs.core.truth_(child_48448)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48448);


var G__48450 = cljs.core.next(seq__47303_48442__$1);
var G__48451 = null;
var G__48452 = (0);
var G__48453 = (0);
seq__47303_48426 = G__48450;
chunk__47305_48427 = G__48451;
count__47306_48428 = G__48452;
i__47307_48429 = G__48453;
continue;
} else {
var G__48454 = cljs.core.next(seq__47303_48442__$1);
var G__48455 = null;
var G__48456 = (0);
var G__48457 = (0);
seq__47303_48426 = G__48454;
chunk__47305_48427 = G__48455;
count__47306_48428 = G__48456;
i__47307_48429 = G__48457;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_48424);
}


var G__48458 = seq__47233_48418;
var G__48459 = chunk__47234_48419;
var G__48460 = count__47235_48420;
var G__48461 = (i__47236_48421 + (1));
seq__47233_48418 = G__48458;
chunk__47234_48419 = G__48459;
count__47235_48420 = G__48460;
i__47236_48421 = G__48461;
continue;
} else {
var temp__5720__auto___48462 = cljs.core.seq(seq__47233_48418);
if(temp__5720__auto___48462){
var seq__47233_48463__$1 = temp__5720__auto___48462;
if(cljs.core.chunked_seq_QMARK_(seq__47233_48463__$1)){
var c__4556__auto___48464 = cljs.core.chunk_first(seq__47233_48463__$1);
var G__48465 = cljs.core.chunk_rest(seq__47233_48463__$1);
var G__48466 = c__4556__auto___48464;
var G__48467 = cljs.core.count(c__4556__auto___48464);
var G__48468 = (0);
seq__47233_48418 = G__48465;
chunk__47234_48419 = G__48466;
count__47235_48420 = G__48467;
i__47236_48421 = G__48468;
continue;
} else {
var child_struct_48470 = cljs.core.first(seq__47233_48463__$1);
var children_48471 = shadow.dom.dom_node(child_struct_48470);
if(cljs.core.seq_QMARK_(children_48471)){
var seq__47332_48472 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_48471));
var chunk__47334_48473 = null;
var count__47335_48474 = (0);
var i__47336_48475 = (0);
while(true){
if((i__47336_48475 < count__47335_48474)){
var child_48476 = chunk__47334_48473.cljs$core$IIndexed$_nth$arity$2(null,i__47336_48475);
if(cljs.core.truth_(child_48476)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48476);


var G__48478 = seq__47332_48472;
var G__48479 = chunk__47334_48473;
var G__48480 = count__47335_48474;
var G__48481 = (i__47336_48475 + (1));
seq__47332_48472 = G__48478;
chunk__47334_48473 = G__48479;
count__47335_48474 = G__48480;
i__47336_48475 = G__48481;
continue;
} else {
var G__48482 = seq__47332_48472;
var G__48483 = chunk__47334_48473;
var G__48484 = count__47335_48474;
var G__48485 = (i__47336_48475 + (1));
seq__47332_48472 = G__48482;
chunk__47334_48473 = G__48483;
count__47335_48474 = G__48484;
i__47336_48475 = G__48485;
continue;
}
} else {
var temp__5720__auto___48490__$1 = cljs.core.seq(seq__47332_48472);
if(temp__5720__auto___48490__$1){
var seq__47332_48491__$1 = temp__5720__auto___48490__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47332_48491__$1)){
var c__4556__auto___48492 = cljs.core.chunk_first(seq__47332_48491__$1);
var G__48494 = cljs.core.chunk_rest(seq__47332_48491__$1);
var G__48495 = c__4556__auto___48492;
var G__48496 = cljs.core.count(c__4556__auto___48492);
var G__48497 = (0);
seq__47332_48472 = G__48494;
chunk__47334_48473 = G__48495;
count__47335_48474 = G__48496;
i__47336_48475 = G__48497;
continue;
} else {
var child_48501 = cljs.core.first(seq__47332_48491__$1);
if(cljs.core.truth_(child_48501)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48501);


var G__48504 = cljs.core.next(seq__47332_48491__$1);
var G__48505 = null;
var G__48506 = (0);
var G__48507 = (0);
seq__47332_48472 = G__48504;
chunk__47334_48473 = G__48505;
count__47335_48474 = G__48506;
i__47336_48475 = G__48507;
continue;
} else {
var G__48508 = cljs.core.next(seq__47332_48491__$1);
var G__48509 = null;
var G__48510 = (0);
var G__48511 = (0);
seq__47332_48472 = G__48508;
chunk__47334_48473 = G__48509;
count__47335_48474 = G__48510;
i__47336_48475 = G__48511;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_48471);
}


var G__48514 = cljs.core.next(seq__47233_48463__$1);
var G__48515 = null;
var G__48516 = (0);
var G__48517 = (0);
seq__47233_48418 = G__48514;
chunk__47234_48419 = G__48515;
count__47235_48420 = G__48516;
i__47236_48421 = G__48517;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__47366 = cljs.core.seq(node);
var chunk__47367 = null;
var count__47368 = (0);
var i__47369 = (0);
while(true){
if((i__47369 < count__47368)){
var n = chunk__47367.cljs$core$IIndexed$_nth$arity$2(null,i__47369);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__48534 = seq__47366;
var G__48535 = chunk__47367;
var G__48536 = count__47368;
var G__48537 = (i__47369 + (1));
seq__47366 = G__48534;
chunk__47367 = G__48535;
count__47368 = G__48536;
i__47369 = G__48537;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__47366);
if(temp__5720__auto__){
var seq__47366__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47366__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__47366__$1);
var G__48538 = cljs.core.chunk_rest(seq__47366__$1);
var G__48539 = c__4556__auto__;
var G__48540 = cljs.core.count(c__4556__auto__);
var G__48541 = (0);
seq__47366 = G__48538;
chunk__47367 = G__48539;
count__47368 = G__48540;
i__47369 = G__48541;
continue;
} else {
var n = cljs.core.first(seq__47366__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__48542 = cljs.core.next(seq__47366__$1);
var G__48543 = null;
var G__48544 = (0);
var G__48545 = (0);
seq__47366 = G__48542;
chunk__47367 = G__48543;
count__47368 = G__48544;
i__47369 = G__48545;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__47390 = arguments.length;
switch (G__47390) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__47400 = arguments.length;
switch (G__47400) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__47434 = arguments.length;
switch (G__47434) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48607 = arguments.length;
var i__4737__auto___48608 = (0);
while(true){
if((i__4737__auto___48608 < len__4736__auto___48607)){
args__4742__auto__.push((arguments[i__4737__auto___48608]));

var G__48609 = (i__4737__auto___48608 + (1));
i__4737__auto___48608 = G__48609;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__47477_48613 = cljs.core.seq(nodes);
var chunk__47479_48614 = null;
var count__47480_48615 = (0);
var i__47481_48616 = (0);
while(true){
if((i__47481_48616 < count__47480_48615)){
var node_48618 = chunk__47479_48614.cljs$core$IIndexed$_nth$arity$2(null,i__47481_48616);
fragment.appendChild(shadow.dom._to_dom(node_48618));


var G__48619 = seq__47477_48613;
var G__48620 = chunk__47479_48614;
var G__48621 = count__47480_48615;
var G__48622 = (i__47481_48616 + (1));
seq__47477_48613 = G__48619;
chunk__47479_48614 = G__48620;
count__47480_48615 = G__48621;
i__47481_48616 = G__48622;
continue;
} else {
var temp__5720__auto___48623 = cljs.core.seq(seq__47477_48613);
if(temp__5720__auto___48623){
var seq__47477_48624__$1 = temp__5720__auto___48623;
if(cljs.core.chunked_seq_QMARK_(seq__47477_48624__$1)){
var c__4556__auto___48627 = cljs.core.chunk_first(seq__47477_48624__$1);
var G__48628 = cljs.core.chunk_rest(seq__47477_48624__$1);
var G__48629 = c__4556__auto___48627;
var G__48630 = cljs.core.count(c__4556__auto___48627);
var G__48631 = (0);
seq__47477_48613 = G__48628;
chunk__47479_48614 = G__48629;
count__47480_48615 = G__48630;
i__47481_48616 = G__48631;
continue;
} else {
var node_48633 = cljs.core.first(seq__47477_48624__$1);
fragment.appendChild(shadow.dom._to_dom(node_48633));


var G__48634 = cljs.core.next(seq__47477_48624__$1);
var G__48635 = null;
var G__48636 = (0);
var G__48637 = (0);
seq__47477_48613 = G__48634;
chunk__47479_48614 = G__48635;
count__47480_48615 = G__48636;
i__47481_48616 = G__48637;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq47458){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47458));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__47526_48644 = cljs.core.seq(scripts);
var chunk__47527_48645 = null;
var count__47528_48646 = (0);
var i__47529_48647 = (0);
while(true){
if((i__47529_48647 < count__47528_48646)){
var vec__47553_48652 = chunk__47527_48645.cljs$core$IIndexed$_nth$arity$2(null,i__47529_48647);
var script_tag_48653 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47553_48652,(0),null);
var script_body_48654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47553_48652,(1),null);
eval(script_body_48654);


var G__48656 = seq__47526_48644;
var G__48657 = chunk__47527_48645;
var G__48658 = count__47528_48646;
var G__48659 = (i__47529_48647 + (1));
seq__47526_48644 = G__48656;
chunk__47527_48645 = G__48657;
count__47528_48646 = G__48658;
i__47529_48647 = G__48659;
continue;
} else {
var temp__5720__auto___48661 = cljs.core.seq(seq__47526_48644);
if(temp__5720__auto___48661){
var seq__47526_48662__$1 = temp__5720__auto___48661;
if(cljs.core.chunked_seq_QMARK_(seq__47526_48662__$1)){
var c__4556__auto___48664 = cljs.core.chunk_first(seq__47526_48662__$1);
var G__48665 = cljs.core.chunk_rest(seq__47526_48662__$1);
var G__48666 = c__4556__auto___48664;
var G__48667 = cljs.core.count(c__4556__auto___48664);
var G__48668 = (0);
seq__47526_48644 = G__48665;
chunk__47527_48645 = G__48666;
count__47528_48646 = G__48667;
i__47529_48647 = G__48668;
continue;
} else {
var vec__47564_48670 = cljs.core.first(seq__47526_48662__$1);
var script_tag_48671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47564_48670,(0),null);
var script_body_48672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47564_48670,(1),null);
eval(script_body_48672);


var G__48673 = cljs.core.next(seq__47526_48662__$1);
var G__48674 = null;
var G__48675 = (0);
var G__48676 = (0);
seq__47526_48644 = G__48673;
chunk__47527_48645 = G__48674;
count__47528_48646 = G__48675;
i__47529_48647 = G__48676;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__47571){
var vec__47574 = p__47571;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47574,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47574,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__47603 = arguments.length;
switch (G__47603) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__47649 = cljs.core.seq(style_keys);
var chunk__47650 = null;
var count__47651 = (0);
var i__47652 = (0);
while(true){
if((i__47652 < count__47651)){
var it = chunk__47650.cljs$core$IIndexed$_nth$arity$2(null,i__47652);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48687 = seq__47649;
var G__48688 = chunk__47650;
var G__48689 = count__47651;
var G__48690 = (i__47652 + (1));
seq__47649 = G__48687;
chunk__47650 = G__48688;
count__47651 = G__48689;
i__47652 = G__48690;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__47649);
if(temp__5720__auto__){
var seq__47649__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47649__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__47649__$1);
var G__48691 = cljs.core.chunk_rest(seq__47649__$1);
var G__48692 = c__4556__auto__;
var G__48693 = cljs.core.count(c__4556__auto__);
var G__48694 = (0);
seq__47649 = G__48691;
chunk__47650 = G__48692;
count__47651 = G__48693;
i__47652 = G__48694;
continue;
} else {
var it = cljs.core.first(seq__47649__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48696 = cljs.core.next(seq__47649__$1);
var G__48697 = null;
var G__48698 = (0);
var G__48699 = (0);
seq__47649 = G__48696;
chunk__47650 = G__48697;
count__47651 = G__48698;
i__47652 = G__48699;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k47690,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__47707 = k47690;
var G__47707__$1 = (((G__47707 instanceof cljs.core.Keyword))?G__47707.fqn:null);
switch (G__47707__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47690,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__47711){
var vec__47712 = p__47711;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47712,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47712,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47689){
var self__ = this;
var G__47689__$1 = this;
return (new cljs.core.RecordIter((0),G__47689__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47691,other47692){
var self__ = this;
var this47691__$1 = this;
return (((!((other47692 == null)))) && ((this47691__$1.constructor === other47692.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47691__$1.x,other47692.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47691__$1.y,other47692.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47691__$1.__extmap,other47692.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__47689){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__47742 = cljs.core.keyword_identical_QMARK_;
var expr__47743 = k__4388__auto__;
if(cljs.core.truth_((pred__47742.cljs$core$IFn$_invoke$arity$2 ? pred__47742.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__47743) : pred__47742.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__47743)))){
return (new shadow.dom.Coordinate(G__47689,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47742.cljs$core$IFn$_invoke$arity$2 ? pred__47742.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__47743) : pred__47742.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__47743)))){
return (new shadow.dom.Coordinate(self__.x,G__47689,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__47689),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__47689){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__47689,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__47698){
var extmap__4419__auto__ = (function (){var G__47764 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47698,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__47698)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47764);
} else {
return G__47764;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__47698),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__47698),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k47785,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__47796 = k47785;
var G__47796__$1 = (((G__47796 instanceof cljs.core.Keyword))?G__47796.fqn:null);
switch (G__47796__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47785,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__47800){
var vec__47801 = p__47800;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47801,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47801,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47784){
var self__ = this;
var G__47784__$1 = this;
return (new cljs.core.RecordIter((0),G__47784__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47786,other47787){
var self__ = this;
var this47786__$1 = this;
return (((!((other47787 == null)))) && ((this47786__$1.constructor === other47787.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47786__$1.w,other47787.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47786__$1.h,other47787.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47786__$1.__extmap,other47787.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__47784){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__47828 = cljs.core.keyword_identical_QMARK_;
var expr__47829 = k__4388__auto__;
if(cljs.core.truth_((pred__47828.cljs$core$IFn$_invoke$arity$2 ? pred__47828.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__47829) : pred__47828.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__47829)))){
return (new shadow.dom.Size(G__47784,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47828.cljs$core$IFn$_invoke$arity$2 ? pred__47828.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__47829) : pred__47828.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__47829)))){
return (new shadow.dom.Size(self__.w,G__47784,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__47784),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__47784){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__47784,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__47790){
var extmap__4419__auto__ = (function (){var G__47853 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47790,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__47790)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47853);
} else {
return G__47853;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__47790),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__47790),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__48778 = (i + (1));
var G__48779 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__48778;
ret = G__48779;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__47890){
var vec__47892 = p__47890;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47892,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47892,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__47899 = arguments.length;
switch (G__47899) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__48788 = ps;
var G__48789 = (i + (1));
el__$1 = G__48788;
i = G__48789;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47953 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47953,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47953,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47953,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47963_48792 = cljs.core.seq(props);
var chunk__47964_48793 = null;
var count__47965_48794 = (0);
var i__47966_48795 = (0);
while(true){
if((i__47966_48795 < count__47965_48794)){
var vec__48004_48796 = chunk__47964_48793.cljs$core$IIndexed$_nth$arity$2(null,i__47966_48795);
var k_48797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48004_48796,(0),null);
var v_48798 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48004_48796,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_48797);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48797),v_48798);


var G__48802 = seq__47963_48792;
var G__48803 = chunk__47964_48793;
var G__48804 = count__47965_48794;
var G__48805 = (i__47966_48795 + (1));
seq__47963_48792 = G__48802;
chunk__47964_48793 = G__48803;
count__47965_48794 = G__48804;
i__47966_48795 = G__48805;
continue;
} else {
var temp__5720__auto___48806 = cljs.core.seq(seq__47963_48792);
if(temp__5720__auto___48806){
var seq__47963_48807__$1 = temp__5720__auto___48806;
if(cljs.core.chunked_seq_QMARK_(seq__47963_48807__$1)){
var c__4556__auto___48808 = cljs.core.chunk_first(seq__47963_48807__$1);
var G__48809 = cljs.core.chunk_rest(seq__47963_48807__$1);
var G__48810 = c__4556__auto___48808;
var G__48811 = cljs.core.count(c__4556__auto___48808);
var G__48812 = (0);
seq__47963_48792 = G__48809;
chunk__47964_48793 = G__48810;
count__47965_48794 = G__48811;
i__47966_48795 = G__48812;
continue;
} else {
var vec__48019_48814 = cljs.core.first(seq__47963_48807__$1);
var k_48815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48019_48814,(0),null);
var v_48816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48019_48814,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_48815);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48815),v_48816);


var G__48817 = cljs.core.next(seq__47963_48807__$1);
var G__48818 = null;
var G__48819 = (0);
var G__48820 = (0);
seq__47963_48792 = G__48817;
chunk__47964_48793 = G__48818;
count__47965_48794 = G__48819;
i__47966_48795 = G__48820;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__48043 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48043,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48043,(1),null);
var seq__48047_48823 = cljs.core.seq(node_children);
var chunk__48049_48824 = null;
var count__48050_48825 = (0);
var i__48051_48826 = (0);
while(true){
if((i__48051_48826 < count__48050_48825)){
var child_struct_48828 = chunk__48049_48824.cljs$core$IIndexed$_nth$arity$2(null,i__48051_48826);
if((!((child_struct_48828 == null)))){
if(typeof child_struct_48828 === 'string'){
var text_48830 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48830),child_struct_48828].join(''));
} else {
var children_48831 = shadow.dom.svg_node(child_struct_48828);
if(cljs.core.seq_QMARK_(children_48831)){
var seq__48110_48834 = cljs.core.seq(children_48831);
var chunk__48112_48835 = null;
var count__48113_48836 = (0);
var i__48114_48837 = (0);
while(true){
if((i__48114_48837 < count__48113_48836)){
var child_48838 = chunk__48112_48835.cljs$core$IIndexed$_nth$arity$2(null,i__48114_48837);
if(cljs.core.truth_(child_48838)){
node.appendChild(child_48838);


var G__48839 = seq__48110_48834;
var G__48840 = chunk__48112_48835;
var G__48841 = count__48113_48836;
var G__48842 = (i__48114_48837 + (1));
seq__48110_48834 = G__48839;
chunk__48112_48835 = G__48840;
count__48113_48836 = G__48841;
i__48114_48837 = G__48842;
continue;
} else {
var G__48844 = seq__48110_48834;
var G__48845 = chunk__48112_48835;
var G__48846 = count__48113_48836;
var G__48847 = (i__48114_48837 + (1));
seq__48110_48834 = G__48844;
chunk__48112_48835 = G__48845;
count__48113_48836 = G__48846;
i__48114_48837 = G__48847;
continue;
}
} else {
var temp__5720__auto___48848 = cljs.core.seq(seq__48110_48834);
if(temp__5720__auto___48848){
var seq__48110_48851__$1 = temp__5720__auto___48848;
if(cljs.core.chunked_seq_QMARK_(seq__48110_48851__$1)){
var c__4556__auto___48852 = cljs.core.chunk_first(seq__48110_48851__$1);
var G__48853 = cljs.core.chunk_rest(seq__48110_48851__$1);
var G__48854 = c__4556__auto___48852;
var G__48855 = cljs.core.count(c__4556__auto___48852);
var G__48856 = (0);
seq__48110_48834 = G__48853;
chunk__48112_48835 = G__48854;
count__48113_48836 = G__48855;
i__48114_48837 = G__48856;
continue;
} else {
var child_48858 = cljs.core.first(seq__48110_48851__$1);
if(cljs.core.truth_(child_48858)){
node.appendChild(child_48858);


var G__48859 = cljs.core.next(seq__48110_48851__$1);
var G__48860 = null;
var G__48861 = (0);
var G__48862 = (0);
seq__48110_48834 = G__48859;
chunk__48112_48835 = G__48860;
count__48113_48836 = G__48861;
i__48114_48837 = G__48862;
continue;
} else {
var G__48863 = cljs.core.next(seq__48110_48851__$1);
var G__48864 = null;
var G__48865 = (0);
var G__48866 = (0);
seq__48110_48834 = G__48863;
chunk__48112_48835 = G__48864;
count__48113_48836 = G__48865;
i__48114_48837 = G__48866;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48831);
}
}


var G__48869 = seq__48047_48823;
var G__48870 = chunk__48049_48824;
var G__48871 = count__48050_48825;
var G__48872 = (i__48051_48826 + (1));
seq__48047_48823 = G__48869;
chunk__48049_48824 = G__48870;
count__48050_48825 = G__48871;
i__48051_48826 = G__48872;
continue;
} else {
var G__48875 = seq__48047_48823;
var G__48876 = chunk__48049_48824;
var G__48877 = count__48050_48825;
var G__48878 = (i__48051_48826 + (1));
seq__48047_48823 = G__48875;
chunk__48049_48824 = G__48876;
count__48050_48825 = G__48877;
i__48051_48826 = G__48878;
continue;
}
} else {
var temp__5720__auto___48879 = cljs.core.seq(seq__48047_48823);
if(temp__5720__auto___48879){
var seq__48047_48880__$1 = temp__5720__auto___48879;
if(cljs.core.chunked_seq_QMARK_(seq__48047_48880__$1)){
var c__4556__auto___48881 = cljs.core.chunk_first(seq__48047_48880__$1);
var G__48882 = cljs.core.chunk_rest(seq__48047_48880__$1);
var G__48884 = c__4556__auto___48881;
var G__48885 = cljs.core.count(c__4556__auto___48881);
var G__48886 = (0);
seq__48047_48823 = G__48882;
chunk__48049_48824 = G__48884;
count__48050_48825 = G__48885;
i__48051_48826 = G__48886;
continue;
} else {
var child_struct_48891 = cljs.core.first(seq__48047_48880__$1);
if((!((child_struct_48891 == null)))){
if(typeof child_struct_48891 === 'string'){
var text_48892 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48892),child_struct_48891].join(''));
} else {
var children_48893 = shadow.dom.svg_node(child_struct_48891);
if(cljs.core.seq_QMARK_(children_48893)){
var seq__48134_48894 = cljs.core.seq(children_48893);
var chunk__48136_48895 = null;
var count__48137_48896 = (0);
var i__48138_48897 = (0);
while(true){
if((i__48138_48897 < count__48137_48896)){
var child_48902 = chunk__48136_48895.cljs$core$IIndexed$_nth$arity$2(null,i__48138_48897);
if(cljs.core.truth_(child_48902)){
node.appendChild(child_48902);


var G__48903 = seq__48134_48894;
var G__48904 = chunk__48136_48895;
var G__48905 = count__48137_48896;
var G__48906 = (i__48138_48897 + (1));
seq__48134_48894 = G__48903;
chunk__48136_48895 = G__48904;
count__48137_48896 = G__48905;
i__48138_48897 = G__48906;
continue;
} else {
var G__48907 = seq__48134_48894;
var G__48908 = chunk__48136_48895;
var G__48909 = count__48137_48896;
var G__48910 = (i__48138_48897 + (1));
seq__48134_48894 = G__48907;
chunk__48136_48895 = G__48908;
count__48137_48896 = G__48909;
i__48138_48897 = G__48910;
continue;
}
} else {
var temp__5720__auto___48912__$1 = cljs.core.seq(seq__48134_48894);
if(temp__5720__auto___48912__$1){
var seq__48134_48913__$1 = temp__5720__auto___48912__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48134_48913__$1)){
var c__4556__auto___48914 = cljs.core.chunk_first(seq__48134_48913__$1);
var G__48919 = cljs.core.chunk_rest(seq__48134_48913__$1);
var G__48920 = c__4556__auto___48914;
var G__48921 = cljs.core.count(c__4556__auto___48914);
var G__48922 = (0);
seq__48134_48894 = G__48919;
chunk__48136_48895 = G__48920;
count__48137_48896 = G__48921;
i__48138_48897 = G__48922;
continue;
} else {
var child_48923 = cljs.core.first(seq__48134_48913__$1);
if(cljs.core.truth_(child_48923)){
node.appendChild(child_48923);


var G__48924 = cljs.core.next(seq__48134_48913__$1);
var G__48925 = null;
var G__48926 = (0);
var G__48927 = (0);
seq__48134_48894 = G__48924;
chunk__48136_48895 = G__48925;
count__48137_48896 = G__48926;
i__48138_48897 = G__48927;
continue;
} else {
var G__48928 = cljs.core.next(seq__48134_48913__$1);
var G__48929 = null;
var G__48930 = (0);
var G__48931 = (0);
seq__48134_48894 = G__48928;
chunk__48136_48895 = G__48929;
count__48137_48896 = G__48930;
i__48138_48897 = G__48931;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48893);
}
}


var G__48932 = cljs.core.next(seq__48047_48880__$1);
var G__48933 = null;
var G__48934 = (0);
var G__48935 = (0);
seq__48047_48823 = G__48932;
chunk__48049_48824 = G__48933;
count__48050_48825 = G__48934;
i__48051_48826 = G__48935;
continue;
} else {
var G__48937 = cljs.core.next(seq__48047_48880__$1);
var G__48938 = null;
var G__48939 = (0);
var G__48940 = (0);
seq__48047_48823 = G__48937;
chunk__48049_48824 = G__48938;
count__48050_48825 = G__48939;
i__48051_48826 = G__48940;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48947 = arguments.length;
var i__4737__auto___48948 = (0);
while(true){
if((i__4737__auto___48948 < len__4736__auto___48947)){
args__4742__auto__.push((arguments[i__4737__auto___48948]));

var G__48950 = (i__4737__auto___48948 + (1));
i__4737__auto___48948 = G__48950;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq48174){
var G__48175 = cljs.core.first(seq48174);
var seq48174__$1 = cljs.core.next(seq48174);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48175,seq48174__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__48201 = arguments.length;
switch (G__48201) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__44004__auto___48963 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44005__auto__ = (function (){var switch__43869__auto__ = (function (state_48221){
var state_val_48224 = (state_48221[(1)]);
if((state_val_48224 === (1))){
var state_48221__$1 = state_48221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48221__$1,(2),once_or_cleanup);
} else {
if((state_val_48224 === (2))){
var inst_48218 = (state_48221[(2)]);
var inst_48219 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_48221__$1 = (function (){var statearr_48226 = state_48221;
(statearr_48226[(7)] = inst_48218);

return statearr_48226;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48221__$1,inst_48219);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43870__auto__ = null;
var shadow$dom$state_machine__43870__auto____0 = (function (){
var statearr_48228 = [null,null,null,null,null,null,null,null];
(statearr_48228[(0)] = shadow$dom$state_machine__43870__auto__);

(statearr_48228[(1)] = (1));

return statearr_48228;
});
var shadow$dom$state_machine__43870__auto____1 = (function (state_48221){
while(true){
var ret_value__43871__auto__ = (function (){try{while(true){
var result__43872__auto__ = switch__43869__auto__(state_48221);
if(cljs.core.keyword_identical_QMARK_(result__43872__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43872__auto__;
}
break;
}
}catch (e48231){var ex__43873__auto__ = e48231;
var statearr_48232_48981 = state_48221;
(statearr_48232_48981[(2)] = ex__43873__auto__);


if(cljs.core.seq((state_48221[(4)]))){
var statearr_48235_48982 = state_48221;
(statearr_48235_48982[(1)] = cljs.core.first((state_48221[(4)])));

} else {
throw ex__43873__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43871__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48984 = state_48221;
state_48221 = G__48984;
continue;
} else {
return ret_value__43871__auto__;
}
break;
}
});
shadow$dom$state_machine__43870__auto__ = function(state_48221){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43870__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43870__auto____1.call(this,state_48221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43870__auto____0;
shadow$dom$state_machine__43870__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43870__auto____1;
return shadow$dom$state_machine__43870__auto__;
})()
})();
var state__44006__auto__ = (function (){var statearr_48241 = f__44005__auto__();
(statearr_48241[(6)] = c__44004__auto___48963);

return statearr_48241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44006__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
