goog.provide('pinkgorilla.ui.data.leaflet');
var module$node_modules$react_leaflet$lib$index=shadow.js.require("module$node_modules$react_leaflet$lib$index", {});
var module$node_modules$leaflet$dist$leaflet_src=shadow.js.require("module$node_modules$leaflet$dist$leaflet_src", {});
pinkgorilla.ui.data.leaflet.config = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"css","css",1135045163),"leaflet/dist/leaflet.css",new cljs.core.Keyword(null,"tile-layer-url","tile-layer-url",-1729025633),"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",new cljs.core.Keyword(null,"attribution","attribution",1937239286),"&copy; <a href=&quot;http://osm.org/copyright&quot;>OpenStreetMap</a> contributors"], null);
pinkgorilla.ui.data.leaflet.marker = (function pinkgorilla$ui$data$leaflet$marker(){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"icon","icon",1679606541),(new module$node_modules$leaflet$dist$leaflet_src.Icon(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"iconUrl","iconUrl",-1868537869),pinkgorilla.ui.config.res_href("leaflet/dist/images/marker-icon.png"),new cljs.core.Keyword(null,"iconRetinaUrl","iconRetinaUrl",932366134),pinkgorilla.ui.config.res_href("leaflet/dist/images/marker-icon-2x.png"),new cljs.core.Keyword(null,"iconAnchor","iconAnchor",970343173),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(55)], null),new cljs.core.Keyword(null,"popupAnchor","popupAnchor",931949236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(-44)], null),new cljs.core.Keyword(null,"iconSize","iconSize",253109071),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(25),(55)], null),new cljs.core.Keyword(null,"shadowUrl","shadowUrl",1986496437),pinkgorilla.ui.config.res_href("leaflet/dist/images/marker-shadow.png"),new cljs.core.Keyword(null,"shadowSize","shadowSize",-1015046863),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(68),(95)], null),new cljs.core.Keyword(null,"shadowAnchor","shadowAnchor",643451688),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(20),(92)], null)], null))))], null);
});
pinkgorilla.ui.data.leaflet.log = (function pinkgorilla$ui$data$leaflet$log(s){
return console.log(s);
});
pinkgorilla.ui.data.leaflet.feature = (function pinkgorilla$ui$data$leaflet$feature(data_with_type){
var type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(data_with_type);
var data = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(data_with_type,new cljs.core.Keyword(null,"type","type",1174270348));
var G__23008 = type;
var G__23008__$1 = (((G__23008 instanceof cljs.core.Keyword))?G__23008.fqn:null);
switch (G__23008__$1) {
case "rectangle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Rectangle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Circle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "line":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polyline,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "polygon":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polygon,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "marker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Marker,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pinkgorilla.ui.data.leaflet.marker(),data], 0)),(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circlemarker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.CircleMarker,data,(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "geojson":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.GeoJSON,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
default:
pinkgorilla.ui.data.leaflet.log(["No feature found for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''));

return null;

}
});
pinkgorilla.ui.data.leaflet.view_QMARK_ = (function pinkgorilla$ui$data$leaflet$view_QMARK_(feature){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(feature));
});
pinkgorilla.ui.data.leaflet.assoc_if_exists = (function pinkgorilla$ui$data$leaflet$assoc_if_exists(m,key,val){
if((val == null)){
return m;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,key,val);
}
});
pinkgorilla.ui.data.leaflet.view_map_props = (function pinkgorilla$ui$data$leaflet$view_map_props(view){
var map__23020 = view;
var map__23020__$1 = (((((!((map__23020 == null))))?(((((map__23020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23020.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23020):map__23020);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23020__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23020__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23020__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23020__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var useFlyTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23020__$1,new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032));
var style = (cljs.core.truth_((function (){var or__4126__auto__ = width;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return height;
}
})())?pinkgorilla.ui.data.leaflet.assoc_if_exists(pinkgorilla.ui.data.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"width","width",-384071477),width),new cljs.core.Keyword(null,"height","height",1025178622),height):null);
return pinkgorilla.ui.data.leaflet.assoc_if_exists(pinkgorilla.ui.data.leaflet.assoc_if_exists(pinkgorilla.ui.data.leaflet.assoc_if_exists(pinkgorilla.ui.data.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"style","style",-496642736),style),new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom),new cljs.core.Keyword(null,"center","center",-748944368),center),new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032),useFlyTo);
});
/**
 * displays a map with leaflet.
 * example:
 *   [:p/leaflet
 * [{:type :view :center [51.49, -0.08] :zoom 12 :height 600 :width 700}
 *  {:type :rectangle :bounds rectangle}
 *  {:type :circle :center center :fillColor :blue :radius 200}
 *  {:type :polygon :positions polygon :color :purple}
 *  {:type :polygon :positions multiPolygon :color :purple}
 *  {:type :line :positions polyline :color :lime}
 *  {:type :line :positions multi-polyline :color :lime}
 *  {:type :marker :position [51.505, -0.09]}
 *  {:type :marker :position [51.51, -0.12] :popup "wow"}
 *  {:type :circlemarker :center [51.52, -0.06] :fillColor :blue :radius 200 :popup "square the circle"}
 *  {:type :geojson :data geojson}]]
 */
pinkgorilla.ui.data.leaflet.leaflet_map = (function pinkgorilla$ui$data$leaflet$leaflet_map(var_args){
var G__23057 = arguments.length;
switch (G__23057) {
case 2:
return pinkgorilla.ui.data.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return pinkgorilla.ui.data.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(pinkgorilla.ui.data.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2 = (function (options,features_incl_view){
var map__23059 = pinkgorilla.ui.data.leaflet.config;
var map__23059__$1 = (((((!((map__23059 == null))))?(((((map__23059.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23059.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23059):map__23059);
var css = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23059__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var tile_layer_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23059__$1,new cljs.core.Keyword(null,"tile-layer-url","tile-layer-url",-1729025633));
var attribution = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23059__$1,new cljs.core.Keyword(null,"attribution","attribution",1937239286));
var map__23060 = options;
var map__23060__$1 = (((((!((map__23060 == null))))?(((((map__23060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23060.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23060):map__23060);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23060__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23060__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23060__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23060__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var view = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.data.leaflet.view_QMARK_,features_incl_view));
var features = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.data.leaflet.view_QMARK_,features_incl_view);
var view_map = pinkgorilla.ui.data.leaflet.view_map_props(view);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.z-10","div.z-10",-323390226),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pinkgorilla.ui.config.link_css,css], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Map,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom,new cljs.core.Keyword(null,"center","center",-748944368),center,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height], null),new cljs.core.Keyword(null,"keyboard","keyboard",-617357087),true,new cljs.core.Keyword(null,"class","class",-2030961996),"z-10"], null),view_map], 0)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.TileLayer,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),tile_layer_url,new cljs.core.Keyword(null,"attribution","attribution",1937239286),attribution], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.ui.data.leaflet.feature,features))], null)], null);
}));

(pinkgorilla.ui.data.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1 = (function (features){
return pinkgorilla.ui.data.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2(pinkgorilla.dsl.leaflet.default_options,features);
}));

(pinkgorilla.ui.data.leaflet.leaflet_map.cljs$lang$maxFixedArity = 2);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pinkie.pinkie.component_registry,cljs.core.assoc,new cljs.core.Keyword("p","leaflet","p/leaflet",1547983832),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fun","fun",-1265158045),pinkgorilla.ui.data.leaflet.leaflet_map,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core.meta(new cljs.core.Var(function(){return pinkgorilla.ui.data.leaflet.leaflet_map;},new cljs.core.Symbol("pinkgorilla.ui.data.leaflet","leaflet-map","pinkgorilla.ui.data.leaflet/leaflet-map",2012654191,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Symbol(null,"pinkgorilla.ui.data.leaflet","pinkgorilla.ui.data.leaflet",-859949500,null),new cljs.core.Symbol(null,"leaflet-map","leaflet-map",1508038780,null),"pinkgorilla/ui/data/leaflet.cljs",14,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.Symbol(null,"features-incl-view","features-incl-view",-1463689048,null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"features","features",493569191,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.Symbol(null,"features-incl-view","features-incl-view",-1463689048,null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"features","features",493569191,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,95,96,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.Symbol(null,"features-incl-view","features-incl-view",-1463689048,null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"features","features",493569191,null)], null)),"displays a map with leaflet.\n   example:\n  [:p/leaflet\n   [{:type :view :center [51.49, -0.08] :zoom 12 :height 600 :width 700}\n    {:type :rectangle :bounds rectangle}\n    {:type :circle :center center :fillColor :blue :radius 200}\n    {:type :polygon :positions polygon :color :purple}\n    {:type :polygon :positions multiPolygon :color :purple}\n    {:type :line :positions polyline :color :lime}\n    {:type :line :positions multi-polyline :color :lime}\n    {:type :marker :position [51.505, -0.09]}\n    {:type :marker :position [51.51, -0.12] :popup \"wow\"}\n    {:type :circlemarker :center [51.52, -0.06] :fillColor :blue :radius 200 :popup \"square the circle\"}\n    {:type :geojson :data geojson}]]",(cljs.core.truth_(pinkgorilla.ui.data.leaflet.leaflet_map)?pinkgorilla.ui.data.leaflet.leaflet_map.cljs$lang$test:null)]))),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword("p","leaflet","p/leaflet",1547983832)], null));

//# sourceMappingURL=pinkgorilla.ui.data.leaflet.js.map
