goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5720__auto__ = (function (){var fexpr__30496 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__30496.cljs$core$IFn$_invoke$arity$1 ? fexpr__30496.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__30496.call(null,channel));
})();
if(cljs.core.truth_(temp__5720__auto__)){
var req = temp__5720__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__30526){
var vec__30527 = p__30526;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30527,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30527,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__30537 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__30537)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__30537)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__30537)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__30537)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__30537)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__30537)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30537)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__30549){
var map__30550 = p__30549;
var map__30550__$1 = (((((!((map__30550 == null))))?(((((map__30550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30550):map__30550);
var request = map__30550__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30550__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30550__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30550__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__30564 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__30564,default_headers);

cljs_http.core.apply_response_type_BANG_(G__30564,response_type);

G__30564.setTimeoutInterval(timeout);

G__30564.setWithCredentials(send_credentials);

return G__30564;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__30572){
var map__30573 = p__30572;
var map__30573__$1 = (((((!((map__30573 == null))))?(((((map__30573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30573.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30573):map__30573);
var request = map__30573__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30573__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30573__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30573__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30573__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30573__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30573__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__30579 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__30579) : cljs_http.core.error_kw.call(null,G__30579));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_30792 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__30592_30798 = xhr;
G__30592_30798.setProgressEventsEnabled(true);

G__30592_30798.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_30792,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__30592_30798.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_30792,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__28256__auto___30801 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30612){
var state_val_30613 = (state_30612[(1)]);
if((state_val_30613 === (1))){
var state_30612__$1 = state_30612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30612__$1,(2),cancel);
} else {
if((state_val_30613 === (2))){
var inst_30599 = (state_30612[(2)]);
var inst_30601 = xhr.isComplete();
var inst_30602 = cljs.core.not(inst_30601);
var state_30612__$1 = (function (){var statearr_30617 = state_30612;
(statearr_30617[(7)] = inst_30599);

return statearr_30617;
})();
if(inst_30602){
var statearr_30618_30808 = state_30612__$1;
(statearr_30618_30808[(1)] = (3));

} else {
var statearr_30619_30810 = state_30612__$1;
(statearr_30619_30810[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30613 === (3))){
var inst_30604 = xhr.abort();
var state_30612__$1 = state_30612;
var statearr_30620_30816 = state_30612__$1;
(statearr_30620_30816[(2)] = inst_30604);

(statearr_30620_30816[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30613 === (4))){
var state_30612__$1 = state_30612;
var statearr_30622_30818 = state_30612__$1;
(statearr_30622_30818[(2)] = null);

(statearr_30622_30818[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30613 === (5))){
var inst_30607 = (state_30612[(2)]);
var state_30612__$1 = state_30612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30612__$1,inst_30607);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__28148__auto__ = null;
var cljs_http$core$xhr_$_state_machine__28148__auto____0 = (function (){
var statearr_30630 = [null,null,null,null,null,null,null,null];
(statearr_30630[(0)] = cljs_http$core$xhr_$_state_machine__28148__auto__);

(statearr_30630[(1)] = (1));

return statearr_30630;
});
var cljs_http$core$xhr_$_state_machine__28148__auto____1 = (function (state_30612){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30612);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30631){var ex__28151__auto__ = e30631;
var statearr_30633_30824 = state_30612;
(statearr_30633_30824[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30612[(4)]))){
var statearr_30635_30827 = state_30612;
(statearr_30635_30827[(1)] = cljs.core.first((state_30612[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30828 = state_30612;
state_30612 = G__30828;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__28148__auto__ = function(state_30612){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__28148__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__28148__auto____1.call(this,state_30612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__28148__auto____0;
cljs_http$core$xhr_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__28148__auto____1;
return cljs_http$core$xhr_$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30640 = f__28257__auto__();
(statearr_30640[(6)] = c__28256__auto___30801);

return statearr_30640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__30647){
var map__30648 = p__30647;
var map__30648__$1 = (((((!((map__30648 == null))))?(((((map__30648.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30648.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30648):map__30648);
var request = map__30648__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30648__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30648__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30648__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30648__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_30838 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_30838], null));

if(cljs.core.truth_(cancel)){
var c__28256__auto___30846 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30663){
var state_val_30664 = (state_30663[(1)]);
if((state_val_30664 === (1))){
var state_30663__$1 = state_30663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30663__$1,(2),cancel);
} else {
if((state_val_30664 === (2))){
var inst_30660 = (state_30663[(2)]);
var inst_30661 = jsonp.cancel(req_30838);
var state_30663__$1 = (function (){var statearr_30668 = state_30663;
(statearr_30668[(7)] = inst_30660);

return statearr_30668;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30663__$1,inst_30661);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__28148__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__28148__auto____0 = (function (){
var statearr_30673 = [null,null,null,null,null,null,null,null];
(statearr_30673[(0)] = cljs_http$core$jsonp_$_state_machine__28148__auto__);

(statearr_30673[(1)] = (1));

return statearr_30673;
});
var cljs_http$core$jsonp_$_state_machine__28148__auto____1 = (function (state_30663){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30663);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30675){var ex__28151__auto__ = e30675;
var statearr_30676_30853 = state_30663;
(statearr_30676_30853[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30663[(4)]))){
var statearr_30677_30857 = state_30663;
(statearr_30677_30857[(1)] = cljs.core.first((state_30663[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30859 = state_30663;
state_30663 = G__30859;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__28148__auto__ = function(state_30663){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__28148__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__28148__auto____1.call(this,state_30663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__28148__auto____0;
cljs_http$core$jsonp_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__28148__auto____1;
return cljs_http$core$jsonp_$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30680 = f__28257__auto__();
(statearr_30680[(6)] = c__28256__auto___30846);

return statearr_30680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__30684){
var map__30685 = p__30684;
var map__30685__$1 = (((((!((map__30685 == null))))?(((((map__30685.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30685.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30685):map__30685);
var request = map__30685__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30685__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
