goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28348 = arguments.length;
switch (G__28348) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28349 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28349 = (function (f,blockable,meta28350){
this.f = f;
this.blockable = blockable;
this.meta28350 = meta28350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28351,meta28350__$1){
var self__ = this;
var _28351__$1 = this;
return (new cljs.core.async.t_cljs$core$async28349(self__.f,self__.blockable,meta28350__$1));
}));

(cljs.core.async.t_cljs$core$async28349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28351){
var self__ = this;
var _28351__$1 = this;
return self__.meta28350;
}));

(cljs.core.async.t_cljs$core$async28349.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28349.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28349.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28349.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28350","meta28350",44084643,null)], null);
}));

(cljs.core.async.t_cljs$core$async28349.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28349.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28349");

(cljs.core.async.t_cljs$core$async28349.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28349");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28349.
 */
cljs.core.async.__GT_t_cljs$core$async28349 = (function cljs$core$async$__GT_t_cljs$core$async28349(f__$1,blockable__$1,meta28350){
return (new cljs.core.async.t_cljs$core$async28349(f__$1,blockable__$1,meta28350));
});

}

return (new cljs.core.async.t_cljs$core$async28349(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28366 = arguments.length;
switch (G__28366) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28383 = arguments.length;
switch (G__28383) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28391 = arguments.length;
switch (G__28391) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30497 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30497) : fn1.call(null,val_30497));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30497) : fn1.call(null,val_30497));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28400 = arguments.length;
switch (G__28400) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30538 = n;
var x_30540 = (0);
while(true){
if((x_30540 < n__4613__auto___30538)){
(a[x_30540] = x_30540);

var G__30542 = (x_30540 + (1));
x_30540 = G__30542;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28402 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28402 = (function (flag,meta28403){
this.flag = flag;
this.meta28403 = meta28403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28404,meta28403__$1){
var self__ = this;
var _28404__$1 = this;
return (new cljs.core.async.t_cljs$core$async28402(self__.flag,meta28403__$1));
}));

(cljs.core.async.t_cljs$core$async28402.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28404){
var self__ = this;
var _28404__$1 = this;
return self__.meta28403;
}));

(cljs.core.async.t_cljs$core$async28402.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28402.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28402.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28402.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28402.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28403","meta28403",1668273187,null)], null);
}));

(cljs.core.async.t_cljs$core$async28402.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28402.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28402");

(cljs.core.async.t_cljs$core$async28402.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28402");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28402.
 */
cljs.core.async.__GT_t_cljs$core$async28402 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28402(flag__$1,meta28403){
return (new cljs.core.async.t_cljs$core$async28402(flag__$1,meta28403));
});

}

return (new cljs.core.async.t_cljs$core$async28402(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28407 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28407 = (function (flag,cb,meta28408){
this.flag = flag;
this.cb = cb;
this.meta28408 = meta28408;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28407.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28409,meta28408__$1){
var self__ = this;
var _28409__$1 = this;
return (new cljs.core.async.t_cljs$core$async28407(self__.flag,self__.cb,meta28408__$1));
}));

(cljs.core.async.t_cljs$core$async28407.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28409){
var self__ = this;
var _28409__$1 = this;
return self__.meta28408;
}));

(cljs.core.async.t_cljs$core$async28407.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28407.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28407.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28407.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28407.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28408","meta28408",1732673954,null)], null);
}));

(cljs.core.async.t_cljs$core$async28407.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28407.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28407");

(cljs.core.async.t_cljs$core$async28407.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28407");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28407.
 */
cljs.core.async.__GT_t_cljs$core$async28407 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28407(flag__$1,cb__$1,meta28408){
return (new cljs.core.async.t_cljs$core$async28407(flag__$1,cb__$1,meta28408));
});

}

return (new cljs.core.async.t_cljs$core$async28407(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28411_SHARP_){
var G__28414 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28411_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28414) : fret.call(null,G__28414));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28412_SHARP_){
var G__28415 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28412_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28415) : fret.call(null,G__28415));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30583 = (i + (1));
i = G__30583;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30595 = arguments.length;
var i__4737__auto___30597 = (0);
while(true){
if((i__4737__auto___30597 < len__4736__auto___30595)){
args__4742__auto__.push((arguments[i__4737__auto___30597]));

var G__30600 = (i__4737__auto___30597 + (1));
i__4737__auto___30597 = G__30600;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28421){
var map__28422 = p__28421;
var map__28422__$1 = (((((!((map__28422 == null))))?(((((map__28422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28422):map__28422);
var opts = map__28422__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28416){
var G__28417 = cljs.core.first(seq28416);
var seq28416__$1 = cljs.core.next(seq28416);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28417,seq28416__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28451 = arguments.length;
switch (G__28451) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28256__auto___30629 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28486){
var state_val_28487 = (state_28486[(1)]);
if((state_val_28487 === (7))){
var inst_28482 = (state_28486[(2)]);
var state_28486__$1 = state_28486;
var statearr_28488_30634 = state_28486__$1;
(statearr_28488_30634[(2)] = inst_28482);

(statearr_28488_30634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (1))){
var state_28486__$1 = state_28486;
var statearr_28489_30636 = state_28486__$1;
(statearr_28489_30636[(2)] = null);

(statearr_28489_30636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (4))){
var inst_28463 = (state_28486[(7)]);
var inst_28463__$1 = (state_28486[(2)]);
var inst_28464 = (inst_28463__$1 == null);
var state_28486__$1 = (function (){var statearr_28499 = state_28486;
(statearr_28499[(7)] = inst_28463__$1);

return statearr_28499;
})();
if(cljs.core.truth_(inst_28464)){
var statearr_28503_30642 = state_28486__$1;
(statearr_28503_30642[(1)] = (5));

} else {
var statearr_28509_30643 = state_28486__$1;
(statearr_28509_30643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (13))){
var state_28486__$1 = state_28486;
var statearr_28515_30644 = state_28486__$1;
(statearr_28515_30644[(2)] = null);

(statearr_28515_30644[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (6))){
var inst_28463 = (state_28486[(7)]);
var state_28486__$1 = state_28486;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28486__$1,(11),to,inst_28463);
} else {
if((state_val_28487 === (3))){
var inst_28484 = (state_28486[(2)]);
var state_28486__$1 = state_28486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28486__$1,inst_28484);
} else {
if((state_val_28487 === (12))){
var state_28486__$1 = state_28486;
var statearr_28521_30650 = state_28486__$1;
(statearr_28521_30650[(2)] = null);

(statearr_28521_30650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (2))){
var state_28486__$1 = state_28486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28486__$1,(4),from);
} else {
if((state_val_28487 === (11))){
var inst_28473 = (state_28486[(2)]);
var state_28486__$1 = state_28486;
if(cljs.core.truth_(inst_28473)){
var statearr_28536_30652 = state_28486__$1;
(statearr_28536_30652[(1)] = (12));

} else {
var statearr_28538_30653 = state_28486__$1;
(statearr_28538_30653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (9))){
var state_28486__$1 = state_28486;
var statearr_28543_30654 = state_28486__$1;
(statearr_28543_30654[(2)] = null);

(statearr_28543_30654[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (5))){
var state_28486__$1 = state_28486;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28544_30655 = state_28486__$1;
(statearr_28544_30655[(1)] = (8));

} else {
var statearr_28545_30656 = state_28486__$1;
(statearr_28545_30656[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (14))){
var inst_28480 = (state_28486[(2)]);
var state_28486__$1 = state_28486;
var statearr_28562_30657 = state_28486__$1;
(statearr_28562_30657[(2)] = inst_28480);

(statearr_28562_30657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (10))){
var inst_28470 = (state_28486[(2)]);
var state_28486__$1 = state_28486;
var statearr_28571_30658 = state_28486__$1;
(statearr_28571_30658[(2)] = inst_28470);

(statearr_28571_30658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28487 === (8))){
var inst_28467 = cljs.core.async.close_BANG_(to);
var state_28486__$1 = state_28486;
var statearr_28579_30665 = state_28486__$1;
(statearr_28579_30665[(2)] = inst_28467);

(statearr_28579_30665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_28581 = [null,null,null,null,null,null,null,null];
(statearr_28581[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_28581[(1)] = (1));

return statearr_28581;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_28486){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28486);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28587){var ex__28151__auto__ = e28587;
var statearr_28588_30669 = state_28486;
(statearr_28588_30669[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28486[(4)]))){
var statearr_28589_30671 = state_28486;
(statearr_28589_30671[(1)] = cljs.core.first((state_28486[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30674 = state_28486;
state_28486 = G__30674;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_28486){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_28486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_28590 = f__28257__auto__();
(statearr_28590[(6)] = c__28256__auto___30629);

return statearr_28590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28592){
var vec__28593 = p__28592;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28593,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28593,(1),null);
var job = vec__28593;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28256__auto___30683 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28600){
var state_val_28601 = (state_28600[(1)]);
if((state_val_28601 === (1))){
var state_28600__$1 = state_28600;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28600__$1,(2),res,v);
} else {
if((state_val_28601 === (2))){
var inst_28597 = (state_28600[(2)]);
var inst_28598 = cljs.core.async.close_BANG_(res);
var state_28600__$1 = (function (){var statearr_28603 = state_28600;
(statearr_28603[(7)] = inst_28597);

return statearr_28603;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28600__$1,inst_28598);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0 = (function (){
var statearr_28604 = [null,null,null,null,null,null,null,null];
(statearr_28604[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__);

(statearr_28604[(1)] = (1));

return statearr_28604;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1 = (function (state_28600){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28600);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28605){var ex__28151__auto__ = e28605;
var statearr_28606_30693 = state_28600;
(statearr_28606_30693[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28600[(4)]))){
var statearr_28607_30694 = state_28600;
(statearr_28607_30694[(1)] = cljs.core.first((state_28600[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30695 = state_28600;
state_28600 = G__30695;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = function(state_28600){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1.call(this,state_28600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_28608 = f__28257__auto__();
(statearr_28608[(6)] = c__28256__auto___30683);

return statearr_28608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28616){
var vec__28620 = p__28616;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28620,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28620,(1),null);
var job = vec__28620;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30698 = n;
var __30699 = (0);
while(true){
if((__30699 < n__4613__auto___30698)){
var G__28634_30700 = type;
var G__28634_30701__$1 = (((G__28634_30700 instanceof cljs.core.Keyword))?G__28634_30700.fqn:null);
switch (G__28634_30701__$1) {
case "compute":
var c__28256__auto___30703 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30699,c__28256__auto___30703,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async){
return (function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = ((function (__30699,c__28256__auto___30703,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async){
return (function (state_28650){
var state_val_28651 = (state_28650[(1)]);
if((state_val_28651 === (1))){
var state_28650__$1 = state_28650;
var statearr_28653_30706 = state_28650__$1;
(statearr_28653_30706[(2)] = null);

(statearr_28653_30706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28651 === (2))){
var state_28650__$1 = state_28650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28650__$1,(4),jobs);
} else {
if((state_val_28651 === (3))){
var inst_28648 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28650__$1,inst_28648);
} else {
if((state_val_28651 === (4))){
var inst_28640 = (state_28650[(2)]);
var inst_28641 = process(inst_28640);
var state_28650__$1 = state_28650;
if(cljs.core.truth_(inst_28641)){
var statearr_28660_30723 = state_28650__$1;
(statearr_28660_30723[(1)] = (5));

} else {
var statearr_28661_30728 = state_28650__$1;
(statearr_28661_30728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28651 === (5))){
var state_28650__$1 = state_28650;
var statearr_28665_30734 = state_28650__$1;
(statearr_28665_30734[(2)] = null);

(statearr_28665_30734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28651 === (6))){
var state_28650__$1 = state_28650;
var statearr_28666_30747 = state_28650__$1;
(statearr_28666_30747[(2)] = null);

(statearr_28666_30747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28651 === (7))){
var inst_28646 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
var statearr_28667_30758 = state_28650__$1;
(statearr_28667_30758[(2)] = inst_28646);

(statearr_28667_30758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30699,c__28256__auto___30703,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async))
;
return ((function (__30699,switch__28147__auto__,c__28256__auto___30703,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0 = (function (){
var statearr_28668 = [null,null,null,null,null,null,null];
(statearr_28668[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__);

(statearr_28668[(1)] = (1));

return statearr_28668;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1 = (function (state_28650){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28650);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28669){var ex__28151__auto__ = e28669;
var statearr_28670_30784 = state_28650;
(statearr_28670_30784[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28650[(4)]))){
var statearr_28671_30785 = state_28650;
(statearr_28671_30785[(1)] = cljs.core.first((state_28650[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30787 = state_28650;
state_28650 = G__30787;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = function(state_28650){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1.call(this,state_28650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__;
})()
;})(__30699,switch__28147__auto__,c__28256__auto___30703,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async))
})();
var state__28258__auto__ = (function (){var statearr_28672 = f__28257__auto__();
(statearr_28672[(6)] = c__28256__auto___30703);

return statearr_28672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
});})(__30699,c__28256__auto___30703,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async))
);


break;
case "async":
var c__28256__auto___30790 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30699,c__28256__auto___30790,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async){
return (function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = ((function (__30699,c__28256__auto___30790,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async){
return (function (state_28685){
var state_val_28686 = (state_28685[(1)]);
if((state_val_28686 === (1))){
var state_28685__$1 = state_28685;
var statearr_28690_30793 = state_28685__$1;
(statearr_28690_30793[(2)] = null);

(statearr_28690_30793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28686 === (2))){
var state_28685__$1 = state_28685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28685__$1,(4),jobs);
} else {
if((state_val_28686 === (3))){
var inst_28683 = (state_28685[(2)]);
var state_28685__$1 = state_28685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28685__$1,inst_28683);
} else {
if((state_val_28686 === (4))){
var inst_28675 = (state_28685[(2)]);
var inst_28676 = async(inst_28675);
var state_28685__$1 = state_28685;
if(cljs.core.truth_(inst_28676)){
var statearr_28691_30800 = state_28685__$1;
(statearr_28691_30800[(1)] = (5));

} else {
var statearr_28692_30802 = state_28685__$1;
(statearr_28692_30802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28686 === (5))){
var state_28685__$1 = state_28685;
var statearr_28699_30804 = state_28685__$1;
(statearr_28699_30804[(2)] = null);

(statearr_28699_30804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28686 === (6))){
var state_28685__$1 = state_28685;
var statearr_28700_30806 = state_28685__$1;
(statearr_28700_30806[(2)] = null);

(statearr_28700_30806[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28686 === (7))){
var inst_28681 = (state_28685[(2)]);
var state_28685__$1 = state_28685;
var statearr_28701_30813 = state_28685__$1;
(statearr_28701_30813[(2)] = inst_28681);

(statearr_28701_30813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30699,c__28256__auto___30790,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async))
;
return ((function (__30699,switch__28147__auto__,c__28256__auto___30790,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0 = (function (){
var statearr_28703 = [null,null,null,null,null,null,null];
(statearr_28703[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__);

(statearr_28703[(1)] = (1));

return statearr_28703;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1 = (function (state_28685){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28685);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28704){var ex__28151__auto__ = e28704;
var statearr_28706_30821 = state_28685;
(statearr_28706_30821[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28685[(4)]))){
var statearr_28707_30823 = state_28685;
(statearr_28707_30823[(1)] = cljs.core.first((state_28685[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30825 = state_28685;
state_28685 = G__30825;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = function(state_28685){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1.call(this,state_28685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__;
})()
;})(__30699,switch__28147__auto__,c__28256__auto___30790,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async))
})();
var state__28258__auto__ = (function (){var statearr_28708 = f__28257__auto__();
(statearr_28708[(6)] = c__28256__auto___30790);

return statearr_28708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
});})(__30699,c__28256__auto___30790,G__28634_30700,G__28634_30701__$1,n__4613__auto___30698,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28634_30701__$1)].join('')));

}

var G__30830 = (__30699 + (1));
__30699 = G__30830;
continue;
} else {
}
break;
}

var c__28256__auto___30831 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28736){
var state_val_28737 = (state_28736[(1)]);
if((state_val_28737 === (7))){
var inst_28732 = (state_28736[(2)]);
var state_28736__$1 = state_28736;
var statearr_28741_30833 = state_28736__$1;
(statearr_28741_30833[(2)] = inst_28732);

(statearr_28741_30833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28737 === (1))){
var state_28736__$1 = state_28736;
var statearr_28742_30835 = state_28736__$1;
(statearr_28742_30835[(2)] = null);

(statearr_28742_30835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28737 === (4))){
var inst_28714 = (state_28736[(7)]);
var inst_28714__$1 = (state_28736[(2)]);
var inst_28715 = (inst_28714__$1 == null);
var state_28736__$1 = (function (){var statearr_28746 = state_28736;
(statearr_28746[(7)] = inst_28714__$1);

return statearr_28746;
})();
if(cljs.core.truth_(inst_28715)){
var statearr_28750_30839 = state_28736__$1;
(statearr_28750_30839[(1)] = (5));

} else {
var statearr_28751_30840 = state_28736__$1;
(statearr_28751_30840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28737 === (6))){
var inst_28714 = (state_28736[(7)]);
var inst_28722 = (state_28736[(8)]);
var inst_28722__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28724 = [inst_28714,inst_28722__$1];
var inst_28725 = (new cljs.core.PersistentVector(null,2,(5),inst_28723,inst_28724,null));
var state_28736__$1 = (function (){var statearr_28755 = state_28736;
(statearr_28755[(8)] = inst_28722__$1);

return statearr_28755;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28736__$1,(8),jobs,inst_28725);
} else {
if((state_val_28737 === (3))){
var inst_28734 = (state_28736[(2)]);
var state_28736__$1 = state_28736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28736__$1,inst_28734);
} else {
if((state_val_28737 === (2))){
var state_28736__$1 = state_28736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28736__$1,(4),from);
} else {
if((state_val_28737 === (9))){
var inst_28729 = (state_28736[(2)]);
var state_28736__$1 = (function (){var statearr_28759 = state_28736;
(statearr_28759[(9)] = inst_28729);

return statearr_28759;
})();
var statearr_28760_30847 = state_28736__$1;
(statearr_28760_30847[(2)] = null);

(statearr_28760_30847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28737 === (5))){
var inst_28717 = cljs.core.async.close_BANG_(jobs);
var state_28736__$1 = state_28736;
var statearr_28761_30850 = state_28736__$1;
(statearr_28761_30850[(2)] = inst_28717);

(statearr_28761_30850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28737 === (8))){
var inst_28722 = (state_28736[(8)]);
var inst_28727 = (state_28736[(2)]);
var state_28736__$1 = (function (){var statearr_28762 = state_28736;
(statearr_28762[(10)] = inst_28727);

return statearr_28762;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28736__$1,(9),results,inst_28722);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0 = (function (){
var statearr_28763 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28763[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__);

(statearr_28763[(1)] = (1));

return statearr_28763;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1 = (function (state_28736){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28736);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28764){var ex__28151__auto__ = e28764;
var statearr_28765_30858 = state_28736;
(statearr_28765_30858[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28736[(4)]))){
var statearr_28766_30860 = state_28736;
(statearr_28766_30860[(1)] = cljs.core.first((state_28736[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30862 = state_28736;
state_28736 = G__30862;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = function(state_28736){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1.call(this,state_28736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_28769 = f__28257__auto__();
(statearr_28769[(6)] = c__28256__auto___30831);

return statearr_28769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


var c__28256__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28807){
var state_val_28808 = (state_28807[(1)]);
if((state_val_28808 === (7))){
var inst_28803 = (state_28807[(2)]);
var state_28807__$1 = state_28807;
var statearr_28813_30870 = state_28807__$1;
(statearr_28813_30870[(2)] = inst_28803);

(statearr_28813_30870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (20))){
var state_28807__$1 = state_28807;
var statearr_28815_30873 = state_28807__$1;
(statearr_28815_30873[(2)] = null);

(statearr_28815_30873[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (1))){
var state_28807__$1 = state_28807;
var statearr_28816_30874 = state_28807__$1;
(statearr_28816_30874[(2)] = null);

(statearr_28816_30874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (4))){
var inst_28772 = (state_28807[(7)]);
var inst_28772__$1 = (state_28807[(2)]);
var inst_28773 = (inst_28772__$1 == null);
var state_28807__$1 = (function (){var statearr_28817 = state_28807;
(statearr_28817[(7)] = inst_28772__$1);

return statearr_28817;
})();
if(cljs.core.truth_(inst_28773)){
var statearr_28818_30875 = state_28807__$1;
(statearr_28818_30875[(1)] = (5));

} else {
var statearr_28819_30878 = state_28807__$1;
(statearr_28819_30878[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (15))){
var inst_28785 = (state_28807[(8)]);
var state_28807__$1 = state_28807;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28807__$1,(18),to,inst_28785);
} else {
if((state_val_28808 === (21))){
var inst_28798 = (state_28807[(2)]);
var state_28807__$1 = state_28807;
var statearr_28823_30879 = state_28807__$1;
(statearr_28823_30879[(2)] = inst_28798);

(statearr_28823_30879[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (13))){
var inst_28800 = (state_28807[(2)]);
var state_28807__$1 = (function (){var statearr_28824 = state_28807;
(statearr_28824[(9)] = inst_28800);

return statearr_28824;
})();
var statearr_28825_30881 = state_28807__$1;
(statearr_28825_30881[(2)] = null);

(statearr_28825_30881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (6))){
var inst_28772 = (state_28807[(7)]);
var state_28807__$1 = state_28807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28807__$1,(11),inst_28772);
} else {
if((state_val_28808 === (17))){
var inst_28793 = (state_28807[(2)]);
var state_28807__$1 = state_28807;
if(cljs.core.truth_(inst_28793)){
var statearr_28826_30888 = state_28807__$1;
(statearr_28826_30888[(1)] = (19));

} else {
var statearr_28827_30889 = state_28807__$1;
(statearr_28827_30889[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (3))){
var inst_28805 = (state_28807[(2)]);
var state_28807__$1 = state_28807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28807__$1,inst_28805);
} else {
if((state_val_28808 === (12))){
var inst_28782 = (state_28807[(10)]);
var state_28807__$1 = state_28807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28807__$1,(14),inst_28782);
} else {
if((state_val_28808 === (2))){
var state_28807__$1 = state_28807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28807__$1,(4),results);
} else {
if((state_val_28808 === (19))){
var state_28807__$1 = state_28807;
var statearr_28828_30891 = state_28807__$1;
(statearr_28828_30891[(2)] = null);

(statearr_28828_30891[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (11))){
var inst_28782 = (state_28807[(2)]);
var state_28807__$1 = (function (){var statearr_28829 = state_28807;
(statearr_28829[(10)] = inst_28782);

return statearr_28829;
})();
var statearr_28830_30892 = state_28807__$1;
(statearr_28830_30892[(2)] = null);

(statearr_28830_30892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (9))){
var state_28807__$1 = state_28807;
var statearr_28831_30895 = state_28807__$1;
(statearr_28831_30895[(2)] = null);

(statearr_28831_30895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (5))){
var state_28807__$1 = state_28807;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28832_30896 = state_28807__$1;
(statearr_28832_30896[(1)] = (8));

} else {
var statearr_28833_30897 = state_28807__$1;
(statearr_28833_30897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (14))){
var inst_28785 = (state_28807[(8)]);
var inst_28785__$1 = (state_28807[(2)]);
var inst_28786 = (inst_28785__$1 == null);
var inst_28787 = cljs.core.not(inst_28786);
var state_28807__$1 = (function (){var statearr_28834 = state_28807;
(statearr_28834[(8)] = inst_28785__$1);

return statearr_28834;
})();
if(inst_28787){
var statearr_28835_30902 = state_28807__$1;
(statearr_28835_30902[(1)] = (15));

} else {
var statearr_28836_30903 = state_28807__$1;
(statearr_28836_30903[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (16))){
var state_28807__$1 = state_28807;
var statearr_28837_30904 = state_28807__$1;
(statearr_28837_30904[(2)] = false);

(statearr_28837_30904[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (10))){
var inst_28779 = (state_28807[(2)]);
var state_28807__$1 = state_28807;
var statearr_28838_30907 = state_28807__$1;
(statearr_28838_30907[(2)] = inst_28779);

(statearr_28838_30907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (18))){
var inst_28790 = (state_28807[(2)]);
var state_28807__$1 = state_28807;
var statearr_28839_30909 = state_28807__$1;
(statearr_28839_30909[(2)] = inst_28790);

(statearr_28839_30909[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28808 === (8))){
var inst_28776 = cljs.core.async.close_BANG_(to);
var state_28807__$1 = state_28807;
var statearr_28840_30911 = state_28807__$1;
(statearr_28840_30911[(2)] = inst_28776);

(statearr_28840_30911[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0 = (function (){
var statearr_28841 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28841[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__);

(statearr_28841[(1)] = (1));

return statearr_28841;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1 = (function (state_28807){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28807);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28842){var ex__28151__auto__ = e28842;
var statearr_28846_30913 = state_28807;
(statearr_28846_30913[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28807[(4)]))){
var statearr_28847_30914 = state_28807;
(statearr_28847_30914[(1)] = cljs.core.first((state_28807[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30918 = state_28807;
state_28807 = G__30918;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__ = function(state_28807){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1.call(this,state_28807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28148__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_28848 = f__28257__auto__();
(statearr_28848[(6)] = c__28256__auto__);

return statearr_28848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

return c__28256__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28850 = arguments.length;
switch (G__28850) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28852 = arguments.length;
switch (G__28852) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28855 = arguments.length;
switch (G__28855) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28256__auto___30943 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28885){
var state_val_28887 = (state_28885[(1)]);
if((state_val_28887 === (7))){
var inst_28881 = (state_28885[(2)]);
var state_28885__$1 = state_28885;
var statearr_28891_30948 = state_28885__$1;
(statearr_28891_30948[(2)] = inst_28881);

(statearr_28891_30948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (1))){
var state_28885__$1 = state_28885;
var statearr_28892_30949 = state_28885__$1;
(statearr_28892_30949[(2)] = null);

(statearr_28892_30949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (4))){
var inst_28862 = (state_28885[(7)]);
var inst_28862__$1 = (state_28885[(2)]);
var inst_28863 = (inst_28862__$1 == null);
var state_28885__$1 = (function (){var statearr_28895 = state_28885;
(statearr_28895[(7)] = inst_28862__$1);

return statearr_28895;
})();
if(cljs.core.truth_(inst_28863)){
var statearr_28896_30955 = state_28885__$1;
(statearr_28896_30955[(1)] = (5));

} else {
var statearr_28898_30956 = state_28885__$1;
(statearr_28898_30956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (13))){
var state_28885__$1 = state_28885;
var statearr_28902_30959 = state_28885__$1;
(statearr_28902_30959[(2)] = null);

(statearr_28902_30959[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (6))){
var inst_28862 = (state_28885[(7)]);
var inst_28868 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28862) : p.call(null,inst_28862));
var state_28885__$1 = state_28885;
if(cljs.core.truth_(inst_28868)){
var statearr_28904_30961 = state_28885__$1;
(statearr_28904_30961[(1)] = (9));

} else {
var statearr_28905_30962 = state_28885__$1;
(statearr_28905_30962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (3))){
var inst_28883 = (state_28885[(2)]);
var state_28885__$1 = state_28885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28885__$1,inst_28883);
} else {
if((state_val_28887 === (12))){
var state_28885__$1 = state_28885;
var statearr_28910_30967 = state_28885__$1;
(statearr_28910_30967[(2)] = null);

(statearr_28910_30967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (2))){
var state_28885__$1 = state_28885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28885__$1,(4),ch);
} else {
if((state_val_28887 === (11))){
var inst_28862 = (state_28885[(7)]);
var inst_28872 = (state_28885[(2)]);
var state_28885__$1 = state_28885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28885__$1,(8),inst_28872,inst_28862);
} else {
if((state_val_28887 === (9))){
var state_28885__$1 = state_28885;
var statearr_28911_30970 = state_28885__$1;
(statearr_28911_30970[(2)] = tc);

(statearr_28911_30970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (5))){
var inst_28865 = cljs.core.async.close_BANG_(tc);
var inst_28866 = cljs.core.async.close_BANG_(fc);
var state_28885__$1 = (function (){var statearr_28914 = state_28885;
(statearr_28914[(8)] = inst_28865);

return statearr_28914;
})();
var statearr_28916_30974 = state_28885__$1;
(statearr_28916_30974[(2)] = inst_28866);

(statearr_28916_30974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (14))){
var inst_28879 = (state_28885[(2)]);
var state_28885__$1 = state_28885;
var statearr_28917_30980 = state_28885__$1;
(statearr_28917_30980[(2)] = inst_28879);

(statearr_28917_30980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (10))){
var state_28885__$1 = state_28885;
var statearr_28918_30982 = state_28885__$1;
(statearr_28918_30982[(2)] = fc);

(statearr_28918_30982[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28887 === (8))){
var inst_28874 = (state_28885[(2)]);
var state_28885__$1 = state_28885;
if(cljs.core.truth_(inst_28874)){
var statearr_28920_30989 = state_28885__$1;
(statearr_28920_30989[(1)] = (12));

} else {
var statearr_28922_30993 = state_28885__$1;
(statearr_28922_30993[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_28925 = [null,null,null,null,null,null,null,null,null];
(statearr_28925[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_28925[(1)] = (1));

return statearr_28925;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_28885){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28885);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28926){var ex__28151__auto__ = e28926;
var statearr_28927_30995 = state_28885;
(statearr_28927_30995[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28885[(4)]))){
var statearr_28928_30999 = state_28885;
(statearr_28928_30999[(1)] = cljs.core.first((state_28885[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31000 = state_28885;
state_28885 = G__31000;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_28885){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_28885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_28930 = f__28257__auto__();
(statearr_28930[(6)] = c__28256__auto___30943);

return statearr_28930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28256__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28952){
var state_val_28953 = (state_28952[(1)]);
if((state_val_28953 === (7))){
var inst_28948 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28956_31004 = state_28952__$1;
(statearr_28956_31004[(2)] = inst_28948);

(statearr_28956_31004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (1))){
var inst_28931 = init;
var inst_28932 = inst_28931;
var state_28952__$1 = (function (){var statearr_28957 = state_28952;
(statearr_28957[(7)] = inst_28932);

return statearr_28957;
})();
var statearr_28958_31008 = state_28952__$1;
(statearr_28958_31008[(2)] = null);

(statearr_28958_31008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (4))){
var inst_28935 = (state_28952[(8)]);
var inst_28935__$1 = (state_28952[(2)]);
var inst_28936 = (inst_28935__$1 == null);
var state_28952__$1 = (function (){var statearr_28960 = state_28952;
(statearr_28960[(8)] = inst_28935__$1);

return statearr_28960;
})();
if(cljs.core.truth_(inst_28936)){
var statearr_28961_31009 = state_28952__$1;
(statearr_28961_31009[(1)] = (5));

} else {
var statearr_28963_31010 = state_28952__$1;
(statearr_28963_31010[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (6))){
var inst_28932 = (state_28952[(7)]);
var inst_28939 = (state_28952[(9)]);
var inst_28935 = (state_28952[(8)]);
var inst_28939__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_28932,inst_28935) : f.call(null,inst_28932,inst_28935));
var inst_28940 = cljs.core.reduced_QMARK_(inst_28939__$1);
var state_28952__$1 = (function (){var statearr_28967 = state_28952;
(statearr_28967[(9)] = inst_28939__$1);

return statearr_28967;
})();
if(inst_28940){
var statearr_28968_31014 = state_28952__$1;
(statearr_28968_31014[(1)] = (8));

} else {
var statearr_28969_31016 = state_28952__$1;
(statearr_28969_31016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (3))){
var inst_28950 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28952__$1,inst_28950);
} else {
if((state_val_28953 === (2))){
var state_28952__$1 = state_28952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28952__$1,(4),ch);
} else {
if((state_val_28953 === (9))){
var inst_28939 = (state_28952[(9)]);
var inst_28932 = inst_28939;
var state_28952__$1 = (function (){var statearr_28970 = state_28952;
(statearr_28970[(7)] = inst_28932);

return statearr_28970;
})();
var statearr_28971_31018 = state_28952__$1;
(statearr_28971_31018[(2)] = null);

(statearr_28971_31018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (5))){
var inst_28932 = (state_28952[(7)]);
var state_28952__$1 = state_28952;
var statearr_28972_31020 = state_28952__$1;
(statearr_28972_31020[(2)] = inst_28932);

(statearr_28972_31020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (10))){
var inst_28946 = (state_28952[(2)]);
var state_28952__$1 = state_28952;
var statearr_28973_31022 = state_28952__$1;
(statearr_28973_31022[(2)] = inst_28946);

(statearr_28973_31022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28953 === (8))){
var inst_28939 = (state_28952[(9)]);
var inst_28942 = cljs.core.deref(inst_28939);
var state_28952__$1 = state_28952;
var statearr_28974_31024 = state_28952__$1;
(statearr_28974_31024[(2)] = inst_28942);

(statearr_28974_31024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28148__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28148__auto____0 = (function (){
var statearr_28976 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28976[(0)] = cljs$core$async$reduce_$_state_machine__28148__auto__);

(statearr_28976[(1)] = (1));

return statearr_28976;
});
var cljs$core$async$reduce_$_state_machine__28148__auto____1 = (function (state_28952){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28952);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e28979){var ex__28151__auto__ = e28979;
var statearr_28981_31029 = state_28952;
(statearr_28981_31029[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28952[(4)]))){
var statearr_28982_31030 = state_28952;
(statearr_28982_31030[(1)] = cljs.core.first((state_28952[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31031 = state_28952;
state_28952 = G__31031;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28148__auto__ = function(state_28952){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28148__auto____1.call(this,state_28952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28148__auto____0;
cljs$core$async$reduce_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28148__auto____1;
return cljs$core$async$reduce_$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_28983 = f__28257__auto__();
(statearr_28983[(6)] = c__28256__auto__);

return statearr_28983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

return c__28256__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28256__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_28996){
var state_val_28997 = (state_28996[(1)]);
if((state_val_28997 === (1))){
var inst_28985 = cljs.core.async.reduce(f__$1,init,ch);
var state_28996__$1 = state_28996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28996__$1,(2),inst_28985);
} else {
if((state_val_28997 === (2))){
var inst_28987 = (state_28996[(2)]);
var inst_28994 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_28987) : f__$1.call(null,inst_28987));
var state_28996__$1 = state_28996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28996__$1,inst_28994);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28148__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28148__auto____0 = (function (){
var statearr_29000 = [null,null,null,null,null,null,null];
(statearr_29000[(0)] = cljs$core$async$transduce_$_state_machine__28148__auto__);

(statearr_29000[(1)] = (1));

return statearr_29000;
});
var cljs$core$async$transduce_$_state_machine__28148__auto____1 = (function (state_28996){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_28996);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29002){var ex__28151__auto__ = e29002;
var statearr_29003_31035 = state_28996;
(statearr_29003_31035[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_28996[(4)]))){
var statearr_29004_31036 = state_28996;
(statearr_29004_31036[(1)] = cljs.core.first((state_28996[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31037 = state_28996;
state_28996 = G__31037;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28148__auto__ = function(state_28996){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28148__auto____1.call(this,state_28996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28148__auto____0;
cljs$core$async$transduce_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28148__auto____1;
return cljs$core$async$transduce_$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29011 = f__28257__auto__();
(statearr_29011[(6)] = c__28256__auto__);

return statearr_29011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

return c__28256__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__29013 = arguments.length;
switch (G__29013) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28256__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_29042){
var state_val_29043 = (state_29042[(1)]);
if((state_val_29043 === (7))){
var inst_29022 = (state_29042[(2)]);
var state_29042__$1 = state_29042;
var statearr_29044_31044 = state_29042__$1;
(statearr_29044_31044[(2)] = inst_29022);

(statearr_29044_31044[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (1))){
var inst_29015 = cljs.core.seq(coll);
var inst_29016 = inst_29015;
var state_29042__$1 = (function (){var statearr_29045 = state_29042;
(statearr_29045[(7)] = inst_29016);

return statearr_29045;
})();
var statearr_29046_31045 = state_29042__$1;
(statearr_29046_31045[(2)] = null);

(statearr_29046_31045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (4))){
var inst_29016 = (state_29042[(7)]);
var inst_29020 = cljs.core.first(inst_29016);
var state_29042__$1 = state_29042;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29042__$1,(7),ch,inst_29020);
} else {
if((state_val_29043 === (13))){
var inst_29036 = (state_29042[(2)]);
var state_29042__$1 = state_29042;
var statearr_29050_31049 = state_29042__$1;
(statearr_29050_31049[(2)] = inst_29036);

(statearr_29050_31049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (6))){
var inst_29026 = (state_29042[(2)]);
var state_29042__$1 = state_29042;
if(cljs.core.truth_(inst_29026)){
var statearr_29051_31050 = state_29042__$1;
(statearr_29051_31050[(1)] = (8));

} else {
var statearr_29052_31051 = state_29042__$1;
(statearr_29052_31051[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (3))){
var inst_29040 = (state_29042[(2)]);
var state_29042__$1 = state_29042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29042__$1,inst_29040);
} else {
if((state_val_29043 === (12))){
var state_29042__$1 = state_29042;
var statearr_29056_31052 = state_29042__$1;
(statearr_29056_31052[(2)] = null);

(statearr_29056_31052[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (2))){
var inst_29016 = (state_29042[(7)]);
var state_29042__$1 = state_29042;
if(cljs.core.truth_(inst_29016)){
var statearr_29058_31053 = state_29042__$1;
(statearr_29058_31053[(1)] = (4));

} else {
var statearr_29059_31055 = state_29042__$1;
(statearr_29059_31055[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (11))){
var inst_29033 = cljs.core.async.close_BANG_(ch);
var state_29042__$1 = state_29042;
var statearr_29063_31056 = state_29042__$1;
(statearr_29063_31056[(2)] = inst_29033);

(statearr_29063_31056[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (9))){
var state_29042__$1 = state_29042;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29065_31057 = state_29042__$1;
(statearr_29065_31057[(1)] = (11));

} else {
var statearr_29066_31063 = state_29042__$1;
(statearr_29066_31063[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (5))){
var inst_29016 = (state_29042[(7)]);
var state_29042__$1 = state_29042;
var statearr_29067_31064 = state_29042__$1;
(statearr_29067_31064[(2)] = inst_29016);

(statearr_29067_31064[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (10))){
var inst_29038 = (state_29042[(2)]);
var state_29042__$1 = state_29042;
var statearr_29068_31065 = state_29042__$1;
(statearr_29068_31065[(2)] = inst_29038);

(statearr_29068_31065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29043 === (8))){
var inst_29016 = (state_29042[(7)]);
var inst_29029 = cljs.core.next(inst_29016);
var inst_29016__$1 = inst_29029;
var state_29042__$1 = (function (){var statearr_29069 = state_29042;
(statearr_29069[(7)] = inst_29016__$1);

return statearr_29069;
})();
var statearr_29071_31066 = state_29042__$1;
(statearr_29071_31066[(2)] = null);

(statearr_29071_31066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_29075 = [null,null,null,null,null,null,null,null];
(statearr_29075[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_29075[(1)] = (1));

return statearr_29075;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_29042){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_29042);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29076){var ex__28151__auto__ = e29076;
var statearr_29077_31067 = state_29042;
(statearr_29077_31067[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_29042[(4)]))){
var statearr_29078_31068 = state_29042;
(statearr_29078_31068[(1)] = cljs.core.first((state_29042[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31069 = state_29042;
state_29042 = G__31069;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_29042){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_29042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29082 = f__28257__auto__();
(statearr_29082[(6)] = c__28256__auto__);

return statearr_29082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

return c__28256__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29087 = arguments.length;
switch (G__29087) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31079 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31079(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31090 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31090(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31093 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31093(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31094 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31094(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29112 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29112 = (function (ch,cs,meta29113){
this.ch = ch;
this.cs = cs;
this.meta29113 = meta29113;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29114,meta29113__$1){
var self__ = this;
var _29114__$1 = this;
return (new cljs.core.async.t_cljs$core$async29112(self__.ch,self__.cs,meta29113__$1));
}));

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29114){
var self__ = this;
var _29114__$1 = this;
return self__.meta29113;
}));

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29112.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29112.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29113","meta29113",1200459588,null)], null);
}));

(cljs.core.async.t_cljs$core$async29112.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29112.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29112");

(cljs.core.async.t_cljs$core$async29112.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29112");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29112.
 */
cljs.core.async.__GT_t_cljs$core$async29112 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29112(ch__$1,cs__$1,meta29113){
return (new cljs.core.async.t_cljs$core$async29112(ch__$1,cs__$1,meta29113));
});

}

return (new cljs.core.async.t_cljs$core$async29112(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28256__auto___31109 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_29263){
var state_val_29264 = (state_29263[(1)]);
if((state_val_29264 === (7))){
var inst_29258 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29265_31110 = state_29263__$1;
(statearr_29265_31110[(2)] = inst_29258);

(statearr_29265_31110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (20))){
var inst_29158 = (state_29263[(7)]);
var inst_29171 = cljs.core.first(inst_29158);
var inst_29172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29171,(0),null);
var inst_29173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29171,(1),null);
var state_29263__$1 = (function (){var statearr_29267 = state_29263;
(statearr_29267[(8)] = inst_29172);

return statearr_29267;
})();
if(cljs.core.truth_(inst_29173)){
var statearr_29268_31116 = state_29263__$1;
(statearr_29268_31116[(1)] = (22));

} else {
var statearr_29269_31117 = state_29263__$1;
(statearr_29269_31117[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (27))){
var inst_29201 = (state_29263[(9)]);
var inst_29203 = (state_29263[(10)]);
var inst_29126 = (state_29263[(11)]);
var inst_29208 = (state_29263[(12)]);
var inst_29208__$1 = cljs.core._nth(inst_29201,inst_29203);
var inst_29209 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29208__$1,inst_29126,done);
var state_29263__$1 = (function (){var statearr_29270 = state_29263;
(statearr_29270[(12)] = inst_29208__$1);

return statearr_29270;
})();
if(cljs.core.truth_(inst_29209)){
var statearr_29271_31122 = state_29263__$1;
(statearr_29271_31122[(1)] = (30));

} else {
var statearr_29272_31123 = state_29263__$1;
(statearr_29272_31123[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (1))){
var state_29263__$1 = state_29263;
var statearr_29273_31126 = state_29263__$1;
(statearr_29273_31126[(2)] = null);

(statearr_29273_31126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (24))){
var inst_29158 = (state_29263[(7)]);
var inst_29178 = (state_29263[(2)]);
var inst_29179 = cljs.core.next(inst_29158);
var inst_29135 = inst_29179;
var inst_29136 = null;
var inst_29137 = (0);
var inst_29138 = (0);
var state_29263__$1 = (function (){var statearr_29274 = state_29263;
(statearr_29274[(13)] = inst_29178);

(statearr_29274[(14)] = inst_29138);

(statearr_29274[(15)] = inst_29135);

(statearr_29274[(16)] = inst_29136);

(statearr_29274[(17)] = inst_29137);

return statearr_29274;
})();
var statearr_29277_31130 = state_29263__$1;
(statearr_29277_31130[(2)] = null);

(statearr_29277_31130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (39))){
var state_29263__$1 = state_29263;
var statearr_29283_31131 = state_29263__$1;
(statearr_29283_31131[(2)] = null);

(statearr_29283_31131[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (4))){
var inst_29126 = (state_29263[(11)]);
var inst_29126__$1 = (state_29263[(2)]);
var inst_29127 = (inst_29126__$1 == null);
var state_29263__$1 = (function (){var statearr_29285 = state_29263;
(statearr_29285[(11)] = inst_29126__$1);

return statearr_29285;
})();
if(cljs.core.truth_(inst_29127)){
var statearr_29286_31135 = state_29263__$1;
(statearr_29286_31135[(1)] = (5));

} else {
var statearr_29287_31137 = state_29263__$1;
(statearr_29287_31137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (15))){
var inst_29138 = (state_29263[(14)]);
var inst_29135 = (state_29263[(15)]);
var inst_29136 = (state_29263[(16)]);
var inst_29137 = (state_29263[(17)]);
var inst_29153 = (state_29263[(2)]);
var inst_29155 = (inst_29138 + (1));
var tmp29280 = inst_29135;
var tmp29281 = inst_29136;
var tmp29282 = inst_29137;
var inst_29135__$1 = tmp29280;
var inst_29136__$1 = tmp29281;
var inst_29137__$1 = tmp29282;
var inst_29138__$1 = inst_29155;
var state_29263__$1 = (function (){var statearr_29291 = state_29263;
(statearr_29291[(18)] = inst_29153);

(statearr_29291[(14)] = inst_29138__$1);

(statearr_29291[(15)] = inst_29135__$1);

(statearr_29291[(16)] = inst_29136__$1);

(statearr_29291[(17)] = inst_29137__$1);

return statearr_29291;
})();
var statearr_29292_31141 = state_29263__$1;
(statearr_29292_31141[(2)] = null);

(statearr_29292_31141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (21))){
var inst_29182 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29298_31144 = state_29263__$1;
(statearr_29298_31144[(2)] = inst_29182);

(statearr_29298_31144[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (31))){
var inst_29208 = (state_29263[(12)]);
var inst_29212 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29208);
var state_29263__$1 = state_29263;
var statearr_29299_31145 = state_29263__$1;
(statearr_29299_31145[(2)] = inst_29212);

(statearr_29299_31145[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (32))){
var inst_29202 = (state_29263[(19)]);
var inst_29201 = (state_29263[(9)]);
var inst_29203 = (state_29263[(10)]);
var inst_29200 = (state_29263[(20)]);
var inst_29214 = (state_29263[(2)]);
var inst_29215 = (inst_29203 + (1));
var tmp29293 = inst_29202;
var tmp29294 = inst_29201;
var tmp29295 = inst_29200;
var inst_29200__$1 = tmp29295;
var inst_29201__$1 = tmp29294;
var inst_29202__$1 = tmp29293;
var inst_29203__$1 = inst_29215;
var state_29263__$1 = (function (){var statearr_29304 = state_29263;
(statearr_29304[(19)] = inst_29202__$1);

(statearr_29304[(9)] = inst_29201__$1);

(statearr_29304[(10)] = inst_29203__$1);

(statearr_29304[(20)] = inst_29200__$1);

(statearr_29304[(21)] = inst_29214);

return statearr_29304;
})();
var statearr_29306_31149 = state_29263__$1;
(statearr_29306_31149[(2)] = null);

(statearr_29306_31149[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (40))){
var inst_29231 = (state_29263[(22)]);
var inst_29235 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29231);
var state_29263__$1 = state_29263;
var statearr_29307_31151 = state_29263__$1;
(statearr_29307_31151[(2)] = inst_29235);

(statearr_29307_31151[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (33))){
var inst_29218 = (state_29263[(23)]);
var inst_29220 = cljs.core.chunked_seq_QMARK_(inst_29218);
var state_29263__$1 = state_29263;
if(inst_29220){
var statearr_29308_31153 = state_29263__$1;
(statearr_29308_31153[(1)] = (36));

} else {
var statearr_29309_31154 = state_29263__$1;
(statearr_29309_31154[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (13))){
var inst_29147 = (state_29263[(24)]);
var inst_29150 = cljs.core.async.close_BANG_(inst_29147);
var state_29263__$1 = state_29263;
var statearr_29310_31156 = state_29263__$1;
(statearr_29310_31156[(2)] = inst_29150);

(statearr_29310_31156[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (22))){
var inst_29172 = (state_29263[(8)]);
var inst_29175 = cljs.core.async.close_BANG_(inst_29172);
var state_29263__$1 = state_29263;
var statearr_29311_31158 = state_29263__$1;
(statearr_29311_31158[(2)] = inst_29175);

(statearr_29311_31158[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (36))){
var inst_29218 = (state_29263[(23)]);
var inst_29223 = cljs.core.chunk_first(inst_29218);
var inst_29226 = cljs.core.chunk_rest(inst_29218);
var inst_29227 = cljs.core.count(inst_29223);
var inst_29200 = inst_29226;
var inst_29201 = inst_29223;
var inst_29202 = inst_29227;
var inst_29203 = (0);
var state_29263__$1 = (function (){var statearr_29312 = state_29263;
(statearr_29312[(19)] = inst_29202);

(statearr_29312[(9)] = inst_29201);

(statearr_29312[(10)] = inst_29203);

(statearr_29312[(20)] = inst_29200);

return statearr_29312;
})();
var statearr_29313_31163 = state_29263__$1;
(statearr_29313_31163[(2)] = null);

(statearr_29313_31163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (41))){
var inst_29218 = (state_29263[(23)]);
var inst_29237 = (state_29263[(2)]);
var inst_29238 = cljs.core.next(inst_29218);
var inst_29200 = inst_29238;
var inst_29201 = null;
var inst_29202 = (0);
var inst_29203 = (0);
var state_29263__$1 = (function (){var statearr_29314 = state_29263;
(statearr_29314[(19)] = inst_29202);

(statearr_29314[(9)] = inst_29201);

(statearr_29314[(10)] = inst_29203);

(statearr_29314[(20)] = inst_29200);

(statearr_29314[(25)] = inst_29237);

return statearr_29314;
})();
var statearr_29315_31164 = state_29263__$1;
(statearr_29315_31164[(2)] = null);

(statearr_29315_31164[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (43))){
var state_29263__$1 = state_29263;
var statearr_29316_31165 = state_29263__$1;
(statearr_29316_31165[(2)] = null);

(statearr_29316_31165[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (29))){
var inst_29246 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29317_31168 = state_29263__$1;
(statearr_29317_31168[(2)] = inst_29246);

(statearr_29317_31168[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (44))){
var inst_29255 = (state_29263[(2)]);
var state_29263__$1 = (function (){var statearr_29318 = state_29263;
(statearr_29318[(26)] = inst_29255);

return statearr_29318;
})();
var statearr_29319_31169 = state_29263__$1;
(statearr_29319_31169[(2)] = null);

(statearr_29319_31169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (6))){
var inst_29192 = (state_29263[(27)]);
var inst_29191 = cljs.core.deref(cs);
var inst_29192__$1 = cljs.core.keys(inst_29191);
var inst_29193 = cljs.core.count(inst_29192__$1);
var inst_29194 = cljs.core.reset_BANG_(dctr,inst_29193);
var inst_29199 = cljs.core.seq(inst_29192__$1);
var inst_29200 = inst_29199;
var inst_29201 = null;
var inst_29202 = (0);
var inst_29203 = (0);
var state_29263__$1 = (function (){var statearr_29320 = state_29263;
(statearr_29320[(19)] = inst_29202);

(statearr_29320[(9)] = inst_29201);

(statearr_29320[(28)] = inst_29194);

(statearr_29320[(10)] = inst_29203);

(statearr_29320[(27)] = inst_29192__$1);

(statearr_29320[(20)] = inst_29200);

return statearr_29320;
})();
var statearr_29321_31174 = state_29263__$1;
(statearr_29321_31174[(2)] = null);

(statearr_29321_31174[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (28))){
var inst_29218 = (state_29263[(23)]);
var inst_29200 = (state_29263[(20)]);
var inst_29218__$1 = cljs.core.seq(inst_29200);
var state_29263__$1 = (function (){var statearr_29322 = state_29263;
(statearr_29322[(23)] = inst_29218__$1);

return statearr_29322;
})();
if(inst_29218__$1){
var statearr_29323_31175 = state_29263__$1;
(statearr_29323_31175[(1)] = (33));

} else {
var statearr_29325_31176 = state_29263__$1;
(statearr_29325_31176[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (25))){
var inst_29202 = (state_29263[(19)]);
var inst_29203 = (state_29263[(10)]);
var inst_29205 = (inst_29203 < inst_29202);
var inst_29206 = inst_29205;
var state_29263__$1 = state_29263;
if(cljs.core.truth_(inst_29206)){
var statearr_29329_31179 = state_29263__$1;
(statearr_29329_31179[(1)] = (27));

} else {
var statearr_29331_31180 = state_29263__$1;
(statearr_29331_31180[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (34))){
var state_29263__$1 = state_29263;
var statearr_29332_31181 = state_29263__$1;
(statearr_29332_31181[(2)] = null);

(statearr_29332_31181[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (17))){
var state_29263__$1 = state_29263;
var statearr_29339_31182 = state_29263__$1;
(statearr_29339_31182[(2)] = null);

(statearr_29339_31182[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (3))){
var inst_29260 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29263__$1,inst_29260);
} else {
if((state_val_29264 === (12))){
var inst_29187 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29340_31188 = state_29263__$1;
(statearr_29340_31188[(2)] = inst_29187);

(statearr_29340_31188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (2))){
var state_29263__$1 = state_29263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29263__$1,(4),ch);
} else {
if((state_val_29264 === (23))){
var state_29263__$1 = state_29263;
var statearr_29341_31190 = state_29263__$1;
(statearr_29341_31190[(2)] = null);

(statearr_29341_31190[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (35))){
var inst_29244 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29342_31191 = state_29263__$1;
(statearr_29342_31191[(2)] = inst_29244);

(statearr_29342_31191[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (19))){
var inst_29158 = (state_29263[(7)]);
var inst_29163 = cljs.core.chunk_first(inst_29158);
var inst_29164 = cljs.core.chunk_rest(inst_29158);
var inst_29165 = cljs.core.count(inst_29163);
var inst_29135 = inst_29164;
var inst_29136 = inst_29163;
var inst_29137 = inst_29165;
var inst_29138 = (0);
var state_29263__$1 = (function (){var statearr_29343 = state_29263;
(statearr_29343[(14)] = inst_29138);

(statearr_29343[(15)] = inst_29135);

(statearr_29343[(16)] = inst_29136);

(statearr_29343[(17)] = inst_29137);

return statearr_29343;
})();
var statearr_29344_31192 = state_29263__$1;
(statearr_29344_31192[(2)] = null);

(statearr_29344_31192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (11))){
var inst_29158 = (state_29263[(7)]);
var inst_29135 = (state_29263[(15)]);
var inst_29158__$1 = cljs.core.seq(inst_29135);
var state_29263__$1 = (function (){var statearr_29345 = state_29263;
(statearr_29345[(7)] = inst_29158__$1);

return statearr_29345;
})();
if(inst_29158__$1){
var statearr_29346_31193 = state_29263__$1;
(statearr_29346_31193[(1)] = (16));

} else {
var statearr_29347_31194 = state_29263__$1;
(statearr_29347_31194[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (9))){
var inst_29189 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29348_31195 = state_29263__$1;
(statearr_29348_31195[(2)] = inst_29189);

(statearr_29348_31195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (5))){
var inst_29133 = cljs.core.deref(cs);
var inst_29134 = cljs.core.seq(inst_29133);
var inst_29135 = inst_29134;
var inst_29136 = null;
var inst_29137 = (0);
var inst_29138 = (0);
var state_29263__$1 = (function (){var statearr_29349 = state_29263;
(statearr_29349[(14)] = inst_29138);

(statearr_29349[(15)] = inst_29135);

(statearr_29349[(16)] = inst_29136);

(statearr_29349[(17)] = inst_29137);

return statearr_29349;
})();
var statearr_29350_31196 = state_29263__$1;
(statearr_29350_31196[(2)] = null);

(statearr_29350_31196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (14))){
var state_29263__$1 = state_29263;
var statearr_29351_31197 = state_29263__$1;
(statearr_29351_31197[(2)] = null);

(statearr_29351_31197[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (45))){
var inst_29252 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29353_31198 = state_29263__$1;
(statearr_29353_31198[(2)] = inst_29252);

(statearr_29353_31198[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (26))){
var inst_29192 = (state_29263[(27)]);
var inst_29248 = (state_29263[(2)]);
var inst_29249 = cljs.core.seq(inst_29192);
var state_29263__$1 = (function (){var statearr_29354 = state_29263;
(statearr_29354[(29)] = inst_29248);

return statearr_29354;
})();
if(inst_29249){
var statearr_29355_31215 = state_29263__$1;
(statearr_29355_31215[(1)] = (42));

} else {
var statearr_29356_31219 = state_29263__$1;
(statearr_29356_31219[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (16))){
var inst_29158 = (state_29263[(7)]);
var inst_29161 = cljs.core.chunked_seq_QMARK_(inst_29158);
var state_29263__$1 = state_29263;
if(inst_29161){
var statearr_29359_31236 = state_29263__$1;
(statearr_29359_31236[(1)] = (19));

} else {
var statearr_29360_31239 = state_29263__$1;
(statearr_29360_31239[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (38))){
var inst_29241 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29363_31247 = state_29263__$1;
(statearr_29363_31247[(2)] = inst_29241);

(statearr_29363_31247[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (30))){
var state_29263__$1 = state_29263;
var statearr_29365_31254 = state_29263__$1;
(statearr_29365_31254[(2)] = null);

(statearr_29365_31254[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (10))){
var inst_29138 = (state_29263[(14)]);
var inst_29136 = (state_29263[(16)]);
var inst_29146 = cljs.core._nth(inst_29136,inst_29138);
var inst_29147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29146,(0),null);
var inst_29148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29146,(1),null);
var state_29263__$1 = (function (){var statearr_29367 = state_29263;
(statearr_29367[(24)] = inst_29147);

return statearr_29367;
})();
if(cljs.core.truth_(inst_29148)){
var statearr_29368_31283 = state_29263__$1;
(statearr_29368_31283[(1)] = (13));

} else {
var statearr_29370_31285 = state_29263__$1;
(statearr_29370_31285[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (18))){
var inst_29185 = (state_29263[(2)]);
var state_29263__$1 = state_29263;
var statearr_29371_31286 = state_29263__$1;
(statearr_29371_31286[(2)] = inst_29185);

(statearr_29371_31286[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (42))){
var state_29263__$1 = state_29263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29263__$1,(45),dchan);
} else {
if((state_val_29264 === (37))){
var inst_29231 = (state_29263[(22)]);
var inst_29218 = (state_29263[(23)]);
var inst_29126 = (state_29263[(11)]);
var inst_29231__$1 = cljs.core.first(inst_29218);
var inst_29232 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29231__$1,inst_29126,done);
var state_29263__$1 = (function (){var statearr_29372 = state_29263;
(statearr_29372[(22)] = inst_29231__$1);

return statearr_29372;
})();
if(cljs.core.truth_(inst_29232)){
var statearr_29373_31289 = state_29263__$1;
(statearr_29373_31289[(1)] = (39));

} else {
var statearr_29374_31291 = state_29263__$1;
(statearr_29374_31291[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29264 === (8))){
var inst_29138 = (state_29263[(14)]);
var inst_29137 = (state_29263[(17)]);
var inst_29140 = (inst_29138 < inst_29137);
var inst_29141 = inst_29140;
var state_29263__$1 = state_29263;
if(cljs.core.truth_(inst_29141)){
var statearr_29378_31292 = state_29263__$1;
(statearr_29378_31292[(1)] = (10));

} else {
var statearr_29379_31296 = state_29263__$1;
(statearr_29379_31296[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28148__auto__ = null;
var cljs$core$async$mult_$_state_machine__28148__auto____0 = (function (){
var statearr_29380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29380[(0)] = cljs$core$async$mult_$_state_machine__28148__auto__);

(statearr_29380[(1)] = (1));

return statearr_29380;
});
var cljs$core$async$mult_$_state_machine__28148__auto____1 = (function (state_29263){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_29263);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29381){var ex__28151__auto__ = e29381;
var statearr_29382_31300 = state_29263;
(statearr_29382_31300[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_29263[(4)]))){
var statearr_29383_31301 = state_29263;
(statearr_29383_31301[(1)] = cljs.core.first((state_29263[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31303 = state_29263;
state_29263 = G__31303;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28148__auto__ = function(state_29263){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28148__auto____1.call(this,state_29263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28148__auto____0;
cljs$core$async$mult_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28148__auto____1;
return cljs$core$async$mult_$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29388 = f__28257__auto__();
(statearr_29388[(6)] = c__28256__auto___31109);

return statearr_29388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29394 = arguments.length;
switch (G__29394) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31311 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31311(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31318 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31318(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31322 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31322(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31327 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31327(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31333 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31333(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31339 = arguments.length;
var i__4737__auto___31340 = (0);
while(true){
if((i__4737__auto___31340 < len__4736__auto___31339)){
args__4742__auto__.push((arguments[i__4737__auto___31340]));

var G__31341 = (i__4737__auto___31340 + (1));
i__4737__auto___31340 = G__31341;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29410){
var map__29411 = p__29410;
var map__29411__$1 = (((((!((map__29411 == null))))?(((((map__29411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29411):map__29411);
var opts = map__29411__$1;
var statearr_29413_31344 = state;
(statearr_29413_31344[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29414_31346 = state;
(statearr_29414_31346[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_29415_31347 = state;
(statearr_29415_31347[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29406){
var G__29407 = cljs.core.first(seq29406);
var seq29406__$1 = cljs.core.next(seq29406);
var G__29408 = cljs.core.first(seq29406__$1);
var seq29406__$2 = cljs.core.next(seq29406__$1);
var G__29409 = cljs.core.first(seq29406__$2);
var seq29406__$3 = cljs.core.next(seq29406__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29407,G__29408,G__29409,seq29406__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29417 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29417 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29418){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29418 = meta29418;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29419,meta29418__$1){
var self__ = this;
var _29419__$1 = this;
return (new cljs.core.async.t_cljs$core$async29417(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29418__$1));
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29419){
var self__ = this;
var _29419__$1 = this;
return self__.meta29418;
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29417.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29417.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29418","meta29418",1724864198,null)], null);
}));

(cljs.core.async.t_cljs$core$async29417.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29417.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29417");

(cljs.core.async.t_cljs$core$async29417.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29417");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29417.
 */
cljs.core.async.__GT_t_cljs$core$async29417 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29417(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29418){
return (new cljs.core.async.t_cljs$core$async29417(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29418));
});

}

return (new cljs.core.async.t_cljs$core$async29417(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28256__auto___31385 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_29530){
var state_val_29531 = (state_29530[(1)]);
if((state_val_29531 === (7))){
var inst_29441 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29532_31395 = state_29530__$1;
(statearr_29532_31395[(2)] = inst_29441);

(statearr_29532_31395[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (20))){
var inst_29453 = (state_29530[(7)]);
var state_29530__$1 = state_29530;
var statearr_29533_31400 = state_29530__$1;
(statearr_29533_31400[(2)] = inst_29453);

(statearr_29533_31400[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (27))){
var state_29530__$1 = state_29530;
var statearr_29534_31404 = state_29530__$1;
(statearr_29534_31404[(2)] = null);

(statearr_29534_31404[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (1))){
var inst_29428 = (state_29530[(8)]);
var inst_29428__$1 = calc_state();
var inst_29430 = (inst_29428__$1 == null);
var inst_29431 = cljs.core.not(inst_29430);
var state_29530__$1 = (function (){var statearr_29538 = state_29530;
(statearr_29538[(8)] = inst_29428__$1);

return statearr_29538;
})();
if(inst_29431){
var statearr_29539_31417 = state_29530__$1;
(statearr_29539_31417[(1)] = (2));

} else {
var statearr_29540_31418 = state_29530__$1;
(statearr_29540_31418[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (24))){
var inst_29486 = (state_29530[(9)]);
var inst_29504 = (state_29530[(10)]);
var inst_29477 = (state_29530[(11)]);
var inst_29504__$1 = (inst_29477.cljs$core$IFn$_invoke$arity$1 ? inst_29477.cljs$core$IFn$_invoke$arity$1(inst_29486) : inst_29477.call(null,inst_29486));
var state_29530__$1 = (function (){var statearr_29541 = state_29530;
(statearr_29541[(10)] = inst_29504__$1);

return statearr_29541;
})();
if(cljs.core.truth_(inst_29504__$1)){
var statearr_29542_31420 = state_29530__$1;
(statearr_29542_31420[(1)] = (29));

} else {
var statearr_29543_31422 = state_29530__$1;
(statearr_29543_31422[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (4))){
var inst_29444 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29444)){
var statearr_29544_31429 = state_29530__$1;
(statearr_29544_31429[(1)] = (8));

} else {
var statearr_29545_31442 = state_29530__$1;
(statearr_29545_31442[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (15))){
var inst_29471 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29471)){
var statearr_29546_31455 = state_29530__$1;
(statearr_29546_31455[(1)] = (19));

} else {
var statearr_29547_31458 = state_29530__$1;
(statearr_29547_31458[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (21))){
var inst_29476 = (state_29530[(12)]);
var inst_29476__$1 = (state_29530[(2)]);
var inst_29477 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29476__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29476__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29476__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29530__$1 = (function (){var statearr_29551 = state_29530;
(statearr_29551[(11)] = inst_29477);

(statearr_29551[(12)] = inst_29476__$1);

(statearr_29551[(13)] = inst_29478);

return statearr_29551;
})();
return cljs.core.async.ioc_alts_BANG_(state_29530__$1,(22),inst_29479);
} else {
if((state_val_29531 === (31))){
var inst_29512 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29512)){
var statearr_29552_31493 = state_29530__$1;
(statearr_29552_31493[(1)] = (32));

} else {
var statearr_29553_31494 = state_29530__$1;
(statearr_29553_31494[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (32))){
var inst_29485 = (state_29530[(14)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29530__$1,(35),out,inst_29485);
} else {
if((state_val_29531 === (33))){
var inst_29476 = (state_29530[(12)]);
var inst_29453 = inst_29476;
var state_29530__$1 = (function (){var statearr_29554 = state_29530;
(statearr_29554[(7)] = inst_29453);

return statearr_29554;
})();
var statearr_29555_31499 = state_29530__$1;
(statearr_29555_31499[(2)] = null);

(statearr_29555_31499[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (13))){
var inst_29453 = (state_29530[(7)]);
var inst_29460 = inst_29453.cljs$lang$protocol_mask$partition0$;
var inst_29461 = (inst_29460 & (64));
var inst_29462 = inst_29453.cljs$core$ISeq$;
var inst_29463 = (cljs.core.PROTOCOL_SENTINEL === inst_29462);
var inst_29464 = ((inst_29461) || (inst_29463));
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29464)){
var statearr_29556_31502 = state_29530__$1;
(statearr_29556_31502[(1)] = (16));

} else {
var statearr_29557_31503 = state_29530__$1;
(statearr_29557_31503[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (22))){
var inst_29486 = (state_29530[(9)]);
var inst_29485 = (state_29530[(14)]);
var inst_29484 = (state_29530[(2)]);
var inst_29485__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29484,(0),null);
var inst_29486__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29484,(1),null);
var inst_29488 = (inst_29485__$1 == null);
var inst_29489 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29486__$1,change);
var inst_29490 = ((inst_29488) || (inst_29489));
var state_29530__$1 = (function (){var statearr_29561 = state_29530;
(statearr_29561[(9)] = inst_29486__$1);

(statearr_29561[(14)] = inst_29485__$1);

return statearr_29561;
})();
if(cljs.core.truth_(inst_29490)){
var statearr_29562_31509 = state_29530__$1;
(statearr_29562_31509[(1)] = (23));

} else {
var statearr_29563_31510 = state_29530__$1;
(statearr_29563_31510[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (36))){
var inst_29476 = (state_29530[(12)]);
var inst_29453 = inst_29476;
var state_29530__$1 = (function (){var statearr_29564 = state_29530;
(statearr_29564[(7)] = inst_29453);

return statearr_29564;
})();
var statearr_29568_31516 = state_29530__$1;
(statearr_29568_31516[(2)] = null);

(statearr_29568_31516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (29))){
var inst_29504 = (state_29530[(10)]);
var state_29530__$1 = state_29530;
var statearr_29575_31517 = state_29530__$1;
(statearr_29575_31517[(2)] = inst_29504);

(statearr_29575_31517[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (6))){
var state_29530__$1 = state_29530;
var statearr_29576_31520 = state_29530__$1;
(statearr_29576_31520[(2)] = false);

(statearr_29576_31520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (28))){
var inst_29500 = (state_29530[(2)]);
var inst_29501 = calc_state();
var inst_29453 = inst_29501;
var state_29530__$1 = (function (){var statearr_29577 = state_29530;
(statearr_29577[(15)] = inst_29500);

(statearr_29577[(7)] = inst_29453);

return statearr_29577;
})();
var statearr_29578_31525 = state_29530__$1;
(statearr_29578_31525[(2)] = null);

(statearr_29578_31525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (25))){
var inst_29526 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29579_31528 = state_29530__$1;
(statearr_29579_31528[(2)] = inst_29526);

(statearr_29579_31528[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (34))){
var inst_29524 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29580_31530 = state_29530__$1;
(statearr_29580_31530[(2)] = inst_29524);

(statearr_29580_31530[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (17))){
var state_29530__$1 = state_29530;
var statearr_29590_31532 = state_29530__$1;
(statearr_29590_31532[(2)] = false);

(statearr_29590_31532[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (3))){
var state_29530__$1 = state_29530;
var statearr_29591_31534 = state_29530__$1;
(statearr_29591_31534[(2)] = false);

(statearr_29591_31534[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (12))){
var inst_29528 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29530__$1,inst_29528);
} else {
if((state_val_29531 === (2))){
var inst_29428 = (state_29530[(8)]);
var inst_29433 = inst_29428.cljs$lang$protocol_mask$partition0$;
var inst_29434 = (inst_29433 & (64));
var inst_29435 = inst_29428.cljs$core$ISeq$;
var inst_29436 = (cljs.core.PROTOCOL_SENTINEL === inst_29435);
var inst_29437 = ((inst_29434) || (inst_29436));
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29437)){
var statearr_29592_31541 = state_29530__$1;
(statearr_29592_31541[(1)] = (5));

} else {
var statearr_29593_31544 = state_29530__$1;
(statearr_29593_31544[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (23))){
var inst_29485 = (state_29530[(14)]);
var inst_29495 = (inst_29485 == null);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29495)){
var statearr_29594_31547 = state_29530__$1;
(statearr_29594_31547[(1)] = (26));

} else {
var statearr_29595_31549 = state_29530__$1;
(statearr_29595_31549[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (35))){
var inst_29515 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29515)){
var statearr_29596_31551 = state_29530__$1;
(statearr_29596_31551[(1)] = (36));

} else {
var statearr_29597_31552 = state_29530__$1;
(statearr_29597_31552[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (19))){
var inst_29453 = (state_29530[(7)]);
var inst_29473 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29453);
var state_29530__$1 = state_29530;
var statearr_29598_31557 = state_29530__$1;
(statearr_29598_31557[(2)] = inst_29473);

(statearr_29598_31557[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (11))){
var inst_29453 = (state_29530[(7)]);
var inst_29457 = (inst_29453 == null);
var inst_29458 = cljs.core.not(inst_29457);
var state_29530__$1 = state_29530;
if(inst_29458){
var statearr_29602_31560 = state_29530__$1;
(statearr_29602_31560[(1)] = (13));

} else {
var statearr_29603_31562 = state_29530__$1;
(statearr_29603_31562[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (9))){
var inst_29428 = (state_29530[(8)]);
var state_29530__$1 = state_29530;
var statearr_29604_31564 = state_29530__$1;
(statearr_29604_31564[(2)] = inst_29428);

(statearr_29604_31564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (5))){
var state_29530__$1 = state_29530;
var statearr_29605_31567 = state_29530__$1;
(statearr_29605_31567[(2)] = true);

(statearr_29605_31567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (14))){
var state_29530__$1 = state_29530;
var statearr_29606_31570 = state_29530__$1;
(statearr_29606_31570[(2)] = false);

(statearr_29606_31570[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (26))){
var inst_29486 = (state_29530[(9)]);
var inst_29497 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29486);
var state_29530__$1 = state_29530;
var statearr_29607_31573 = state_29530__$1;
(statearr_29607_31573[(2)] = inst_29497);

(statearr_29607_31573[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (16))){
var state_29530__$1 = state_29530;
var statearr_29608_31574 = state_29530__$1;
(statearr_29608_31574[(2)] = true);

(statearr_29608_31574[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (38))){
var inst_29520 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29609_31576 = state_29530__$1;
(statearr_29609_31576[(2)] = inst_29520);

(statearr_29609_31576[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (30))){
var inst_29486 = (state_29530[(9)]);
var inst_29477 = (state_29530[(11)]);
var inst_29478 = (state_29530[(13)]);
var inst_29507 = cljs.core.empty_QMARK_(inst_29477);
var inst_29508 = (inst_29478.cljs$core$IFn$_invoke$arity$1 ? inst_29478.cljs$core$IFn$_invoke$arity$1(inst_29486) : inst_29478.call(null,inst_29486));
var inst_29509 = cljs.core.not(inst_29508);
var inst_29510 = ((inst_29507) && (inst_29509));
var state_29530__$1 = state_29530;
var statearr_29613_31579 = state_29530__$1;
(statearr_29613_31579[(2)] = inst_29510);

(statearr_29613_31579[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (10))){
var inst_29428 = (state_29530[(8)]);
var inst_29449 = (state_29530[(2)]);
var inst_29450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29449,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29451 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29449,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29449,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29453 = inst_29428;
var state_29530__$1 = (function (){var statearr_29614 = state_29530;
(statearr_29614[(7)] = inst_29453);

(statearr_29614[(16)] = inst_29450);

(statearr_29614[(17)] = inst_29451);

(statearr_29614[(18)] = inst_29452);

return statearr_29614;
})();
var statearr_29615_31583 = state_29530__$1;
(statearr_29615_31583[(2)] = null);

(statearr_29615_31583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (18))){
var inst_29468 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29616_31585 = state_29530__$1;
(statearr_29616_31585[(2)] = inst_29468);

(statearr_29616_31585[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (37))){
var state_29530__$1 = state_29530;
var statearr_29617_31587 = state_29530__$1;
(statearr_29617_31587[(2)] = null);

(statearr_29617_31587[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (8))){
var inst_29428 = (state_29530[(8)]);
var inst_29446 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29428);
var state_29530__$1 = state_29530;
var statearr_29618_31588 = state_29530__$1;
(statearr_29618_31588[(2)] = inst_29446);

(statearr_29618_31588[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28148__auto__ = null;
var cljs$core$async$mix_$_state_machine__28148__auto____0 = (function (){
var statearr_29622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29622[(0)] = cljs$core$async$mix_$_state_machine__28148__auto__);

(statearr_29622[(1)] = (1));

return statearr_29622;
});
var cljs$core$async$mix_$_state_machine__28148__auto____1 = (function (state_29530){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_29530);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29623){var ex__28151__auto__ = e29623;
var statearr_29624_31591 = state_29530;
(statearr_29624_31591[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_29530[(4)]))){
var statearr_29625_31595 = state_29530;
(statearr_29625_31595[(1)] = cljs.core.first((state_29530[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31596 = state_29530;
state_29530 = G__31596;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28148__auto__ = function(state_29530){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28148__auto____1.call(this,state_29530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28148__auto____0;
cljs$core$async$mix_$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28148__auto____1;
return cljs$core$async$mix_$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29626 = f__28257__auto__();
(statearr_29626[(6)] = c__28256__auto___31385);

return statearr_29626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_31599 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_31599(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_31605 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_31605(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_31608 = (function() {
var G__31609 = null;
var G__31609__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__31609__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__31609 = function(p,v){
switch(arguments.length){
case 1:
return G__31609__1.call(this,p);
case 2:
return G__31609__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31609.cljs$core$IFn$_invoke$arity$1 = G__31609__1;
G__31609.cljs$core$IFn$_invoke$arity$2 = G__31609__2;
return G__31609;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29647 = arguments.length;
switch (G__29647) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31608(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31608(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29650 = arguments.length;
switch (G__29650) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29648_SHARP_){
if(cljs.core.truth_((p1__29648_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29648_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29648_SHARP_.call(null,topic)))){
return p1__29648_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29648_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29651 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29651 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29652){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29652 = meta29652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29653,meta29652__$1){
var self__ = this;
var _29653__$1 = this;
return (new cljs.core.async.t_cljs$core$async29651(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29652__$1));
}));

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29653){
var self__ = this;
var _29653__$1 = this;
return self__.meta29652;
}));

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29651.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29652","meta29652",2001279738,null)], null);
}));

(cljs.core.async.t_cljs$core$async29651.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29651");

(cljs.core.async.t_cljs$core$async29651.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29651");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29651.
 */
cljs.core.async.__GT_t_cljs$core$async29651 = (function cljs$core$async$__GT_t_cljs$core$async29651(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29652){
return (new cljs.core.async.t_cljs$core$async29651(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29652));
});

}

return (new cljs.core.async.t_cljs$core$async29651(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28256__auto___31625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_29734){
var state_val_29738 = (state_29734[(1)]);
if((state_val_29738 === (7))){
var inst_29729 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
var statearr_29739_31626 = state_29734__$1;
(statearr_29739_31626[(2)] = inst_29729);

(statearr_29739_31626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (20))){
var state_29734__$1 = state_29734;
var statearr_29740_31627 = state_29734__$1;
(statearr_29740_31627[(2)] = null);

(statearr_29740_31627[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (1))){
var state_29734__$1 = state_29734;
var statearr_29741_31632 = state_29734__$1;
(statearr_29741_31632[(2)] = null);

(statearr_29741_31632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (24))){
var inst_29712 = (state_29734[(7)]);
var inst_29721 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29712);
var state_29734__$1 = state_29734;
var statearr_29742_31633 = state_29734__$1;
(statearr_29742_31633[(2)] = inst_29721);

(statearr_29742_31633[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (4))){
var inst_29662 = (state_29734[(8)]);
var inst_29662__$1 = (state_29734[(2)]);
var inst_29664 = (inst_29662__$1 == null);
var state_29734__$1 = (function (){var statearr_29743 = state_29734;
(statearr_29743[(8)] = inst_29662__$1);

return statearr_29743;
})();
if(cljs.core.truth_(inst_29664)){
var statearr_29744_31635 = state_29734__$1;
(statearr_29744_31635[(1)] = (5));

} else {
var statearr_29745_31636 = state_29734__$1;
(statearr_29745_31636[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (15))){
var inst_29706 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
var statearr_29746_31637 = state_29734__$1;
(statearr_29746_31637[(2)] = inst_29706);

(statearr_29746_31637[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (21))){
var inst_29726 = (state_29734[(2)]);
var state_29734__$1 = (function (){var statearr_29747 = state_29734;
(statearr_29747[(9)] = inst_29726);

return statearr_29747;
})();
var statearr_29748_31638 = state_29734__$1;
(statearr_29748_31638[(2)] = null);

(statearr_29748_31638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (13))){
var inst_29687 = (state_29734[(10)]);
var inst_29689 = cljs.core.chunked_seq_QMARK_(inst_29687);
var state_29734__$1 = state_29734;
if(inst_29689){
var statearr_29749_31639 = state_29734__$1;
(statearr_29749_31639[(1)] = (16));

} else {
var statearr_29750_31640 = state_29734__$1;
(statearr_29750_31640[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (22))){
var inst_29718 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
if(cljs.core.truth_(inst_29718)){
var statearr_29751_31648 = state_29734__$1;
(statearr_29751_31648[(1)] = (23));

} else {
var statearr_29752_31649 = state_29734__$1;
(statearr_29752_31649[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (6))){
var inst_29714 = (state_29734[(11)]);
var inst_29712 = (state_29734[(7)]);
var inst_29662 = (state_29734[(8)]);
var inst_29712__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29662) : topic_fn.call(null,inst_29662));
var inst_29713 = cljs.core.deref(mults);
var inst_29714__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29713,inst_29712__$1);
var state_29734__$1 = (function (){var statearr_29753 = state_29734;
(statearr_29753[(11)] = inst_29714__$1);

(statearr_29753[(7)] = inst_29712__$1);

return statearr_29753;
})();
if(cljs.core.truth_(inst_29714__$1)){
var statearr_29757_31657 = state_29734__$1;
(statearr_29757_31657[(1)] = (19));

} else {
var statearr_29758_31658 = state_29734__$1;
(statearr_29758_31658[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (25))){
var inst_29723 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
var statearr_29759_31659 = state_29734__$1;
(statearr_29759_31659[(2)] = inst_29723);

(statearr_29759_31659[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (17))){
var inst_29687 = (state_29734[(10)]);
var inst_29696 = cljs.core.first(inst_29687);
var inst_29698 = cljs.core.async.muxch_STAR_(inst_29696);
var inst_29699 = cljs.core.async.close_BANG_(inst_29698);
var inst_29700 = cljs.core.next(inst_29687);
var inst_29673 = inst_29700;
var inst_29674 = null;
var inst_29675 = (0);
var inst_29676 = (0);
var state_29734__$1 = (function (){var statearr_29760 = state_29734;
(statearr_29760[(12)] = inst_29676);

(statearr_29760[(13)] = inst_29675);

(statearr_29760[(14)] = inst_29674);

(statearr_29760[(15)] = inst_29699);

(statearr_29760[(16)] = inst_29673);

return statearr_29760;
})();
var statearr_29761_31669 = state_29734__$1;
(statearr_29761_31669[(2)] = null);

(statearr_29761_31669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (3))){
var inst_29731 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29734__$1,inst_29731);
} else {
if((state_val_29738 === (12))){
var inst_29708 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
var statearr_29762_31684 = state_29734__$1;
(statearr_29762_31684[(2)] = inst_29708);

(statearr_29762_31684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (2))){
var state_29734__$1 = state_29734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29734__$1,(4),ch);
} else {
if((state_val_29738 === (23))){
var state_29734__$1 = state_29734;
var statearr_29763_31687 = state_29734__$1;
(statearr_29763_31687[(2)] = null);

(statearr_29763_31687[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (19))){
var inst_29714 = (state_29734[(11)]);
var inst_29662 = (state_29734[(8)]);
var inst_29716 = cljs.core.async.muxch_STAR_(inst_29714);
var state_29734__$1 = state_29734;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29734__$1,(22),inst_29716,inst_29662);
} else {
if((state_val_29738 === (11))){
var inst_29687 = (state_29734[(10)]);
var inst_29673 = (state_29734[(16)]);
var inst_29687__$1 = cljs.core.seq(inst_29673);
var state_29734__$1 = (function (){var statearr_29765 = state_29734;
(statearr_29765[(10)] = inst_29687__$1);

return statearr_29765;
})();
if(inst_29687__$1){
var statearr_29766_31689 = state_29734__$1;
(statearr_29766_31689[(1)] = (13));

} else {
var statearr_29767_31690 = state_29734__$1;
(statearr_29767_31690[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (9))){
var inst_29710 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
var statearr_29768_31696 = state_29734__$1;
(statearr_29768_31696[(2)] = inst_29710);

(statearr_29768_31696[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (5))){
var inst_29670 = cljs.core.deref(mults);
var inst_29671 = cljs.core.vals(inst_29670);
var inst_29672 = cljs.core.seq(inst_29671);
var inst_29673 = inst_29672;
var inst_29674 = null;
var inst_29675 = (0);
var inst_29676 = (0);
var state_29734__$1 = (function (){var statearr_29769 = state_29734;
(statearr_29769[(12)] = inst_29676);

(statearr_29769[(13)] = inst_29675);

(statearr_29769[(14)] = inst_29674);

(statearr_29769[(16)] = inst_29673);

return statearr_29769;
})();
var statearr_29770_31705 = state_29734__$1;
(statearr_29770_31705[(2)] = null);

(statearr_29770_31705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (14))){
var state_29734__$1 = state_29734;
var statearr_29774_31713 = state_29734__$1;
(statearr_29774_31713[(2)] = null);

(statearr_29774_31713[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (16))){
var inst_29687 = (state_29734[(10)]);
var inst_29691 = cljs.core.chunk_first(inst_29687);
var inst_29692 = cljs.core.chunk_rest(inst_29687);
var inst_29693 = cljs.core.count(inst_29691);
var inst_29673 = inst_29692;
var inst_29674 = inst_29691;
var inst_29675 = inst_29693;
var inst_29676 = (0);
var state_29734__$1 = (function (){var statearr_29775 = state_29734;
(statearr_29775[(12)] = inst_29676);

(statearr_29775[(13)] = inst_29675);

(statearr_29775[(14)] = inst_29674);

(statearr_29775[(16)] = inst_29673);

return statearr_29775;
})();
var statearr_29776_31718 = state_29734__$1;
(statearr_29776_31718[(2)] = null);

(statearr_29776_31718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (10))){
var inst_29676 = (state_29734[(12)]);
var inst_29675 = (state_29734[(13)]);
var inst_29674 = (state_29734[(14)]);
var inst_29673 = (state_29734[(16)]);
var inst_29681 = cljs.core._nth(inst_29674,inst_29676);
var inst_29682 = cljs.core.async.muxch_STAR_(inst_29681);
var inst_29683 = cljs.core.async.close_BANG_(inst_29682);
var inst_29684 = (inst_29676 + (1));
var tmp29771 = inst_29675;
var tmp29772 = inst_29674;
var tmp29773 = inst_29673;
var inst_29673__$1 = tmp29773;
var inst_29674__$1 = tmp29772;
var inst_29675__$1 = tmp29771;
var inst_29676__$1 = inst_29684;
var state_29734__$1 = (function (){var statearr_29777 = state_29734;
(statearr_29777[(12)] = inst_29676__$1);

(statearr_29777[(13)] = inst_29675__$1);

(statearr_29777[(17)] = inst_29683);

(statearr_29777[(14)] = inst_29674__$1);

(statearr_29777[(16)] = inst_29673__$1);

return statearr_29777;
})();
var statearr_29778_31721 = state_29734__$1;
(statearr_29778_31721[(2)] = null);

(statearr_29778_31721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (18))){
var inst_29703 = (state_29734[(2)]);
var state_29734__$1 = state_29734;
var statearr_29779_31724 = state_29734__$1;
(statearr_29779_31724[(2)] = inst_29703);

(statearr_29779_31724[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29738 === (8))){
var inst_29676 = (state_29734[(12)]);
var inst_29675 = (state_29734[(13)]);
var inst_29678 = (inst_29676 < inst_29675);
var inst_29679 = inst_29678;
var state_29734__$1 = state_29734;
if(cljs.core.truth_(inst_29679)){
var statearr_29780_31728 = state_29734__$1;
(statearr_29780_31728[(1)] = (10));

} else {
var statearr_29781_31729 = state_29734__$1;
(statearr_29781_31729[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_29782 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29782[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_29782[(1)] = (1));

return statearr_29782;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_29734){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_29734);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29783){var ex__28151__auto__ = e29783;
var statearr_29785_31732 = state_29734;
(statearr_29785_31732[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_29734[(4)]))){
var statearr_29786_31735 = state_29734;
(statearr_29786_31735[(1)] = cljs.core.first((state_29734[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31738 = state_29734;
state_29734 = G__31738;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_29734){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_29734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29791 = f__28257__auto__();
(statearr_29791[(6)] = c__28256__auto___31625);

return statearr_29791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29795 = arguments.length;
switch (G__29795) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29800 = arguments.length;
switch (G__29800) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29802 = arguments.length;
switch (G__29802) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28256__auto___31755 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_29848){
var state_val_29849 = (state_29848[(1)]);
if((state_val_29849 === (7))){
var state_29848__$1 = state_29848;
var statearr_29853_31757 = state_29848__$1;
(statearr_29853_31757[(2)] = null);

(statearr_29853_31757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (1))){
var state_29848__$1 = state_29848;
var statearr_29854_31759 = state_29848__$1;
(statearr_29854_31759[(2)] = null);

(statearr_29854_31759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (4))){
var inst_29805 = (state_29848[(7)]);
var inst_29806 = (state_29848[(8)]);
var inst_29808 = (inst_29806 < inst_29805);
var state_29848__$1 = state_29848;
if(cljs.core.truth_(inst_29808)){
var statearr_29855_31761 = state_29848__$1;
(statearr_29855_31761[(1)] = (6));

} else {
var statearr_29856_31763 = state_29848__$1;
(statearr_29856_31763[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (15))){
var inst_29831 = (state_29848[(9)]);
var inst_29839 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29831);
var state_29848__$1 = state_29848;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29848__$1,(17),out,inst_29839);
} else {
if((state_val_29849 === (13))){
var inst_29831 = (state_29848[(9)]);
var inst_29831__$1 = (state_29848[(2)]);
var inst_29835 = cljs.core.some(cljs.core.nil_QMARK_,inst_29831__$1);
var state_29848__$1 = (function (){var statearr_29857 = state_29848;
(statearr_29857[(9)] = inst_29831__$1);

return statearr_29857;
})();
if(cljs.core.truth_(inst_29835)){
var statearr_29858_31767 = state_29848__$1;
(statearr_29858_31767[(1)] = (14));

} else {
var statearr_29859_31768 = state_29848__$1;
(statearr_29859_31768[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (6))){
var state_29848__$1 = state_29848;
var statearr_29862_31769 = state_29848__$1;
(statearr_29862_31769[(2)] = null);

(statearr_29862_31769[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (17))){
var inst_29841 = (state_29848[(2)]);
var state_29848__$1 = (function (){var statearr_29878 = state_29848;
(statearr_29878[(10)] = inst_29841);

return statearr_29878;
})();
var statearr_29879_31770 = state_29848__$1;
(statearr_29879_31770[(2)] = null);

(statearr_29879_31770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (3))){
var inst_29846 = (state_29848[(2)]);
var state_29848__$1 = state_29848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29848__$1,inst_29846);
} else {
if((state_val_29849 === (12))){
var _ = (function (){var statearr_29880 = state_29848;
(statearr_29880[(4)] = cljs.core.rest((state_29848[(4)])));

return statearr_29880;
})();
var state_29848__$1 = state_29848;
var ex29876 = (state_29848__$1[(2)]);
var statearr_29881_31774 = state_29848__$1;
(statearr_29881_31774[(5)] = ex29876);


if((ex29876 instanceof Object)){
var statearr_29885_31775 = state_29848__$1;
(statearr_29885_31775[(1)] = (11));

(statearr_29885_31775[(5)] = null);

} else {
throw ex29876;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (2))){
var inst_29804 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29805 = cnt;
var inst_29806 = (0);
var state_29848__$1 = (function (){var statearr_29892 = state_29848;
(statearr_29892[(7)] = inst_29805);

(statearr_29892[(8)] = inst_29806);

(statearr_29892[(11)] = inst_29804);

return statearr_29892;
})();
var statearr_29893_31777 = state_29848__$1;
(statearr_29893_31777[(2)] = null);

(statearr_29893_31777[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (11))){
var inst_29810 = (state_29848[(2)]);
var inst_29811 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29848__$1 = (function (){var statearr_29894 = state_29848;
(statearr_29894[(12)] = inst_29810);

return statearr_29894;
})();
var statearr_29895_31780 = state_29848__$1;
(statearr_29895_31780[(2)] = inst_29811);

(statearr_29895_31780[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (9))){
var inst_29806 = (state_29848[(8)]);
var _ = (function (){var statearr_29896 = state_29848;
(statearr_29896[(4)] = cljs.core.cons((12),(state_29848[(4)])));

return statearr_29896;
})();
var inst_29817 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29806) : chs__$1.call(null,inst_29806));
var inst_29818 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29806) : done.call(null,inst_29806));
var inst_29819 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29817,inst_29818);
var ___$1 = (function (){var statearr_29898 = state_29848;
(statearr_29898[(4)] = cljs.core.rest((state_29848[(4)])));

return statearr_29898;
})();
var state_29848__$1 = state_29848;
var statearr_29899_31784 = state_29848__$1;
(statearr_29899_31784[(2)] = inst_29819);

(statearr_29899_31784[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (5))){
var inst_29829 = (state_29848[(2)]);
var state_29848__$1 = (function (){var statearr_29900 = state_29848;
(statearr_29900[(13)] = inst_29829);

return statearr_29900;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29848__$1,(13),dchan);
} else {
if((state_val_29849 === (14))){
var inst_29837 = cljs.core.async.close_BANG_(out);
var state_29848__$1 = state_29848;
var statearr_29901_31787 = state_29848__$1;
(statearr_29901_31787[(2)] = inst_29837);

(statearr_29901_31787[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (16))){
var inst_29844 = (state_29848[(2)]);
var state_29848__$1 = state_29848;
var statearr_29902_31789 = state_29848__$1;
(statearr_29902_31789[(2)] = inst_29844);

(statearr_29902_31789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (10))){
var inst_29806 = (state_29848[(8)]);
var inst_29822 = (state_29848[(2)]);
var inst_29823 = (inst_29806 + (1));
var inst_29806__$1 = inst_29823;
var state_29848__$1 = (function (){var statearr_29903 = state_29848;
(statearr_29903[(8)] = inst_29806__$1);

(statearr_29903[(14)] = inst_29822);

return statearr_29903;
})();
var statearr_29904_31792 = state_29848__$1;
(statearr_29904_31792[(2)] = null);

(statearr_29904_31792[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29849 === (8))){
var inst_29827 = (state_29848[(2)]);
var state_29848__$1 = state_29848;
var statearr_29905_31794 = state_29848__$1;
(statearr_29905_31794[(2)] = inst_29827);

(statearr_29905_31794[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_29910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29910[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_29910[(1)] = (1));

return statearr_29910;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_29848){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_29848);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29911){var ex__28151__auto__ = e29911;
var statearr_29912_31797 = state_29848;
(statearr_29912_31797[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_29848[(4)]))){
var statearr_29913_31798 = state_29848;
(statearr_29913_31798[(1)] = cljs.core.first((state_29848[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31800 = state_29848;
state_29848 = G__31800;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_29848){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_29848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29914 = f__28257__auto__();
(statearr_29914[(6)] = c__28256__auto___31755);

return statearr_29914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29920 = arguments.length;
switch (G__29920) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28256__auto___31805 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_29968){
var state_val_29969 = (state_29968[(1)]);
if((state_val_29969 === (7))){
var inst_29939 = (state_29968[(7)]);
var inst_29945 = (state_29968[(8)]);
var inst_29939__$1 = (state_29968[(2)]);
var inst_29945__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29939__$1,(0),null);
var inst_29946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29939__$1,(1),null);
var inst_29950 = (inst_29945__$1 == null);
var state_29968__$1 = (function (){var statearr_29970 = state_29968;
(statearr_29970[(9)] = inst_29946);

(statearr_29970[(7)] = inst_29939__$1);

(statearr_29970[(8)] = inst_29945__$1);

return statearr_29970;
})();
if(cljs.core.truth_(inst_29950)){
var statearr_29971_31809 = state_29968__$1;
(statearr_29971_31809[(1)] = (8));

} else {
var statearr_29972_31810 = state_29968__$1;
(statearr_29972_31810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (1))){
var inst_29929 = cljs.core.vec(chs);
var inst_29930 = inst_29929;
var state_29968__$1 = (function (){var statearr_29973 = state_29968;
(statearr_29973[(10)] = inst_29930);

return statearr_29973;
})();
var statearr_29974_31812 = state_29968__$1;
(statearr_29974_31812[(2)] = null);

(statearr_29974_31812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (4))){
var inst_29930 = (state_29968[(10)]);
var state_29968__$1 = state_29968;
return cljs.core.async.ioc_alts_BANG_(state_29968__$1,(7),inst_29930);
} else {
if((state_val_29969 === (6))){
var inst_29964 = (state_29968[(2)]);
var state_29968__$1 = state_29968;
var statearr_29978_31814 = state_29968__$1;
(statearr_29978_31814[(2)] = inst_29964);

(statearr_29978_31814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (3))){
var inst_29966 = (state_29968[(2)]);
var state_29968__$1 = state_29968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29968__$1,inst_29966);
} else {
if((state_val_29969 === (2))){
var inst_29930 = (state_29968[(10)]);
var inst_29932 = cljs.core.count(inst_29930);
var inst_29933 = (inst_29932 > (0));
var state_29968__$1 = state_29968;
if(cljs.core.truth_(inst_29933)){
var statearr_29982_31817 = state_29968__$1;
(statearr_29982_31817[(1)] = (4));

} else {
var statearr_29983_31818 = state_29968__$1;
(statearr_29983_31818[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (11))){
var inst_29930 = (state_29968[(10)]);
var inst_29957 = (state_29968[(2)]);
var tmp29979 = inst_29930;
var inst_29930__$1 = tmp29979;
var state_29968__$1 = (function (){var statearr_29984 = state_29968;
(statearr_29984[(10)] = inst_29930__$1);

(statearr_29984[(11)] = inst_29957);

return statearr_29984;
})();
var statearr_29985_31821 = state_29968__$1;
(statearr_29985_31821[(2)] = null);

(statearr_29985_31821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (9))){
var inst_29945 = (state_29968[(8)]);
var state_29968__$1 = state_29968;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29968__$1,(11),out,inst_29945);
} else {
if((state_val_29969 === (5))){
var inst_29962 = cljs.core.async.close_BANG_(out);
var state_29968__$1 = state_29968;
var statearr_29988_31823 = state_29968__$1;
(statearr_29988_31823[(2)] = inst_29962);

(statearr_29988_31823[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (10))){
var inst_29960 = (state_29968[(2)]);
var state_29968__$1 = state_29968;
var statearr_29989_31824 = state_29968__$1;
(statearr_29989_31824[(2)] = inst_29960);

(statearr_29989_31824[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29969 === (8))){
var inst_29946 = (state_29968[(9)]);
var inst_29939 = (state_29968[(7)]);
var inst_29930 = (state_29968[(10)]);
var inst_29945 = (state_29968[(8)]);
var inst_29952 = (function (){var cs = inst_29930;
var vec__29935 = inst_29939;
var v = inst_29945;
var c = inst_29946;
return (function (p1__29918_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29918_SHARP_);
});
})();
var inst_29953 = cljs.core.filterv(inst_29952,inst_29930);
var inst_29930__$1 = inst_29953;
var state_29968__$1 = (function (){var statearr_29990 = state_29968;
(statearr_29990[(10)] = inst_29930__$1);

return statearr_29990;
})();
var statearr_29991_31828 = state_29968__$1;
(statearr_29991_31828[(2)] = null);

(statearr_29991_31828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_29994 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29994[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_29994[(1)] = (1));

return statearr_29994;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_29968){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_29968);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e29995){var ex__28151__auto__ = e29995;
var statearr_29996_31829 = state_29968;
(statearr_29996_31829[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_29968[(4)]))){
var statearr_29997_31830 = state_29968;
(statearr_29997_31830[(1)] = cljs.core.first((state_29968[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31831 = state_29968;
state_29968 = G__31831;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_29968){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_29968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_29998 = f__28257__auto__();
(statearr_29998[(6)] = c__28256__auto___31805);

return statearr_29998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__30002 = arguments.length;
switch (G__30002) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28256__auto___31833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30026){
var state_val_30027 = (state_30026[(1)]);
if((state_val_30027 === (7))){
var inst_30008 = (state_30026[(7)]);
var inst_30008__$1 = (state_30026[(2)]);
var inst_30009 = (inst_30008__$1 == null);
var inst_30010 = cljs.core.not(inst_30009);
var state_30026__$1 = (function (){var statearr_30028 = state_30026;
(statearr_30028[(7)] = inst_30008__$1);

return statearr_30028;
})();
if(inst_30010){
var statearr_30029_31834 = state_30026__$1;
(statearr_30029_31834[(1)] = (8));

} else {
var statearr_30031_31835 = state_30026__$1;
(statearr_30031_31835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (1))){
var inst_30003 = (0);
var state_30026__$1 = (function (){var statearr_30032 = state_30026;
(statearr_30032[(8)] = inst_30003);

return statearr_30032;
})();
var statearr_30033_31836 = state_30026__$1;
(statearr_30033_31836[(2)] = null);

(statearr_30033_31836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (4))){
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30026__$1,(7),ch);
} else {
if((state_val_30027 === (6))){
var inst_30021 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30034_31837 = state_30026__$1;
(statearr_30034_31837[(2)] = inst_30021);

(statearr_30034_31837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (3))){
var inst_30023 = (state_30026[(2)]);
var inst_30024 = cljs.core.async.close_BANG_(out);
var state_30026__$1 = (function (){var statearr_30035 = state_30026;
(statearr_30035[(9)] = inst_30023);

return statearr_30035;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30026__$1,inst_30024);
} else {
if((state_val_30027 === (2))){
var inst_30003 = (state_30026[(8)]);
var inst_30005 = (inst_30003 < n);
var state_30026__$1 = state_30026;
if(cljs.core.truth_(inst_30005)){
var statearr_30036_31838 = state_30026__$1;
(statearr_30036_31838[(1)] = (4));

} else {
var statearr_30037_31839 = state_30026__$1;
(statearr_30037_31839[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (11))){
var inst_30003 = (state_30026[(8)]);
var inst_30013 = (state_30026[(2)]);
var inst_30014 = (inst_30003 + (1));
var inst_30003__$1 = inst_30014;
var state_30026__$1 = (function (){var statearr_30038 = state_30026;
(statearr_30038[(8)] = inst_30003__$1);

(statearr_30038[(10)] = inst_30013);

return statearr_30038;
})();
var statearr_30039_31840 = state_30026__$1;
(statearr_30039_31840[(2)] = null);

(statearr_30039_31840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (9))){
var state_30026__$1 = state_30026;
var statearr_30040_31841 = state_30026__$1;
(statearr_30040_31841[(2)] = null);

(statearr_30040_31841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (5))){
var state_30026__$1 = state_30026;
var statearr_30045_31842 = state_30026__$1;
(statearr_30045_31842[(2)] = null);

(statearr_30045_31842[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (10))){
var inst_30018 = (state_30026[(2)]);
var state_30026__$1 = state_30026;
var statearr_30046_31843 = state_30026__$1;
(statearr_30046_31843[(2)] = inst_30018);

(statearr_30046_31843[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30027 === (8))){
var inst_30008 = (state_30026[(7)]);
var state_30026__$1 = state_30026;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30026__$1,(11),out,inst_30008);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_30050 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30050[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_30050[(1)] = (1));

return statearr_30050;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_30026){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30026);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30051){var ex__28151__auto__ = e30051;
var statearr_30052_31844 = state_30026;
(statearr_30052_31844[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30026[(4)]))){
var statearr_30053_31845 = state_30026;
(statearr_30053_31845[(1)] = cljs.core.first((state_30026[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31846 = state_30026;
state_30026 = G__31846;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_30026){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_30026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30054 = f__28257__auto__();
(statearr_30054[(6)] = c__28256__auto___31833);

return statearr_30054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30056 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30056 = (function (f,ch,meta30057){
this.f = f;
this.ch = ch;
this.meta30057 = meta30057;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30058,meta30057__$1){
var self__ = this;
var _30058__$1 = this;
return (new cljs.core.async.t_cljs$core$async30056(self__.f,self__.ch,meta30057__$1));
}));

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30058){
var self__ = this;
var _30058__$1 = this;
return self__.meta30057;
}));

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30059 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30059 = (function (f,ch,meta30057,_,fn1,meta30060){
this.f = f;
this.ch = ch;
this.meta30057 = meta30057;
this._ = _;
this.fn1 = fn1;
this.meta30060 = meta30060;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30059.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30061,meta30060__$1){
var self__ = this;
var _30061__$1 = this;
return (new cljs.core.async.t_cljs$core$async30059(self__.f,self__.ch,self__.meta30057,self__._,self__.fn1,meta30060__$1));
}));

(cljs.core.async.t_cljs$core$async30059.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30061){
var self__ = this;
var _30061__$1 = this;
return self__.meta30060;
}));

(cljs.core.async.t_cljs$core$async30059.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30059.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30059.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30059.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30055_SHARP_){
var G__30062 = (((p1__30055_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30055_SHARP_) : self__.f.call(null,p1__30055_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30062) : f1.call(null,G__30062));
});
}));

(cljs.core.async.t_cljs$core$async30059.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30057","meta30057",3518188,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30056","cljs.core.async/t_cljs$core$async30056",-1399765224,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30060","meta30060",-1052282596,null)], null);
}));

(cljs.core.async.t_cljs$core$async30059.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30059.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30059");

(cljs.core.async.t_cljs$core$async30059.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30059");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30059.
 */
cljs.core.async.__GT_t_cljs$core$async30059 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30059(f__$1,ch__$1,meta30057__$1,___$2,fn1__$1,meta30060){
return (new cljs.core.async.t_cljs$core$async30059(f__$1,ch__$1,meta30057__$1,___$2,fn1__$1,meta30060));
});

}

return (new cljs.core.async.t_cljs$core$async30059(self__.f,self__.ch,self__.meta30057,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30065 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30065) : self__.f.call(null,G__30065));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30056.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30056.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30057","meta30057",3518188,null)], null);
}));

(cljs.core.async.t_cljs$core$async30056.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30056.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30056");

(cljs.core.async.t_cljs$core$async30056.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30056");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30056.
 */
cljs.core.async.__GT_t_cljs$core$async30056 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30056(f__$1,ch__$1,meta30057){
return (new cljs.core.async.t_cljs$core$async30056(f__$1,ch__$1,meta30057));
});

}

return (new cljs.core.async.t_cljs$core$async30056(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30067 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30067 = (function (f,ch,meta30068){
this.f = f;
this.ch = ch;
this.meta30068 = meta30068;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30069,meta30068__$1){
var self__ = this;
var _30069__$1 = this;
return (new cljs.core.async.t_cljs$core$async30067(self__.f,self__.ch,meta30068__$1));
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30069){
var self__ = this;
var _30069__$1 = this;
return self__.meta30068;
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30067.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30068","meta30068",-988911195,null)], null);
}));

(cljs.core.async.t_cljs$core$async30067.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30067.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30067");

(cljs.core.async.t_cljs$core$async30067.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30067");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30067.
 */
cljs.core.async.__GT_t_cljs$core$async30067 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30067(f__$1,ch__$1,meta30068){
return (new cljs.core.async.t_cljs$core$async30067(f__$1,ch__$1,meta30068));
});

}

return (new cljs.core.async.t_cljs$core$async30067(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30071 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30071 = (function (p,ch,meta30072){
this.p = p;
this.ch = ch;
this.meta30072 = meta30072;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30073,meta30072__$1){
var self__ = this;
var _30073__$1 = this;
return (new cljs.core.async.t_cljs$core$async30071(self__.p,self__.ch,meta30072__$1));
}));

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30073){
var self__ = this;
var _30073__$1 = this;
return self__.meta30072;
}));

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30071.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30071.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30072","meta30072",1804912815,null)], null);
}));

(cljs.core.async.t_cljs$core$async30071.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30071.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30071");

(cljs.core.async.t_cljs$core$async30071.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30071");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30071.
 */
cljs.core.async.__GT_t_cljs$core$async30071 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30071(p__$1,ch__$1,meta30072){
return (new cljs.core.async.t_cljs$core$async30071(p__$1,ch__$1,meta30072));
});

}

return (new cljs.core.async.t_cljs$core$async30071(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30086 = arguments.length;
switch (G__30086) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28256__auto___31848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30110){
var state_val_30111 = (state_30110[(1)]);
if((state_val_30111 === (7))){
var inst_30106 = (state_30110[(2)]);
var state_30110__$1 = state_30110;
var statearr_30113_31849 = state_30110__$1;
(statearr_30113_31849[(2)] = inst_30106);

(statearr_30113_31849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (1))){
var state_30110__$1 = state_30110;
var statearr_30114_31850 = state_30110__$1;
(statearr_30114_31850[(2)] = null);

(statearr_30114_31850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (4))){
var inst_30092 = (state_30110[(7)]);
var inst_30092__$1 = (state_30110[(2)]);
var inst_30093 = (inst_30092__$1 == null);
var state_30110__$1 = (function (){var statearr_30115 = state_30110;
(statearr_30115[(7)] = inst_30092__$1);

return statearr_30115;
})();
if(cljs.core.truth_(inst_30093)){
var statearr_30116_31851 = state_30110__$1;
(statearr_30116_31851[(1)] = (5));

} else {
var statearr_30117_31852 = state_30110__$1;
(statearr_30117_31852[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (6))){
var inst_30092 = (state_30110[(7)]);
var inst_30097 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30092) : p.call(null,inst_30092));
var state_30110__$1 = state_30110;
if(cljs.core.truth_(inst_30097)){
var statearr_30118_31853 = state_30110__$1;
(statearr_30118_31853[(1)] = (8));

} else {
var statearr_30119_31854 = state_30110__$1;
(statearr_30119_31854[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (3))){
var inst_30108 = (state_30110[(2)]);
var state_30110__$1 = state_30110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30110__$1,inst_30108);
} else {
if((state_val_30111 === (2))){
var state_30110__$1 = state_30110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30110__$1,(4),ch);
} else {
if((state_val_30111 === (11))){
var inst_30100 = (state_30110[(2)]);
var state_30110__$1 = state_30110;
var statearr_30124_31855 = state_30110__$1;
(statearr_30124_31855[(2)] = inst_30100);

(statearr_30124_31855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (9))){
var state_30110__$1 = state_30110;
var statearr_30125_31856 = state_30110__$1;
(statearr_30125_31856[(2)] = null);

(statearr_30125_31856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (5))){
var inst_30095 = cljs.core.async.close_BANG_(out);
var state_30110__$1 = state_30110;
var statearr_30126_31857 = state_30110__$1;
(statearr_30126_31857[(2)] = inst_30095);

(statearr_30126_31857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (10))){
var inst_30103 = (state_30110[(2)]);
var state_30110__$1 = (function (){var statearr_30127 = state_30110;
(statearr_30127[(8)] = inst_30103);

return statearr_30127;
})();
var statearr_30128_31858 = state_30110__$1;
(statearr_30128_31858[(2)] = null);

(statearr_30128_31858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30111 === (8))){
var inst_30092 = (state_30110[(7)]);
var state_30110__$1 = state_30110;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30110__$1,(11),out,inst_30092);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_30129 = [null,null,null,null,null,null,null,null,null];
(statearr_30129[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_30129[(1)] = (1));

return statearr_30129;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_30110){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30110);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30130){var ex__28151__auto__ = e30130;
var statearr_30131_31859 = state_30110;
(statearr_30131_31859[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30110[(4)]))){
var statearr_30132_31860 = state_30110;
(statearr_30132_31860[(1)] = cljs.core.first((state_30110[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31861 = state_30110;
state_30110 = G__31861;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_30110){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_30110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30133 = f__28257__auto__();
(statearr_30133[(6)] = c__28256__auto___31848);

return statearr_30133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30135 = arguments.length;
switch (G__30135) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28256__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30198){
var state_val_30199 = (state_30198[(1)]);
if((state_val_30199 === (7))){
var inst_30194 = (state_30198[(2)]);
var state_30198__$1 = state_30198;
var statearr_30204_31863 = state_30198__$1;
(statearr_30204_31863[(2)] = inst_30194);

(statearr_30204_31863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (20))){
var inst_30164 = (state_30198[(7)]);
var inst_30175 = (state_30198[(2)]);
var inst_30176 = cljs.core.next(inst_30164);
var inst_30149 = inst_30176;
var inst_30150 = null;
var inst_30151 = (0);
var inst_30152 = (0);
var state_30198__$1 = (function (){var statearr_30205 = state_30198;
(statearr_30205[(8)] = inst_30150);

(statearr_30205[(9)] = inst_30149);

(statearr_30205[(10)] = inst_30175);

(statearr_30205[(11)] = inst_30151);

(statearr_30205[(12)] = inst_30152);

return statearr_30205;
})();
var statearr_30206_31864 = state_30198__$1;
(statearr_30206_31864[(2)] = null);

(statearr_30206_31864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (1))){
var state_30198__$1 = state_30198;
var statearr_30207_31865 = state_30198__$1;
(statearr_30207_31865[(2)] = null);

(statearr_30207_31865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (4))){
var inst_30138 = (state_30198[(13)]);
var inst_30138__$1 = (state_30198[(2)]);
var inst_30139 = (inst_30138__$1 == null);
var state_30198__$1 = (function (){var statearr_30210 = state_30198;
(statearr_30210[(13)] = inst_30138__$1);

return statearr_30210;
})();
if(cljs.core.truth_(inst_30139)){
var statearr_30211_31866 = state_30198__$1;
(statearr_30211_31866[(1)] = (5));

} else {
var statearr_30213_31867 = state_30198__$1;
(statearr_30213_31867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (15))){
var state_30198__$1 = state_30198;
var statearr_30217_31868 = state_30198__$1;
(statearr_30217_31868[(2)] = null);

(statearr_30217_31868[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (21))){
var state_30198__$1 = state_30198;
var statearr_30218_31869 = state_30198__$1;
(statearr_30218_31869[(2)] = null);

(statearr_30218_31869[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (13))){
var inst_30150 = (state_30198[(8)]);
var inst_30149 = (state_30198[(9)]);
var inst_30151 = (state_30198[(11)]);
var inst_30152 = (state_30198[(12)]);
var inst_30159 = (state_30198[(2)]);
var inst_30160 = (inst_30152 + (1));
var tmp30214 = inst_30150;
var tmp30215 = inst_30149;
var tmp30216 = inst_30151;
var inst_30149__$1 = tmp30215;
var inst_30150__$1 = tmp30214;
var inst_30151__$1 = tmp30216;
var inst_30152__$1 = inst_30160;
var state_30198__$1 = (function (){var statearr_30219 = state_30198;
(statearr_30219[(8)] = inst_30150__$1);

(statearr_30219[(9)] = inst_30149__$1);

(statearr_30219[(14)] = inst_30159);

(statearr_30219[(11)] = inst_30151__$1);

(statearr_30219[(12)] = inst_30152__$1);

return statearr_30219;
})();
var statearr_30220_31870 = state_30198__$1;
(statearr_30220_31870[(2)] = null);

(statearr_30220_31870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (22))){
var state_30198__$1 = state_30198;
var statearr_30221_31871 = state_30198__$1;
(statearr_30221_31871[(2)] = null);

(statearr_30221_31871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (6))){
var inst_30138 = (state_30198[(13)]);
var inst_30147 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30138) : f.call(null,inst_30138));
var inst_30148 = cljs.core.seq(inst_30147);
var inst_30149 = inst_30148;
var inst_30150 = null;
var inst_30151 = (0);
var inst_30152 = (0);
var state_30198__$1 = (function (){var statearr_30222 = state_30198;
(statearr_30222[(8)] = inst_30150);

(statearr_30222[(9)] = inst_30149);

(statearr_30222[(11)] = inst_30151);

(statearr_30222[(12)] = inst_30152);

return statearr_30222;
})();
var statearr_30223_31872 = state_30198__$1;
(statearr_30223_31872[(2)] = null);

(statearr_30223_31872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (17))){
var inst_30164 = (state_30198[(7)]);
var inst_30168 = cljs.core.chunk_first(inst_30164);
var inst_30169 = cljs.core.chunk_rest(inst_30164);
var inst_30170 = cljs.core.count(inst_30168);
var inst_30149 = inst_30169;
var inst_30150 = inst_30168;
var inst_30151 = inst_30170;
var inst_30152 = (0);
var state_30198__$1 = (function (){var statearr_30224 = state_30198;
(statearr_30224[(8)] = inst_30150);

(statearr_30224[(9)] = inst_30149);

(statearr_30224[(11)] = inst_30151);

(statearr_30224[(12)] = inst_30152);

return statearr_30224;
})();
var statearr_30225_31873 = state_30198__$1;
(statearr_30225_31873[(2)] = null);

(statearr_30225_31873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (3))){
var inst_30196 = (state_30198[(2)]);
var state_30198__$1 = state_30198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30198__$1,inst_30196);
} else {
if((state_val_30199 === (12))){
var inst_30184 = (state_30198[(2)]);
var state_30198__$1 = state_30198;
var statearr_30226_31874 = state_30198__$1;
(statearr_30226_31874[(2)] = inst_30184);

(statearr_30226_31874[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (2))){
var state_30198__$1 = state_30198;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30198__$1,(4),in$);
} else {
if((state_val_30199 === (23))){
var inst_30192 = (state_30198[(2)]);
var state_30198__$1 = state_30198;
var statearr_30227_31875 = state_30198__$1;
(statearr_30227_31875[(2)] = inst_30192);

(statearr_30227_31875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (19))){
var inst_30179 = (state_30198[(2)]);
var state_30198__$1 = state_30198;
var statearr_30230_31876 = state_30198__$1;
(statearr_30230_31876[(2)] = inst_30179);

(statearr_30230_31876[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (11))){
var inst_30164 = (state_30198[(7)]);
var inst_30149 = (state_30198[(9)]);
var inst_30164__$1 = cljs.core.seq(inst_30149);
var state_30198__$1 = (function (){var statearr_30232 = state_30198;
(statearr_30232[(7)] = inst_30164__$1);

return statearr_30232;
})();
if(inst_30164__$1){
var statearr_30233_31877 = state_30198__$1;
(statearr_30233_31877[(1)] = (14));

} else {
var statearr_30234_31878 = state_30198__$1;
(statearr_30234_31878[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (9))){
var inst_30186 = (state_30198[(2)]);
var inst_30187 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30198__$1 = (function (){var statearr_30235 = state_30198;
(statearr_30235[(15)] = inst_30186);

return statearr_30235;
})();
if(cljs.core.truth_(inst_30187)){
var statearr_30236_31879 = state_30198__$1;
(statearr_30236_31879[(1)] = (21));

} else {
var statearr_30239_31880 = state_30198__$1;
(statearr_30239_31880[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (5))){
var inst_30141 = cljs.core.async.close_BANG_(out);
var state_30198__$1 = state_30198;
var statearr_30241_31881 = state_30198__$1;
(statearr_30241_31881[(2)] = inst_30141);

(statearr_30241_31881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (14))){
var inst_30164 = (state_30198[(7)]);
var inst_30166 = cljs.core.chunked_seq_QMARK_(inst_30164);
var state_30198__$1 = state_30198;
if(inst_30166){
var statearr_30242_31882 = state_30198__$1;
(statearr_30242_31882[(1)] = (17));

} else {
var statearr_30243_31883 = state_30198__$1;
(statearr_30243_31883[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (16))){
var inst_30182 = (state_30198[(2)]);
var state_30198__$1 = state_30198;
var statearr_30246_31884 = state_30198__$1;
(statearr_30246_31884[(2)] = inst_30182);

(statearr_30246_31884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30199 === (10))){
var inst_30150 = (state_30198[(8)]);
var inst_30152 = (state_30198[(12)]);
var inst_30157 = cljs.core._nth(inst_30150,inst_30152);
var state_30198__$1 = state_30198;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30198__$1,(13),out,inst_30157);
} else {
if((state_val_30199 === (18))){
var inst_30164 = (state_30198[(7)]);
var inst_30173 = cljs.core.first(inst_30164);
var state_30198__$1 = state_30198;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30198__$1,(20),out,inst_30173);
} else {
if((state_val_30199 === (8))){
var inst_30151 = (state_30198[(11)]);
var inst_30152 = (state_30198[(12)]);
var inst_30154 = (inst_30152 < inst_30151);
var inst_30155 = inst_30154;
var state_30198__$1 = state_30198;
if(cljs.core.truth_(inst_30155)){
var statearr_30248_31885 = state_30198__$1;
(statearr_30248_31885[(1)] = (10));

} else {
var statearr_30249_31886 = state_30198__$1;
(statearr_30249_31886[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28148__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28148__auto____0 = (function (){
var statearr_30250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30250[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28148__auto__);

(statearr_30250[(1)] = (1));

return statearr_30250;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28148__auto____1 = (function (state_30198){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30198);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30253){var ex__28151__auto__ = e30253;
var statearr_30254_31887 = state_30198;
(statearr_30254_31887[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30198[(4)]))){
var statearr_30256_31888 = state_30198;
(statearr_30256_31888[(1)] = cljs.core.first((state_30198[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31889 = state_30198;
state_30198 = G__31889;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28148__auto__ = function(state_30198){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28148__auto____1.call(this,state_30198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28148__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28148__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30257 = f__28257__auto__();
(statearr_30257[(6)] = c__28256__auto__);

return statearr_30257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));

return c__28256__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30259 = arguments.length;
switch (G__30259) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30264 = arguments.length;
switch (G__30264) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30266 = arguments.length;
switch (G__30266) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28256__auto___31893 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30290){
var state_val_30291 = (state_30290[(1)]);
if((state_val_30291 === (7))){
var inst_30285 = (state_30290[(2)]);
var state_30290__$1 = state_30290;
var statearr_30292_31894 = state_30290__$1;
(statearr_30292_31894[(2)] = inst_30285);

(statearr_30292_31894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (1))){
var inst_30267 = null;
var state_30290__$1 = (function (){var statearr_30293 = state_30290;
(statearr_30293[(7)] = inst_30267);

return statearr_30293;
})();
var statearr_30294_31895 = state_30290__$1;
(statearr_30294_31895[(2)] = null);

(statearr_30294_31895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (4))){
var inst_30270 = (state_30290[(8)]);
var inst_30270__$1 = (state_30290[(2)]);
var inst_30271 = (inst_30270__$1 == null);
var inst_30272 = cljs.core.not(inst_30271);
var state_30290__$1 = (function (){var statearr_30295 = state_30290;
(statearr_30295[(8)] = inst_30270__$1);

return statearr_30295;
})();
if(inst_30272){
var statearr_30296_31896 = state_30290__$1;
(statearr_30296_31896[(1)] = (5));

} else {
var statearr_30297_31897 = state_30290__$1;
(statearr_30297_31897[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (6))){
var state_30290__$1 = state_30290;
var statearr_30298_31898 = state_30290__$1;
(statearr_30298_31898[(2)] = null);

(statearr_30298_31898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (3))){
var inst_30287 = (state_30290[(2)]);
var inst_30288 = cljs.core.async.close_BANG_(out);
var state_30290__$1 = (function (){var statearr_30300 = state_30290;
(statearr_30300[(9)] = inst_30287);

return statearr_30300;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30290__$1,inst_30288);
} else {
if((state_val_30291 === (2))){
var state_30290__$1 = state_30290;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30290__$1,(4),ch);
} else {
if((state_val_30291 === (11))){
var inst_30270 = (state_30290[(8)]);
var inst_30279 = (state_30290[(2)]);
var inst_30267 = inst_30270;
var state_30290__$1 = (function (){var statearr_30303 = state_30290;
(statearr_30303[(10)] = inst_30279);

(statearr_30303[(7)] = inst_30267);

return statearr_30303;
})();
var statearr_30304_31899 = state_30290__$1;
(statearr_30304_31899[(2)] = null);

(statearr_30304_31899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (9))){
var inst_30270 = (state_30290[(8)]);
var state_30290__$1 = state_30290;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30290__$1,(11),out,inst_30270);
} else {
if((state_val_30291 === (5))){
var inst_30270 = (state_30290[(8)]);
var inst_30267 = (state_30290[(7)]);
var inst_30274 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30270,inst_30267);
var state_30290__$1 = state_30290;
if(inst_30274){
var statearr_30310_31900 = state_30290__$1;
(statearr_30310_31900[(1)] = (8));

} else {
var statearr_30311_31901 = state_30290__$1;
(statearr_30311_31901[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (10))){
var inst_30282 = (state_30290[(2)]);
var state_30290__$1 = state_30290;
var statearr_30312_31902 = state_30290__$1;
(statearr_30312_31902[(2)] = inst_30282);

(statearr_30312_31902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30291 === (8))){
var inst_30267 = (state_30290[(7)]);
var tmp30309 = inst_30267;
var inst_30267__$1 = tmp30309;
var state_30290__$1 = (function (){var statearr_30314 = state_30290;
(statearr_30314[(7)] = inst_30267__$1);

return statearr_30314;
})();
var statearr_30315_31903 = state_30290__$1;
(statearr_30315_31903[(2)] = null);

(statearr_30315_31903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_30316 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30316[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_30316[(1)] = (1));

return statearr_30316;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_30290){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30290);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30317){var ex__28151__auto__ = e30317;
var statearr_30318_31904 = state_30290;
(statearr_30318_31904[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30290[(4)]))){
var statearr_30319_31905 = state_30290;
(statearr_30319_31905[(1)] = cljs.core.first((state_30290[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31906 = state_30290;
state_30290 = G__31906;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_30290){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_30290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30320 = f__28257__auto__();
(statearr_30320[(6)] = c__28256__auto___31893);

return statearr_30320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30326 = arguments.length;
switch (G__30326) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28256__auto___31908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30365){
var state_val_30366 = (state_30365[(1)]);
if((state_val_30366 === (7))){
var inst_30361 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30367_31909 = state_30365__$1;
(statearr_30367_31909[(2)] = inst_30361);

(statearr_30367_31909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (1))){
var inst_30327 = (new Array(n));
var inst_30328 = inst_30327;
var inst_30329 = (0);
var state_30365__$1 = (function (){var statearr_30368 = state_30365;
(statearr_30368[(7)] = inst_30328);

(statearr_30368[(8)] = inst_30329);

return statearr_30368;
})();
var statearr_30369_31910 = state_30365__$1;
(statearr_30369_31910[(2)] = null);

(statearr_30369_31910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (4))){
var inst_30332 = (state_30365[(9)]);
var inst_30332__$1 = (state_30365[(2)]);
var inst_30333 = (inst_30332__$1 == null);
var inst_30334 = cljs.core.not(inst_30333);
var state_30365__$1 = (function (){var statearr_30370 = state_30365;
(statearr_30370[(9)] = inst_30332__$1);

return statearr_30370;
})();
if(inst_30334){
var statearr_30371_31911 = state_30365__$1;
(statearr_30371_31911[(1)] = (5));

} else {
var statearr_30372_31912 = state_30365__$1;
(statearr_30372_31912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (15))){
var inst_30355 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30373_31913 = state_30365__$1;
(statearr_30373_31913[(2)] = inst_30355);

(statearr_30373_31913[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (13))){
var state_30365__$1 = state_30365;
var statearr_30374_31914 = state_30365__$1;
(statearr_30374_31914[(2)] = null);

(statearr_30374_31914[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (6))){
var inst_30329 = (state_30365[(8)]);
var inst_30350 = (inst_30329 > (0));
var state_30365__$1 = state_30365;
if(cljs.core.truth_(inst_30350)){
var statearr_30375_31915 = state_30365__$1;
(statearr_30375_31915[(1)] = (12));

} else {
var statearr_30376_31916 = state_30365__$1;
(statearr_30376_31916[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (3))){
var inst_30363 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30365__$1,inst_30363);
} else {
if((state_val_30366 === (12))){
var inst_30328 = (state_30365[(7)]);
var inst_30353 = cljs.core.vec(inst_30328);
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30365__$1,(15),out,inst_30353);
} else {
if((state_val_30366 === (2))){
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30365__$1,(4),ch);
} else {
if((state_val_30366 === (11))){
var inst_30344 = (state_30365[(2)]);
var inst_30345 = (new Array(n));
var inst_30328 = inst_30345;
var inst_30329 = (0);
var state_30365__$1 = (function (){var statearr_30377 = state_30365;
(statearr_30377[(10)] = inst_30344);

(statearr_30377[(7)] = inst_30328);

(statearr_30377[(8)] = inst_30329);

return statearr_30377;
})();
var statearr_30378_31917 = state_30365__$1;
(statearr_30378_31917[(2)] = null);

(statearr_30378_31917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (9))){
var inst_30328 = (state_30365[(7)]);
var inst_30342 = cljs.core.vec(inst_30328);
var state_30365__$1 = state_30365;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30365__$1,(11),out,inst_30342);
} else {
if((state_val_30366 === (5))){
var inst_30337 = (state_30365[(11)]);
var inst_30328 = (state_30365[(7)]);
var inst_30329 = (state_30365[(8)]);
var inst_30332 = (state_30365[(9)]);
var inst_30336 = (inst_30328[inst_30329] = inst_30332);
var inst_30337__$1 = (inst_30329 + (1));
var inst_30338 = (inst_30337__$1 < n);
var state_30365__$1 = (function (){var statearr_30379 = state_30365;
(statearr_30379[(11)] = inst_30337__$1);

(statearr_30379[(12)] = inst_30336);

return statearr_30379;
})();
if(cljs.core.truth_(inst_30338)){
var statearr_30380_31918 = state_30365__$1;
(statearr_30380_31918[(1)] = (8));

} else {
var statearr_30381_31919 = state_30365__$1;
(statearr_30381_31919[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (14))){
var inst_30358 = (state_30365[(2)]);
var inst_30359 = cljs.core.async.close_BANG_(out);
var state_30365__$1 = (function (){var statearr_30383 = state_30365;
(statearr_30383[(13)] = inst_30358);

return statearr_30383;
})();
var statearr_30384_31920 = state_30365__$1;
(statearr_30384_31920[(2)] = inst_30359);

(statearr_30384_31920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (10))){
var inst_30348 = (state_30365[(2)]);
var state_30365__$1 = state_30365;
var statearr_30385_31921 = state_30365__$1;
(statearr_30385_31921[(2)] = inst_30348);

(statearr_30385_31921[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30366 === (8))){
var inst_30337 = (state_30365[(11)]);
var inst_30328 = (state_30365[(7)]);
var tmp30382 = inst_30328;
var inst_30328__$1 = tmp30382;
var inst_30329 = inst_30337;
var state_30365__$1 = (function (){var statearr_30386 = state_30365;
(statearr_30386[(7)] = inst_30328__$1);

(statearr_30386[(8)] = inst_30329);

return statearr_30386;
})();
var statearr_30387_31922 = state_30365__$1;
(statearr_30387_31922[(2)] = null);

(statearr_30387_31922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_30388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30388[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_30388[(1)] = (1));

return statearr_30388;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_30365){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30365);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30389){var ex__28151__auto__ = e30389;
var statearr_30390_31923 = state_30365;
(statearr_30390_31923[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30365[(4)]))){
var statearr_30391_31924 = state_30365;
(statearr_30391_31924[(1)] = cljs.core.first((state_30365[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31925 = state_30365;
state_30365 = G__31925;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_30365){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_30365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30396 = f__28257__auto__();
(statearr_30396[(6)] = c__28256__auto___31908);

return statearr_30396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30398 = arguments.length;
switch (G__30398) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28256__auto___31927 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30440){
var state_val_30441 = (state_30440[(1)]);
if((state_val_30441 === (7))){
var inst_30436 = (state_30440[(2)]);
var state_30440__$1 = state_30440;
var statearr_30443_31928 = state_30440__$1;
(statearr_30443_31928[(2)] = inst_30436);

(statearr_30443_31928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (1))){
var inst_30399 = [];
var inst_30400 = inst_30399;
var inst_30401 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30440__$1 = (function (){var statearr_30444 = state_30440;
(statearr_30444[(7)] = inst_30400);

(statearr_30444[(8)] = inst_30401);

return statearr_30444;
})();
var statearr_30445_31929 = state_30440__$1;
(statearr_30445_31929[(2)] = null);

(statearr_30445_31929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (4))){
var inst_30404 = (state_30440[(9)]);
var inst_30404__$1 = (state_30440[(2)]);
var inst_30405 = (inst_30404__$1 == null);
var inst_30406 = cljs.core.not(inst_30405);
var state_30440__$1 = (function (){var statearr_30446 = state_30440;
(statearr_30446[(9)] = inst_30404__$1);

return statearr_30446;
})();
if(inst_30406){
var statearr_30447_31930 = state_30440__$1;
(statearr_30447_31930[(1)] = (5));

} else {
var statearr_30448_31931 = state_30440__$1;
(statearr_30448_31931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (15))){
var inst_30430 = (state_30440[(2)]);
var state_30440__$1 = state_30440;
var statearr_30449_31932 = state_30440__$1;
(statearr_30449_31932[(2)] = inst_30430);

(statearr_30449_31932[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (13))){
var state_30440__$1 = state_30440;
var statearr_30450_31933 = state_30440__$1;
(statearr_30450_31933[(2)] = null);

(statearr_30450_31933[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (6))){
var inst_30400 = (state_30440[(7)]);
var inst_30425 = inst_30400.length;
var inst_30426 = (inst_30425 > (0));
var state_30440__$1 = state_30440;
if(cljs.core.truth_(inst_30426)){
var statearr_30451_31934 = state_30440__$1;
(statearr_30451_31934[(1)] = (12));

} else {
var statearr_30452_31935 = state_30440__$1;
(statearr_30452_31935[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (3))){
var inst_30438 = (state_30440[(2)]);
var state_30440__$1 = state_30440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30440__$1,inst_30438);
} else {
if((state_val_30441 === (12))){
var inst_30400 = (state_30440[(7)]);
var inst_30428 = cljs.core.vec(inst_30400);
var state_30440__$1 = state_30440;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30440__$1,(15),out,inst_30428);
} else {
if((state_val_30441 === (2))){
var state_30440__$1 = state_30440;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30440__$1,(4),ch);
} else {
if((state_val_30441 === (11))){
var inst_30404 = (state_30440[(9)]);
var inst_30408 = (state_30440[(10)]);
var inst_30418 = (state_30440[(2)]);
var inst_30419 = [];
var inst_30420 = inst_30419.push(inst_30404);
var inst_30400 = inst_30419;
var inst_30401 = inst_30408;
var state_30440__$1 = (function (){var statearr_30453 = state_30440;
(statearr_30453[(11)] = inst_30420);

(statearr_30453[(12)] = inst_30418);

(statearr_30453[(7)] = inst_30400);

(statearr_30453[(8)] = inst_30401);

return statearr_30453;
})();
var statearr_30454_31936 = state_30440__$1;
(statearr_30454_31936[(2)] = null);

(statearr_30454_31936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (9))){
var inst_30400 = (state_30440[(7)]);
var inst_30416 = cljs.core.vec(inst_30400);
var state_30440__$1 = state_30440;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30440__$1,(11),out,inst_30416);
} else {
if((state_val_30441 === (5))){
var inst_30404 = (state_30440[(9)]);
var inst_30408 = (state_30440[(10)]);
var inst_30401 = (state_30440[(8)]);
var inst_30408__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30404) : f.call(null,inst_30404));
var inst_30409 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30408__$1,inst_30401);
var inst_30410 = cljs.core.keyword_identical_QMARK_(inst_30401,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30411 = ((inst_30409) || (inst_30410));
var state_30440__$1 = (function (){var statearr_30455 = state_30440;
(statearr_30455[(10)] = inst_30408__$1);

return statearr_30455;
})();
if(cljs.core.truth_(inst_30411)){
var statearr_30456_31937 = state_30440__$1;
(statearr_30456_31937[(1)] = (8));

} else {
var statearr_30457_31938 = state_30440__$1;
(statearr_30457_31938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (14))){
var inst_30433 = (state_30440[(2)]);
var inst_30434 = cljs.core.async.close_BANG_(out);
var state_30440__$1 = (function (){var statearr_30459 = state_30440;
(statearr_30459[(13)] = inst_30433);

return statearr_30459;
})();
var statearr_30460_31939 = state_30440__$1;
(statearr_30460_31939[(2)] = inst_30434);

(statearr_30460_31939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (10))){
var inst_30423 = (state_30440[(2)]);
var state_30440__$1 = state_30440;
var statearr_30461_31940 = state_30440__$1;
(statearr_30461_31940[(2)] = inst_30423);

(statearr_30461_31940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30441 === (8))){
var inst_30404 = (state_30440[(9)]);
var inst_30400 = (state_30440[(7)]);
var inst_30408 = (state_30440[(10)]);
var inst_30413 = inst_30400.push(inst_30404);
var tmp30458 = inst_30400;
var inst_30400__$1 = tmp30458;
var inst_30401 = inst_30408;
var state_30440__$1 = (function (){var statearr_30462 = state_30440;
(statearr_30462[(14)] = inst_30413);

(statearr_30462[(7)] = inst_30400__$1);

(statearr_30462[(8)] = inst_30401);

return statearr_30462;
})();
var statearr_30463_31941 = state_30440__$1;
(statearr_30463_31941[(2)] = null);

(statearr_30463_31941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28148__auto__ = null;
var cljs$core$async$state_machine__28148__auto____0 = (function (){
var statearr_30464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30464[(0)] = cljs$core$async$state_machine__28148__auto__);

(statearr_30464[(1)] = (1));

return statearr_30464;
});
var cljs$core$async$state_machine__28148__auto____1 = (function (state_30440){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30440);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30465){var ex__28151__auto__ = e30465;
var statearr_30466_31942 = state_30440;
(statearr_30466_31942[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30440[(4)]))){
var statearr_30467_31943 = state_30440;
(statearr_30467_31943[(1)] = cljs.core.first((state_30440[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31944 = state_30440;
state_30440 = G__31944;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
cljs$core$async$state_machine__28148__auto__ = function(state_30440){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28148__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28148__auto____1.call(this,state_30440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28148__auto____0;
cljs$core$async$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28148__auto____1;
return cljs$core$async$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30468 = f__28257__auto__();
(statearr_30468[(6)] = c__28256__auto___31927);

return statearr_30468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
