goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e30672){var e = e30672;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30880 = arguments.length;
var i__4737__auto___30882 = (0);
while(true){
if((i__4737__auto___30882 < len__4736__auto___30880)){
args__4742__auto__.push((arguments[i__4737__auto___30882]));

var G__30887 = (i__4737__auto___30882 + (1));
i__4737__auto___30882 = G__30887;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__30687){
var vec__30688 = p__30687;
var map__30691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30688,(0),null);
var map__30691__$1 = (((((!((map__30691 == null))))?(((((map__30691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30691):map__30691);
var opts = map__30691__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30691__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30691__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30691__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30691__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__30696 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__30696__$1 = (((((!((map__30696 == null))))?(((((map__30696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30696):map__30696);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30696__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30696__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__30678_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__30678_SHARP_);
}));

(web_socket.onclose = (function (p1__30679_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__30679_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28256__auto___30905 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28257__auto__ = (function (){var switch__28147__auto__ = (function (state_30782){
var state_val_30783 = (state_30782[(1)]);
if((state_val_30783 === (7))){
var inst_30778 = (state_30782[(2)]);
var state_30782__$1 = state_30782;
var statearr_30786_30908 = state_30782__$1;
(statearr_30786_30908[(2)] = inst_30778);

(statearr_30786_30908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (20))){
var state_30782__$1 = state_30782;
var statearr_30788_30910 = state_30782__$1;
(statearr_30788_30910[(2)] = null);

(statearr_30788_30910[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (1))){
var inst_30704 = false;
var state_30782__$1 = (function (){var statearr_30789 = state_30782;
(statearr_30789[(7)] = inst_30704);

return statearr_30789;
})();
var statearr_30791_30912 = state_30782__$1;
(statearr_30791_30912[(2)] = null);

(statearr_30791_30912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (4))){
var inst_30722 = (state_30782[(8)]);
var inst_30714 = (state_30782[(9)]);
var inst_30720 = (state_30782[(10)]);
var inst_30720__$1 = (state_30782[(2)]);
var inst_30721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30720__$1,(0),null);
var inst_30722__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30720__$1,(1),null);
var inst_30724 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30722__$1,inst_30714);
var state_30782__$1 = (function (){var statearr_30794 = state_30782;
(statearr_30794[(8)] = inst_30722__$1);

(statearr_30794[(11)] = inst_30721);

(statearr_30794[(10)] = inst_30720__$1);

return statearr_30794;
})();
if(inst_30724){
var statearr_30796_30917 = state_30782__$1;
(statearr_30796_30917[(1)] = (5));

} else {
var statearr_30797_30919 = state_30782__$1;
(statearr_30797_30919[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (15))){
var inst_30763 = (state_30782[(2)]);
var state_30782__$1 = state_30782;
var statearr_30799_30920 = state_30782__$1;
(statearr_30799_30920[(2)] = inst_30763);

(statearr_30799_30920[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (21))){
var inst_30774 = (state_30782[(2)]);
var state_30782__$1 = state_30782;
var statearr_30803_30923 = state_30782__$1;
(statearr_30803_30923[(2)] = inst_30774);

(statearr_30803_30923[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (13))){
var state_30782__$1 = state_30782;
var statearr_30805_30926 = state_30782__$1;
(statearr_30805_30926[(2)] = null);

(statearr_30805_30926[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (6))){
var inst_30715 = (state_30782[(12)]);
var inst_30722 = (state_30782[(8)]);
var inst_30742 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30722,inst_30715);
var state_30782__$1 = state_30782;
if(inst_30742){
var statearr_30814_30927 = state_30782__$1;
(statearr_30814_30927[(1)] = (9));

} else {
var statearr_30815_30930 = state_30782__$1;
(statearr_30815_30930[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (17))){
var state_30782__$1 = state_30782;
var statearr_30817_30933 = state_30782__$1;
(statearr_30817_30933[(2)] = initial_ch);

(statearr_30817_30933[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (3))){
var inst_30780 = (state_30782[(2)]);
var state_30782__$1 = state_30782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30782__$1,inst_30780);
} else {
if((state_val_30783 === (12))){
var inst_30704 = (state_30782[(7)]);
var state_30782__$1 = state_30782;
if(cljs.core.truth_(inst_30704)){
var statearr_30820_30934 = state_30782__$1;
(statearr_30820_30934[(1)] = (16));

} else {
var statearr_30822_30935 = state_30782__$1;
(statearr_30822_30935[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (2))){
var inst_30715 = (state_30782[(12)]);
var inst_30714 = (state_30782[(9)]);
var inst_30714__$1 = open_ch;
var inst_30715__$1 = close_ch;
var inst_30716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30717 = [inst_30714__$1,inst_30715__$1];
var inst_30718 = (new cljs.core.PersistentVector(null,2,(5),inst_30716,inst_30717,null));
var state_30782__$1 = (function (){var statearr_30826 = state_30782;
(statearr_30826[(12)] = inst_30715__$1);

(statearr_30826[(9)] = inst_30714__$1);

return statearr_30826;
})();
return cljs.core.async.ioc_alts_BANG_(state_30782__$1,(4),inst_30718);
} else {
if((state_val_30783 === (19))){
var inst_30721 = (state_30782[(11)]);
var state_30782__$1 = state_30782;
var statearr_30829_30939 = state_30782__$1;
(statearr_30829_30939[(2)] = inst_30721);

(statearr_30829_30939[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (11))){
var inst_30776 = (state_30782[(2)]);
var state_30782__$1 = state_30782;
var statearr_30832_30941 = state_30782__$1;
(statearr_30832_30941[(2)] = inst_30776);

(statearr_30832_30941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (9))){
var inst_30720 = (state_30782[(10)]);
var inst_30749 = (state_30782[(13)]);
var inst_30748 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30720,(0),null);
var inst_30749__$1 = chord.client.close_event__GT_maybe_error(inst_30748);
var state_30782__$1 = (function (){var statearr_30834 = state_30782;
(statearr_30834[(13)] = inst_30749__$1);

return statearr_30834;
})();
if(cljs.core.truth_(inst_30749__$1)){
var statearr_30836_30945 = state_30782__$1;
(statearr_30836_30945[(1)] = (12));

} else {
var statearr_30837_30947 = state_30782__$1;
(statearr_30837_30947[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (5))){
var inst_30720 = (state_30782[(10)]);
var inst_30732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30720,(0),null);
var inst_30733 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_30735 = [ws_chan];
var inst_30736 = cljs.core.PersistentHashMap.fromArrays(inst_30733,inst_30735);
var state_30782__$1 = (function (){var statearr_30841 = state_30782;
(statearr_30841[(14)] = inst_30732);

return statearr_30841;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30782__$1,(8),initial_ch,inst_30736);
} else {
if((state_val_30783 === (14))){
var inst_30766 = (state_30782[(2)]);
var inst_30767 = cljs.core.async.close_BANG_(ws_chan);
var inst_30768 = cljs.core.async.close_BANG_(initial_ch);
var state_30782__$1 = (function (){var statearr_30842 = state_30782;
(statearr_30842[(15)] = inst_30766);

(statearr_30842[(16)] = inst_30767);

return statearr_30842;
})();
var statearr_30843_30957 = state_30782__$1;
(statearr_30843_30957[(2)] = inst_30768);

(statearr_30843_30957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (16))){
var state_30782__$1 = state_30782;
var statearr_30844_30960 = state_30782__$1;
(statearr_30844_30960[(2)] = read_ch__$1);

(statearr_30844_30960[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (10))){
var inst_30722 = (state_30782[(8)]);
var inst_30770 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30722,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_30782__$1 = state_30782;
if(inst_30770){
var statearr_30848_30963 = state_30782__$1;
(statearr_30848_30963[(1)] = (19));

} else {
var statearr_30851_30964 = state_30782__$1;
(statearr_30851_30964[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30783 === (18))){
var inst_30749 = (state_30782[(13)]);
var inst_30757 = (state_30782[(2)]);
var inst_30759 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30760 = [inst_30749];
var inst_30761 = cljs.core.PersistentHashMap.fromArrays(inst_30759,inst_30760);
var state_30782__$1 = state_30782;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30782__$1,(15),inst_30757,inst_30761);
} else {
if((state_val_30783 === (8))){
var inst_30738 = (state_30782[(2)]);
var inst_30739 = cljs.core.async.close_BANG_(initial_ch);
var inst_30704 = true;
var state_30782__$1 = (function (){var statearr_30852 = state_30782;
(statearr_30852[(7)] = inst_30704);

(statearr_30852[(17)] = inst_30739);

(statearr_30852[(18)] = inst_30738);

return statearr_30852;
})();
var statearr_30856_30971 = state_30782__$1;
(statearr_30856_30971[(2)] = null);

(statearr_30856_30971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28148__auto__ = null;
var chord$client$state_machine__28148__auto____0 = (function (){
var statearr_30861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30861[(0)] = chord$client$state_machine__28148__auto__);

(statearr_30861[(1)] = (1));

return statearr_30861;
});
var chord$client$state_machine__28148__auto____1 = (function (state_30782){
while(true){
var ret_value__28149__auto__ = (function (){try{while(true){
var result__28150__auto__ = switch__28147__auto__(state_30782);
if(cljs.core.keyword_identical_QMARK_(result__28150__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28150__auto__;
}
break;
}
}catch (e30863){var ex__28151__auto__ = e30863;
var statearr_30864_30981 = state_30782;
(statearr_30864_30981[(2)] = ex__28151__auto__);


if(cljs.core.seq((state_30782[(4)]))){
var statearr_30869_30983 = state_30782;
(statearr_30869_30983[(1)] = cljs.core.first((state_30782[(4)])));

} else {
throw ex__28151__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28149__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30988 = state_30782;
state_30782 = G__30988;
continue;
} else {
return ret_value__28149__auto__;
}
break;
}
});
chord$client$state_machine__28148__auto__ = function(state_30782){
switch(arguments.length){
case 0:
return chord$client$state_machine__28148__auto____0.call(this);
case 1:
return chord$client$state_machine__28148__auto____1.call(this,state_30782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28148__auto____0;
chord$client$state_machine__28148__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28148__auto____1;
return chord$client$state_machine__28148__auto__;
})()
})();
var state__28258__auto__ = (function (){var statearr_30871 = f__28257__auto__();
(statearr_30871[(6)] = c__28256__auto___30905);

return statearr_30871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28258__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq30681){
var G__30682 = cljs.core.first(seq30681);
var seq30681__$1 = cljs.core.next(seq30681);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30682,seq30681__$1);
}));


//# sourceMappingURL=chord.client.js.map
