goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e30709){var e = e30709;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30947 = arguments.length;
var i__4737__auto___30948 = (0);
while(true){
if((i__4737__auto___30948 < len__4736__auto___30947)){
args__4742__auto__.push((arguments[i__4737__auto___30948]));

var G__30950 = (i__4737__auto___30948 + (1));
i__4737__auto___30948 = G__30950;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__30728){
var vec__30730 = p__30728;
var map__30733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30730,(0),null);
var map__30733__$1 = (((((!((map__30733 == null))))?(((((map__30733.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30733.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30733):map__30733);
var opts = map__30733__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30733__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30733__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30733__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30733__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__30740 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__30740__$1 = (((((!((map__30740 == null))))?(((((map__30740.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30740.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30740):map__30740);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30740__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30740__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__30718_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__30718_SHARP_);
}));

(web_socket.onclose = (function (p1__30720_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__30720_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28309__auto___30969 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30835){
var state_val_30836 = (state_30835[(1)]);
if((state_val_30836 === (7))){
var inst_30830 = (state_30835[(2)]);
var state_30835__$1 = state_30835;
var statearr_30843_30975 = state_30835__$1;
(statearr_30843_30975[(2)] = inst_30830);

(statearr_30843_30975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (20))){
var state_30835__$1 = state_30835;
var statearr_30845_30977 = state_30835__$1;
(statearr_30845_30977[(2)] = null);

(statearr_30845_30977[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (1))){
var inst_30755 = false;
var state_30835__$1 = (function (){var statearr_30847 = state_30835;
(statearr_30847[(7)] = inst_30755);

return statearr_30847;
})();
var statearr_30848_30979 = state_30835__$1;
(statearr_30848_30979[(2)] = null);

(statearr_30848_30979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (4))){
var inst_30777 = (state_30835[(8)]);
var inst_30779 = (state_30835[(9)]);
var inst_30770 = (state_30835[(10)]);
var inst_30777__$1 = (state_30835[(2)]);
var inst_30778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30777__$1,(0),null);
var inst_30779__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30777__$1,(1),null);
var inst_30781 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30779__$1,inst_30770);
var state_30835__$1 = (function (){var statearr_30853 = state_30835;
(statearr_30853[(11)] = inst_30778);

(statearr_30853[(8)] = inst_30777__$1);

(statearr_30853[(9)] = inst_30779__$1);

return statearr_30853;
})();
if(inst_30781){
var statearr_30855_30982 = state_30835__$1;
(statearr_30855_30982[(1)] = (5));

} else {
var statearr_30856_30983 = state_30835__$1;
(statearr_30856_30983[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (15))){
var inst_30814 = (state_30835[(2)]);
var state_30835__$1 = state_30835;
var statearr_30858_30986 = state_30835__$1;
(statearr_30858_30986[(2)] = inst_30814);

(statearr_30858_30986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (21))){
var inst_30826 = (state_30835[(2)]);
var state_30835__$1 = state_30835;
var statearr_30864_30988 = state_30835__$1;
(statearr_30864_30988[(2)] = inst_30826);

(statearr_30864_30988[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (13))){
var state_30835__$1 = state_30835;
var statearr_30866_30989 = state_30835__$1;
(statearr_30866_30989[(2)] = null);

(statearr_30866_30989[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (6))){
var inst_30771 = (state_30835[(12)]);
var inst_30779 = (state_30835[(9)]);
var inst_30796 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30779,inst_30771);
var state_30835__$1 = state_30835;
if(inst_30796){
var statearr_30869_30994 = state_30835__$1;
(statearr_30869_30994[(1)] = (9));

} else {
var statearr_30871_30995 = state_30835__$1;
(statearr_30871_30995[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (17))){
var state_30835__$1 = state_30835;
var statearr_30873_30997 = state_30835__$1;
(statearr_30873_30997[(2)] = initial_ch);

(statearr_30873_30997[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (3))){
var inst_30832 = (state_30835[(2)]);
var state_30835__$1 = state_30835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30835__$1,inst_30832);
} else {
if((state_val_30836 === (12))){
var inst_30755 = (state_30835[(7)]);
var state_30835__$1 = state_30835;
if(cljs.core.truth_(inst_30755)){
var statearr_30875_31002 = state_30835__$1;
(statearr_30875_31002[(1)] = (16));

} else {
var statearr_30877_31003 = state_30835__$1;
(statearr_30877_31003[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (2))){
var inst_30771 = (state_30835[(12)]);
var inst_30770 = (state_30835[(10)]);
var inst_30770__$1 = open_ch;
var inst_30771__$1 = close_ch;
var inst_30773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30774 = [inst_30770__$1,inst_30771__$1];
var inst_30775 = (new cljs.core.PersistentVector(null,2,(5),inst_30773,inst_30774,null));
var state_30835__$1 = (function (){var statearr_30883 = state_30835;
(statearr_30883[(12)] = inst_30771__$1);

(statearr_30883[(10)] = inst_30770__$1);

return statearr_30883;
})();
return cljs.core.async.ioc_alts_BANG_(state_30835__$1,(4),inst_30775);
} else {
if((state_val_30836 === (19))){
var inst_30778 = (state_30835[(11)]);
var state_30835__$1 = state_30835;
var statearr_30892_31011 = state_30835__$1;
(statearr_30892_31011[(2)] = inst_30778);

(statearr_30892_31011[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (11))){
var inst_30828 = (state_30835[(2)]);
var state_30835__$1 = state_30835;
var statearr_30896_31013 = state_30835__$1;
(statearr_30896_31013[(2)] = inst_30828);

(statearr_30896_31013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (9))){
var inst_30777 = (state_30835[(8)]);
var inst_30804 = (state_30835[(13)]);
var inst_30803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30777,(0),null);
var inst_30804__$1 = chord.client.close_event__GT_maybe_error(inst_30803);
var state_30835__$1 = (function (){var statearr_30897 = state_30835;
(statearr_30897[(13)] = inst_30804__$1);

return statearr_30897;
})();
if(cljs.core.truth_(inst_30804__$1)){
var statearr_30899_31015 = state_30835__$1;
(statearr_30899_31015[(1)] = (12));

} else {
var statearr_30901_31018 = state_30835__$1;
(statearr_30901_31018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (5))){
var inst_30777 = (state_30835[(8)]);
var inst_30787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30777,(0),null);
var inst_30788 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_30789 = [ws_chan];
var inst_30790 = cljs.core.PersistentHashMap.fromArrays(inst_30788,inst_30789);
var state_30835__$1 = (function (){var statearr_30903 = state_30835;
(statearr_30903[(14)] = inst_30787);

return statearr_30903;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30835__$1,(8),initial_ch,inst_30790);
} else {
if((state_val_30836 === (14))){
var inst_30817 = (state_30835[(2)]);
var inst_30818 = cljs.core.async.close_BANG_(ws_chan);
var inst_30819 = cljs.core.async.close_BANG_(initial_ch);
var state_30835__$1 = (function (){var statearr_30905 = state_30835;
(statearr_30905[(15)] = inst_30817);

(statearr_30905[(16)] = inst_30818);

return statearr_30905;
})();
var statearr_30907_31026 = state_30835__$1;
(statearr_30907_31026[(2)] = inst_30819);

(statearr_30907_31026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (16))){
var state_30835__$1 = state_30835;
var statearr_30909_31027 = state_30835__$1;
(statearr_30909_31027[(2)] = read_ch__$1);

(statearr_30909_31027[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (10))){
var inst_30779 = (state_30835[(9)]);
var inst_30822 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30779,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_30835__$1 = state_30835;
if(inst_30822){
var statearr_30911_31030 = state_30835__$1;
(statearr_30911_31030[(1)] = (19));

} else {
var statearr_30912_31031 = state_30835__$1;
(statearr_30912_31031[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30836 === (18))){
var inst_30804 = (state_30835[(13)]);
var inst_30809 = (state_30835[(2)]);
var inst_30810 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30811 = [inst_30804];
var inst_30812 = cljs.core.PersistentHashMap.fromArrays(inst_30810,inst_30811);
var state_30835__$1 = state_30835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30835__$1,(15),inst_30809,inst_30812);
} else {
if((state_val_30836 === (8))){
var inst_30792 = (state_30835[(2)]);
var inst_30793 = cljs.core.async.close_BANG_(initial_ch);
var inst_30755 = true;
var state_30835__$1 = (function (){var statearr_30914 = state_30835;
(statearr_30914[(7)] = inst_30755);

(statearr_30914[(17)] = inst_30792);

(statearr_30914[(18)] = inst_30793);

return statearr_30914;
})();
var statearr_30917_31037 = state_30835__$1;
(statearr_30917_31037[(2)] = null);

(statearr_30917_31037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28253__auto__ = null;
var chord$client$state_machine__28253__auto____0 = (function (){
var statearr_30919 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30919[(0)] = chord$client$state_machine__28253__auto__);

(statearr_30919[(1)] = (1));

return statearr_30919;
});
var chord$client$state_machine__28253__auto____1 = (function (state_30835){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30835);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30920){var ex__28256__auto__ = e30920;
var statearr_30921_31043 = state_30835;
(statearr_30921_31043[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30835[(4)]))){
var statearr_30928_31044 = state_30835;
(statearr_30928_31044[(1)] = cljs.core.first((state_30835[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31046 = state_30835;
state_30835 = G__31046;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
chord$client$state_machine__28253__auto__ = function(state_30835){
switch(arguments.length){
case 0:
return chord$client$state_machine__28253__auto____0.call(this);
case 1:
return chord$client$state_machine__28253__auto____1.call(this,state_30835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28253__auto____0;
chord$client$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28253__auto____1;
return chord$client$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30932 = f__28310__auto__();
(statearr_30932[(6)] = c__28309__auto___30969);

return statearr_30932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq30721){
var G__30722 = cljs.core.first(seq30721);
var seq30721__$1 = cljs.core.next(seq30721);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30722,seq30721__$1);
}));


//# sourceMappingURL=chord.client.js.map
