goog.provide('re_frame.trace');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__52968){
var map__52969 = p__52968;
var map__52969__$1 = cljs.core.__destructure_map(map__52969);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52969__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52969__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52969__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52969__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4160__auto__ = child_of;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__52972_53002 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__52973_53003 = null;
var count__52974_53004 = (0);
var i__52975_53005 = (0);
while(true){
if((i__52975_53005 < count__52974_53004)){
var vec__52987_53006 = chunk__52973_53003.cljs$core$IIndexed$_nth$arity$2(null,i__52975_53005);
var k_53007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52987_53006,(0),null);
var cb_53008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52987_53006,(1),null);
try{var G__52991_53011 = cljs.core.deref(re_frame.trace.traces);
(cb_53008.cljs$core$IFn$_invoke$arity$1 ? cb_53008.cljs$core$IFn$_invoke$arity$1(G__52991_53011) : cb_53008.call(null,G__52991_53011));
}catch (e52990){var e_53012 = e52990;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_53007,"while storing",cljs.core.deref(re_frame.trace.traces),e_53012], 0));
}

var G__53017 = seq__52972_53002;
var G__53018 = chunk__52973_53003;
var G__53019 = count__52974_53004;
var G__53020 = (i__52975_53005 + (1));
seq__52972_53002 = G__53017;
chunk__52973_53003 = G__53018;
count__52974_53004 = G__53019;
i__52975_53005 = G__53020;
continue;
} else {
var temp__5754__auto___53021 = cljs.core.seq(seq__52972_53002);
if(temp__5754__auto___53021){
var seq__52972_53022__$1 = temp__5754__auto___53021;
if(cljs.core.chunked_seq_QMARK_(seq__52972_53022__$1)){
var c__4591__auto___53026 = cljs.core.chunk_first(seq__52972_53022__$1);
var G__53027 = cljs.core.chunk_rest(seq__52972_53022__$1);
var G__53028 = c__4591__auto___53026;
var G__53029 = cljs.core.count(c__4591__auto___53026);
var G__53030 = (0);
seq__52972_53002 = G__53027;
chunk__52973_53003 = G__53028;
count__52974_53004 = G__53029;
i__52975_53005 = G__53030;
continue;
} else {
var vec__52992_53031 = cljs.core.first(seq__52972_53022__$1);
var k_53032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52992_53031,(0),null);
var cb_53033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52992_53031,(1),null);
try{var G__52997_53034 = cljs.core.deref(re_frame.trace.traces);
(cb_53033.cljs$core$IFn$_invoke$arity$1 ? cb_53033.cljs$core$IFn$_invoke$arity$1(G__52997_53034) : cb_53033.call(null,G__52997_53034));
}catch (e52995){var e_53035 = e52995;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_53032,"while storing",cljs.core.deref(re_frame.trace.traces),e_53035], 0));
}

var G__53040 = cljs.core.next(seq__52972_53022__$1);
var G__53041 = null;
var G__53042 = (0);
var G__53043 = (0);
seq__52972_53002 = G__53040;
chunk__52973_53003 = G__53041;
count__52974_53004 = G__53042;
i__52975_53005 = G__53043;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
