goog.provide('lambdaisland.ansi');
/**
 * ASCII escape character (codepoint 27, hex 1b, octal 33).
 */
lambdaisland.ansi.ESC = "\u001B[";
lambdaisland.ansi._EQ_i = cljs.core.identical_QMARK_;
/**
 * Fast string length
 */
lambdaisland.ansi.str_length = (function lambdaisland$ansi$str_length(s){
return s.length;
});
/**
 * Color schemes used in popular applications.
 */
lambdaisland.ansi.color_schemes = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p__52353){
var vec__52354 = p__52353;
var seq__52355 = cljs.core.seq(vec__52354);
var first__52356 = cljs.core.first(seq__52355);
var seq__52355__$1 = cljs.core.next(seq__52355);
var x = first__52356;
var xs = seq__52355__$1;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,cljs.core.vec(xs)], null);
})),cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.mapv,cljs.core.vector,new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"vga","vga",-1367544518),new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"osx","osx",-1758754360),new cljs.core.Keyword(null,"putty","putty",1014121302),new cljs.core.Keyword(null,"mirc","mirc",-2122433283),new cljs.core.Keyword(null,"xterm","xterm",1729060616),new cljs.core.Keyword(null,"ubuntu","ubuntu",-431145217)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1),(1)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(170),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(128),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(194),(54),(33)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(187),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(127),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(205),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(222),(56),(43)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(170),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(128),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(37),(188),(36)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(187),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(147),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(205),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(57),(181),(74)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(170),(85),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(128),(128),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(173),(173),(39)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(187),(187),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(252),(127),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(205),(205),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(199),(6)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(170)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(128)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(73),(46),(225)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(187)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(127)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(238)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(111),(184)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(170),(0),(170)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(128),(0),(128)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(211),(56),(211)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(187),(0),(187)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(156),(0),(156)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(205),(0),(205)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(118),(38),(113)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(170),(170)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(128),(128)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(51),(187),(200)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(187),(187)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(147),(147)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(205),(205)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(44),(181),(233)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(170),(170),(170)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(192),(192),(192)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(203),(204),(205)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(187),(187),(187)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(210),(210),(210)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(229),(229),(229)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(204),(204),(204)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(85),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(128),(128),(128)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(129),(131),(131)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(85),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(127),(127),(127)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(127),(127),(127)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(128),(128),(128)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(85),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(252),(57),(31)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(85),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(0)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(255),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(49),(231),(34)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(255),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(252),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(0)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(234),(236),(35)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(85)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(0)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(0)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(85),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(88),(51),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(85),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(252)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(92),(92),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(255)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(85),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(249),(53),(248)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(85),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(0),(255)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(20),(240),(240)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(85),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(255),(255)], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(233),(235),(235)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(255),(255),(255)], null)], null)], null)));
/**
 * Color scheme currently in use during parsing.
 */
lambdaisland.ansi._STAR_color_scheme_STAR_ = new cljs.core.Keyword(null,"xterm","xterm",1729060616).cljs$core$IFn$_invoke$arity$1(lambdaisland.ansi.color_schemes);
lambdaisland.ansi.get_color = (function lambdaisland$ansi$get_color(n){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rgb","rgb",1432123467)], null),cljs.core.get.cljs$core$IFn$_invoke$arity$2(lambdaisland.ansi._STAR_color_scheme_STAR_,n));
});
lambdaisland.ansi.parse_int = (function lambdaisland$ansi$parse_int(s){
return parseInt(s,(10));
});
lambdaisland.ansi.reset_attrs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"foreground","foreground",499022036),null,new cljs.core.Keyword(null,"background","background",-863952629),null,new cljs.core.Keyword(null,"bold","bold",-116809535),null], null);
/**
 * Given a CSI code, return a map of properties it sets. A value of `nil` means
 *   the property gets unset.
 */
lambdaisland.ansi.code__GT_attrs = (function lambdaisland$ansi$code__GT_attrs(code){
if(cljs.core.truth_((lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2((0),code) : lambdaisland.ansi._EQ_i.call(null,(0),code)))){
return lambdaisland.ansi.reset_attrs;
} else {
if(cljs.core.truth_((lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2((1),code) : lambdaisland.ansi._EQ_i.call(null,(1),code)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bold","bold",-116809535),true], null);
} else {
if(((((30) <= code)) && ((code <= (37))))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"foreground","foreground",499022036),lambdaisland.ansi.get_color((code - (30)))], null);
} else {
if(cljs.core.truth_((lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2((39),code) : lambdaisland.ansi._EQ_i.call(null,(39),code)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"foreground","foreground",499022036),null], null);
} else {
if(((((40) <= code)) && ((code <= (47))))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),lambdaisland.ansi.get_color((code - (40)))], null);
} else {
if(cljs.core.truth_((lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2((49),code) : lambdaisland.ansi._EQ_i.call(null,(49),code)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),null], null);
} else {
if(((((90) <= code)) && ((code <= (99))))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"foreground","foreground",499022036),lambdaisland.ansi.get_color(((8) + (code - (90))))], null);
} else {
if(((((100) <= code)) && ((code <= (109))))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),lambdaisland.ansi.get_color(((8) + (code - (40))))], null);
} else {
return null;
}
}
}
}
}
}
}
}
});
/**
 * Parse a "8-bit" color, given the code that follows on ESC[38;5;<code>m.
 */
lambdaisland.ansi.color_8_bit = (function lambdaisland$ansi$color_8_bit(code){
if(((((0) <= code)) && ((code <= (7))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lambdaisland.ansi.get_color(code),false], null);
} else {
if(((((8) <= code)) && ((code <= (15))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lambdaisland.ansi.get_color((code - (8))),true], null);
} else {
if(((((16) <= code)) && ((code <= (231))))){
var code__$1 = (code - (16));
var blue = cljs.core.mod(code__$1,(6));
var green = cljs.core.mod(((code__$1 - blue) / (6)),(6));
var red = (((code__$1 - blue) - ((6) * green)) / (36));
var color_values = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(95),(135),(175),(215),(255)], null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rgb","rgb",1432123467)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$1(color_values),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [red,green,blue], null)),false], null);
} else {
if(((((232) <= code)) && ((code <= (255))))){
var x = ((8) + ((10) * (code - (232))));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rgb","rgb",1432123467),x,x,x], null),false], null);
} else {
return null;
}
}
}
}
});
lambdaisland.ansi.color_24_bit = (function lambdaisland$ansi$color_24_bit(p__52359){
var vec__52361 = p__52359;
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52361,(0),null);
var g = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52361,(1),null);
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52361,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rgb","rgb",1432123467),r,g,b], null);
});
/**
 * Handle CSI code 38 and 48, used to specify 8 or 24 bit colors. This may consume
 *   up to 5 codes in total (ESC [38;2;r;g;bm). Returns the map of properties that
 *   get set, and the remaining, unconsumed codes.
 */
lambdaisland.ansi.parse_color = (function lambdaisland$ansi$parse_color(fg_or_bg,p__52365){
var vec__52366 = p__52365;
var seq__52367 = cljs.core.seq(vec__52366);
var first__52368 = cljs.core.first(seq__52367);
var seq__52367__$1 = cljs.core.next(seq__52367);
var colorspace = first__52368;
var more = seq__52367__$1;
var type = (function (){var G__52369 = fg_or_bg;
switch (G__52369) {
case (38):
return new cljs.core.Keyword(null,"foreground","foreground",499022036);

break;
case (48):
return new cljs.core.Keyword(null,"background","background",-863952629);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52369)].join('')));

}
})();
var G__52370 = colorspace;
switch (G__52370) {
case (5):
var vec__52372 = lambdaisland.ansi.color_8_bit(cljs.core.first(more));
var color = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52372,(0),null);
var bold_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52372,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.PersistentArrayMap.createAsIfByAssoc([type,color]),(cljs.core.truth_(bold_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bold","bold",-116809535),true], null):null)], 0)),cljs.core.next(more)], null);

break;
case (2):
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"foreground","foreground",499022036),lambdaisland.ansi.color_24_bit(cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),more))], null),cljs.core.nthnext(more,(3))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52370)].join('')));

}
});
/**
 * Like clojure.string/split, but uses a single character instead of a regex,
 *   allowing for faster operation.
 */
lambdaisland.ansi.str_split = (function lambdaisland$ansi$str_split(s,sep){
var res = cljs.core.PersistentVector.EMPTY;
var start = (0);
var end = s.indexOf(sep);
while(true){
if(cljs.core.truth_((lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2(end,(-1)) : lambdaisland.ansi._EQ_i.call(null,end,(-1))))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res,s.substring(start));
} else {
var G__52480 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res,s.substring(start,end));
var G__52481 = (end + (1));
var G__52482 = s.indexOf(sep,(end + (1)));
res = G__52480;
start = G__52481;
end = G__52482;
continue;
}
break;
}
});
/**
 * Given a CSI specifier, excluding ESC[ but including the final "m", convert it
 *   to a map of properties that it sets or unsets. Property values of nil indicate
 *   a reset/unset. 
 */
lambdaisland.ansi.csi__GT_attrs = (function lambdaisland$ansi$csi__GT_attrs(csi){
if(cljs.core.truth_(csi.endsWith("m"))){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(csi,"m")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(csi,"0m")))){
return lambdaisland.ansi.reset_attrs;
} else {
var csi_len = lambdaisland.ansi.str_length(csi);
var G__52380 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(lambdaisland.ansi.parse_int,lambdaisland.ansi.str_split(csi.substring((0),(lambdaisland.ansi.str_length(csi) - (1))),";"));
var vec__52381 = G__52380;
var seq__52382 = cljs.core.seq(vec__52381);
var first__52383 = cljs.core.first(seq__52382);
var seq__52382__$1 = cljs.core.next(seq__52382);
var code = first__52383;
var codes = seq__52382__$1;
var result = cljs.core.PersistentArrayMap.EMPTY;
var G__52380__$1 = G__52380;
var result__$1 = result;
while(true){
var vec__52392 = G__52380__$1;
var seq__52393 = cljs.core.seq(vec__52392);
var first__52394 = cljs.core.first(seq__52393);
var seq__52393__$1 = cljs.core.next(seq__52393);
var code__$1 = first__52394;
var codes__$1 = seq__52393__$1;
var result__$2 = result__$1;
if(cljs.core.truth_(code__$1)){
if(cljs.core.truth_((function (){var or__4160__auto__ = (lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2((38),code__$1) : lambdaisland.ansi._EQ_i.call(null,(38),code__$1));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2 ? lambdaisland.ansi._EQ_i.cljs$core$IFn$_invoke$arity$2((48),code__$1) : lambdaisland.ansi._EQ_i.call(null,(48),code__$1));
}
})())){
var vec__52395 = lambdaisland.ansi.parse_color(code__$1,codes__$1);
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52395,(0),null);
var codes__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52395,(1),null);
var G__52489 = codes__$2;
var G__52490 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([result__$2,res], 0));
G__52380__$1 = G__52489;
result__$1 = G__52490;
continue;
} else {
var G__52491 = codes__$1;
var G__52492 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([result__$2,lambdaisland.ansi.code__GT_attrs(code__$1)], 0));
G__52380__$1 = G__52491;
result__$1 = G__52492;
continue;
}
} else {
return result__$2;
}
break;
}
}
} else {
return null;
}
});
/**
 * Efficient check to see if a string contains an escape character.
 */
lambdaisland.ansi.has_escape_char_QMARK_ = (function lambdaisland$ansi$has_escape_char_QMARK_(s){
return s.includes(lambdaisland.ansi.ESC);
});
/**
 * Starting at position pos, move forward as long as the characters at the current
 *   position are within the given range. Returns the new position.
 */
lambdaisland.ansi.str_scan = (function lambdaisland$ansi$str_scan(pos,s,min,max){
var len = lambdaisland.ansi.str_length(s);
var pos__$1 = pos;
while(true){
if((pos__$1 >= len)){
return pos__$1;
} else {
var ch = s.codePointAt(pos__$1);
if((((min <= ch)) && ((ch <= max)))){
var G__52497 = (pos__$1 + (1));
pos__$1 = G__52497;
continue;
} else {
return pos__$1;
}
}
break;
}
});
/**
 * Split a string on the next escape sequence, returning a [head CSI tail]
 *   triplet. The returned CSI is excluding ESC[.
 */
lambdaisland.ansi.next_csi = (function lambdaisland$ansi$next_csi(var_args){
var G__52406 = arguments.length;
switch (G__52406) {
case 1:
return lambdaisland.ansi.next_csi.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return lambdaisland.ansi.next_csi.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(lambdaisland.ansi.next_csi.cljs$core$IFn$_invoke$arity$1 = (function (s){
return lambdaisland.ansi.next_csi.cljs$core$IFn$_invoke$arity$2(s,(0));
}));

(lambdaisland.ansi.next_csi.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
while(true){
var esc_pos = s.indexOf(lambdaisland.ansi.ESC,start);
if((esc_pos === (-1))){
return null;
} else {
var pos = lambdaisland.ansi.str_scan(lambdaisland.ansi.str_scan((esc_pos + (2)),s,(48),(63)),s,(32),(47));
if(((((1) < pos)) && ((pos < lambdaisland.ansi.str_length(s))))){
if(((((64) <= s.codePointAt(pos))) && ((s.codePointAt(pos) <= (126))))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [s.substring((0),esc_pos),s.substring(((2) + esc_pos),(pos + (1))),s.substring((pos + (1)))], null);
} else {
var G__52504 = s;
var G__52505 = pos;
s = G__52504;
start = G__52505;
continue;
}
} else {
return null;
}
}
break;
}
}));

(lambdaisland.ansi.next_csi.cljs$lang$maxFixedArity = 2);

/**
 * Tokenize a string, whereby each CSI sequence gets transformed into a map of
 *   properties. The result is a vector of strings and maps.
 */
lambdaisland.ansi.token_stream = (function lambdaisland$ansi$token_stream(string){
var input = string;
var result = cljs.core.PersistentVector.EMPTY;
while(true){
if(cljs.core.truth_(lambdaisland.ansi.has_escape_char_QMARK_(input))){
var temp__5752__auto__ = lambdaisland.ansi.next_csi.cljs$core$IFn$_invoke$arity$1(input);
if(cljs.core.truth_(temp__5752__auto__)){
var match = temp__5752__auto__;
var vec__52416 = match;
var start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52416,(0),null);
var csi = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52416,(1),null);
var tail = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52416,(2),null);
var G__52509 = tail;
var G__52510 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var G__52419 = result;
if(cljs.core.seq(start)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__52419,start);
} else {
return G__52419;
}
})(),lambdaisland.ansi.csi__GT_attrs(csi));
input = G__52509;
result = G__52510;
continue;
} else {
var G__52420 = result;
if(cljs.core.seq(input)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__52420,input);
} else {
return G__52420;
}
}
} else {
var G__52421 = result;
if(cljs.core.seq(input)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__52421,input);
} else {
return G__52421;
}
}
break;
}
});
/**
 * Stateful transducer, apply it over the output of token-stream to know which
 *   styling should be applied over each piece of text.
 * 
 *   The results are pairs consisting of a property map and a string.
 */
lambdaisland.ansi.apply_props = (function lambdaisland$ansi$apply_props(rf){
var state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return (function() {
var G__52514 = null;
var G__52514__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__52514__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__52514__2 = (function (res,val){
if(cljs.core.map_QMARK_(val)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__52422_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.second)),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p1__52422_SHARP_,val], 0)));
}));
} else {
}

if(typeof val === 'string'){
var G__52424 = res;
var G__52425 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(state),val], null);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__52424,G__52425) : rf.call(null,G__52424,G__52425));
} else {
return res;
}
});
G__52514 = function(res,val){
switch(arguments.length){
case 0:
return G__52514__0.call(this);
case 1:
return G__52514__1.call(this,res);
case 2:
return G__52514__2.call(this,res,val);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__52514.cljs$core$IFn$_invoke$arity$0 = G__52514__0;
G__52514.cljs$core$IFn$_invoke$arity$1 = G__52514__1;
G__52514.cljs$core$IFn$_invoke$arity$2 = G__52514__2;
return G__52514;
})()
});
lambdaisland.ansi.rgb__GT_css = (function lambdaisland$ansi$rgb__GT_css(p__52426){
var vec__52427 = p__52426;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52427,(0),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52427,(1),null);
var g = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52427,(2),null);
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52427,(3),null);
return ["rgb(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(r),",",cljs.core.str.cljs$core$IFn$_invoke$arity$1(g),",",cljs.core.str.cljs$core$IFn$_invoke$arity$1(b),")"].join('');
});
lambdaisland.ansi.chunk__GT_hiccup = (function lambdaisland$ansi$chunk__GT_hiccup(p__52433){
var vec__52434 = p__52433;
var map__52438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52434,(0),null);
var map__52438__$1 = cljs.core.__destructure_map(map__52438);
var props = map__52438__$1;
var foreground = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52438__$1,new cljs.core.Keyword(null,"foreground","foreground",499022036));
var background = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52438__$1,new cljs.core.Keyword(null,"background","background",-863952629));
var bold = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52438__$1,new cljs.core.Keyword(null,"bold","bold",-116809535));
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52434,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),((cljs.core.seq(props))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),(function (){var G__52442 = cljs.core.PersistentArrayMap.EMPTY;
var G__52442__$1 = (cljs.core.truth_(foreground)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__52442,new cljs.core.Keyword(null,"color","color",1011675173),lambdaisland.ansi.rgb__GT_css(foreground)):G__52442);
var G__52442__$2 = (cljs.core.truth_(background)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__52442__$1,new cljs.core.Keyword(null,"background-color","background-color",570434026),lambdaisland.ansi.rgb__GT_css(background)):G__52442__$1);
if(cljs.core.truth_(bold)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__52442__$2,new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),"bold");
} else {
return G__52442__$2;
}
})()], null):cljs.core.PersistentArrayMap.EMPTY),text], null);
});
/**
 * Transducer that consumes strings of input, and produces hiccup elements. Useful
 *   when dealing with streaming input, since it will carry over the 'terminal
 *   state'.
 */
lambdaisland.ansi.hiccup_xform = cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(lambdaisland.ansi.token_stream),lambdaisland.ansi.apply_props,cljs.core.map.cljs$core$IFn$_invoke$arity$1(lambdaisland.ansi.chunk__GT_hiccup));
/**
 * Convenience function for the basic case where you have a string of terminal
 *   output and want to turn it into hiccup. Returns a seq of [:span] elements.
 */
lambdaisland.ansi.text__GT_hiccup = (function lambdaisland$ansi$text__GT_hiccup(text){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(lambdaisland.ansi.apply_props,cljs.core.map.cljs$core$IFn$_invoke$arity$1(lambdaisland.ansi.chunk__GT_hiccup)),lambdaisland.ansi.token_stream(text));
});

//# sourceMappingURL=lambdaisland.ansi.js.map
