goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__43557 = arguments.length;
switch (G__43557) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43560 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43560 = (function (f,blockable,meta43561){
this.f = f;
this.blockable = blockable;
this.meta43561 = meta43561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43562,meta43561__$1){
var self__ = this;
var _43562__$1 = this;
return (new cljs.core.async.t_cljs$core$async43560(self__.f,self__.blockable,meta43561__$1));
}));

(cljs.core.async.t_cljs$core$async43560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43562){
var self__ = this;
var _43562__$1 = this;
return self__.meta43561;
}));

(cljs.core.async.t_cljs$core$async43560.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43560.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43560.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async43560.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async43560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta43561","meta43561",811554188,null)], null);
}));

(cljs.core.async.t_cljs$core$async43560.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43560.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43560");

(cljs.core.async.t_cljs$core$async43560.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async43560");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43560.
 */
cljs.core.async.__GT_t_cljs$core$async43560 = (function cljs$core$async$__GT_t_cljs$core$async43560(f__$1,blockable__$1,meta43561){
return (new cljs.core.async.t_cljs$core$async43560(f__$1,blockable__$1,meta43561));
});

}

return (new cljs.core.async.t_cljs$core$async43560(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__43588 = arguments.length;
switch (G__43588) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__43597 = arguments.length;
switch (G__43597) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__43606 = arguments.length;
switch (G__43606) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_46171 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46171) : fn1.call(null,val_46171));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_46171) : fn1.call(null,val_46171));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__43617 = arguments.length;
switch (G__43617) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5752__auto__)){
var ret = temp__5752__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5752__auto__)){
var retb = temp__5752__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4648__auto___46192 = n;
var x_46193 = (0);
while(true){
if((x_46193 < n__4648__auto___46192)){
(a[x_46193] = x_46193);

var G__46194 = (x_46193 + (1));
x_46193 = G__46194;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43637 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43637 = (function (flag,meta43638){
this.flag = flag;
this.meta43638 = meta43638;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43637.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43639,meta43638__$1){
var self__ = this;
var _43639__$1 = this;
return (new cljs.core.async.t_cljs$core$async43637(self__.flag,meta43638__$1));
}));

(cljs.core.async.t_cljs$core$async43637.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43639){
var self__ = this;
var _43639__$1 = this;
return self__.meta43638;
}));

(cljs.core.async.t_cljs$core$async43637.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43637.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43637.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43637.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async43637.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta43638","meta43638",1224892076,null)], null);
}));

(cljs.core.async.t_cljs$core$async43637.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43637.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43637");

(cljs.core.async.t_cljs$core$async43637.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async43637");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43637.
 */
cljs.core.async.__GT_t_cljs$core$async43637 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async43637(flag__$1,meta43638){
return (new cljs.core.async.t_cljs$core$async43637(flag__$1,meta43638));
});

}

return (new cljs.core.async.t_cljs$core$async43637(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async43651 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async43651 = (function (flag,cb,meta43652){
this.flag = flag;
this.cb = cb;
this.meta43652 = meta43652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async43651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43653,meta43652__$1){
var self__ = this;
var _43653__$1 = this;
return (new cljs.core.async.t_cljs$core$async43651(self__.flag,self__.cb,meta43652__$1));
}));

(cljs.core.async.t_cljs$core$async43651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43653){
var self__ = this;
var _43653__$1 = this;
return self__.meta43652;
}));

(cljs.core.async.t_cljs$core$async43651.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async43651.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async43651.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async43651.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async43651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta43652","meta43652",483991918,null)], null);
}));

(cljs.core.async.t_cljs$core$async43651.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async43651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async43651");

(cljs.core.async.t_cljs$core$async43651.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async43651");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async43651.
 */
cljs.core.async.__GT_t_cljs$core$async43651 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async43651(flag__$1,cb__$1,meta43652){
return (new cljs.core.async.t_cljs$core$async43651(flag__$1,cb__$1,meta43652));
});

}

return (new cljs.core.async.t_cljs$core$async43651(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43696_SHARP_){
var G__43698 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43696_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43698) : fret.call(null,G__43698));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__43697_SHARP_){
var G__43699 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__43697_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__43699) : fret.call(null,G__43699));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4160__auto__ = wport;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46231 = (i + (1));
i = G__46231;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4160__auto__ = ret;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5754__auto__ = (function (){var and__4149__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4149__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5754__auto__)){
var got = temp__5754__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___46241 = arguments.length;
var i__4772__auto___46242 = (0);
while(true){
if((i__4772__auto___46242 < len__4771__auto___46241)){
args__4777__auto__.push((arguments[i__4772__auto___46242]));

var G__46243 = (i__4772__auto___46242 + (1));
i__4772__auto___46242 = G__46243;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__43704){
var map__43705 = p__43704;
var map__43705__$1 = cljs.core.__destructure_map(map__43705);
var opts = map__43705__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq43702){
var G__43703 = cljs.core.first(seq43702);
var seq43702__$1 = cljs.core.next(seq43702);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43703,seq43702__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__43711 = arguments.length;
switch (G__43711) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43458__auto___46247 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_43739){
var state_val_43740 = (state_43739[(1)]);
if((state_val_43740 === (7))){
var inst_43735 = (state_43739[(2)]);
var state_43739__$1 = state_43739;
var statearr_43750_46250 = state_43739__$1;
(statearr_43750_46250[(2)] = inst_43735);

(statearr_43750_46250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (1))){
var state_43739__$1 = state_43739;
var statearr_43751_46251 = state_43739__$1;
(statearr_43751_46251[(2)] = null);

(statearr_43751_46251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (4))){
var inst_43718 = (state_43739[(7)]);
var inst_43718__$1 = (state_43739[(2)]);
var inst_43719 = (inst_43718__$1 == null);
var state_43739__$1 = (function (){var statearr_43752 = state_43739;
(statearr_43752[(7)] = inst_43718__$1);

return statearr_43752;
})();
if(cljs.core.truth_(inst_43719)){
var statearr_43753_46257 = state_43739__$1;
(statearr_43753_46257[(1)] = (5));

} else {
var statearr_43754_46258 = state_43739__$1;
(statearr_43754_46258[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (13))){
var state_43739__$1 = state_43739;
var statearr_43755_46259 = state_43739__$1;
(statearr_43755_46259[(2)] = null);

(statearr_43755_46259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (6))){
var inst_43718 = (state_43739[(7)]);
var state_43739__$1 = state_43739;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43739__$1,(11),to,inst_43718);
} else {
if((state_val_43740 === (3))){
var inst_43737 = (state_43739[(2)]);
var state_43739__$1 = state_43739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43739__$1,inst_43737);
} else {
if((state_val_43740 === (12))){
var state_43739__$1 = state_43739;
var statearr_43760_46261 = state_43739__$1;
(statearr_43760_46261[(2)] = null);

(statearr_43760_46261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (2))){
var state_43739__$1 = state_43739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43739__$1,(4),from);
} else {
if((state_val_43740 === (11))){
var inst_43728 = (state_43739[(2)]);
var state_43739__$1 = state_43739;
if(cljs.core.truth_(inst_43728)){
var statearr_43761_46264 = state_43739__$1;
(statearr_43761_46264[(1)] = (12));

} else {
var statearr_43762_46265 = state_43739__$1;
(statearr_43762_46265[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (9))){
var state_43739__$1 = state_43739;
var statearr_43763_46267 = state_43739__$1;
(statearr_43763_46267[(2)] = null);

(statearr_43763_46267[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (5))){
var state_43739__$1 = state_43739;
if(cljs.core.truth_(close_QMARK_)){
var statearr_43764_46268 = state_43739__$1;
(statearr_43764_46268[(1)] = (8));

} else {
var statearr_43765_46269 = state_43739__$1;
(statearr_43765_46269[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (14))){
var inst_43733 = (state_43739[(2)]);
var state_43739__$1 = state_43739;
var statearr_43766_46272 = state_43739__$1;
(statearr_43766_46272[(2)] = inst_43733);

(statearr_43766_46272[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (10))){
var inst_43725 = (state_43739[(2)]);
var state_43739__$1 = state_43739;
var statearr_43767_46276 = state_43739__$1;
(statearr_43767_46276[(2)] = inst_43725);

(statearr_43767_46276[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43740 === (8))){
var inst_43722 = cljs.core.async.close_BANG_(to);
var state_43739__$1 = state_43739;
var statearr_43768_46277 = state_43739__$1;
(statearr_43768_46277[(2)] = inst_43722);

(statearr_43768_46277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_43772 = [null,null,null,null,null,null,null,null];
(statearr_43772[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_43772[(1)] = (1));

return statearr_43772;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_43739){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_43739);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e43774){var ex__43208__auto__ = e43774;
var statearr_43778_46280 = state_43739;
(statearr_43778_46280[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_43739[(4)]))){
var statearr_43780_46282 = state_43739;
(statearr_43780_46282[(1)] = cljs.core.first((state_43739[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46284 = state_43739;
state_43739 = G__46284;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_43739){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_43739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_43786 = f__43459__auto__();
(statearr_43786[(6)] = c__43458__auto___46247);

return statearr_43786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__43794){
var vec__43795 = p__43794;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43795,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43795,(1),null);
var job = vec__43795;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43458__auto___46292 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_43802){
var state_val_43803 = (state_43802[(1)]);
if((state_val_43803 === (1))){
var state_43802__$1 = state_43802;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43802__$1,(2),res,v);
} else {
if((state_val_43803 === (2))){
var inst_43799 = (state_43802[(2)]);
var inst_43800 = cljs.core.async.close_BANG_(res);
var state_43802__$1 = (function (){var statearr_43804 = state_43802;
(statearr_43804[(7)] = inst_43799);

return statearr_43804;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43802__$1,inst_43800);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0 = (function (){
var statearr_43806 = [null,null,null,null,null,null,null,null];
(statearr_43806[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__);

(statearr_43806[(1)] = (1));

return statearr_43806;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1 = (function (state_43802){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_43802);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e43810){var ex__43208__auto__ = e43810;
var statearr_43811_46304 = state_43802;
(statearr_43811_46304[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_43802[(4)]))){
var statearr_43812_46306 = state_43802;
(statearr_43812_46306[(1)] = cljs.core.first((state_43802[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46309 = state_43802;
state_43802 = G__46309;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = function(state_43802){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1.call(this,state_43802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_43813 = f__43459__auto__();
(statearr_43813[(6)] = c__43458__auto___46292);

return statearr_43813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__43814){
var vec__43815 = p__43814;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43815,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43815,(1),null);
var job = vec__43815;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4648__auto___46312 = n;
var __46313 = (0);
while(true){
if((__46313 < n__4648__auto___46312)){
var G__43819_46314 = type;
var G__43819_46315__$1 = (((G__43819_46314 instanceof cljs.core.Keyword))?G__43819_46314.fqn:null);
switch (G__43819_46315__$1) {
case "compute":
var c__43458__auto___46317 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46313,c__43458__auto___46317,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async){
return (function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = ((function (__46313,c__43458__auto___46317,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async){
return (function (state_43836){
var state_val_43837 = (state_43836[(1)]);
if((state_val_43837 === (1))){
var state_43836__$1 = state_43836;
var statearr_43841_46319 = state_43836__$1;
(statearr_43841_46319[(2)] = null);

(statearr_43841_46319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (2))){
var state_43836__$1 = state_43836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43836__$1,(4),jobs);
} else {
if((state_val_43837 === (3))){
var inst_43834 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43836__$1,inst_43834);
} else {
if((state_val_43837 === (4))){
var inst_43826 = (state_43836[(2)]);
var inst_43827 = process(inst_43826);
var state_43836__$1 = state_43836;
if(cljs.core.truth_(inst_43827)){
var statearr_43842_46322 = state_43836__$1;
(statearr_43842_46322[(1)] = (5));

} else {
var statearr_43843_46323 = state_43836__$1;
(statearr_43843_46323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (5))){
var state_43836__$1 = state_43836;
var statearr_43844_46325 = state_43836__$1;
(statearr_43844_46325[(2)] = null);

(statearr_43844_46325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (6))){
var state_43836__$1 = state_43836;
var statearr_43845_46327 = state_43836__$1;
(statearr_43845_46327[(2)] = null);

(statearr_43845_46327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43837 === (7))){
var inst_43832 = (state_43836[(2)]);
var state_43836__$1 = state_43836;
var statearr_43848_46328 = state_43836__$1;
(statearr_43848_46328[(2)] = inst_43832);

(statearr_43848_46328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46313,c__43458__auto___46317,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async))
;
return ((function (__46313,switch__43204__auto__,c__43458__auto___46317,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0 = (function (){
var statearr_43854 = [null,null,null,null,null,null,null];
(statearr_43854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__);

(statearr_43854[(1)] = (1));

return statearr_43854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1 = (function (state_43836){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_43836);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e43855){var ex__43208__auto__ = e43855;
var statearr_43856_46336 = state_43836;
(statearr_43856_46336[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_43836[(4)]))){
var statearr_43857_46337 = state_43836;
(statearr_43857_46337[(1)] = cljs.core.first((state_43836[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46340 = state_43836;
state_43836 = G__46340;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = function(state_43836){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1.call(this,state_43836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__;
})()
;})(__46313,switch__43204__auto__,c__43458__auto___46317,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async))
})();
var state__43460__auto__ = (function (){var statearr_43858 = f__43459__auto__();
(statearr_43858[(6)] = c__43458__auto___46317);

return statearr_43858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
});})(__46313,c__43458__auto___46317,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async))
);


break;
case "async":
var c__43458__auto___46342 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__46313,c__43458__auto___46342,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async){
return (function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = ((function (__46313,c__43458__auto___46342,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async){
return (function (state_43875){
var state_val_43876 = (state_43875[(1)]);
if((state_val_43876 === (1))){
var state_43875__$1 = state_43875;
var statearr_43887_46347 = state_43875__$1;
(statearr_43887_46347[(2)] = null);

(statearr_43887_46347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43876 === (2))){
var state_43875__$1 = state_43875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43875__$1,(4),jobs);
} else {
if((state_val_43876 === (3))){
var inst_43870 = (state_43875[(2)]);
var state_43875__$1 = state_43875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43875__$1,inst_43870);
} else {
if((state_val_43876 === (4))){
var inst_43862 = (state_43875[(2)]);
var inst_43863 = async(inst_43862);
var state_43875__$1 = state_43875;
if(cljs.core.truth_(inst_43863)){
var statearr_43900_46372 = state_43875__$1;
(statearr_43900_46372[(1)] = (5));

} else {
var statearr_43901_46379 = state_43875__$1;
(statearr_43901_46379[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43876 === (5))){
var state_43875__$1 = state_43875;
var statearr_43908_46380 = state_43875__$1;
(statearr_43908_46380[(2)] = null);

(statearr_43908_46380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43876 === (6))){
var state_43875__$1 = state_43875;
var statearr_43912_46382 = state_43875__$1;
(statearr_43912_46382[(2)] = null);

(statearr_43912_46382[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43876 === (7))){
var inst_43868 = (state_43875[(2)]);
var state_43875__$1 = state_43875;
var statearr_43913_46383 = state_43875__$1;
(statearr_43913_46383[(2)] = inst_43868);

(statearr_43913_46383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46313,c__43458__auto___46342,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async))
;
return ((function (__46313,switch__43204__auto__,c__43458__auto___46342,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0 = (function (){
var statearr_43917 = [null,null,null,null,null,null,null];
(statearr_43917[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__);

(statearr_43917[(1)] = (1));

return statearr_43917;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1 = (function (state_43875){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_43875);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e43918){var ex__43208__auto__ = e43918;
var statearr_43919_46385 = state_43875;
(statearr_43919_46385[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_43875[(4)]))){
var statearr_43932_46391 = state_43875;
(statearr_43932_46391[(1)] = cljs.core.first((state_43875[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46392 = state_43875;
state_43875 = G__46392;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = function(state_43875){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1.call(this,state_43875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__;
})()
;})(__46313,switch__43204__auto__,c__43458__auto___46342,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async))
})();
var state__43460__auto__ = (function (){var statearr_43933 = f__43459__auto__();
(statearr_43933[(6)] = c__43458__auto___46342);

return statearr_43933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
});})(__46313,c__43458__auto___46342,G__43819_46314,G__43819_46315__$1,n__4648__auto___46312,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43819_46315__$1)].join('')));

}

var G__46394 = (__46313 + (1));
__46313 = G__46394;
continue;
} else {
}
break;
}

var c__43458__auto___46395 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_43958){
var state_val_43959 = (state_43958[(1)]);
if((state_val_43959 === (7))){
var inst_43954 = (state_43958[(2)]);
var state_43958__$1 = state_43958;
var statearr_43963_46396 = state_43958__$1;
(statearr_43963_46396[(2)] = inst_43954);

(statearr_43963_46396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43959 === (1))){
var state_43958__$1 = state_43958;
var statearr_43964_46400 = state_43958__$1;
(statearr_43964_46400[(2)] = null);

(statearr_43964_46400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43959 === (4))){
var inst_43937 = (state_43958[(7)]);
var inst_43937__$1 = (state_43958[(2)]);
var inst_43939 = (inst_43937__$1 == null);
var state_43958__$1 = (function (){var statearr_43965 = state_43958;
(statearr_43965[(7)] = inst_43937__$1);

return statearr_43965;
})();
if(cljs.core.truth_(inst_43939)){
var statearr_43966_46402 = state_43958__$1;
(statearr_43966_46402[(1)] = (5));

} else {
var statearr_43967_46404 = state_43958__$1;
(statearr_43967_46404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43959 === (6))){
var inst_43937 = (state_43958[(7)]);
var inst_43944 = (state_43958[(8)]);
var inst_43944__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_43945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43946 = [inst_43937,inst_43944__$1];
var inst_43947 = (new cljs.core.PersistentVector(null,2,(5),inst_43945,inst_43946,null));
var state_43958__$1 = (function (){var statearr_43971 = state_43958;
(statearr_43971[(8)] = inst_43944__$1);

return statearr_43971;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43958__$1,(8),jobs,inst_43947);
} else {
if((state_val_43959 === (3))){
var inst_43956 = (state_43958[(2)]);
var state_43958__$1 = state_43958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43958__$1,inst_43956);
} else {
if((state_val_43959 === (2))){
var state_43958__$1 = state_43958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43958__$1,(4),from);
} else {
if((state_val_43959 === (9))){
var inst_43951 = (state_43958[(2)]);
var state_43958__$1 = (function (){var statearr_43972 = state_43958;
(statearr_43972[(9)] = inst_43951);

return statearr_43972;
})();
var statearr_43973_46405 = state_43958__$1;
(statearr_43973_46405[(2)] = null);

(statearr_43973_46405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43959 === (5))){
var inst_43941 = cljs.core.async.close_BANG_(jobs);
var state_43958__$1 = state_43958;
var statearr_43974_46410 = state_43958__$1;
(statearr_43974_46410[(2)] = inst_43941);

(statearr_43974_46410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43959 === (8))){
var inst_43944 = (state_43958[(8)]);
var inst_43949 = (state_43958[(2)]);
var state_43958__$1 = (function (){var statearr_43975 = state_43958;
(statearr_43975[(10)] = inst_43949);

return statearr_43975;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43958__$1,(9),results,inst_43944);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0 = (function (){
var statearr_43976 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43976[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__);

(statearr_43976[(1)] = (1));

return statearr_43976;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1 = (function (state_43958){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_43958);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e43977){var ex__43208__auto__ = e43977;
var statearr_43978_46420 = state_43958;
(statearr_43978_46420[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_43958[(4)]))){
var statearr_43979_46424 = state_43958;
(statearr_43979_46424[(1)] = cljs.core.first((state_43958[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46425 = state_43958;
state_43958 = G__46425;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = function(state_43958){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1.call(this,state_43958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_43980 = f__43459__auto__();
(statearr_43980[(6)] = c__43458__auto___46395);

return statearr_43980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


var c__43458__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_44032){
var state_val_44033 = (state_44032[(1)]);
if((state_val_44033 === (7))){
var inst_44028 = (state_44032[(2)]);
var state_44032__$1 = state_44032;
var statearr_44034_46430 = state_44032__$1;
(statearr_44034_46430[(2)] = inst_44028);

(statearr_44034_46430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (20))){
var state_44032__$1 = state_44032;
var statearr_44036_46431 = state_44032__$1;
(statearr_44036_46431[(2)] = null);

(statearr_44036_46431[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (1))){
var state_44032__$1 = state_44032;
var statearr_44037_46436 = state_44032__$1;
(statearr_44037_46436[(2)] = null);

(statearr_44037_46436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (4))){
var inst_43984 = (state_44032[(7)]);
var inst_43984__$1 = (state_44032[(2)]);
var inst_43985 = (inst_43984__$1 == null);
var state_44032__$1 = (function (){var statearr_44038 = state_44032;
(statearr_44038[(7)] = inst_43984__$1);

return statearr_44038;
})();
if(cljs.core.truth_(inst_43985)){
var statearr_44039_46440 = state_44032__$1;
(statearr_44039_46440[(1)] = (5));

} else {
var statearr_44040_46441 = state_44032__$1;
(statearr_44040_46441[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (15))){
var inst_44003 = (state_44032[(8)]);
var state_44032__$1 = state_44032;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44032__$1,(18),to,inst_44003);
} else {
if((state_val_44033 === (21))){
var inst_44023 = (state_44032[(2)]);
var state_44032__$1 = state_44032;
var statearr_44041_46446 = state_44032__$1;
(statearr_44041_46446[(2)] = inst_44023);

(statearr_44041_46446[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (13))){
var inst_44025 = (state_44032[(2)]);
var state_44032__$1 = (function (){var statearr_44042 = state_44032;
(statearr_44042[(9)] = inst_44025);

return statearr_44042;
})();
var statearr_44043_46450 = state_44032__$1;
(statearr_44043_46450[(2)] = null);

(statearr_44043_46450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (6))){
var inst_43984 = (state_44032[(7)]);
var state_44032__$1 = state_44032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44032__$1,(11),inst_43984);
} else {
if((state_val_44033 === (17))){
var inst_44018 = (state_44032[(2)]);
var state_44032__$1 = state_44032;
if(cljs.core.truth_(inst_44018)){
var statearr_44044_46451 = state_44032__$1;
(statearr_44044_46451[(1)] = (19));

} else {
var statearr_44045_46455 = state_44032__$1;
(statearr_44045_46455[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (3))){
var inst_44030 = (state_44032[(2)]);
var state_44032__$1 = state_44032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44032__$1,inst_44030);
} else {
if((state_val_44033 === (12))){
var inst_43998 = (state_44032[(10)]);
var state_44032__$1 = state_44032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44032__$1,(14),inst_43998);
} else {
if((state_val_44033 === (2))){
var state_44032__$1 = state_44032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44032__$1,(4),results);
} else {
if((state_val_44033 === (19))){
var state_44032__$1 = state_44032;
var statearr_44049_46460 = state_44032__$1;
(statearr_44049_46460[(2)] = null);

(statearr_44049_46460[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (11))){
var inst_43998 = (state_44032[(2)]);
var state_44032__$1 = (function (){var statearr_44054 = state_44032;
(statearr_44054[(10)] = inst_43998);

return statearr_44054;
})();
var statearr_44055_46462 = state_44032__$1;
(statearr_44055_46462[(2)] = null);

(statearr_44055_46462[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (9))){
var state_44032__$1 = state_44032;
var statearr_44056_46463 = state_44032__$1;
(statearr_44056_46463[(2)] = null);

(statearr_44056_46463[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (5))){
var state_44032__$1 = state_44032;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44058_46466 = state_44032__$1;
(statearr_44058_46466[(1)] = (8));

} else {
var statearr_44059_46467 = state_44032__$1;
(statearr_44059_46467[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (14))){
var inst_44003 = (state_44032[(8)]);
var inst_44003__$1 = (state_44032[(2)]);
var inst_44011 = (inst_44003__$1 == null);
var inst_44012 = cljs.core.not(inst_44011);
var state_44032__$1 = (function (){var statearr_44061 = state_44032;
(statearr_44061[(8)] = inst_44003__$1);

return statearr_44061;
})();
if(inst_44012){
var statearr_44063_46470 = state_44032__$1;
(statearr_44063_46470[(1)] = (15));

} else {
var statearr_44065_46471 = state_44032__$1;
(statearr_44065_46471[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (16))){
var state_44032__$1 = state_44032;
var statearr_44067_46472 = state_44032__$1;
(statearr_44067_46472[(2)] = false);

(statearr_44067_46472[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (10))){
var inst_43995 = (state_44032[(2)]);
var state_44032__$1 = state_44032;
var statearr_44068_46473 = state_44032__$1;
(statearr_44068_46473[(2)] = inst_43995);

(statearr_44068_46473[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (18))){
var inst_44015 = (state_44032[(2)]);
var state_44032__$1 = state_44032;
var statearr_44069_46477 = state_44032__$1;
(statearr_44069_46477[(2)] = inst_44015);

(statearr_44069_46477[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44033 === (8))){
var inst_43992 = cljs.core.async.close_BANG_(to);
var state_44032__$1 = state_44032;
var statearr_44070_46478 = state_44032__$1;
(statearr_44070_46478[(2)] = inst_43992);

(statearr_44070_46478[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0 = (function (){
var statearr_44071 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44071[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__);

(statearr_44071[(1)] = (1));

return statearr_44071;
});
var cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1 = (function (state_44032){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_44032);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e44072){var ex__43208__auto__ = e44072;
var statearr_44073_46485 = state_44032;
(statearr_44073_46485[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_44032[(4)]))){
var statearr_44076_46486 = state_44032;
(statearr_44076_46486[(1)] = cljs.core.first((state_44032[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46489 = state_44032;
state_44032 = G__46489;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__ = function(state_44032){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1.call(this,state_44032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__43205__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_44079 = f__43459__auto__();
(statearr_44079[(6)] = c__43458__auto__);

return statearr_44079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));

return c__43458__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__44083 = arguments.length;
switch (G__44083) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__44121 = arguments.length;
switch (G__44121) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__44133 = arguments.length;
switch (G__44133) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43458__auto___46512 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_44173){
var state_val_44174 = (state_44173[(1)]);
if((state_val_44174 === (7))){
var inst_44169 = (state_44173[(2)]);
var state_44173__$1 = state_44173;
var statearr_44175_46513 = state_44173__$1;
(statearr_44175_46513[(2)] = inst_44169);

(statearr_44175_46513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (1))){
var state_44173__$1 = state_44173;
var statearr_44180_46516 = state_44173__$1;
(statearr_44180_46516[(2)] = null);

(statearr_44180_46516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (4))){
var inst_44147 = (state_44173[(7)]);
var inst_44147__$1 = (state_44173[(2)]);
var inst_44148 = (inst_44147__$1 == null);
var state_44173__$1 = (function (){var statearr_44183 = state_44173;
(statearr_44183[(7)] = inst_44147__$1);

return statearr_44183;
})();
if(cljs.core.truth_(inst_44148)){
var statearr_44184_46521 = state_44173__$1;
(statearr_44184_46521[(1)] = (5));

} else {
var statearr_44186_46523 = state_44173__$1;
(statearr_44186_46523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (13))){
var state_44173__$1 = state_44173;
var statearr_44188_46527 = state_44173__$1;
(statearr_44188_46527[(2)] = null);

(statearr_44188_46527[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (6))){
var inst_44147 = (state_44173[(7)]);
var inst_44156 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_44147) : p.call(null,inst_44147));
var state_44173__$1 = state_44173;
if(cljs.core.truth_(inst_44156)){
var statearr_44191_46534 = state_44173__$1;
(statearr_44191_46534[(1)] = (9));

} else {
var statearr_44192_46535 = state_44173__$1;
(statearr_44192_46535[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (3))){
var inst_44171 = (state_44173[(2)]);
var state_44173__$1 = state_44173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44173__$1,inst_44171);
} else {
if((state_val_44174 === (12))){
var state_44173__$1 = state_44173;
var statearr_44200_46538 = state_44173__$1;
(statearr_44200_46538[(2)] = null);

(statearr_44200_46538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (2))){
var state_44173__$1 = state_44173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44173__$1,(4),ch);
} else {
if((state_val_44174 === (11))){
var inst_44147 = (state_44173[(7)]);
var inst_44160 = (state_44173[(2)]);
var state_44173__$1 = state_44173;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44173__$1,(8),inst_44160,inst_44147);
} else {
if((state_val_44174 === (9))){
var state_44173__$1 = state_44173;
var statearr_44218_46549 = state_44173__$1;
(statearr_44218_46549[(2)] = tc);

(statearr_44218_46549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (5))){
var inst_44150 = cljs.core.async.close_BANG_(tc);
var inst_44151 = cljs.core.async.close_BANG_(fc);
var state_44173__$1 = (function (){var statearr_44225 = state_44173;
(statearr_44225[(8)] = inst_44150);

return statearr_44225;
})();
var statearr_44226_46556 = state_44173__$1;
(statearr_44226_46556[(2)] = inst_44151);

(statearr_44226_46556[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (14))){
var inst_44167 = (state_44173[(2)]);
var state_44173__$1 = state_44173;
var statearr_44228_46559 = state_44173__$1;
(statearr_44228_46559[(2)] = inst_44167);

(statearr_44228_46559[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (10))){
var state_44173__$1 = state_44173;
var statearr_44231_46561 = state_44173__$1;
(statearr_44231_46561[(2)] = fc);

(statearr_44231_46561[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44174 === (8))){
var inst_44162 = (state_44173[(2)]);
var state_44173__$1 = state_44173;
if(cljs.core.truth_(inst_44162)){
var statearr_44233_46562 = state_44173__$1;
(statearr_44233_46562[(1)] = (12));

} else {
var statearr_44234_46566 = state_44173__$1;
(statearr_44234_46566[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_44240 = [null,null,null,null,null,null,null,null,null];
(statearr_44240[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_44240[(1)] = (1));

return statearr_44240;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_44173){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_44173);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e44242){var ex__43208__auto__ = e44242;
var statearr_44243_46567 = state_44173;
(statearr_44243_46567[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_44173[(4)]))){
var statearr_44248_46568 = state_44173;
(statearr_44248_46568[(1)] = cljs.core.first((state_44173[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46569 = state_44173;
state_44173 = G__46569;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_44173){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_44173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_44259 = f__43459__auto__();
(statearr_44259[(6)] = c__43458__auto___46512);

return statearr_44259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43458__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_44298){
var state_val_44300 = (state_44298[(1)]);
if((state_val_44300 === (7))){
var inst_44294 = (state_44298[(2)]);
var state_44298__$1 = state_44298;
var statearr_44316_46577 = state_44298__$1;
(statearr_44316_46577[(2)] = inst_44294);

(statearr_44316_46577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (1))){
var inst_44277 = init;
var inst_44278 = inst_44277;
var state_44298__$1 = (function (){var statearr_44323 = state_44298;
(statearr_44323[(7)] = inst_44278);

return statearr_44323;
})();
var statearr_44324_46585 = state_44298__$1;
(statearr_44324_46585[(2)] = null);

(statearr_44324_46585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (4))){
var inst_44281 = (state_44298[(8)]);
var inst_44281__$1 = (state_44298[(2)]);
var inst_44282 = (inst_44281__$1 == null);
var state_44298__$1 = (function (){var statearr_44330 = state_44298;
(statearr_44330[(8)] = inst_44281__$1);

return statearr_44330;
})();
if(cljs.core.truth_(inst_44282)){
var statearr_44331_46588 = state_44298__$1;
(statearr_44331_46588[(1)] = (5));

} else {
var statearr_44333_46589 = state_44298__$1;
(statearr_44333_46589[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (6))){
var inst_44285 = (state_44298[(9)]);
var inst_44281 = (state_44298[(8)]);
var inst_44278 = (state_44298[(7)]);
var inst_44285__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_44278,inst_44281) : f.call(null,inst_44278,inst_44281));
var inst_44286 = cljs.core.reduced_QMARK_(inst_44285__$1);
var state_44298__$1 = (function (){var statearr_44340 = state_44298;
(statearr_44340[(9)] = inst_44285__$1);

return statearr_44340;
})();
if(inst_44286){
var statearr_44341_46591 = state_44298__$1;
(statearr_44341_46591[(1)] = (8));

} else {
var statearr_44342_46593 = state_44298__$1;
(statearr_44342_46593[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (3))){
var inst_44296 = (state_44298[(2)]);
var state_44298__$1 = state_44298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44298__$1,inst_44296);
} else {
if((state_val_44300 === (2))){
var state_44298__$1 = state_44298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44298__$1,(4),ch);
} else {
if((state_val_44300 === (9))){
var inst_44285 = (state_44298[(9)]);
var inst_44278 = inst_44285;
var state_44298__$1 = (function (){var statearr_44348 = state_44298;
(statearr_44348[(7)] = inst_44278);

return statearr_44348;
})();
var statearr_44350_46602 = state_44298__$1;
(statearr_44350_46602[(2)] = null);

(statearr_44350_46602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (5))){
var inst_44278 = (state_44298[(7)]);
var state_44298__$1 = state_44298;
var statearr_44353_46604 = state_44298__$1;
(statearr_44353_46604[(2)] = inst_44278);

(statearr_44353_46604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (10))){
var inst_44292 = (state_44298[(2)]);
var state_44298__$1 = state_44298;
var statearr_44354_46606 = state_44298__$1;
(statearr_44354_46606[(2)] = inst_44292);

(statearr_44354_46606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44300 === (8))){
var inst_44285 = (state_44298[(9)]);
var inst_44288 = cljs.core.deref(inst_44285);
var state_44298__$1 = state_44298;
var statearr_44355_46609 = state_44298__$1;
(statearr_44355_46609[(2)] = inst_44288);

(statearr_44355_46609[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__43205__auto__ = null;
var cljs$core$async$reduce_$_state_machine__43205__auto____0 = (function (){
var statearr_44357 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44357[(0)] = cljs$core$async$reduce_$_state_machine__43205__auto__);

(statearr_44357[(1)] = (1));

return statearr_44357;
});
var cljs$core$async$reduce_$_state_machine__43205__auto____1 = (function (state_44298){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_44298);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e44359){var ex__43208__auto__ = e44359;
var statearr_44360_46611 = state_44298;
(statearr_44360_46611[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_44298[(4)]))){
var statearr_44361_46614 = state_44298;
(statearr_44361_46614[(1)] = cljs.core.first((state_44298[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46620 = state_44298;
state_44298 = G__46620;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__43205__auto__ = function(state_44298){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__43205__auto____1.call(this,state_44298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__43205__auto____0;
cljs$core$async$reduce_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__43205__auto____1;
return cljs$core$async$reduce_$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_44364 = f__43459__auto__();
(statearr_44364[(6)] = c__43458__auto__);

return statearr_44364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));

return c__43458__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43458__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_44372){
var state_val_44373 = (state_44372[(1)]);
if((state_val_44373 === (1))){
var inst_44366 = cljs.core.async.reduce(f__$1,init,ch);
var state_44372__$1 = state_44372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44372__$1,(2),inst_44366);
} else {
if((state_val_44373 === (2))){
var inst_44369 = (state_44372[(2)]);
var inst_44370 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_44369) : f__$1.call(null,inst_44369));
var state_44372__$1 = state_44372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44372__$1,inst_44370);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__43205__auto__ = null;
var cljs$core$async$transduce_$_state_machine__43205__auto____0 = (function (){
var statearr_44379 = [null,null,null,null,null,null,null];
(statearr_44379[(0)] = cljs$core$async$transduce_$_state_machine__43205__auto__);

(statearr_44379[(1)] = (1));

return statearr_44379;
});
var cljs$core$async$transduce_$_state_machine__43205__auto____1 = (function (state_44372){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_44372);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e44380){var ex__43208__auto__ = e44380;
var statearr_44381_46632 = state_44372;
(statearr_44381_46632[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_44372[(4)]))){
var statearr_44387_46633 = state_44372;
(statearr_44387_46633[(1)] = cljs.core.first((state_44372[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46634 = state_44372;
state_44372 = G__46634;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__43205__auto__ = function(state_44372){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__43205__auto____1.call(this,state_44372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__43205__auto____0;
cljs$core$async$transduce_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__43205__auto____1;
return cljs$core$async$transduce_$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_44394 = f__43459__auto__();
(statearr_44394[(6)] = c__43458__auto__);

return statearr_44394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));

return c__43458__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__44409 = arguments.length;
switch (G__44409) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43458__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_44444){
var state_val_44445 = (state_44444[(1)]);
if((state_val_44445 === (7))){
var inst_44424 = (state_44444[(2)]);
var state_44444__$1 = state_44444;
var statearr_44450_46651 = state_44444__$1;
(statearr_44450_46651[(2)] = inst_44424);

(statearr_44450_46651[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (1))){
var inst_44416 = cljs.core.seq(coll);
var inst_44417 = inst_44416;
var state_44444__$1 = (function (){var statearr_44456 = state_44444;
(statearr_44456[(7)] = inst_44417);

return statearr_44456;
})();
var statearr_44457_46653 = state_44444__$1;
(statearr_44457_46653[(2)] = null);

(statearr_44457_46653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (4))){
var inst_44417 = (state_44444[(7)]);
var inst_44422 = cljs.core.first(inst_44417);
var state_44444__$1 = state_44444;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44444__$1,(7),ch,inst_44422);
} else {
if((state_val_44445 === (13))){
var inst_44436 = (state_44444[(2)]);
var state_44444__$1 = state_44444;
var statearr_44461_46655 = state_44444__$1;
(statearr_44461_46655[(2)] = inst_44436);

(statearr_44461_46655[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (6))){
var inst_44427 = (state_44444[(2)]);
var state_44444__$1 = state_44444;
if(cljs.core.truth_(inst_44427)){
var statearr_44462_46659 = state_44444__$1;
(statearr_44462_46659[(1)] = (8));

} else {
var statearr_44463_46660 = state_44444__$1;
(statearr_44463_46660[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (3))){
var inst_44440 = (state_44444[(2)]);
var state_44444__$1 = state_44444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44444__$1,inst_44440);
} else {
if((state_val_44445 === (12))){
var state_44444__$1 = state_44444;
var statearr_44466_46667 = state_44444__$1;
(statearr_44466_46667[(2)] = null);

(statearr_44466_46667[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (2))){
var inst_44417 = (state_44444[(7)]);
var state_44444__$1 = state_44444;
if(cljs.core.truth_(inst_44417)){
var statearr_44468_46673 = state_44444__$1;
(statearr_44468_46673[(1)] = (4));

} else {
var statearr_44469_46674 = state_44444__$1;
(statearr_44469_46674[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (11))){
var inst_44433 = cljs.core.async.close_BANG_(ch);
var state_44444__$1 = state_44444;
var statearr_44470_46675 = state_44444__$1;
(statearr_44470_46675[(2)] = inst_44433);

(statearr_44470_46675[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (9))){
var state_44444__$1 = state_44444;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44472_46679 = state_44444__$1;
(statearr_44472_46679[(1)] = (11));

} else {
var statearr_44473_46680 = state_44444__$1;
(statearr_44473_46680[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (5))){
var inst_44417 = (state_44444[(7)]);
var state_44444__$1 = state_44444;
var statearr_44475_46681 = state_44444__$1;
(statearr_44475_46681[(2)] = inst_44417);

(statearr_44475_46681[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (10))){
var inst_44438 = (state_44444[(2)]);
var state_44444__$1 = state_44444;
var statearr_44476_46683 = state_44444__$1;
(statearr_44476_46683[(2)] = inst_44438);

(statearr_44476_46683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44445 === (8))){
var inst_44417 = (state_44444[(7)]);
var inst_44429 = cljs.core.next(inst_44417);
var inst_44417__$1 = inst_44429;
var state_44444__$1 = (function (){var statearr_44477 = state_44444;
(statearr_44477[(7)] = inst_44417__$1);

return statearr_44477;
})();
var statearr_44478_46684 = state_44444__$1;
(statearr_44478_46684[(2)] = null);

(statearr_44478_46684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_44482 = [null,null,null,null,null,null,null,null];
(statearr_44482[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_44482[(1)] = (1));

return statearr_44482;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_44444){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_44444);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e44484){var ex__43208__auto__ = e44484;
var statearr_44494_46690 = state_44444;
(statearr_44494_46690[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_44444[(4)]))){
var statearr_44495_46692 = state_44444;
(statearr_44495_46692[(1)] = cljs.core.first((state_44444[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46693 = state_44444;
state_44444 = G__46693;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_44444){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_44444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_44496 = f__43459__auto__();
(statearr_44496[(6)] = c__43458__auto__);

return statearr_44496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));

return c__43458__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__44506 = arguments.length;
switch (G__44506) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_46705 = (function (_){
var x__4463__auto__ = (((_ == null))?null:_);
var m__4464__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4464__auto__.call(null,_));
} else {
var m__4461__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4461__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_46705(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_46707 = (function (m,ch,close_QMARK_){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4464__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4461__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_46707(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_46715 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_46715(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_46720 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_46720(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44536 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44536 = (function (ch,cs,meta44537){
this.ch = ch;
this.cs = cs;
this.meta44537 = meta44537;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44538,meta44537__$1){
var self__ = this;
var _44538__$1 = this;
return (new cljs.core.async.t_cljs$core$async44536(self__.ch,self__.cs,meta44537__$1));
}));

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44538){
var self__ = this;
var _44538__$1 = this;
return self__.meta44537;
}));

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async44536.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async44536.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta44537","meta44537",2001099701,null)], null);
}));

(cljs.core.async.t_cljs$core$async44536.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44536.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44536");

(cljs.core.async.t_cljs$core$async44536.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async44536");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44536.
 */
cljs.core.async.__GT_t_cljs$core$async44536 = (function cljs$core$async$mult_$___GT_t_cljs$core$async44536(ch__$1,cs__$1,meta44537){
return (new cljs.core.async.t_cljs$core$async44536(ch__$1,cs__$1,meta44537));
});

}

return (new cljs.core.async.t_cljs$core$async44536(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43458__auto___46736 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_44699){
var state_val_44701 = (state_44699[(1)]);
if((state_val_44701 === (7))){
var inst_44695 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44705_46743 = state_44699__$1;
(statearr_44705_46743[(2)] = inst_44695);

(statearr_44705_46743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (20))){
var inst_44589 = (state_44699[(7)]);
var inst_44601 = cljs.core.first(inst_44589);
var inst_44602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44601,(0),null);
var inst_44603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44601,(1),null);
var state_44699__$1 = (function (){var statearr_44706 = state_44699;
(statearr_44706[(8)] = inst_44602);

return statearr_44706;
})();
if(cljs.core.truth_(inst_44603)){
var statearr_44708_46745 = state_44699__$1;
(statearr_44708_46745[(1)] = (22));

} else {
var statearr_44709_46746 = state_44699__$1;
(statearr_44709_46746[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (27))){
var inst_44631 = (state_44699[(9)]);
var inst_44633 = (state_44699[(10)]);
var inst_44639 = (state_44699[(11)]);
var inst_44558 = (state_44699[(12)]);
var inst_44639__$1 = cljs.core._nth(inst_44631,inst_44633);
var inst_44640 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44639__$1,inst_44558,done);
var state_44699__$1 = (function (){var statearr_44717 = state_44699;
(statearr_44717[(11)] = inst_44639__$1);

return statearr_44717;
})();
if(cljs.core.truth_(inst_44640)){
var statearr_44718_46764 = state_44699__$1;
(statearr_44718_46764[(1)] = (30));

} else {
var statearr_44719_46765 = state_44699__$1;
(statearr_44719_46765[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (1))){
var state_44699__$1 = state_44699;
var statearr_44725_46771 = state_44699__$1;
(statearr_44725_46771[(2)] = null);

(statearr_44725_46771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (24))){
var inst_44589 = (state_44699[(7)]);
var inst_44608 = (state_44699[(2)]);
var inst_44609 = cljs.core.next(inst_44589);
var inst_44567 = inst_44609;
var inst_44568 = null;
var inst_44569 = (0);
var inst_44570 = (0);
var state_44699__$1 = (function (){var statearr_44726 = state_44699;
(statearr_44726[(13)] = inst_44568);

(statearr_44726[(14)] = inst_44567);

(statearr_44726[(15)] = inst_44570);

(statearr_44726[(16)] = inst_44608);

(statearr_44726[(17)] = inst_44569);

return statearr_44726;
})();
var statearr_44728_46778 = state_44699__$1;
(statearr_44728_46778[(2)] = null);

(statearr_44728_46778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (39))){
var state_44699__$1 = state_44699;
var statearr_44734_46781 = state_44699__$1;
(statearr_44734_46781[(2)] = null);

(statearr_44734_46781[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (4))){
var inst_44558 = (state_44699[(12)]);
var inst_44558__$1 = (state_44699[(2)]);
var inst_44559 = (inst_44558__$1 == null);
var state_44699__$1 = (function (){var statearr_44739 = state_44699;
(statearr_44739[(12)] = inst_44558__$1);

return statearr_44739;
})();
if(cljs.core.truth_(inst_44559)){
var statearr_44740_46790 = state_44699__$1;
(statearr_44740_46790[(1)] = (5));

} else {
var statearr_44741_46792 = state_44699__$1;
(statearr_44741_46792[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (15))){
var inst_44568 = (state_44699[(13)]);
var inst_44567 = (state_44699[(14)]);
var inst_44570 = (state_44699[(15)]);
var inst_44569 = (state_44699[(17)]);
var inst_44585 = (state_44699[(2)]);
var inst_44586 = (inst_44570 + (1));
var tmp44729 = inst_44568;
var tmp44730 = inst_44567;
var tmp44731 = inst_44569;
var inst_44567__$1 = tmp44730;
var inst_44568__$1 = tmp44729;
var inst_44569__$1 = tmp44731;
var inst_44570__$1 = inst_44586;
var state_44699__$1 = (function (){var statearr_44744 = state_44699;
(statearr_44744[(13)] = inst_44568__$1);

(statearr_44744[(14)] = inst_44567__$1);

(statearr_44744[(15)] = inst_44570__$1);

(statearr_44744[(18)] = inst_44585);

(statearr_44744[(17)] = inst_44569__$1);

return statearr_44744;
})();
var statearr_44745_46798 = state_44699__$1;
(statearr_44745_46798[(2)] = null);

(statearr_44745_46798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (21))){
var inst_44612 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44749_46802 = state_44699__$1;
(statearr_44749_46802[(2)] = inst_44612);

(statearr_44749_46802[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (31))){
var inst_44639 = (state_44699[(11)]);
var inst_44643 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44639);
var state_44699__$1 = state_44699;
var statearr_44750_46808 = state_44699__$1;
(statearr_44750_46808[(2)] = inst_44643);

(statearr_44750_46808[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (32))){
var inst_44631 = (state_44699[(9)]);
var inst_44633 = (state_44699[(10)]);
var inst_44630 = (state_44699[(19)]);
var inst_44632 = (state_44699[(20)]);
var inst_44645 = (state_44699[(2)]);
var inst_44646 = (inst_44633 + (1));
var tmp44746 = inst_44631;
var tmp44747 = inst_44630;
var tmp44748 = inst_44632;
var inst_44630__$1 = tmp44747;
var inst_44631__$1 = tmp44746;
var inst_44632__$1 = tmp44748;
var inst_44633__$1 = inst_44646;
var state_44699__$1 = (function (){var statearr_44756 = state_44699;
(statearr_44756[(9)] = inst_44631__$1);

(statearr_44756[(10)] = inst_44633__$1);

(statearr_44756[(19)] = inst_44630__$1);

(statearr_44756[(21)] = inst_44645);

(statearr_44756[(20)] = inst_44632__$1);

return statearr_44756;
})();
var statearr_44758_46815 = state_44699__$1;
(statearr_44758_46815[(2)] = null);

(statearr_44758_46815[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (40))){
var inst_44663 = (state_44699[(22)]);
var inst_44667 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_44663);
var state_44699__$1 = state_44699;
var statearr_44761_46817 = state_44699__$1;
(statearr_44761_46817[(2)] = inst_44667);

(statearr_44761_46817[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (33))){
var inst_44649 = (state_44699[(23)]);
var inst_44656 = cljs.core.chunked_seq_QMARK_(inst_44649);
var state_44699__$1 = state_44699;
if(inst_44656){
var statearr_44768_46820 = state_44699__$1;
(statearr_44768_46820[(1)] = (36));

} else {
var statearr_44769_46821 = state_44699__$1;
(statearr_44769_46821[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (13))){
var inst_44579 = (state_44699[(24)]);
var inst_44582 = cljs.core.async.close_BANG_(inst_44579);
var state_44699__$1 = state_44699;
var statearr_44770_46823 = state_44699__$1;
(statearr_44770_46823[(2)] = inst_44582);

(statearr_44770_46823[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (22))){
var inst_44602 = (state_44699[(8)]);
var inst_44605 = cljs.core.async.close_BANG_(inst_44602);
var state_44699__$1 = state_44699;
var statearr_44771_46827 = state_44699__$1;
(statearr_44771_46827[(2)] = inst_44605);

(statearr_44771_46827[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (36))){
var inst_44649 = (state_44699[(23)]);
var inst_44658 = cljs.core.chunk_first(inst_44649);
var inst_44659 = cljs.core.chunk_rest(inst_44649);
var inst_44660 = cljs.core.count(inst_44658);
var inst_44630 = inst_44659;
var inst_44631 = inst_44658;
var inst_44632 = inst_44660;
var inst_44633 = (0);
var state_44699__$1 = (function (){var statearr_44772 = state_44699;
(statearr_44772[(9)] = inst_44631);

(statearr_44772[(10)] = inst_44633);

(statearr_44772[(19)] = inst_44630);

(statearr_44772[(20)] = inst_44632);

return statearr_44772;
})();
var statearr_44774_46829 = state_44699__$1;
(statearr_44774_46829[(2)] = null);

(statearr_44774_46829[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (41))){
var inst_44649 = (state_44699[(23)]);
var inst_44669 = (state_44699[(2)]);
var inst_44670 = cljs.core.next(inst_44649);
var inst_44630 = inst_44670;
var inst_44631 = null;
var inst_44632 = (0);
var inst_44633 = (0);
var state_44699__$1 = (function (){var statearr_44775 = state_44699;
(statearr_44775[(9)] = inst_44631);

(statearr_44775[(10)] = inst_44633);

(statearr_44775[(19)] = inst_44630);

(statearr_44775[(25)] = inst_44669);

(statearr_44775[(20)] = inst_44632);

return statearr_44775;
})();
var statearr_44779_46837 = state_44699__$1;
(statearr_44779_46837[(2)] = null);

(statearr_44779_46837[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (43))){
var state_44699__$1 = state_44699;
var statearr_44781_46839 = state_44699__$1;
(statearr_44781_46839[(2)] = null);

(statearr_44781_46839[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (29))){
var inst_44679 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44783_46840 = state_44699__$1;
(statearr_44783_46840[(2)] = inst_44679);

(statearr_44783_46840[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (44))){
var inst_44692 = (state_44699[(2)]);
var state_44699__$1 = (function (){var statearr_44785 = state_44699;
(statearr_44785[(26)] = inst_44692);

return statearr_44785;
})();
var statearr_44786_46845 = state_44699__$1;
(statearr_44786_46845[(2)] = null);

(statearr_44786_46845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (6))){
var inst_44622 = (state_44699[(27)]);
var inst_44621 = cljs.core.deref(cs);
var inst_44622__$1 = cljs.core.keys(inst_44621);
var inst_44623 = cljs.core.count(inst_44622__$1);
var inst_44624 = cljs.core.reset_BANG_(dctr,inst_44623);
var inst_44629 = cljs.core.seq(inst_44622__$1);
var inst_44630 = inst_44629;
var inst_44631 = null;
var inst_44632 = (0);
var inst_44633 = (0);
var state_44699__$1 = (function (){var statearr_44789 = state_44699;
(statearr_44789[(9)] = inst_44631);

(statearr_44789[(10)] = inst_44633);

(statearr_44789[(19)] = inst_44630);

(statearr_44789[(28)] = inst_44624);

(statearr_44789[(27)] = inst_44622__$1);

(statearr_44789[(20)] = inst_44632);

return statearr_44789;
})();
var statearr_44790_46855 = state_44699__$1;
(statearr_44790_46855[(2)] = null);

(statearr_44790_46855[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (28))){
var inst_44649 = (state_44699[(23)]);
var inst_44630 = (state_44699[(19)]);
var inst_44649__$1 = cljs.core.seq(inst_44630);
var state_44699__$1 = (function (){var statearr_44791 = state_44699;
(statearr_44791[(23)] = inst_44649__$1);

return statearr_44791;
})();
if(inst_44649__$1){
var statearr_44792_46858 = state_44699__$1;
(statearr_44792_46858[(1)] = (33));

} else {
var statearr_44793_46859 = state_44699__$1;
(statearr_44793_46859[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (25))){
var inst_44633 = (state_44699[(10)]);
var inst_44632 = (state_44699[(20)]);
var inst_44635 = (inst_44633 < inst_44632);
var inst_44636 = inst_44635;
var state_44699__$1 = state_44699;
if(cljs.core.truth_(inst_44636)){
var statearr_44795_46862 = state_44699__$1;
(statearr_44795_46862[(1)] = (27));

} else {
var statearr_44797_46863 = state_44699__$1;
(statearr_44797_46863[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (34))){
var state_44699__$1 = state_44699;
var statearr_44798_46868 = state_44699__$1;
(statearr_44798_46868[(2)] = null);

(statearr_44798_46868[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (17))){
var state_44699__$1 = state_44699;
var statearr_44799_46874 = state_44699__$1;
(statearr_44799_46874[(2)] = null);

(statearr_44799_46874[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (3))){
var inst_44697 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44699__$1,inst_44697);
} else {
if((state_val_44701 === (12))){
var inst_44617 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44802_46876 = state_44699__$1;
(statearr_44802_46876[(2)] = inst_44617);

(statearr_44802_46876[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (2))){
var state_44699__$1 = state_44699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44699__$1,(4),ch);
} else {
if((state_val_44701 === (23))){
var state_44699__$1 = state_44699;
var statearr_44805_46878 = state_44699__$1;
(statearr_44805_46878[(2)] = null);

(statearr_44805_46878[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (35))){
var inst_44677 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44806_46881 = state_44699__$1;
(statearr_44806_46881[(2)] = inst_44677);

(statearr_44806_46881[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (19))){
var inst_44589 = (state_44699[(7)]);
var inst_44593 = cljs.core.chunk_first(inst_44589);
var inst_44594 = cljs.core.chunk_rest(inst_44589);
var inst_44595 = cljs.core.count(inst_44593);
var inst_44567 = inst_44594;
var inst_44568 = inst_44593;
var inst_44569 = inst_44595;
var inst_44570 = (0);
var state_44699__$1 = (function (){var statearr_44808 = state_44699;
(statearr_44808[(13)] = inst_44568);

(statearr_44808[(14)] = inst_44567);

(statearr_44808[(15)] = inst_44570);

(statearr_44808[(17)] = inst_44569);

return statearr_44808;
})();
var statearr_44809_46883 = state_44699__$1;
(statearr_44809_46883[(2)] = null);

(statearr_44809_46883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (11))){
var inst_44589 = (state_44699[(7)]);
var inst_44567 = (state_44699[(14)]);
var inst_44589__$1 = cljs.core.seq(inst_44567);
var state_44699__$1 = (function (){var statearr_44815 = state_44699;
(statearr_44815[(7)] = inst_44589__$1);

return statearr_44815;
})();
if(inst_44589__$1){
var statearr_44818_46887 = state_44699__$1;
(statearr_44818_46887[(1)] = (16));

} else {
var statearr_44820_46888 = state_44699__$1;
(statearr_44820_46888[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (9))){
var inst_44619 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44822_46889 = state_44699__$1;
(statearr_44822_46889[(2)] = inst_44619);

(statearr_44822_46889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (5))){
var inst_44565 = cljs.core.deref(cs);
var inst_44566 = cljs.core.seq(inst_44565);
var inst_44567 = inst_44566;
var inst_44568 = null;
var inst_44569 = (0);
var inst_44570 = (0);
var state_44699__$1 = (function (){var statearr_44824 = state_44699;
(statearr_44824[(13)] = inst_44568);

(statearr_44824[(14)] = inst_44567);

(statearr_44824[(15)] = inst_44570);

(statearr_44824[(17)] = inst_44569);

return statearr_44824;
})();
var statearr_44826_46894 = state_44699__$1;
(statearr_44826_46894[(2)] = null);

(statearr_44826_46894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (14))){
var state_44699__$1 = state_44699;
var statearr_44829_46899 = state_44699__$1;
(statearr_44829_46899[(2)] = null);

(statearr_44829_46899[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (45))){
var inst_44689 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44831_46908 = state_44699__$1;
(statearr_44831_46908[(2)] = inst_44689);

(statearr_44831_46908[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (26))){
var inst_44622 = (state_44699[(27)]);
var inst_44681 = (state_44699[(2)]);
var inst_44682 = cljs.core.seq(inst_44622);
var state_44699__$1 = (function (){var statearr_44838 = state_44699;
(statearr_44838[(29)] = inst_44681);

return statearr_44838;
})();
if(inst_44682){
var statearr_44839_46915 = state_44699__$1;
(statearr_44839_46915[(1)] = (42));

} else {
var statearr_44841_46917 = state_44699__$1;
(statearr_44841_46917[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (16))){
var inst_44589 = (state_44699[(7)]);
var inst_44591 = cljs.core.chunked_seq_QMARK_(inst_44589);
var state_44699__$1 = state_44699;
if(inst_44591){
var statearr_44845_46918 = state_44699__$1;
(statearr_44845_46918[(1)] = (19));

} else {
var statearr_44846_46919 = state_44699__$1;
(statearr_44846_46919[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (38))){
var inst_44673 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44851_46923 = state_44699__$1;
(statearr_44851_46923[(2)] = inst_44673);

(statearr_44851_46923[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (30))){
var state_44699__$1 = state_44699;
var statearr_44852_46924 = state_44699__$1;
(statearr_44852_46924[(2)] = null);

(statearr_44852_46924[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (10))){
var inst_44568 = (state_44699[(13)]);
var inst_44570 = (state_44699[(15)]);
var inst_44578 = cljs.core._nth(inst_44568,inst_44570);
var inst_44579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44578,(0),null);
var inst_44580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44578,(1),null);
var state_44699__$1 = (function (){var statearr_44857 = state_44699;
(statearr_44857[(24)] = inst_44579);

return statearr_44857;
})();
if(cljs.core.truth_(inst_44580)){
var statearr_44860_46928 = state_44699__$1;
(statearr_44860_46928[(1)] = (13));

} else {
var statearr_44861_46934 = state_44699__$1;
(statearr_44861_46934[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (18))){
var inst_44615 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44862_46935 = state_44699__$1;
(statearr_44862_46935[(2)] = inst_44615);

(statearr_44862_46935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (42))){
var state_44699__$1 = state_44699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44699__$1,(45),dchan);
} else {
if((state_val_44701 === (37))){
var inst_44649 = (state_44699[(23)]);
var inst_44558 = (state_44699[(12)]);
var inst_44663 = (state_44699[(22)]);
var inst_44663__$1 = cljs.core.first(inst_44649);
var inst_44664 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_44663__$1,inst_44558,done);
var state_44699__$1 = (function (){var statearr_44868 = state_44699;
(statearr_44868[(22)] = inst_44663__$1);

return statearr_44868;
})();
if(cljs.core.truth_(inst_44664)){
var statearr_44871_46940 = state_44699__$1;
(statearr_44871_46940[(1)] = (39));

} else {
var statearr_44875_46941 = state_44699__$1;
(statearr_44875_46941[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44701 === (8))){
var inst_44570 = (state_44699[(15)]);
var inst_44569 = (state_44699[(17)]);
var inst_44572 = (inst_44570 < inst_44569);
var inst_44573 = inst_44572;
var state_44699__$1 = state_44699;
if(cljs.core.truth_(inst_44573)){
var statearr_44877_46948 = state_44699__$1;
(statearr_44877_46948[(1)] = (10));

} else {
var statearr_44878_46949 = state_44699__$1;
(statearr_44878_46949[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__43205__auto__ = null;
var cljs$core$async$mult_$_state_machine__43205__auto____0 = (function (){
var statearr_44883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44883[(0)] = cljs$core$async$mult_$_state_machine__43205__auto__);

(statearr_44883[(1)] = (1));

return statearr_44883;
});
var cljs$core$async$mult_$_state_machine__43205__auto____1 = (function (state_44699){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_44699);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e44884){var ex__43208__auto__ = e44884;
var statearr_44885_46952 = state_44699;
(statearr_44885_46952[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_44699[(4)]))){
var statearr_44886_46955 = state_44699;
(statearr_44886_46955[(1)] = cljs.core.first((state_44699[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46958 = state_44699;
state_44699 = G__46958;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__43205__auto__ = function(state_44699){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__43205__auto____1.call(this,state_44699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__43205__auto____0;
cljs$core$async$mult_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__43205__auto____1;
return cljs$core$async$mult_$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_44888 = f__43459__auto__();
(statearr_44888[(6)] = c__43458__auto___46736);

return statearr_44888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__44891 = arguments.length;
switch (G__44891) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_46967 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_46967(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_46980 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_46980(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_46990 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_46990(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_47000 = (function (m,state_map){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4464__auto__.call(null,m,state_map));
} else {
var m__4461__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4461__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_47000(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_47009 = (function (m,mode){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4464__auto__.call(null,m,mode));
} else {
var m__4461__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4461__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_47009(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___47016 = arguments.length;
var i__4772__auto___47017 = (0);
while(true){
if((i__4772__auto___47017 < len__4771__auto___47016)){
args__4777__auto__.push((arguments[i__4772__auto___47017]));

var G__47039 = (i__4772__auto___47017 + (1));
i__4772__auto___47017 = G__47039;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((3) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4778__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__44924){
var map__44925 = p__44924;
var map__44925__$1 = cljs.core.__destructure_map(map__44925);
var opts = map__44925__$1;
var statearr_44926_47040 = state;
(statearr_44926_47040[(1)] = cont_block);


var temp__5754__auto__ = cljs.core.async.do_alts((function (val){
var statearr_44927_47041 = state;
(statearr_44927_47041[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5754__auto__)){
var cb = temp__5754__auto__;
var statearr_44928_47042 = state;
(statearr_44928_47042[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq44920){
var G__44921 = cljs.core.first(seq44920);
var seq44920__$1 = cljs.core.next(seq44920);
var G__44922 = cljs.core.first(seq44920__$1);
var seq44920__$2 = cljs.core.next(seq44920__$1);
var G__44923 = cljs.core.first(seq44920__$2);
var seq44920__$3 = cljs.core.next(seq44920__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44921,G__44922,G__44923,seq44920__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44940 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta44941){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta44941 = meta44941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44942,meta44941__$1){
var self__ = this;
var _44942__$1 = this;
return (new cljs.core.async.t_cljs$core$async44940(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta44941__$1));
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44942){
var self__ = this;
var _44942__$1 = this;
return self__.meta44941;
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44940.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async44940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta44941","meta44941",1260961042,null)], null);
}));

(cljs.core.async.t_cljs$core$async44940.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44940");

(cljs.core.async.t_cljs$core$async44940.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async44940");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44940.
 */
cljs.core.async.__GT_t_cljs$core$async44940 = (function cljs$core$async$mix_$___GT_t_cljs$core$async44940(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44941){
return (new cljs.core.async.t_cljs$core$async44940(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta44941));
});

}

return (new cljs.core.async.t_cljs$core$async44940(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43458__auto___47079 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45035){
var state_val_45036 = (state_45035[(1)]);
if((state_val_45036 === (7))){
var inst_45031 = (state_45035[(2)]);
var state_45035__$1 = state_45035;
var statearr_45042_47084 = state_45035__$1;
(statearr_45042_47084[(2)] = inst_45031);

(statearr_45042_47084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (20))){
var inst_45025 = (state_45035[(2)]);
var state_45035__$1 = state_45035;
var statearr_45046_47085 = state_45035__$1;
(statearr_45046_47085[(2)] = inst_45025);

(statearr_45046_47085[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (1))){
var inst_44971 = calc_state();
var inst_44972 = cljs.core.__destructure_map(inst_44971);
var inst_44973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44972,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44972,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44975 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44972,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_44976 = inst_44971;
var state_45035__$1 = (function (){var statearr_45047 = state_45035;
(statearr_45047[(7)] = inst_44976);

(statearr_45047[(8)] = inst_44975);

(statearr_45047[(9)] = inst_44974);

(statearr_45047[(10)] = inst_44973);

return statearr_45047;
})();
var statearr_45051_47090 = state_45035__$1;
(statearr_45051_47090[(2)] = null);

(statearr_45051_47090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (4))){
var inst_44992 = (state_45035[(11)]);
var inst_44991 = (state_45035[(12)]);
var inst_44990 = (state_45035[(2)]);
var inst_44991__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44990,(0),null);
var inst_44992__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_44990,(1),null);
var inst_44993 = (inst_44991__$1 == null);
var inst_44994 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_44992__$1,change);
var inst_44995 = ((inst_44993) || (inst_44994));
var state_45035__$1 = (function (){var statearr_45057 = state_45035;
(statearr_45057[(11)] = inst_44992__$1);

(statearr_45057[(12)] = inst_44991__$1);

return statearr_45057;
})();
if(cljs.core.truth_(inst_44995)){
var statearr_45059_47092 = state_45035__$1;
(statearr_45059_47092[(1)] = (5));

} else {
var statearr_45061_47093 = state_45035__$1;
(statearr_45061_47093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (15))){
var inst_44980 = (state_45035[(13)]);
var inst_44976 = inst_44980;
var state_45035__$1 = (function (){var statearr_45063 = state_45035;
(statearr_45063[(7)] = inst_44976);

return statearr_45063;
})();
var statearr_45066_47097 = state_45035__$1;
(statearr_45066_47097[(2)] = null);

(statearr_45066_47097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (13))){
var inst_45017 = (state_45035[(2)]);
var state_45035__$1 = state_45035;
if(cljs.core.truth_(inst_45017)){
var statearr_45068_47102 = state_45035__$1;
(statearr_45068_47102[(1)] = (14));

} else {
var statearr_45069_47103 = state_45035__$1;
(statearr_45069_47103[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (6))){
var inst_44992 = (state_45035[(11)]);
var inst_45006 = (state_45035[(14)]);
var inst_44981 = (state_45035[(15)]);
var inst_45006__$1 = (inst_44981.cljs$core$IFn$_invoke$arity$1 ? inst_44981.cljs$core$IFn$_invoke$arity$1(inst_44992) : inst_44981.call(null,inst_44992));
var state_45035__$1 = (function (){var statearr_45072 = state_45035;
(statearr_45072[(14)] = inst_45006__$1);

return statearr_45072;
})();
if(cljs.core.truth_(inst_45006__$1)){
var statearr_45073_47108 = state_45035__$1;
(statearr_45073_47108[(1)] = (11));

} else {
var statearr_45074_47109 = state_45035__$1;
(statearr_45074_47109[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (17))){
var inst_45020 = (state_45035[(2)]);
var state_45035__$1 = state_45035;
if(cljs.core.truth_(inst_45020)){
var statearr_45076_47114 = state_45035__$1;
(statearr_45076_47114[(1)] = (18));

} else {
var statearr_45077_47117 = state_45035__$1;
(statearr_45077_47117[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (3))){
var inst_45033 = (state_45035[(2)]);
var state_45035__$1 = state_45035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45035__$1,inst_45033);
} else {
if((state_val_45036 === (12))){
var inst_44982 = (state_45035[(16)]);
var inst_44992 = (state_45035[(11)]);
var inst_44981 = (state_45035[(15)]);
var inst_45012 = cljs.core.empty_QMARK_(inst_44981);
var inst_45013 = (inst_44982.cljs$core$IFn$_invoke$arity$1 ? inst_44982.cljs$core$IFn$_invoke$arity$1(inst_44992) : inst_44982.call(null,inst_44992));
var inst_45014 = cljs.core.not(inst_45013);
var inst_45015 = ((inst_45012) && (inst_45014));
var state_45035__$1 = state_45035;
var statearr_45081_47124 = state_45035__$1;
(statearr_45081_47124[(2)] = inst_45015);

(statearr_45081_47124[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (2))){
var inst_44976 = (state_45035[(7)]);
var inst_44980 = (state_45035[(13)]);
var inst_44980__$1 = cljs.core.__destructure_map(inst_44976);
var inst_44981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44980__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_44982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44980__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_44983 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44980__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45035__$1 = (function (){var statearr_45083 = state_45035;
(statearr_45083[(16)] = inst_44982);

(statearr_45083[(13)] = inst_44980__$1);

(statearr_45083[(15)] = inst_44981);

return statearr_45083;
})();
return cljs.core.async.ioc_alts_BANG_(state_45035__$1,(4),inst_44983);
} else {
if((state_val_45036 === (19))){
var state_45035__$1 = state_45035;
var statearr_45084_47130 = state_45035__$1;
(statearr_45084_47130[(2)] = null);

(statearr_45084_47130[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (11))){
var inst_45006 = (state_45035[(14)]);
var state_45035__$1 = state_45035;
var statearr_45086_47131 = state_45035__$1;
(statearr_45086_47131[(2)] = inst_45006);

(statearr_45086_47131[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (9))){
var state_45035__$1 = state_45035;
var statearr_45087_47132 = state_45035__$1;
(statearr_45087_47132[(2)] = null);

(statearr_45087_47132[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (5))){
var inst_44991 = (state_45035[(12)]);
var inst_44997 = (inst_44991 == null);
var state_45035__$1 = state_45035;
if(cljs.core.truth_(inst_44997)){
var statearr_45092_47137 = state_45035__$1;
(statearr_45092_47137[(1)] = (8));

} else {
var statearr_45093_47138 = state_45035__$1;
(statearr_45093_47138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (14))){
var inst_44991 = (state_45035[(12)]);
var state_45035__$1 = state_45035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45035__$1,(17),out,inst_44991);
} else {
if((state_val_45036 === (16))){
var inst_45029 = (state_45035[(2)]);
var state_45035__$1 = state_45035;
var statearr_45099_47140 = state_45035__$1;
(statearr_45099_47140[(2)] = inst_45029);

(statearr_45099_47140[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (10))){
var inst_45002 = (state_45035[(2)]);
var inst_45003 = calc_state();
var inst_44976 = inst_45003;
var state_45035__$1 = (function (){var statearr_45102 = state_45035;
(statearr_45102[(7)] = inst_44976);

(statearr_45102[(17)] = inst_45002);

return statearr_45102;
})();
var statearr_45104_47141 = state_45035__$1;
(statearr_45104_47141[(2)] = null);

(statearr_45104_47141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (18))){
var inst_44980 = (state_45035[(13)]);
var inst_44976 = inst_44980;
var state_45035__$1 = (function (){var statearr_45105 = state_45035;
(statearr_45105[(7)] = inst_44976);

return statearr_45105;
})();
var statearr_45106_47142 = state_45035__$1;
(statearr_45106_47142[(2)] = null);

(statearr_45106_47142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45036 === (8))){
var inst_44992 = (state_45035[(11)]);
var inst_44999 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_44992);
var state_45035__$1 = state_45035;
var statearr_45107_47143 = state_45035__$1;
(statearr_45107_47143[(2)] = inst_44999);

(statearr_45107_47143[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__43205__auto__ = null;
var cljs$core$async$mix_$_state_machine__43205__auto____0 = (function (){
var statearr_45108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45108[(0)] = cljs$core$async$mix_$_state_machine__43205__auto__);

(statearr_45108[(1)] = (1));

return statearr_45108;
});
var cljs$core$async$mix_$_state_machine__43205__auto____1 = (function (state_45035){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45035);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45109){var ex__43208__auto__ = e45109;
var statearr_45110_47144 = state_45035;
(statearr_45110_47144[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45035[(4)]))){
var statearr_45113_47146 = state_45035;
(statearr_45113_47146[(1)] = cljs.core.first((state_45035[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47147 = state_45035;
state_45035 = G__47147;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__43205__auto__ = function(state_45035){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__43205__auto____1.call(this,state_45035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__43205__auto____0;
cljs$core$async$mix_$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__43205__auto____1;
return cljs$core$async$mix_$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45115 = f__43459__auto__();
(statearr_45115[(6)] = c__43458__auto___47079);

return statearr_45115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_47150 = (function (p,v,ch,close_QMARK_){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4464__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4461__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_47150(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_47153 = (function (p,v,ch){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4464__auto__.call(null,p,v,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4461__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_47153(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_47155 = (function() {
var G__47156 = null;
var G__47156__1 = (function (p){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4464__auto__.call(null,p));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4461__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__47156__2 = (function (p,v){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4464__auto__.call(null,p,v));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4461__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__47156 = function(p,v){
switch(arguments.length){
case 1:
return G__47156__1.call(this,p);
case 2:
return G__47156__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47156.cljs$core$IFn$_invoke$arity$1 = G__47156__1;
G__47156.cljs$core$IFn$_invoke$arity$2 = G__47156__2;
return G__47156;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__45148 = arguments.length;
switch (G__45148) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47155(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_47155(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__45153 = arguments.length;
switch (G__45153) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__45149_SHARP_){
if(cljs.core.truth_((p1__45149_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__45149_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__45149_SHARP_.call(null,topic)))){
return p1__45149_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__45149_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45158 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45158 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta45159){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta45159 = meta45159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45160,meta45159__$1){
var self__ = this;
var _45160__$1 = this;
return (new cljs.core.async.t_cljs$core$async45158(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta45159__$1));
}));

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45160){
var self__ = this;
var _45160__$1 = this;
return self__.meta45159;
}));

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5754__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5754__auto__)){
var m = temp__5754__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async45158.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async45158.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta45159","meta45159",-149857240,null)], null);
}));

(cljs.core.async.t_cljs$core$async45158.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45158");

(cljs.core.async.t_cljs$core$async45158.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45158");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45158.
 */
cljs.core.async.__GT_t_cljs$core$async45158 = (function cljs$core$async$__GT_t_cljs$core$async45158(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45159){
return (new cljs.core.async.t_cljs$core$async45158(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta45159));
});

}

return (new cljs.core.async.t_cljs$core$async45158(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43458__auto___47173 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45243){
var state_val_45244 = (state_45243[(1)]);
if((state_val_45244 === (7))){
var inst_45239 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45246_47174 = state_45243__$1;
(statearr_45246_47174[(2)] = inst_45239);

(statearr_45246_47174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (20))){
var state_45243__$1 = state_45243;
var statearr_45247_47175 = state_45243__$1;
(statearr_45247_47175[(2)] = null);

(statearr_45247_47175[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (1))){
var state_45243__$1 = state_45243;
var statearr_45249_47177 = state_45243__$1;
(statearr_45249_47177[(2)] = null);

(statearr_45249_47177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (24))){
var inst_45222 = (state_45243[(7)]);
var inst_45231 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_45222);
var state_45243__$1 = state_45243;
var statearr_45250_47184 = state_45243__$1;
(statearr_45250_47184[(2)] = inst_45231);

(statearr_45250_47184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (4))){
var inst_45172 = (state_45243[(8)]);
var inst_45172__$1 = (state_45243[(2)]);
var inst_45174 = (inst_45172__$1 == null);
var state_45243__$1 = (function (){var statearr_45251 = state_45243;
(statearr_45251[(8)] = inst_45172__$1);

return statearr_45251;
})();
if(cljs.core.truth_(inst_45174)){
var statearr_45252_47187 = state_45243__$1;
(statearr_45252_47187[(1)] = (5));

} else {
var statearr_45254_47188 = state_45243__$1;
(statearr_45254_47188[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (15))){
var inst_45216 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45255_47189 = state_45243__$1;
(statearr_45255_47189[(2)] = inst_45216);

(statearr_45255_47189[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (21))){
var inst_45236 = (state_45243[(2)]);
var state_45243__$1 = (function (){var statearr_45260 = state_45243;
(statearr_45260[(9)] = inst_45236);

return statearr_45260;
})();
var statearr_45261_47192 = state_45243__$1;
(statearr_45261_47192[(2)] = null);

(statearr_45261_47192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (13))){
var inst_45198 = (state_45243[(10)]);
var inst_45200 = cljs.core.chunked_seq_QMARK_(inst_45198);
var state_45243__$1 = state_45243;
if(inst_45200){
var statearr_45262_47194 = state_45243__$1;
(statearr_45262_47194[(1)] = (16));

} else {
var statearr_45263_47195 = state_45243__$1;
(statearr_45263_47195[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (22))){
var inst_45228 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
if(cljs.core.truth_(inst_45228)){
var statearr_45264_47203 = state_45243__$1;
(statearr_45264_47203[(1)] = (23));

} else {
var statearr_45265_47205 = state_45243__$1;
(statearr_45265_47205[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (6))){
var inst_45172 = (state_45243[(8)]);
var inst_45222 = (state_45243[(7)]);
var inst_45224 = (state_45243[(11)]);
var inst_45222__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_45172) : topic_fn.call(null,inst_45172));
var inst_45223 = cljs.core.deref(mults);
var inst_45224__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_45223,inst_45222__$1);
var state_45243__$1 = (function (){var statearr_45266 = state_45243;
(statearr_45266[(7)] = inst_45222__$1);

(statearr_45266[(11)] = inst_45224__$1);

return statearr_45266;
})();
if(cljs.core.truth_(inst_45224__$1)){
var statearr_45267_47217 = state_45243__$1;
(statearr_45267_47217[(1)] = (19));

} else {
var statearr_45268_47218 = state_45243__$1;
(statearr_45268_47218[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (25))){
var inst_45233 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45270_47219 = state_45243__$1;
(statearr_45270_47219[(2)] = inst_45233);

(statearr_45270_47219[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (17))){
var inst_45198 = (state_45243[(10)]);
var inst_45207 = cljs.core.first(inst_45198);
var inst_45208 = cljs.core.async.muxch_STAR_(inst_45207);
var inst_45209 = cljs.core.async.close_BANG_(inst_45208);
var inst_45210 = cljs.core.next(inst_45198);
var inst_45183 = inst_45210;
var inst_45184 = null;
var inst_45185 = (0);
var inst_45186 = (0);
var state_45243__$1 = (function (){var statearr_45271 = state_45243;
(statearr_45271[(12)] = inst_45184);

(statearr_45271[(13)] = inst_45209);

(statearr_45271[(14)] = inst_45183);

(statearr_45271[(15)] = inst_45186);

(statearr_45271[(16)] = inst_45185);

return statearr_45271;
})();
var statearr_45272_47223 = state_45243__$1;
(statearr_45272_47223[(2)] = null);

(statearr_45272_47223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (3))){
var inst_45241 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45243__$1,inst_45241);
} else {
if((state_val_45244 === (12))){
var inst_45218 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45273_47230 = state_45243__$1;
(statearr_45273_47230[(2)] = inst_45218);

(statearr_45273_47230[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (2))){
var state_45243__$1 = state_45243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45243__$1,(4),ch);
} else {
if((state_val_45244 === (23))){
var state_45243__$1 = state_45243;
var statearr_45274_47232 = state_45243__$1;
(statearr_45274_47232[(2)] = null);

(statearr_45274_47232[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (19))){
var inst_45172 = (state_45243[(8)]);
var inst_45224 = (state_45243[(11)]);
var inst_45226 = cljs.core.async.muxch_STAR_(inst_45224);
var state_45243__$1 = state_45243;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45243__$1,(22),inst_45226,inst_45172);
} else {
if((state_val_45244 === (11))){
var inst_45198 = (state_45243[(10)]);
var inst_45183 = (state_45243[(14)]);
var inst_45198__$1 = cljs.core.seq(inst_45183);
var state_45243__$1 = (function (){var statearr_45276 = state_45243;
(statearr_45276[(10)] = inst_45198__$1);

return statearr_45276;
})();
if(inst_45198__$1){
var statearr_45277_47240 = state_45243__$1;
(statearr_45277_47240[(1)] = (13));

} else {
var statearr_45278_47241 = state_45243__$1;
(statearr_45278_47241[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (9))){
var inst_45220 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45279_47246 = state_45243__$1;
(statearr_45279_47246[(2)] = inst_45220);

(statearr_45279_47246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (5))){
var inst_45180 = cljs.core.deref(mults);
var inst_45181 = cljs.core.vals(inst_45180);
var inst_45182 = cljs.core.seq(inst_45181);
var inst_45183 = inst_45182;
var inst_45184 = null;
var inst_45185 = (0);
var inst_45186 = (0);
var state_45243__$1 = (function (){var statearr_45284 = state_45243;
(statearr_45284[(12)] = inst_45184);

(statearr_45284[(14)] = inst_45183);

(statearr_45284[(15)] = inst_45186);

(statearr_45284[(16)] = inst_45185);

return statearr_45284;
})();
var statearr_45285_47251 = state_45243__$1;
(statearr_45285_47251[(2)] = null);

(statearr_45285_47251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (14))){
var state_45243__$1 = state_45243;
var statearr_45289_47261 = state_45243__$1;
(statearr_45289_47261[(2)] = null);

(statearr_45289_47261[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (16))){
var inst_45198 = (state_45243[(10)]);
var inst_45202 = cljs.core.chunk_first(inst_45198);
var inst_45203 = cljs.core.chunk_rest(inst_45198);
var inst_45204 = cljs.core.count(inst_45202);
var inst_45183 = inst_45203;
var inst_45184 = inst_45202;
var inst_45185 = inst_45204;
var inst_45186 = (0);
var state_45243__$1 = (function (){var statearr_45293 = state_45243;
(statearr_45293[(12)] = inst_45184);

(statearr_45293[(14)] = inst_45183);

(statearr_45293[(15)] = inst_45186);

(statearr_45293[(16)] = inst_45185);

return statearr_45293;
})();
var statearr_45294_47274 = state_45243__$1;
(statearr_45294_47274[(2)] = null);

(statearr_45294_47274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (10))){
var inst_45184 = (state_45243[(12)]);
var inst_45183 = (state_45243[(14)]);
var inst_45186 = (state_45243[(15)]);
var inst_45185 = (state_45243[(16)]);
var inst_45191 = cljs.core._nth(inst_45184,inst_45186);
var inst_45192 = cljs.core.async.muxch_STAR_(inst_45191);
var inst_45193 = cljs.core.async.close_BANG_(inst_45192);
var inst_45195 = (inst_45186 + (1));
var tmp45286 = inst_45184;
var tmp45287 = inst_45183;
var tmp45288 = inst_45185;
var inst_45183__$1 = tmp45287;
var inst_45184__$1 = tmp45286;
var inst_45185__$1 = tmp45288;
var inst_45186__$1 = inst_45195;
var state_45243__$1 = (function (){var statearr_45298 = state_45243;
(statearr_45298[(12)] = inst_45184__$1);

(statearr_45298[(14)] = inst_45183__$1);

(statearr_45298[(17)] = inst_45193);

(statearr_45298[(15)] = inst_45186__$1);

(statearr_45298[(16)] = inst_45185__$1);

return statearr_45298;
})();
var statearr_45299_47280 = state_45243__$1;
(statearr_45299_47280[(2)] = null);

(statearr_45299_47280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (18))){
var inst_45213 = (state_45243[(2)]);
var state_45243__$1 = state_45243;
var statearr_45300_47290 = state_45243__$1;
(statearr_45300_47290[(2)] = inst_45213);

(statearr_45300_47290[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45244 === (8))){
var inst_45186 = (state_45243[(15)]);
var inst_45185 = (state_45243[(16)]);
var inst_45188 = (inst_45186 < inst_45185);
var inst_45189 = inst_45188;
var state_45243__$1 = state_45243;
if(cljs.core.truth_(inst_45189)){
var statearr_45301_47301 = state_45243__$1;
(statearr_45301_47301[(1)] = (10));

} else {
var statearr_45302_47302 = state_45243__$1;
(statearr_45302_47302[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_45303 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45303[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_45303[(1)] = (1));

return statearr_45303;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_45243){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45243);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45304){var ex__43208__auto__ = e45304;
var statearr_45305_47312 = state_45243;
(statearr_45305_47312[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45243[(4)]))){
var statearr_45306_47314 = state_45243;
(statearr_45306_47314[(1)] = cljs.core.first((state_45243[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47318 = state_45243;
state_45243 = G__47318;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_45243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_45243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45307 = f__43459__auto__();
(statearr_45307[(6)] = c__43458__auto___47173);

return statearr_45307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__45311 = arguments.length;
switch (G__45311) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__45318 = arguments.length;
switch (G__45318) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__45333 = arguments.length;
switch (G__45333) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43458__auto___47365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45401){
var state_val_45402 = (state_45401[(1)]);
if((state_val_45402 === (7))){
var state_45401__$1 = state_45401;
var statearr_45403_47367 = state_45401__$1;
(statearr_45403_47367[(2)] = null);

(statearr_45403_47367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (1))){
var state_45401__$1 = state_45401;
var statearr_45406_47371 = state_45401__$1;
(statearr_45406_47371[(2)] = null);

(statearr_45406_47371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (4))){
var inst_45354 = (state_45401[(7)]);
var inst_45355 = (state_45401[(8)]);
var inst_45357 = (inst_45355 < inst_45354);
var state_45401__$1 = state_45401;
if(cljs.core.truth_(inst_45357)){
var statearr_45411_47375 = state_45401__$1;
(statearr_45411_47375[(1)] = (6));

} else {
var statearr_45417_47383 = state_45401__$1;
(statearr_45417_47383[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (15))){
var inst_45384 = (state_45401[(9)]);
var inst_45392 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_45384);
var state_45401__$1 = state_45401;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45401__$1,(17),out,inst_45392);
} else {
if((state_val_45402 === (13))){
var inst_45384 = (state_45401[(9)]);
var inst_45384__$1 = (state_45401[(2)]);
var inst_45385 = cljs.core.some(cljs.core.nil_QMARK_,inst_45384__$1);
var state_45401__$1 = (function (){var statearr_45421 = state_45401;
(statearr_45421[(9)] = inst_45384__$1);

return statearr_45421;
})();
if(cljs.core.truth_(inst_45385)){
var statearr_45422_47390 = state_45401__$1;
(statearr_45422_47390[(1)] = (14));

} else {
var statearr_45423_47395 = state_45401__$1;
(statearr_45423_47395[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (6))){
var state_45401__$1 = state_45401;
var statearr_45424_47396 = state_45401__$1;
(statearr_45424_47396[(2)] = null);

(statearr_45424_47396[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (17))){
var inst_45394 = (state_45401[(2)]);
var state_45401__$1 = (function (){var statearr_45431 = state_45401;
(statearr_45431[(10)] = inst_45394);

return statearr_45431;
})();
var statearr_45432_47404 = state_45401__$1;
(statearr_45432_47404[(2)] = null);

(statearr_45432_47404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (3))){
var inst_45399 = (state_45401[(2)]);
var state_45401__$1 = state_45401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45401__$1,inst_45399);
} else {
if((state_val_45402 === (12))){
var _ = (function (){var statearr_45435 = state_45401;
(statearr_45435[(4)] = cljs.core.rest((state_45401[(4)])));

return statearr_45435;
})();
var state_45401__$1 = state_45401;
var ex45429 = (state_45401__$1[(2)]);
var statearr_45441_47414 = state_45401__$1;
(statearr_45441_47414[(5)] = ex45429);


if((ex45429 instanceof Object)){
var statearr_45442_47416 = state_45401__$1;
(statearr_45442_47416[(1)] = (11));

(statearr_45442_47416[(5)] = null);

} else {
throw ex45429;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (2))){
var inst_45353 = cljs.core.reset_BANG_(dctr,cnt);
var inst_45354 = cnt;
var inst_45355 = (0);
var state_45401__$1 = (function (){var statearr_45443 = state_45401;
(statearr_45443[(11)] = inst_45353);

(statearr_45443[(7)] = inst_45354);

(statearr_45443[(8)] = inst_45355);

return statearr_45443;
})();
var statearr_45444_47419 = state_45401__$1;
(statearr_45444_47419[(2)] = null);

(statearr_45444_47419[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (11))){
var inst_45359 = (state_45401[(2)]);
var inst_45362 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_45401__$1 = (function (){var statearr_45446 = state_45401;
(statearr_45446[(12)] = inst_45359);

return statearr_45446;
})();
var statearr_45449_47420 = state_45401__$1;
(statearr_45449_47420[(2)] = inst_45362);

(statearr_45449_47420[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (9))){
var inst_45355 = (state_45401[(8)]);
var _ = (function (){var statearr_45450 = state_45401;
(statearr_45450[(4)] = cljs.core.cons((12),(state_45401[(4)])));

return statearr_45450;
})();
var inst_45369 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_45355) : chs__$1.call(null,inst_45355));
var inst_45371 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_45355) : done.call(null,inst_45355));
var inst_45372 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_45369,inst_45371);
var ___$1 = (function (){var statearr_45451 = state_45401;
(statearr_45451[(4)] = cljs.core.rest((state_45401[(4)])));

return statearr_45451;
})();
var state_45401__$1 = state_45401;
var statearr_45452_47435 = state_45401__$1;
(statearr_45452_47435[(2)] = inst_45372);

(statearr_45452_47435[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (5))){
var inst_45382 = (state_45401[(2)]);
var state_45401__$1 = (function (){var statearr_45455 = state_45401;
(statearr_45455[(13)] = inst_45382);

return statearr_45455;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45401__$1,(13),dchan);
} else {
if((state_val_45402 === (14))){
var inst_45389 = cljs.core.async.close_BANG_(out);
var state_45401__$1 = state_45401;
var statearr_45459_47441 = state_45401__$1;
(statearr_45459_47441[(2)] = inst_45389);

(statearr_45459_47441[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (16))){
var inst_45397 = (state_45401[(2)]);
var state_45401__$1 = state_45401;
var statearr_45460_47444 = state_45401__$1;
(statearr_45460_47444[(2)] = inst_45397);

(statearr_45460_47444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (10))){
var inst_45355 = (state_45401[(8)]);
var inst_45375 = (state_45401[(2)]);
var inst_45376 = (inst_45355 + (1));
var inst_45355__$1 = inst_45376;
var state_45401__$1 = (function (){var statearr_45465 = state_45401;
(statearr_45465[(14)] = inst_45375);

(statearr_45465[(8)] = inst_45355__$1);

return statearr_45465;
})();
var statearr_45466_47452 = state_45401__$1;
(statearr_45466_47452[(2)] = null);

(statearr_45466_47452[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45402 === (8))){
var inst_45380 = (state_45401[(2)]);
var state_45401__$1 = state_45401;
var statearr_45468_47457 = state_45401__$1;
(statearr_45468_47457[(2)] = inst_45380);

(statearr_45468_47457[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_45470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45470[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_45470[(1)] = (1));

return statearr_45470;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_45401){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45401);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45477){var ex__43208__auto__ = e45477;
var statearr_45479_47462 = state_45401;
(statearr_45479_47462[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45401[(4)]))){
var statearr_45480_47463 = state_45401;
(statearr_45480_47463[(1)] = cljs.core.first((state_45401[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47469 = state_45401;
state_45401 = G__47469;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_45401){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_45401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45482 = f__43459__auto__();
(statearr_45482[(6)] = c__43458__auto___47365);

return statearr_45482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__45490 = arguments.length;
switch (G__45490) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43458__auto___47495 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45524){
var state_val_45525 = (state_45524[(1)]);
if((state_val_45525 === (7))){
var inst_45503 = (state_45524[(7)]);
var inst_45504 = (state_45524[(8)]);
var inst_45503__$1 = (state_45524[(2)]);
var inst_45504__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45503__$1,(0),null);
var inst_45505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_45503__$1,(1),null);
var inst_45506 = (inst_45504__$1 == null);
var state_45524__$1 = (function (){var statearr_45527 = state_45524;
(statearr_45527[(9)] = inst_45505);

(statearr_45527[(7)] = inst_45503__$1);

(statearr_45527[(8)] = inst_45504__$1);

return statearr_45527;
})();
if(cljs.core.truth_(inst_45506)){
var statearr_45528_47509 = state_45524__$1;
(statearr_45528_47509[(1)] = (8));

} else {
var statearr_45529_47511 = state_45524__$1;
(statearr_45529_47511[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (1))){
var inst_45493 = cljs.core.vec(chs);
var inst_45494 = inst_45493;
var state_45524__$1 = (function (){var statearr_45530 = state_45524;
(statearr_45530[(10)] = inst_45494);

return statearr_45530;
})();
var statearr_45531_47520 = state_45524__$1;
(statearr_45531_47520[(2)] = null);

(statearr_45531_47520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (4))){
var inst_45494 = (state_45524[(10)]);
var state_45524__$1 = state_45524;
return cljs.core.async.ioc_alts_BANG_(state_45524__$1,(7),inst_45494);
} else {
if((state_val_45525 === (6))){
var inst_45520 = (state_45524[(2)]);
var state_45524__$1 = state_45524;
var statearr_45535_47523 = state_45524__$1;
(statearr_45535_47523[(2)] = inst_45520);

(statearr_45535_47523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (3))){
var inst_45522 = (state_45524[(2)]);
var state_45524__$1 = state_45524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45524__$1,inst_45522);
} else {
if((state_val_45525 === (2))){
var inst_45494 = (state_45524[(10)]);
var inst_45496 = cljs.core.count(inst_45494);
var inst_45497 = (inst_45496 > (0));
var state_45524__$1 = state_45524;
if(cljs.core.truth_(inst_45497)){
var statearr_45537_47527 = state_45524__$1;
(statearr_45537_47527[(1)] = (4));

} else {
var statearr_45538_47529 = state_45524__$1;
(statearr_45538_47529[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (11))){
var inst_45494 = (state_45524[(10)]);
var inst_45513 = (state_45524[(2)]);
var tmp45536 = inst_45494;
var inst_45494__$1 = tmp45536;
var state_45524__$1 = (function (){var statearr_45549 = state_45524;
(statearr_45549[(10)] = inst_45494__$1);

(statearr_45549[(11)] = inst_45513);

return statearr_45549;
})();
var statearr_45552_47533 = state_45524__$1;
(statearr_45552_47533[(2)] = null);

(statearr_45552_47533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (9))){
var inst_45504 = (state_45524[(8)]);
var state_45524__$1 = state_45524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45524__$1,(11),out,inst_45504);
} else {
if((state_val_45525 === (5))){
var inst_45518 = cljs.core.async.close_BANG_(out);
var state_45524__$1 = state_45524;
var statearr_45565_47536 = state_45524__$1;
(statearr_45565_47536[(2)] = inst_45518);

(statearr_45565_47536[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (10))){
var inst_45516 = (state_45524[(2)]);
var state_45524__$1 = state_45524;
var statearr_45566_47540 = state_45524__$1;
(statearr_45566_47540[(2)] = inst_45516);

(statearr_45566_47540[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45525 === (8))){
var inst_45505 = (state_45524[(9)]);
var inst_45503 = (state_45524[(7)]);
var inst_45494 = (state_45524[(10)]);
var inst_45504 = (state_45524[(8)]);
var inst_45508 = (function (){var cs = inst_45494;
var vec__45499 = inst_45503;
var v = inst_45504;
var c = inst_45505;
return (function (p1__45484_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__45484_SHARP_);
});
})();
var inst_45509 = cljs.core.filterv(inst_45508,inst_45494);
var inst_45494__$1 = inst_45509;
var state_45524__$1 = (function (){var statearr_45570 = state_45524;
(statearr_45570[(10)] = inst_45494__$1);

return statearr_45570;
})();
var statearr_45571_47542 = state_45524__$1;
(statearr_45571_47542[(2)] = null);

(statearr_45571_47542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_45572 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45572[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_45572[(1)] = (1));

return statearr_45572;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_45524){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45524);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45573){var ex__43208__auto__ = e45573;
var statearr_45574_47547 = state_45524;
(statearr_45574_47547[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45524[(4)]))){
var statearr_45576_47549 = state_45524;
(statearr_45576_47549[(1)] = cljs.core.first((state_45524[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47551 = state_45524;
state_45524 = G__47551;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_45524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_45524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45578 = f__43459__auto__();
(statearr_45578[(6)] = c__43458__auto___47495);

return statearr_45578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__45580 = arguments.length;
switch (G__45580) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43458__auto___47561 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45607){
var state_val_45608 = (state_45607[(1)]);
if((state_val_45608 === (7))){
var inst_45589 = (state_45607[(7)]);
var inst_45589__$1 = (state_45607[(2)]);
var inst_45590 = (inst_45589__$1 == null);
var inst_45591 = cljs.core.not(inst_45590);
var state_45607__$1 = (function (){var statearr_45611 = state_45607;
(statearr_45611[(7)] = inst_45589__$1);

return statearr_45611;
})();
if(inst_45591){
var statearr_45613_47569 = state_45607__$1;
(statearr_45613_47569[(1)] = (8));

} else {
var statearr_45614_47570 = state_45607__$1;
(statearr_45614_47570[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (1))){
var inst_45584 = (0);
var state_45607__$1 = (function (){var statearr_45615 = state_45607;
(statearr_45615[(8)] = inst_45584);

return statearr_45615;
})();
var statearr_45616_47577 = state_45607__$1;
(statearr_45616_47577[(2)] = null);

(statearr_45616_47577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (4))){
var state_45607__$1 = state_45607;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45607__$1,(7),ch);
} else {
if((state_val_45608 === (6))){
var inst_45602 = (state_45607[(2)]);
var state_45607__$1 = state_45607;
var statearr_45617_47585 = state_45607__$1;
(statearr_45617_47585[(2)] = inst_45602);

(statearr_45617_47585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (3))){
var inst_45604 = (state_45607[(2)]);
var inst_45605 = cljs.core.async.close_BANG_(out);
var state_45607__$1 = (function (){var statearr_45618 = state_45607;
(statearr_45618[(9)] = inst_45604);

return statearr_45618;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45607__$1,inst_45605);
} else {
if((state_val_45608 === (2))){
var inst_45584 = (state_45607[(8)]);
var inst_45586 = (inst_45584 < n);
var state_45607__$1 = state_45607;
if(cljs.core.truth_(inst_45586)){
var statearr_45620_47588 = state_45607__$1;
(statearr_45620_47588[(1)] = (4));

} else {
var statearr_45621_47591 = state_45607__$1;
(statearr_45621_47591[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (11))){
var inst_45584 = (state_45607[(8)]);
var inst_45594 = (state_45607[(2)]);
var inst_45595 = (inst_45584 + (1));
var inst_45584__$1 = inst_45595;
var state_45607__$1 = (function (){var statearr_45623 = state_45607;
(statearr_45623[(8)] = inst_45584__$1);

(statearr_45623[(10)] = inst_45594);

return statearr_45623;
})();
var statearr_45624_47596 = state_45607__$1;
(statearr_45624_47596[(2)] = null);

(statearr_45624_47596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (9))){
var state_45607__$1 = state_45607;
var statearr_45625_47601 = state_45607__$1;
(statearr_45625_47601[(2)] = null);

(statearr_45625_47601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (5))){
var state_45607__$1 = state_45607;
var statearr_45626_47605 = state_45607__$1;
(statearr_45626_47605[(2)] = null);

(statearr_45626_47605[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (10))){
var inst_45599 = (state_45607[(2)]);
var state_45607__$1 = state_45607;
var statearr_45627_47608 = state_45607__$1;
(statearr_45627_47608[(2)] = inst_45599);

(statearr_45627_47608[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45608 === (8))){
var inst_45589 = (state_45607[(7)]);
var state_45607__$1 = state_45607;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45607__$1,(11),out,inst_45589);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_45628 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45628[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_45628[(1)] = (1));

return statearr_45628;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_45607){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45607);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45633){var ex__43208__auto__ = e45633;
var statearr_45634_47615 = state_45607;
(statearr_45634_47615[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45607[(4)]))){
var statearr_45639_47618 = state_45607;
(statearr_45639_47618[(1)] = cljs.core.first((state_45607[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47620 = state_45607;
state_45607 = G__47620;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_45607){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_45607);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45644 = f__43459__auto__();
(statearr_45644[(6)] = c__43458__auto___47561);

return statearr_45644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45654 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45654 = (function (f,ch,meta45655){
this.f = f;
this.ch = ch;
this.meta45655 = meta45655;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45656,meta45655__$1){
var self__ = this;
var _45656__$1 = this;
return (new cljs.core.async.t_cljs$core$async45654(self__.f,self__.ch,meta45655__$1));
}));

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45656){
var self__ = this;
var _45656__$1 = this;
return self__.meta45655;
}));

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45663 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45663 = (function (f,ch,meta45655,_,fn1,meta45664){
this.f = f;
this.ch = ch;
this.meta45655 = meta45655;
this._ = _;
this.fn1 = fn1;
this.meta45664 = meta45664;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45663.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45665,meta45664__$1){
var self__ = this;
var _45665__$1 = this;
return (new cljs.core.async.t_cljs$core$async45663(self__.f,self__.ch,self__.meta45655,self__._,self__.fn1,meta45664__$1));
}));

(cljs.core.async.t_cljs$core$async45663.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45665){
var self__ = this;
var _45665__$1 = this;
return self__.meta45664;
}));

(cljs.core.async.t_cljs$core$async45663.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45663.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async45663.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45663.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__45653_SHARP_){
var G__45667 = (((p1__45653_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__45653_SHARP_) : self__.f.call(null,p1__45653_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__45667) : f1.call(null,G__45667));
});
}));

(cljs.core.async.t_cljs$core$async45663.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45655","meta45655",408716119,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async45654","cljs.core.async/t_cljs$core$async45654",2133974854,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta45664","meta45664",-823349645,null)], null);
}));

(cljs.core.async.t_cljs$core$async45663.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45663.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45663");

(cljs.core.async.t_cljs$core$async45663.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45663");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45663.
 */
cljs.core.async.__GT_t_cljs$core$async45663 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45663(f__$1,ch__$1,meta45655__$1,___$2,fn1__$1,meta45664){
return (new cljs.core.async.t_cljs$core$async45663(f__$1,ch__$1,meta45655__$1,___$2,fn1__$1,meta45664));
});

}

return (new cljs.core.async.t_cljs$core$async45663(self__.f,self__.ch,self__.meta45655,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4149__auto__ = ret;
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4149__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__45679 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__45679) : self__.f.call(null,G__45679));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45654.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async45654.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45655","meta45655",408716119,null)], null);
}));

(cljs.core.async.t_cljs$core$async45654.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45654.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45654");

(cljs.core.async.t_cljs$core$async45654.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45654");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45654.
 */
cljs.core.async.__GT_t_cljs$core$async45654 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async45654(f__$1,ch__$1,meta45655){
return (new cljs.core.async.t_cljs$core$async45654(f__$1,ch__$1,meta45655));
});

}

return (new cljs.core.async.t_cljs$core$async45654(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45693 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45693 = (function (f,ch,meta45694){
this.f = f;
this.ch = ch;
this.meta45694 = meta45694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45695,meta45694__$1){
var self__ = this;
var _45695__$1 = this;
return (new cljs.core.async.t_cljs$core$async45693(self__.f,self__.ch,meta45694__$1));
}));

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45695){
var self__ = this;
var _45695__$1 = this;
return self__.meta45694;
}));

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45693.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async45693.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45694","meta45694",-91261908,null)], null);
}));

(cljs.core.async.t_cljs$core$async45693.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45693.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45693");

(cljs.core.async.t_cljs$core$async45693.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45693");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45693.
 */
cljs.core.async.__GT_t_cljs$core$async45693 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async45693(f__$1,ch__$1,meta45694){
return (new cljs.core.async.t_cljs$core$async45693(f__$1,ch__$1,meta45694));
});

}

return (new cljs.core.async.t_cljs$core$async45693(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45712 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45712 = (function (p,ch,meta45713){
this.p = p;
this.ch = ch;
this.meta45713 = meta45713;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45714,meta45713__$1){
var self__ = this;
var _45714__$1 = this;
return (new cljs.core.async.t_cljs$core$async45712(self__.p,self__.ch,meta45713__$1));
}));

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45714){
var self__ = this;
var _45714__$1 = this;
return self__.meta45713;
}));

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45712.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async45712.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta45713","meta45713",897306508,null)], null);
}));

(cljs.core.async.t_cljs$core$async45712.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45712.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45712");

(cljs.core.async.t_cljs$core$async45712.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async45712");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45712.
 */
cljs.core.async.__GT_t_cljs$core$async45712 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async45712(p__$1,ch__$1,meta45713){
return (new cljs.core.async.t_cljs$core$async45712(p__$1,ch__$1,meta45713));
});

}

return (new cljs.core.async.t_cljs$core$async45712(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__45718 = arguments.length;
switch (G__45718) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43458__auto___47739 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45740){
var state_val_45741 = (state_45740[(1)]);
if((state_val_45741 === (7))){
var inst_45736 = (state_45740[(2)]);
var state_45740__$1 = state_45740;
var statearr_45747_47740 = state_45740__$1;
(statearr_45747_47740[(2)] = inst_45736);

(statearr_45747_47740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (1))){
var state_45740__$1 = state_45740;
var statearr_45748_47742 = state_45740__$1;
(statearr_45748_47742[(2)] = null);

(statearr_45748_47742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (4))){
var inst_45722 = (state_45740[(7)]);
var inst_45722__$1 = (state_45740[(2)]);
var inst_45723 = (inst_45722__$1 == null);
var state_45740__$1 = (function (){var statearr_45749 = state_45740;
(statearr_45749[(7)] = inst_45722__$1);

return statearr_45749;
})();
if(cljs.core.truth_(inst_45723)){
var statearr_45751_47743 = state_45740__$1;
(statearr_45751_47743[(1)] = (5));

} else {
var statearr_45752_47744 = state_45740__$1;
(statearr_45752_47744[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (6))){
var inst_45722 = (state_45740[(7)]);
var inst_45727 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45722) : p.call(null,inst_45722));
var state_45740__$1 = state_45740;
if(cljs.core.truth_(inst_45727)){
var statearr_45753_47745 = state_45740__$1;
(statearr_45753_47745[(1)] = (8));

} else {
var statearr_45754_47746 = state_45740__$1;
(statearr_45754_47746[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (3))){
var inst_45738 = (state_45740[(2)]);
var state_45740__$1 = state_45740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45740__$1,inst_45738);
} else {
if((state_val_45741 === (2))){
var state_45740__$1 = state_45740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45740__$1,(4),ch);
} else {
if((state_val_45741 === (11))){
var inst_45730 = (state_45740[(2)]);
var state_45740__$1 = state_45740;
var statearr_45756_47748 = state_45740__$1;
(statearr_45756_47748[(2)] = inst_45730);

(statearr_45756_47748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (9))){
var state_45740__$1 = state_45740;
var statearr_45757_47749 = state_45740__$1;
(statearr_45757_47749[(2)] = null);

(statearr_45757_47749[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (5))){
var inst_45725 = cljs.core.async.close_BANG_(out);
var state_45740__$1 = state_45740;
var statearr_45758_47753 = state_45740__$1;
(statearr_45758_47753[(2)] = inst_45725);

(statearr_45758_47753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (10))){
var inst_45733 = (state_45740[(2)]);
var state_45740__$1 = (function (){var statearr_45759 = state_45740;
(statearr_45759[(8)] = inst_45733);

return statearr_45759;
})();
var statearr_45760_47756 = state_45740__$1;
(statearr_45760_47756[(2)] = null);

(statearr_45760_47756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45741 === (8))){
var inst_45722 = (state_45740[(7)]);
var state_45740__$1 = state_45740;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45740__$1,(11),out,inst_45722);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_45761 = [null,null,null,null,null,null,null,null,null];
(statearr_45761[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_45761[(1)] = (1));

return statearr_45761;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_45740){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45740);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45762){var ex__43208__auto__ = e45762;
var statearr_45763_47761 = state_45740;
(statearr_45763_47761[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45740[(4)]))){
var statearr_45766_47763 = state_45740;
(statearr_45766_47763[(1)] = cljs.core.first((state_45740[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47767 = state_45740;
state_45740 = G__47767;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_45740){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_45740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45767 = f__43459__auto__();
(statearr_45767[(6)] = c__43458__auto___47739);

return statearr_45767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__45776 = arguments.length;
switch (G__45776) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43458__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45855){
var state_val_45856 = (state_45855[(1)]);
if((state_val_45856 === (7))){
var inst_45851 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45857_47797 = state_45855__$1;
(statearr_45857_47797[(2)] = inst_45851);

(statearr_45857_47797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (20))){
var inst_45821 = (state_45855[(7)]);
var inst_45832 = (state_45855[(2)]);
var inst_45833 = cljs.core.next(inst_45821);
var inst_45806 = inst_45833;
var inst_45807 = null;
var inst_45808 = (0);
var inst_45809 = (0);
var state_45855__$1 = (function (){var statearr_45859 = state_45855;
(statearr_45859[(8)] = inst_45806);

(statearr_45859[(9)] = inst_45807);

(statearr_45859[(10)] = inst_45809);

(statearr_45859[(11)] = inst_45832);

(statearr_45859[(12)] = inst_45808);

return statearr_45859;
})();
var statearr_45860_47815 = state_45855__$1;
(statearr_45860_47815[(2)] = null);

(statearr_45860_47815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (1))){
var state_45855__$1 = state_45855;
var statearr_45861_47821 = state_45855__$1;
(statearr_45861_47821[(2)] = null);

(statearr_45861_47821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (4))){
var inst_45795 = (state_45855[(13)]);
var inst_45795__$1 = (state_45855[(2)]);
var inst_45796 = (inst_45795__$1 == null);
var state_45855__$1 = (function (){var statearr_45862 = state_45855;
(statearr_45862[(13)] = inst_45795__$1);

return statearr_45862;
})();
if(cljs.core.truth_(inst_45796)){
var statearr_45863_47829 = state_45855__$1;
(statearr_45863_47829[(1)] = (5));

} else {
var statearr_45864_47835 = state_45855__$1;
(statearr_45864_47835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (15))){
var state_45855__$1 = state_45855;
var statearr_45868_47840 = state_45855__$1;
(statearr_45868_47840[(2)] = null);

(statearr_45868_47840[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (21))){
var state_45855__$1 = state_45855;
var statearr_45869_47844 = state_45855__$1;
(statearr_45869_47844[(2)] = null);

(statearr_45869_47844[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (13))){
var inst_45806 = (state_45855[(8)]);
var inst_45807 = (state_45855[(9)]);
var inst_45809 = (state_45855[(10)]);
var inst_45808 = (state_45855[(12)]);
var inst_45817 = (state_45855[(2)]);
var inst_45818 = (inst_45809 + (1));
var tmp45865 = inst_45806;
var tmp45866 = inst_45807;
var tmp45867 = inst_45808;
var inst_45806__$1 = tmp45865;
var inst_45807__$1 = tmp45866;
var inst_45808__$1 = tmp45867;
var inst_45809__$1 = inst_45818;
var state_45855__$1 = (function (){var statearr_45873 = state_45855;
(statearr_45873[(8)] = inst_45806__$1);

(statearr_45873[(9)] = inst_45807__$1);

(statearr_45873[(10)] = inst_45809__$1);

(statearr_45873[(14)] = inst_45817);

(statearr_45873[(12)] = inst_45808__$1);

return statearr_45873;
})();
var statearr_45874_47866 = state_45855__$1;
(statearr_45874_47866[(2)] = null);

(statearr_45874_47866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (22))){
var state_45855__$1 = state_45855;
var statearr_45876_47872 = state_45855__$1;
(statearr_45876_47872[(2)] = null);

(statearr_45876_47872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (6))){
var inst_45795 = (state_45855[(13)]);
var inst_45804 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_45795) : f.call(null,inst_45795));
var inst_45805 = cljs.core.seq(inst_45804);
var inst_45806 = inst_45805;
var inst_45807 = null;
var inst_45808 = (0);
var inst_45809 = (0);
var state_45855__$1 = (function (){var statearr_45881 = state_45855;
(statearr_45881[(8)] = inst_45806);

(statearr_45881[(9)] = inst_45807);

(statearr_45881[(10)] = inst_45809);

(statearr_45881[(12)] = inst_45808);

return statearr_45881;
})();
var statearr_45883_47890 = state_45855__$1;
(statearr_45883_47890[(2)] = null);

(statearr_45883_47890[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (17))){
var inst_45821 = (state_45855[(7)]);
var inst_45825 = cljs.core.chunk_first(inst_45821);
var inst_45826 = cljs.core.chunk_rest(inst_45821);
var inst_45827 = cljs.core.count(inst_45825);
var inst_45806 = inst_45826;
var inst_45807 = inst_45825;
var inst_45808 = inst_45827;
var inst_45809 = (0);
var state_45855__$1 = (function (){var statearr_45885 = state_45855;
(statearr_45885[(8)] = inst_45806);

(statearr_45885[(9)] = inst_45807);

(statearr_45885[(10)] = inst_45809);

(statearr_45885[(12)] = inst_45808);

return statearr_45885;
})();
var statearr_45886_47900 = state_45855__$1;
(statearr_45886_47900[(2)] = null);

(statearr_45886_47900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (3))){
var inst_45853 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45855__$1,inst_45853);
} else {
if((state_val_45856 === (12))){
var inst_45841 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45888_47909 = state_45855__$1;
(statearr_45888_47909[(2)] = inst_45841);

(statearr_45888_47909[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (2))){
var state_45855__$1 = state_45855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45855__$1,(4),in$);
} else {
if((state_val_45856 === (23))){
var inst_45849 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45889_47914 = state_45855__$1;
(statearr_45889_47914[(2)] = inst_45849);

(statearr_45889_47914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (19))){
var inst_45836 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45890_47917 = state_45855__$1;
(statearr_45890_47917[(2)] = inst_45836);

(statearr_45890_47917[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (11))){
var inst_45806 = (state_45855[(8)]);
var inst_45821 = (state_45855[(7)]);
var inst_45821__$1 = cljs.core.seq(inst_45806);
var state_45855__$1 = (function (){var statearr_45893 = state_45855;
(statearr_45893[(7)] = inst_45821__$1);

return statearr_45893;
})();
if(inst_45821__$1){
var statearr_45894_47920 = state_45855__$1;
(statearr_45894_47920[(1)] = (14));

} else {
var statearr_45895_47921 = state_45855__$1;
(statearr_45895_47921[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (9))){
var inst_45843 = (state_45855[(2)]);
var inst_45844 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_45855__$1 = (function (){var statearr_45897 = state_45855;
(statearr_45897[(15)] = inst_45843);

return statearr_45897;
})();
if(cljs.core.truth_(inst_45844)){
var statearr_45898_47923 = state_45855__$1;
(statearr_45898_47923[(1)] = (21));

} else {
var statearr_45899_47924 = state_45855__$1;
(statearr_45899_47924[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (5))){
var inst_45798 = cljs.core.async.close_BANG_(out);
var state_45855__$1 = state_45855;
var statearr_45900_47927 = state_45855__$1;
(statearr_45900_47927[(2)] = inst_45798);

(statearr_45900_47927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (14))){
var inst_45821 = (state_45855[(7)]);
var inst_45823 = cljs.core.chunked_seq_QMARK_(inst_45821);
var state_45855__$1 = state_45855;
if(inst_45823){
var statearr_45901_47929 = state_45855__$1;
(statearr_45901_47929[(1)] = (17));

} else {
var statearr_45902_47930 = state_45855__$1;
(statearr_45902_47930[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (16))){
var inst_45839 = (state_45855[(2)]);
var state_45855__$1 = state_45855;
var statearr_45904_47931 = state_45855__$1;
(statearr_45904_47931[(2)] = inst_45839);

(statearr_45904_47931[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45856 === (10))){
var inst_45807 = (state_45855[(9)]);
var inst_45809 = (state_45855[(10)]);
var inst_45815 = cljs.core._nth(inst_45807,inst_45809);
var state_45855__$1 = state_45855;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45855__$1,(13),out,inst_45815);
} else {
if((state_val_45856 === (18))){
var inst_45821 = (state_45855[(7)]);
var inst_45830 = cljs.core.first(inst_45821);
var state_45855__$1 = state_45855;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45855__$1,(20),out,inst_45830);
} else {
if((state_val_45856 === (8))){
var inst_45809 = (state_45855[(10)]);
var inst_45808 = (state_45855[(12)]);
var inst_45812 = (inst_45809 < inst_45808);
var inst_45813 = inst_45812;
var state_45855__$1 = state_45855;
if(cljs.core.truth_(inst_45813)){
var statearr_45908_47933 = state_45855__$1;
(statearr_45908_47933[(1)] = (10));

} else {
var statearr_45909_47934 = state_45855__$1;
(statearr_45909_47934[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__43205__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__43205__auto____0 = (function (){
var statearr_45910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45910[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__43205__auto__);

(statearr_45910[(1)] = (1));

return statearr_45910;
});
var cljs$core$async$mapcat_STAR__$_state_machine__43205__auto____1 = (function (state_45855){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45855);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45911){var ex__43208__auto__ = e45911;
var statearr_45913_47942 = state_45855;
(statearr_45913_47942[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45855[(4)]))){
var statearr_45915_47947 = state_45855;
(statearr_45915_47947[(1)] = cljs.core.first((state_45855[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47952 = state_45855;
state_45855 = G__47952;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__43205__auto__ = function(state_45855){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__43205__auto____1.call(this,state_45855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__43205__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__43205__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45916 = f__43459__auto__();
(statearr_45916[(6)] = c__43458__auto__);

return statearr_45916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));

return c__43458__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__45919 = arguments.length;
switch (G__45919) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__45922 = arguments.length;
switch (G__45922) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__45931 = arguments.length;
switch (G__45931) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43458__auto___48039 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_45956){
var state_val_45957 = (state_45956[(1)]);
if((state_val_45957 === (7))){
var inst_45951 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45960_48046 = state_45956__$1;
(statearr_45960_48046[(2)] = inst_45951);

(statearr_45960_48046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (1))){
var inst_45933 = null;
var state_45956__$1 = (function (){var statearr_45962 = state_45956;
(statearr_45962[(7)] = inst_45933);

return statearr_45962;
})();
var statearr_45963_48050 = state_45956__$1;
(statearr_45963_48050[(2)] = null);

(statearr_45963_48050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (4))){
var inst_45936 = (state_45956[(8)]);
var inst_45936__$1 = (state_45956[(2)]);
var inst_45937 = (inst_45936__$1 == null);
var inst_45938 = cljs.core.not(inst_45937);
var state_45956__$1 = (function (){var statearr_45964 = state_45956;
(statearr_45964[(8)] = inst_45936__$1);

return statearr_45964;
})();
if(inst_45938){
var statearr_45965_48052 = state_45956__$1;
(statearr_45965_48052[(1)] = (5));

} else {
var statearr_45966_48053 = state_45956__$1;
(statearr_45966_48053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (6))){
var state_45956__$1 = state_45956;
var statearr_45967_48056 = state_45956__$1;
(statearr_45967_48056[(2)] = null);

(statearr_45967_48056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (3))){
var inst_45953 = (state_45956[(2)]);
var inst_45954 = cljs.core.async.close_BANG_(out);
var state_45956__$1 = (function (){var statearr_45968 = state_45956;
(statearr_45968[(9)] = inst_45953);

return statearr_45968;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45956__$1,inst_45954);
} else {
if((state_val_45957 === (2))){
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45956__$1,(4),ch);
} else {
if((state_val_45957 === (11))){
var inst_45936 = (state_45956[(8)]);
var inst_45945 = (state_45956[(2)]);
var inst_45933 = inst_45936;
var state_45956__$1 = (function (){var statearr_45969 = state_45956;
(statearr_45969[(7)] = inst_45933);

(statearr_45969[(10)] = inst_45945);

return statearr_45969;
})();
var statearr_45970_48061 = state_45956__$1;
(statearr_45970_48061[(2)] = null);

(statearr_45970_48061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (9))){
var inst_45936 = (state_45956[(8)]);
var state_45956__$1 = state_45956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45956__$1,(11),out,inst_45936);
} else {
if((state_val_45957 === (5))){
var inst_45933 = (state_45956[(7)]);
var inst_45936 = (state_45956[(8)]);
var inst_45940 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_45936,inst_45933);
var state_45956__$1 = state_45956;
if(inst_45940){
var statearr_45975_48067 = state_45956__$1;
(statearr_45975_48067[(1)] = (8));

} else {
var statearr_45976_48072 = state_45956__$1;
(statearr_45976_48072[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (10))){
var inst_45948 = (state_45956[(2)]);
var state_45956__$1 = state_45956;
var statearr_45978_48077 = state_45956__$1;
(statearr_45978_48077[(2)] = inst_45948);

(statearr_45978_48077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45957 === (8))){
var inst_45933 = (state_45956[(7)]);
var tmp45974 = inst_45933;
var inst_45933__$1 = tmp45974;
var state_45956__$1 = (function (){var statearr_45979 = state_45956;
(statearr_45979[(7)] = inst_45933__$1);

return statearr_45979;
})();
var statearr_45980_48078 = state_45956__$1;
(statearr_45980_48078[(2)] = null);

(statearr_45980_48078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_45981 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45981[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_45981[(1)] = (1));

return statearr_45981;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_45956){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_45956);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e45982){var ex__43208__auto__ = e45982;
var statearr_45983_48084 = state_45956;
(statearr_45983_48084[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_45956[(4)]))){
var statearr_45985_48085 = state_45956;
(statearr_45985_48085[(1)] = cljs.core.first((state_45956[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48091 = state_45956;
state_45956 = G__48091;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_45956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_45956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_45986 = f__43459__auto__();
(statearr_45986[(6)] = c__43458__auto___48039);

return statearr_45986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__45992 = arguments.length;
switch (G__45992) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43458__auto___48093 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_46034){
var state_val_46035 = (state_46034[(1)]);
if((state_val_46035 === (7))){
var inst_46030 = (state_46034[(2)]);
var state_46034__$1 = state_46034;
var statearr_46038_48096 = state_46034__$1;
(statearr_46038_48096[(2)] = inst_46030);

(statearr_46038_48096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (1))){
var inst_45996 = (new Array(n));
var inst_45998 = inst_45996;
var inst_45999 = (0);
var state_46034__$1 = (function (){var statearr_46039 = state_46034;
(statearr_46039[(7)] = inst_45998);

(statearr_46039[(8)] = inst_45999);

return statearr_46039;
})();
var statearr_46040_48099 = state_46034__$1;
(statearr_46040_48099[(2)] = null);

(statearr_46040_48099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (4))){
var inst_46002 = (state_46034[(9)]);
var inst_46002__$1 = (state_46034[(2)]);
var inst_46003 = (inst_46002__$1 == null);
var inst_46004 = cljs.core.not(inst_46003);
var state_46034__$1 = (function (){var statearr_46042 = state_46034;
(statearr_46042[(9)] = inst_46002__$1);

return statearr_46042;
})();
if(inst_46004){
var statearr_46043_48103 = state_46034__$1;
(statearr_46043_48103[(1)] = (5));

} else {
var statearr_46044_48104 = state_46034__$1;
(statearr_46044_48104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (15))){
var inst_46024 = (state_46034[(2)]);
var state_46034__$1 = state_46034;
var statearr_46045_48105 = state_46034__$1;
(statearr_46045_48105[(2)] = inst_46024);

(statearr_46045_48105[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (13))){
var state_46034__$1 = state_46034;
var statearr_46046_48109 = state_46034__$1;
(statearr_46046_48109[(2)] = null);

(statearr_46046_48109[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (6))){
var inst_45999 = (state_46034[(8)]);
var inst_46020 = (inst_45999 > (0));
var state_46034__$1 = state_46034;
if(cljs.core.truth_(inst_46020)){
var statearr_46047_48111 = state_46034__$1;
(statearr_46047_48111[(1)] = (12));

} else {
var statearr_46048_48112 = state_46034__$1;
(statearr_46048_48112[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (3))){
var inst_46032 = (state_46034[(2)]);
var state_46034__$1 = state_46034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46034__$1,inst_46032);
} else {
if((state_val_46035 === (12))){
var inst_45998 = (state_46034[(7)]);
var inst_46022 = cljs.core.vec(inst_45998);
var state_46034__$1 = state_46034;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46034__$1,(15),out,inst_46022);
} else {
if((state_val_46035 === (2))){
var state_46034__$1 = state_46034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46034__$1,(4),ch);
} else {
if((state_val_46035 === (11))){
var inst_46014 = (state_46034[(2)]);
var inst_46015 = (new Array(n));
var inst_45998 = inst_46015;
var inst_45999 = (0);
var state_46034__$1 = (function (){var statearr_46049 = state_46034;
(statearr_46049[(10)] = inst_46014);

(statearr_46049[(7)] = inst_45998);

(statearr_46049[(8)] = inst_45999);

return statearr_46049;
})();
var statearr_46050_48119 = state_46034__$1;
(statearr_46050_48119[(2)] = null);

(statearr_46050_48119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (9))){
var inst_45998 = (state_46034[(7)]);
var inst_46012 = cljs.core.vec(inst_45998);
var state_46034__$1 = state_46034;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46034__$1,(11),out,inst_46012);
} else {
if((state_val_46035 === (5))){
var inst_46002 = (state_46034[(9)]);
var inst_46007 = (state_46034[(11)]);
var inst_45998 = (state_46034[(7)]);
var inst_45999 = (state_46034[(8)]);
var inst_46006 = (inst_45998[inst_45999] = inst_46002);
var inst_46007__$1 = (inst_45999 + (1));
var inst_46008 = (inst_46007__$1 < n);
var state_46034__$1 = (function (){var statearr_46052 = state_46034;
(statearr_46052[(12)] = inst_46006);

(statearr_46052[(11)] = inst_46007__$1);

return statearr_46052;
})();
if(cljs.core.truth_(inst_46008)){
var statearr_46053_48120 = state_46034__$1;
(statearr_46053_48120[(1)] = (8));

} else {
var statearr_46054_48121 = state_46034__$1;
(statearr_46054_48121[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (14))){
var inst_46027 = (state_46034[(2)]);
var inst_46028 = cljs.core.async.close_BANG_(out);
var state_46034__$1 = (function (){var statearr_46057 = state_46034;
(statearr_46057[(13)] = inst_46027);

return statearr_46057;
})();
var statearr_46058_48123 = state_46034__$1;
(statearr_46058_48123[(2)] = inst_46028);

(statearr_46058_48123[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (10))){
var inst_46018 = (state_46034[(2)]);
var state_46034__$1 = state_46034;
var statearr_46059_48126 = state_46034__$1;
(statearr_46059_48126[(2)] = inst_46018);

(statearr_46059_48126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46035 === (8))){
var inst_46007 = (state_46034[(11)]);
var inst_45998 = (state_46034[(7)]);
var tmp46055 = inst_45998;
var inst_45998__$1 = tmp46055;
var inst_45999 = inst_46007;
var state_46034__$1 = (function (){var statearr_46060 = state_46034;
(statearr_46060[(7)] = inst_45998__$1);

(statearr_46060[(8)] = inst_45999);

return statearr_46060;
})();
var statearr_46061_48132 = state_46034__$1;
(statearr_46061_48132[(2)] = null);

(statearr_46061_48132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_46062 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46062[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_46062[(1)] = (1));

return statearr_46062;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_46034){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_46034);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e46063){var ex__43208__auto__ = e46063;
var statearr_46064_48133 = state_46034;
(statearr_46064_48133[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_46034[(4)]))){
var statearr_46066_48134 = state_46034;
(statearr_46066_48134[(1)] = cljs.core.first((state_46034[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48135 = state_46034;
state_46034 = G__48135;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_46034){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_46034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_46067 = f__43459__auto__();
(statearr_46067[(6)] = c__43458__auto___48093);

return statearr_46067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46069 = arguments.length;
switch (G__46069) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43458__auto___48145 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_46113){
var state_val_46114 = (state_46113[(1)]);
if((state_val_46114 === (7))){
var inst_46109 = (state_46113[(2)]);
var state_46113__$1 = state_46113;
var statearr_46115_48146 = state_46113__$1;
(statearr_46115_48146[(2)] = inst_46109);

(statearr_46115_48146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (1))){
var inst_46071 = [];
var inst_46072 = inst_46071;
var inst_46073 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_46113__$1 = (function (){var statearr_46116 = state_46113;
(statearr_46116[(7)] = inst_46072);

(statearr_46116[(8)] = inst_46073);

return statearr_46116;
})();
var statearr_46117_48151 = state_46113__$1;
(statearr_46117_48151[(2)] = null);

(statearr_46117_48151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (4))){
var inst_46076 = (state_46113[(9)]);
var inst_46076__$1 = (state_46113[(2)]);
var inst_46077 = (inst_46076__$1 == null);
var inst_46078 = cljs.core.not(inst_46077);
var state_46113__$1 = (function (){var statearr_46119 = state_46113;
(statearr_46119[(9)] = inst_46076__$1);

return statearr_46119;
})();
if(inst_46078){
var statearr_46120_48153 = state_46113__$1;
(statearr_46120_48153[(1)] = (5));

} else {
var statearr_46121_48154 = state_46113__$1;
(statearr_46121_48154[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (15))){
var inst_46103 = (state_46113[(2)]);
var state_46113__$1 = state_46113;
var statearr_46123_48155 = state_46113__$1;
(statearr_46123_48155[(2)] = inst_46103);

(statearr_46123_48155[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (13))){
var state_46113__$1 = state_46113;
var statearr_46124_48158 = state_46113__$1;
(statearr_46124_48158[(2)] = null);

(statearr_46124_48158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (6))){
var inst_46072 = (state_46113[(7)]);
var inst_46098 = inst_46072.length;
var inst_46099 = (inst_46098 > (0));
var state_46113__$1 = state_46113;
if(cljs.core.truth_(inst_46099)){
var statearr_46127_48160 = state_46113__$1;
(statearr_46127_48160[(1)] = (12));

} else {
var statearr_46128_48161 = state_46113__$1;
(statearr_46128_48161[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (3))){
var inst_46111 = (state_46113[(2)]);
var state_46113__$1 = state_46113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46113__$1,inst_46111);
} else {
if((state_val_46114 === (12))){
var inst_46072 = (state_46113[(7)]);
var inst_46101 = cljs.core.vec(inst_46072);
var state_46113__$1 = state_46113;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46113__$1,(15),out,inst_46101);
} else {
if((state_val_46114 === (2))){
var state_46113__$1 = state_46113;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46113__$1,(4),ch);
} else {
if((state_val_46114 === (11))){
var inst_46080 = (state_46113[(10)]);
var inst_46076 = (state_46113[(9)]);
var inst_46091 = (state_46113[(2)]);
var inst_46092 = [];
var inst_46093 = inst_46092.push(inst_46076);
var inst_46072 = inst_46092;
var inst_46073 = inst_46080;
var state_46113__$1 = (function (){var statearr_46131 = state_46113;
(statearr_46131[(11)] = inst_46093);

(statearr_46131[(7)] = inst_46072);

(statearr_46131[(12)] = inst_46091);

(statearr_46131[(8)] = inst_46073);

return statearr_46131;
})();
var statearr_46132_48164 = state_46113__$1;
(statearr_46132_48164[(2)] = null);

(statearr_46132_48164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (9))){
var inst_46072 = (state_46113[(7)]);
var inst_46089 = cljs.core.vec(inst_46072);
var state_46113__$1 = state_46113;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46113__$1,(11),out,inst_46089);
} else {
if((state_val_46114 === (5))){
var inst_46080 = (state_46113[(10)]);
var inst_46076 = (state_46113[(9)]);
var inst_46073 = (state_46113[(8)]);
var inst_46080__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_46076) : f.call(null,inst_46076));
var inst_46081 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46080__$1,inst_46073);
var inst_46082 = cljs.core.keyword_identical_QMARK_(inst_46073,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_46083 = ((inst_46081) || (inst_46082));
var state_46113__$1 = (function (){var statearr_46135 = state_46113;
(statearr_46135[(10)] = inst_46080__$1);

return statearr_46135;
})();
if(cljs.core.truth_(inst_46083)){
var statearr_46136_48175 = state_46113__$1;
(statearr_46136_48175[(1)] = (8));

} else {
var statearr_46137_48176 = state_46113__$1;
(statearr_46137_48176[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (14))){
var inst_46106 = (state_46113[(2)]);
var inst_46107 = cljs.core.async.close_BANG_(out);
var state_46113__$1 = (function (){var statearr_46139 = state_46113;
(statearr_46139[(13)] = inst_46106);

return statearr_46139;
})();
var statearr_46141_48177 = state_46113__$1;
(statearr_46141_48177[(2)] = inst_46107);

(statearr_46141_48177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (10))){
var inst_46096 = (state_46113[(2)]);
var state_46113__$1 = state_46113;
var statearr_46145_48179 = state_46113__$1;
(statearr_46145_48179[(2)] = inst_46096);

(statearr_46145_48179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46114 === (8))){
var inst_46080 = (state_46113[(10)]);
var inst_46076 = (state_46113[(9)]);
var inst_46072 = (state_46113[(7)]);
var inst_46086 = inst_46072.push(inst_46076);
var tmp46138 = inst_46072;
var inst_46072__$1 = tmp46138;
var inst_46073 = inst_46080;
var state_46113__$1 = (function (){var statearr_46146 = state_46113;
(statearr_46146[(14)] = inst_46086);

(statearr_46146[(7)] = inst_46072__$1);

(statearr_46146[(8)] = inst_46073);

return statearr_46146;
})();
var statearr_46147_48183 = state_46113__$1;
(statearr_46147_48183[(2)] = null);

(statearr_46147_48183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__43205__auto__ = null;
var cljs$core$async$state_machine__43205__auto____0 = (function (){
var statearr_46148 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46148[(0)] = cljs$core$async$state_machine__43205__auto__);

(statearr_46148[(1)] = (1));

return statearr_46148;
});
var cljs$core$async$state_machine__43205__auto____1 = (function (state_46113){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_46113);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e46149){var ex__43208__auto__ = e46149;
var statearr_46150_48187 = state_46113;
(statearr_46150_48187[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_46113[(4)]))){
var statearr_46151_48188 = state_46113;
(statearr_46151_48188[(1)] = cljs.core.first((state_46113[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48191 = state_46113;
state_46113 = G__48191;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
cljs$core$async$state_machine__43205__auto__ = function(state_46113){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__43205__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__43205__auto____1.call(this,state_46113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__43205__auto____0;
cljs$core$async$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__43205__auto____1;
return cljs$core$async$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_46153 = f__43459__auto__();
(statearr_46153[(6)] = c__43458__auto___48145);

return statearr_46153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
