goog.provide('gorilla_notes.components.leaflet');
var module$node_modules$react_leaflet$lib$index=shadow.js.require("module$node_modules$react_leaflet$lib$index", {});
var module$node_modules$leaflet$dist$leaflet_src=shadow.js.require("module$node_modules$leaflet$dist$leaflet_src", {});
gorilla_notes.components.leaflet.default_options = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"zoom","zoom",-1827487038),new cljs.core.Keyword(null,"line-join","line-join",-1560936092),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"tile-layer","tile-layer",192729190),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"dash-array","dash-array",2130256592),new cljs.core.Keyword(null,"weight","weight",-1262796205),new cljs.core.Keyword(null,"opacity","opacity",397153780),new cljs.core.Keyword(null,"line-cap","line-cap",448406012),new cljs.core.Keyword(null,"height","height",1025178622)],[(10),"miter","steelblue",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",new cljs.core.Keyword(null,"attribution","attribution",1937239286),"&copy; <a href=&quot;http://osm.org/copyright&quot;>OpenStreetMap</a> contributors"], null),(600),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [8.5407166,-79.8833319], null),"1, 0",5.0,1.0,"butt",(400)]);
gorilla_notes.components.leaflet.log = (function gorilla_notes$components$leaflet$log(s){
return console.log(s);
});
gorilla_notes.components.leaflet.feature = (function gorilla_notes$components$leaflet$feature(data_with_type){
var type = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(data_with_type);
var data = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(data_with_type,new cljs.core.Keyword(null,"type","type",1174270348));
var G__53581 = type;
var G__53581__$1 = (((G__53581 instanceof cljs.core.Keyword))?G__53581.fqn:null);
switch (G__53581__$1) {
case "rectangle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Rectangle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circle":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Circle,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "line":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polyline,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "polygon":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Polygon,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "marker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Marker,data,(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "circlemarker":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.CircleMarker,data,(((!((new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data) == null))))?cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Popup,new cljs.core.Keyword(null,"popup","popup",635890211).cljs$core$IFn$_invoke$arity$1(data)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null)):null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
case "geojson":
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.GeoJSON,data], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"r","r",-471384190),true], null));

break;
default:
gorilla_notes.components.leaflet.log(["No feature found for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''));

return null;

}
});
gorilla_notes.components.leaflet.view_QMARK_ = (function gorilla_notes$components$leaflet$view_QMARK_(feature){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(feature));
});
gorilla_notes.components.leaflet.assoc_if_exists = (function gorilla_notes$components$leaflet$assoc_if_exists(m,key,val){
if((val == null)){
return m;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,key,val);
}
});
gorilla_notes.components.leaflet.view_map_props = (function gorilla_notes$components$leaflet$view_map_props(view){
var map__53594 = view;
var map__53594__$1 = (((((!((map__53594 == null))))?(((((map__53594.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53594.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53594):map__53594);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53594__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53594__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53594__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53594__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var useFlyTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53594__$1,new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032));
var style = (cljs.core.truth_((function (){var or__4126__auto__ = width;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return height;
}
})())?gorilla_notes.components.leaflet.assoc_if_exists(gorilla_notes.components.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"width","width",-384071477),width),new cljs.core.Keyword(null,"height","height",1025178622),height):null);
return gorilla_notes.components.leaflet.assoc_if_exists(gorilla_notes.components.leaflet.assoc_if_exists(gorilla_notes.components.leaflet.assoc_if_exists(gorilla_notes.components.leaflet.assoc_if_exists(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"style","style",-496642736),style),new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom),new cljs.core.Keyword(null,"center","center",-748944368),center),new cljs.core.Keyword(null,"useFlyTo","useFlyTo",1726688032),useFlyTo);
});
/**
 * displays a map with leaflet.
 *   example:
 *  [:p/leaflet
 *   [{:type :view :center [51.49, -0.08] :zoom 12 :height 600 :width 700}
 *  {:type :rectangle :bounds rectangle}
 *    {:type :circle :center center :fillColor :blue :radius 200}
 *  {:type :polygon :positions polygon :color :purple}
 *  {:type :polygon :positions multiPolygon :color :purple}
 *  {:type :line :positions polyline :color :lime}
 *  {:type :line :positions multi-polyline :color :lime}
 *  {:type :marker :position [51.505, -0.09]}
 *  {:type :marker :position [51.51, -0.12] :popup "wow"}
 *  {:type :circlemarker :center [51.52, -0.06] :fillColor :blue :radius 200 :popup "square the circle"}
 *  {:type :geojson :data geojson}]]
 */
gorilla_notes.components.leaflet.leaflet_map = (function gorilla_notes$components$leaflet$leaflet_map(var_args){
var G__53614 = arguments.length;
switch (G__53614) {
case 2:
return gorilla_notes.components.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return gorilla_notes.components.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(gorilla_notes.components.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2 = (function (options,features_incl_view){
var map__53618 = options;
var map__53618__$1 = (((((!((map__53618 == null))))?(((((map__53618.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53618.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53618):map__53618);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53618__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53618__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53618__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var center = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53618__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var tile_layer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53618__$1,new cljs.core.Keyword(null,"tile-layer","tile-layer",192729190));
var view = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(gorilla_notes.components.leaflet.view_QMARK_,features_incl_view));
var features = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(gorilla_notes.components.leaflet.view_QMARK_,features_incl_view);
var view_map = gorilla_notes.components.leaflet.view_map_props(view);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.z-10","div.z-10",-323390226),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.Map,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"zoom","zoom",-1827487038),zoom,new cljs.core.Keyword(null,"center","center",-748944368),center,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),width,new cljs.core.Keyword(null,"height","height",1025178622),height], null),new cljs.core.Keyword(null,"keyboard","keyboard",-617357087),true,new cljs.core.Keyword(null,"class","class",-2030961996),"z-10"], null),view_map], 0)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,">",">",-555517146),module$node_modules$react_leaflet$lib$index.TileLayer,tile_layer], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(gorilla_notes.components.leaflet.feature,features))], null)], null);
}));

(gorilla_notes.components.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$1 = (function (features){
return gorilla_notes.components.leaflet.leaflet_map.cljs$core$IFn$_invoke$arity$2(gorilla_notes.components.leaflet.default_options,features);
}));

(gorilla_notes.components.leaflet.leaflet_map.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=gorilla_notes.components.leaflet.js.map
