goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5720__auto__ = (function (){var fexpr__53367 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__53367.cljs$core$IFn$_invoke$arity$1 ? fexpr__53367.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__53367.call(null,channel));
})();
if(cljs.core.truth_(temp__5720__auto__)){
var req = temp__5720__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__53372){
var vec__53373 = p__53372;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53373,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53373,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__53376 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__53376)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__53376)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__53376)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__53376)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__53376)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__53376)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53376)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__53377){
var map__53378 = p__53377;
var map__53378__$1 = (((((!((map__53378 == null))))?(((((map__53378.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53378.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53378):map__53378);
var request = map__53378__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53378__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53378__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53378__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__53380 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__53380,default_headers);

cljs_http.core.apply_response_type_BANG_(G__53380,response_type);

G__53380.setTimeoutInterval(timeout);

G__53380.setWithCredentials(send_credentials);

return G__53380;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__53388){
var map__53389 = p__53388;
var map__53389__$1 = (((((!((map__53389 == null))))?(((((map__53389.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53389.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53389):map__53389);
var request = map__53389__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53389__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53389__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53389__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53389__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53389__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53389__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__53391 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__53391) : cljs_http.core.error_kw.call(null,G__53391));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_53469 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__53395_53470 = xhr;
G__53395_53470.setProgressEventsEnabled(true);

G__53395_53470.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_53469,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__53395_53470.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_53469,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__43781__auto___53472 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_53407){
var state_val_53408 = (state_53407[(1)]);
if((state_val_53408 === (1))){
var state_53407__$1 = state_53407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53407__$1,(2),cancel);
} else {
if((state_val_53408 === (2))){
var inst_53398 = (state_53407[(2)]);
var inst_53399 = xhr.isComplete();
var inst_53400 = cljs.core.not(inst_53399);
var state_53407__$1 = (function (){var statearr_53409 = state_53407;
(statearr_53409[(7)] = inst_53398);

return statearr_53409;
})();
if(inst_53400){
var statearr_53410_53473 = state_53407__$1;
(statearr_53410_53473[(1)] = (3));

} else {
var statearr_53411_53476 = state_53407__$1;
(statearr_53411_53476[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53408 === (3))){
var inst_53402 = xhr.abort();
var state_53407__$1 = state_53407;
var statearr_53412_53478 = state_53407__$1;
(statearr_53412_53478[(2)] = inst_53402);

(statearr_53412_53478[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53408 === (4))){
var state_53407__$1 = state_53407;
var statearr_53414_53479 = state_53407__$1;
(statearr_53414_53479[(2)] = null);

(statearr_53414_53479[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53408 === (5))){
var inst_53405 = (state_53407[(2)]);
var state_53407__$1 = state_53407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53407__$1,inst_53405);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__43550__auto__ = null;
var cljs_http$core$xhr_$_state_machine__43550__auto____0 = (function (){
var statearr_53418 = [null,null,null,null,null,null,null,null];
(statearr_53418[(0)] = cljs_http$core$xhr_$_state_machine__43550__auto__);

(statearr_53418[(1)] = (1));

return statearr_53418;
});
var cljs_http$core$xhr_$_state_machine__43550__auto____1 = (function (state_53407){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_53407);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e53419){var ex__43553__auto__ = e53419;
var statearr_53420_53485 = state_53407;
(statearr_53420_53485[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_53407[(4)]))){
var statearr_53421_53486 = state_53407;
(statearr_53421_53486[(1)] = cljs.core.first((state_53407[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53487 = state_53407;
state_53407 = G__53487;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__43550__auto__ = function(state_53407){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__43550__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__43550__auto____1.call(this,state_53407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__43550__auto____0;
cljs_http$core$xhr_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__43550__auto____1;
return cljs_http$core$xhr_$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_53422 = f__43782__auto__();
(statearr_53422[(6)] = c__43781__auto___53472);

return statearr_53422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__53429){
var map__53430 = p__53429;
var map__53430__$1 = (((((!((map__53430 == null))))?(((((map__53430.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53430.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53430):map__53430);
var request = map__53430__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53430__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53430__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53430__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__53430__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_53491 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_53491], null));

if(cljs.core.truth_(cancel)){
var c__43781__auto___53496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_53436){
var state_val_53437 = (state_53436[(1)]);
if((state_val_53437 === (1))){
var state_53436__$1 = state_53436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53436__$1,(2),cancel);
} else {
if((state_val_53437 === (2))){
var inst_53433 = (state_53436[(2)]);
var inst_53434 = jsonp.cancel(req_53491);
var state_53436__$1 = (function (){var statearr_53438 = state_53436;
(statearr_53438[(7)] = inst_53433);

return statearr_53438;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_53436__$1,inst_53434);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__43550__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__43550__auto____0 = (function (){
var statearr_53439 = [null,null,null,null,null,null,null,null];
(statearr_53439[(0)] = cljs_http$core$jsonp_$_state_machine__43550__auto__);

(statearr_53439[(1)] = (1));

return statearr_53439;
});
var cljs_http$core$jsonp_$_state_machine__43550__auto____1 = (function (state_53436){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_53436);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e53440){var ex__43553__auto__ = e53440;
var statearr_53441_53497 = state_53436;
(statearr_53441_53497[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_53436[(4)]))){
var statearr_53442_53502 = state_53436;
(statearr_53442_53502[(1)] = cljs.core.first((state_53436[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53503 = state_53436;
state_53436 = G__53503;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__43550__auto__ = function(state_53436){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__43550__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__43550__auto____1.call(this,state_53436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__43550__auto____0;
cljs_http$core$jsonp_$_state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__43550__auto____1;
return cljs_http$core$jsonp_$_state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_53445 = f__43782__auto__();
(statearr_53445[(6)] = c__43781__auto___53496);

return statearr_53445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__53452){
var map__53453 = p__53452;
var map__53453__$1 = (((((!((map__53453 == null))))?(((((map__53453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53453.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53453):map__53453);
var request = map__53453__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53453__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
