goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e53009){var e = e53009;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___53132 = arguments.length;
var i__4737__auto___53133 = (0);
while(true){
if((i__4737__auto___53133 < len__4736__auto___53132)){
args__4742__auto__.push((arguments[i__4737__auto___53133]));

var G__53134 = (i__4737__auto___53133 + (1));
i__4737__auto___53133 = G__53134;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__53014){
var vec__53015 = p__53014;
var map__53018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53015,(0),null);
var map__53018__$1 = (((((!((map__53018 == null))))?(((((map__53018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53018.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53018):map__53018);
var opts = map__53018__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53018__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53018__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53018__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53018__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__53020 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__53020__$1 = (((((!((map__53020 == null))))?(((((map__53020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53020.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53020):map__53020);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53020__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53020__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__53010_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__53010_SHARP_);
}));

(web_socket.onclose = (function (p1__53011_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__53011_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__43781__auto___53147 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43782__auto__ = (function (){var switch__43549__auto__ = (function (state_53089){
var state_val_53090 = (state_53089[(1)]);
if((state_val_53090 === (7))){
var inst_53085 = (state_53089[(2)]);
var state_53089__$1 = state_53089;
var statearr_53091_53151 = state_53089__$1;
(statearr_53091_53151[(2)] = inst_53085);

(statearr_53091_53151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (20))){
var state_53089__$1 = state_53089;
var statearr_53092_53154 = state_53089__$1;
(statearr_53092_53154[(2)] = null);

(statearr_53092_53154[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (1))){
var inst_53022 = false;
var state_53089__$1 = (function (){var statearr_53093 = state_53089;
(statearr_53093[(7)] = inst_53022);

return statearr_53093;
})();
var statearr_53094_53157 = state_53089__$1;
(statearr_53094_53157[(2)] = null);

(statearr_53094_53157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (4))){
var inst_53031 = (state_53089[(8)]);
var inst_53037 = (state_53089[(9)]);
var inst_53039 = (state_53089[(10)]);
var inst_53037__$1 = (state_53089[(2)]);
var inst_53038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53037__$1,(0),null);
var inst_53039__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53037__$1,(1),null);
var inst_53040 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_53039__$1,inst_53031);
var state_53089__$1 = (function (){var statearr_53095 = state_53089;
(statearr_53095[(11)] = inst_53038);

(statearr_53095[(9)] = inst_53037__$1);

(statearr_53095[(10)] = inst_53039__$1);

return statearr_53095;
})();
if(inst_53040){
var statearr_53096_53169 = state_53089__$1;
(statearr_53096_53169[(1)] = (5));

} else {
var statearr_53097_53170 = state_53089__$1;
(statearr_53097_53170[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (15))){
var inst_53070 = (state_53089[(2)]);
var state_53089__$1 = state_53089;
var statearr_53098_53172 = state_53089__$1;
(statearr_53098_53172[(2)] = inst_53070);

(statearr_53098_53172[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (21))){
var inst_53081 = (state_53089[(2)]);
var state_53089__$1 = state_53089;
var statearr_53099_53175 = state_53089__$1;
(statearr_53099_53175[(2)] = inst_53081);

(statearr_53099_53175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (13))){
var state_53089__$1 = state_53089;
var statearr_53100_53178 = state_53089__$1;
(statearr_53100_53178[(2)] = null);

(statearr_53100_53178[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (6))){
var inst_53032 = (state_53089[(12)]);
var inst_53039 = (state_53089[(10)]);
var inst_53054 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_53039,inst_53032);
var state_53089__$1 = state_53089;
if(inst_53054){
var statearr_53101_53182 = state_53089__$1;
(statearr_53101_53182[(1)] = (9));

} else {
var statearr_53102_53186 = state_53089__$1;
(statearr_53102_53186[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (17))){
var state_53089__$1 = state_53089;
var statearr_53104_53188 = state_53089__$1;
(statearr_53104_53188[(2)] = initial_ch);

(statearr_53104_53188[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (3))){
var inst_53087 = (state_53089[(2)]);
var state_53089__$1 = state_53089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53089__$1,inst_53087);
} else {
if((state_val_53090 === (12))){
var inst_53022 = (state_53089[(7)]);
var state_53089__$1 = state_53089;
if(cljs.core.truth_(inst_53022)){
var statearr_53109_53193 = state_53089__$1;
(statearr_53109_53193[(1)] = (16));

} else {
var statearr_53110_53194 = state_53089__$1;
(statearr_53110_53194[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (2))){
var inst_53032 = (state_53089[(12)]);
var inst_53031 = (state_53089[(8)]);
var inst_53031__$1 = open_ch;
var inst_53032__$1 = close_ch;
var inst_53033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53034 = [inst_53031__$1,inst_53032__$1];
var inst_53035 = (new cljs.core.PersistentVector(null,2,(5),inst_53033,inst_53034,null));
var state_53089__$1 = (function (){var statearr_53113 = state_53089;
(statearr_53113[(12)] = inst_53032__$1);

(statearr_53113[(8)] = inst_53031__$1);

return statearr_53113;
})();
return cljs.core.async.ioc_alts_BANG_(state_53089__$1,(4),inst_53035);
} else {
if((state_val_53090 === (19))){
var inst_53038 = (state_53089[(11)]);
var state_53089__$1 = state_53089;
var statearr_53114_53204 = state_53089__$1;
(statearr_53114_53204[(2)] = inst_53038);

(statearr_53114_53204[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (11))){
var inst_53083 = (state_53089[(2)]);
var state_53089__$1 = state_53089;
var statearr_53115_53207 = state_53089__$1;
(statearr_53115_53207[(2)] = inst_53083);

(statearr_53115_53207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (9))){
var inst_53037 = (state_53089[(9)]);
var inst_53060 = (state_53089[(13)]);
var inst_53059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53037,(0),null);
var inst_53060__$1 = chord.client.close_event__GT_maybe_error(inst_53059);
var state_53089__$1 = (function (){var statearr_53116 = state_53089;
(statearr_53116[(13)] = inst_53060__$1);

return statearr_53116;
})();
if(cljs.core.truth_(inst_53060__$1)){
var statearr_53117_53212 = state_53089__$1;
(statearr_53117_53212[(1)] = (12));

} else {
var statearr_53118_53213 = state_53089__$1;
(statearr_53118_53213[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (5))){
var inst_53037 = (state_53089[(9)]);
var inst_53045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53037,(0),null);
var inst_53046 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_53047 = [ws_chan];
var inst_53048 = cljs.core.PersistentHashMap.fromArrays(inst_53046,inst_53047);
var state_53089__$1 = (function (){var statearr_53119 = state_53089;
(statearr_53119[(14)] = inst_53045);

return statearr_53119;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_53089__$1,(8),initial_ch,inst_53048);
} else {
if((state_val_53090 === (14))){
var inst_53073 = (state_53089[(2)]);
var inst_53074 = cljs.core.async.close_BANG_(ws_chan);
var inst_53075 = cljs.core.async.close_BANG_(initial_ch);
var state_53089__$1 = (function (){var statearr_53120 = state_53089;
(statearr_53120[(15)] = inst_53073);

(statearr_53120[(16)] = inst_53074);

return statearr_53120;
})();
var statearr_53121_53219 = state_53089__$1;
(statearr_53121_53219[(2)] = inst_53075);

(statearr_53121_53219[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (16))){
var state_53089__$1 = state_53089;
var statearr_53122_53220 = state_53089__$1;
(statearr_53122_53220[(2)] = read_ch__$1);

(statearr_53122_53220[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (10))){
var inst_53039 = (state_53089[(10)]);
var inst_53077 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_53039,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_53089__$1 = state_53089;
if(inst_53077){
var statearr_53123_53221 = state_53089__$1;
(statearr_53123_53221[(1)] = (19));

} else {
var statearr_53124_53222 = state_53089__$1;
(statearr_53124_53222[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53090 === (18))){
var inst_53060 = (state_53089[(13)]);
var inst_53065 = (state_53089[(2)]);
var inst_53066 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_53067 = [inst_53060];
var inst_53068 = cljs.core.PersistentHashMap.fromArrays(inst_53066,inst_53067);
var state_53089__$1 = state_53089;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_53089__$1,(15),inst_53065,inst_53068);
} else {
if((state_val_53090 === (8))){
var inst_53050 = (state_53089[(2)]);
var inst_53051 = cljs.core.async.close_BANG_(initial_ch);
var inst_53022 = true;
var state_53089__$1 = (function (){var statearr_53125 = state_53089;
(statearr_53125[(7)] = inst_53022);

(statearr_53125[(17)] = inst_53051);

(statearr_53125[(18)] = inst_53050);

return statearr_53125;
})();
var statearr_53126_53223 = state_53089__$1;
(statearr_53126_53223[(2)] = null);

(statearr_53126_53223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__43550__auto__ = null;
var chord$client$state_machine__43550__auto____0 = (function (){
var statearr_53127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53127[(0)] = chord$client$state_machine__43550__auto__);

(statearr_53127[(1)] = (1));

return statearr_53127;
});
var chord$client$state_machine__43550__auto____1 = (function (state_53089){
while(true){
var ret_value__43551__auto__ = (function (){try{while(true){
var result__43552__auto__ = switch__43549__auto__(state_53089);
if(cljs.core.keyword_identical_QMARK_(result__43552__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43552__auto__;
}
break;
}
}catch (e53128){var ex__43553__auto__ = e53128;
var statearr_53129_53227 = state_53089;
(statearr_53129_53227[(2)] = ex__43553__auto__);


if(cljs.core.seq((state_53089[(4)]))){
var statearr_53130_53228 = state_53089;
(statearr_53130_53228[(1)] = cljs.core.first((state_53089[(4)])));

} else {
throw ex__43553__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43551__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53230 = state_53089;
state_53089 = G__53230;
continue;
} else {
return ret_value__43551__auto__;
}
break;
}
});
chord$client$state_machine__43550__auto__ = function(state_53089){
switch(arguments.length){
case 0:
return chord$client$state_machine__43550__auto____0.call(this);
case 1:
return chord$client$state_machine__43550__auto____1.call(this,state_53089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__43550__auto____0;
chord$client$state_machine__43550__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__43550__auto____1;
return chord$client$state_machine__43550__auto__;
})()
})();
var state__43783__auto__ = (function (){var statearr_53131 = f__43782__auto__();
(statearr_53131[(6)] = c__43781__auto___53147);

return statearr_53131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43783__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq53012){
var G__53013 = cljs.core.first(seq53012);
var seq53012__$1 = cljs.core.next(seq53012);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53013,seq53012__$1);
}));


//# sourceMappingURL=chord.client.js.map
