goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47171 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47171(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47176 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47176(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__46374 = coll;
var G__46375 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__46374,G__46375) : shadow.dom.lazy_native_coll_seq.call(null,G__46374,G__46375));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46398 = arguments.length;
switch (G__46398) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46409 = arguments.length;
switch (G__46409) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46421 = arguments.length;
switch (G__46421) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46436 = arguments.length;
switch (G__46436) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46450 = arguments.length;
switch (G__46450) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46472 = arguments.length;
switch (G__46472) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e46486){if((e46486 instanceof Object)){
var e = e46486;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46486;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46498 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__46499 = null;
var count__46500 = (0);
var i__46501 = (0);
while(true){
if((i__46501 < count__46500)){
var el = chunk__46499.cljs$core$IIndexed$_nth$arity$2(null,i__46501);
var handler_47197__$1 = ((function (seq__46498,chunk__46499,count__46500,i__46501,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46498,chunk__46499,count__46500,i__46501,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47197__$1);


var G__47198 = seq__46498;
var G__47199 = chunk__46499;
var G__47200 = count__46500;
var G__47201 = (i__46501 + (1));
seq__46498 = G__47198;
chunk__46499 = G__47199;
count__46500 = G__47200;
i__46501 = G__47201;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46498);
if(temp__5720__auto__){
var seq__46498__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46498__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46498__$1);
var G__47202 = cljs.core.chunk_rest(seq__46498__$1);
var G__47203 = c__4556__auto__;
var G__47204 = cljs.core.count(c__4556__auto__);
var G__47205 = (0);
seq__46498 = G__47202;
chunk__46499 = G__47203;
count__46500 = G__47204;
i__46501 = G__47205;
continue;
} else {
var el = cljs.core.first(seq__46498__$1);
var handler_47206__$1 = ((function (seq__46498,chunk__46499,count__46500,i__46501,el,seq__46498__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46498,chunk__46499,count__46500,i__46501,el,seq__46498__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47206__$1);


var G__47207 = cljs.core.next(seq__46498__$1);
var G__47208 = null;
var G__47209 = (0);
var G__47210 = (0);
seq__46498 = G__47207;
chunk__46499 = G__47208;
count__46500 = G__47209;
i__46501 = G__47210;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46530 = arguments.length;
switch (G__46530) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46547 = cljs.core.seq(events);
var chunk__46548 = null;
var count__46549 = (0);
var i__46550 = (0);
while(true){
if((i__46550 < count__46549)){
var vec__46573 = chunk__46548.cljs$core$IIndexed$_nth$arity$2(null,i__46550);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46573,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46573,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47213 = seq__46547;
var G__47214 = chunk__46548;
var G__47215 = count__46549;
var G__47216 = (i__46550 + (1));
seq__46547 = G__47213;
chunk__46548 = G__47214;
count__46549 = G__47215;
i__46550 = G__47216;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46547);
if(temp__5720__auto__){
var seq__46547__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46547__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46547__$1);
var G__47217 = cljs.core.chunk_rest(seq__46547__$1);
var G__47218 = c__4556__auto__;
var G__47219 = cljs.core.count(c__4556__auto__);
var G__47220 = (0);
seq__46547 = G__47217;
chunk__46548 = G__47218;
count__46549 = G__47219;
i__46550 = G__47220;
continue;
} else {
var vec__46577 = cljs.core.first(seq__46547__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46577,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46577,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47221 = cljs.core.next(seq__46547__$1);
var G__47222 = null;
var G__47223 = (0);
var G__47224 = (0);
seq__46547 = G__47221;
chunk__46548 = G__47222;
count__46549 = G__47223;
i__46550 = G__47224;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__46582 = cljs.core.seq(styles);
var chunk__46583 = null;
var count__46584 = (0);
var i__46585 = (0);
while(true){
if((i__46585 < count__46584)){
var vec__46599 = chunk__46583.cljs$core$IIndexed$_nth$arity$2(null,i__46585);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46599,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47227 = seq__46582;
var G__47228 = chunk__46583;
var G__47229 = count__46584;
var G__47230 = (i__46585 + (1));
seq__46582 = G__47227;
chunk__46583 = G__47228;
count__46584 = G__47229;
i__46585 = G__47230;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46582);
if(temp__5720__auto__){
var seq__46582__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46582__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46582__$1);
var G__47233 = cljs.core.chunk_rest(seq__46582__$1);
var G__47234 = c__4556__auto__;
var G__47235 = cljs.core.count(c__4556__auto__);
var G__47236 = (0);
seq__46582 = G__47233;
chunk__46583 = G__47234;
count__46584 = G__47235;
i__46585 = G__47236;
continue;
} else {
var vec__46605 = cljs.core.first(seq__46582__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46605,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46605,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47241 = cljs.core.next(seq__46582__$1);
var G__47242 = null;
var G__47243 = (0);
var G__47244 = (0);
seq__46582 = G__47241;
chunk__46583 = G__47242;
count__46584 = G__47243;
i__46585 = G__47244;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46610_47246 = key;
var G__46610_47247__$1 = (((G__46610_47246 instanceof cljs.core.Keyword))?G__46610_47246.fqn:null);
switch (G__46610_47247__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47256 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_47256,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_47256,"aria-");
}
})())){
el.setAttribute(ks_47256,value);
} else {
(el[ks_47256] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46625){
var map__46626 = p__46625;
var map__46626__$1 = (((((!((map__46626 == null))))?(((((map__46626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46626.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46626):map__46626);
var props = map__46626__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46626__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46630 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46630,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46630,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46630,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__46633 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__46633,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46633;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46639 = arguments.length;
switch (G__46639) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46658){
var vec__46659 = p__46658;
var seq__46660 = cljs.core.seq(vec__46659);
var first__46661 = cljs.core.first(seq__46660);
var seq__46660__$1 = cljs.core.next(seq__46660);
var nn = first__46661;
var first__46661__$1 = cljs.core.first(seq__46660__$1);
var seq__46660__$2 = cljs.core.next(seq__46660__$1);
var np = first__46661__$1;
var nc = seq__46660__$2;
var node = vec__46659;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46664 = nn;
var G__46665 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46664,G__46665) : create_fn.call(null,G__46664,G__46665));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46667 = nn;
var G__46668 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46667,G__46668) : create_fn.call(null,G__46667,G__46668));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46671 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46671,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46671,(1),null);
var seq__46674_47287 = cljs.core.seq(node_children);
var chunk__46675_47288 = null;
var count__46676_47289 = (0);
var i__46677_47290 = (0);
while(true){
if((i__46677_47290 < count__46676_47289)){
var child_struct_47291 = chunk__46675_47288.cljs$core$IIndexed$_nth$arity$2(null,i__46677_47290);
var children_47292 = shadow.dom.dom_node(child_struct_47291);
if(cljs.core.seq_QMARK_(children_47292)){
var seq__46713_47293 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47292));
var chunk__46715_47294 = null;
var count__46716_47295 = (0);
var i__46717_47296 = (0);
while(true){
if((i__46717_47296 < count__46716_47295)){
var child_47299 = chunk__46715_47294.cljs$core$IIndexed$_nth$arity$2(null,i__46717_47296);
if(cljs.core.truth_(child_47299)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47299);


var G__47301 = seq__46713_47293;
var G__47302 = chunk__46715_47294;
var G__47303 = count__46716_47295;
var G__47304 = (i__46717_47296 + (1));
seq__46713_47293 = G__47301;
chunk__46715_47294 = G__47302;
count__46716_47295 = G__47303;
i__46717_47296 = G__47304;
continue;
} else {
var G__47306 = seq__46713_47293;
var G__47307 = chunk__46715_47294;
var G__47308 = count__46716_47295;
var G__47309 = (i__46717_47296 + (1));
seq__46713_47293 = G__47306;
chunk__46715_47294 = G__47307;
count__46716_47295 = G__47308;
i__46717_47296 = G__47309;
continue;
}
} else {
var temp__5720__auto___47311 = cljs.core.seq(seq__46713_47293);
if(temp__5720__auto___47311){
var seq__46713_47312__$1 = temp__5720__auto___47311;
if(cljs.core.chunked_seq_QMARK_(seq__46713_47312__$1)){
var c__4556__auto___47313 = cljs.core.chunk_first(seq__46713_47312__$1);
var G__47314 = cljs.core.chunk_rest(seq__46713_47312__$1);
var G__47315 = c__4556__auto___47313;
var G__47316 = cljs.core.count(c__4556__auto___47313);
var G__47317 = (0);
seq__46713_47293 = G__47314;
chunk__46715_47294 = G__47315;
count__46716_47295 = G__47316;
i__46717_47296 = G__47317;
continue;
} else {
var child_47321 = cljs.core.first(seq__46713_47312__$1);
if(cljs.core.truth_(child_47321)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47321);


var G__47322 = cljs.core.next(seq__46713_47312__$1);
var G__47323 = null;
var G__47324 = (0);
var G__47325 = (0);
seq__46713_47293 = G__47322;
chunk__46715_47294 = G__47323;
count__46716_47295 = G__47324;
i__46717_47296 = G__47325;
continue;
} else {
var G__47327 = cljs.core.next(seq__46713_47312__$1);
var G__47328 = null;
var G__47329 = (0);
var G__47330 = (0);
seq__46713_47293 = G__47327;
chunk__46715_47294 = G__47328;
count__46716_47295 = G__47329;
i__46717_47296 = G__47330;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47292);
}


var G__47332 = seq__46674_47287;
var G__47333 = chunk__46675_47288;
var G__47334 = count__46676_47289;
var G__47335 = (i__46677_47290 + (1));
seq__46674_47287 = G__47332;
chunk__46675_47288 = G__47333;
count__46676_47289 = G__47334;
i__46677_47290 = G__47335;
continue;
} else {
var temp__5720__auto___47336 = cljs.core.seq(seq__46674_47287);
if(temp__5720__auto___47336){
var seq__46674_47337__$1 = temp__5720__auto___47336;
if(cljs.core.chunked_seq_QMARK_(seq__46674_47337__$1)){
var c__4556__auto___47338 = cljs.core.chunk_first(seq__46674_47337__$1);
var G__47340 = cljs.core.chunk_rest(seq__46674_47337__$1);
var G__47341 = c__4556__auto___47338;
var G__47342 = cljs.core.count(c__4556__auto___47338);
var G__47343 = (0);
seq__46674_47287 = G__47340;
chunk__46675_47288 = G__47341;
count__46676_47289 = G__47342;
i__46677_47290 = G__47343;
continue;
} else {
var child_struct_47344 = cljs.core.first(seq__46674_47337__$1);
var children_47346 = shadow.dom.dom_node(child_struct_47344);
if(cljs.core.seq_QMARK_(children_47346)){
var seq__46725_47347 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47346));
var chunk__46727_47348 = null;
var count__46728_47349 = (0);
var i__46729_47350 = (0);
while(true){
if((i__46729_47350 < count__46728_47349)){
var child_47353 = chunk__46727_47348.cljs$core$IIndexed$_nth$arity$2(null,i__46729_47350);
if(cljs.core.truth_(child_47353)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47353);


var G__47355 = seq__46725_47347;
var G__47356 = chunk__46727_47348;
var G__47357 = count__46728_47349;
var G__47358 = (i__46729_47350 + (1));
seq__46725_47347 = G__47355;
chunk__46727_47348 = G__47356;
count__46728_47349 = G__47357;
i__46729_47350 = G__47358;
continue;
} else {
var G__47359 = seq__46725_47347;
var G__47360 = chunk__46727_47348;
var G__47361 = count__46728_47349;
var G__47362 = (i__46729_47350 + (1));
seq__46725_47347 = G__47359;
chunk__46727_47348 = G__47360;
count__46728_47349 = G__47361;
i__46729_47350 = G__47362;
continue;
}
} else {
var temp__5720__auto___47364__$1 = cljs.core.seq(seq__46725_47347);
if(temp__5720__auto___47364__$1){
var seq__46725_47365__$1 = temp__5720__auto___47364__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46725_47365__$1)){
var c__4556__auto___47367 = cljs.core.chunk_first(seq__46725_47365__$1);
var G__47369 = cljs.core.chunk_rest(seq__46725_47365__$1);
var G__47370 = c__4556__auto___47367;
var G__47371 = cljs.core.count(c__4556__auto___47367);
var G__47372 = (0);
seq__46725_47347 = G__47369;
chunk__46727_47348 = G__47370;
count__46728_47349 = G__47371;
i__46729_47350 = G__47372;
continue;
} else {
var child_47373 = cljs.core.first(seq__46725_47365__$1);
if(cljs.core.truth_(child_47373)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47373);


var G__47375 = cljs.core.next(seq__46725_47365__$1);
var G__47376 = null;
var G__47377 = (0);
var G__47378 = (0);
seq__46725_47347 = G__47375;
chunk__46727_47348 = G__47376;
count__46728_47349 = G__47377;
i__46729_47350 = G__47378;
continue;
} else {
var G__47379 = cljs.core.next(seq__46725_47365__$1);
var G__47380 = null;
var G__47381 = (0);
var G__47382 = (0);
seq__46725_47347 = G__47379;
chunk__46727_47348 = G__47380;
count__46728_47349 = G__47381;
i__46729_47350 = G__47382;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47346);
}


var G__47385 = cljs.core.next(seq__46674_47337__$1);
var G__47386 = null;
var G__47387 = (0);
var G__47388 = (0);
seq__46674_47287 = G__47385;
chunk__46675_47288 = G__47386;
count__46676_47289 = G__47387;
i__46677_47290 = G__47388;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46743 = cljs.core.seq(node);
var chunk__46744 = null;
var count__46745 = (0);
var i__46746 = (0);
while(true){
if((i__46746 < count__46745)){
var n = chunk__46744.cljs$core$IIndexed$_nth$arity$2(null,i__46746);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47405 = seq__46743;
var G__47406 = chunk__46744;
var G__47407 = count__46745;
var G__47408 = (i__46746 + (1));
seq__46743 = G__47405;
chunk__46744 = G__47406;
count__46745 = G__47407;
i__46746 = G__47408;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46743);
if(temp__5720__auto__){
var seq__46743__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46743__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46743__$1);
var G__47410 = cljs.core.chunk_rest(seq__46743__$1);
var G__47411 = c__4556__auto__;
var G__47412 = cljs.core.count(c__4556__auto__);
var G__47413 = (0);
seq__46743 = G__47410;
chunk__46744 = G__47411;
count__46745 = G__47412;
i__46746 = G__47413;
continue;
} else {
var n = cljs.core.first(seq__46743__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47415 = cljs.core.next(seq__46743__$1);
var G__47416 = null;
var G__47417 = (0);
var G__47418 = (0);
seq__46743 = G__47415;
chunk__46744 = G__47416;
count__46745 = G__47417;
i__46746 = G__47418;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46756 = arguments.length;
switch (G__46756) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46761 = arguments.length;
switch (G__46761) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46777 = arguments.length;
switch (G__46777) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47437 = arguments.length;
var i__4737__auto___47438 = (0);
while(true){
if((i__4737__auto___47438 < len__4736__auto___47437)){
args__4742__auto__.push((arguments[i__4737__auto___47438]));

var G__47439 = (i__4737__auto___47438 + (1));
i__4737__auto___47438 = G__47439;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46798_47442 = cljs.core.seq(nodes);
var chunk__46799_47443 = null;
var count__46800_47444 = (0);
var i__46801_47446 = (0);
while(true){
if((i__46801_47446 < count__46800_47444)){
var node_47454 = chunk__46799_47443.cljs$core$IIndexed$_nth$arity$2(null,i__46801_47446);
fragment.appendChild(shadow.dom._to_dom(node_47454));


var G__47458 = seq__46798_47442;
var G__47459 = chunk__46799_47443;
var G__47460 = count__46800_47444;
var G__47461 = (i__46801_47446 + (1));
seq__46798_47442 = G__47458;
chunk__46799_47443 = G__47459;
count__46800_47444 = G__47460;
i__46801_47446 = G__47461;
continue;
} else {
var temp__5720__auto___47462 = cljs.core.seq(seq__46798_47442);
if(temp__5720__auto___47462){
var seq__46798_47463__$1 = temp__5720__auto___47462;
if(cljs.core.chunked_seq_QMARK_(seq__46798_47463__$1)){
var c__4556__auto___47464 = cljs.core.chunk_first(seq__46798_47463__$1);
var G__47465 = cljs.core.chunk_rest(seq__46798_47463__$1);
var G__47466 = c__4556__auto___47464;
var G__47467 = cljs.core.count(c__4556__auto___47464);
var G__47468 = (0);
seq__46798_47442 = G__47465;
chunk__46799_47443 = G__47466;
count__46800_47444 = G__47467;
i__46801_47446 = G__47468;
continue;
} else {
var node_47469 = cljs.core.first(seq__46798_47463__$1);
fragment.appendChild(shadow.dom._to_dom(node_47469));


var G__47471 = cljs.core.next(seq__46798_47463__$1);
var G__47472 = null;
var G__47473 = (0);
var G__47474 = (0);
seq__46798_47442 = G__47471;
chunk__46799_47443 = G__47472;
count__46800_47444 = G__47473;
i__46801_47446 = G__47474;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46792){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46792));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46812_47479 = cljs.core.seq(scripts);
var chunk__46813_47480 = null;
var count__46814_47481 = (0);
var i__46815_47482 = (0);
while(true){
if((i__46815_47482 < count__46814_47481)){
var vec__46825_47487 = chunk__46813_47480.cljs$core$IIndexed$_nth$arity$2(null,i__46815_47482);
var script_tag_47488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46825_47487,(0),null);
var script_body_47489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46825_47487,(1),null);
eval(script_body_47489);


var G__47491 = seq__46812_47479;
var G__47492 = chunk__46813_47480;
var G__47493 = count__46814_47481;
var G__47494 = (i__46815_47482 + (1));
seq__46812_47479 = G__47491;
chunk__46813_47480 = G__47492;
count__46814_47481 = G__47493;
i__46815_47482 = G__47494;
continue;
} else {
var temp__5720__auto___47499 = cljs.core.seq(seq__46812_47479);
if(temp__5720__auto___47499){
var seq__46812_47500__$1 = temp__5720__auto___47499;
if(cljs.core.chunked_seq_QMARK_(seq__46812_47500__$1)){
var c__4556__auto___47501 = cljs.core.chunk_first(seq__46812_47500__$1);
var G__47502 = cljs.core.chunk_rest(seq__46812_47500__$1);
var G__47503 = c__4556__auto___47501;
var G__47504 = cljs.core.count(c__4556__auto___47501);
var G__47505 = (0);
seq__46812_47479 = G__47502;
chunk__46813_47480 = G__47503;
count__46814_47481 = G__47504;
i__46815_47482 = G__47505;
continue;
} else {
var vec__46829_47510 = cljs.core.first(seq__46812_47500__$1);
var script_tag_47511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46829_47510,(0),null);
var script_body_47512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46829_47510,(1),null);
eval(script_body_47512);


var G__47518 = cljs.core.next(seq__46812_47500__$1);
var G__47519 = null;
var G__47520 = (0);
var G__47521 = (0);
seq__46812_47479 = G__47518;
chunk__46813_47480 = G__47519;
count__46814_47481 = G__47520;
i__46815_47482 = G__47521;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46833){
var vec__46834 = p__46833;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46834,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46834,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46847 = arguments.length;
switch (G__46847) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46857 = cljs.core.seq(style_keys);
var chunk__46858 = null;
var count__46859 = (0);
var i__46860 = (0);
while(true){
if((i__46860 < count__46859)){
var it = chunk__46858.cljs$core$IIndexed$_nth$arity$2(null,i__46860);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47536 = seq__46857;
var G__47537 = chunk__46858;
var G__47538 = count__46859;
var G__47539 = (i__46860 + (1));
seq__46857 = G__47536;
chunk__46858 = G__47537;
count__46859 = G__47538;
i__46860 = G__47539;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46857);
if(temp__5720__auto__){
var seq__46857__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46857__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46857__$1);
var G__47541 = cljs.core.chunk_rest(seq__46857__$1);
var G__47542 = c__4556__auto__;
var G__47543 = cljs.core.count(c__4556__auto__);
var G__47544 = (0);
seq__46857 = G__47541;
chunk__46858 = G__47542;
count__46859 = G__47543;
i__46860 = G__47544;
continue;
} else {
var it = cljs.core.first(seq__46857__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47545 = cljs.core.next(seq__46857__$1);
var G__47546 = null;
var G__47547 = (0);
var G__47548 = (0);
seq__46857 = G__47545;
chunk__46858 = G__47546;
count__46859 = G__47547;
i__46860 = G__47548;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46863,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46869 = k46863;
var G__46869__$1 = (((G__46869 instanceof cljs.core.Keyword))?G__46869.fqn:null);
switch (G__46869__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46863,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46870){
var vec__46873 = p__46870;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46873,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46873,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46862){
var self__ = this;
var G__46862__$1 = this;
return (new cljs.core.RecordIter((0),G__46862__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46864,other46865){
var self__ = this;
var this46864__$1 = this;
return (((!((other46865 == null)))) && ((this46864__$1.constructor === other46865.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46864__$1.x,other46865.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46864__$1.y,other46865.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46864__$1.__extmap,other46865.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46862){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46889 = cljs.core.keyword_identical_QMARK_;
var expr__46890 = k__4388__auto__;
if(cljs.core.truth_((pred__46889.cljs$core$IFn$_invoke$arity$2 ? pred__46889.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46890) : pred__46889.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46890)))){
return (new shadow.dom.Coordinate(G__46862,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46889.cljs$core$IFn$_invoke$arity$2 ? pred__46889.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46890) : pred__46889.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46890)))){
return (new shadow.dom.Coordinate(self__.x,G__46862,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46862),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46862){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46862,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46867){
var extmap__4419__auto__ = (function (){var G__46901 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46867,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46867)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46901);
} else {
return G__46901;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46867),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46867),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46916,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46923 = k46916;
var G__46923__$1 = (((G__46923 instanceof cljs.core.Keyword))?G__46923.fqn:null);
switch (G__46923__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46916,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46925){
var vec__46926 = p__46925;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46926,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46926,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46915){
var self__ = this;
var G__46915__$1 = this;
return (new cljs.core.RecordIter((0),G__46915__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46917,other46918){
var self__ = this;
var this46917__$1 = this;
return (((!((other46918 == null)))) && ((this46917__$1.constructor === other46918.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46917__$1.w,other46918.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46917__$1.h,other46918.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46917__$1.__extmap,other46918.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46915){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46948 = cljs.core.keyword_identical_QMARK_;
var expr__46949 = k__4388__auto__;
if(cljs.core.truth_((pred__46948.cljs$core$IFn$_invoke$arity$2 ? pred__46948.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__46949) : pred__46948.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46949)))){
return (new shadow.dom.Size(G__46915,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46948.cljs$core$IFn$_invoke$arity$2 ? pred__46948.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__46949) : pred__46948.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46949)))){
return (new shadow.dom.Size(self__.w,G__46915,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46915),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46915){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46915,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46920){
var extmap__4419__auto__ = (function (){var G__46960 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46920,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__46920)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46960);
} else {
return G__46960;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46920),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46920),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47657 = (i + (1));
var G__47658 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__47657;
ret = G__47658;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__46991){
var vec__46992 = p__46991;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46992,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46992,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46998 = arguments.length;
switch (G__46998) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47664 = ps;
var G__47665 = (i + (1));
el__$1 = G__47664;
i = G__47665;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47024 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47024,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47024,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47024,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47027_47670 = cljs.core.seq(props);
var chunk__47028_47671 = null;
var count__47029_47672 = (0);
var i__47030_47673 = (0);
while(true){
if((i__47030_47673 < count__47029_47672)){
var vec__47043_47674 = chunk__47028_47671.cljs$core$IIndexed$_nth$arity$2(null,i__47030_47673);
var k_47675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47043_47674,(0),null);
var v_47676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47043_47674,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_47675);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47675),v_47676);


var G__47677 = seq__47027_47670;
var G__47678 = chunk__47028_47671;
var G__47679 = count__47029_47672;
var G__47680 = (i__47030_47673 + (1));
seq__47027_47670 = G__47677;
chunk__47028_47671 = G__47678;
count__47029_47672 = G__47679;
i__47030_47673 = G__47680;
continue;
} else {
var temp__5720__auto___47681 = cljs.core.seq(seq__47027_47670);
if(temp__5720__auto___47681){
var seq__47027_47682__$1 = temp__5720__auto___47681;
if(cljs.core.chunked_seq_QMARK_(seq__47027_47682__$1)){
var c__4556__auto___47683 = cljs.core.chunk_first(seq__47027_47682__$1);
var G__47684 = cljs.core.chunk_rest(seq__47027_47682__$1);
var G__47685 = c__4556__auto___47683;
var G__47686 = cljs.core.count(c__4556__auto___47683);
var G__47687 = (0);
seq__47027_47670 = G__47684;
chunk__47028_47671 = G__47685;
count__47029_47672 = G__47686;
i__47030_47673 = G__47687;
continue;
} else {
var vec__47050_47688 = cljs.core.first(seq__47027_47682__$1);
var k_47689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47050_47688,(0),null);
var v_47690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47050_47688,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_47689);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47689),v_47690);


var G__47691 = cljs.core.next(seq__47027_47682__$1);
var G__47692 = null;
var G__47693 = (0);
var G__47694 = (0);
seq__47027_47670 = G__47691;
chunk__47028_47671 = G__47692;
count__47029_47672 = G__47693;
i__47030_47673 = G__47694;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__47058 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47058,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47058,(1),null);
var seq__47061_47695 = cljs.core.seq(node_children);
var chunk__47063_47696 = null;
var count__47064_47697 = (0);
var i__47065_47698 = (0);
while(true){
if((i__47065_47698 < count__47064_47697)){
var child_struct_47699 = chunk__47063_47696.cljs$core$IIndexed$_nth$arity$2(null,i__47065_47698);
if((!((child_struct_47699 == null)))){
if(typeof child_struct_47699 === 'string'){
var text_47700 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47700),child_struct_47699].join(''));
} else {
var children_47701 = shadow.dom.svg_node(child_struct_47699);
if(cljs.core.seq_QMARK_(children_47701)){
var seq__47093_47702 = cljs.core.seq(children_47701);
var chunk__47095_47703 = null;
var count__47096_47704 = (0);
var i__47097_47705 = (0);
while(true){
if((i__47097_47705 < count__47096_47704)){
var child_47706 = chunk__47095_47703.cljs$core$IIndexed$_nth$arity$2(null,i__47097_47705);
if(cljs.core.truth_(child_47706)){
node.appendChild(child_47706);


var G__47707 = seq__47093_47702;
var G__47708 = chunk__47095_47703;
var G__47709 = count__47096_47704;
var G__47710 = (i__47097_47705 + (1));
seq__47093_47702 = G__47707;
chunk__47095_47703 = G__47708;
count__47096_47704 = G__47709;
i__47097_47705 = G__47710;
continue;
} else {
var G__47711 = seq__47093_47702;
var G__47712 = chunk__47095_47703;
var G__47713 = count__47096_47704;
var G__47714 = (i__47097_47705 + (1));
seq__47093_47702 = G__47711;
chunk__47095_47703 = G__47712;
count__47096_47704 = G__47713;
i__47097_47705 = G__47714;
continue;
}
} else {
var temp__5720__auto___47717 = cljs.core.seq(seq__47093_47702);
if(temp__5720__auto___47717){
var seq__47093_47718__$1 = temp__5720__auto___47717;
if(cljs.core.chunked_seq_QMARK_(seq__47093_47718__$1)){
var c__4556__auto___47719 = cljs.core.chunk_first(seq__47093_47718__$1);
var G__47720 = cljs.core.chunk_rest(seq__47093_47718__$1);
var G__47721 = c__4556__auto___47719;
var G__47722 = cljs.core.count(c__4556__auto___47719);
var G__47723 = (0);
seq__47093_47702 = G__47720;
chunk__47095_47703 = G__47721;
count__47096_47704 = G__47722;
i__47097_47705 = G__47723;
continue;
} else {
var child_47724 = cljs.core.first(seq__47093_47718__$1);
if(cljs.core.truth_(child_47724)){
node.appendChild(child_47724);


var G__47725 = cljs.core.next(seq__47093_47718__$1);
var G__47726 = null;
var G__47727 = (0);
var G__47728 = (0);
seq__47093_47702 = G__47725;
chunk__47095_47703 = G__47726;
count__47096_47704 = G__47727;
i__47097_47705 = G__47728;
continue;
} else {
var G__47730 = cljs.core.next(seq__47093_47718__$1);
var G__47731 = null;
var G__47732 = (0);
var G__47733 = (0);
seq__47093_47702 = G__47730;
chunk__47095_47703 = G__47731;
count__47096_47704 = G__47732;
i__47097_47705 = G__47733;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47701);
}
}


var G__47734 = seq__47061_47695;
var G__47735 = chunk__47063_47696;
var G__47736 = count__47064_47697;
var G__47737 = (i__47065_47698 + (1));
seq__47061_47695 = G__47734;
chunk__47063_47696 = G__47735;
count__47064_47697 = G__47736;
i__47065_47698 = G__47737;
continue;
} else {
var G__47738 = seq__47061_47695;
var G__47739 = chunk__47063_47696;
var G__47740 = count__47064_47697;
var G__47741 = (i__47065_47698 + (1));
seq__47061_47695 = G__47738;
chunk__47063_47696 = G__47739;
count__47064_47697 = G__47740;
i__47065_47698 = G__47741;
continue;
}
} else {
var temp__5720__auto___47742 = cljs.core.seq(seq__47061_47695);
if(temp__5720__auto___47742){
var seq__47061_47743__$1 = temp__5720__auto___47742;
if(cljs.core.chunked_seq_QMARK_(seq__47061_47743__$1)){
var c__4556__auto___47744 = cljs.core.chunk_first(seq__47061_47743__$1);
var G__47746 = cljs.core.chunk_rest(seq__47061_47743__$1);
var G__47747 = c__4556__auto___47744;
var G__47748 = cljs.core.count(c__4556__auto___47744);
var G__47749 = (0);
seq__47061_47695 = G__47746;
chunk__47063_47696 = G__47747;
count__47064_47697 = G__47748;
i__47065_47698 = G__47749;
continue;
} else {
var child_struct_47755 = cljs.core.first(seq__47061_47743__$1);
if((!((child_struct_47755 == null)))){
if(typeof child_struct_47755 === 'string'){
var text_47757 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47757),child_struct_47755].join(''));
} else {
var children_47759 = shadow.dom.svg_node(child_struct_47755);
if(cljs.core.seq_QMARK_(children_47759)){
var seq__47111_47760 = cljs.core.seq(children_47759);
var chunk__47113_47761 = null;
var count__47114_47762 = (0);
var i__47115_47763 = (0);
while(true){
if((i__47115_47763 < count__47114_47762)){
var child_47764 = chunk__47113_47761.cljs$core$IIndexed$_nth$arity$2(null,i__47115_47763);
if(cljs.core.truth_(child_47764)){
node.appendChild(child_47764);


var G__47766 = seq__47111_47760;
var G__47767 = chunk__47113_47761;
var G__47768 = count__47114_47762;
var G__47769 = (i__47115_47763 + (1));
seq__47111_47760 = G__47766;
chunk__47113_47761 = G__47767;
count__47114_47762 = G__47768;
i__47115_47763 = G__47769;
continue;
} else {
var G__47771 = seq__47111_47760;
var G__47772 = chunk__47113_47761;
var G__47773 = count__47114_47762;
var G__47774 = (i__47115_47763 + (1));
seq__47111_47760 = G__47771;
chunk__47113_47761 = G__47772;
count__47114_47762 = G__47773;
i__47115_47763 = G__47774;
continue;
}
} else {
var temp__5720__auto___47775__$1 = cljs.core.seq(seq__47111_47760);
if(temp__5720__auto___47775__$1){
var seq__47111_47776__$1 = temp__5720__auto___47775__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47111_47776__$1)){
var c__4556__auto___47778 = cljs.core.chunk_first(seq__47111_47776__$1);
var G__47779 = cljs.core.chunk_rest(seq__47111_47776__$1);
var G__47780 = c__4556__auto___47778;
var G__47781 = cljs.core.count(c__4556__auto___47778);
var G__47782 = (0);
seq__47111_47760 = G__47779;
chunk__47113_47761 = G__47780;
count__47114_47762 = G__47781;
i__47115_47763 = G__47782;
continue;
} else {
var child_47784 = cljs.core.first(seq__47111_47776__$1);
if(cljs.core.truth_(child_47784)){
node.appendChild(child_47784);


var G__47785 = cljs.core.next(seq__47111_47776__$1);
var G__47786 = null;
var G__47787 = (0);
var G__47788 = (0);
seq__47111_47760 = G__47785;
chunk__47113_47761 = G__47786;
count__47114_47762 = G__47787;
i__47115_47763 = G__47788;
continue;
} else {
var G__47789 = cljs.core.next(seq__47111_47776__$1);
var G__47790 = null;
var G__47791 = (0);
var G__47792 = (0);
seq__47111_47760 = G__47789;
chunk__47113_47761 = G__47790;
count__47114_47762 = G__47791;
i__47115_47763 = G__47792;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47759);
}
}


var G__47795 = cljs.core.next(seq__47061_47743__$1);
var G__47796 = null;
var G__47797 = (0);
var G__47798 = (0);
seq__47061_47695 = G__47795;
chunk__47063_47696 = G__47796;
count__47064_47697 = G__47797;
i__47065_47698 = G__47798;
continue;
} else {
var G__47799 = cljs.core.next(seq__47061_47743__$1);
var G__47800 = null;
var G__47801 = (0);
var G__47802 = (0);
seq__47061_47695 = G__47799;
chunk__47063_47696 = G__47800;
count__47064_47697 = G__47801;
i__47065_47698 = G__47802;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47807 = arguments.length;
var i__4737__auto___47808 = (0);
while(true){
if((i__4737__auto___47808 < len__4736__auto___47807)){
args__4742__auto__.push((arguments[i__4737__auto___47808]));

var G__47810 = (i__4737__auto___47808 + (1));
i__4737__auto___47808 = G__47810;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47127){
var G__47128 = cljs.core.first(seq47127);
var seq47127__$1 = cljs.core.next(seq47127);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47128,seq47127__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47137 = arguments.length;
switch (G__47137) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__43595__auto___47829 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43596__auto__ = (function (){var switch__43402__auto__ = (function (state_47148){
var state_val_47149 = (state_47148[(1)]);
if((state_val_47149 === (1))){
var state_47148__$1 = state_47148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47148__$1,(2),once_or_cleanup);
} else {
if((state_val_47149 === (2))){
var inst_47145 = (state_47148[(2)]);
var inst_47146 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_47148__$1 = (function (){var statearr_47152 = state_47148;
(statearr_47152[(7)] = inst_47145);

return statearr_47152;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47148__$1,inst_47146);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43403__auto__ = null;
var shadow$dom$state_machine__43403__auto____0 = (function (){
var statearr_47156 = [null,null,null,null,null,null,null,null];
(statearr_47156[(0)] = shadow$dom$state_machine__43403__auto__);

(statearr_47156[(1)] = (1));

return statearr_47156;
});
var shadow$dom$state_machine__43403__auto____1 = (function (state_47148){
while(true){
var ret_value__43404__auto__ = (function (){try{while(true){
var result__43405__auto__ = switch__43402__auto__(state_47148);
if(cljs.core.keyword_identical_QMARK_(result__43405__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43405__auto__;
}
break;
}
}catch (e47159){var ex__43406__auto__ = e47159;
var statearr_47161_47836 = state_47148;
(statearr_47161_47836[(2)] = ex__43406__auto__);


if(cljs.core.seq((state_47148[(4)]))){
var statearr_47162_47838 = state_47148;
(statearr_47162_47838[(1)] = cljs.core.first((state_47148[(4)])));

} else {
throw ex__43406__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43404__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47841 = state_47148;
state_47148 = G__47841;
continue;
} else {
return ret_value__43404__auto__;
}
break;
}
});
shadow$dom$state_machine__43403__auto__ = function(state_47148){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43403__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43403__auto____1.call(this,state_47148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43403__auto____0;
shadow$dom$state_machine__43403__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43403__auto____1;
return shadow$dom$state_machine__43403__auto__;
})()
})();
var state__43597__auto__ = (function (){var statearr_47165 = f__43596__auto__();
(statearr_47165[(6)] = c__43595__auto___47829);

return statearr_47165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43597__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
