goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5720__auto__ = (function (){var fexpr__21821 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__21821.cljs$core$IFn$_invoke$arity$1 ? fexpr__21821.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__21821.call(null,channel));
})();
if(cljs.core.truth_(temp__5720__auto__)){
var req = temp__5720__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__21840){
var vec__21841 = p__21840;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21841,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21841,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__21847 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__21847)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__21847)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__21847)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__21847)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__21847)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__21847)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21847)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__21857){
var map__21858 = p__21857;
var map__21858__$1 = (((((!((map__21858 == null))))?(((((map__21858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21858.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21858):map__21858);
var request = map__21858__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21858__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21858__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21858__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__21864 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__21864,default_headers);

cljs_http.core.apply_response_type_BANG_(G__21864,response_type);

G__21864.setTimeoutInterval(timeout);

G__21864.setWithCredentials(send_credentials);

return G__21864;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__21876){
var map__21878 = p__21876;
var map__21878__$1 = (((((!((map__21878 == null))))?(((((map__21878.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21878.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21878):map__21878);
var request = map__21878__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21878__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21878__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21878__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21878__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21878__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21878__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__21884 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__21884) : cljs_http.core.error_kw.call(null,G__21884));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_22006 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__21891_22009 = xhr;
G__21891_22009.setProgressEventsEnabled(true);

G__21891_22009.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_22006,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__21891_22009.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_22006,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__20271__auto___22012 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21902){
var state_val_21903 = (state_21902[(1)]);
if((state_val_21903 === (1))){
var state_21902__$1 = state_21902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21902__$1,(2),cancel);
} else {
if((state_val_21903 === (2))){
var inst_21893 = (state_21902[(2)]);
var inst_21894 = xhr.isComplete();
var inst_21895 = cljs.core.not(inst_21894);
var state_21902__$1 = (function (){var statearr_21905 = state_21902;
(statearr_21905[(7)] = inst_21893);

return statearr_21905;
})();
if(inst_21895){
var statearr_21906_22015 = state_21902__$1;
(statearr_21906_22015[(1)] = (3));

} else {
var statearr_21907_22018 = state_21902__$1;
(statearr_21907_22018[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (3))){
var inst_21897 = xhr.abort();
var state_21902__$1 = state_21902;
var statearr_21909_22020 = state_21902__$1;
(statearr_21909_22020[(2)] = inst_21897);

(statearr_21909_22020[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (4))){
var state_21902__$1 = state_21902;
var statearr_21910_22022 = state_21902__$1;
(statearr_21910_22022[(2)] = null);

(statearr_21910_22022[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (5))){
var inst_21900 = (state_21902[(2)]);
var state_21902__$1 = state_21902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21902__$1,inst_21900);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__20124__auto__ = null;
var cljs_http$core$xhr_$_state_machine__20124__auto____0 = (function (){
var statearr_21917 = [null,null,null,null,null,null,null,null];
(statearr_21917[(0)] = cljs_http$core$xhr_$_state_machine__20124__auto__);

(statearr_21917[(1)] = (1));

return statearr_21917;
});
var cljs_http$core$xhr_$_state_machine__20124__auto____1 = (function (state_21902){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21902);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21918){var ex__20127__auto__ = e21918;
var statearr_21919_22032 = state_21902;
(statearr_21919_22032[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21902[(4)]))){
var statearr_21922_22035 = state_21902;
(statearr_21922_22035[(1)] = cljs.core.first((state_21902[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22039 = state_21902;
state_21902 = G__22039;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__20124__auto__ = function(state_21902){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__20124__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__20124__auto____1.call(this,state_21902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__20124__auto____0;
cljs_http$core$xhr_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__20124__auto____1;
return cljs_http$core$xhr_$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21926 = f__20272__auto__();
(statearr_21926[(6)] = c__20271__auto___22012);

return statearr_21926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__21932){
var map__21934 = p__21932;
var map__21934__$1 = (((((!((map__21934 == null))))?(((((map__21934.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21934.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21934):map__21934);
var request = map__21934__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21934__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21934__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21934__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__21934__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_22046 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_22046], null));

if(cljs.core.truth_(cancel)){
var c__20271__auto___22073 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21955){
var state_val_21956 = (state_21955[(1)]);
if((state_val_21956 === (1))){
var state_21955__$1 = state_21955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21955__$1,(2),cancel);
} else {
if((state_val_21956 === (2))){
var inst_21952 = (state_21955[(2)]);
var inst_21953 = jsonp.cancel(req_22046);
var state_21955__$1 = (function (){var statearr_21960 = state_21955;
(statearr_21960[(7)] = inst_21952);

return statearr_21960;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_21955__$1,inst_21953);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__20124__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__20124__auto____0 = (function (){
var statearr_21961 = [null,null,null,null,null,null,null,null];
(statearr_21961[(0)] = cljs_http$core$jsonp_$_state_machine__20124__auto__);

(statearr_21961[(1)] = (1));

return statearr_21961;
});
var cljs_http$core$jsonp_$_state_machine__20124__auto____1 = (function (state_21955){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21955);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21962){var ex__20127__auto__ = e21962;
var statearr_21964_22125 = state_21955;
(statearr_21964_22125[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21955[(4)]))){
var statearr_21965_22127 = state_21955;
(statearr_21965_22127[(1)] = cljs.core.first((state_21955[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22130 = state_21955;
state_21955 = G__22130;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__20124__auto__ = function(state_21955){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__20124__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__20124__auto____1.call(this,state_21955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__20124__auto____0;
cljs_http$core$jsonp_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__20124__auto____1;
return cljs_http$core$jsonp_$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21972 = f__20272__auto__();
(statearr_21972[(6)] = c__20271__auto___22073);

return statearr_21972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__21974){
var map__21975 = p__21974;
var map__21975__$1 = (((((!((map__21975 == null))))?(((((map__21975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21975):map__21975);
var request = map__21975__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21975__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
