goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_41063 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_41063(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_41064 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_41064(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__40570 = coll;
var G__40571 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__40570,G__40571) : shadow.dom.lazy_native_coll_seq.call(null,G__40570,G__40571));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__40599 = arguments.length;
switch (G__40599) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__40622 = arguments.length;
switch (G__40622) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__40636 = arguments.length;
switch (G__40636) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__40649 = arguments.length;
switch (G__40649) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__40665 = arguments.length;
switch (G__40665) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__40667 = arguments.length;
switch (G__40667) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e40668){if((e40668 instanceof Object)){
var e = e40668;
return console.log("didnt support attachEvent",el,e);
} else {
throw e40668;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__40672 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__40673 = null;
var count__40674 = (0);
var i__40675 = (0);
while(true){
if((i__40675 < count__40674)){
var el = chunk__40673.cljs$core$IIndexed$_nth$arity$2(null,i__40675);
var handler_41077__$1 = ((function (seq__40672,chunk__40673,count__40674,i__40675,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__40672,chunk__40673,count__40674,i__40675,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_41077__$1);


var G__41078 = seq__40672;
var G__41079 = chunk__40673;
var G__41080 = count__40674;
var G__41081 = (i__40675 + (1));
seq__40672 = G__41078;
chunk__40673 = G__41079;
count__40674 = G__41080;
i__40675 = G__41081;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40672);
if(temp__5720__auto__){
var seq__40672__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40672__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40672__$1);
var G__41082 = cljs.core.chunk_rest(seq__40672__$1);
var G__41083 = c__4556__auto__;
var G__41084 = cljs.core.count(c__4556__auto__);
var G__41085 = (0);
seq__40672 = G__41082;
chunk__40673 = G__41083;
count__40674 = G__41084;
i__40675 = G__41085;
continue;
} else {
var el = cljs.core.first(seq__40672__$1);
var handler_41086__$1 = ((function (seq__40672,chunk__40673,count__40674,i__40675,el,seq__40672__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__40672,chunk__40673,count__40674,i__40675,el,seq__40672__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_41086__$1);


var G__41087 = cljs.core.next(seq__40672__$1);
var G__41088 = null;
var G__41089 = (0);
var G__41090 = (0);
seq__40672 = G__41087;
chunk__40673 = G__41088;
count__40674 = G__41089;
i__40675 = G__41090;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__40700 = arguments.length;
switch (G__40700) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__40719 = cljs.core.seq(events);
var chunk__40720 = null;
var count__40721 = (0);
var i__40722 = (0);
while(true){
if((i__40722 < count__40721)){
var vec__40738 = chunk__40720.cljs$core$IIndexed$_nth$arity$2(null,i__40722);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40738,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40738,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__41094 = seq__40719;
var G__41095 = chunk__40720;
var G__41096 = count__40721;
var G__41097 = (i__40722 + (1));
seq__40719 = G__41094;
chunk__40720 = G__41095;
count__40721 = G__41096;
i__40722 = G__41097;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40719);
if(temp__5720__auto__){
var seq__40719__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40719__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40719__$1);
var G__41099 = cljs.core.chunk_rest(seq__40719__$1);
var G__41100 = c__4556__auto__;
var G__41101 = cljs.core.count(c__4556__auto__);
var G__41102 = (0);
seq__40719 = G__41099;
chunk__40720 = G__41100;
count__40721 = G__41101;
i__40722 = G__41102;
continue;
} else {
var vec__40743 = cljs.core.first(seq__40719__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40743,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40743,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__41103 = cljs.core.next(seq__40719__$1);
var G__41104 = null;
var G__41105 = (0);
var G__41106 = (0);
seq__40719 = G__41103;
chunk__40720 = G__41104;
count__40721 = G__41105;
i__40722 = G__41106;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__40746 = cljs.core.seq(styles);
var chunk__40747 = null;
var count__40748 = (0);
var i__40749 = (0);
while(true){
if((i__40749 < count__40748)){
var vec__40756 = chunk__40747.cljs$core$IIndexed$_nth$arity$2(null,i__40749);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40756,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40756,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__41107 = seq__40746;
var G__41108 = chunk__40747;
var G__41109 = count__40748;
var G__41110 = (i__40749 + (1));
seq__40746 = G__41107;
chunk__40747 = G__41108;
count__40748 = G__41109;
i__40749 = G__41110;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40746);
if(temp__5720__auto__){
var seq__40746__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40746__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40746__$1);
var G__41112 = cljs.core.chunk_rest(seq__40746__$1);
var G__41113 = c__4556__auto__;
var G__41114 = cljs.core.count(c__4556__auto__);
var G__41115 = (0);
seq__40746 = G__41112;
chunk__40747 = G__41113;
count__40748 = G__41114;
i__40749 = G__41115;
continue;
} else {
var vec__40759 = cljs.core.first(seq__40746__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40759,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40759,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__41116 = cljs.core.next(seq__40746__$1);
var G__41117 = null;
var G__41118 = (0);
var G__41119 = (0);
seq__40746 = G__41116;
chunk__40747 = G__41117;
count__40748 = G__41118;
i__40749 = G__41119;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__40762_41123 = key;
var G__40762_41124__$1 = (((G__40762_41123 instanceof cljs.core.Keyword))?G__40762_41123.fqn:null);
switch (G__40762_41124__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_41129 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_41129,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_41129,"aria-");
}
})())){
el.setAttribute(ks_41129,value);
} else {
(el[ks_41129] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__40763){
var map__40764 = p__40763;
var map__40764__$1 = (((((!((map__40764 == null))))?(((((map__40764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40764.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40764):map__40764);
var props = map__40764__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40764__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__40766 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40766,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40766,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40766,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__40772 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__40772,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__40772;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__40777 = arguments.length;
switch (G__40777) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__40785){
var vec__40788 = p__40785;
var seq__40789 = cljs.core.seq(vec__40788);
var first__40790 = cljs.core.first(seq__40789);
var seq__40789__$1 = cljs.core.next(seq__40789);
var nn = first__40790;
var first__40790__$1 = cljs.core.first(seq__40789__$1);
var seq__40789__$2 = cljs.core.next(seq__40789__$1);
var np = first__40790__$1;
var nc = seq__40789__$2;
var node = vec__40788;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__40791 = nn;
var G__40792 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__40791,G__40792) : create_fn.call(null,G__40791,G__40792));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__40793 = nn;
var G__40794 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__40793,G__40794) : create_fn.call(null,G__40793,G__40794));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__40795 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40795,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40795,(1),null);
var seq__40798_41142 = cljs.core.seq(node_children);
var chunk__40799_41143 = null;
var count__40800_41144 = (0);
var i__40801_41145 = (0);
while(true){
if((i__40801_41145 < count__40800_41144)){
var child_struct_41146 = chunk__40799_41143.cljs$core$IIndexed$_nth$arity$2(null,i__40801_41145);
var children_41147 = shadow.dom.dom_node(child_struct_41146);
if(cljs.core.seq_QMARK_(children_41147)){
var seq__40814_41148 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_41147));
var chunk__40816_41149 = null;
var count__40817_41150 = (0);
var i__40818_41151 = (0);
while(true){
if((i__40818_41151 < count__40817_41150)){
var child_41152 = chunk__40816_41149.cljs$core$IIndexed$_nth$arity$2(null,i__40818_41151);
if(cljs.core.truth_(child_41152)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41152);


var G__41153 = seq__40814_41148;
var G__41154 = chunk__40816_41149;
var G__41155 = count__40817_41150;
var G__41156 = (i__40818_41151 + (1));
seq__40814_41148 = G__41153;
chunk__40816_41149 = G__41154;
count__40817_41150 = G__41155;
i__40818_41151 = G__41156;
continue;
} else {
var G__41160 = seq__40814_41148;
var G__41161 = chunk__40816_41149;
var G__41162 = count__40817_41150;
var G__41163 = (i__40818_41151 + (1));
seq__40814_41148 = G__41160;
chunk__40816_41149 = G__41161;
count__40817_41150 = G__41162;
i__40818_41151 = G__41163;
continue;
}
} else {
var temp__5720__auto___41164 = cljs.core.seq(seq__40814_41148);
if(temp__5720__auto___41164){
var seq__40814_41165__$1 = temp__5720__auto___41164;
if(cljs.core.chunked_seq_QMARK_(seq__40814_41165__$1)){
var c__4556__auto___41166 = cljs.core.chunk_first(seq__40814_41165__$1);
var G__41167 = cljs.core.chunk_rest(seq__40814_41165__$1);
var G__41168 = c__4556__auto___41166;
var G__41169 = cljs.core.count(c__4556__auto___41166);
var G__41170 = (0);
seq__40814_41148 = G__41167;
chunk__40816_41149 = G__41168;
count__40817_41150 = G__41169;
i__40818_41151 = G__41170;
continue;
} else {
var child_41171 = cljs.core.first(seq__40814_41165__$1);
if(cljs.core.truth_(child_41171)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41171);


var G__41172 = cljs.core.next(seq__40814_41165__$1);
var G__41173 = null;
var G__41174 = (0);
var G__41175 = (0);
seq__40814_41148 = G__41172;
chunk__40816_41149 = G__41173;
count__40817_41150 = G__41174;
i__40818_41151 = G__41175;
continue;
} else {
var G__41176 = cljs.core.next(seq__40814_41165__$1);
var G__41177 = null;
var G__41178 = (0);
var G__41179 = (0);
seq__40814_41148 = G__41176;
chunk__40816_41149 = G__41177;
count__40817_41150 = G__41178;
i__40818_41151 = G__41179;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_41147);
}


var G__41180 = seq__40798_41142;
var G__41181 = chunk__40799_41143;
var G__41182 = count__40800_41144;
var G__41183 = (i__40801_41145 + (1));
seq__40798_41142 = G__41180;
chunk__40799_41143 = G__41181;
count__40800_41144 = G__41182;
i__40801_41145 = G__41183;
continue;
} else {
var temp__5720__auto___41187 = cljs.core.seq(seq__40798_41142);
if(temp__5720__auto___41187){
var seq__40798_41188__$1 = temp__5720__auto___41187;
if(cljs.core.chunked_seq_QMARK_(seq__40798_41188__$1)){
var c__4556__auto___41189 = cljs.core.chunk_first(seq__40798_41188__$1);
var G__41190 = cljs.core.chunk_rest(seq__40798_41188__$1);
var G__41191 = c__4556__auto___41189;
var G__41192 = cljs.core.count(c__4556__auto___41189);
var G__41193 = (0);
seq__40798_41142 = G__41190;
chunk__40799_41143 = G__41191;
count__40800_41144 = G__41192;
i__40801_41145 = G__41193;
continue;
} else {
var child_struct_41194 = cljs.core.first(seq__40798_41188__$1);
var children_41195 = shadow.dom.dom_node(child_struct_41194);
if(cljs.core.seq_QMARK_(children_41195)){
var seq__40826_41196 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_41195));
var chunk__40828_41197 = null;
var count__40829_41198 = (0);
var i__40830_41199 = (0);
while(true){
if((i__40830_41199 < count__40829_41198)){
var child_41200 = chunk__40828_41197.cljs$core$IIndexed$_nth$arity$2(null,i__40830_41199);
if(cljs.core.truth_(child_41200)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41200);


var G__41201 = seq__40826_41196;
var G__41202 = chunk__40828_41197;
var G__41203 = count__40829_41198;
var G__41204 = (i__40830_41199 + (1));
seq__40826_41196 = G__41201;
chunk__40828_41197 = G__41202;
count__40829_41198 = G__41203;
i__40830_41199 = G__41204;
continue;
} else {
var G__41205 = seq__40826_41196;
var G__41206 = chunk__40828_41197;
var G__41207 = count__40829_41198;
var G__41208 = (i__40830_41199 + (1));
seq__40826_41196 = G__41205;
chunk__40828_41197 = G__41206;
count__40829_41198 = G__41207;
i__40830_41199 = G__41208;
continue;
}
} else {
var temp__5720__auto___41209__$1 = cljs.core.seq(seq__40826_41196);
if(temp__5720__auto___41209__$1){
var seq__40826_41210__$1 = temp__5720__auto___41209__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40826_41210__$1)){
var c__4556__auto___41211 = cljs.core.chunk_first(seq__40826_41210__$1);
var G__41212 = cljs.core.chunk_rest(seq__40826_41210__$1);
var G__41213 = c__4556__auto___41211;
var G__41214 = cljs.core.count(c__4556__auto___41211);
var G__41215 = (0);
seq__40826_41196 = G__41212;
chunk__40828_41197 = G__41213;
count__40829_41198 = G__41214;
i__40830_41199 = G__41215;
continue;
} else {
var child_41216 = cljs.core.first(seq__40826_41210__$1);
if(cljs.core.truth_(child_41216)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_41216);


var G__41220 = cljs.core.next(seq__40826_41210__$1);
var G__41221 = null;
var G__41222 = (0);
var G__41223 = (0);
seq__40826_41196 = G__41220;
chunk__40828_41197 = G__41221;
count__40829_41198 = G__41222;
i__40830_41199 = G__41223;
continue;
} else {
var G__41224 = cljs.core.next(seq__40826_41210__$1);
var G__41225 = null;
var G__41226 = (0);
var G__41227 = (0);
seq__40826_41196 = G__41224;
chunk__40828_41197 = G__41225;
count__40829_41198 = G__41226;
i__40830_41199 = G__41227;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_41195);
}


var G__41228 = cljs.core.next(seq__40798_41188__$1);
var G__41229 = null;
var G__41230 = (0);
var G__41231 = (0);
seq__40798_41142 = G__41228;
chunk__40799_41143 = G__41229;
count__40800_41144 = G__41230;
i__40801_41145 = G__41231;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__40849 = cljs.core.seq(node);
var chunk__40850 = null;
var count__40851 = (0);
var i__40852 = (0);
while(true){
if((i__40852 < count__40851)){
var n = chunk__40850.cljs$core$IIndexed$_nth$arity$2(null,i__40852);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__41232 = seq__40849;
var G__41233 = chunk__40850;
var G__41234 = count__40851;
var G__41235 = (i__40852 + (1));
seq__40849 = G__41232;
chunk__40850 = G__41233;
count__40851 = G__41234;
i__40852 = G__41235;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40849);
if(temp__5720__auto__){
var seq__40849__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40849__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40849__$1);
var G__41236 = cljs.core.chunk_rest(seq__40849__$1);
var G__41237 = c__4556__auto__;
var G__41238 = cljs.core.count(c__4556__auto__);
var G__41239 = (0);
seq__40849 = G__41236;
chunk__40850 = G__41237;
count__40851 = G__41238;
i__40852 = G__41239;
continue;
} else {
var n = cljs.core.first(seq__40849__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__41240 = cljs.core.next(seq__40849__$1);
var G__41241 = null;
var G__41242 = (0);
var G__41243 = (0);
seq__40849 = G__41240;
chunk__40850 = G__41241;
count__40851 = G__41242;
i__40852 = G__41243;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__40861 = arguments.length;
switch (G__40861) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__40873 = arguments.length;
switch (G__40873) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__40891 = arguments.length;
switch (G__40891) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41261 = arguments.length;
var i__4737__auto___41262 = (0);
while(true){
if((i__4737__auto___41262 < len__4736__auto___41261)){
args__4742__auto__.push((arguments[i__4737__auto___41262]));

var G__41263 = (i__4737__auto___41262 + (1));
i__4737__auto___41262 = G__41263;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__40907_41264 = cljs.core.seq(nodes);
var chunk__40908_41265 = null;
var count__40909_41266 = (0);
var i__40910_41267 = (0);
while(true){
if((i__40910_41267 < count__40909_41266)){
var node_41271 = chunk__40908_41265.cljs$core$IIndexed$_nth$arity$2(null,i__40910_41267);
fragment.appendChild(shadow.dom._to_dom(node_41271));


var G__41272 = seq__40907_41264;
var G__41273 = chunk__40908_41265;
var G__41274 = count__40909_41266;
var G__41275 = (i__40910_41267 + (1));
seq__40907_41264 = G__41272;
chunk__40908_41265 = G__41273;
count__40909_41266 = G__41274;
i__40910_41267 = G__41275;
continue;
} else {
var temp__5720__auto___41276 = cljs.core.seq(seq__40907_41264);
if(temp__5720__auto___41276){
var seq__40907_41277__$1 = temp__5720__auto___41276;
if(cljs.core.chunked_seq_QMARK_(seq__40907_41277__$1)){
var c__4556__auto___41278 = cljs.core.chunk_first(seq__40907_41277__$1);
var G__41279 = cljs.core.chunk_rest(seq__40907_41277__$1);
var G__41280 = c__4556__auto___41278;
var G__41281 = cljs.core.count(c__4556__auto___41278);
var G__41282 = (0);
seq__40907_41264 = G__41279;
chunk__40908_41265 = G__41280;
count__40909_41266 = G__41281;
i__40910_41267 = G__41282;
continue;
} else {
var node_41283 = cljs.core.first(seq__40907_41277__$1);
fragment.appendChild(shadow.dom._to_dom(node_41283));


var G__41284 = cljs.core.next(seq__40907_41277__$1);
var G__41285 = null;
var G__41286 = (0);
var G__41287 = (0);
seq__40907_41264 = G__41284;
chunk__40908_41265 = G__41285;
count__40909_41266 = G__41286;
i__40910_41267 = G__41287;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq40903){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40903));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__40911_41291 = cljs.core.seq(scripts);
var chunk__40912_41292 = null;
var count__40913_41293 = (0);
var i__40914_41294 = (0);
while(true){
if((i__40914_41294 < count__40913_41293)){
var vec__40921_41295 = chunk__40912_41292.cljs$core$IIndexed$_nth$arity$2(null,i__40914_41294);
var script_tag_41296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40921_41295,(0),null);
var script_body_41297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40921_41295,(1),null);
eval(script_body_41297);


var G__41298 = seq__40911_41291;
var G__41299 = chunk__40912_41292;
var G__41300 = count__40913_41293;
var G__41301 = (i__40914_41294 + (1));
seq__40911_41291 = G__41298;
chunk__40912_41292 = G__41299;
count__40913_41293 = G__41300;
i__40914_41294 = G__41301;
continue;
} else {
var temp__5720__auto___41302 = cljs.core.seq(seq__40911_41291);
if(temp__5720__auto___41302){
var seq__40911_41303__$1 = temp__5720__auto___41302;
if(cljs.core.chunked_seq_QMARK_(seq__40911_41303__$1)){
var c__4556__auto___41304 = cljs.core.chunk_first(seq__40911_41303__$1);
var G__41305 = cljs.core.chunk_rest(seq__40911_41303__$1);
var G__41306 = c__4556__auto___41304;
var G__41307 = cljs.core.count(c__4556__auto___41304);
var G__41308 = (0);
seq__40911_41291 = G__41305;
chunk__40912_41292 = G__41306;
count__40913_41293 = G__41307;
i__40914_41294 = G__41308;
continue;
} else {
var vec__40924_41309 = cljs.core.first(seq__40911_41303__$1);
var script_tag_41310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40924_41309,(0),null);
var script_body_41311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40924_41309,(1),null);
eval(script_body_41311);


var G__41316 = cljs.core.next(seq__40911_41303__$1);
var G__41317 = null;
var G__41318 = (0);
var G__41319 = (0);
seq__40911_41291 = G__41316;
chunk__40912_41292 = G__41317;
count__40913_41293 = G__41318;
i__40914_41294 = G__41319;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__40927){
var vec__40928 = p__40927;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40928,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40928,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__40932 = arguments.length;
switch (G__40932) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__40933 = cljs.core.seq(style_keys);
var chunk__40934 = null;
var count__40935 = (0);
var i__40936 = (0);
while(true){
if((i__40936 < count__40935)){
var it = chunk__40934.cljs$core$IIndexed$_nth$arity$2(null,i__40936);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41321 = seq__40933;
var G__41322 = chunk__40934;
var G__41323 = count__40935;
var G__41324 = (i__40936 + (1));
seq__40933 = G__41321;
chunk__40934 = G__41322;
count__40935 = G__41323;
i__40936 = G__41324;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__40933);
if(temp__5720__auto__){
var seq__40933__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40933__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__40933__$1);
var G__41327 = cljs.core.chunk_rest(seq__40933__$1);
var G__41328 = c__4556__auto__;
var G__41329 = cljs.core.count(c__4556__auto__);
var G__41330 = (0);
seq__40933 = G__41327;
chunk__40934 = G__41328;
count__40935 = G__41329;
i__40936 = G__41330;
continue;
} else {
var it = cljs.core.first(seq__40933__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41331 = cljs.core.next(seq__40933__$1);
var G__41332 = null;
var G__41333 = (0);
var G__41334 = (0);
seq__40933 = G__41331;
chunk__40934 = G__41332;
count__40935 = G__41333;
i__40936 = G__41334;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k40938,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__40942 = k40938;
var G__40942__$1 = (((G__40942 instanceof cljs.core.Keyword))?G__40942.fqn:null);
switch (G__40942__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40938,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__40943){
var vec__40944 = p__40943;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40944,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40944,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40937){
var self__ = this;
var G__40937__$1 = this;
return (new cljs.core.RecordIter((0),G__40937__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40939,other40940){
var self__ = this;
var this40939__$1 = this;
return (((!((other40940 == null)))) && ((this40939__$1.constructor === other40940.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40939__$1.x,other40940.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40939__$1.y,other40940.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40939__$1.__extmap,other40940.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__40937){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__40947 = cljs.core.keyword_identical_QMARK_;
var expr__40948 = k__4388__auto__;
if(cljs.core.truth_((pred__40947.cljs$core$IFn$_invoke$arity$2 ? pred__40947.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__40948) : pred__40947.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__40948)))){
return (new shadow.dom.Coordinate(G__40937,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__40947.cljs$core$IFn$_invoke$arity$2 ? pred__40947.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__40948) : pred__40947.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__40948)))){
return (new shadow.dom.Coordinate(self__.x,G__40937,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__40937),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__40937){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__40937,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__40941){
var extmap__4419__auto__ = (function (){var G__40950 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40941,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__40941)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40950);
} else {
return G__40950;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__40941),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__40941),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k40952,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__40956 = k40952;
var G__40956__$1 = (((G__40956 instanceof cljs.core.Keyword))?G__40956.fqn:null);
switch (G__40956__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40952,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__40957){
var vec__40958 = p__40957;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40958,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40958,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40951){
var self__ = this;
var G__40951__$1 = this;
return (new cljs.core.RecordIter((0),G__40951__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40953,other40954){
var self__ = this;
var this40953__$1 = this;
return (((!((other40954 == null)))) && ((this40953__$1.constructor === other40954.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40953__$1.w,other40954.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40953__$1.h,other40954.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40953__$1.__extmap,other40954.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__40951){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__40961 = cljs.core.keyword_identical_QMARK_;
var expr__40962 = k__4388__auto__;
if(cljs.core.truth_((pred__40961.cljs$core$IFn$_invoke$arity$2 ? pred__40961.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__40962) : pred__40961.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__40962)))){
return (new shadow.dom.Size(G__40951,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__40961.cljs$core$IFn$_invoke$arity$2 ? pred__40961.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__40962) : pred__40961.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__40962)))){
return (new shadow.dom.Size(self__.w,G__40951,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__40951),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__40951){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__40951,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__40955){
var extmap__4419__auto__ = (function (){var G__40964 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40955,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__40955)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40964);
} else {
return G__40964;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__40955),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__40955),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__41356 = (i + (1));
var G__41357 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__41356;
ret = G__41357;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__40969){
var vec__40970 = p__40969;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40970,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40970,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__40974 = arguments.length;
switch (G__40974) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__41359 = ps;
var G__41360 = (i + (1));
el__$1 = G__41359;
i = G__41360;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__40975 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40975,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40975,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40975,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__40978_41367 = cljs.core.seq(props);
var chunk__40979_41368 = null;
var count__40980_41369 = (0);
var i__40981_41370 = (0);
while(true){
if((i__40981_41370 < count__40980_41369)){
var vec__40988_41371 = chunk__40979_41368.cljs$core$IIndexed$_nth$arity$2(null,i__40981_41370);
var k_41372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40988_41371,(0),null);
var v_41373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40988_41371,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_41372);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41372),v_41373);


var G__41376 = seq__40978_41367;
var G__41377 = chunk__40979_41368;
var G__41378 = count__40980_41369;
var G__41379 = (i__40981_41370 + (1));
seq__40978_41367 = G__41376;
chunk__40979_41368 = G__41377;
count__40980_41369 = G__41378;
i__40981_41370 = G__41379;
continue;
} else {
var temp__5720__auto___41380 = cljs.core.seq(seq__40978_41367);
if(temp__5720__auto___41380){
var seq__40978_41381__$1 = temp__5720__auto___41380;
if(cljs.core.chunked_seq_QMARK_(seq__40978_41381__$1)){
var c__4556__auto___41382 = cljs.core.chunk_first(seq__40978_41381__$1);
var G__41383 = cljs.core.chunk_rest(seq__40978_41381__$1);
var G__41384 = c__4556__auto___41382;
var G__41385 = cljs.core.count(c__4556__auto___41382);
var G__41386 = (0);
seq__40978_41367 = G__41383;
chunk__40979_41368 = G__41384;
count__40980_41369 = G__41385;
i__40981_41370 = G__41386;
continue;
} else {
var vec__40991_41389 = cljs.core.first(seq__40978_41381__$1);
var k_41390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40991_41389,(0),null);
var v_41391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40991_41389,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_41390);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41390),v_41391);


var G__41392 = cljs.core.next(seq__40978_41381__$1);
var G__41393 = null;
var G__41394 = (0);
var G__41395 = (0);
seq__40978_41367 = G__41392;
chunk__40979_41368 = G__41393;
count__40980_41369 = G__41394;
i__40981_41370 = G__41395;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__40995 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40995,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40995,(1),null);
var seq__40998_41398 = cljs.core.seq(node_children);
var chunk__41000_41399 = null;
var count__41001_41400 = (0);
var i__41002_41401 = (0);
while(true){
if((i__41002_41401 < count__41001_41400)){
var child_struct_41406 = chunk__41000_41399.cljs$core$IIndexed$_nth$arity$2(null,i__41002_41401);
if((!((child_struct_41406 == null)))){
if(typeof child_struct_41406 === 'string'){
var text_41407 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41407),child_struct_41406].join(''));
} else {
var children_41408 = shadow.dom.svg_node(child_struct_41406);
if(cljs.core.seq_QMARK_(children_41408)){
var seq__41016_41409 = cljs.core.seq(children_41408);
var chunk__41018_41410 = null;
var count__41019_41411 = (0);
var i__41020_41412 = (0);
while(true){
if((i__41020_41412 < count__41019_41411)){
var child_41413 = chunk__41018_41410.cljs$core$IIndexed$_nth$arity$2(null,i__41020_41412);
if(cljs.core.truth_(child_41413)){
node.appendChild(child_41413);


var G__41414 = seq__41016_41409;
var G__41415 = chunk__41018_41410;
var G__41416 = count__41019_41411;
var G__41417 = (i__41020_41412 + (1));
seq__41016_41409 = G__41414;
chunk__41018_41410 = G__41415;
count__41019_41411 = G__41416;
i__41020_41412 = G__41417;
continue;
} else {
var G__41418 = seq__41016_41409;
var G__41419 = chunk__41018_41410;
var G__41420 = count__41019_41411;
var G__41421 = (i__41020_41412 + (1));
seq__41016_41409 = G__41418;
chunk__41018_41410 = G__41419;
count__41019_41411 = G__41420;
i__41020_41412 = G__41421;
continue;
}
} else {
var temp__5720__auto___41422 = cljs.core.seq(seq__41016_41409);
if(temp__5720__auto___41422){
var seq__41016_41423__$1 = temp__5720__auto___41422;
if(cljs.core.chunked_seq_QMARK_(seq__41016_41423__$1)){
var c__4556__auto___41424 = cljs.core.chunk_first(seq__41016_41423__$1);
var G__41425 = cljs.core.chunk_rest(seq__41016_41423__$1);
var G__41426 = c__4556__auto___41424;
var G__41427 = cljs.core.count(c__4556__auto___41424);
var G__41428 = (0);
seq__41016_41409 = G__41425;
chunk__41018_41410 = G__41426;
count__41019_41411 = G__41427;
i__41020_41412 = G__41428;
continue;
} else {
var child_41429 = cljs.core.first(seq__41016_41423__$1);
if(cljs.core.truth_(child_41429)){
node.appendChild(child_41429);


var G__41430 = cljs.core.next(seq__41016_41423__$1);
var G__41431 = null;
var G__41432 = (0);
var G__41433 = (0);
seq__41016_41409 = G__41430;
chunk__41018_41410 = G__41431;
count__41019_41411 = G__41432;
i__41020_41412 = G__41433;
continue;
} else {
var G__41434 = cljs.core.next(seq__41016_41423__$1);
var G__41435 = null;
var G__41436 = (0);
var G__41437 = (0);
seq__41016_41409 = G__41434;
chunk__41018_41410 = G__41435;
count__41019_41411 = G__41436;
i__41020_41412 = G__41437;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41408);
}
}


var G__41438 = seq__40998_41398;
var G__41439 = chunk__41000_41399;
var G__41440 = count__41001_41400;
var G__41441 = (i__41002_41401 + (1));
seq__40998_41398 = G__41438;
chunk__41000_41399 = G__41439;
count__41001_41400 = G__41440;
i__41002_41401 = G__41441;
continue;
} else {
var G__41442 = seq__40998_41398;
var G__41443 = chunk__41000_41399;
var G__41444 = count__41001_41400;
var G__41445 = (i__41002_41401 + (1));
seq__40998_41398 = G__41442;
chunk__41000_41399 = G__41443;
count__41001_41400 = G__41444;
i__41002_41401 = G__41445;
continue;
}
} else {
var temp__5720__auto___41446 = cljs.core.seq(seq__40998_41398);
if(temp__5720__auto___41446){
var seq__40998_41447__$1 = temp__5720__auto___41446;
if(cljs.core.chunked_seq_QMARK_(seq__40998_41447__$1)){
var c__4556__auto___41448 = cljs.core.chunk_first(seq__40998_41447__$1);
var G__41449 = cljs.core.chunk_rest(seq__40998_41447__$1);
var G__41450 = c__4556__auto___41448;
var G__41451 = cljs.core.count(c__4556__auto___41448);
var G__41452 = (0);
seq__40998_41398 = G__41449;
chunk__41000_41399 = G__41450;
count__41001_41400 = G__41451;
i__41002_41401 = G__41452;
continue;
} else {
var child_struct_41453 = cljs.core.first(seq__40998_41447__$1);
if((!((child_struct_41453 == null)))){
if(typeof child_struct_41453 === 'string'){
var text_41454 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41454),child_struct_41453].join(''));
} else {
var children_41457 = shadow.dom.svg_node(child_struct_41453);
if(cljs.core.seq_QMARK_(children_41457)){
var seq__41022_41458 = cljs.core.seq(children_41457);
var chunk__41024_41459 = null;
var count__41025_41460 = (0);
var i__41026_41461 = (0);
while(true){
if((i__41026_41461 < count__41025_41460)){
var child_41462 = chunk__41024_41459.cljs$core$IIndexed$_nth$arity$2(null,i__41026_41461);
if(cljs.core.truth_(child_41462)){
node.appendChild(child_41462);


var G__41463 = seq__41022_41458;
var G__41464 = chunk__41024_41459;
var G__41465 = count__41025_41460;
var G__41466 = (i__41026_41461 + (1));
seq__41022_41458 = G__41463;
chunk__41024_41459 = G__41464;
count__41025_41460 = G__41465;
i__41026_41461 = G__41466;
continue;
} else {
var G__41467 = seq__41022_41458;
var G__41468 = chunk__41024_41459;
var G__41469 = count__41025_41460;
var G__41470 = (i__41026_41461 + (1));
seq__41022_41458 = G__41467;
chunk__41024_41459 = G__41468;
count__41025_41460 = G__41469;
i__41026_41461 = G__41470;
continue;
}
} else {
var temp__5720__auto___41471__$1 = cljs.core.seq(seq__41022_41458);
if(temp__5720__auto___41471__$1){
var seq__41022_41472__$1 = temp__5720__auto___41471__$1;
if(cljs.core.chunked_seq_QMARK_(seq__41022_41472__$1)){
var c__4556__auto___41473 = cljs.core.chunk_first(seq__41022_41472__$1);
var G__41474 = cljs.core.chunk_rest(seq__41022_41472__$1);
var G__41475 = c__4556__auto___41473;
var G__41476 = cljs.core.count(c__4556__auto___41473);
var G__41477 = (0);
seq__41022_41458 = G__41474;
chunk__41024_41459 = G__41475;
count__41025_41460 = G__41476;
i__41026_41461 = G__41477;
continue;
} else {
var child_41478 = cljs.core.first(seq__41022_41472__$1);
if(cljs.core.truth_(child_41478)){
node.appendChild(child_41478);


var G__41479 = cljs.core.next(seq__41022_41472__$1);
var G__41480 = null;
var G__41481 = (0);
var G__41482 = (0);
seq__41022_41458 = G__41479;
chunk__41024_41459 = G__41480;
count__41025_41460 = G__41481;
i__41026_41461 = G__41482;
continue;
} else {
var G__41483 = cljs.core.next(seq__41022_41472__$1);
var G__41484 = null;
var G__41485 = (0);
var G__41486 = (0);
seq__41022_41458 = G__41483;
chunk__41024_41459 = G__41484;
count__41025_41460 = G__41485;
i__41026_41461 = G__41486;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41457);
}
}


var G__41488 = cljs.core.next(seq__40998_41447__$1);
var G__41489 = null;
var G__41490 = (0);
var G__41491 = (0);
seq__40998_41398 = G__41488;
chunk__41000_41399 = G__41489;
count__41001_41400 = G__41490;
i__41002_41401 = G__41491;
continue;
} else {
var G__41492 = cljs.core.next(seq__40998_41447__$1);
var G__41493 = null;
var G__41494 = (0);
var G__41495 = (0);
seq__40998_41398 = G__41492;
chunk__41000_41399 = G__41493;
count__41001_41400 = G__41494;
i__41002_41401 = G__41495;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41498 = arguments.length;
var i__4737__auto___41499 = (0);
while(true){
if((i__4737__auto___41499 < len__4736__auto___41498)){
args__4742__auto__.push((arguments[i__4737__auto___41499]));

var G__41500 = (i__4737__auto___41499 + (1));
i__4737__auto___41499 = G__41500;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq41036){
var G__41037 = cljs.core.first(seq41036);
var seq41036__$1 = cljs.core.next(seq41036);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41037,seq41036__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__41048 = arguments.length;
switch (G__41048) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__40457__auto___41508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__40458__auto__ = (function (){var switch__40387__auto__ = (function (state_41055){
var state_val_41056 = (state_41055[(1)]);
if((state_val_41056 === (1))){
var state_41055__$1 = state_41055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41055__$1,(2),once_or_cleanup);
} else {
if((state_val_41056 === (2))){
var inst_41052 = (state_41055[(2)]);
var inst_41053 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_41055__$1 = (function (){var statearr_41057 = state_41055;
(statearr_41057[(7)] = inst_41052);

return statearr_41057;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41055__$1,inst_41053);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__40388__auto__ = null;
var shadow$dom$state_machine__40388__auto____0 = (function (){
var statearr_41058 = [null,null,null,null,null,null,null,null];
(statearr_41058[(0)] = shadow$dom$state_machine__40388__auto__);

(statearr_41058[(1)] = (1));

return statearr_41058;
});
var shadow$dom$state_machine__40388__auto____1 = (function (state_41055){
while(true){
var ret_value__40389__auto__ = (function (){try{while(true){
var result__40390__auto__ = switch__40387__auto__(state_41055);
if(cljs.core.keyword_identical_QMARK_(result__40390__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__40390__auto__;
}
break;
}
}catch (e41059){var ex__40391__auto__ = e41059;
var statearr_41060_41526 = state_41055;
(statearr_41060_41526[(2)] = ex__40391__auto__);


if(cljs.core.seq((state_41055[(4)]))){
var statearr_41061_41528 = state_41055;
(statearr_41061_41528[(1)] = cljs.core.first((state_41055[(4)])));

} else {
throw ex__40391__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__40389__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41532 = state_41055;
state_41055 = G__41532;
continue;
} else {
return ret_value__40389__auto__;
}
break;
}
});
shadow$dom$state_machine__40388__auto__ = function(state_41055){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__40388__auto____0.call(this);
case 1:
return shadow$dom$state_machine__40388__auto____1.call(this,state_41055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__40388__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__40388__auto____0;
shadow$dom$state_machine__40388__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__40388__auto____1;
return shadow$dom$state_machine__40388__auto__;
})()
})();
var state__40459__auto__ = (function (){var statearr_41062 = f__40458__auto__();
(statearr_41062[(6)] = c__40457__auto___41508);

return statearr_41062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__40459__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
