goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__20329 = arguments.length;
switch (G__20329) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20330 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20330 = (function (f,blockable,meta20331){
this.f = f;
this.blockable = blockable;
this.meta20331 = meta20331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20332,meta20331__$1){
var self__ = this;
var _20332__$1 = this;
return (new cljs.core.async.t_cljs$core$async20330(self__.f,self__.blockable,meta20331__$1));
}));

(cljs.core.async.t_cljs$core$async20330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20332){
var self__ = this;
var _20332__$1 = this;
return self__.meta20331;
}));

(cljs.core.async.t_cljs$core$async20330.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20330.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20330.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async20330.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async20330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20331","meta20331",-440817813,null)], null);
}));

(cljs.core.async.t_cljs$core$async20330.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20330");

(cljs.core.async.t_cljs$core$async20330.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async20330");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20330.
 */
cljs.core.async.__GT_t_cljs$core$async20330 = (function cljs$core$async$__GT_t_cljs$core$async20330(f__$1,blockable__$1,meta20331){
return (new cljs.core.async.t_cljs$core$async20330(f__$1,blockable__$1,meta20331));
});

}

return (new cljs.core.async.t_cljs$core$async20330(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__20335 = arguments.length;
switch (G__20335) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__20337 = arguments.length;
switch (G__20337) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__20339 = arguments.length;
switch (G__20339) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_21812 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_21812) : fn1.call(null,val_21812));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_21812) : fn1.call(null,val_21812));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__20341 = arguments.length;
switch (G__20341) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___21836 = n;
var x_21837 = (0);
while(true){
if((x_21837 < n__4613__auto___21836)){
(a[x_21837] = x_21837);

var G__21838 = (x_21837 + (1));
x_21837 = G__21838;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20342 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20342 = (function (flag,meta20343){
this.flag = flag;
this.meta20343 = meta20343;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20342.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20344,meta20343__$1){
var self__ = this;
var _20344__$1 = this;
return (new cljs.core.async.t_cljs$core$async20342(self__.flag,meta20343__$1));
}));

(cljs.core.async.t_cljs$core$async20342.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20344){
var self__ = this;
var _20344__$1 = this;
return self__.meta20343;
}));

(cljs.core.async.t_cljs$core$async20342.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20342.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async20342.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20342.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async20342.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20343","meta20343",-601847576,null)], null);
}));

(cljs.core.async.t_cljs$core$async20342.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20342.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20342");

(cljs.core.async.t_cljs$core$async20342.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async20342");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20342.
 */
cljs.core.async.__GT_t_cljs$core$async20342 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20342(flag__$1,meta20343){
return (new cljs.core.async.t_cljs$core$async20342(flag__$1,meta20343));
});

}

return (new cljs.core.async.t_cljs$core$async20342(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20345 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20345 = (function (flag,cb,meta20346){
this.flag = flag;
this.cb = cb;
this.meta20346 = meta20346;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20345.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20347,meta20346__$1){
var self__ = this;
var _20347__$1 = this;
return (new cljs.core.async.t_cljs$core$async20345(self__.flag,self__.cb,meta20346__$1));
}));

(cljs.core.async.t_cljs$core$async20345.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20347){
var self__ = this;
var _20347__$1 = this;
return self__.meta20346;
}));

(cljs.core.async.t_cljs$core$async20345.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20345.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async20345.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20345.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async20345.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20346","meta20346",-841683618,null)], null);
}));

(cljs.core.async.t_cljs$core$async20345.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20345.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20345");

(cljs.core.async.t_cljs$core$async20345.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async20345");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20345.
 */
cljs.core.async.__GT_t_cljs$core$async20345 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20345(flag__$1,cb__$1,meta20346){
return (new cljs.core.async.t_cljs$core$async20345(flag__$1,cb__$1,meta20346));
});

}

return (new cljs.core.async.t_cljs$core$async20345(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20348_SHARP_){
var G__20350 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20348_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__20350) : fret.call(null,G__20350));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20349_SHARP_){
var G__20351 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20349_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__20351) : fret.call(null,G__20351));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__21883 = (i + (1));
i = G__21883;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___21885 = arguments.length;
var i__4737__auto___21886 = (0);
while(true){
if((i__4737__auto___21886 < len__4736__auto___21885)){
args__4742__auto__.push((arguments[i__4737__auto___21886]));

var G__21887 = (i__4737__auto___21886 + (1));
i__4737__auto___21886 = G__21887;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20354){
var map__20355 = p__20354;
var map__20355__$1 = (((((!((map__20355 == null))))?(((((map__20355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20355.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20355):map__20355);
var opts = map__20355__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20352){
var G__20353 = cljs.core.first(seq20352);
var seq20352__$1 = cljs.core.next(seq20352);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20353,seq20352__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__20358 = arguments.length;
switch (G__20358) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20271__auto___21908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20382){
var state_val_20383 = (state_20382[(1)]);
if((state_val_20383 === (7))){
var inst_20378 = (state_20382[(2)]);
var state_20382__$1 = state_20382;
var statearr_20384_21911 = state_20382__$1;
(statearr_20384_21911[(2)] = inst_20378);

(statearr_20384_21911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (1))){
var state_20382__$1 = state_20382;
var statearr_20385_21916 = state_20382__$1;
(statearr_20385_21916[(2)] = null);

(statearr_20385_21916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (4))){
var inst_20361 = (state_20382[(7)]);
var inst_20361__$1 = (state_20382[(2)]);
var inst_20362 = (inst_20361__$1 == null);
var state_20382__$1 = (function (){var statearr_20386 = state_20382;
(statearr_20386[(7)] = inst_20361__$1);

return statearr_20386;
})();
if(cljs.core.truth_(inst_20362)){
var statearr_20387_21920 = state_20382__$1;
(statearr_20387_21920[(1)] = (5));

} else {
var statearr_20388_21921 = state_20382__$1;
(statearr_20388_21921[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (13))){
var state_20382__$1 = state_20382;
var statearr_20389_21925 = state_20382__$1;
(statearr_20389_21925[(2)] = null);

(statearr_20389_21925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (6))){
var inst_20361 = (state_20382[(7)]);
var state_20382__$1 = state_20382;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20382__$1,(11),to,inst_20361);
} else {
if((state_val_20383 === (3))){
var inst_20380 = (state_20382[(2)]);
var state_20382__$1 = state_20382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20382__$1,inst_20380);
} else {
if((state_val_20383 === (12))){
var state_20382__$1 = state_20382;
var statearr_20390_21929 = state_20382__$1;
(statearr_20390_21929[(2)] = null);

(statearr_20390_21929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (2))){
var state_20382__$1 = state_20382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20382__$1,(4),from);
} else {
if((state_val_20383 === (11))){
var inst_20371 = (state_20382[(2)]);
var state_20382__$1 = state_20382;
if(cljs.core.truth_(inst_20371)){
var statearr_20391_21931 = state_20382__$1;
(statearr_20391_21931[(1)] = (12));

} else {
var statearr_20392_21933 = state_20382__$1;
(statearr_20392_21933[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (9))){
var state_20382__$1 = state_20382;
var statearr_20393_21936 = state_20382__$1;
(statearr_20393_21936[(2)] = null);

(statearr_20393_21936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (5))){
var state_20382__$1 = state_20382;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20394_21941 = state_20382__$1;
(statearr_20394_21941[(1)] = (8));

} else {
var statearr_20395_21943 = state_20382__$1;
(statearr_20395_21943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (14))){
var inst_20376 = (state_20382[(2)]);
var state_20382__$1 = state_20382;
var statearr_20396_21945 = state_20382__$1;
(statearr_20396_21945[(2)] = inst_20376);

(statearr_20396_21945[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (10))){
var inst_20368 = (state_20382[(2)]);
var state_20382__$1 = state_20382;
var statearr_20397_21946 = state_20382__$1;
(statearr_20397_21946[(2)] = inst_20368);

(statearr_20397_21946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20383 === (8))){
var inst_20365 = cljs.core.async.close_BANG_(to);
var state_20382__$1 = state_20382;
var statearr_20398_21949 = state_20382__$1;
(statearr_20398_21949[(2)] = inst_20365);

(statearr_20398_21949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_20399 = [null,null,null,null,null,null,null,null];
(statearr_20399[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_20399[(1)] = (1));

return statearr_20399;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_20382){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20382);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20400){var ex__20127__auto__ = e20400;
var statearr_20401_21957 = state_20382;
(statearr_20401_21957[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20382[(4)]))){
var statearr_20402_21958 = state_20382;
(statearr_20402_21958[(1)] = cljs.core.first((state_20382[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21959 = state_20382;
state_20382 = G__21959;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_20382){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_20382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20403 = f__20272__auto__();
(statearr_20403[(6)] = c__20271__auto___21908);

return statearr_20403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__20404){
var vec__20405 = p__20404;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20405,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20405,(1),null);
var job = vec__20405;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__20271__auto___21970 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20412){
var state_val_20413 = (state_20412[(1)]);
if((state_val_20413 === (1))){
var state_20412__$1 = state_20412;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20412__$1,(2),res,v);
} else {
if((state_val_20413 === (2))){
var inst_20409 = (state_20412[(2)]);
var inst_20410 = cljs.core.async.close_BANG_(res);
var state_20412__$1 = (function (){var statearr_20414 = state_20412;
(statearr_20414[(7)] = inst_20409);

return statearr_20414;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20412__$1,inst_20410);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0 = (function (){
var statearr_20415 = [null,null,null,null,null,null,null,null];
(statearr_20415[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__);

(statearr_20415[(1)] = (1));

return statearr_20415;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1 = (function (state_20412){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20412);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20416){var ex__20127__auto__ = e20416;
var statearr_20417_21980 = state_20412;
(statearr_20417_21980[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20412[(4)]))){
var statearr_20418_21981 = state_20412;
(statearr_20418_21981[(1)] = cljs.core.first((state_20412[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21983 = state_20412;
state_20412 = G__21983;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = function(state_20412){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1.call(this,state_20412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20419 = f__20272__auto__();
(statearr_20419[(6)] = c__20271__auto___21970);

return statearr_20419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__20420){
var vec__20421 = p__20420;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20421,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20421,(1),null);
var job = vec__20421;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___21985 = n;
var __21986 = (0);
while(true){
if((__21986 < n__4613__auto___21985)){
var G__20424_21987 = type;
var G__20424_21988__$1 = (((G__20424_21987 instanceof cljs.core.Keyword))?G__20424_21987.fqn:null);
switch (G__20424_21988__$1) {
case "compute":
var c__20271__auto___21990 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__21986,c__20271__auto___21990,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async){
return (function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = ((function (__21986,c__20271__auto___21990,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async){
return (function (state_20437){
var state_val_20438 = (state_20437[(1)]);
if((state_val_20438 === (1))){
var state_20437__$1 = state_20437;
var statearr_20439_21992 = state_20437__$1;
(statearr_20439_21992[(2)] = null);

(statearr_20439_21992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20438 === (2))){
var state_20437__$1 = state_20437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20437__$1,(4),jobs);
} else {
if((state_val_20438 === (3))){
var inst_20435 = (state_20437[(2)]);
var state_20437__$1 = state_20437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20437__$1,inst_20435);
} else {
if((state_val_20438 === (4))){
var inst_20427 = (state_20437[(2)]);
var inst_20428 = process(inst_20427);
var state_20437__$1 = state_20437;
if(cljs.core.truth_(inst_20428)){
var statearr_20440_21993 = state_20437__$1;
(statearr_20440_21993[(1)] = (5));

} else {
var statearr_20441_21994 = state_20437__$1;
(statearr_20441_21994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20438 === (5))){
var state_20437__$1 = state_20437;
var statearr_20442_21995 = state_20437__$1;
(statearr_20442_21995[(2)] = null);

(statearr_20442_21995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20438 === (6))){
var state_20437__$1 = state_20437;
var statearr_20443_21996 = state_20437__$1;
(statearr_20443_21996[(2)] = null);

(statearr_20443_21996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20438 === (7))){
var inst_20433 = (state_20437[(2)]);
var state_20437__$1 = state_20437;
var statearr_20444_21997 = state_20437__$1;
(statearr_20444_21997[(2)] = inst_20433);

(statearr_20444_21997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21986,c__20271__auto___21990,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async))
;
return ((function (__21986,switch__20123__auto__,c__20271__auto___21990,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0 = (function (){
var statearr_20445 = [null,null,null,null,null,null,null];
(statearr_20445[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__);

(statearr_20445[(1)] = (1));

return statearr_20445;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1 = (function (state_20437){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20437);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20446){var ex__20127__auto__ = e20446;
var statearr_20447_21998 = state_20437;
(statearr_20447_21998[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20437[(4)]))){
var statearr_20448_21999 = state_20437;
(statearr_20448_21999[(1)] = cljs.core.first((state_20437[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22000 = state_20437;
state_20437 = G__22000;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = function(state_20437){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1.call(this,state_20437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__;
})()
;})(__21986,switch__20123__auto__,c__20271__auto___21990,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async))
})();
var state__20273__auto__ = (function (){var statearr_20449 = f__20272__auto__();
(statearr_20449[(6)] = c__20271__auto___21990);

return statearr_20449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
});})(__21986,c__20271__auto___21990,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async))
);


break;
case "async":
var c__20271__auto___22001 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__21986,c__20271__auto___22001,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async){
return (function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = ((function (__21986,c__20271__auto___22001,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async){
return (function (state_20462){
var state_val_20463 = (state_20462[(1)]);
if((state_val_20463 === (1))){
var state_20462__$1 = state_20462;
var statearr_20464_22002 = state_20462__$1;
(statearr_20464_22002[(2)] = null);

(statearr_20464_22002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20463 === (2))){
var state_20462__$1 = state_20462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20462__$1,(4),jobs);
} else {
if((state_val_20463 === (3))){
var inst_20460 = (state_20462[(2)]);
var state_20462__$1 = state_20462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20462__$1,inst_20460);
} else {
if((state_val_20463 === (4))){
var inst_20452 = (state_20462[(2)]);
var inst_20453 = async(inst_20452);
var state_20462__$1 = state_20462;
if(cljs.core.truth_(inst_20453)){
var statearr_20465_22003 = state_20462__$1;
(statearr_20465_22003[(1)] = (5));

} else {
var statearr_20466_22005 = state_20462__$1;
(statearr_20466_22005[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20463 === (5))){
var state_20462__$1 = state_20462;
var statearr_20467_22007 = state_20462__$1;
(statearr_20467_22007[(2)] = null);

(statearr_20467_22007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20463 === (6))){
var state_20462__$1 = state_20462;
var statearr_20468_22010 = state_20462__$1;
(statearr_20468_22010[(2)] = null);

(statearr_20468_22010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20463 === (7))){
var inst_20458 = (state_20462[(2)]);
var state_20462__$1 = state_20462;
var statearr_20469_22011 = state_20462__$1;
(statearr_20469_22011[(2)] = inst_20458);

(statearr_20469_22011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__21986,c__20271__auto___22001,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async))
;
return ((function (__21986,switch__20123__auto__,c__20271__auto___22001,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0 = (function (){
var statearr_20470 = [null,null,null,null,null,null,null];
(statearr_20470[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__);

(statearr_20470[(1)] = (1));

return statearr_20470;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1 = (function (state_20462){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20462);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20471){var ex__20127__auto__ = e20471;
var statearr_20472_22019 = state_20462;
(statearr_20472_22019[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20462[(4)]))){
var statearr_20473_22021 = state_20462;
(statearr_20473_22021[(1)] = cljs.core.first((state_20462[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22023 = state_20462;
state_20462 = G__22023;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = function(state_20462){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1.call(this,state_20462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__;
})()
;})(__21986,switch__20123__auto__,c__20271__auto___22001,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async))
})();
var state__20273__auto__ = (function (){var statearr_20474 = f__20272__auto__();
(statearr_20474[(6)] = c__20271__auto___22001);

return statearr_20474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
});})(__21986,c__20271__auto___22001,G__20424_21987,G__20424_21988__$1,n__4613__auto___21985,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20424_21988__$1)].join('')));

}

var G__22033 = (__21986 + (1));
__21986 = G__22033;
continue;
} else {
}
break;
}

var c__20271__auto___22034 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20496){
var state_val_20497 = (state_20496[(1)]);
if((state_val_20497 === (7))){
var inst_20492 = (state_20496[(2)]);
var state_20496__$1 = state_20496;
var statearr_20498_22040 = state_20496__$1;
(statearr_20498_22040[(2)] = inst_20492);

(statearr_20498_22040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20497 === (1))){
var state_20496__$1 = state_20496;
var statearr_20499_22042 = state_20496__$1;
(statearr_20499_22042[(2)] = null);

(statearr_20499_22042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20497 === (4))){
var inst_20477 = (state_20496[(7)]);
var inst_20477__$1 = (state_20496[(2)]);
var inst_20478 = (inst_20477__$1 == null);
var state_20496__$1 = (function (){var statearr_20500 = state_20496;
(statearr_20500[(7)] = inst_20477__$1);

return statearr_20500;
})();
if(cljs.core.truth_(inst_20478)){
var statearr_20501_22044 = state_20496__$1;
(statearr_20501_22044[(1)] = (5));

} else {
var statearr_20502_22045 = state_20496__$1;
(statearr_20502_22045[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20497 === (6))){
var inst_20482 = (state_20496[(8)]);
var inst_20477 = (state_20496[(7)]);
var inst_20482__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_20483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20484 = [inst_20477,inst_20482__$1];
var inst_20485 = (new cljs.core.PersistentVector(null,2,(5),inst_20483,inst_20484,null));
var state_20496__$1 = (function (){var statearr_20503 = state_20496;
(statearr_20503[(8)] = inst_20482__$1);

return statearr_20503;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20496__$1,(8),jobs,inst_20485);
} else {
if((state_val_20497 === (3))){
var inst_20494 = (state_20496[(2)]);
var state_20496__$1 = state_20496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20496__$1,inst_20494);
} else {
if((state_val_20497 === (2))){
var state_20496__$1 = state_20496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20496__$1,(4),from);
} else {
if((state_val_20497 === (9))){
var inst_20489 = (state_20496[(2)]);
var state_20496__$1 = (function (){var statearr_20504 = state_20496;
(statearr_20504[(9)] = inst_20489);

return statearr_20504;
})();
var statearr_20505_22058 = state_20496__$1;
(statearr_20505_22058[(2)] = null);

(statearr_20505_22058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20497 === (5))){
var inst_20480 = cljs.core.async.close_BANG_(jobs);
var state_20496__$1 = state_20496;
var statearr_20506_22072 = state_20496__$1;
(statearr_20506_22072[(2)] = inst_20480);

(statearr_20506_22072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20497 === (8))){
var inst_20482 = (state_20496[(8)]);
var inst_20487 = (state_20496[(2)]);
var state_20496__$1 = (function (){var statearr_20507 = state_20496;
(statearr_20507[(10)] = inst_20487);

return statearr_20507;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20496__$1,(9),results,inst_20482);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0 = (function (){
var statearr_20508 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20508[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__);

(statearr_20508[(1)] = (1));

return statearr_20508;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1 = (function (state_20496){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20496);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20509){var ex__20127__auto__ = e20509;
var statearr_20510_22124 = state_20496;
(statearr_20510_22124[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20496[(4)]))){
var statearr_20511_22126 = state_20496;
(statearr_20511_22126[(1)] = cljs.core.first((state_20496[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22129 = state_20496;
state_20496 = G__22129;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = function(state_20496){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1.call(this,state_20496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20512 = f__20272__auto__();
(statearr_20512[(6)] = c__20271__auto___22034);

return statearr_20512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


var c__20271__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20550){
var state_val_20551 = (state_20550[(1)]);
if((state_val_20551 === (7))){
var inst_20546 = (state_20550[(2)]);
var state_20550__$1 = state_20550;
var statearr_20552_22134 = state_20550__$1;
(statearr_20552_22134[(2)] = inst_20546);

(statearr_20552_22134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (20))){
var state_20550__$1 = state_20550;
var statearr_20553_22136 = state_20550__$1;
(statearr_20553_22136[(2)] = null);

(statearr_20553_22136[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (1))){
var state_20550__$1 = state_20550;
var statearr_20554_22137 = state_20550__$1;
(statearr_20554_22137[(2)] = null);

(statearr_20554_22137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (4))){
var inst_20515 = (state_20550[(7)]);
var inst_20515__$1 = (state_20550[(2)]);
var inst_20516 = (inst_20515__$1 == null);
var state_20550__$1 = (function (){var statearr_20555 = state_20550;
(statearr_20555[(7)] = inst_20515__$1);

return statearr_20555;
})();
if(cljs.core.truth_(inst_20516)){
var statearr_20556_22141 = state_20550__$1;
(statearr_20556_22141[(1)] = (5));

} else {
var statearr_20557_22142 = state_20550__$1;
(statearr_20557_22142[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (15))){
var inst_20528 = (state_20550[(8)]);
var state_20550__$1 = state_20550;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20550__$1,(18),to,inst_20528);
} else {
if((state_val_20551 === (21))){
var inst_20541 = (state_20550[(2)]);
var state_20550__$1 = state_20550;
var statearr_20558_22147 = state_20550__$1;
(statearr_20558_22147[(2)] = inst_20541);

(statearr_20558_22147[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (13))){
var inst_20543 = (state_20550[(2)]);
var state_20550__$1 = (function (){var statearr_20559 = state_20550;
(statearr_20559[(9)] = inst_20543);

return statearr_20559;
})();
var statearr_20560_22149 = state_20550__$1;
(statearr_20560_22149[(2)] = null);

(statearr_20560_22149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (6))){
var inst_20515 = (state_20550[(7)]);
var state_20550__$1 = state_20550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20550__$1,(11),inst_20515);
} else {
if((state_val_20551 === (17))){
var inst_20536 = (state_20550[(2)]);
var state_20550__$1 = state_20550;
if(cljs.core.truth_(inst_20536)){
var statearr_20561_22155 = state_20550__$1;
(statearr_20561_22155[(1)] = (19));

} else {
var statearr_20562_22156 = state_20550__$1;
(statearr_20562_22156[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (3))){
var inst_20548 = (state_20550[(2)]);
var state_20550__$1 = state_20550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20550__$1,inst_20548);
} else {
if((state_val_20551 === (12))){
var inst_20525 = (state_20550[(10)]);
var state_20550__$1 = state_20550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20550__$1,(14),inst_20525);
} else {
if((state_val_20551 === (2))){
var state_20550__$1 = state_20550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20550__$1,(4),results);
} else {
if((state_val_20551 === (19))){
var state_20550__$1 = state_20550;
var statearr_20563_22164 = state_20550__$1;
(statearr_20563_22164[(2)] = null);

(statearr_20563_22164[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (11))){
var inst_20525 = (state_20550[(2)]);
var state_20550__$1 = (function (){var statearr_20564 = state_20550;
(statearr_20564[(10)] = inst_20525);

return statearr_20564;
})();
var statearr_20565_22166 = state_20550__$1;
(statearr_20565_22166[(2)] = null);

(statearr_20565_22166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (9))){
var state_20550__$1 = state_20550;
var statearr_20566_22170 = state_20550__$1;
(statearr_20566_22170[(2)] = null);

(statearr_20566_22170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (5))){
var state_20550__$1 = state_20550;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20567_22172 = state_20550__$1;
(statearr_20567_22172[(1)] = (8));

} else {
var statearr_20568_22173 = state_20550__$1;
(statearr_20568_22173[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (14))){
var inst_20528 = (state_20550[(8)]);
var inst_20528__$1 = (state_20550[(2)]);
var inst_20529 = (inst_20528__$1 == null);
var inst_20530 = cljs.core.not(inst_20529);
var state_20550__$1 = (function (){var statearr_20569 = state_20550;
(statearr_20569[(8)] = inst_20528__$1);

return statearr_20569;
})();
if(inst_20530){
var statearr_20570_22181 = state_20550__$1;
(statearr_20570_22181[(1)] = (15));

} else {
var statearr_20571_22183 = state_20550__$1;
(statearr_20571_22183[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (16))){
var state_20550__$1 = state_20550;
var statearr_20572_22185 = state_20550__$1;
(statearr_20572_22185[(2)] = false);

(statearr_20572_22185[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (10))){
var inst_20522 = (state_20550[(2)]);
var state_20550__$1 = state_20550;
var statearr_20573_22188 = state_20550__$1;
(statearr_20573_22188[(2)] = inst_20522);

(statearr_20573_22188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (18))){
var inst_20533 = (state_20550[(2)]);
var state_20550__$1 = state_20550;
var statearr_20574_22191 = state_20550__$1;
(statearr_20574_22191[(2)] = inst_20533);

(statearr_20574_22191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20551 === (8))){
var inst_20519 = cljs.core.async.close_BANG_(to);
var state_20550__$1 = state_20550;
var statearr_20575_22193 = state_20550__$1;
(statearr_20575_22193[(2)] = inst_20519);

(statearr_20575_22193[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0 = (function (){
var statearr_20576 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20576[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__);

(statearr_20576[(1)] = (1));

return statearr_20576;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1 = (function (state_20550){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20550);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20577){var ex__20127__auto__ = e20577;
var statearr_20578_22201 = state_20550;
(statearr_20578_22201[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20550[(4)]))){
var statearr_20579_22203 = state_20550;
(statearr_20579_22203[(1)] = cljs.core.first((state_20550[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22205 = state_20550;
state_20550 = G__22205;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__ = function(state_20550){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1.call(this,state_20550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20124__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20580 = f__20272__auto__();
(statearr_20580[(6)] = c__20271__auto__);

return statearr_20580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

return c__20271__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__20582 = arguments.length;
switch (G__20582) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__20584 = arguments.length;
switch (G__20584) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__20586 = arguments.length;
switch (G__20586) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__20271__auto___22224 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20612){
var state_val_20613 = (state_20612[(1)]);
if((state_val_20613 === (7))){
var inst_20608 = (state_20612[(2)]);
var state_20612__$1 = state_20612;
var statearr_20614_22226 = state_20612__$1;
(statearr_20614_22226[(2)] = inst_20608);

(statearr_20614_22226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (1))){
var state_20612__$1 = state_20612;
var statearr_20615_22228 = state_20612__$1;
(statearr_20615_22228[(2)] = null);

(statearr_20615_22228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (4))){
var inst_20589 = (state_20612[(7)]);
var inst_20589__$1 = (state_20612[(2)]);
var inst_20590 = (inst_20589__$1 == null);
var state_20612__$1 = (function (){var statearr_20616 = state_20612;
(statearr_20616[(7)] = inst_20589__$1);

return statearr_20616;
})();
if(cljs.core.truth_(inst_20590)){
var statearr_20617_22229 = state_20612__$1;
(statearr_20617_22229[(1)] = (5));

} else {
var statearr_20618_22230 = state_20612__$1;
(statearr_20618_22230[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (13))){
var state_20612__$1 = state_20612;
var statearr_20619_22231 = state_20612__$1;
(statearr_20619_22231[(2)] = null);

(statearr_20619_22231[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (6))){
var inst_20589 = (state_20612[(7)]);
var inst_20595 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_20589) : p.call(null,inst_20589));
var state_20612__$1 = state_20612;
if(cljs.core.truth_(inst_20595)){
var statearr_20620_22235 = state_20612__$1;
(statearr_20620_22235[(1)] = (9));

} else {
var statearr_20621_22236 = state_20612__$1;
(statearr_20621_22236[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (3))){
var inst_20610 = (state_20612[(2)]);
var state_20612__$1 = state_20612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20612__$1,inst_20610);
} else {
if((state_val_20613 === (12))){
var state_20612__$1 = state_20612;
var statearr_20622_22239 = state_20612__$1;
(statearr_20622_22239[(2)] = null);

(statearr_20622_22239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (2))){
var state_20612__$1 = state_20612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20612__$1,(4),ch);
} else {
if((state_val_20613 === (11))){
var inst_20589 = (state_20612[(7)]);
var inst_20599 = (state_20612[(2)]);
var state_20612__$1 = state_20612;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20612__$1,(8),inst_20599,inst_20589);
} else {
if((state_val_20613 === (9))){
var state_20612__$1 = state_20612;
var statearr_20623_22244 = state_20612__$1;
(statearr_20623_22244[(2)] = tc);

(statearr_20623_22244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (5))){
var inst_20592 = cljs.core.async.close_BANG_(tc);
var inst_20593 = cljs.core.async.close_BANG_(fc);
var state_20612__$1 = (function (){var statearr_20624 = state_20612;
(statearr_20624[(8)] = inst_20592);

return statearr_20624;
})();
var statearr_20625_22247 = state_20612__$1;
(statearr_20625_22247[(2)] = inst_20593);

(statearr_20625_22247[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (14))){
var inst_20606 = (state_20612[(2)]);
var state_20612__$1 = state_20612;
var statearr_20626_22249 = state_20612__$1;
(statearr_20626_22249[(2)] = inst_20606);

(statearr_20626_22249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (10))){
var state_20612__$1 = state_20612;
var statearr_20627_22251 = state_20612__$1;
(statearr_20627_22251[(2)] = fc);

(statearr_20627_22251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20613 === (8))){
var inst_20601 = (state_20612[(2)]);
var state_20612__$1 = state_20612;
if(cljs.core.truth_(inst_20601)){
var statearr_20628_22254 = state_20612__$1;
(statearr_20628_22254[(1)] = (12));

} else {
var statearr_20629_22256 = state_20612__$1;
(statearr_20629_22256[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_20630 = [null,null,null,null,null,null,null,null,null];
(statearr_20630[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_20630[(1)] = (1));

return statearr_20630;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_20612){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20612);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20631){var ex__20127__auto__ = e20631;
var statearr_20632_22266 = state_20612;
(statearr_20632_22266[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20612[(4)]))){
var statearr_20633_22268 = state_20612;
(statearr_20633_22268[(1)] = cljs.core.first((state_20612[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22271 = state_20612;
state_20612 = G__22271;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_20612){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_20612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20634 = f__20272__auto__();
(statearr_20634[(6)] = c__20271__auto___22224);

return statearr_20634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20271__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20656){
var state_val_20657 = (state_20656[(1)]);
if((state_val_20657 === (7))){
var inst_20652 = (state_20656[(2)]);
var state_20656__$1 = state_20656;
var statearr_20658_22280 = state_20656__$1;
(statearr_20658_22280[(2)] = inst_20652);

(statearr_20658_22280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (1))){
var inst_20635 = init;
var inst_20636 = inst_20635;
var state_20656__$1 = (function (){var statearr_20659 = state_20656;
(statearr_20659[(7)] = inst_20636);

return statearr_20659;
})();
var statearr_20660_22282 = state_20656__$1;
(statearr_20660_22282[(2)] = null);

(statearr_20660_22282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (4))){
var inst_20639 = (state_20656[(8)]);
var inst_20639__$1 = (state_20656[(2)]);
var inst_20640 = (inst_20639__$1 == null);
var state_20656__$1 = (function (){var statearr_20661 = state_20656;
(statearr_20661[(8)] = inst_20639__$1);

return statearr_20661;
})();
if(cljs.core.truth_(inst_20640)){
var statearr_20662_22287 = state_20656__$1;
(statearr_20662_22287[(1)] = (5));

} else {
var statearr_20663_22288 = state_20656__$1;
(statearr_20663_22288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (6))){
var inst_20643 = (state_20656[(9)]);
var inst_20639 = (state_20656[(8)]);
var inst_20636 = (state_20656[(7)]);
var inst_20643__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_20636,inst_20639) : f.call(null,inst_20636,inst_20639));
var inst_20644 = cljs.core.reduced_QMARK_(inst_20643__$1);
var state_20656__$1 = (function (){var statearr_20664 = state_20656;
(statearr_20664[(9)] = inst_20643__$1);

return statearr_20664;
})();
if(inst_20644){
var statearr_20665_22294 = state_20656__$1;
(statearr_20665_22294[(1)] = (8));

} else {
var statearr_20666_22296 = state_20656__$1;
(statearr_20666_22296[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (3))){
var inst_20654 = (state_20656[(2)]);
var state_20656__$1 = state_20656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20656__$1,inst_20654);
} else {
if((state_val_20657 === (2))){
var state_20656__$1 = state_20656;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20656__$1,(4),ch);
} else {
if((state_val_20657 === (9))){
var inst_20643 = (state_20656[(9)]);
var inst_20636 = inst_20643;
var state_20656__$1 = (function (){var statearr_20667 = state_20656;
(statearr_20667[(7)] = inst_20636);

return statearr_20667;
})();
var statearr_20668_22299 = state_20656__$1;
(statearr_20668_22299[(2)] = null);

(statearr_20668_22299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (5))){
var inst_20636 = (state_20656[(7)]);
var state_20656__$1 = state_20656;
var statearr_20669_22302 = state_20656__$1;
(statearr_20669_22302[(2)] = inst_20636);

(statearr_20669_22302[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (10))){
var inst_20650 = (state_20656[(2)]);
var state_20656__$1 = state_20656;
var statearr_20670_22305 = state_20656__$1;
(statearr_20670_22305[(2)] = inst_20650);

(statearr_20670_22305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20657 === (8))){
var inst_20643 = (state_20656[(9)]);
var inst_20646 = cljs.core.deref(inst_20643);
var state_20656__$1 = state_20656;
var statearr_20671_22309 = state_20656__$1;
(statearr_20671_22309[(2)] = inst_20646);

(statearr_20671_22309[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__20124__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20124__auto____0 = (function (){
var statearr_20672 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20672[(0)] = cljs$core$async$reduce_$_state_machine__20124__auto__);

(statearr_20672[(1)] = (1));

return statearr_20672;
});
var cljs$core$async$reduce_$_state_machine__20124__auto____1 = (function (state_20656){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20656);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20673){var ex__20127__auto__ = e20673;
var statearr_20674_22315 = state_20656;
(statearr_20674_22315[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20656[(4)]))){
var statearr_20675_22316 = state_20656;
(statearr_20675_22316[(1)] = cljs.core.first((state_20656[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22318 = state_20656;
state_20656 = G__22318;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20124__auto__ = function(state_20656){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20124__auto____1.call(this,state_20656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20124__auto____0;
cljs$core$async$reduce_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20124__auto____1;
return cljs$core$async$reduce_$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20676 = f__20272__auto__();
(statearr_20676[(6)] = c__20271__auto__);

return statearr_20676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

return c__20271__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__20271__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20682){
var state_val_20683 = (state_20682[(1)]);
if((state_val_20683 === (1))){
var inst_20677 = cljs.core.async.reduce(f__$1,init,ch);
var state_20682__$1 = state_20682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20682__$1,(2),inst_20677);
} else {
if((state_val_20683 === (2))){
var inst_20679 = (state_20682[(2)]);
var inst_20680 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_20679) : f__$1.call(null,inst_20679));
var state_20682__$1 = state_20682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20682__$1,inst_20680);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__20124__auto__ = null;
var cljs$core$async$transduce_$_state_machine__20124__auto____0 = (function (){
var statearr_20684 = [null,null,null,null,null,null,null];
(statearr_20684[(0)] = cljs$core$async$transduce_$_state_machine__20124__auto__);

(statearr_20684[(1)] = (1));

return statearr_20684;
});
var cljs$core$async$transduce_$_state_machine__20124__auto____1 = (function (state_20682){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20682);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20685){var ex__20127__auto__ = e20685;
var statearr_20686_22328 = state_20682;
(statearr_20686_22328[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20682[(4)]))){
var statearr_20687_22330 = state_20682;
(statearr_20687_22330[(1)] = cljs.core.first((state_20682[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22331 = state_20682;
state_20682 = G__22331;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__20124__auto__ = function(state_20682){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__20124__auto____1.call(this,state_20682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__20124__auto____0;
cljs$core$async$transduce_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__20124__auto____1;
return cljs$core$async$transduce_$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20688 = f__20272__auto__();
(statearr_20688[(6)] = c__20271__auto__);

return statearr_20688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

return c__20271__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__20690 = arguments.length;
switch (G__20690) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20271__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20715){
var state_val_20716 = (state_20715[(1)]);
if((state_val_20716 === (7))){
var inst_20697 = (state_20715[(2)]);
var state_20715__$1 = state_20715;
var statearr_20717_22335 = state_20715__$1;
(statearr_20717_22335[(2)] = inst_20697);

(statearr_20717_22335[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (1))){
var inst_20691 = cljs.core.seq(coll);
var inst_20692 = inst_20691;
var state_20715__$1 = (function (){var statearr_20718 = state_20715;
(statearr_20718[(7)] = inst_20692);

return statearr_20718;
})();
var statearr_20719_22337 = state_20715__$1;
(statearr_20719_22337[(2)] = null);

(statearr_20719_22337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (4))){
var inst_20692 = (state_20715[(7)]);
var inst_20695 = cljs.core.first(inst_20692);
var state_20715__$1 = state_20715;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20715__$1,(7),ch,inst_20695);
} else {
if((state_val_20716 === (13))){
var inst_20709 = (state_20715[(2)]);
var state_20715__$1 = state_20715;
var statearr_20720_22341 = state_20715__$1;
(statearr_20720_22341[(2)] = inst_20709);

(statearr_20720_22341[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (6))){
var inst_20700 = (state_20715[(2)]);
var state_20715__$1 = state_20715;
if(cljs.core.truth_(inst_20700)){
var statearr_20721_22344 = state_20715__$1;
(statearr_20721_22344[(1)] = (8));

} else {
var statearr_20722_22345 = state_20715__$1;
(statearr_20722_22345[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (3))){
var inst_20713 = (state_20715[(2)]);
var state_20715__$1 = state_20715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20715__$1,inst_20713);
} else {
if((state_val_20716 === (12))){
var state_20715__$1 = state_20715;
var statearr_20723_22350 = state_20715__$1;
(statearr_20723_22350[(2)] = null);

(statearr_20723_22350[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (2))){
var inst_20692 = (state_20715[(7)]);
var state_20715__$1 = state_20715;
if(cljs.core.truth_(inst_20692)){
var statearr_20724_22351 = state_20715__$1;
(statearr_20724_22351[(1)] = (4));

} else {
var statearr_20725_22352 = state_20715__$1;
(statearr_20725_22352[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (11))){
var inst_20706 = cljs.core.async.close_BANG_(ch);
var state_20715__$1 = state_20715;
var statearr_20726_22355 = state_20715__$1;
(statearr_20726_22355[(2)] = inst_20706);

(statearr_20726_22355[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (9))){
var state_20715__$1 = state_20715;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20727_22356 = state_20715__$1;
(statearr_20727_22356[(1)] = (11));

} else {
var statearr_20728_22357 = state_20715__$1;
(statearr_20728_22357[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (5))){
var inst_20692 = (state_20715[(7)]);
var state_20715__$1 = state_20715;
var statearr_20729_22362 = state_20715__$1;
(statearr_20729_22362[(2)] = inst_20692);

(statearr_20729_22362[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (10))){
var inst_20711 = (state_20715[(2)]);
var state_20715__$1 = state_20715;
var statearr_20730_22363 = state_20715__$1;
(statearr_20730_22363[(2)] = inst_20711);

(statearr_20730_22363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20716 === (8))){
var inst_20692 = (state_20715[(7)]);
var inst_20702 = cljs.core.next(inst_20692);
var inst_20692__$1 = inst_20702;
var state_20715__$1 = (function (){var statearr_20731 = state_20715;
(statearr_20731[(7)] = inst_20692__$1);

return statearr_20731;
})();
var statearr_20732_22364 = state_20715__$1;
(statearr_20732_22364[(2)] = null);

(statearr_20732_22364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_20733 = [null,null,null,null,null,null,null,null];
(statearr_20733[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_20733[(1)] = (1));

return statearr_20733;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_20715){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20715);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20734){var ex__20127__auto__ = e20734;
var statearr_20735_22367 = state_20715;
(statearr_20735_22367[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20715[(4)]))){
var statearr_20736_22368 = state_20715;
(statearr_20736_22368[(1)] = cljs.core.first((state_20715[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22370 = state_20715;
state_20715 = G__22370;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_20715){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_20715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20737 = f__20272__auto__();
(statearr_20737[(6)] = c__20271__auto__);

return statearr_20737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

return c__20271__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__20739 = arguments.length;
switch (G__20739) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_22377 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_22377(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_22382 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_22382(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_22385 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_22385(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_22390 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_22390(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20740 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20740 = (function (ch,cs,meta20741){
this.ch = ch;
this.cs = cs;
this.meta20741 = meta20741;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20742,meta20741__$1){
var self__ = this;
var _20742__$1 = this;
return (new cljs.core.async.t_cljs$core$async20740(self__.ch,self__.cs,meta20741__$1));
}));

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20742){
var self__ = this;
var _20742__$1 = this;
return self__.meta20741;
}));

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async20740.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async20740.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20741","meta20741",-1986343465,null)], null);
}));

(cljs.core.async.t_cljs$core$async20740.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20740.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20740");

(cljs.core.async.t_cljs$core$async20740.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async20740");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20740.
 */
cljs.core.async.__GT_t_cljs$core$async20740 = (function cljs$core$async$mult_$___GT_t_cljs$core$async20740(ch__$1,cs__$1,meta20741){
return (new cljs.core.async.t_cljs$core$async20740(ch__$1,cs__$1,meta20741));
});

}

return (new cljs.core.async.t_cljs$core$async20740(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__20271__auto___22403 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_20875){
var state_val_20876 = (state_20875[(1)]);
if((state_val_20876 === (7))){
var inst_20871 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20877_22406 = state_20875__$1;
(statearr_20877_22406[(2)] = inst_20871);

(statearr_20877_22406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (20))){
var inst_20776 = (state_20875[(7)]);
var inst_20788 = cljs.core.first(inst_20776);
var inst_20789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20788,(0),null);
var inst_20790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20788,(1),null);
var state_20875__$1 = (function (){var statearr_20878 = state_20875;
(statearr_20878[(8)] = inst_20789);

return statearr_20878;
})();
if(cljs.core.truth_(inst_20790)){
var statearr_20879_22408 = state_20875__$1;
(statearr_20879_22408[(1)] = (22));

} else {
var statearr_20880_22412 = state_20875__$1;
(statearr_20880_22412[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (27))){
var inst_20818 = (state_20875[(9)]);
var inst_20825 = (state_20875[(10)]);
var inst_20745 = (state_20875[(11)]);
var inst_20820 = (state_20875[(12)]);
var inst_20825__$1 = cljs.core._nth(inst_20818,inst_20820);
var inst_20826 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_20825__$1,inst_20745,done);
var state_20875__$1 = (function (){var statearr_20881 = state_20875;
(statearr_20881[(10)] = inst_20825__$1);

return statearr_20881;
})();
if(cljs.core.truth_(inst_20826)){
var statearr_20882_22413 = state_20875__$1;
(statearr_20882_22413[(1)] = (30));

} else {
var statearr_20883_22414 = state_20875__$1;
(statearr_20883_22414[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (1))){
var state_20875__$1 = state_20875;
var statearr_20884_22415 = state_20875__$1;
(statearr_20884_22415[(2)] = null);

(statearr_20884_22415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (24))){
var inst_20776 = (state_20875[(7)]);
var inst_20795 = (state_20875[(2)]);
var inst_20796 = cljs.core.next(inst_20776);
var inst_20754 = inst_20796;
var inst_20755 = null;
var inst_20756 = (0);
var inst_20757 = (0);
var state_20875__$1 = (function (){var statearr_20885 = state_20875;
(statearr_20885[(13)] = inst_20756);

(statearr_20885[(14)] = inst_20754);

(statearr_20885[(15)] = inst_20757);

(statearr_20885[(16)] = inst_20795);

(statearr_20885[(17)] = inst_20755);

return statearr_20885;
})();
var statearr_20886_22416 = state_20875__$1;
(statearr_20886_22416[(2)] = null);

(statearr_20886_22416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (39))){
var state_20875__$1 = state_20875;
var statearr_20890_22417 = state_20875__$1;
(statearr_20890_22417[(2)] = null);

(statearr_20890_22417[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (4))){
var inst_20745 = (state_20875[(11)]);
var inst_20745__$1 = (state_20875[(2)]);
var inst_20746 = (inst_20745__$1 == null);
var state_20875__$1 = (function (){var statearr_20891 = state_20875;
(statearr_20891[(11)] = inst_20745__$1);

return statearr_20891;
})();
if(cljs.core.truth_(inst_20746)){
var statearr_20892_22418 = state_20875__$1;
(statearr_20892_22418[(1)] = (5));

} else {
var statearr_20893_22419 = state_20875__$1;
(statearr_20893_22419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (15))){
var inst_20756 = (state_20875[(13)]);
var inst_20754 = (state_20875[(14)]);
var inst_20757 = (state_20875[(15)]);
var inst_20755 = (state_20875[(17)]);
var inst_20772 = (state_20875[(2)]);
var inst_20773 = (inst_20757 + (1));
var tmp20887 = inst_20756;
var tmp20888 = inst_20754;
var tmp20889 = inst_20755;
var inst_20754__$1 = tmp20888;
var inst_20755__$1 = tmp20889;
var inst_20756__$1 = tmp20887;
var inst_20757__$1 = inst_20773;
var state_20875__$1 = (function (){var statearr_20894 = state_20875;
(statearr_20894[(18)] = inst_20772);

(statearr_20894[(13)] = inst_20756__$1);

(statearr_20894[(14)] = inst_20754__$1);

(statearr_20894[(15)] = inst_20757__$1);

(statearr_20894[(17)] = inst_20755__$1);

return statearr_20894;
})();
var statearr_20895_22420 = state_20875__$1;
(statearr_20895_22420[(2)] = null);

(statearr_20895_22420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (21))){
var inst_20799 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20899_22421 = state_20875__$1;
(statearr_20899_22421[(2)] = inst_20799);

(statearr_20899_22421[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (31))){
var inst_20825 = (state_20875[(10)]);
var inst_20829 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_20825);
var state_20875__$1 = state_20875;
var statearr_20900_22422 = state_20875__$1;
(statearr_20900_22422[(2)] = inst_20829);

(statearr_20900_22422[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (32))){
var inst_20818 = (state_20875[(9)]);
var inst_20817 = (state_20875[(19)]);
var inst_20819 = (state_20875[(20)]);
var inst_20820 = (state_20875[(12)]);
var inst_20831 = (state_20875[(2)]);
var inst_20832 = (inst_20820 + (1));
var tmp20896 = inst_20818;
var tmp20897 = inst_20817;
var tmp20898 = inst_20819;
var inst_20817__$1 = tmp20897;
var inst_20818__$1 = tmp20896;
var inst_20819__$1 = tmp20898;
var inst_20820__$1 = inst_20832;
var state_20875__$1 = (function (){var statearr_20901 = state_20875;
(statearr_20901[(9)] = inst_20818__$1);

(statearr_20901[(19)] = inst_20817__$1);

(statearr_20901[(20)] = inst_20819__$1);

(statearr_20901[(21)] = inst_20831);

(statearr_20901[(12)] = inst_20820__$1);

return statearr_20901;
})();
var statearr_20902_22423 = state_20875__$1;
(statearr_20902_22423[(2)] = null);

(statearr_20902_22423[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (40))){
var inst_20844 = (state_20875[(22)]);
var inst_20848 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_20844);
var state_20875__$1 = state_20875;
var statearr_20903_22424 = state_20875__$1;
(statearr_20903_22424[(2)] = inst_20848);

(statearr_20903_22424[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (33))){
var inst_20835 = (state_20875[(23)]);
var inst_20837 = cljs.core.chunked_seq_QMARK_(inst_20835);
var state_20875__$1 = state_20875;
if(inst_20837){
var statearr_20904_22428 = state_20875__$1;
(statearr_20904_22428[(1)] = (36));

} else {
var statearr_20905_22429 = state_20875__$1;
(statearr_20905_22429[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (13))){
var inst_20766 = (state_20875[(24)]);
var inst_20769 = cljs.core.async.close_BANG_(inst_20766);
var state_20875__$1 = state_20875;
var statearr_20906_22430 = state_20875__$1;
(statearr_20906_22430[(2)] = inst_20769);

(statearr_20906_22430[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (22))){
var inst_20789 = (state_20875[(8)]);
var inst_20792 = cljs.core.async.close_BANG_(inst_20789);
var state_20875__$1 = state_20875;
var statearr_20907_22431 = state_20875__$1;
(statearr_20907_22431[(2)] = inst_20792);

(statearr_20907_22431[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (36))){
var inst_20835 = (state_20875[(23)]);
var inst_20839 = cljs.core.chunk_first(inst_20835);
var inst_20840 = cljs.core.chunk_rest(inst_20835);
var inst_20841 = cljs.core.count(inst_20839);
var inst_20817 = inst_20840;
var inst_20818 = inst_20839;
var inst_20819 = inst_20841;
var inst_20820 = (0);
var state_20875__$1 = (function (){var statearr_20908 = state_20875;
(statearr_20908[(9)] = inst_20818);

(statearr_20908[(19)] = inst_20817);

(statearr_20908[(20)] = inst_20819);

(statearr_20908[(12)] = inst_20820);

return statearr_20908;
})();
var statearr_20909_22435 = state_20875__$1;
(statearr_20909_22435[(2)] = null);

(statearr_20909_22435[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (41))){
var inst_20835 = (state_20875[(23)]);
var inst_20850 = (state_20875[(2)]);
var inst_20851 = cljs.core.next(inst_20835);
var inst_20817 = inst_20851;
var inst_20818 = null;
var inst_20819 = (0);
var inst_20820 = (0);
var state_20875__$1 = (function (){var statearr_20910 = state_20875;
(statearr_20910[(9)] = inst_20818);

(statearr_20910[(19)] = inst_20817);

(statearr_20910[(20)] = inst_20819);

(statearr_20910[(12)] = inst_20820);

(statearr_20910[(25)] = inst_20850);

return statearr_20910;
})();
var statearr_20911_22452 = state_20875__$1;
(statearr_20911_22452[(2)] = null);

(statearr_20911_22452[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (43))){
var state_20875__$1 = state_20875;
var statearr_20912_22464 = state_20875__$1;
(statearr_20912_22464[(2)] = null);

(statearr_20912_22464[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (29))){
var inst_20859 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20913_22476 = state_20875__$1;
(statearr_20913_22476[(2)] = inst_20859);

(statearr_20913_22476[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (44))){
var inst_20868 = (state_20875[(2)]);
var state_20875__$1 = (function (){var statearr_20914 = state_20875;
(statearr_20914[(26)] = inst_20868);

return statearr_20914;
})();
var statearr_20915_22489 = state_20875__$1;
(statearr_20915_22489[(2)] = null);

(statearr_20915_22489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (6))){
var inst_20809 = (state_20875[(27)]);
var inst_20808 = cljs.core.deref(cs);
var inst_20809__$1 = cljs.core.keys(inst_20808);
var inst_20810 = cljs.core.count(inst_20809__$1);
var inst_20811 = cljs.core.reset_BANG_(dctr,inst_20810);
var inst_20816 = cljs.core.seq(inst_20809__$1);
var inst_20817 = inst_20816;
var inst_20818 = null;
var inst_20819 = (0);
var inst_20820 = (0);
var state_20875__$1 = (function (){var statearr_20916 = state_20875;
(statearr_20916[(9)] = inst_20818);

(statearr_20916[(19)] = inst_20817);

(statearr_20916[(20)] = inst_20819);

(statearr_20916[(28)] = inst_20811);

(statearr_20916[(12)] = inst_20820);

(statearr_20916[(27)] = inst_20809__$1);

return statearr_20916;
})();
var statearr_20917_22521 = state_20875__$1;
(statearr_20917_22521[(2)] = null);

(statearr_20917_22521[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (28))){
var inst_20817 = (state_20875[(19)]);
var inst_20835 = (state_20875[(23)]);
var inst_20835__$1 = cljs.core.seq(inst_20817);
var state_20875__$1 = (function (){var statearr_20918 = state_20875;
(statearr_20918[(23)] = inst_20835__$1);

return statearr_20918;
})();
if(inst_20835__$1){
var statearr_20919_22522 = state_20875__$1;
(statearr_20919_22522[(1)] = (33));

} else {
var statearr_20920_22523 = state_20875__$1;
(statearr_20920_22523[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (25))){
var inst_20819 = (state_20875[(20)]);
var inst_20820 = (state_20875[(12)]);
var inst_20822 = (inst_20820 < inst_20819);
var inst_20823 = inst_20822;
var state_20875__$1 = state_20875;
if(cljs.core.truth_(inst_20823)){
var statearr_20921_22525 = state_20875__$1;
(statearr_20921_22525[(1)] = (27));

} else {
var statearr_20922_22527 = state_20875__$1;
(statearr_20922_22527[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (34))){
var state_20875__$1 = state_20875;
var statearr_20923_22529 = state_20875__$1;
(statearr_20923_22529[(2)] = null);

(statearr_20923_22529[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (17))){
var state_20875__$1 = state_20875;
var statearr_20924_22530 = state_20875__$1;
(statearr_20924_22530[(2)] = null);

(statearr_20924_22530[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (3))){
var inst_20873 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20875__$1,inst_20873);
} else {
if((state_val_20876 === (12))){
var inst_20804 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20925_22533 = state_20875__$1;
(statearr_20925_22533[(2)] = inst_20804);

(statearr_20925_22533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (2))){
var state_20875__$1 = state_20875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20875__$1,(4),ch);
} else {
if((state_val_20876 === (23))){
var state_20875__$1 = state_20875;
var statearr_20926_22535 = state_20875__$1;
(statearr_20926_22535[(2)] = null);

(statearr_20926_22535[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (35))){
var inst_20857 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20927_22537 = state_20875__$1;
(statearr_20927_22537[(2)] = inst_20857);

(statearr_20927_22537[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (19))){
var inst_20776 = (state_20875[(7)]);
var inst_20780 = cljs.core.chunk_first(inst_20776);
var inst_20781 = cljs.core.chunk_rest(inst_20776);
var inst_20782 = cljs.core.count(inst_20780);
var inst_20754 = inst_20781;
var inst_20755 = inst_20780;
var inst_20756 = inst_20782;
var inst_20757 = (0);
var state_20875__$1 = (function (){var statearr_20928 = state_20875;
(statearr_20928[(13)] = inst_20756);

(statearr_20928[(14)] = inst_20754);

(statearr_20928[(15)] = inst_20757);

(statearr_20928[(17)] = inst_20755);

return statearr_20928;
})();
var statearr_20929_22539 = state_20875__$1;
(statearr_20929_22539[(2)] = null);

(statearr_20929_22539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (11))){
var inst_20776 = (state_20875[(7)]);
var inst_20754 = (state_20875[(14)]);
var inst_20776__$1 = cljs.core.seq(inst_20754);
var state_20875__$1 = (function (){var statearr_20930 = state_20875;
(statearr_20930[(7)] = inst_20776__$1);

return statearr_20930;
})();
if(inst_20776__$1){
var statearr_20931_22540 = state_20875__$1;
(statearr_20931_22540[(1)] = (16));

} else {
var statearr_20932_22541 = state_20875__$1;
(statearr_20932_22541[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (9))){
var inst_20806 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20933_22542 = state_20875__$1;
(statearr_20933_22542[(2)] = inst_20806);

(statearr_20933_22542[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (5))){
var inst_20752 = cljs.core.deref(cs);
var inst_20753 = cljs.core.seq(inst_20752);
var inst_20754 = inst_20753;
var inst_20755 = null;
var inst_20756 = (0);
var inst_20757 = (0);
var state_20875__$1 = (function (){var statearr_20934 = state_20875;
(statearr_20934[(13)] = inst_20756);

(statearr_20934[(14)] = inst_20754);

(statearr_20934[(15)] = inst_20757);

(statearr_20934[(17)] = inst_20755);

return statearr_20934;
})();
var statearr_20935_22544 = state_20875__$1;
(statearr_20935_22544[(2)] = null);

(statearr_20935_22544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (14))){
var state_20875__$1 = state_20875;
var statearr_20936_22546 = state_20875__$1;
(statearr_20936_22546[(2)] = null);

(statearr_20936_22546[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (45))){
var inst_20865 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20937_22551 = state_20875__$1;
(statearr_20937_22551[(2)] = inst_20865);

(statearr_20937_22551[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (26))){
var inst_20809 = (state_20875[(27)]);
var inst_20861 = (state_20875[(2)]);
var inst_20862 = cljs.core.seq(inst_20809);
var state_20875__$1 = (function (){var statearr_20938 = state_20875;
(statearr_20938[(29)] = inst_20861);

return statearr_20938;
})();
if(inst_20862){
var statearr_20939_22556 = state_20875__$1;
(statearr_20939_22556[(1)] = (42));

} else {
var statearr_20940_22557 = state_20875__$1;
(statearr_20940_22557[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (16))){
var inst_20776 = (state_20875[(7)]);
var inst_20778 = cljs.core.chunked_seq_QMARK_(inst_20776);
var state_20875__$1 = state_20875;
if(inst_20778){
var statearr_20941_22565 = state_20875__$1;
(statearr_20941_22565[(1)] = (19));

} else {
var statearr_20942_22567 = state_20875__$1;
(statearr_20942_22567[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (38))){
var inst_20854 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20943_22576 = state_20875__$1;
(statearr_20943_22576[(2)] = inst_20854);

(statearr_20943_22576[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (30))){
var state_20875__$1 = state_20875;
var statearr_20944_22578 = state_20875__$1;
(statearr_20944_22578[(2)] = null);

(statearr_20944_22578[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (10))){
var inst_20757 = (state_20875[(15)]);
var inst_20755 = (state_20875[(17)]);
var inst_20765 = cljs.core._nth(inst_20755,inst_20757);
var inst_20766 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20765,(0),null);
var inst_20767 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20765,(1),null);
var state_20875__$1 = (function (){var statearr_20945 = state_20875;
(statearr_20945[(24)] = inst_20766);

return statearr_20945;
})();
if(cljs.core.truth_(inst_20767)){
var statearr_20946_22585 = state_20875__$1;
(statearr_20946_22585[(1)] = (13));

} else {
var statearr_20947_22586 = state_20875__$1;
(statearr_20947_22586[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (18))){
var inst_20802 = (state_20875[(2)]);
var state_20875__$1 = state_20875;
var statearr_20948_22589 = state_20875__$1;
(statearr_20948_22589[(2)] = inst_20802);

(statearr_20948_22589[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (42))){
var state_20875__$1 = state_20875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20875__$1,(45),dchan);
} else {
if((state_val_20876 === (37))){
var inst_20844 = (state_20875[(22)]);
var inst_20745 = (state_20875[(11)]);
var inst_20835 = (state_20875[(23)]);
var inst_20844__$1 = cljs.core.first(inst_20835);
var inst_20845 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_20844__$1,inst_20745,done);
var state_20875__$1 = (function (){var statearr_20949 = state_20875;
(statearr_20949[(22)] = inst_20844__$1);

return statearr_20949;
})();
if(cljs.core.truth_(inst_20845)){
var statearr_20950_22593 = state_20875__$1;
(statearr_20950_22593[(1)] = (39));

} else {
var statearr_20951_22594 = state_20875__$1;
(statearr_20951_22594[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20876 === (8))){
var inst_20756 = (state_20875[(13)]);
var inst_20757 = (state_20875[(15)]);
var inst_20759 = (inst_20757 < inst_20756);
var inst_20760 = inst_20759;
var state_20875__$1 = state_20875;
if(cljs.core.truth_(inst_20760)){
var statearr_20952_22596 = state_20875__$1;
(statearr_20952_22596[(1)] = (10));

} else {
var statearr_20953_22598 = state_20875__$1;
(statearr_20953_22598[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__20124__auto__ = null;
var cljs$core$async$mult_$_state_machine__20124__auto____0 = (function (){
var statearr_20954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20954[(0)] = cljs$core$async$mult_$_state_machine__20124__auto__);

(statearr_20954[(1)] = (1));

return statearr_20954;
});
var cljs$core$async$mult_$_state_machine__20124__auto____1 = (function (state_20875){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_20875);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e20955){var ex__20127__auto__ = e20955;
var statearr_20956_22606 = state_20875;
(statearr_20956_22606[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_20875[(4)]))){
var statearr_20957_22607 = state_20875;
(statearr_20957_22607[(1)] = cljs.core.first((state_20875[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22609 = state_20875;
state_20875 = G__22609;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20124__auto__ = function(state_20875){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20124__auto____1.call(this,state_20875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20124__auto____0;
cljs$core$async$mult_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20124__auto____1;
return cljs$core$async$mult_$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_20958 = f__20272__auto__();
(statearr_20958[(6)] = c__20271__auto___22403);

return statearr_20958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__20960 = arguments.length;
switch (G__20960) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_22616 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_22616(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_22618 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_22618(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_22620 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_22620(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_22628 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_22628(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_22630 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_22630(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___22639 = arguments.length;
var i__4737__auto___22640 = (0);
while(true){
if((i__4737__auto___22640 < len__4736__auto___22639)){
args__4742__auto__.push((arguments[i__4737__auto___22640]));

var G__22641 = (i__4737__auto___22640 + (1));
i__4737__auto___22640 = G__22641;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20965){
var map__20966 = p__20965;
var map__20966__$1 = (((((!((map__20966 == null))))?(((((map__20966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20966.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20966):map__20966);
var opts = map__20966__$1;
var statearr_20968_22645 = state;
(statearr_20968_22645[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_20969_22646 = state;
(statearr_20969_22646[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_20970_22647 = state;
(statearr_20970_22647[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20961){
var G__20962 = cljs.core.first(seq20961);
var seq20961__$1 = cljs.core.next(seq20961);
var G__20963 = cljs.core.first(seq20961__$1);
var seq20961__$2 = cljs.core.next(seq20961__$1);
var G__20964 = cljs.core.first(seq20961__$2);
var seq20961__$3 = cljs.core.next(seq20961__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20962,G__20963,G__20964,seq20961__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20971 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20971 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20972){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20972 = meta20972;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20973,meta20972__$1){
var self__ = this;
var _20973__$1 = this;
return (new cljs.core.async.t_cljs$core$async20971(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20972__$1));
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20973){
var self__ = this;
var _20973__$1 = this;
return self__.meta20972;
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20971.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async20971.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20972","meta20972",-441791204,null)], null);
}));

(cljs.core.async.t_cljs$core$async20971.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20971.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20971");

(cljs.core.async.t_cljs$core$async20971.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async20971");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20971.
 */
cljs.core.async.__GT_t_cljs$core$async20971 = (function cljs$core$async$mix_$___GT_t_cljs$core$async20971(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20972){
return (new cljs.core.async.t_cljs$core$async20971(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20972));
});

}

return (new cljs.core.async.t_cljs$core$async20971(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20271__auto___22744 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21075){
var state_val_21076 = (state_21075[(1)]);
if((state_val_21076 === (7))){
var inst_20990 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21077_22747 = state_21075__$1;
(statearr_21077_22747[(2)] = inst_20990);

(statearr_21077_22747[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (20))){
var inst_21002 = (state_21075[(7)]);
var state_21075__$1 = state_21075;
var statearr_21078_22750 = state_21075__$1;
(statearr_21078_22750[(2)] = inst_21002);

(statearr_21078_22750[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (27))){
var state_21075__$1 = state_21075;
var statearr_21079_22751 = state_21075__$1;
(statearr_21079_22751[(2)] = null);

(statearr_21079_22751[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (1))){
var inst_20977 = (state_21075[(8)]);
var inst_20977__$1 = calc_state();
var inst_20979 = (inst_20977__$1 == null);
var inst_20980 = cljs.core.not(inst_20979);
var state_21075__$1 = (function (){var statearr_21080 = state_21075;
(statearr_21080[(8)] = inst_20977__$1);

return statearr_21080;
})();
if(inst_20980){
var statearr_21081_22756 = state_21075__$1;
(statearr_21081_22756[(1)] = (2));

} else {
var statearr_21082_22757 = state_21075__$1;
(statearr_21082_22757[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (24))){
var inst_21035 = (state_21075[(9)]);
var inst_21026 = (state_21075[(10)]);
var inst_21049 = (state_21075[(11)]);
var inst_21049__$1 = (inst_21026.cljs$core$IFn$_invoke$arity$1 ? inst_21026.cljs$core$IFn$_invoke$arity$1(inst_21035) : inst_21026.call(null,inst_21035));
var state_21075__$1 = (function (){var statearr_21083 = state_21075;
(statearr_21083[(11)] = inst_21049__$1);

return statearr_21083;
})();
if(cljs.core.truth_(inst_21049__$1)){
var statearr_21084_22761 = state_21075__$1;
(statearr_21084_22761[(1)] = (29));

} else {
var statearr_21085_22762 = state_21075__$1;
(statearr_21085_22762[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (4))){
var inst_20993 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_20993)){
var statearr_21086_22764 = state_21075__$1;
(statearr_21086_22764[(1)] = (8));

} else {
var statearr_21087_22765 = state_21075__$1;
(statearr_21087_22765[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (15))){
var inst_21020 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_21020)){
var statearr_21088_22767 = state_21075__$1;
(statearr_21088_22767[(1)] = (19));

} else {
var statearr_21089_22768 = state_21075__$1;
(statearr_21089_22768[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (21))){
var inst_21025 = (state_21075[(12)]);
var inst_21025__$1 = (state_21075[(2)]);
var inst_21026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21025__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21027 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21025__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21028 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21025__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_21075__$1 = (function (){var statearr_21090 = state_21075;
(statearr_21090[(10)] = inst_21026);

(statearr_21090[(12)] = inst_21025__$1);

(statearr_21090[(13)] = inst_21027);

return statearr_21090;
})();
return cljs.core.async.ioc_alts_BANG_(state_21075__$1,(22),inst_21028);
} else {
if((state_val_21076 === (31))){
var inst_21057 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_21057)){
var statearr_21091_22772 = state_21075__$1;
(statearr_21091_22772[(1)] = (32));

} else {
var statearr_21092_22774 = state_21075__$1;
(statearr_21092_22774[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (32))){
var inst_21034 = (state_21075[(14)]);
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21075__$1,(35),out,inst_21034);
} else {
if((state_val_21076 === (33))){
var inst_21025 = (state_21075[(12)]);
var inst_21002 = inst_21025;
var state_21075__$1 = (function (){var statearr_21093 = state_21075;
(statearr_21093[(7)] = inst_21002);

return statearr_21093;
})();
var statearr_21094_22778 = state_21075__$1;
(statearr_21094_22778[(2)] = null);

(statearr_21094_22778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (13))){
var inst_21002 = (state_21075[(7)]);
var inst_21009 = inst_21002.cljs$lang$protocol_mask$partition0$;
var inst_21010 = (inst_21009 & (64));
var inst_21011 = inst_21002.cljs$core$ISeq$;
var inst_21012 = (cljs.core.PROTOCOL_SENTINEL === inst_21011);
var inst_21013 = ((inst_21010) || (inst_21012));
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_21013)){
var statearr_21095_22781 = state_21075__$1;
(statearr_21095_22781[(1)] = (16));

} else {
var statearr_21096_22783 = state_21075__$1;
(statearr_21096_22783[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (22))){
var inst_21035 = (state_21075[(9)]);
var inst_21034 = (state_21075[(14)]);
var inst_21033 = (state_21075[(2)]);
var inst_21034__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21033,(0),null);
var inst_21035__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21033,(1),null);
var inst_21036 = (inst_21034__$1 == null);
var inst_21037 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21035__$1,change);
var inst_21038 = ((inst_21036) || (inst_21037));
var state_21075__$1 = (function (){var statearr_21097 = state_21075;
(statearr_21097[(9)] = inst_21035__$1);

(statearr_21097[(14)] = inst_21034__$1);

return statearr_21097;
})();
if(cljs.core.truth_(inst_21038)){
var statearr_21098_22786 = state_21075__$1;
(statearr_21098_22786[(1)] = (23));

} else {
var statearr_21099_22787 = state_21075__$1;
(statearr_21099_22787[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (36))){
var inst_21025 = (state_21075[(12)]);
var inst_21002 = inst_21025;
var state_21075__$1 = (function (){var statearr_21100 = state_21075;
(statearr_21100[(7)] = inst_21002);

return statearr_21100;
})();
var statearr_21101_22789 = state_21075__$1;
(statearr_21101_22789[(2)] = null);

(statearr_21101_22789[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (29))){
var inst_21049 = (state_21075[(11)]);
var state_21075__$1 = state_21075;
var statearr_21102_22792 = state_21075__$1;
(statearr_21102_22792[(2)] = inst_21049);

(statearr_21102_22792[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (6))){
var state_21075__$1 = state_21075;
var statearr_21103_22794 = state_21075__$1;
(statearr_21103_22794[(2)] = false);

(statearr_21103_22794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (28))){
var inst_21045 = (state_21075[(2)]);
var inst_21046 = calc_state();
var inst_21002 = inst_21046;
var state_21075__$1 = (function (){var statearr_21104 = state_21075;
(statearr_21104[(7)] = inst_21002);

(statearr_21104[(15)] = inst_21045);

return statearr_21104;
})();
var statearr_21105_22796 = state_21075__$1;
(statearr_21105_22796[(2)] = null);

(statearr_21105_22796[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (25))){
var inst_21071 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21106_22802 = state_21075__$1;
(statearr_21106_22802[(2)] = inst_21071);

(statearr_21106_22802[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (34))){
var inst_21069 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21107_22814 = state_21075__$1;
(statearr_21107_22814[(2)] = inst_21069);

(statearr_21107_22814[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (17))){
var state_21075__$1 = state_21075;
var statearr_21108_22815 = state_21075__$1;
(statearr_21108_22815[(2)] = false);

(statearr_21108_22815[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (3))){
var state_21075__$1 = state_21075;
var statearr_21109_22816 = state_21075__$1;
(statearr_21109_22816[(2)] = false);

(statearr_21109_22816[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (12))){
var inst_21073 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21075__$1,inst_21073);
} else {
if((state_val_21076 === (2))){
var inst_20977 = (state_21075[(8)]);
var inst_20982 = inst_20977.cljs$lang$protocol_mask$partition0$;
var inst_20983 = (inst_20982 & (64));
var inst_20984 = inst_20977.cljs$core$ISeq$;
var inst_20985 = (cljs.core.PROTOCOL_SENTINEL === inst_20984);
var inst_20986 = ((inst_20983) || (inst_20985));
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_20986)){
var statearr_21110_22818 = state_21075__$1;
(statearr_21110_22818[(1)] = (5));

} else {
var statearr_21111_22819 = state_21075__$1;
(statearr_21111_22819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (23))){
var inst_21034 = (state_21075[(14)]);
var inst_21040 = (inst_21034 == null);
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_21040)){
var statearr_21112_22822 = state_21075__$1;
(statearr_21112_22822[(1)] = (26));

} else {
var statearr_21113_22823 = state_21075__$1;
(statearr_21113_22823[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (35))){
var inst_21060 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
if(cljs.core.truth_(inst_21060)){
var statearr_21114_22825 = state_21075__$1;
(statearr_21114_22825[(1)] = (36));

} else {
var statearr_21115_22827 = state_21075__$1;
(statearr_21115_22827[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (19))){
var inst_21002 = (state_21075[(7)]);
var inst_21022 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_21002);
var state_21075__$1 = state_21075;
var statearr_21116_22828 = state_21075__$1;
(statearr_21116_22828[(2)] = inst_21022);

(statearr_21116_22828[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (11))){
var inst_21002 = (state_21075[(7)]);
var inst_21006 = (inst_21002 == null);
var inst_21007 = cljs.core.not(inst_21006);
var state_21075__$1 = state_21075;
if(inst_21007){
var statearr_21117_22830 = state_21075__$1;
(statearr_21117_22830[(1)] = (13));

} else {
var statearr_21118_22831 = state_21075__$1;
(statearr_21118_22831[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (9))){
var inst_20977 = (state_21075[(8)]);
var state_21075__$1 = state_21075;
var statearr_21119_22834 = state_21075__$1;
(statearr_21119_22834[(2)] = inst_20977);

(statearr_21119_22834[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (5))){
var state_21075__$1 = state_21075;
var statearr_21120_22836 = state_21075__$1;
(statearr_21120_22836[(2)] = true);

(statearr_21120_22836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (14))){
var state_21075__$1 = state_21075;
var statearr_21121_22837 = state_21075__$1;
(statearr_21121_22837[(2)] = false);

(statearr_21121_22837[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (26))){
var inst_21035 = (state_21075[(9)]);
var inst_21042 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_21035);
var state_21075__$1 = state_21075;
var statearr_21122_22839 = state_21075__$1;
(statearr_21122_22839[(2)] = inst_21042);

(statearr_21122_22839[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (16))){
var state_21075__$1 = state_21075;
var statearr_21123_22840 = state_21075__$1;
(statearr_21123_22840[(2)] = true);

(statearr_21123_22840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (38))){
var inst_21065 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21124_22857 = state_21075__$1;
(statearr_21124_22857[(2)] = inst_21065);

(statearr_21124_22857[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (30))){
var inst_21035 = (state_21075[(9)]);
var inst_21026 = (state_21075[(10)]);
var inst_21027 = (state_21075[(13)]);
var inst_21052 = cljs.core.empty_QMARK_(inst_21026);
var inst_21053 = (inst_21027.cljs$core$IFn$_invoke$arity$1 ? inst_21027.cljs$core$IFn$_invoke$arity$1(inst_21035) : inst_21027.call(null,inst_21035));
var inst_21054 = cljs.core.not(inst_21053);
var inst_21055 = ((inst_21052) && (inst_21054));
var state_21075__$1 = state_21075;
var statearr_21125_22858 = state_21075__$1;
(statearr_21125_22858[(2)] = inst_21055);

(statearr_21125_22858[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (10))){
var inst_20977 = (state_21075[(8)]);
var inst_20998 = (state_21075[(2)]);
var inst_20999 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20998,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21000 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20998,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21001 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20998,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_21002 = inst_20977;
var state_21075__$1 = (function (){var statearr_21126 = state_21075;
(statearr_21126[(7)] = inst_21002);

(statearr_21126[(16)] = inst_21001);

(statearr_21126[(17)] = inst_20999);

(statearr_21126[(18)] = inst_21000);

return statearr_21126;
})();
var statearr_21127_22861 = state_21075__$1;
(statearr_21127_22861[(2)] = null);

(statearr_21127_22861[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (18))){
var inst_21017 = (state_21075[(2)]);
var state_21075__$1 = state_21075;
var statearr_21128_22863 = state_21075__$1;
(statearr_21128_22863[(2)] = inst_21017);

(statearr_21128_22863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (37))){
var state_21075__$1 = state_21075;
var statearr_21129_22865 = state_21075__$1;
(statearr_21129_22865[(2)] = null);

(statearr_21129_22865[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21076 === (8))){
var inst_20977 = (state_21075[(8)]);
var inst_20995 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20977);
var state_21075__$1 = state_21075;
var statearr_21130_22867 = state_21075__$1;
(statearr_21130_22867[(2)] = inst_20995);

(statearr_21130_22867[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__20124__auto__ = null;
var cljs$core$async$mix_$_state_machine__20124__auto____0 = (function (){
var statearr_21131 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21131[(0)] = cljs$core$async$mix_$_state_machine__20124__auto__);

(statearr_21131[(1)] = (1));

return statearr_21131;
});
var cljs$core$async$mix_$_state_machine__20124__auto____1 = (function (state_21075){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21075);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21132){var ex__20127__auto__ = e21132;
var statearr_21133_22869 = state_21075;
(statearr_21133_22869[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21075[(4)]))){
var statearr_21134_22871 = state_21075;
(statearr_21134_22871[(1)] = cljs.core.first((state_21075[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22873 = state_21075;
state_21075 = G__22873;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20124__auto__ = function(state_21075){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20124__auto____1.call(this,state_21075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20124__auto____0;
cljs$core$async$mix_$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20124__auto____1;
return cljs$core$async$mix_$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21135 = f__20272__auto__();
(statearr_21135[(6)] = c__20271__auto___22744);

return statearr_21135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_22876 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_22876(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_22877 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_22877(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_22880 = (function() {
var G__22881 = null;
var G__22881__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__22881__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__22881 = function(p,v){
switch(arguments.length){
case 1:
return G__22881__1.call(this,p);
case 2:
return G__22881__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22881.cljs$core$IFn$_invoke$arity$1 = G__22881__1;
G__22881.cljs$core$IFn$_invoke$arity$2 = G__22881__2;
return G__22881;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__21137 = arguments.length;
switch (G__21137) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_22880(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_22880(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__21140 = arguments.length;
switch (G__21140) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__21138_SHARP_){
if(cljs.core.truth_((p1__21138_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__21138_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__21138_SHARP_.call(null,topic)))){
return p1__21138_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__21138_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21141 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21141 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta21142){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta21142 = meta21142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21143,meta21142__$1){
var self__ = this;
var _21143__$1 = this;
return (new cljs.core.async.t_cljs$core$async21141(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta21142__$1));
}));

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21143){
var self__ = this;
var _21143__$1 = this;
return self__.meta21142;
}));

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async21141.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async21141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta21142","meta21142",618145687,null)], null);
}));

(cljs.core.async.t_cljs$core$async21141.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21141");

(cljs.core.async.t_cljs$core$async21141.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async21141");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21141.
 */
cljs.core.async.__GT_t_cljs$core$async21141 = (function cljs$core$async$__GT_t_cljs$core$async21141(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta21142){
return (new cljs.core.async.t_cljs$core$async21141(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta21142));
});

}

return (new cljs.core.async.t_cljs$core$async21141(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20271__auto___22890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21215){
var state_val_21216 = (state_21215[(1)]);
if((state_val_21216 === (7))){
var inst_21211 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
var statearr_21217_22892 = state_21215__$1;
(statearr_21217_22892[(2)] = inst_21211);

(statearr_21217_22892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (20))){
var state_21215__$1 = state_21215;
var statearr_21218_22893 = state_21215__$1;
(statearr_21218_22893[(2)] = null);

(statearr_21218_22893[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (1))){
var state_21215__$1 = state_21215;
var statearr_21219_22896 = state_21215__$1;
(statearr_21219_22896[(2)] = null);

(statearr_21219_22896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (24))){
var inst_21194 = (state_21215[(7)]);
var inst_21203 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_21194);
var state_21215__$1 = state_21215;
var statearr_21220_22898 = state_21215__$1;
(statearr_21220_22898[(2)] = inst_21203);

(statearr_21220_22898[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (4))){
var inst_21146 = (state_21215[(8)]);
var inst_21146__$1 = (state_21215[(2)]);
var inst_21147 = (inst_21146__$1 == null);
var state_21215__$1 = (function (){var statearr_21221 = state_21215;
(statearr_21221[(8)] = inst_21146__$1);

return statearr_21221;
})();
if(cljs.core.truth_(inst_21147)){
var statearr_21222_22901 = state_21215__$1;
(statearr_21222_22901[(1)] = (5));

} else {
var statearr_21223_22902 = state_21215__$1;
(statearr_21223_22902[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (15))){
var inst_21188 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
var statearr_21224_22904 = state_21215__$1;
(statearr_21224_22904[(2)] = inst_21188);

(statearr_21224_22904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (21))){
var inst_21208 = (state_21215[(2)]);
var state_21215__$1 = (function (){var statearr_21225 = state_21215;
(statearr_21225[(9)] = inst_21208);

return statearr_21225;
})();
var statearr_21226_22905 = state_21215__$1;
(statearr_21226_22905[(2)] = null);

(statearr_21226_22905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (13))){
var inst_21170 = (state_21215[(10)]);
var inst_21172 = cljs.core.chunked_seq_QMARK_(inst_21170);
var state_21215__$1 = state_21215;
if(inst_21172){
var statearr_21227_22908 = state_21215__$1;
(statearr_21227_22908[(1)] = (16));

} else {
var statearr_21228_22909 = state_21215__$1;
(statearr_21228_22909[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (22))){
var inst_21200 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
if(cljs.core.truth_(inst_21200)){
var statearr_21229_22910 = state_21215__$1;
(statearr_21229_22910[(1)] = (23));

} else {
var statearr_21230_22911 = state_21215__$1;
(statearr_21230_22911[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (6))){
var inst_21196 = (state_21215[(11)]);
var inst_21146 = (state_21215[(8)]);
var inst_21194 = (state_21215[(7)]);
var inst_21194__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_21146) : topic_fn.call(null,inst_21146));
var inst_21195 = cljs.core.deref(mults);
var inst_21196__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21195,inst_21194__$1);
var state_21215__$1 = (function (){var statearr_21231 = state_21215;
(statearr_21231[(11)] = inst_21196__$1);

(statearr_21231[(7)] = inst_21194__$1);

return statearr_21231;
})();
if(cljs.core.truth_(inst_21196__$1)){
var statearr_21232_22916 = state_21215__$1;
(statearr_21232_22916[(1)] = (19));

} else {
var statearr_21233_22918 = state_21215__$1;
(statearr_21233_22918[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (25))){
var inst_21205 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
var statearr_21234_22919 = state_21215__$1;
(statearr_21234_22919[(2)] = inst_21205);

(statearr_21234_22919[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (17))){
var inst_21170 = (state_21215[(10)]);
var inst_21179 = cljs.core.first(inst_21170);
var inst_21180 = cljs.core.async.muxch_STAR_(inst_21179);
var inst_21181 = cljs.core.async.close_BANG_(inst_21180);
var inst_21182 = cljs.core.next(inst_21170);
var inst_21156 = inst_21182;
var inst_21157 = null;
var inst_21158 = (0);
var inst_21159 = (0);
var state_21215__$1 = (function (){var statearr_21235 = state_21215;
(statearr_21235[(12)] = inst_21159);

(statearr_21235[(13)] = inst_21156);

(statearr_21235[(14)] = inst_21157);

(statearr_21235[(15)] = inst_21158);

(statearr_21235[(16)] = inst_21181);

return statearr_21235;
})();
var statearr_21236_22920 = state_21215__$1;
(statearr_21236_22920[(2)] = null);

(statearr_21236_22920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (3))){
var inst_21213 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21215__$1,inst_21213);
} else {
if((state_val_21216 === (12))){
var inst_21190 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
var statearr_21237_22922 = state_21215__$1;
(statearr_21237_22922[(2)] = inst_21190);

(statearr_21237_22922[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (2))){
var state_21215__$1 = state_21215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21215__$1,(4),ch);
} else {
if((state_val_21216 === (23))){
var state_21215__$1 = state_21215;
var statearr_21238_22923 = state_21215__$1;
(statearr_21238_22923[(2)] = null);

(statearr_21238_22923[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (19))){
var inst_21196 = (state_21215[(11)]);
var inst_21146 = (state_21215[(8)]);
var inst_21198 = cljs.core.async.muxch_STAR_(inst_21196);
var state_21215__$1 = state_21215;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21215__$1,(22),inst_21198,inst_21146);
} else {
if((state_val_21216 === (11))){
var inst_21156 = (state_21215[(13)]);
var inst_21170 = (state_21215[(10)]);
var inst_21170__$1 = cljs.core.seq(inst_21156);
var state_21215__$1 = (function (){var statearr_21239 = state_21215;
(statearr_21239[(10)] = inst_21170__$1);

return statearr_21239;
})();
if(inst_21170__$1){
var statearr_21240_22925 = state_21215__$1;
(statearr_21240_22925[(1)] = (13));

} else {
var statearr_21241_22926 = state_21215__$1;
(statearr_21241_22926[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (9))){
var inst_21192 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
var statearr_21242_22927 = state_21215__$1;
(statearr_21242_22927[(2)] = inst_21192);

(statearr_21242_22927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (5))){
var inst_21153 = cljs.core.deref(mults);
var inst_21154 = cljs.core.vals(inst_21153);
var inst_21155 = cljs.core.seq(inst_21154);
var inst_21156 = inst_21155;
var inst_21157 = null;
var inst_21158 = (0);
var inst_21159 = (0);
var state_21215__$1 = (function (){var statearr_21243 = state_21215;
(statearr_21243[(12)] = inst_21159);

(statearr_21243[(13)] = inst_21156);

(statearr_21243[(14)] = inst_21157);

(statearr_21243[(15)] = inst_21158);

return statearr_21243;
})();
var statearr_21244_22929 = state_21215__$1;
(statearr_21244_22929[(2)] = null);

(statearr_21244_22929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (14))){
var state_21215__$1 = state_21215;
var statearr_21248_22930 = state_21215__$1;
(statearr_21248_22930[(2)] = null);

(statearr_21248_22930[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (16))){
var inst_21170 = (state_21215[(10)]);
var inst_21174 = cljs.core.chunk_first(inst_21170);
var inst_21175 = cljs.core.chunk_rest(inst_21170);
var inst_21176 = cljs.core.count(inst_21174);
var inst_21156 = inst_21175;
var inst_21157 = inst_21174;
var inst_21158 = inst_21176;
var inst_21159 = (0);
var state_21215__$1 = (function (){var statearr_21249 = state_21215;
(statearr_21249[(12)] = inst_21159);

(statearr_21249[(13)] = inst_21156);

(statearr_21249[(14)] = inst_21157);

(statearr_21249[(15)] = inst_21158);

return statearr_21249;
})();
var statearr_21250_22933 = state_21215__$1;
(statearr_21250_22933[(2)] = null);

(statearr_21250_22933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (10))){
var inst_21159 = (state_21215[(12)]);
var inst_21156 = (state_21215[(13)]);
var inst_21157 = (state_21215[(14)]);
var inst_21158 = (state_21215[(15)]);
var inst_21164 = cljs.core._nth(inst_21157,inst_21159);
var inst_21165 = cljs.core.async.muxch_STAR_(inst_21164);
var inst_21166 = cljs.core.async.close_BANG_(inst_21165);
var inst_21167 = (inst_21159 + (1));
var tmp21245 = inst_21156;
var tmp21246 = inst_21157;
var tmp21247 = inst_21158;
var inst_21156__$1 = tmp21245;
var inst_21157__$1 = tmp21246;
var inst_21158__$1 = tmp21247;
var inst_21159__$1 = inst_21167;
var state_21215__$1 = (function (){var statearr_21251 = state_21215;
(statearr_21251[(12)] = inst_21159__$1);

(statearr_21251[(13)] = inst_21156__$1);

(statearr_21251[(17)] = inst_21166);

(statearr_21251[(14)] = inst_21157__$1);

(statearr_21251[(15)] = inst_21158__$1);

return statearr_21251;
})();
var statearr_21252_22936 = state_21215__$1;
(statearr_21252_22936[(2)] = null);

(statearr_21252_22936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (18))){
var inst_21185 = (state_21215[(2)]);
var state_21215__$1 = state_21215;
var statearr_21253_22937 = state_21215__$1;
(statearr_21253_22937[(2)] = inst_21185);

(statearr_21253_22937[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21216 === (8))){
var inst_21159 = (state_21215[(12)]);
var inst_21158 = (state_21215[(15)]);
var inst_21161 = (inst_21159 < inst_21158);
var inst_21162 = inst_21161;
var state_21215__$1 = state_21215;
if(cljs.core.truth_(inst_21162)){
var statearr_21254_22939 = state_21215__$1;
(statearr_21254_22939[(1)] = (10));

} else {
var statearr_21255_22941 = state_21215__$1;
(statearr_21255_22941[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21256[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21256[(1)] = (1));

return statearr_21256;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21215){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21215);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21257){var ex__20127__auto__ = e21257;
var statearr_21258_22945 = state_21215;
(statearr_21258_22945[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21215[(4)]))){
var statearr_21259_22947 = state_21215;
(statearr_21259_22947[(1)] = cljs.core.first((state_21215[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22948 = state_21215;
state_21215 = G__22948;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21215){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21260 = f__20272__auto__();
(statearr_21260[(6)] = c__20271__auto___22890);

return statearr_21260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__21262 = arguments.length;
switch (G__21262) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__21264 = arguments.length;
switch (G__21264) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__21266 = arguments.length;
switch (G__21266) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__20271__auto___22963 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21309){
var state_val_21310 = (state_21309[(1)]);
if((state_val_21310 === (7))){
var state_21309__$1 = state_21309;
var statearr_21311_22964 = state_21309__$1;
(statearr_21311_22964[(2)] = null);

(statearr_21311_22964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (1))){
var state_21309__$1 = state_21309;
var statearr_21312_22967 = state_21309__$1;
(statearr_21312_22967[(2)] = null);

(statearr_21312_22967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (4))){
var inst_21270 = (state_21309[(7)]);
var inst_21269 = (state_21309[(8)]);
var inst_21272 = (inst_21270 < inst_21269);
var state_21309__$1 = state_21309;
if(cljs.core.truth_(inst_21272)){
var statearr_21313_22970 = state_21309__$1;
(statearr_21313_22970[(1)] = (6));

} else {
var statearr_21314_22971 = state_21309__$1;
(statearr_21314_22971[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (15))){
var inst_21295 = (state_21309[(9)]);
var inst_21300 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_21295);
var state_21309__$1 = state_21309;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21309__$1,(17),out,inst_21300);
} else {
if((state_val_21310 === (13))){
var inst_21295 = (state_21309[(9)]);
var inst_21295__$1 = (state_21309[(2)]);
var inst_21296 = cljs.core.some(cljs.core.nil_QMARK_,inst_21295__$1);
var state_21309__$1 = (function (){var statearr_21315 = state_21309;
(statearr_21315[(9)] = inst_21295__$1);

return statearr_21315;
})();
if(cljs.core.truth_(inst_21296)){
var statearr_21316_22975 = state_21309__$1;
(statearr_21316_22975[(1)] = (14));

} else {
var statearr_21317_22976 = state_21309__$1;
(statearr_21317_22976[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (6))){
var state_21309__$1 = state_21309;
var statearr_21318_22977 = state_21309__$1;
(statearr_21318_22977[(2)] = null);

(statearr_21318_22977[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (17))){
var inst_21302 = (state_21309[(2)]);
var state_21309__$1 = (function (){var statearr_21320 = state_21309;
(statearr_21320[(10)] = inst_21302);

return statearr_21320;
})();
var statearr_21321_22980 = state_21309__$1;
(statearr_21321_22980[(2)] = null);

(statearr_21321_22980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (3))){
var inst_21307 = (state_21309[(2)]);
var state_21309__$1 = state_21309;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21309__$1,inst_21307);
} else {
if((state_val_21310 === (12))){
var _ = (function (){var statearr_21322 = state_21309;
(statearr_21322[(4)] = cljs.core.rest((state_21309[(4)])));

return statearr_21322;
})();
var state_21309__$1 = state_21309;
var ex21319 = (state_21309__$1[(2)]);
var statearr_21323_22984 = state_21309__$1;
(statearr_21323_22984[(5)] = ex21319);


if((ex21319 instanceof Object)){
var statearr_21324_22985 = state_21309__$1;
(statearr_21324_22985[(1)] = (11));

(statearr_21324_22985[(5)] = null);

} else {
throw ex21319;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (2))){
var inst_21268 = cljs.core.reset_BANG_(dctr,cnt);
var inst_21269 = cnt;
var inst_21270 = (0);
var state_21309__$1 = (function (){var statearr_21325 = state_21309;
(statearr_21325[(11)] = inst_21268);

(statearr_21325[(7)] = inst_21270);

(statearr_21325[(8)] = inst_21269);

return statearr_21325;
})();
var statearr_21326_22988 = state_21309__$1;
(statearr_21326_22988[(2)] = null);

(statearr_21326_22988[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (11))){
var inst_21274 = (state_21309[(2)]);
var inst_21275 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_21309__$1 = (function (){var statearr_21327 = state_21309;
(statearr_21327[(12)] = inst_21274);

return statearr_21327;
})();
var statearr_21328_22990 = state_21309__$1;
(statearr_21328_22990[(2)] = inst_21275);

(statearr_21328_22990[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (9))){
var inst_21270 = (state_21309[(7)]);
var _ = (function (){var statearr_21329 = state_21309;
(statearr_21329[(4)] = cljs.core.cons((12),(state_21309[(4)])));

return statearr_21329;
})();
var inst_21281 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_21270) : chs__$1.call(null,inst_21270));
var inst_21282 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_21270) : done.call(null,inst_21270));
var inst_21283 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_21281,inst_21282);
var ___$1 = (function (){var statearr_21330 = state_21309;
(statearr_21330[(4)] = cljs.core.rest((state_21309[(4)])));

return statearr_21330;
})();
var state_21309__$1 = state_21309;
var statearr_21331_22994 = state_21309__$1;
(statearr_21331_22994[(2)] = inst_21283);

(statearr_21331_22994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (5))){
var inst_21293 = (state_21309[(2)]);
var state_21309__$1 = (function (){var statearr_21332 = state_21309;
(statearr_21332[(13)] = inst_21293);

return statearr_21332;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21309__$1,(13),dchan);
} else {
if((state_val_21310 === (14))){
var inst_21298 = cljs.core.async.close_BANG_(out);
var state_21309__$1 = state_21309;
var statearr_21333_22995 = state_21309__$1;
(statearr_21333_22995[(2)] = inst_21298);

(statearr_21333_22995[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (16))){
var inst_21305 = (state_21309[(2)]);
var state_21309__$1 = state_21309;
var statearr_21334_22996 = state_21309__$1;
(statearr_21334_22996[(2)] = inst_21305);

(statearr_21334_22996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (10))){
var inst_21270 = (state_21309[(7)]);
var inst_21286 = (state_21309[(2)]);
var inst_21287 = (inst_21270 + (1));
var inst_21270__$1 = inst_21287;
var state_21309__$1 = (function (){var statearr_21335 = state_21309;
(statearr_21335[(7)] = inst_21270__$1);

(statearr_21335[(14)] = inst_21286);

return statearr_21335;
})();
var statearr_21336_23000 = state_21309__$1;
(statearr_21336_23000[(2)] = null);

(statearr_21336_23000[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21310 === (8))){
var inst_21291 = (state_21309[(2)]);
var state_21309__$1 = state_21309;
var statearr_21337_23002 = state_21309__$1;
(statearr_21337_23002[(2)] = inst_21291);

(statearr_21337_23002[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21338 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21338[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21338[(1)] = (1));

return statearr_21338;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21309){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21309);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21339){var ex__20127__auto__ = e21339;
var statearr_21340_23003 = state_21309;
(statearr_21340_23003[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21309[(4)]))){
var statearr_21341_23005 = state_21309;
(statearr_21341_23005[(1)] = cljs.core.first((state_21309[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23007 = state_21309;
state_21309 = G__23007;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21309){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21342 = f__20272__auto__();
(statearr_21342[(6)] = c__20271__auto___22963);

return statearr_21342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__21345 = arguments.length;
switch (G__21345) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20271__auto___23010 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21377){
var state_val_21378 = (state_21377[(1)]);
if((state_val_21378 === (7))){
var inst_21356 = (state_21377[(7)]);
var inst_21357 = (state_21377[(8)]);
var inst_21356__$1 = (state_21377[(2)]);
var inst_21357__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21356__$1,(0),null);
var inst_21358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21356__$1,(1),null);
var inst_21359 = (inst_21357__$1 == null);
var state_21377__$1 = (function (){var statearr_21379 = state_21377;
(statearr_21379[(7)] = inst_21356__$1);

(statearr_21379[(8)] = inst_21357__$1);

(statearr_21379[(9)] = inst_21358);

return statearr_21379;
})();
if(cljs.core.truth_(inst_21359)){
var statearr_21380_23015 = state_21377__$1;
(statearr_21380_23015[(1)] = (8));

} else {
var statearr_21381_23016 = state_21377__$1;
(statearr_21381_23016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (1))){
var inst_21346 = cljs.core.vec(chs);
var inst_21347 = inst_21346;
var state_21377__$1 = (function (){var statearr_21382 = state_21377;
(statearr_21382[(10)] = inst_21347);

return statearr_21382;
})();
var statearr_21383_23017 = state_21377__$1;
(statearr_21383_23017[(2)] = null);

(statearr_21383_23017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (4))){
var inst_21347 = (state_21377[(10)]);
var state_21377__$1 = state_21377;
return cljs.core.async.ioc_alts_BANG_(state_21377__$1,(7),inst_21347);
} else {
if((state_val_21378 === (6))){
var inst_21373 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
var statearr_21384_23021 = state_21377__$1;
(statearr_21384_23021[(2)] = inst_21373);

(statearr_21384_23021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (3))){
var inst_21375 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21377__$1,inst_21375);
} else {
if((state_val_21378 === (2))){
var inst_21347 = (state_21377[(10)]);
var inst_21349 = cljs.core.count(inst_21347);
var inst_21350 = (inst_21349 > (0));
var state_21377__$1 = state_21377;
if(cljs.core.truth_(inst_21350)){
var statearr_21386_23022 = state_21377__$1;
(statearr_21386_23022[(1)] = (4));

} else {
var statearr_21387_23023 = state_21377__$1;
(statearr_21387_23023[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (11))){
var inst_21347 = (state_21377[(10)]);
var inst_21366 = (state_21377[(2)]);
var tmp21385 = inst_21347;
var inst_21347__$1 = tmp21385;
var state_21377__$1 = (function (){var statearr_21388 = state_21377;
(statearr_21388[(11)] = inst_21366);

(statearr_21388[(10)] = inst_21347__$1);

return statearr_21388;
})();
var statearr_21389_23024 = state_21377__$1;
(statearr_21389_23024[(2)] = null);

(statearr_21389_23024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (9))){
var inst_21357 = (state_21377[(8)]);
var state_21377__$1 = state_21377;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21377__$1,(11),out,inst_21357);
} else {
if((state_val_21378 === (5))){
var inst_21371 = cljs.core.async.close_BANG_(out);
var state_21377__$1 = state_21377;
var statearr_21390_23025 = state_21377__$1;
(statearr_21390_23025[(2)] = inst_21371);

(statearr_21390_23025[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (10))){
var inst_21369 = (state_21377[(2)]);
var state_21377__$1 = state_21377;
var statearr_21391_23026 = state_21377__$1;
(statearr_21391_23026[(2)] = inst_21369);

(statearr_21391_23026[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21378 === (8))){
var inst_21356 = (state_21377[(7)]);
var inst_21357 = (state_21377[(8)]);
var inst_21358 = (state_21377[(9)]);
var inst_21347 = (state_21377[(10)]);
var inst_21361 = (function (){var cs = inst_21347;
var vec__21352 = inst_21356;
var v = inst_21357;
var c = inst_21358;
return (function (p1__21343_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__21343_SHARP_);
});
})();
var inst_21362 = cljs.core.filterv(inst_21361,inst_21347);
var inst_21347__$1 = inst_21362;
var state_21377__$1 = (function (){var statearr_21392 = state_21377;
(statearr_21392[(10)] = inst_21347__$1);

return statearr_21392;
})();
var statearr_21393_23027 = state_21377__$1;
(statearr_21393_23027[(2)] = null);

(statearr_21393_23027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21394 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21394[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21394[(1)] = (1));

return statearr_21394;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21377){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21377);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21395){var ex__20127__auto__ = e21395;
var statearr_21396_23032 = state_21377;
(statearr_21396_23032[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21377[(4)]))){
var statearr_21397_23033 = state_21377;
(statearr_21397_23033[(1)] = cljs.core.first((state_21377[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23034 = state_21377;
state_21377 = G__23034;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21377){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21398 = f__20272__auto__();
(statearr_21398[(6)] = c__20271__auto___23010);

return statearr_21398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__21400 = arguments.length;
switch (G__21400) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20271__auto___23038 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21424){
var state_val_21425 = (state_21424[(1)]);
if((state_val_21425 === (7))){
var inst_21406 = (state_21424[(7)]);
var inst_21406__$1 = (state_21424[(2)]);
var inst_21407 = (inst_21406__$1 == null);
var inst_21408 = cljs.core.not(inst_21407);
var state_21424__$1 = (function (){var statearr_21426 = state_21424;
(statearr_21426[(7)] = inst_21406__$1);

return statearr_21426;
})();
if(inst_21408){
var statearr_21427_23039 = state_21424__$1;
(statearr_21427_23039[(1)] = (8));

} else {
var statearr_21428_23040 = state_21424__$1;
(statearr_21428_23040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (1))){
var inst_21401 = (0);
var state_21424__$1 = (function (){var statearr_21429 = state_21424;
(statearr_21429[(8)] = inst_21401);

return statearr_21429;
})();
var statearr_21430_23041 = state_21424__$1;
(statearr_21430_23041[(2)] = null);

(statearr_21430_23041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (4))){
var state_21424__$1 = state_21424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21424__$1,(7),ch);
} else {
if((state_val_21425 === (6))){
var inst_21419 = (state_21424[(2)]);
var state_21424__$1 = state_21424;
var statearr_21431_23042 = state_21424__$1;
(statearr_21431_23042[(2)] = inst_21419);

(statearr_21431_23042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (3))){
var inst_21421 = (state_21424[(2)]);
var inst_21422 = cljs.core.async.close_BANG_(out);
var state_21424__$1 = (function (){var statearr_21432 = state_21424;
(statearr_21432[(9)] = inst_21421);

return statearr_21432;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_21424__$1,inst_21422);
} else {
if((state_val_21425 === (2))){
var inst_21401 = (state_21424[(8)]);
var inst_21403 = (inst_21401 < n);
var state_21424__$1 = state_21424;
if(cljs.core.truth_(inst_21403)){
var statearr_21433_23043 = state_21424__$1;
(statearr_21433_23043[(1)] = (4));

} else {
var statearr_21434_23044 = state_21424__$1;
(statearr_21434_23044[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (11))){
var inst_21401 = (state_21424[(8)]);
var inst_21411 = (state_21424[(2)]);
var inst_21412 = (inst_21401 + (1));
var inst_21401__$1 = inst_21412;
var state_21424__$1 = (function (){var statearr_21435 = state_21424;
(statearr_21435[(10)] = inst_21411);

(statearr_21435[(8)] = inst_21401__$1);

return statearr_21435;
})();
var statearr_21436_23045 = state_21424__$1;
(statearr_21436_23045[(2)] = null);

(statearr_21436_23045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (9))){
var state_21424__$1 = state_21424;
var statearr_21437_23046 = state_21424__$1;
(statearr_21437_23046[(2)] = null);

(statearr_21437_23046[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (5))){
var state_21424__$1 = state_21424;
var statearr_21438_23047 = state_21424__$1;
(statearr_21438_23047[(2)] = null);

(statearr_21438_23047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (10))){
var inst_21416 = (state_21424[(2)]);
var state_21424__$1 = state_21424;
var statearr_21439_23048 = state_21424__$1;
(statearr_21439_23048[(2)] = inst_21416);

(statearr_21439_23048[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21425 === (8))){
var inst_21406 = (state_21424[(7)]);
var state_21424__$1 = state_21424;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21424__$1,(11),out,inst_21406);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21440 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21440[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21440[(1)] = (1));

return statearr_21440;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21424){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21424);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21441){var ex__20127__auto__ = e21441;
var statearr_21442_23049 = state_21424;
(statearr_21442_23049[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21424[(4)]))){
var statearr_21443_23050 = state_21424;
(statearr_21443_23050[(1)] = cljs.core.first((state_21424[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23051 = state_21424;
state_21424 = G__23051;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21424){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21444 = f__20272__auto__();
(statearr_21444[(6)] = c__20271__auto___23038);

return statearr_21444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21446 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21446 = (function (f,ch,meta21447){
this.f = f;
this.ch = ch;
this.meta21447 = meta21447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21448,meta21447__$1){
var self__ = this;
var _21448__$1 = this;
return (new cljs.core.async.t_cljs$core$async21446(self__.f,self__.ch,meta21447__$1));
}));

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21448){
var self__ = this;
var _21448__$1 = this;
return self__.meta21447;
}));

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21449 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21449 = (function (f,ch,meta21447,_,fn1,meta21450){
this.f = f;
this.ch = ch;
this.meta21447 = meta21447;
this._ = _;
this.fn1 = fn1;
this.meta21450 = meta21450;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21449.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21451,meta21450__$1){
var self__ = this;
var _21451__$1 = this;
return (new cljs.core.async.t_cljs$core$async21449(self__.f,self__.ch,self__.meta21447,self__._,self__.fn1,meta21450__$1));
}));

(cljs.core.async.t_cljs$core$async21449.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21451){
var self__ = this;
var _21451__$1 = this;
return self__.meta21450;
}));

(cljs.core.async.t_cljs$core$async21449.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21449.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async21449.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async21449.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__21445_SHARP_){
var G__21452 = (((p1__21445_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__21445_SHARP_) : self__.f.call(null,p1__21445_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__21452) : f1.call(null,G__21452));
});
}));

(cljs.core.async.t_cljs$core$async21449.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21447","meta21447",1358883424,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21446","cljs.core.async/t_cljs$core$async21446",803015461,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21450","meta21450",-1151078854,null)], null);
}));

(cljs.core.async.t_cljs$core$async21449.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21449.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21449");

(cljs.core.async.t_cljs$core$async21449.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async21449");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21449.
 */
cljs.core.async.__GT_t_cljs$core$async21449 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21449(f__$1,ch__$1,meta21447__$1,___$2,fn1__$1,meta21450){
return (new cljs.core.async.t_cljs$core$async21449(f__$1,ch__$1,meta21447__$1,___$2,fn1__$1,meta21450));
});

}

return (new cljs.core.async.t_cljs$core$async21449(self__.f,self__.ch,self__.meta21447,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__21453 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__21453) : self__.f.call(null,G__21453));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21446.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async21446.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21447","meta21447",1358883424,null)], null);
}));

(cljs.core.async.t_cljs$core$async21446.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21446.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21446");

(cljs.core.async.t_cljs$core$async21446.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async21446");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21446.
 */
cljs.core.async.__GT_t_cljs$core$async21446 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21446(f__$1,ch__$1,meta21447){
return (new cljs.core.async.t_cljs$core$async21446(f__$1,ch__$1,meta21447));
});

}

return (new cljs.core.async.t_cljs$core$async21446(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21454 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21454 = (function (f,ch,meta21455){
this.f = f;
this.ch = ch;
this.meta21455 = meta21455;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21456,meta21455__$1){
var self__ = this;
var _21456__$1 = this;
return (new cljs.core.async.t_cljs$core$async21454(self__.f,self__.ch,meta21455__$1));
}));

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21456){
var self__ = this;
var _21456__$1 = this;
return self__.meta21455;
}));

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21454.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async21454.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21455","meta21455",-670222178,null)], null);
}));

(cljs.core.async.t_cljs$core$async21454.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21454.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21454");

(cljs.core.async.t_cljs$core$async21454.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async21454");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21454.
 */
cljs.core.async.__GT_t_cljs$core$async21454 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21454(f__$1,ch__$1,meta21455){
return (new cljs.core.async.t_cljs$core$async21454(f__$1,ch__$1,meta21455));
});

}

return (new cljs.core.async.t_cljs$core$async21454(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21457 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21457 = (function (p,ch,meta21458){
this.p = p;
this.ch = ch;
this.meta21458 = meta21458;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21459,meta21458__$1){
var self__ = this;
var _21459__$1 = this;
return (new cljs.core.async.t_cljs$core$async21457(self__.p,self__.ch,meta21458__$1));
}));

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21459){
var self__ = this;
var _21459__$1 = this;
return self__.meta21458;
}));

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21457.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async21457.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21458","meta21458",1536500742,null)], null);
}));

(cljs.core.async.t_cljs$core$async21457.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21457.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21457");

(cljs.core.async.t_cljs$core$async21457.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async21457");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21457.
 */
cljs.core.async.__GT_t_cljs$core$async21457 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21457(p__$1,ch__$1,meta21458){
return (new cljs.core.async.t_cljs$core$async21457(p__$1,ch__$1,meta21458));
});

}

return (new cljs.core.async.t_cljs$core$async21457(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__21461 = arguments.length;
switch (G__21461) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20271__auto___23053 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21482){
var state_val_21483 = (state_21482[(1)]);
if((state_val_21483 === (7))){
var inst_21478 = (state_21482[(2)]);
var state_21482__$1 = state_21482;
var statearr_21484_23054 = state_21482__$1;
(statearr_21484_23054[(2)] = inst_21478);

(statearr_21484_23054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (1))){
var state_21482__$1 = state_21482;
var statearr_21485_23055 = state_21482__$1;
(statearr_21485_23055[(2)] = null);

(statearr_21485_23055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (4))){
var inst_21464 = (state_21482[(7)]);
var inst_21464__$1 = (state_21482[(2)]);
var inst_21465 = (inst_21464__$1 == null);
var state_21482__$1 = (function (){var statearr_21486 = state_21482;
(statearr_21486[(7)] = inst_21464__$1);

return statearr_21486;
})();
if(cljs.core.truth_(inst_21465)){
var statearr_21487_23056 = state_21482__$1;
(statearr_21487_23056[(1)] = (5));

} else {
var statearr_21488_23057 = state_21482__$1;
(statearr_21488_23057[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (6))){
var inst_21464 = (state_21482[(7)]);
var inst_21469 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_21464) : p.call(null,inst_21464));
var state_21482__$1 = state_21482;
if(cljs.core.truth_(inst_21469)){
var statearr_21489_23058 = state_21482__$1;
(statearr_21489_23058[(1)] = (8));

} else {
var statearr_21490_23059 = state_21482__$1;
(statearr_21490_23059[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (3))){
var inst_21480 = (state_21482[(2)]);
var state_21482__$1 = state_21482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21482__$1,inst_21480);
} else {
if((state_val_21483 === (2))){
var state_21482__$1 = state_21482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21482__$1,(4),ch);
} else {
if((state_val_21483 === (11))){
var inst_21472 = (state_21482[(2)]);
var state_21482__$1 = state_21482;
var statearr_21491_23060 = state_21482__$1;
(statearr_21491_23060[(2)] = inst_21472);

(statearr_21491_23060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (9))){
var state_21482__$1 = state_21482;
var statearr_21492_23061 = state_21482__$1;
(statearr_21492_23061[(2)] = null);

(statearr_21492_23061[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (5))){
var inst_21467 = cljs.core.async.close_BANG_(out);
var state_21482__$1 = state_21482;
var statearr_21493_23062 = state_21482__$1;
(statearr_21493_23062[(2)] = inst_21467);

(statearr_21493_23062[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (10))){
var inst_21475 = (state_21482[(2)]);
var state_21482__$1 = (function (){var statearr_21494 = state_21482;
(statearr_21494[(8)] = inst_21475);

return statearr_21494;
})();
var statearr_21495_23063 = state_21482__$1;
(statearr_21495_23063[(2)] = null);

(statearr_21495_23063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21483 === (8))){
var inst_21464 = (state_21482[(7)]);
var state_21482__$1 = state_21482;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21482__$1,(11),out,inst_21464);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21496 = [null,null,null,null,null,null,null,null,null];
(statearr_21496[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21496[(1)] = (1));

return statearr_21496;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21482){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21482);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21497){var ex__20127__auto__ = e21497;
var statearr_21498_23064 = state_21482;
(statearr_21498_23064[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21482[(4)]))){
var statearr_21499_23065 = state_21482;
(statearr_21499_23065[(1)] = cljs.core.first((state_21482[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23066 = state_21482;
state_21482 = G__23066;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21482){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21500 = f__20272__auto__();
(statearr_21500[(6)] = c__20271__auto___23053);

return statearr_21500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__21502 = arguments.length;
switch (G__21502) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20271__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21564){
var state_val_21565 = (state_21564[(1)]);
if((state_val_21565 === (7))){
var inst_21560 = (state_21564[(2)]);
var state_21564__$1 = state_21564;
var statearr_21566_23068 = state_21564__$1;
(statearr_21566_23068[(2)] = inst_21560);

(statearr_21566_23068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (20))){
var inst_21530 = (state_21564[(7)]);
var inst_21541 = (state_21564[(2)]);
var inst_21542 = cljs.core.next(inst_21530);
var inst_21516 = inst_21542;
var inst_21517 = null;
var inst_21518 = (0);
var inst_21519 = (0);
var state_21564__$1 = (function (){var statearr_21567 = state_21564;
(statearr_21567[(8)] = inst_21516);

(statearr_21567[(9)] = inst_21519);

(statearr_21567[(10)] = inst_21541);

(statearr_21567[(11)] = inst_21517);

(statearr_21567[(12)] = inst_21518);

return statearr_21567;
})();
var statearr_21568_23069 = state_21564__$1;
(statearr_21568_23069[(2)] = null);

(statearr_21568_23069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (1))){
var state_21564__$1 = state_21564;
var statearr_21569_23070 = state_21564__$1;
(statearr_21569_23070[(2)] = null);

(statearr_21569_23070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (4))){
var inst_21505 = (state_21564[(13)]);
var inst_21505__$1 = (state_21564[(2)]);
var inst_21506 = (inst_21505__$1 == null);
var state_21564__$1 = (function (){var statearr_21570 = state_21564;
(statearr_21570[(13)] = inst_21505__$1);

return statearr_21570;
})();
if(cljs.core.truth_(inst_21506)){
var statearr_21571_23071 = state_21564__$1;
(statearr_21571_23071[(1)] = (5));

} else {
var statearr_21572_23072 = state_21564__$1;
(statearr_21572_23072[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (15))){
var state_21564__$1 = state_21564;
var statearr_21576_23073 = state_21564__$1;
(statearr_21576_23073[(2)] = null);

(statearr_21576_23073[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (21))){
var state_21564__$1 = state_21564;
var statearr_21577_23074 = state_21564__$1;
(statearr_21577_23074[(2)] = null);

(statearr_21577_23074[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (13))){
var inst_21516 = (state_21564[(8)]);
var inst_21519 = (state_21564[(9)]);
var inst_21517 = (state_21564[(11)]);
var inst_21518 = (state_21564[(12)]);
var inst_21526 = (state_21564[(2)]);
var inst_21527 = (inst_21519 + (1));
var tmp21573 = inst_21516;
var tmp21574 = inst_21517;
var tmp21575 = inst_21518;
var inst_21516__$1 = tmp21573;
var inst_21517__$1 = tmp21574;
var inst_21518__$1 = tmp21575;
var inst_21519__$1 = inst_21527;
var state_21564__$1 = (function (){var statearr_21578 = state_21564;
(statearr_21578[(8)] = inst_21516__$1);

(statearr_21578[(9)] = inst_21519__$1);

(statearr_21578[(11)] = inst_21517__$1);

(statearr_21578[(12)] = inst_21518__$1);

(statearr_21578[(14)] = inst_21526);

return statearr_21578;
})();
var statearr_21579_23075 = state_21564__$1;
(statearr_21579_23075[(2)] = null);

(statearr_21579_23075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (22))){
var state_21564__$1 = state_21564;
var statearr_21580_23076 = state_21564__$1;
(statearr_21580_23076[(2)] = null);

(statearr_21580_23076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (6))){
var inst_21505 = (state_21564[(13)]);
var inst_21514 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_21505) : f.call(null,inst_21505));
var inst_21515 = cljs.core.seq(inst_21514);
var inst_21516 = inst_21515;
var inst_21517 = null;
var inst_21518 = (0);
var inst_21519 = (0);
var state_21564__$1 = (function (){var statearr_21581 = state_21564;
(statearr_21581[(8)] = inst_21516);

(statearr_21581[(9)] = inst_21519);

(statearr_21581[(11)] = inst_21517);

(statearr_21581[(12)] = inst_21518);

return statearr_21581;
})();
var statearr_21582_23077 = state_21564__$1;
(statearr_21582_23077[(2)] = null);

(statearr_21582_23077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (17))){
var inst_21530 = (state_21564[(7)]);
var inst_21534 = cljs.core.chunk_first(inst_21530);
var inst_21535 = cljs.core.chunk_rest(inst_21530);
var inst_21536 = cljs.core.count(inst_21534);
var inst_21516 = inst_21535;
var inst_21517 = inst_21534;
var inst_21518 = inst_21536;
var inst_21519 = (0);
var state_21564__$1 = (function (){var statearr_21583 = state_21564;
(statearr_21583[(8)] = inst_21516);

(statearr_21583[(9)] = inst_21519);

(statearr_21583[(11)] = inst_21517);

(statearr_21583[(12)] = inst_21518);

return statearr_21583;
})();
var statearr_21584_23078 = state_21564__$1;
(statearr_21584_23078[(2)] = null);

(statearr_21584_23078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (3))){
var inst_21562 = (state_21564[(2)]);
var state_21564__$1 = state_21564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21564__$1,inst_21562);
} else {
if((state_val_21565 === (12))){
var inst_21550 = (state_21564[(2)]);
var state_21564__$1 = state_21564;
var statearr_21585_23079 = state_21564__$1;
(statearr_21585_23079[(2)] = inst_21550);

(statearr_21585_23079[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (2))){
var state_21564__$1 = state_21564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21564__$1,(4),in$);
} else {
if((state_val_21565 === (23))){
var inst_21558 = (state_21564[(2)]);
var state_21564__$1 = state_21564;
var statearr_21586_23080 = state_21564__$1;
(statearr_21586_23080[(2)] = inst_21558);

(statearr_21586_23080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (19))){
var inst_21545 = (state_21564[(2)]);
var state_21564__$1 = state_21564;
var statearr_21587_23081 = state_21564__$1;
(statearr_21587_23081[(2)] = inst_21545);

(statearr_21587_23081[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (11))){
var inst_21530 = (state_21564[(7)]);
var inst_21516 = (state_21564[(8)]);
var inst_21530__$1 = cljs.core.seq(inst_21516);
var state_21564__$1 = (function (){var statearr_21588 = state_21564;
(statearr_21588[(7)] = inst_21530__$1);

return statearr_21588;
})();
if(inst_21530__$1){
var statearr_21589_23082 = state_21564__$1;
(statearr_21589_23082[(1)] = (14));

} else {
var statearr_21590_23083 = state_21564__$1;
(statearr_21590_23083[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (9))){
var inst_21552 = (state_21564[(2)]);
var inst_21553 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_21564__$1 = (function (){var statearr_21591 = state_21564;
(statearr_21591[(15)] = inst_21552);

return statearr_21591;
})();
if(cljs.core.truth_(inst_21553)){
var statearr_21592_23084 = state_21564__$1;
(statearr_21592_23084[(1)] = (21));

} else {
var statearr_21593_23085 = state_21564__$1;
(statearr_21593_23085[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (5))){
var inst_21508 = cljs.core.async.close_BANG_(out);
var state_21564__$1 = state_21564;
var statearr_21594_23086 = state_21564__$1;
(statearr_21594_23086[(2)] = inst_21508);

(statearr_21594_23086[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (14))){
var inst_21530 = (state_21564[(7)]);
var inst_21532 = cljs.core.chunked_seq_QMARK_(inst_21530);
var state_21564__$1 = state_21564;
if(inst_21532){
var statearr_21595_23087 = state_21564__$1;
(statearr_21595_23087[(1)] = (17));

} else {
var statearr_21596_23088 = state_21564__$1;
(statearr_21596_23088[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (16))){
var inst_21548 = (state_21564[(2)]);
var state_21564__$1 = state_21564;
var statearr_21597_23089 = state_21564__$1;
(statearr_21597_23089[(2)] = inst_21548);

(statearr_21597_23089[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21565 === (10))){
var inst_21519 = (state_21564[(9)]);
var inst_21517 = (state_21564[(11)]);
var inst_21524 = cljs.core._nth(inst_21517,inst_21519);
var state_21564__$1 = state_21564;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21564__$1,(13),out,inst_21524);
} else {
if((state_val_21565 === (18))){
var inst_21530 = (state_21564[(7)]);
var inst_21539 = cljs.core.first(inst_21530);
var state_21564__$1 = state_21564;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21564__$1,(20),out,inst_21539);
} else {
if((state_val_21565 === (8))){
var inst_21519 = (state_21564[(9)]);
var inst_21518 = (state_21564[(12)]);
var inst_21521 = (inst_21519 < inst_21518);
var inst_21522 = inst_21521;
var state_21564__$1 = state_21564;
if(cljs.core.truth_(inst_21522)){
var statearr_21598_23090 = state_21564__$1;
(statearr_21598_23090[(1)] = (10));

} else {
var statearr_21599_23091 = state_21564__$1;
(statearr_21599_23091[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20124__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20124__auto____0 = (function (){
var statearr_21600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21600[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20124__auto__);

(statearr_21600[(1)] = (1));

return statearr_21600;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20124__auto____1 = (function (state_21564){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21564);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21601){var ex__20127__auto__ = e21601;
var statearr_21602_23092 = state_21564;
(statearr_21602_23092[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21564[(4)]))){
var statearr_21603_23093 = state_21564;
(statearr_21603_23093[(1)] = cljs.core.first((state_21564[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23094 = state_21564;
state_21564 = G__23094;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20124__auto__ = function(state_21564){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20124__auto____1.call(this,state_21564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20124__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20124__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21604 = f__20272__auto__();
(statearr_21604[(6)] = c__20271__auto__);

return statearr_21604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));

return c__20271__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__21606 = arguments.length;
switch (G__21606) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__21608 = arguments.length;
switch (G__21608) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__21610 = arguments.length;
switch (G__21610) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20271__auto___23098 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21634){
var state_val_21635 = (state_21634[(1)]);
if((state_val_21635 === (7))){
var inst_21629 = (state_21634[(2)]);
var state_21634__$1 = state_21634;
var statearr_21636_23099 = state_21634__$1;
(statearr_21636_23099[(2)] = inst_21629);

(statearr_21636_23099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (1))){
var inst_21611 = null;
var state_21634__$1 = (function (){var statearr_21637 = state_21634;
(statearr_21637[(7)] = inst_21611);

return statearr_21637;
})();
var statearr_21638_23100 = state_21634__$1;
(statearr_21638_23100[(2)] = null);

(statearr_21638_23100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (4))){
var inst_21614 = (state_21634[(8)]);
var inst_21614__$1 = (state_21634[(2)]);
var inst_21615 = (inst_21614__$1 == null);
var inst_21616 = cljs.core.not(inst_21615);
var state_21634__$1 = (function (){var statearr_21639 = state_21634;
(statearr_21639[(8)] = inst_21614__$1);

return statearr_21639;
})();
if(inst_21616){
var statearr_21640_23101 = state_21634__$1;
(statearr_21640_23101[(1)] = (5));

} else {
var statearr_21641_23102 = state_21634__$1;
(statearr_21641_23102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (6))){
var state_21634__$1 = state_21634;
var statearr_21642_23103 = state_21634__$1;
(statearr_21642_23103[(2)] = null);

(statearr_21642_23103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (3))){
var inst_21631 = (state_21634[(2)]);
var inst_21632 = cljs.core.async.close_BANG_(out);
var state_21634__$1 = (function (){var statearr_21643 = state_21634;
(statearr_21643[(9)] = inst_21631);

return statearr_21643;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_21634__$1,inst_21632);
} else {
if((state_val_21635 === (2))){
var state_21634__$1 = state_21634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21634__$1,(4),ch);
} else {
if((state_val_21635 === (11))){
var inst_21614 = (state_21634[(8)]);
var inst_21623 = (state_21634[(2)]);
var inst_21611 = inst_21614;
var state_21634__$1 = (function (){var statearr_21644 = state_21634;
(statearr_21644[(10)] = inst_21623);

(statearr_21644[(7)] = inst_21611);

return statearr_21644;
})();
var statearr_21645_23104 = state_21634__$1;
(statearr_21645_23104[(2)] = null);

(statearr_21645_23104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (9))){
var inst_21614 = (state_21634[(8)]);
var state_21634__$1 = state_21634;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21634__$1,(11),out,inst_21614);
} else {
if((state_val_21635 === (5))){
var inst_21611 = (state_21634[(7)]);
var inst_21614 = (state_21634[(8)]);
var inst_21618 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21614,inst_21611);
var state_21634__$1 = state_21634;
if(inst_21618){
var statearr_21647_23105 = state_21634__$1;
(statearr_21647_23105[(1)] = (8));

} else {
var statearr_21648_23106 = state_21634__$1;
(statearr_21648_23106[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (10))){
var inst_21626 = (state_21634[(2)]);
var state_21634__$1 = state_21634;
var statearr_21649_23107 = state_21634__$1;
(statearr_21649_23107[(2)] = inst_21626);

(statearr_21649_23107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21635 === (8))){
var inst_21611 = (state_21634[(7)]);
var tmp21646 = inst_21611;
var inst_21611__$1 = tmp21646;
var state_21634__$1 = (function (){var statearr_21650 = state_21634;
(statearr_21650[(7)] = inst_21611__$1);

return statearr_21650;
})();
var statearr_21651_23108 = state_21634__$1;
(statearr_21651_23108[(2)] = null);

(statearr_21651_23108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21652 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21652[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21652[(1)] = (1));

return statearr_21652;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21634){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21634);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21653){var ex__20127__auto__ = e21653;
var statearr_21654_23109 = state_21634;
(statearr_21654_23109[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21634[(4)]))){
var statearr_21655_23110 = state_21634;
(statearr_21655_23110[(1)] = cljs.core.first((state_21634[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23111 = state_21634;
state_21634 = G__23111;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21634){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21656 = f__20272__auto__();
(statearr_21656[(6)] = c__20271__auto___23098);

return statearr_21656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__21658 = arguments.length;
switch (G__21658) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20271__auto___23113 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21696){
var state_val_21697 = (state_21696[(1)]);
if((state_val_21697 === (7))){
var inst_21692 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21698_23114 = state_21696__$1;
(statearr_21698_23114[(2)] = inst_21692);

(statearr_21698_23114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (1))){
var inst_21659 = (new Array(n));
var inst_21660 = inst_21659;
var inst_21661 = (0);
var state_21696__$1 = (function (){var statearr_21699 = state_21696;
(statearr_21699[(7)] = inst_21660);

(statearr_21699[(8)] = inst_21661);

return statearr_21699;
})();
var statearr_21700_23115 = state_21696__$1;
(statearr_21700_23115[(2)] = null);

(statearr_21700_23115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (4))){
var inst_21664 = (state_21696[(9)]);
var inst_21664__$1 = (state_21696[(2)]);
var inst_21665 = (inst_21664__$1 == null);
var inst_21666 = cljs.core.not(inst_21665);
var state_21696__$1 = (function (){var statearr_21701 = state_21696;
(statearr_21701[(9)] = inst_21664__$1);

return statearr_21701;
})();
if(inst_21666){
var statearr_21702_23116 = state_21696__$1;
(statearr_21702_23116[(1)] = (5));

} else {
var statearr_21703_23117 = state_21696__$1;
(statearr_21703_23117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (15))){
var inst_21686 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21704_23118 = state_21696__$1;
(statearr_21704_23118[(2)] = inst_21686);

(statearr_21704_23118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (13))){
var state_21696__$1 = state_21696;
var statearr_21705_23119 = state_21696__$1;
(statearr_21705_23119[(2)] = null);

(statearr_21705_23119[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (6))){
var inst_21661 = (state_21696[(8)]);
var inst_21682 = (inst_21661 > (0));
var state_21696__$1 = state_21696;
if(cljs.core.truth_(inst_21682)){
var statearr_21706_23120 = state_21696__$1;
(statearr_21706_23120[(1)] = (12));

} else {
var statearr_21707_23121 = state_21696__$1;
(statearr_21707_23121[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (3))){
var inst_21694 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21696__$1,inst_21694);
} else {
if((state_val_21697 === (12))){
var inst_21660 = (state_21696[(7)]);
var inst_21684 = cljs.core.vec(inst_21660);
var state_21696__$1 = state_21696;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21696__$1,(15),out,inst_21684);
} else {
if((state_val_21697 === (2))){
var state_21696__$1 = state_21696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21696__$1,(4),ch);
} else {
if((state_val_21697 === (11))){
var inst_21676 = (state_21696[(2)]);
var inst_21677 = (new Array(n));
var inst_21660 = inst_21677;
var inst_21661 = (0);
var state_21696__$1 = (function (){var statearr_21708 = state_21696;
(statearr_21708[(10)] = inst_21676);

(statearr_21708[(7)] = inst_21660);

(statearr_21708[(8)] = inst_21661);

return statearr_21708;
})();
var statearr_21709_23122 = state_21696__$1;
(statearr_21709_23122[(2)] = null);

(statearr_21709_23122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (9))){
var inst_21660 = (state_21696[(7)]);
var inst_21674 = cljs.core.vec(inst_21660);
var state_21696__$1 = state_21696;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21696__$1,(11),out,inst_21674);
} else {
if((state_val_21697 === (5))){
var inst_21664 = (state_21696[(9)]);
var inst_21669 = (state_21696[(11)]);
var inst_21660 = (state_21696[(7)]);
var inst_21661 = (state_21696[(8)]);
var inst_21668 = (inst_21660[inst_21661] = inst_21664);
var inst_21669__$1 = (inst_21661 + (1));
var inst_21670 = (inst_21669__$1 < n);
var state_21696__$1 = (function (){var statearr_21710 = state_21696;
(statearr_21710[(11)] = inst_21669__$1);

(statearr_21710[(12)] = inst_21668);

return statearr_21710;
})();
if(cljs.core.truth_(inst_21670)){
var statearr_21711_23123 = state_21696__$1;
(statearr_21711_23123[(1)] = (8));

} else {
var statearr_21712_23124 = state_21696__$1;
(statearr_21712_23124[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (14))){
var inst_21689 = (state_21696[(2)]);
var inst_21690 = cljs.core.async.close_BANG_(out);
var state_21696__$1 = (function (){var statearr_21714 = state_21696;
(statearr_21714[(13)] = inst_21689);

return statearr_21714;
})();
var statearr_21715_23125 = state_21696__$1;
(statearr_21715_23125[(2)] = inst_21690);

(statearr_21715_23125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (10))){
var inst_21680 = (state_21696[(2)]);
var state_21696__$1 = state_21696;
var statearr_21716_23126 = state_21696__$1;
(statearr_21716_23126[(2)] = inst_21680);

(statearr_21716_23126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21697 === (8))){
var inst_21669 = (state_21696[(11)]);
var inst_21660 = (state_21696[(7)]);
var tmp21713 = inst_21660;
var inst_21660__$1 = tmp21713;
var inst_21661 = inst_21669;
var state_21696__$1 = (function (){var statearr_21717 = state_21696;
(statearr_21717[(7)] = inst_21660__$1);

(statearr_21717[(8)] = inst_21661);

return statearr_21717;
})();
var statearr_21718_23127 = state_21696__$1;
(statearr_21718_23127[(2)] = null);

(statearr_21718_23127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21719 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21719[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21719[(1)] = (1));

return statearr_21719;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21696){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21696);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21720){var ex__20127__auto__ = e21720;
var statearr_21721_23128 = state_21696;
(statearr_21721_23128[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21696[(4)]))){
var statearr_21722_23129 = state_21696;
(statearr_21722_23129[(1)] = cljs.core.first((state_21696[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23130 = state_21696;
state_21696 = G__23130;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21696){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21723 = f__20272__auto__();
(statearr_21723[(6)] = c__20271__auto___23113);

return statearr_21723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__21725 = arguments.length;
switch (G__21725) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20271__auto___23132 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_21767){
var state_val_21768 = (state_21767[(1)]);
if((state_val_21768 === (7))){
var inst_21763 = (state_21767[(2)]);
var state_21767__$1 = state_21767;
var statearr_21769_23133 = state_21767__$1;
(statearr_21769_23133[(2)] = inst_21763);

(statearr_21769_23133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (1))){
var inst_21726 = [];
var inst_21727 = inst_21726;
var inst_21728 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21767__$1 = (function (){var statearr_21770 = state_21767;
(statearr_21770[(7)] = inst_21728);

(statearr_21770[(8)] = inst_21727);

return statearr_21770;
})();
var statearr_21771_23134 = state_21767__$1;
(statearr_21771_23134[(2)] = null);

(statearr_21771_23134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (4))){
var inst_21731 = (state_21767[(9)]);
var inst_21731__$1 = (state_21767[(2)]);
var inst_21732 = (inst_21731__$1 == null);
var inst_21733 = cljs.core.not(inst_21732);
var state_21767__$1 = (function (){var statearr_21772 = state_21767;
(statearr_21772[(9)] = inst_21731__$1);

return statearr_21772;
})();
if(inst_21733){
var statearr_21773_23135 = state_21767__$1;
(statearr_21773_23135[(1)] = (5));

} else {
var statearr_21774_23136 = state_21767__$1;
(statearr_21774_23136[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (15))){
var inst_21757 = (state_21767[(2)]);
var state_21767__$1 = state_21767;
var statearr_21775_23137 = state_21767__$1;
(statearr_21775_23137[(2)] = inst_21757);

(statearr_21775_23137[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (13))){
var state_21767__$1 = state_21767;
var statearr_21776_23138 = state_21767__$1;
(statearr_21776_23138[(2)] = null);

(statearr_21776_23138[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (6))){
var inst_21727 = (state_21767[(8)]);
var inst_21752 = inst_21727.length;
var inst_21753 = (inst_21752 > (0));
var state_21767__$1 = state_21767;
if(cljs.core.truth_(inst_21753)){
var statearr_21777_23139 = state_21767__$1;
(statearr_21777_23139[(1)] = (12));

} else {
var statearr_21778_23140 = state_21767__$1;
(statearr_21778_23140[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (3))){
var inst_21765 = (state_21767[(2)]);
var state_21767__$1 = state_21767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21767__$1,inst_21765);
} else {
if((state_val_21768 === (12))){
var inst_21727 = (state_21767[(8)]);
var inst_21755 = cljs.core.vec(inst_21727);
var state_21767__$1 = state_21767;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21767__$1,(15),out,inst_21755);
} else {
if((state_val_21768 === (2))){
var state_21767__$1 = state_21767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21767__$1,(4),ch);
} else {
if((state_val_21768 === (11))){
var inst_21731 = (state_21767[(9)]);
var inst_21735 = (state_21767[(10)]);
var inst_21745 = (state_21767[(2)]);
var inst_21746 = [];
var inst_21747 = inst_21746.push(inst_21731);
var inst_21727 = inst_21746;
var inst_21728 = inst_21735;
var state_21767__$1 = (function (){var statearr_21779 = state_21767;
(statearr_21779[(11)] = inst_21747);

(statearr_21779[(12)] = inst_21745);

(statearr_21779[(7)] = inst_21728);

(statearr_21779[(8)] = inst_21727);

return statearr_21779;
})();
var statearr_21780_23141 = state_21767__$1;
(statearr_21780_23141[(2)] = null);

(statearr_21780_23141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (9))){
var inst_21727 = (state_21767[(8)]);
var inst_21743 = cljs.core.vec(inst_21727);
var state_21767__$1 = state_21767;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21767__$1,(11),out,inst_21743);
} else {
if((state_val_21768 === (5))){
var inst_21731 = (state_21767[(9)]);
var inst_21728 = (state_21767[(7)]);
var inst_21735 = (state_21767[(10)]);
var inst_21735__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_21731) : f.call(null,inst_21731));
var inst_21736 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21735__$1,inst_21728);
var inst_21737 = cljs.core.keyword_identical_QMARK_(inst_21728,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21738 = ((inst_21736) || (inst_21737));
var state_21767__$1 = (function (){var statearr_21781 = state_21767;
(statearr_21781[(10)] = inst_21735__$1);

return statearr_21781;
})();
if(cljs.core.truth_(inst_21738)){
var statearr_21782_23142 = state_21767__$1;
(statearr_21782_23142[(1)] = (8));

} else {
var statearr_21783_23143 = state_21767__$1;
(statearr_21783_23143[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (14))){
var inst_21760 = (state_21767[(2)]);
var inst_21761 = cljs.core.async.close_BANG_(out);
var state_21767__$1 = (function (){var statearr_21785 = state_21767;
(statearr_21785[(13)] = inst_21760);

return statearr_21785;
})();
var statearr_21786_23144 = state_21767__$1;
(statearr_21786_23144[(2)] = inst_21761);

(statearr_21786_23144[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (10))){
var inst_21750 = (state_21767[(2)]);
var state_21767__$1 = state_21767;
var statearr_21787_23145 = state_21767__$1;
(statearr_21787_23145[(2)] = inst_21750);

(statearr_21787_23145[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21768 === (8))){
var inst_21731 = (state_21767[(9)]);
var inst_21735 = (state_21767[(10)]);
var inst_21727 = (state_21767[(8)]);
var inst_21740 = inst_21727.push(inst_21731);
var tmp21784 = inst_21727;
var inst_21727__$1 = tmp21784;
var inst_21728 = inst_21735;
var state_21767__$1 = (function (){var statearr_21788 = state_21767;
(statearr_21788[(7)] = inst_21728);

(statearr_21788[(8)] = inst_21727__$1);

(statearr_21788[(14)] = inst_21740);

return statearr_21788;
})();
var statearr_21789_23146 = state_21767__$1;
(statearr_21789_23146[(2)] = null);

(statearr_21789_23146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20124__auto__ = null;
var cljs$core$async$state_machine__20124__auto____0 = (function (){
var statearr_21790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21790[(0)] = cljs$core$async$state_machine__20124__auto__);

(statearr_21790[(1)] = (1));

return statearr_21790;
});
var cljs$core$async$state_machine__20124__auto____1 = (function (state_21767){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_21767);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e21791){var ex__20127__auto__ = e21791;
var statearr_21792_23147 = state_21767;
(statearr_21792_23147[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_21767[(4)]))){
var statearr_21793_23148 = state_21767;
(statearr_21793_23148[(1)] = cljs.core.first((state_21767[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23149 = state_21767;
state_21767 = G__23149;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
cljs$core$async$state_machine__20124__auto__ = function(state_21767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20124__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20124__auto____1.call(this,state_21767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20124__auto____0;
cljs$core$async$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20124__auto____1;
return cljs$core$async$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_21794 = f__20272__auto__();
(statearr_21794[(6)] = c__20271__auto___23132);

return statearr_21794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
