goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e22008){var e = e22008;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___22220 = arguments.length;
var i__4737__auto___22221 = (0);
while(true){
if((i__4737__auto___22221 < len__4736__auto___22220)){
args__4742__auto__.push((arguments[i__4737__auto___22221]));

var G__22222 = (i__4737__auto___22221 + (1));
i__4737__auto___22221 = G__22222;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__22026){
var vec__22027 = p__22026;
var map__22030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22027,(0),null);
var map__22030__$1 = (((((!((map__22030 == null))))?(((((map__22030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22030.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22030):map__22030);
var opts = map__22030__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22030__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22030__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22030__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22030__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__22041 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__22041__$1 = (((((!((map__22041 == null))))?(((((map__22041.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22041.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22041):map__22041);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22041__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22041__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__22013_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__22013_SHARP_);
}));

(web_socket.onclose = (function (p1__22014_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__22014_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__20271__auto___22238 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20272__auto__ = (function (){var switch__20123__auto__ = (function (state_22122){
var state_val_22123 = (state_22122[(1)]);
if((state_val_22123 === (7))){
var inst_22115 = (state_22122[(2)]);
var state_22122__$1 = state_22122;
var statearr_22131_22240 = state_22122__$1;
(statearr_22131_22240[(2)] = inst_22115);

(statearr_22131_22240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (20))){
var state_22122__$1 = state_22122;
var statearr_22132_22241 = state_22122__$1;
(statearr_22132_22241[(2)] = null);

(statearr_22132_22241[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (1))){
var inst_22047 = false;
var state_22122__$1 = (function (){var statearr_22133 = state_22122;
(statearr_22133[(7)] = inst_22047);

return statearr_22133;
})();
var statearr_22135_22246 = state_22122__$1;
(statearr_22135_22246[(2)] = null);

(statearr_22135_22246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (4))){
var inst_22065 = (state_22122[(8)]);
var inst_22056 = (state_22122[(9)]);
var inst_22063 = (state_22122[(10)]);
var inst_22063__$1 = (state_22122[(2)]);
var inst_22064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22063__$1,(0),null);
var inst_22065__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22063__$1,(1),null);
var inst_22067 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22065__$1,inst_22056);
var state_22122__$1 = (function (){var statearr_22138 = state_22122;
(statearr_22138[(8)] = inst_22065__$1);

(statearr_22138[(10)] = inst_22063__$1);

(statearr_22138[(11)] = inst_22064);

return statearr_22138;
})();
if(inst_22067){
var statearr_22139_22252 = state_22122__$1;
(statearr_22139_22252[(1)] = (5));

} else {
var statearr_22140_22253 = state_22122__$1;
(statearr_22140_22253[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (15))){
var inst_22099 = (state_22122[(2)]);
var state_22122__$1 = state_22122;
var statearr_22143_22255 = state_22122__$1;
(statearr_22143_22255[(2)] = inst_22099);

(statearr_22143_22255[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (21))){
var inst_22111 = (state_22122[(2)]);
var state_22122__$1 = state_22122;
var statearr_22145_22257 = state_22122__$1;
(statearr_22145_22257[(2)] = inst_22111);

(statearr_22145_22257[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (13))){
var state_22122__$1 = state_22122;
var statearr_22148_22262 = state_22122__$1;
(statearr_22148_22262[(2)] = null);

(statearr_22148_22262[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (6))){
var inst_22065 = (state_22122[(8)]);
var inst_22057 = (state_22122[(12)]);
var inst_22083 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22065,inst_22057);
var state_22122__$1 = state_22122;
if(inst_22083){
var statearr_22150_22267 = state_22122__$1;
(statearr_22150_22267[(1)] = (9));

} else {
var statearr_22151_22269 = state_22122__$1;
(statearr_22151_22269[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (17))){
var state_22122__$1 = state_22122;
var statearr_22154_22270 = state_22122__$1;
(statearr_22154_22270[(2)] = initial_ch);

(statearr_22154_22270[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (3))){
var inst_22117 = (state_22122[(2)]);
var state_22122__$1 = state_22122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22122__$1,inst_22117);
} else {
if((state_val_22123 === (12))){
var inst_22047 = (state_22122[(7)]);
var state_22122__$1 = state_22122;
if(cljs.core.truth_(inst_22047)){
var statearr_22161_22275 = state_22122__$1;
(statearr_22161_22275[(1)] = (16));

} else {
var statearr_22162_22276 = state_22122__$1;
(statearr_22162_22276[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (2))){
var inst_22056 = (state_22122[(9)]);
var inst_22057 = (state_22122[(12)]);
var inst_22056__$1 = open_ch;
var inst_22057__$1 = close_ch;
var inst_22059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22060 = [inst_22056__$1,inst_22057__$1];
var inst_22061 = (new cljs.core.PersistentVector(null,2,(5),inst_22059,inst_22060,null));
var state_22122__$1 = (function (){var statearr_22165 = state_22122;
(statearr_22165[(9)] = inst_22056__$1);

(statearr_22165[(12)] = inst_22057__$1);

return statearr_22165;
})();
return cljs.core.async.ioc_alts_BANG_(state_22122__$1,(4),inst_22061);
} else {
if((state_val_22123 === (19))){
var inst_22064 = (state_22122[(11)]);
var state_22122__$1 = state_22122;
var statearr_22167_22281 = state_22122__$1;
(statearr_22167_22281[(2)] = inst_22064);

(statearr_22167_22281[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (11))){
var inst_22113 = (state_22122[(2)]);
var state_22122__$1 = state_22122;
var statearr_22171_22286 = state_22122__$1;
(statearr_22171_22286[(2)] = inst_22113);

(statearr_22171_22286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (9))){
var inst_22089 = (state_22122[(13)]);
var inst_22063 = (state_22122[(10)]);
var inst_22088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22063,(0),null);
var inst_22089__$1 = chord.client.close_event__GT_maybe_error(inst_22088);
var state_22122__$1 = (function (){var statearr_22175 = state_22122;
(statearr_22175[(13)] = inst_22089__$1);

return statearr_22175;
})();
if(cljs.core.truth_(inst_22089__$1)){
var statearr_22179_22290 = state_22122__$1;
(statearr_22179_22290[(1)] = (12));

} else {
var statearr_22180_22293 = state_22122__$1;
(statearr_22180_22293[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (5))){
var inst_22063 = (state_22122[(10)]);
var inst_22074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22063,(0),null);
var inst_22075 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_22076 = [ws_chan];
var inst_22077 = cljs.core.PersistentHashMap.fromArrays(inst_22075,inst_22076);
var state_22122__$1 = (function (){var statearr_22184 = state_22122;
(statearr_22184[(14)] = inst_22074);

return statearr_22184;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22122__$1,(8),initial_ch,inst_22077);
} else {
if((state_val_22123 === (14))){
var inst_22102 = (state_22122[(2)]);
var inst_22103 = cljs.core.async.close_BANG_(ws_chan);
var inst_22104 = cljs.core.async.close_BANG_(initial_ch);
var state_22122__$1 = (function (){var statearr_22189 = state_22122;
(statearr_22189[(15)] = inst_22103);

(statearr_22189[(16)] = inst_22102);

return statearr_22189;
})();
var statearr_22190_22298 = state_22122__$1;
(statearr_22190_22298[(2)] = inst_22104);

(statearr_22190_22298[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (16))){
var state_22122__$1 = state_22122;
var statearr_22192_22301 = state_22122__$1;
(statearr_22192_22301[(2)] = read_ch__$1);

(statearr_22192_22301[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (10))){
var inst_22065 = (state_22122[(8)]);
var inst_22106 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22065,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_22122__$1 = state_22122;
if(inst_22106){
var statearr_22198_22304 = state_22122__$1;
(statearr_22198_22304[(1)] = (19));

} else {
var statearr_22199_22306 = state_22122__$1;
(statearr_22199_22306[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22123 === (18))){
var inst_22089 = (state_22122[(13)]);
var inst_22094 = (state_22122[(2)]);
var inst_22095 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22096 = [inst_22089];
var inst_22097 = cljs.core.PersistentHashMap.fromArrays(inst_22095,inst_22096);
var state_22122__$1 = state_22122;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22122__$1,(15),inst_22094,inst_22097);
} else {
if((state_val_22123 === (8))){
var inst_22079 = (state_22122[(2)]);
var inst_22080 = cljs.core.async.close_BANG_(initial_ch);
var inst_22047 = true;
var state_22122__$1 = (function (){var statearr_22202 = state_22122;
(statearr_22202[(17)] = inst_22080);

(statearr_22202[(18)] = inst_22079);

(statearr_22202[(7)] = inst_22047);

return statearr_22202;
})();
var statearr_22204_22313 = state_22122__$1;
(statearr_22204_22313[(2)] = null);

(statearr_22204_22313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__20124__auto__ = null;
var chord$client$state_machine__20124__auto____0 = (function (){
var statearr_22206 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22206[(0)] = chord$client$state_machine__20124__auto__);

(statearr_22206[(1)] = (1));

return statearr_22206;
});
var chord$client$state_machine__20124__auto____1 = (function (state_22122){
while(true){
var ret_value__20125__auto__ = (function (){try{while(true){
var result__20126__auto__ = switch__20123__auto__(state_22122);
if(cljs.core.keyword_identical_QMARK_(result__20126__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20126__auto__;
}
break;
}
}catch (e22207){var ex__20127__auto__ = e22207;
var statearr_22209_22320 = state_22122;
(statearr_22209_22320[(2)] = ex__20127__auto__);


if(cljs.core.seq((state_22122[(4)]))){
var statearr_22210_22321 = state_22122;
(statearr_22210_22321[(1)] = cljs.core.first((state_22122[(4)])));

} else {
throw ex__20127__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20125__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22322 = state_22122;
state_22122 = G__22322;
continue;
} else {
return ret_value__20125__auto__;
}
break;
}
});
chord$client$state_machine__20124__auto__ = function(state_22122){
switch(arguments.length){
case 0:
return chord$client$state_machine__20124__auto____0.call(this);
case 1:
return chord$client$state_machine__20124__auto____1.call(this,state_22122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__20124__auto____0;
chord$client$state_machine__20124__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__20124__auto____1;
return chord$client$state_machine__20124__auto__;
})()
})();
var state__20273__auto__ = (function (){var statearr_22213 = f__20272__auto__();
(statearr_22213[(6)] = c__20271__auto___22238);

return statearr_22213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20273__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq22016){
var G__22017 = cljs.core.first(seq22016);
var seq22016__$1 = cljs.core.next(seq22016);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22017,seq22016__$1);
}));


//# sourceMappingURL=chord.client.js.map
