goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5720__auto__ = (function (){var fexpr__45695 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__45695.cljs$core$IFn$_invoke$arity$1 ? fexpr__45695.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__45695.call(null,channel));
})();
if(cljs.core.truth_(temp__5720__auto__)){
var req = temp__5720__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__45697){
var vec__45698 = p__45697;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45698,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45698,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__45701 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__45701)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__45701)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__45701)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__45701)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__45701)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__45701)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45701)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__45704){
var map__45705 = p__45704;
var map__45705__$1 = (((((!((map__45705 == null))))?(((((map__45705.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45705.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45705):map__45705);
var request = map__45705__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45705__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45705__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45705__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__45713 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__45713,default_headers);

cljs_http.core.apply_response_type_BANG_(G__45713,response_type);

G__45713.setTimeoutInterval(timeout);

G__45713.setWithCredentials(send_credentials);

return G__45713;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__45717){
var map__45718 = p__45717;
var map__45718__$1 = (((((!((map__45718 == null))))?(((((map__45718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45718):map__45718);
var request = map__45718__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45718__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__45724 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__45724) : cljs_http.core.error_kw.call(null,G__45724));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_45833 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__45725_45834 = xhr;
G__45725_45834.setProgressEventsEnabled(true);

G__45725_45834.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_45833,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__45725_45834.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_45833,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__41778__auto___45835 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_45739){
var state_val_45740 = (state_45739[(1)]);
if((state_val_45740 === (1))){
var state_45739__$1 = state_45739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45739__$1,(2),cancel);
} else {
if((state_val_45740 === (2))){
var inst_45729 = (state_45739[(2)]);
var inst_45730 = xhr.isComplete();
var inst_45731 = cljs.core.not(inst_45730);
var state_45739__$1 = (function (){var statearr_45748 = state_45739;
(statearr_45748[(7)] = inst_45729);

return statearr_45748;
})();
if(inst_45731){
var statearr_45751_45836 = state_45739__$1;
(statearr_45751_45836[(1)] = (3));

} else {
var statearr_45752_45837 = state_45739__$1;
(statearr_45752_45837[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45740 === (3))){
var inst_45733 = xhr.abort();
var state_45739__$1 = state_45739;
var statearr_45753_45838 = state_45739__$1;
(statearr_45753_45838[(2)] = inst_45733);

(statearr_45753_45838[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45740 === (4))){
var state_45739__$1 = state_45739;
var statearr_45756_45839 = state_45739__$1;
(statearr_45756_45839[(2)] = null);

(statearr_45756_45839[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45740 === (5))){
var inst_45736 = (state_45739[(2)]);
var state_45739__$1 = state_45739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45739__$1,inst_45736);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__41689__auto__ = null;
var cljs_http$core$xhr_$_state_machine__41689__auto____0 = (function (){
var statearr_45761 = [null,null,null,null,null,null,null,null];
(statearr_45761[(0)] = cljs_http$core$xhr_$_state_machine__41689__auto__);

(statearr_45761[(1)] = (1));

return statearr_45761;
});
var cljs_http$core$xhr_$_state_machine__41689__auto____1 = (function (state_45739){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_45739);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e45765){if((e45765 instanceof Object)){
var ex__41692__auto__ = e45765;
var statearr_45766_45842 = state_45739;
(statearr_45766_45842[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45739);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45765;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45843 = state_45739;
state_45739 = G__45843;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__41689__auto__ = function(state_45739){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__41689__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__41689__auto____1.call(this,state_45739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__41689__auto____0;
cljs_http$core$xhr_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__41689__auto____1;
return cljs_http$core$xhr_$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_45772 = f__41779__auto__();
(statearr_45772[(6)] = c__41778__auto___45835);

return statearr_45772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__45780){
var map__45783 = p__45780;
var map__45783__$1 = (((((!((map__45783 == null))))?(((((map__45783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45783.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45783):map__45783);
var request = map__45783__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45783__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45783__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45783__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__45783__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_45847 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_45847], null));

if(cljs.core.truth_(cancel)){
var c__41778__auto___45849 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_45802){
var state_val_45803 = (state_45802[(1)]);
if((state_val_45803 === (1))){
var state_45802__$1 = state_45802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45802__$1,(2),cancel);
} else {
if((state_val_45803 === (2))){
var inst_45797 = (state_45802[(2)]);
var inst_45798 = jsonp.cancel(req_45847);
var state_45802__$1 = (function (){var statearr_45807 = state_45802;
(statearr_45807[(7)] = inst_45797);

return statearr_45807;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45802__$1,inst_45798);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__41689__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__41689__auto____0 = (function (){
var statearr_45813 = [null,null,null,null,null,null,null,null];
(statearr_45813[(0)] = cljs_http$core$jsonp_$_state_machine__41689__auto__);

(statearr_45813[(1)] = (1));

return statearr_45813;
});
var cljs_http$core$jsonp_$_state_machine__41689__auto____1 = (function (state_45802){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_45802);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e45814){if((e45814 instanceof Object)){
var ex__41692__auto__ = e45814;
var statearr_45815_45852 = state_45802;
(statearr_45815_45852[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_45802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45814;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45853 = state_45802;
state_45802 = G__45853;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__41689__auto__ = function(state_45802){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__41689__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__41689__auto____1.call(this,state_45802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__41689__auto____0;
cljs_http$core$jsonp_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__41689__auto____1;
return cljs_http$core$jsonp_$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_45821 = f__41779__auto__();
(statearr_45821[(6)] = c__41778__auto___45849);

return statearr_45821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__45825){
var map__45827 = p__45825;
var map__45827__$1 = (((((!((map__45827 == null))))?(((((map__45827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45827):map__45827);
var request = map__45827__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45827__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
