import "./cljs_env.js";
shadow$provide.module$node_modules$topojson_client$dist$topojson_client=function(global$jscomp$0,require,module,exports$jscomp$0){(function(global,factory){"object"===typeof exports$jscomp$0&&"undefined"!==typeof module?factory(exports$jscomp$0):"function"===typeof define&&define.amd?define(["exports"],factory):(global=global||self,factory(global.topojson=global.topojson||{}))})(this,function(exports){function identity(x){return x}function transform$jscomp$0(transform){if(null==transform)return identity;
var x0,y0,kx=transform.scale[0],ky=transform.scale[1],dx=transform.translate[0],dy=transform.translate[1];return function(input,i){i||(x0=y0=0);i=2;var n=input.length,output=Array(n);output[0]=(x0+=input[0])*kx+dx;for(output[1]=(y0+=input[1])*ky+dy;i<n;)output[i]=input[i],++i;return output}}function bbox$jscomp$0(topology){function bboxPoint(p){p=t(p);p[0]<x0&&(x0=p[0]);p[0]>x1&&(x1=p[0]);p[1]<y0&&(y0=p[1]);p[1]>y1&&(y1=p[1])}function bboxGeometry(o){switch(o.type){case "GeometryCollection":o.geometries.forEach(bboxGeometry);
break;case "Point":bboxPoint(o.coordinates);break;case "MultiPoint":o.coordinates.forEach(bboxPoint)}}var t=transform$jscomp$0(topology.transform),key,x0=Infinity,y0=x0,x1=-x0,y1=-x0;topology.arcs.forEach(function(arc){for(var i=-1,n=arc.length,p;++i<n;)p=t(arc[i],i),p[0]<x0&&(x0=p[0]),p[0]>x1&&(x1=p[0]),p[1]<y0&&(y0=p[1]),p[1]>y1&&(y1=p[1])});for(key in topology.objects)bboxGeometry(topology.objects[key]);return[x0,y0,x1,y1]}function feature$1(topology,o){var id=o.id,bbox=o.bbox,properties=null==
o.properties?{}:o.properties;topology=object$jscomp$0(topology,o);return null==id&&null==bbox?{type:"Feature",properties,geometry:topology}:null==bbox?{type:"Feature",id,properties,geometry:topology}:{type:"Feature",id,bbox,properties,geometry:topology}}function object$jscomp$0(topology,o$jscomp$0){function point(p){return transformPoint(p)}function line(arcs$jscomp$0){for(var points=[],i=0,n=arcs$jscomp$0.length;i<n;++i){var i$jscomp$0=arcs$jscomp$0[i],points$jscomp$0=points;points$jscomp$0.length&&
points$jscomp$0.pop();for(var a=arcs[0>i$jscomp$0?~i$jscomp$0:i$jscomp$0],k=0,n$jscomp$0=a.length;k<n$jscomp$0;++k)points$jscomp$0.push(transformPoint(a[k],k));if(0>i$jscomp$0)for(i$jscomp$0=points$jscomp$0,points$jscomp$0=i$jscomp$0.length,a=points$jscomp$0-n$jscomp$0;a<--points$jscomp$0;)n$jscomp$0=i$jscomp$0[a],i$jscomp$0[a++]=i$jscomp$0[points$jscomp$0],i$jscomp$0[points$jscomp$0]=n$jscomp$0}2>points.length&&points.push(points[0]);return points}function ring(arcs){for(arcs=line(arcs);4>arcs.length;)arcs.push(arcs[0]);
return arcs}function polygon(arcs){return arcs.map(ring)}function geometry(o){var type=o.type;switch(type){case "GeometryCollection":return{type,geometries:o.geometries.map(geometry)};case "Point":o=transformPoint(o.coordinates);break;case "MultiPoint":o=o.coordinates.map(point);break;case "LineString":o=line(o.arcs);break;case "MultiLineString":o=o.arcs.map(line);break;case "Polygon":o=polygon(o.arcs);break;case "MultiPolygon":o=o.arcs.map(polygon);break;default:return null}return{type,coordinates:o}}
var transformPoint=transform$jscomp$0(topology.transform),arcs=topology.arcs;return geometry(o$jscomp$0)}function stitch(topology,arcs){function ends(i){var arc=topology.arcs[0>i?~i:i],p0=arc[0];if(topology.transform){var p1=[0,0];arc.forEach(function(dp){p1[0]+=dp[0];p1[1]+=dp[1]})}else p1=arc[arc.length-1];return 0>i?[p1,p0]:[p0,p1]}function flush(fragmentByEnd,fragmentByStart){for(var k in fragmentByEnd){var f=fragmentByEnd[k];delete fragmentByStart[f.start];delete f.start;delete f.end;f.forEach(function(i){stitchedArcs[0>
i?~i:i]=1});fragments.push(f)}}var stitchedArcs={},fragmentByStart={},fragmentByEnd={},fragments=[],emptyIndex=-1;arcs.forEach(function(i,j){var arc=topology.arcs[0>i?~i:i];3>arc.length&&!arc[1][0]&&!arc[1][1]&&(arc=arcs[++emptyIndex],arcs[emptyIndex]=i,arcs[j]=arc)});arcs.forEach(function(i){var e=ends(i),start=e[0],end=e[1];(e=fragmentByEnd[start])?(delete fragmentByEnd[e.end],e.push(i),e.end=end,(i=fragmentByStart[end])?(delete fragmentByStart[i.start],start=i===e?e:e.concat(i),fragmentByStart[start.start=
e.start]=fragmentByEnd[start.end=i.end]=start):fragmentByStart[e.start]=fragmentByEnd[e.end]=e):(e=fragmentByStart[end])?(delete fragmentByStart[e.start],e.unshift(i),e.start=start,(i=fragmentByEnd[start])?(delete fragmentByEnd[i.end],start=i===e?e:i.concat(e),fragmentByStart[start.start=i.start]=fragmentByEnd[start.end=e.end]=start):fragmentByStart[e.start]=fragmentByEnd[e.end]=e):(e=[i],fragmentByStart[e.start=start]=fragmentByEnd[e.end=end]=e)});flush(fragmentByEnd,fragmentByStart);flush(fragmentByStart,
fragmentByEnd);arcs.forEach(function(i){stitchedArcs[0>i?~i:i]||fragments.push([i])});return fragments}function meshArcs(topology,object,filter){var n;if(1<arguments.length)var arcs=extractArcs(topology,object,filter);else{var i=0;for(arcs=Array(n=topology.arcs.length);i<n;++i)arcs[i]=i}return{type:"MultiLineString",arcs:stitch(topology,arcs)}}function extractArcs(topology,object,filter){function extract0(i){var j=0>i?~i:i;(geomsByArc[j]||(geomsByArc[j]=[])).push({i,g:geom})}function extract1(arcs){arcs.forEach(extract0)}
function extract2(arcs){arcs.forEach(extract1)}function geometry(o){switch(geom=o,o.type){case "GeometryCollection":o.geometries.forEach(geometry);break;case "LineString":extract1(o.arcs);break;case "MultiLineString":case "Polygon":extract2(o.arcs);break;case "MultiPolygon":o.arcs.forEach(extract2)}}var arcs$jscomp$0=[],geomsByArc=[],geom;geometry(object);geomsByArc.forEach(null==filter?function(geoms){arcs$jscomp$0.push(geoms[0].i)}:function(geoms){filter(geoms[0].g,geoms[geoms.length-1].g)&&arcs$jscomp$0.push(geoms[0].i)});
return arcs$jscomp$0}function mergeArcs(topology,objects){function geometry(o){switch(o.type){case "GeometryCollection":o.geometries.forEach(geometry);break;case "Polygon":extract(o.arcs);break;case "MultiPolygon":o.arcs.forEach(extract)}}function extract(polygon){polygon.forEach(function(ring){ring.forEach(function(arc){(polygonsByArc[arc=0>arc?~arc:arc]||(polygonsByArc[arc]=[])).push(polygon)})});polygons.push(polygon)}function area$jscomp$0(ring){ring=object$jscomp$0(topology,{type:"Polygon",arcs:[ring]}).coordinates[0];
for(var i=-1,n=ring.length,a,b=ring[n-1],area=0;++i<n;)a=b,b=ring[i],area+=a[0]*b[1]-a[1]*b[0];return Math.abs(area)}var polygonsByArc={},polygons=[],groups=[];objects.forEach(geometry);polygons.forEach(function(polygon$jscomp$0){if(!polygon$jscomp$0._){var group=[],neighbors=[polygon$jscomp$0];polygon$jscomp$0._=1;for(groups.push(group);polygon$jscomp$0=neighbors.pop();)group.push(polygon$jscomp$0),polygon$jscomp$0.forEach(function(ring){ring.forEach(function(arc){polygonsByArc[0>arc?~arc:arc].forEach(function(polygon){polygon._||
(polygon._=1,neighbors.push(polygon))})})})}});polygons.forEach(function(polygon){delete polygon._});return{type:"MultiPolygon",arcs:groups.map(function(polygons){var arcs=[];polygons.forEach(function(polygon){polygon.forEach(function(ring){ring.forEach(function(arc){2>polygonsByArc[0>arc?~arc:arc].length&&arcs.push(arc)})})});arcs=stitch(topology,arcs);if(1<(polygons=arcs.length))for(var i=1,k=area$jscomp$0(arcs[0]),ki;i<polygons;++i)(ki=area$jscomp$0(arcs[i]))>k&&(k=arcs[0],arcs[0]=arcs[i],arcs[i]=
k,k=ki);return arcs}).filter(function(arcs){return 0<arcs.length})}}function bisect(a,x){for(var lo=0,hi=a.length;lo<hi;){var mid=lo+hi>>>1;a[mid]<x?lo=mid+1:hi=mid}return lo}function untransform(transform){if(null==transform)return identity;var x0,y0,kx=transform.scale[0],ky=transform.scale[1],dx=transform.translate[0],dy=transform.translate[1];return function(input,i){i||(x0=y0=0);i=2;var n=input.length,output=Array(n),x1=Math.round((input[0]-dx)/kx),y1=Math.round((input[1]-dy)/ky);output[0]=x1-
x0;x0=x1;output[1]=y1-y0;for(y0=y1;i<n;)output[i]=input[i],++i;return output}}exports.bbox=bbox$jscomp$0;exports.feature=function(topology,o$jscomp$0){"string"===typeof o$jscomp$0&&(o$jscomp$0=topology.objects[o$jscomp$0]);return"GeometryCollection"===o$jscomp$0.type?{type:"FeatureCollection",features:o$jscomp$0.geometries.map(function(o){return feature$1(topology,o)})}:feature$1(topology,o$jscomp$0)};exports.merge=function(topology){return object$jscomp$0(topology,mergeArcs.apply(this,arguments))};
exports.mergeArcs=mergeArcs;exports.mesh=function(topology){return object$jscomp$0(topology,meshArcs.apply(this,arguments))};exports.meshArcs=meshArcs;exports.neighbors=function(objects){function line(arcs,i){arcs.forEach(function(a){0>a&&(a=~a);var o=indexesByArc[a];o?o.push(i):indexesByArc[a]=[i]})}function polygon(arcs,i){arcs.forEach(function(arc){line(arc,i)})}function geometry(o$jscomp$0,i){if("GeometryCollection"===o$jscomp$0.type)o$jscomp$0.geometries.forEach(function(o){geometry(o,i)});else if(o$jscomp$0.type in
geometryType)geometryType[o$jscomp$0.type](o$jscomp$0.arcs,i)}var indexesByArc={},neighbors=objects.map(function(){return[]}),geometryType={LineString:line,MultiLineString:polygon,Polygon:polygon,MultiPolygon:function(arcs,i){arcs.forEach(function(arc){polygon(arc,i)})}};objects.forEach(geometry);for(var i$jscomp$0 in indexesByArc){objects=indexesByArc[i$jscomp$0];for(var m=objects.length,j=0;j<m;++j)for(var k=j+1;k<m;++k){var ij=objects[j],ik=objects[k],n;(n=neighbors[ij])[i$jscomp$0=bisect(n,ik)]!==
ik&&n.splice(i$jscomp$0,0,ik);(n=neighbors[ik])[i$jscomp$0=bisect(n,ij)]!==ij&&n.splice(i$jscomp$0,0,ij)}}return neighbors};exports.quantize=function(topology,transform){function quantizePoint(point){return t(point)}function quantizeGeometry(input){switch(input.type){case "GeometryCollection":var output={type:"GeometryCollection",geometries:input.geometries.map(quantizeGeometry)};break;case "Point":output={type:"Point",coordinates:t(input.coordinates)};break;case "MultiPoint":output={type:"MultiPoint",
coordinates:input.coordinates.map(quantizePoint)};break;default:return input}null!=input.id&&(output.id=input.id);null!=input.bbox&&(output.bbox=input.bbox);null!=input.properties&&(output.properties=input.properties);return output}if(topology.transform)throw Error("already quantized");if(transform&&transform.scale)var box=topology.bbox;else{if(!(2<=(n$jscomp$0=Math.floor(transform))))throw Error("n must be ≥2");box=topology.bbox||bbox$jscomp$0(topology);transform=box[0];var y0=box[1],x1=box[2],y1=
box[3],n$jscomp$0;transform={scale:[x1-transform?(x1-transform)/(n$jscomp$0-1):1,y1-y0?(y1-y0)/(n$jscomp$0-1):1],translate:[transform,y0]}}var t=untransform(transform),key;y0=topology.objects;x1={};for(key in y0)x1[key]=quantizeGeometry(y0[key]);return{type:"Topology",bbox:box,transform,objects:x1,arcs:topology.arcs.map(function(input){var i=0,j=1,n=input.length,p,output=Array(n);for(output[0]=t(input[0],0);++i<n;)if((p=t(input[i],i))[0]||p[1])output[j++]=p;1===j&&(output[j++]=[0,0]);output.length=
j;return output})}};exports.transform=transform$jscomp$0;exports.untransform=untransform;Object.defineProperty(exports,"__esModule",{value:!0})})}
//# sourceMappingURL=module$node_modules$topojson_client$dist$topojson_client.js.map
