import "./cljs_env.js";
shadow$provide.module$node_modules$vega_functions$build$vega_functions=function(global$jscomp$0,require,module,exports$jscomp$0){(function(global,factory){"object"===typeof exports$jscomp$0&&"undefined"!==typeof module?factory(exports$jscomp$0,require("module$node_modules$vega_util$build$vega_util"),require("module$node_modules$vega_expression$build$vega_expression"),require("module$node_modules$d3_geo$dist$d3_geo"),require("module$node_modules$d3_color$dist$d3_color"),require("module$node_modules$vega_dataflow$build$vega_dataflow"),
require("module$node_modules$vega_scale$build$vega_scale"),require("module$node_modules$vega_scenegraph$build$vega_scenegraph"),require("module$node_modules$vega_selections$build$vega_selections"),require("module$node_modules$vega_statistics$build$vega_statistics"),require("module$node_modules$vega_time$build$vega_time"),require("module$node_modules$d3_array$dist$d3_array")):"function"===typeof define&&define.amd?define("exports vega-util vega-expression d3-geo d3-color vega-dataflow vega-scale vega-scenegraph vega-selections vega-statistics vega-time d3-array".split(" "),
factory):(global=global||self,factory(global.vega={},global.vega,global.vega,global.d3,global.d3,global.vega,global.vega,global.vega,global.vega,global.vega,global.vega,global.d3))})(this,function(exports,vegaUtil,vegaExpression,d3Geo,d3Color,vegaDataflow,vegaScale,vegaScenegraph,vegaSelections,vegaStatistics,vegaTime,d3Array){function data$jscomp$0(name){return(name=this.context.data[name])?name.values.value:[]}function indata(name,field,value){return(value=(name=this.context.data[name]["index:"+
field])?name.value.get(value):void 0)?value.count:value}function setdata(name,tuples){const df=this.context.dataflow;df.pulse(this.context.data[name].input,df.changeset().remove(vegaUtil.truthy).insert(tuples));return 1}function encode(item,name,retval){if(item){const df=this.context.dataflow;df.pulse(item.mark.source,df.changeset().encode(item,name))}return void 0!==retval?retval:item}function time(month,day,specifier){if(!Number.isInteger(month)||!Number.isInteger(day))return"";dateObj.setYear(2E3);
dateObj.setMonth(month);dateObj.setDate(day);return timeFormat.call(this,dateObj,specifier)}function monthFormat(month){return time.call(this,month,1,"%B")}function monthAbbrevFormat(month){return time.call(this,month,1,"%b")}function dayFormat(day){return time.call(this,0,2+day,"%A")}function dayAbbrevFormat(day){return time.call(this,0,2+day,"%a")}function dataVisitor(name,args,scope,params){args[0].type!==vegaExpression.Literal&&vegaUtil.error("First argument to data functions must be a string literal.");
name=args[0].value;args=":"+name;if(!vegaUtil.hasOwnProperty(args,params))try{params[args]=scope.getData(name).tuplesRef()}catch(err){}}function indataVisitor(name,args,scope,params){args[0].type!==vegaExpression.Literal&&vegaUtil.error("First argument to indata must be a string literal.");args[1].type!==vegaExpression.Literal&&vegaUtil.error("Second argument to indata must be a string literal.");name=args[0].value;args=args[1].value;const indexName="@"+args;vegaUtil.hasOwnProperty(indexName,params)||
(params[indexName]=scope.getData(name).indataRef(scope,args))}function scaleVisitor(name,args,scope,params){if(args[0].type===vegaExpression.Literal)addScaleDependency(scope,params,args[0].value);else for(name in scope.scales)addScaleDependency(scope,params,name)}function addScaleDependency(scope,params,name){const scaleName="%"+name;if(!vegaUtil.hasOwnProperty(params,scaleName))try{params[scaleName]=scope.scaleRef(name)}catch(err){}}function getScale(name,ctx){let s;return vegaUtil.isFunction(name)?
name:vegaUtil.isString(name)?(s=ctx.scales[name])&&s.value:void 0}function internalScaleFunctions(codegen,fnctx,visitors){fnctx.__bandwidth=s=>s&&s.bandwidth?s.bandwidth():0;visitors._bandwidth=scaleVisitor;visitors._range=scaleVisitor;visitors._scale=scaleVisitor;const ref=arg=>"_["+(arg.type===vegaExpression.Literal?vegaUtil.stringValue("%"+arg.value):vegaUtil.stringValue("%")+"+"+codegen(arg))+"]";return{_bandwidth:args=>`this.__bandwidth(${ref(args[0])})`,_range:args=>`${ref(args[0])}.range()`,
_scale:args=>`${ref(args[0])}(${codegen(args[1])})`}}function geoMethod(methodName,globalMethod){return function(projection,geojson,group){return projection?(projection=getScale(projection,(group||this).context))&&projection.path[methodName](geojson):globalMethod(geojson)}}function inScope(item){let group=this.context.group,value=!1;if(group)for(;item;){if(item===group){value=!0;break}item=item.mark.group}return value}function log(df,method,args){try{df[method].apply(df,["EXPRESSION"].concat([].slice.call(args)))}catch(err){df.warn(err)}return args[args.length-
1]}function warn(){return log(this.context.dataflow,"warn",arguments)}function info(){return log(this.context.dataflow,"info",arguments)}function debug(){return log(this.context.dataflow,"debug",arguments)}function channel_luminance_value(channelValue){channelValue/=255;return.03928>=channelValue?channelValue/12.92:Math.pow((channelValue+.055)/1.055,2.4)}function luminance(color){var c=d3Color.rgb(color);color=channel_luminance_value(c.r);const g=channel_luminance_value(c.g);c=channel_luminance_value(c.b);
return.2126*color+.7152*g+.0722*c}function contrast(color1,color2){color1=luminance(color1);color2=luminance(color2);return(Math.max(color1,color2)+.05)/(Math.min(color1,color2)+.05)}function merge(){var args=[].slice.call(arguments);args.unshift({});return vegaUtil.extend.apply(null,args)}function equal(a,b){if(a===b||a!==a&&b!==b)a=!0;else if(vegaUtil.isArray(a))if(vegaUtil.isArray(b)&&a.length===b.length)a:{for(let i=0,n=a.length;i<n;++i)if(!equal(a[i],b[i])){a=!1;break a}a=!0}else a=!1;else a=
vegaUtil.isObject(a)&&vegaUtil.isObject(b)?equalObject(a,b):!1;return a}function equalObject(a,b){for(let key in a)if(!equal(a[key],b[key]))return!1;return!0}function removePredicate(props){return _=>equalObject(props,_)}function modify$jscomp$0(name,insert,remove,toggle,modify,values){let df=this.context.dataflow,data=this.context.data[name],input=data.input,changes=data.changes;name=df.stamp();let key;if(!1===df._trigger||!(input.value.length||insert||toggle))return 0;if(!changes||changes.stamp<
name)data.changes=changes=df.changeset(),changes.stamp=name,df.runAfter(function(){data.modified=!0;df.pulse(input,changes).run()},!0,1);remove&&(remove=!0===remove?vegaUtil.truthy:vegaUtil.isArray(remove)||vegaDataflow.isTuple(remove)?remove:removePredicate(remove),changes.remove(remove));insert&&changes.insert(insert);toggle&&(remove=removePredicate(toggle),input.value.some(remove)?changes.remove(remove):changes.insert(toggle));if(modify)for(key in values)changes.modify(modify,key,values[key]);
return 1}function pinchDistance(event){var t=event.touches;event=t[0].clientX-t[1].clientX;t=t[0].clientY-t[1].clientY;return Math.sqrt(event*event+t*t)}function pinchAngle(event){event=event.touches;return Math.atan2(event[0].clientY-event[1].clientY,event[0].clientX-event[1].clientX)}function bandspace(count,paddingInner,paddingOuter){return vegaScale.bandSpace(count||0,paddingInner||0,paddingOuter||0)}function bandwidth(name,group){return(name=getScale(name,(group||this).context))&&name.bandwidth?
name.bandwidth():0}function copy(name,group){return(name=getScale(name,(group||this).context))?name.copy():void 0}function domain(name,group){return(name=getScale(name,(group||this).context))?name.domain():[]}function invert(name,range,group){return(name=getScale(name,(group||this).context))?vegaUtil.isArray(range)?(name.invertRange||name.invert)(range):(name.invert||name.invertExtent)(range):void 0}function range$jscomp$0(name,group){return(name=getScale(name,(group||this).context))&&name.range?
name.range():[]}function scale$jscomp$0(name,value,group){return(name=getScale(name,(group||this).context))?name(value):void 0}function scaleGradient(scale,p0,p1,count,group){scale=getScale(scale,(group||this).context);const gradient=vegaScenegraph.Gradient(p0,p1);p0=scale.domain();p1=p0[0];group=vegaUtil.peek(p0);let fraction=vegaUtil.identity;group-p1?fraction=vegaScale.scaleFraction(scale,p1,group):scale=(scale.interpolator?vegaScale.scale("sequential")().interpolator(scale.interpolator()):vegaScale.scale("linear")().interpolate(scale.interpolate()).range(scale.range())).domain([p1=
0,group=1]);scale.ticks&&(p0=scale.ticks(+count||15),p1!==p0[0]&&p0.unshift(p1),group!==vegaUtil.peek(p0)&&p0.push(group));p0.forEach(_=>gradient.stop(fraction(_),scale(_)));return gradient}function geoShape(projection,geojson,group){const p=getScale(projection,(group||this).context);return function(context){return p?p.path.context(context)(geojson):""}}function pathShape(path){let p=null;return function(context){return context?vegaScenegraph.pathRender(context,p=p||vegaScenegraph.pathParse(path)):
path}}function treeNodes(name,context){name=data$jscomp$0.call(context,name);return name.root&&name.root.lookup||{}}function treePath(name,source,target){name=treeNodes(name,this);source=name[source];target=name[target];return source&&target?source.path(target).map(datum):void 0}function treeAncestors(name,node){return(name=treeNodes(name,this)[node])?name.ancestors().map(datum):void 0}function screen(){const w="undefined"!==typeof window&&window||null;return w?w.screen:{}}function windowSize(){const w=
"undefined"!==typeof window&&window||null;return w?[w.innerWidth,w.innerHeight]:[void 0,void 0]}function containerSize(){var view=this.context.dataflow;return(view=view.container&&view.container())?[view.clientWidth,view.clientHeight]:[void 0,void 0]}function filter(opt){let p=null;if(opt){const types=vegaUtil.array(opt.marktype),names=vegaUtil.array(opt.markname);p=_=>(!types.length||types.some(t=>_.marktype===t))&&(!names.length||names.some(s=>_.name===s))}return p}function expressionFunction(name,
fn,visitor){if(1===arguments.length)return functionContext[name];functionContext[name]=fn;visitor&&(astVisitors[name]=visitor);codeGenerator&&(codeGenerator.functions[name]="this."+name);return this}var wrap=method=>function(value,spec){return this.context.dataflow.locale()[method](spec)(value)};const format=wrap("format"),timeFormat=wrap("timeFormat"),utcFormat=wrap("utcFormat"),timeParse=wrap("timeParse");wrap=wrap("utcParse");var dateObj=new Date(2E3,0,1);const geoArea=geoMethod("area",d3Geo.geoArea),
geoBounds=geoMethod("bounds",d3Geo.geoBounds);d3Geo=geoMethod("centroid",d3Geo.geoCentroid);const datum=d=>d.data,functionContext={random:function(){return vegaStatistics.random()},cumulativeNormal:vegaStatistics.cumulativeNormal,cumulativeLogNormal:vegaStatistics.cumulativeLogNormal,cumulativeUniform:vegaStatistics.cumulativeUniform,densityNormal:vegaStatistics.densityNormal,densityLogNormal:vegaStatistics.densityLogNormal,densityUniform:vegaStatistics.densityUniform,quantileNormal:vegaStatistics.quantileNormal,
quantileLogNormal:vegaStatistics.quantileLogNormal,quantileUniform:vegaStatistics.quantileUniform,sampleNormal:vegaStatistics.sampleNormal,sampleLogNormal:vegaStatistics.sampleLogNormal,sampleUniform:vegaStatistics.sampleUniform,isArray:vegaUtil.isArray,isBoolean:vegaUtil.isBoolean,isDate:vegaUtil.isDate,isDefined:function(_){return void 0!==_},isNumber:vegaUtil.isNumber,isObject:vegaUtil.isObject,isRegExp:vegaUtil.isRegExp,isString:vegaUtil.isString,isTuple:vegaDataflow.isTuple,isValid:function(_){return null!=
_&&_===_},toBoolean:vegaUtil.toBoolean,toDate:vegaUtil.toDate,toNumber:vegaUtil.toNumber,toString:vegaUtil.toString,flush:vegaUtil.flush,lerp:vegaUtil.lerp,merge,pad:vegaUtil.pad,peek:vegaUtil.peek,span:vegaUtil.span,inrange:vegaUtil.inrange,truncate:vegaUtil.truncate,rgb:d3Color.rgb,lab:d3Color.lab,hcl:d3Color.hcl,hsl:d3Color.hsl,luminance,contrast,sequence:d3Array.range,format,utcFormat,utcParse:wrap,utcOffset:vegaTime.utcOffset,utcSequence:vegaTime.utcSequence,timeFormat,timeParse,timeOffset:vegaTime.timeOffset,
timeSequence:vegaTime.timeSequence,timeUnitSpecifier:vegaTime.timeUnitSpecifier,monthFormat,monthAbbrevFormat,dayFormat,dayAbbrevFormat,quarter:vegaUtil.quarter,utcquarter:vegaUtil.utcquarter,week:vegaTime.week,utcweek:vegaTime.utcweek,dayofyear:vegaTime.dayofyear,utcdayofyear:vegaTime.utcdayofyear,warn,info,debug,extent:vegaUtil.extent,inScope,intersect:function(b,opt,group){if(!b)return[];const [u,v]=b;b=(new vegaScenegraph.Bounds).set(u[0],u[1],v[0],v[1]);group=group||this.context.dataflow.scenegraph().root;
return vegaScenegraph.intersect(group,b,filter(opt))},clampRange:vegaUtil.clampRange,pinchDistance,pinchAngle,screen,containerSize,windowSize,bandspace,setdata,pathShape,panLinear:vegaUtil.panLinear,panLog:vegaUtil.panLog,panPow:vegaUtil.panPow,panSymlog:vegaUtil.panSymlog,zoomLinear:vegaUtil.zoomLinear,zoomLog:vegaUtil.zoomLog,zoomPow:vegaUtil.zoomPow,zoomSymlog:vegaUtil.zoomSymlog,encode,modify:modify$jscomp$0},eventFunctions="view item group xy x y".split(" "),astVisitors={};expressionFunction("bandwidth",
bandwidth,scaleVisitor);expressionFunction("copy",copy,scaleVisitor);expressionFunction("domain",domain,scaleVisitor);expressionFunction("range",range$jscomp$0,scaleVisitor);expressionFunction("invert",invert,scaleVisitor);expressionFunction("scale",scale$jscomp$0,scaleVisitor);expressionFunction("gradient",scaleGradient,scaleVisitor);expressionFunction("geoArea",geoArea,scaleVisitor);expressionFunction("geoBounds",geoBounds,scaleVisitor);expressionFunction("geoCentroid",d3Geo,scaleVisitor);expressionFunction("geoShape",
geoShape,scaleVisitor);expressionFunction("indata",indata,indataVisitor);expressionFunction("data",data$jscomp$0,dataVisitor);expressionFunction("treePath",treePath,dataVisitor);expressionFunction("treeAncestors",treeAncestors,dataVisitor);expressionFunction("vlSelectionTest",vegaSelections.selectionTest,vegaSelections.selectionVisitor);expressionFunction("vlSelectionResolve",vegaSelections.selectionResolve,vegaSelections.selectionVisitor);const codegenParams={blacklist:["_"],whitelist:["datum","event",
"item"],fieldvar:"datum",globalvar:id=>"_["+vegaUtil.stringValue("$"+id)+"]",functions:function(codegen){const fn=vegaExpression.functions(codegen);eventFunctions.forEach(name=>fn[name]="event.vega."+name);for(let name in functionContext)fn[name]="this."+name;vegaUtil.extend(fn,internalScaleFunctions(codegen,functionContext,astVisitors));return fn},constants:vegaExpression.constants,visitors:astVisitors};var codeGenerator=vegaExpression.codegen(codegenParams);exports.DataPrefix=":";exports.IndexPrefix=
"@";exports.ScalePrefix="%";exports.SignalPrefix="$";exports.bandspace=bandspace;exports.bandwidth=bandwidth;exports.codeGenerator=codeGenerator;exports.codegenParams=codegenParams;exports.containerSize=containerSize;exports.contrast=contrast;exports.copy=copy;exports.data=data$jscomp$0;exports.dataVisitor=dataVisitor;exports.dayAbbrevFormat=dayAbbrevFormat;exports.dayFormat=dayFormat;exports.debug=debug;exports.domain=domain;exports.encode=encode;exports.expressionFunction=expressionFunction;exports.format=
format;exports.functionContext=functionContext;exports.geoArea=geoArea;exports.geoBounds=geoBounds;exports.geoCentroid=d3Geo;exports.geoShape=geoShape;exports.inScope=inScope;exports.indata=indata;exports.indataVisitor=indataVisitor;exports.info=info;exports.invert=invert;exports.luminance=luminance;exports.merge=merge;exports.modify=modify$jscomp$0;exports.monthAbbrevFormat=monthAbbrevFormat;exports.monthFormat=monthFormat;exports.parseExpression=function(expr,scope){var params={};try{expr=vegaUtil.isString(expr)?
expr:vegaUtil.stringValue(expr)+"";var ast=vegaExpression.parse(expr)}catch(err){vegaUtil.error("Expression parse error: "+expr)}ast.visit(node=>{if(node.type===vegaExpression.CallExpression){var name=node.callee.name,visit=codegenParams.visitors[name];visit&&visit(name,node.arguments,scope,params)}});expr=codeGenerator(ast);expr.globals.forEach(name=>{var signalName="$"+name;!vegaUtil.hasOwnProperty(params,signalName)&&scope.getSignal(name)&&(params[signalName]=scope.signalRef(name))});return{$expr:vegaUtil.extend({code:expr.code},
scope.options.ast?{ast}:null),$fields:expr.fields,$params:params}};exports.pathShape=pathShape;exports.pinchAngle=pinchAngle;exports.pinchDistance=pinchDistance;exports.range=range$jscomp$0;exports.scale=scale$jscomp$0;exports.scaleGradient=scaleGradient;exports.scaleVisitor=scaleVisitor;exports.screen=screen;exports.setdata=setdata;exports.timeFormat=timeFormat;exports.timeParse=timeParse;exports.treeAncestors=treeAncestors;exports.treePath=treePath;exports.utcFormat=utcFormat;exports.utcParse=wrap;
exports.warn=warn;exports.windowSize=windowSize;Object.defineProperty(exports,"__esModule",{value:!0})})}
//# sourceMappingURL=module$node_modules$vega_functions$build$vega_functions.js.map
