import "./cljs_env.js";
goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e30809){var e = e30809;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31005 = arguments.length;
var i__4737__auto___31006 = (0);
while(true){
if((i__4737__auto___31006 < len__4736__auto___31005)){
args__4742__auto__.push((arguments[i__4737__auto___31006]));

var G__31007 = (i__4737__auto___31006 + (1));
i__4737__auto___31006 = G__31007;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__30825){
var vec__30826 = p__30825;
var map__30829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30826,(0),null);
var map__30829__$1 = (((((!((map__30829 == null))))?(((((map__30829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30829.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30829):map__30829);
var opts = map__30829__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30829__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30829__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30829__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30829__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__30837 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__30837__$1 = (((((!((map__30837 == null))))?(((((map__30837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30837):map__30837);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30837__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30837__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__30813_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__30813_SHARP_);
}));

(web_socket.onclose = (function (p1__30814_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__30814_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28469__auto___31020 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30914){
var state_val_30915 = (state_30914[(1)]);
if((state_val_30915 === (7))){
var inst_30909 = (state_30914[(2)]);
var state_30914__$1 = state_30914;
var statearr_30919_31021 = state_30914__$1;
(statearr_30919_31021[(2)] = inst_30909);

(statearr_30919_31021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (20))){
var state_30914__$1 = state_30914;
var statearr_30920_31022 = state_30914__$1;
(statearr_30920_31022[(2)] = null);

(statearr_30920_31022[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (1))){
var inst_30841 = false;
var state_30914__$1 = (function (){var statearr_30922 = state_30914;
(statearr_30922[(7)] = inst_30841);

return statearr_30922;
})();
var statearr_30923_31025 = state_30914__$1;
(statearr_30923_31025[(2)] = null);

(statearr_30923_31025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (4))){
var inst_30858 = (state_30914[(8)]);
var inst_30856 = (state_30914[(9)]);
var inst_30856__$1 = (state_30914[(2)]);
var inst_30857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30856__$1,(0),null);
var inst_30858__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30856__$1,(1),null);
var inst_30859 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30858__$1,open_ch);
var state_30914__$1 = (function (){var statearr_30925 = state_30914;
(statearr_30925[(10)] = inst_30857);

(statearr_30925[(8)] = inst_30858__$1);

(statearr_30925[(9)] = inst_30856__$1);

return statearr_30925;
})();
if(inst_30859){
var statearr_30926_31032 = state_30914__$1;
(statearr_30926_31032[(1)] = (5));

} else {
var statearr_30927_31034 = state_30914__$1;
(statearr_30927_31034[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (15))){
var inst_30891 = (state_30914[(2)]);
var state_30914__$1 = state_30914;
var statearr_30928_31036 = state_30914__$1;
(statearr_30928_31036[(2)] = inst_30891);

(statearr_30928_31036[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (21))){
var inst_30905 = (state_30914[(2)]);
var state_30914__$1 = state_30914;
var statearr_30930_31038 = state_30914__$1;
(statearr_30930_31038[(2)] = inst_30905);

(statearr_30930_31038[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (13))){
var state_30914__$1 = state_30914;
var statearr_30933_31041 = state_30914__$1;
(statearr_30933_31041[(2)] = null);

(statearr_30933_31041[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (6))){
var inst_30858 = (state_30914[(8)]);
var inst_30875 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30858,close_ch);
var state_30914__$1 = state_30914;
if(inst_30875){
var statearr_30935_31042 = state_30914__$1;
(statearr_30935_31042[(1)] = (9));

} else {
var statearr_30936_31044 = state_30914__$1;
(statearr_30936_31044[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (17))){
var state_30914__$1 = state_30914;
var statearr_30939_31046 = state_30914__$1;
(statearr_30939_31046[(2)] = initial_ch);

(statearr_30939_31046[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (3))){
var inst_30912 = (state_30914[(2)]);
var state_30914__$1 = state_30914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30914__$1,inst_30912);
} else {
if((state_val_30915 === (12))){
var inst_30841 = (state_30914[(7)]);
var state_30914__$1 = state_30914;
if(cljs.core.truth_(inst_30841)){
var statearr_30946_31054 = state_30914__$1;
(statearr_30946_31054[(1)] = (16));

} else {
var statearr_30948_31056 = state_30914__$1;
(statearr_30948_31056[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (2))){
var inst_30852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30853 = [open_ch,close_ch];
var inst_30854 = (new cljs.core.PersistentVector(null,2,(5),inst_30852,inst_30853,null));
var state_30914__$1 = state_30914;
return cljs.core.async.ioc_alts_BANG_(state_30914__$1,(4),inst_30854);
} else {
if((state_val_30915 === (19))){
var inst_30857 = (state_30914[(10)]);
var state_30914__$1 = state_30914;
var statearr_30952_31061 = state_30914__$1;
(statearr_30952_31061[(2)] = inst_30857);

(statearr_30952_31061[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (11))){
var inst_30907 = (state_30914[(2)]);
var state_30914__$1 = state_30914;
var statearr_30956_31063 = state_30914__$1;
(statearr_30956_31063[(2)] = inst_30907);

(statearr_30956_31063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (9))){
var inst_30881 = (state_30914[(11)]);
var inst_30856 = (state_30914[(9)]);
var inst_30880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30856,(0),null);
var inst_30881__$1 = chord.client.close_event__GT_maybe_error(inst_30880);
var state_30914__$1 = (function (){var statearr_30959 = state_30914;
(statearr_30959[(11)] = inst_30881__$1);

return statearr_30959;
})();
if(cljs.core.truth_(inst_30881__$1)){
var statearr_30961_31068 = state_30914__$1;
(statearr_30961_31068[(1)] = (12));

} else {
var statearr_30962_31069 = state_30914__$1;
(statearr_30962_31069[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (5))){
var inst_30856 = (state_30914[(9)]);
var inst_30865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30856,(0),null);
var inst_30866 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_30867 = [ws_chan];
var inst_30868 = cljs.core.PersistentHashMap.fromArrays(inst_30866,inst_30867);
var state_30914__$1 = (function (){var statearr_30964 = state_30914;
(statearr_30964[(12)] = inst_30865);

return statearr_30964;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30914__$1,(8),initial_ch,inst_30868);
} else {
if((state_val_30915 === (14))){
var inst_30894 = (state_30914[(2)]);
var inst_30895 = cljs.core.async.close_BANG_(ws_chan);
var inst_30897 = cljs.core.async.close_BANG_(initial_ch);
var state_30914__$1 = (function (){var statearr_30968 = state_30914;
(statearr_30968[(13)] = inst_30895);

(statearr_30968[(14)] = inst_30894);

return statearr_30968;
})();
var statearr_30969_31072 = state_30914__$1;
(statearr_30969_31072[(2)] = inst_30897);

(statearr_30969_31072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (16))){
var state_30914__$1 = state_30914;
var statearr_30970_31074 = state_30914__$1;
(statearr_30970_31074[(2)] = read_ch__$1);

(statearr_30970_31074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (10))){
var inst_30858 = (state_30914[(8)]);
var inst_30899 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30858,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_30914__$1 = state_30914;
if(inst_30899){
var statearr_30973_31076 = state_30914__$1;
(statearr_30973_31076[(1)] = (19));

} else {
var statearr_30975_31078 = state_30914__$1;
(statearr_30975_31078[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30915 === (18))){
var inst_30881 = (state_30914[(11)]);
var inst_30886 = (state_30914[(2)]);
var inst_30887 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30888 = [inst_30881];
var inst_30889 = cljs.core.PersistentHashMap.fromArrays(inst_30887,inst_30888);
var state_30914__$1 = state_30914;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30914__$1,(15),inst_30886,inst_30889);
} else {
if((state_val_30915 === (8))){
var inst_30870 = (state_30914[(2)]);
var inst_30871 = cljs.core.async.close_BANG_(initial_ch);
var inst_30841 = true;
var state_30914__$1 = (function (){var statearr_30981 = state_30914;
(statearr_30981[(7)] = inst_30841);

(statearr_30981[(15)] = inst_30871);

(statearr_30981[(16)] = inst_30870);

return statearr_30981;
})();
var statearr_30982_31083 = state_30914__$1;
(statearr_30982_31083[(2)] = null);

(statearr_30982_31083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28339__auto__ = null;
var chord$client$state_machine__28339__auto____0 = (function (){
var statearr_30986 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30986[(0)] = chord$client$state_machine__28339__auto__);

(statearr_30986[(1)] = (1));

return statearr_30986;
});
var chord$client$state_machine__28339__auto____1 = (function (state_30914){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30914);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30990){if((e30990 instanceof Object)){
var ex__28342__auto__ = e30990;
var statearr_30991_31089 = state_30914;
(statearr_30991_31089[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30914);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30990;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31090 = state_30914;
state_30914 = G__31090;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
chord$client$state_machine__28339__auto__ = function(state_30914){
switch(arguments.length){
case 0:
return chord$client$state_machine__28339__auto____0.call(this);
case 1:
return chord$client$state_machine__28339__auto____1.call(this,state_30914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28339__auto____0;
chord$client$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28339__auto____1;
return chord$client$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30996 = f__28470__auto__();
(statearr_30996[(6)] = c__28469__auto___31020);

return statearr_30996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq30817){
var G__30818 = cljs.core.first(seq30817);
var seq30817__$1 = cljs.core.next(seq30817);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30818,seq30817__$1);
}));


//# sourceMappingURL=chord.client.js.map
