import "./cljs_env.js";
goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5720__auto__ = (function (){var fexpr__30639 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__30639.cljs$core$IFn$_invoke$arity$1 ? fexpr__30639.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__30639.call(null,channel));
})();
if(cljs.core.truth_(temp__5720__auto__)){
var req = temp__5720__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__30660){
var vec__30661 = p__30660;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30661,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30661,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__30673 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__30673)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__30673)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__30673)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__30673)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__30673)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__30673)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30673)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__30679){
var map__30683 = p__30679;
var map__30683__$1 = (((((!((map__30683 == null))))?(((((map__30683.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30683.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30683):map__30683);
var request = map__30683__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30683__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30683__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30683__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__30688 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__30688,default_headers);

cljs_http.core.apply_response_type_BANG_(G__30688,response_type);

G__30688.setTimeoutInterval(timeout);

G__30688.setWithCredentials(send_credentials);

return G__30688;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__30702){
var map__30707 = p__30702;
var map__30707__$1 = (((((!((map__30707 == null))))?(((((map__30707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30707):map__30707);
var request = map__30707__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__30719 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__30719) : cljs_http.core.error_kw.call(null,G__30719));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_30934 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__30725_30937 = xhr;
G__30725_30937.setProgressEventsEnabled(true);

G__30725_30937.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_30934,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__30725_30937.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_30934,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__28469__auto___30942 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30745){
var state_val_30746 = (state_30745[(1)]);
if((state_val_30746 === (1))){
var state_30745__$1 = state_30745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30745__$1,(2),cancel);
} else {
if((state_val_30746 === (2))){
var inst_30735 = (state_30745[(2)]);
var inst_30736 = xhr.isComplete();
var inst_30737 = cljs.core.not(inst_30736);
var state_30745__$1 = (function (){var statearr_30750 = state_30745;
(statearr_30750[(7)] = inst_30735);

return statearr_30750;
})();
if(inst_30737){
var statearr_30752_30950 = state_30745__$1;
(statearr_30752_30950[(1)] = (3));

} else {
var statearr_30753_30953 = state_30745__$1;
(statearr_30753_30953[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (3))){
var inst_30739 = xhr.abort();
var state_30745__$1 = state_30745;
var statearr_30754_30955 = state_30745__$1;
(statearr_30754_30955[(2)] = inst_30739);

(statearr_30754_30955[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (4))){
var state_30745__$1 = state_30745;
var statearr_30757_30958 = state_30745__$1;
(statearr_30757_30958[(2)] = null);

(statearr_30757_30958[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30746 === (5))){
var inst_30742 = (state_30745[(2)]);
var state_30745__$1 = state_30745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30745__$1,inst_30742);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__28339__auto__ = null;
var cljs_http$core$xhr_$_state_machine__28339__auto____0 = (function (){
var statearr_30765 = [null,null,null,null,null,null,null,null];
(statearr_30765[(0)] = cljs_http$core$xhr_$_state_machine__28339__auto__);

(statearr_30765[(1)] = (1));

return statearr_30765;
});
var cljs_http$core$xhr_$_state_machine__28339__auto____1 = (function (state_30745){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30745);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30768){if((e30768 instanceof Object)){
var ex__28342__auto__ = e30768;
var statearr_30770_30966 = state_30745;
(statearr_30770_30966[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30768;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30967 = state_30745;
state_30745 = G__30967;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__28339__auto__ = function(state_30745){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__28339__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__28339__auto____1.call(this,state_30745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__28339__auto____0;
cljs_http$core$xhr_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__28339__auto____1;
return cljs_http$core$xhr_$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30777 = f__28470__auto__();
(statearr_30777[(6)] = c__28469__auto___30942);

return statearr_30777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__30788){
var map__30789 = p__30788;
var map__30789__$1 = (((((!((map__30789 == null))))?(((((map__30789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30789):map__30789);
var request = map__30789__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30789__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30789__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30789__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30789__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_30972 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_30972], null));

if(cljs.core.truth_(cancel)){
var c__28469__auto___30979 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30807){
var state_val_30808 = (state_30807[(1)]);
if((state_val_30808 === (1))){
var state_30807__$1 = state_30807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30807__$1,(2),cancel);
} else {
if((state_val_30808 === (2))){
var inst_30804 = (state_30807[(2)]);
var inst_30805 = jsonp.cancel(req_30972);
var state_30807__$1 = (function (){var statearr_30812 = state_30807;
(statearr_30812[(7)] = inst_30804);

return statearr_30812;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30807__$1,inst_30805);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__28339__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__28339__auto____0 = (function (){
var statearr_30816 = [null,null,null,null,null,null,null,null];
(statearr_30816[(0)] = cljs_http$core$jsonp_$_state_machine__28339__auto__);

(statearr_30816[(1)] = (1));

return statearr_30816;
});
var cljs_http$core$jsonp_$_state_machine__28339__auto____1 = (function (state_30807){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30807);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30820){if((e30820 instanceof Object)){
var ex__28342__auto__ = e30820;
var statearr_30821_30987 = state_30807;
(statearr_30821_30987[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30820;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30989 = state_30807;
state_30807 = G__30989;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__28339__auto__ = function(state_30807){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__28339__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__28339__auto____1.call(this,state_30807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__28339__auto____0;
cljs_http$core$jsonp_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__28339__auto____1;
return cljs_http$core$jsonp_$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30822 = f__28470__auto__();
(statearr_30822[(6)] = c__28469__auto___30979);

return statearr_30822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__30832){
var map__30833 = p__30832;
var map__30833__$1 = (((((!((map__30833 == null))))?(((((map__30833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30833.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30833):map__30833);
var request = map__30833__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30833__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
