import "./cljs_env.js";
goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28553 = arguments.length;
switch (G__28553) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28560 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28560 = (function (f,blockable,meta28561){
this.f = f;
this.blockable = blockable;
this.meta28561 = meta28561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28562,meta28561__$1){
var self__ = this;
var _28562__$1 = this;
return (new cljs.core.async.t_cljs$core$async28560(self__.f,self__.blockable,meta28561__$1));
}));

(cljs.core.async.t_cljs$core$async28560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28562){
var self__ = this;
var _28562__$1 = this;
return self__.meta28561;
}));

(cljs.core.async.t_cljs$core$async28560.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28560.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28560.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28560.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28561","meta28561",-825663977,null)], null);
}));

(cljs.core.async.t_cljs$core$async28560.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28560.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28560");

(cljs.core.async.t_cljs$core$async28560.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28560");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28560.
 */
cljs.core.async.__GT_t_cljs$core$async28560 = (function cljs$core$async$__GT_t_cljs$core$async28560(f__$1,blockable__$1,meta28561){
return (new cljs.core.async.t_cljs$core$async28560(f__$1,blockable__$1,meta28561));
});

}

return (new cljs.core.async.t_cljs$core$async28560(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28592 = arguments.length;
switch (G__28592) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28596 = arguments.length;
switch (G__28596) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28603 = arguments.length;
switch (G__28603) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30641 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30641) : fn1.call(null,val_30641));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30641) : fn1.call(null,val_30641));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28610 = arguments.length;
switch (G__28610) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30667 = n;
var x_30668 = (0);
while(true){
if((x_30668 < n__4613__auto___30667)){
(a[x_30668] = x_30668);

var G__30670 = (x_30668 + (1));
x_30668 = G__30670;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28614 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28614 = (function (flag,meta28615){
this.flag = flag;
this.meta28615 = meta28615;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28614.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28616,meta28615__$1){
var self__ = this;
var _28616__$1 = this;
return (new cljs.core.async.t_cljs$core$async28614(self__.flag,meta28615__$1));
}));

(cljs.core.async.t_cljs$core$async28614.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28616){
var self__ = this;
var _28616__$1 = this;
return self__.meta28615;
}));

(cljs.core.async.t_cljs$core$async28614.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28614.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28614.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28614.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28614.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28615","meta28615",-1646733556,null)], null);
}));

(cljs.core.async.t_cljs$core$async28614.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28614.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28614");

(cljs.core.async.t_cljs$core$async28614.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28614");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28614.
 */
cljs.core.async.__GT_t_cljs$core$async28614 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28614(flag__$1,meta28615){
return (new cljs.core.async.t_cljs$core$async28614(flag__$1,meta28615));
});

}

return (new cljs.core.async.t_cljs$core$async28614(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28621 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28621 = (function (flag,cb,meta28622){
this.flag = flag;
this.cb = cb;
this.meta28622 = meta28622;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28621.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28623,meta28622__$1){
var self__ = this;
var _28623__$1 = this;
return (new cljs.core.async.t_cljs$core$async28621(self__.flag,self__.cb,meta28622__$1));
}));

(cljs.core.async.t_cljs$core$async28621.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28623){
var self__ = this;
var _28623__$1 = this;
return self__.meta28622;
}));

(cljs.core.async.t_cljs$core$async28621.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28621.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28621.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28621.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28621.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28622","meta28622",132221120,null)], null);
}));

(cljs.core.async.t_cljs$core$async28621.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28621.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28621");

(cljs.core.async.t_cljs$core$async28621.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28621");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28621.
 */
cljs.core.async.__GT_t_cljs$core$async28621 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28621(flag__$1,cb__$1,meta28622){
return (new cljs.core.async.t_cljs$core$async28621(flag__$1,cb__$1,meta28622));
});

}

return (new cljs.core.async.t_cljs$core$async28621(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28627_SHARP_){
var G__28633 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28627_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28633) : fret.call(null,G__28633));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28628_SHARP_){
var G__28634 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28628_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28634) : fret.call(null,G__28634));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30692 = (i + (1));
i = G__30692;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30698 = arguments.length;
var i__4737__auto___30699 = (0);
while(true){
if((i__4737__auto___30699 < len__4736__auto___30698)){
args__4742__auto__.push((arguments[i__4737__auto___30699]));

var G__30700 = (i__4737__auto___30699 + (1));
i__4737__auto___30699 = G__30700;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28648){
var map__28649 = p__28648;
var map__28649__$1 = (((((!((map__28649 == null))))?(((((map__28649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28649):map__28649);
var opts = map__28649__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28640){
var G__28641 = cljs.core.first(seq28640);
var seq28640__$1 = cljs.core.next(seq28640);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28641,seq28640__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28655 = arguments.length;
switch (G__28655) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28469__auto___30714 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_28679){
var state_val_28680 = (state_28679[(1)]);
if((state_val_28680 === (7))){
var inst_28675 = (state_28679[(2)]);
var state_28679__$1 = state_28679;
var statearr_28682_30718 = state_28679__$1;
(statearr_28682_30718[(2)] = inst_28675);

(statearr_28682_30718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (1))){
var state_28679__$1 = state_28679;
var statearr_28684_30720 = state_28679__$1;
(statearr_28684_30720[(2)] = null);

(statearr_28684_30720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (4))){
var inst_28658 = (state_28679[(7)]);
var inst_28658__$1 = (state_28679[(2)]);
var inst_28659 = (inst_28658__$1 == null);
var state_28679__$1 = (function (){var statearr_28686 = state_28679;
(statearr_28686[(7)] = inst_28658__$1);

return statearr_28686;
})();
if(cljs.core.truth_(inst_28659)){
var statearr_28687_30721 = state_28679__$1;
(statearr_28687_30721[(1)] = (5));

} else {
var statearr_28688_30722 = state_28679__$1;
(statearr_28688_30722[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (13))){
var state_28679__$1 = state_28679;
var statearr_28690_30723 = state_28679__$1;
(statearr_28690_30723[(2)] = null);

(statearr_28690_30723[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (6))){
var inst_28658 = (state_28679[(7)]);
var state_28679__$1 = state_28679;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28679__$1,(11),to,inst_28658);
} else {
if((state_val_28680 === (3))){
var inst_28677 = (state_28679[(2)]);
var state_28679__$1 = state_28679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28679__$1,inst_28677);
} else {
if((state_val_28680 === (12))){
var state_28679__$1 = state_28679;
var statearr_28692_30724 = state_28679__$1;
(statearr_28692_30724[(2)] = null);

(statearr_28692_30724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (2))){
var state_28679__$1 = state_28679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28679__$1,(4),from);
} else {
if((state_val_28680 === (11))){
var inst_28668 = (state_28679[(2)]);
var state_28679__$1 = state_28679;
if(cljs.core.truth_(inst_28668)){
var statearr_28698_30726 = state_28679__$1;
(statearr_28698_30726[(1)] = (12));

} else {
var statearr_28699_30727 = state_28679__$1;
(statearr_28699_30727[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (9))){
var state_28679__$1 = state_28679;
var statearr_28703_30728 = state_28679__$1;
(statearr_28703_30728[(2)] = null);

(statearr_28703_30728[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (5))){
var state_28679__$1 = state_28679;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28704_30732 = state_28679__$1;
(statearr_28704_30732[(1)] = (8));

} else {
var statearr_28711_30733 = state_28679__$1;
(statearr_28711_30733[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (14))){
var inst_28673 = (state_28679[(2)]);
var state_28679__$1 = state_28679;
var statearr_28712_30744 = state_28679__$1;
(statearr_28712_30744[(2)] = inst_28673);

(statearr_28712_30744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (10))){
var inst_28665 = (state_28679[(2)]);
var state_28679__$1 = state_28679;
var statearr_28716_30747 = state_28679__$1;
(statearr_28716_30747[(2)] = inst_28665);

(statearr_28716_30747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28680 === (8))){
var inst_28662 = cljs.core.async.close_BANG_(to);
var state_28679__$1 = state_28679;
var statearr_28720_30748 = state_28679__$1;
(statearr_28720_30748[(2)] = inst_28662);

(statearr_28720_30748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_28721 = [null,null,null,null,null,null,null,null];
(statearr_28721[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_28721[(1)] = (1));

return statearr_28721;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_28679){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_28679);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e28725){if((e28725 instanceof Object)){
var ex__28342__auto__ = e28725;
var statearr_28726_30749 = state_28679;
(statearr_28726_30749[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28725;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30751 = state_28679;
state_28679 = G__30751;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_28679){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_28679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_28733 = f__28470__auto__();
(statearr_28733[(6)] = c__28469__auto___30714);

return statearr_28733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28737){
var vec__28738 = p__28737;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28738,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28738,(1),null);
var job = vec__28738;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28469__auto___30758 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_28745){
var state_val_28746 = (state_28745[(1)]);
if((state_val_28746 === (1))){
var state_28745__$1 = state_28745;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28745__$1,(2),res,v);
} else {
if((state_val_28746 === (2))){
var inst_28742 = (state_28745[(2)]);
var inst_28743 = cljs.core.async.close_BANG_(res);
var state_28745__$1 = (function (){var statearr_28747 = state_28745;
(statearr_28747[(7)] = inst_28742);

return statearr_28747;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28745__$1,inst_28743);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0 = (function (){
var statearr_28751 = [null,null,null,null,null,null,null,null];
(statearr_28751[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__);

(statearr_28751[(1)] = (1));

return statearr_28751;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1 = (function (state_28745){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_28745);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e28755){if((e28755 instanceof Object)){
var ex__28342__auto__ = e28755;
var statearr_28756_30767 = state_28745;
(statearr_28756_30767[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28755;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30771 = state_28745;
state_28745 = G__30771;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = function(state_28745){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1.call(this,state_28745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_28757 = f__28470__auto__();
(statearr_28757[(6)] = c__28469__auto___30758);

return statearr_28757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28761){
var vec__28762 = p__28761;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28762,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28762,(1),null);
var job = vec__28762;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30779 = n;
var __30780 = (0);
while(true){
if((__30780 < n__4613__auto___30779)){
var G__28768_30781 = type;
var G__28768_30782__$1 = (((G__28768_30781 instanceof cljs.core.Keyword))?G__28768_30781.fqn:null);
switch (G__28768_30782__$1) {
case "compute":
var c__28469__auto___30784 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30780,c__28469__auto___30784,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async){
return (function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = ((function (__30780,c__28469__auto___30784,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async){
return (function (state_28781){
var state_val_28782 = (state_28781[(1)]);
if((state_val_28782 === (1))){
var state_28781__$1 = state_28781;
var statearr_28783_30787 = state_28781__$1;
(statearr_28783_30787[(2)] = null);

(statearr_28783_30787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28782 === (2))){
var state_28781__$1 = state_28781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28781__$1,(4),jobs);
} else {
if((state_val_28782 === (3))){
var inst_28779 = (state_28781[(2)]);
var state_28781__$1 = state_28781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28781__$1,inst_28779);
} else {
if((state_val_28782 === (4))){
var inst_28771 = (state_28781[(2)]);
var inst_28772 = process(inst_28771);
var state_28781__$1 = state_28781;
if(cljs.core.truth_(inst_28772)){
var statearr_28787_30793 = state_28781__$1;
(statearr_28787_30793[(1)] = (5));

} else {
var statearr_28788_30795 = state_28781__$1;
(statearr_28788_30795[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28782 === (5))){
var state_28781__$1 = state_28781;
var statearr_28789_30796 = state_28781__$1;
(statearr_28789_30796[(2)] = null);

(statearr_28789_30796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28782 === (6))){
var state_28781__$1 = state_28781;
var statearr_28793_30797 = state_28781__$1;
(statearr_28793_30797[(2)] = null);

(statearr_28793_30797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28782 === (7))){
var inst_28777 = (state_28781[(2)]);
var state_28781__$1 = state_28781;
var statearr_28794_30801 = state_28781__$1;
(statearr_28794_30801[(2)] = inst_28777);

(statearr_28794_30801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30780,c__28469__auto___30784,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async))
;
return ((function (__30780,switch__28338__auto__,c__28469__auto___30784,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0 = (function (){
var statearr_28795 = [null,null,null,null,null,null,null];
(statearr_28795[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__);

(statearr_28795[(1)] = (1));

return statearr_28795;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1 = (function (state_28781){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_28781);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e28796){if((e28796 instanceof Object)){
var ex__28342__auto__ = e28796;
var statearr_28797_30810 = state_28781;
(statearr_28797_30810[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28781);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28796;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30811 = state_28781;
state_28781 = G__30811;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = function(state_28781){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1.call(this,state_28781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__;
})()
;})(__30780,switch__28338__auto__,c__28469__auto___30784,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async))
})();
var state__28471__auto__ = (function (){var statearr_28798 = f__28470__auto__();
(statearr_28798[(6)] = c__28469__auto___30784);

return statearr_28798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
});})(__30780,c__28469__auto___30784,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async))
);


break;
case "async":
var c__28469__auto___30815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30780,c__28469__auto___30815,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async){
return (function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = ((function (__30780,c__28469__auto___30815,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async){
return (function (state_28811){
var state_val_28812 = (state_28811[(1)]);
if((state_val_28812 === (1))){
var state_28811__$1 = state_28811;
var statearr_28813_30819 = state_28811__$1;
(statearr_28813_30819[(2)] = null);

(statearr_28813_30819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (2))){
var state_28811__$1 = state_28811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28811__$1,(4),jobs);
} else {
if((state_val_28812 === (3))){
var inst_28809 = (state_28811[(2)]);
var state_28811__$1 = state_28811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28811__$1,inst_28809);
} else {
if((state_val_28812 === (4))){
var inst_28801 = (state_28811[(2)]);
var inst_28802 = async(inst_28801);
var state_28811__$1 = state_28811;
if(cljs.core.truth_(inst_28802)){
var statearr_28814_30823 = state_28811__$1;
(statearr_28814_30823[(1)] = (5));

} else {
var statearr_28816_30824 = state_28811__$1;
(statearr_28816_30824[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (5))){
var state_28811__$1 = state_28811;
var statearr_28817_30830 = state_28811__$1;
(statearr_28817_30830[(2)] = null);

(statearr_28817_30830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (6))){
var state_28811__$1 = state_28811;
var statearr_28819_30834 = state_28811__$1;
(statearr_28819_30834[(2)] = null);

(statearr_28819_30834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (7))){
var inst_28807 = (state_28811[(2)]);
var state_28811__$1 = state_28811;
var statearr_28823_30836 = state_28811__$1;
(statearr_28823_30836[(2)] = inst_28807);

(statearr_28823_30836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30780,c__28469__auto___30815,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async))
;
return ((function (__30780,switch__28338__auto__,c__28469__auto___30815,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0 = (function (){
var statearr_28825 = [null,null,null,null,null,null,null];
(statearr_28825[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__);

(statearr_28825[(1)] = (1));

return statearr_28825;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1 = (function (state_28811){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_28811);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e28826){if((e28826 instanceof Object)){
var ex__28342__auto__ = e28826;
var statearr_28827_30839 = state_28811;
(statearr_28827_30839[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28826;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30840 = state_28811;
state_28811 = G__30840;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = function(state_28811){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1.call(this,state_28811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__;
})()
;})(__30780,switch__28338__auto__,c__28469__auto___30815,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async))
})();
var state__28471__auto__ = (function (){var statearr_28828 = f__28470__auto__();
(statearr_28828[(6)] = c__28469__auto___30815);

return statearr_28828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
});})(__30780,c__28469__auto___30815,G__28768_30781,G__28768_30782__$1,n__4613__auto___30779,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28768_30782__$1)].join('')));

}

var G__30847 = (__30780 + (1));
__30780 = G__30847;
continue;
} else {
}
break;
}

var c__28469__auto___30848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_28856){
var state_val_28857 = (state_28856[(1)]);
if((state_val_28857 === (7))){
var inst_28852 = (state_28856[(2)]);
var state_28856__$1 = state_28856;
var statearr_28861_30861 = state_28856__$1;
(statearr_28861_30861[(2)] = inst_28852);

(statearr_28861_30861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28857 === (1))){
var state_28856__$1 = state_28856;
var statearr_28863_30874 = state_28856__$1;
(statearr_28863_30874[(2)] = null);

(statearr_28863_30874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28857 === (4))){
var inst_28831 = (state_28856[(7)]);
var inst_28831__$1 = (state_28856[(2)]);
var inst_28832 = (inst_28831__$1 == null);
var state_28856__$1 = (function (){var statearr_28864 = state_28856;
(statearr_28864[(7)] = inst_28831__$1);

return statearr_28864;
})();
if(cljs.core.truth_(inst_28832)){
var statearr_28865_30896 = state_28856__$1;
(statearr_28865_30896[(1)] = (5));

} else {
var statearr_28866_30910 = state_28856__$1;
(statearr_28866_30910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28857 === (6))){
var inst_28831 = (state_28856[(7)]);
var inst_28836 = (state_28856[(8)]);
var inst_28836__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28843 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28844 = [inst_28831,inst_28836__$1];
var inst_28845 = (new cljs.core.PersistentVector(null,2,(5),inst_28843,inst_28844,null));
var state_28856__$1 = (function (){var statearr_28867 = state_28856;
(statearr_28867[(8)] = inst_28836__$1);

return statearr_28867;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28856__$1,(8),jobs,inst_28845);
} else {
if((state_val_28857 === (3))){
var inst_28854 = (state_28856[(2)]);
var state_28856__$1 = state_28856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28856__$1,inst_28854);
} else {
if((state_val_28857 === (2))){
var state_28856__$1 = state_28856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28856__$1,(4),from);
} else {
if((state_val_28857 === (9))){
var inst_28849 = (state_28856[(2)]);
var state_28856__$1 = (function (){var statearr_28868 = state_28856;
(statearr_28868[(9)] = inst_28849);

return statearr_28868;
})();
var statearr_28869_30921 = state_28856__$1;
(statearr_28869_30921[(2)] = null);

(statearr_28869_30921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28857 === (5))){
var inst_28834 = cljs.core.async.close_BANG_(jobs);
var state_28856__$1 = state_28856;
var statearr_28870_30924 = state_28856__$1;
(statearr_28870_30924[(2)] = inst_28834);

(statearr_28870_30924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28857 === (8))){
var inst_28836 = (state_28856[(8)]);
var inst_28847 = (state_28856[(2)]);
var state_28856__$1 = (function (){var statearr_28871 = state_28856;
(statearr_28871[(10)] = inst_28847);

return statearr_28871;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28856__$1,(9),results,inst_28836);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0 = (function (){
var statearr_28872 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28872[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__);

(statearr_28872[(1)] = (1));

return statearr_28872;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1 = (function (state_28856){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_28856);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e28873){if((e28873 instanceof Object)){
var ex__28342__auto__ = e28873;
var statearr_28874_30929 = state_28856;
(statearr_28874_30929[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28873;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30932 = state_28856;
state_28856 = G__30932;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = function(state_28856){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1.call(this,state_28856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_28878 = f__28470__auto__();
(statearr_28878[(6)] = c__28469__auto___30848);

return statearr_28878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


var c__28469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_28927){
var state_val_28928 = (state_28927[(1)]);
if((state_val_28928 === (7))){
var inst_28919 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
var statearr_28944_30938 = state_28927__$1;
(statearr_28944_30938[(2)] = inst_28919);

(statearr_28944_30938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (20))){
var state_28927__$1 = state_28927;
var statearr_28945_30940 = state_28927__$1;
(statearr_28945_30940[(2)] = null);

(statearr_28945_30940[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (1))){
var state_28927__$1 = state_28927;
var statearr_28946_30947 = state_28927__$1;
(statearr_28946_30947[(2)] = null);

(statearr_28946_30947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (4))){
var inst_28882 = (state_28927[(7)]);
var inst_28882__$1 = (state_28927[(2)]);
var inst_28883 = (inst_28882__$1 == null);
var state_28927__$1 = (function (){var statearr_28947 = state_28927;
(statearr_28947[(7)] = inst_28882__$1);

return statearr_28947;
})();
if(cljs.core.truth_(inst_28883)){
var statearr_28948_30949 = state_28927__$1;
(statearr_28948_30949[(1)] = (5));

} else {
var statearr_28949_30951 = state_28927__$1;
(statearr_28949_30951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (15))){
var inst_28899 = (state_28927[(8)]);
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28927__$1,(18),to,inst_28899);
} else {
if((state_val_28928 === (21))){
var inst_28914 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
var statearr_28950_30957 = state_28927__$1;
(statearr_28950_30957[(2)] = inst_28914);

(statearr_28950_30957[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (13))){
var inst_28916 = (state_28927[(2)]);
var state_28927__$1 = (function (){var statearr_28951 = state_28927;
(statearr_28951[(9)] = inst_28916);

return statearr_28951;
})();
var statearr_28952_30960 = state_28927__$1;
(statearr_28952_30960[(2)] = null);

(statearr_28952_30960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (6))){
var inst_28882 = (state_28927[(7)]);
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28927__$1,(11),inst_28882);
} else {
if((state_val_28928 === (17))){
var inst_28909 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
if(cljs.core.truth_(inst_28909)){
var statearr_28958_30963 = state_28927__$1;
(statearr_28958_30963[(1)] = (19));

} else {
var statearr_28959_30965 = state_28927__$1;
(statearr_28959_30965[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (3))){
var inst_28925 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28927__$1,inst_28925);
} else {
if((state_val_28928 === (12))){
var inst_28896 = (state_28927[(10)]);
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28927__$1,(14),inst_28896);
} else {
if((state_val_28928 === (2))){
var state_28927__$1 = state_28927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28927__$1,(4),results);
} else {
if((state_val_28928 === (19))){
var state_28927__$1 = state_28927;
var statearr_28961_30971 = state_28927__$1;
(statearr_28961_30971[(2)] = null);

(statearr_28961_30971[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (11))){
var inst_28896 = (state_28927[(2)]);
var state_28927__$1 = (function (){var statearr_28964 = state_28927;
(statearr_28964[(10)] = inst_28896);

return statearr_28964;
})();
var statearr_28965_30974 = state_28927__$1;
(statearr_28965_30974[(2)] = null);

(statearr_28965_30974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (9))){
var state_28927__$1 = state_28927;
var statearr_28966_30976 = state_28927__$1;
(statearr_28966_30976[(2)] = null);

(statearr_28966_30976[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (5))){
var state_28927__$1 = state_28927;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28967_30977 = state_28927__$1;
(statearr_28967_30977[(1)] = (8));

} else {
var statearr_28968_30978 = state_28927__$1;
(statearr_28968_30978[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (14))){
var inst_28899 = (state_28927[(8)]);
var inst_28899__$1 = (state_28927[(2)]);
var inst_28901 = (inst_28899__$1 == null);
var inst_28902 = cljs.core.not(inst_28901);
var state_28927__$1 = (function (){var statearr_28969 = state_28927;
(statearr_28969[(8)] = inst_28899__$1);

return statearr_28969;
})();
if(inst_28902){
var statearr_28970_30984 = state_28927__$1;
(statearr_28970_30984[(1)] = (15));

} else {
var statearr_28971_30985 = state_28927__$1;
(statearr_28971_30985[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (16))){
var state_28927__$1 = state_28927;
var statearr_28972_30988 = state_28927__$1;
(statearr_28972_30988[(2)] = false);

(statearr_28972_30988[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (10))){
var inst_28889 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
var statearr_28973_30992 = state_28927__$1;
(statearr_28973_30992[(2)] = inst_28889);

(statearr_28973_30992[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (18))){
var inst_28906 = (state_28927[(2)]);
var state_28927__$1 = state_28927;
var statearr_28974_30995 = state_28927__$1;
(statearr_28974_30995[(2)] = inst_28906);

(statearr_28974_30995[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28928 === (8))){
var inst_28886 = cljs.core.async.close_BANG_(to);
var state_28927__$1 = state_28927;
var statearr_28979_30997 = state_28927__$1;
(statearr_28979_30997[(2)] = inst_28886);

(statearr_28979_30997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0 = (function (){
var statearr_28989 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28989[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__);

(statearr_28989[(1)] = (1));

return statearr_28989;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1 = (function (state_28927){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_28927);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e28995){if((e28995 instanceof Object)){
var ex__28342__auto__ = e28995;
var statearr_29000_31002 = state_28927;
(statearr_29000_31002[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28995;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31004 = state_28927;
state_28927 = G__31004;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__ = function(state_28927){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1.call(this,state_28927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28339__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29002 = f__28470__auto__();
(statearr_29002[(6)] = c__28469__auto__);

return statearr_29002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

return c__28469__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__29004 = arguments.length;
switch (G__29004) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__29032 = arguments.length;
switch (G__29032) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__29055 = arguments.length;
switch (G__29055) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28469__auto___31023 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29081){
var state_val_29082 = (state_29081[(1)]);
if((state_val_29082 === (7))){
var inst_29077 = (state_29081[(2)]);
var state_29081__$1 = state_29081;
var statearr_29088_31026 = state_29081__$1;
(statearr_29088_31026[(2)] = inst_29077);

(statearr_29088_31026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (1))){
var state_29081__$1 = state_29081;
var statearr_29090_31030 = state_29081__$1;
(statearr_29090_31030[(2)] = null);

(statearr_29090_31030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (4))){
var inst_29058 = (state_29081[(7)]);
var inst_29058__$1 = (state_29081[(2)]);
var inst_29059 = (inst_29058__$1 == null);
var state_29081__$1 = (function (){var statearr_29094 = state_29081;
(statearr_29094[(7)] = inst_29058__$1);

return statearr_29094;
})();
if(cljs.core.truth_(inst_29059)){
var statearr_29095_31033 = state_29081__$1;
(statearr_29095_31033[(1)] = (5));

} else {
var statearr_29099_31035 = state_29081__$1;
(statearr_29099_31035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (13))){
var state_29081__$1 = state_29081;
var statearr_29100_31037 = state_29081__$1;
(statearr_29100_31037[(2)] = null);

(statearr_29100_31037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (6))){
var inst_29058 = (state_29081[(7)]);
var inst_29064 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29058) : p.call(null,inst_29058));
var state_29081__$1 = state_29081;
if(cljs.core.truth_(inst_29064)){
var statearr_29101_31039 = state_29081__$1;
(statearr_29101_31039[(1)] = (9));

} else {
var statearr_29102_31040 = state_29081__$1;
(statearr_29102_31040[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (3))){
var inst_29079 = (state_29081[(2)]);
var state_29081__$1 = state_29081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29081__$1,inst_29079);
} else {
if((state_val_29082 === (12))){
var state_29081__$1 = state_29081;
var statearr_29103_31043 = state_29081__$1;
(statearr_29103_31043[(2)] = null);

(statearr_29103_31043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (2))){
var state_29081__$1 = state_29081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29081__$1,(4),ch);
} else {
if((state_val_29082 === (11))){
var inst_29058 = (state_29081[(7)]);
var inst_29068 = (state_29081[(2)]);
var state_29081__$1 = state_29081;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29081__$1,(8),inst_29068,inst_29058);
} else {
if((state_val_29082 === (9))){
var state_29081__$1 = state_29081;
var statearr_29108_31053 = state_29081__$1;
(statearr_29108_31053[(2)] = tc);

(statearr_29108_31053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (5))){
var inst_29061 = cljs.core.async.close_BANG_(tc);
var inst_29062 = cljs.core.async.close_BANG_(fc);
var state_29081__$1 = (function (){var statearr_29113 = state_29081;
(statearr_29113[(8)] = inst_29061);

return statearr_29113;
})();
var statearr_29114_31057 = state_29081__$1;
(statearr_29114_31057[(2)] = inst_29062);

(statearr_29114_31057[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (14))){
var inst_29075 = (state_29081[(2)]);
var state_29081__$1 = state_29081;
var statearr_29119_31060 = state_29081__$1;
(statearr_29119_31060[(2)] = inst_29075);

(statearr_29119_31060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (10))){
var state_29081__$1 = state_29081;
var statearr_29120_31062 = state_29081__$1;
(statearr_29120_31062[(2)] = fc);

(statearr_29120_31062[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29082 === (8))){
var inst_29070 = (state_29081[(2)]);
var state_29081__$1 = state_29081;
if(cljs.core.truth_(inst_29070)){
var statearr_29122_31066 = state_29081__$1;
(statearr_29122_31066[(1)] = (12));

} else {
var statearr_29123_31067 = state_29081__$1;
(statearr_29123_31067[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_29124 = [null,null,null,null,null,null,null,null,null];
(statearr_29124[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_29124[(1)] = (1));

return statearr_29124;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_29081){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29081);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29125){if((e29125 instanceof Object)){
var ex__28342__auto__ = e29125;
var statearr_29127_31070 = state_29081;
(statearr_29127_31070[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29081);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29125;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31071 = state_29081;
state_29081 = G__31071;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_29081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_29081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29128 = f__28470__auto__();
(statearr_29128[(6)] = c__28469__auto___31023);

return statearr_29128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29155){
var state_val_29156 = (state_29155[(1)]);
if((state_val_29156 === (7))){
var inst_29151 = (state_29155[(2)]);
var state_29155__$1 = state_29155;
var statearr_29158_31077 = state_29155__$1;
(statearr_29158_31077[(2)] = inst_29151);

(statearr_29158_31077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (1))){
var inst_29134 = init;
var state_29155__$1 = (function (){var statearr_29159 = state_29155;
(statearr_29159[(7)] = inst_29134);

return statearr_29159;
})();
var statearr_29160_31079 = state_29155__$1;
(statearr_29160_31079[(2)] = null);

(statearr_29160_31079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (4))){
var inst_29137 = (state_29155[(8)]);
var inst_29137__$1 = (state_29155[(2)]);
var inst_29139 = (inst_29137__$1 == null);
var state_29155__$1 = (function (){var statearr_29161 = state_29155;
(statearr_29161[(8)] = inst_29137__$1);

return statearr_29161;
})();
if(cljs.core.truth_(inst_29139)){
var statearr_29165_31081 = state_29155__$1;
(statearr_29165_31081[(1)] = (5));

} else {
var statearr_29166_31084 = state_29155__$1;
(statearr_29166_31084[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (6))){
var inst_29134 = (state_29155[(7)]);
var inst_29142 = (state_29155[(9)]);
var inst_29137 = (state_29155[(8)]);
var inst_29142__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_29134,inst_29137) : f.call(null,inst_29134,inst_29137));
var inst_29143 = cljs.core.reduced_QMARK_(inst_29142__$1);
var state_29155__$1 = (function (){var statearr_29167 = state_29155;
(statearr_29167[(9)] = inst_29142__$1);

return statearr_29167;
})();
if(inst_29143){
var statearr_29168_31087 = state_29155__$1;
(statearr_29168_31087[(1)] = (8));

} else {
var statearr_29169_31088 = state_29155__$1;
(statearr_29169_31088[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (3))){
var inst_29153 = (state_29155[(2)]);
var state_29155__$1 = state_29155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29155__$1,inst_29153);
} else {
if((state_val_29156 === (2))){
var state_29155__$1 = state_29155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29155__$1,(4),ch);
} else {
if((state_val_29156 === (9))){
var inst_29142 = (state_29155[(9)]);
var inst_29134 = inst_29142;
var state_29155__$1 = (function (){var statearr_29170 = state_29155;
(statearr_29170[(7)] = inst_29134);

return statearr_29170;
})();
var statearr_29172_31094 = state_29155__$1;
(statearr_29172_31094[(2)] = null);

(statearr_29172_31094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (5))){
var inst_29134 = (state_29155[(7)]);
var state_29155__$1 = state_29155;
var statearr_29173_31095 = state_29155__$1;
(statearr_29173_31095[(2)] = inst_29134);

(statearr_29173_31095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (10))){
var inst_29149 = (state_29155[(2)]);
var state_29155__$1 = state_29155;
var statearr_29174_31097 = state_29155__$1;
(statearr_29174_31097[(2)] = inst_29149);

(statearr_29174_31097[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29156 === (8))){
var inst_29142 = (state_29155[(9)]);
var inst_29145 = cljs.core.deref(inst_29142);
var state_29155__$1 = state_29155;
var statearr_29175_31099 = state_29155__$1;
(statearr_29175_31099[(2)] = inst_29145);

(statearr_29175_31099[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28339__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28339__auto____0 = (function (){
var statearr_29176 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29176[(0)] = cljs$core$async$reduce_$_state_machine__28339__auto__);

(statearr_29176[(1)] = (1));

return statearr_29176;
});
var cljs$core$async$reduce_$_state_machine__28339__auto____1 = (function (state_29155){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29155);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29177){if((e29177 instanceof Object)){
var ex__28342__auto__ = e29177;
var statearr_29178_31104 = state_29155;
(statearr_29178_31104[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29155);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29177;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31108 = state_29155;
state_29155 = G__31108;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28339__auto__ = function(state_29155){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28339__auto____1.call(this,state_29155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28339__auto____0;
cljs$core$async$reduce_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28339__auto____1;
return cljs$core$async$reduce_$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29179 = f__28470__auto__();
(statearr_29179[(6)] = c__28469__auto__);

return statearr_29179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

return c__28469__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29188){
var state_val_29189 = (state_29188[(1)]);
if((state_val_29189 === (1))){
var inst_29183 = cljs.core.async.reduce(f__$1,init,ch);
var state_29188__$1 = state_29188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29188__$1,(2),inst_29183);
} else {
if((state_val_29189 === (2))){
var inst_29185 = (state_29188[(2)]);
var inst_29186 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_29185) : f__$1.call(null,inst_29185));
var state_29188__$1 = state_29188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29188__$1,inst_29186);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28339__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28339__auto____0 = (function (){
var statearr_29190 = [null,null,null,null,null,null,null];
(statearr_29190[(0)] = cljs$core$async$transduce_$_state_machine__28339__auto__);

(statearr_29190[(1)] = (1));

return statearr_29190;
});
var cljs$core$async$transduce_$_state_machine__28339__auto____1 = (function (state_29188){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29188);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29191){if((e29191 instanceof Object)){
var ex__28342__auto__ = e29191;
var statearr_29192_31115 = state_29188;
(statearr_29192_31115[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29188);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29191;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31116 = state_29188;
state_29188 = G__31116;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28339__auto__ = function(state_29188){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28339__auto____1.call(this,state_29188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28339__auto____0;
cljs$core$async$transduce_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28339__auto____1;
return cljs$core$async$transduce_$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29193 = f__28470__auto__();
(statearr_29193[(6)] = c__28469__auto__);

return statearr_29193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

return c__28469__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29195 = arguments.length;
switch (G__29195) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29220){
var state_val_29221 = (state_29220[(1)]);
if((state_val_29221 === (7))){
var inst_29202 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
var statearr_29223_31121 = state_29220__$1;
(statearr_29223_31121[(2)] = inst_29202);

(statearr_29223_31121[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (1))){
var inst_29196 = cljs.core.seq(coll);
var inst_29197 = inst_29196;
var state_29220__$1 = (function (){var statearr_29225 = state_29220;
(statearr_29225[(7)] = inst_29197);

return statearr_29225;
})();
var statearr_29226_31122 = state_29220__$1;
(statearr_29226_31122[(2)] = null);

(statearr_29226_31122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (4))){
var inst_29197 = (state_29220[(7)]);
var inst_29200 = cljs.core.first(inst_29197);
var state_29220__$1 = state_29220;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29220__$1,(7),ch,inst_29200);
} else {
if((state_val_29221 === (13))){
var inst_29214 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
var statearr_29227_31126 = state_29220__$1;
(statearr_29227_31126[(2)] = inst_29214);

(statearr_29227_31126[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (6))){
var inst_29205 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
if(cljs.core.truth_(inst_29205)){
var statearr_29228_31127 = state_29220__$1;
(statearr_29228_31127[(1)] = (8));

} else {
var statearr_29229_31128 = state_29220__$1;
(statearr_29229_31128[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (3))){
var inst_29218 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29220__$1,inst_29218);
} else {
if((state_val_29221 === (12))){
var state_29220__$1 = state_29220;
var statearr_29230_31129 = state_29220__$1;
(statearr_29230_31129[(2)] = null);

(statearr_29230_31129[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (2))){
var inst_29197 = (state_29220[(7)]);
var state_29220__$1 = state_29220;
if(cljs.core.truth_(inst_29197)){
var statearr_29231_31132 = state_29220__$1;
(statearr_29231_31132[(1)] = (4));

} else {
var statearr_29232_31133 = state_29220__$1;
(statearr_29232_31133[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (11))){
var inst_29211 = cljs.core.async.close_BANG_(ch);
var state_29220__$1 = state_29220;
var statearr_29233_31134 = state_29220__$1;
(statearr_29233_31134[(2)] = inst_29211);

(statearr_29233_31134[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (9))){
var state_29220__$1 = state_29220;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29234_31135 = state_29220__$1;
(statearr_29234_31135[(1)] = (11));

} else {
var statearr_29235_31136 = state_29220__$1;
(statearr_29235_31136[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (5))){
var inst_29197 = (state_29220[(7)]);
var state_29220__$1 = state_29220;
var statearr_29236_31137 = state_29220__$1;
(statearr_29236_31137[(2)] = inst_29197);

(statearr_29236_31137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (10))){
var inst_29216 = (state_29220[(2)]);
var state_29220__$1 = state_29220;
var statearr_29237_31138 = state_29220__$1;
(statearr_29237_31138[(2)] = inst_29216);

(statearr_29237_31138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29221 === (8))){
var inst_29197 = (state_29220[(7)]);
var inst_29207 = cljs.core.next(inst_29197);
var inst_29197__$1 = inst_29207;
var state_29220__$1 = (function (){var statearr_29238 = state_29220;
(statearr_29238[(7)] = inst_29197__$1);

return statearr_29238;
})();
var statearr_29239_31140 = state_29220__$1;
(statearr_29239_31140[(2)] = null);

(statearr_29239_31140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_29240 = [null,null,null,null,null,null,null,null];
(statearr_29240[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_29240[(1)] = (1));

return statearr_29240;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_29220){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29220);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29241){if((e29241 instanceof Object)){
var ex__28342__auto__ = e29241;
var statearr_29242_31142 = state_29220;
(statearr_29242_31142[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29220);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29241;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31144 = state_29220;
state_29220 = G__31144;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_29220){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_29220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29243 = f__28470__auto__();
(statearr_29243[(6)] = c__28469__auto__);

return statearr_29243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

return c__28469__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31146 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31146(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31150 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31150(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31155 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31155(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31158 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31158(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29250 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29250 = (function (ch,cs,meta29251){
this.ch = ch;
this.cs = cs;
this.meta29251 = meta29251;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29252,meta29251__$1){
var self__ = this;
var _29252__$1 = this;
return (new cljs.core.async.t_cljs$core$async29250(self__.ch,self__.cs,meta29251__$1));
}));

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29252){
var self__ = this;
var _29252__$1 = this;
return self__.meta29251;
}));

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29250.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29250.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29251","meta29251",1276169947,null)], null);
}));

(cljs.core.async.t_cljs$core$async29250.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29250.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29250");

(cljs.core.async.t_cljs$core$async29250.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29250");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29250.
 */
cljs.core.async.__GT_t_cljs$core$async29250 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29250(ch__$1,cs__$1,meta29251){
return (new cljs.core.async.t_cljs$core$async29250(ch__$1,cs__$1,meta29251));
});

}

return (new cljs.core.async.t_cljs$core$async29250(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28469__auto___31169 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29400){
var state_val_29401 = (state_29400[(1)]);
if((state_val_29401 === (7))){
var inst_29393 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29411_31170 = state_29400__$1;
(statearr_29411_31170[(2)] = inst_29393);

(statearr_29411_31170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (20))){
var inst_29293 = (state_29400[(7)]);
var inst_29305 = cljs.core.first(inst_29293);
var inst_29306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29305,(0),null);
var inst_29307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29305,(1),null);
var state_29400__$1 = (function (){var statearr_29412 = state_29400;
(statearr_29412[(8)] = inst_29306);

return statearr_29412;
})();
if(cljs.core.truth_(inst_29307)){
var statearr_29413_31171 = state_29400__$1;
(statearr_29413_31171[(1)] = (22));

} else {
var statearr_29414_31172 = state_29400__$1;
(statearr_29414_31172[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (27))){
var inst_29262 = (state_29400[(9)]);
var inst_29340 = (state_29400[(10)]);
var inst_29345 = (state_29400[(11)]);
var inst_29338 = (state_29400[(12)]);
var inst_29345__$1 = cljs.core._nth(inst_29338,inst_29340);
var inst_29346 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29345__$1,inst_29262,done);
var state_29400__$1 = (function (){var statearr_29424 = state_29400;
(statearr_29424[(11)] = inst_29345__$1);

return statearr_29424;
})();
if(cljs.core.truth_(inst_29346)){
var statearr_29425_31174 = state_29400__$1;
(statearr_29425_31174[(1)] = (30));

} else {
var statearr_29426_31175 = state_29400__$1;
(statearr_29426_31175[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (1))){
var state_29400__$1 = state_29400;
var statearr_29427_31176 = state_29400__$1;
(statearr_29427_31176[(2)] = null);

(statearr_29427_31176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (24))){
var inst_29293 = (state_29400[(7)]);
var inst_29312 = (state_29400[(2)]);
var inst_29313 = cljs.core.next(inst_29293);
var inst_29271 = inst_29313;
var inst_29272 = null;
var inst_29273 = (0);
var inst_29274 = (0);
var state_29400__$1 = (function (){var statearr_29428 = state_29400;
(statearr_29428[(13)] = inst_29274);

(statearr_29428[(14)] = inst_29271);

(statearr_29428[(15)] = inst_29272);

(statearr_29428[(16)] = inst_29273);

(statearr_29428[(17)] = inst_29312);

return statearr_29428;
})();
var statearr_29429_31177 = state_29400__$1;
(statearr_29429_31177[(2)] = null);

(statearr_29429_31177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (39))){
var state_29400__$1 = state_29400;
var statearr_29433_31178 = state_29400__$1;
(statearr_29433_31178[(2)] = null);

(statearr_29433_31178[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (4))){
var inst_29262 = (state_29400[(9)]);
var inst_29262__$1 = (state_29400[(2)]);
var inst_29263 = (inst_29262__$1 == null);
var state_29400__$1 = (function (){var statearr_29434 = state_29400;
(statearr_29434[(9)] = inst_29262__$1);

return statearr_29434;
})();
if(cljs.core.truth_(inst_29263)){
var statearr_29435_31179 = state_29400__$1;
(statearr_29435_31179[(1)] = (5));

} else {
var statearr_29439_31180 = state_29400__$1;
(statearr_29439_31180[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (15))){
var inst_29274 = (state_29400[(13)]);
var inst_29271 = (state_29400[(14)]);
var inst_29272 = (state_29400[(15)]);
var inst_29273 = (state_29400[(16)]);
var inst_29289 = (state_29400[(2)]);
var inst_29290 = (inst_29274 + (1));
var tmp29430 = inst_29271;
var tmp29431 = inst_29272;
var tmp29432 = inst_29273;
var inst_29271__$1 = tmp29430;
var inst_29272__$1 = tmp29431;
var inst_29273__$1 = tmp29432;
var inst_29274__$1 = inst_29290;
var state_29400__$1 = (function (){var statearr_29440 = state_29400;
(statearr_29440[(13)] = inst_29274__$1);

(statearr_29440[(14)] = inst_29271__$1);

(statearr_29440[(15)] = inst_29272__$1);

(statearr_29440[(18)] = inst_29289);

(statearr_29440[(16)] = inst_29273__$1);

return statearr_29440;
})();
var statearr_29441_31181 = state_29400__$1;
(statearr_29441_31181[(2)] = null);

(statearr_29441_31181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (21))){
var inst_29316 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29445_31182 = state_29400__$1;
(statearr_29445_31182[(2)] = inst_29316);

(statearr_29445_31182[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (31))){
var inst_29345 = (state_29400[(11)]);
var inst_29349 = done(null);
var inst_29350 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29345);
var state_29400__$1 = (function (){var statearr_29446 = state_29400;
(statearr_29446[(19)] = inst_29349);

return statearr_29446;
})();
var statearr_29447_31183 = state_29400__$1;
(statearr_29447_31183[(2)] = inst_29350);

(statearr_29447_31183[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (32))){
var inst_29340 = (state_29400[(10)]);
var inst_29339 = (state_29400[(20)]);
var inst_29337 = (state_29400[(21)]);
var inst_29338 = (state_29400[(12)]);
var inst_29352 = (state_29400[(2)]);
var inst_29353 = (inst_29340 + (1));
var tmp29442 = inst_29339;
var tmp29443 = inst_29337;
var tmp29444 = inst_29338;
var inst_29337__$1 = tmp29443;
var inst_29338__$1 = tmp29444;
var inst_29339__$1 = tmp29442;
var inst_29340__$1 = inst_29353;
var state_29400__$1 = (function (){var statearr_29451 = state_29400;
(statearr_29451[(10)] = inst_29340__$1);

(statearr_29451[(20)] = inst_29339__$1);

(statearr_29451[(22)] = inst_29352);

(statearr_29451[(21)] = inst_29337__$1);

(statearr_29451[(12)] = inst_29338__$1);

return statearr_29451;
})();
var statearr_29452_31192 = state_29400__$1;
(statearr_29452_31192[(2)] = null);

(statearr_29452_31192[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (40))){
var inst_29365 = (state_29400[(23)]);
var inst_29369 = done(null);
var inst_29370 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29365);
var state_29400__$1 = (function (){var statearr_29453 = state_29400;
(statearr_29453[(24)] = inst_29369);

return statearr_29453;
})();
var statearr_29454_31193 = state_29400__$1;
(statearr_29454_31193[(2)] = inst_29370);

(statearr_29454_31193[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (33))){
var inst_29356 = (state_29400[(25)]);
var inst_29358 = cljs.core.chunked_seq_QMARK_(inst_29356);
var state_29400__$1 = state_29400;
if(inst_29358){
var statearr_29455_31198 = state_29400__$1;
(statearr_29455_31198[(1)] = (36));

} else {
var statearr_29456_31205 = state_29400__$1;
(statearr_29456_31205[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (13))){
var inst_29283 = (state_29400[(26)]);
var inst_29286 = cljs.core.async.close_BANG_(inst_29283);
var state_29400__$1 = state_29400;
var statearr_29460_31206 = state_29400__$1;
(statearr_29460_31206[(2)] = inst_29286);

(statearr_29460_31206[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (22))){
var inst_29306 = (state_29400[(8)]);
var inst_29309 = cljs.core.async.close_BANG_(inst_29306);
var state_29400__$1 = state_29400;
var statearr_29461_31207 = state_29400__$1;
(statearr_29461_31207[(2)] = inst_29309);

(statearr_29461_31207[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (36))){
var inst_29356 = (state_29400[(25)]);
var inst_29360 = cljs.core.chunk_first(inst_29356);
var inst_29361 = cljs.core.chunk_rest(inst_29356);
var inst_29362 = cljs.core.count(inst_29360);
var inst_29337 = inst_29361;
var inst_29338 = inst_29360;
var inst_29339 = inst_29362;
var inst_29340 = (0);
var state_29400__$1 = (function (){var statearr_29462 = state_29400;
(statearr_29462[(10)] = inst_29340);

(statearr_29462[(20)] = inst_29339);

(statearr_29462[(21)] = inst_29337);

(statearr_29462[(12)] = inst_29338);

return statearr_29462;
})();
var statearr_29466_31210 = state_29400__$1;
(statearr_29466_31210[(2)] = null);

(statearr_29466_31210[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (41))){
var inst_29356 = (state_29400[(25)]);
var inst_29372 = (state_29400[(2)]);
var inst_29373 = cljs.core.next(inst_29356);
var inst_29337 = inst_29373;
var inst_29338 = null;
var inst_29339 = (0);
var inst_29340 = (0);
var state_29400__$1 = (function (){var statearr_29467 = state_29400;
(statearr_29467[(27)] = inst_29372);

(statearr_29467[(10)] = inst_29340);

(statearr_29467[(20)] = inst_29339);

(statearr_29467[(21)] = inst_29337);

(statearr_29467[(12)] = inst_29338);

return statearr_29467;
})();
var statearr_29468_31211 = state_29400__$1;
(statearr_29468_31211[(2)] = null);

(statearr_29468_31211[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (43))){
var state_29400__$1 = state_29400;
var statearr_29473_31216 = state_29400__$1;
(statearr_29473_31216[(2)] = null);

(statearr_29473_31216[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (29))){
var inst_29381 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29474_31217 = state_29400__$1;
(statearr_29474_31217[(2)] = inst_29381);

(statearr_29474_31217[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (44))){
var inst_29390 = (state_29400[(2)]);
var state_29400__$1 = (function (){var statearr_29475 = state_29400;
(statearr_29475[(28)] = inst_29390);

return statearr_29475;
})();
var statearr_29477_31218 = state_29400__$1;
(statearr_29477_31218[(2)] = null);

(statearr_29477_31218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (6))){
var inst_29329 = (state_29400[(29)]);
var inst_29328 = cljs.core.deref(cs);
var inst_29329__$1 = cljs.core.keys(inst_29328);
var inst_29330 = cljs.core.count(inst_29329__$1);
var inst_29331 = cljs.core.reset_BANG_(dctr,inst_29330);
var inst_29336 = cljs.core.seq(inst_29329__$1);
var inst_29337 = inst_29336;
var inst_29338 = null;
var inst_29339 = (0);
var inst_29340 = (0);
var state_29400__$1 = (function (){var statearr_29481 = state_29400;
(statearr_29481[(30)] = inst_29331);

(statearr_29481[(10)] = inst_29340);

(statearr_29481[(20)] = inst_29339);

(statearr_29481[(29)] = inst_29329__$1);

(statearr_29481[(21)] = inst_29337);

(statearr_29481[(12)] = inst_29338);

return statearr_29481;
})();
var statearr_29482_31221 = state_29400__$1;
(statearr_29482_31221[(2)] = null);

(statearr_29482_31221[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (28))){
var inst_29356 = (state_29400[(25)]);
var inst_29337 = (state_29400[(21)]);
var inst_29356__$1 = cljs.core.seq(inst_29337);
var state_29400__$1 = (function (){var statearr_29484 = state_29400;
(statearr_29484[(25)] = inst_29356__$1);

return statearr_29484;
})();
if(inst_29356__$1){
var statearr_29485_31226 = state_29400__$1;
(statearr_29485_31226[(1)] = (33));

} else {
var statearr_29486_31227 = state_29400__$1;
(statearr_29486_31227[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (25))){
var inst_29340 = (state_29400[(10)]);
var inst_29339 = (state_29400[(20)]);
var inst_29342 = (inst_29340 < inst_29339);
var inst_29343 = inst_29342;
var state_29400__$1 = state_29400;
if(cljs.core.truth_(inst_29343)){
var statearr_29487_31228 = state_29400__$1;
(statearr_29487_31228[(1)] = (27));

} else {
var statearr_29488_31229 = state_29400__$1;
(statearr_29488_31229[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (34))){
var state_29400__$1 = state_29400;
var statearr_29489_31232 = state_29400__$1;
(statearr_29489_31232[(2)] = null);

(statearr_29489_31232[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (17))){
var state_29400__$1 = state_29400;
var statearr_29491_31233 = state_29400__$1;
(statearr_29491_31233[(2)] = null);

(statearr_29491_31233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (3))){
var inst_29395 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29400__$1,inst_29395);
} else {
if((state_val_29401 === (12))){
var inst_29322 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29498_31234 = state_29400__$1;
(statearr_29498_31234[(2)] = inst_29322);

(statearr_29498_31234[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (2))){
var state_29400__$1 = state_29400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29400__$1,(4),ch);
} else {
if((state_val_29401 === (23))){
var state_29400__$1 = state_29400;
var statearr_29499_31239 = state_29400__$1;
(statearr_29499_31239[(2)] = null);

(statearr_29499_31239[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (35))){
var inst_29379 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29500_31240 = state_29400__$1;
(statearr_29500_31240[(2)] = inst_29379);

(statearr_29500_31240[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (19))){
var inst_29293 = (state_29400[(7)]);
var inst_29297 = cljs.core.chunk_first(inst_29293);
var inst_29298 = cljs.core.chunk_rest(inst_29293);
var inst_29299 = cljs.core.count(inst_29297);
var inst_29271 = inst_29298;
var inst_29272 = inst_29297;
var inst_29273 = inst_29299;
var inst_29274 = (0);
var state_29400__$1 = (function (){var statearr_29501 = state_29400;
(statearr_29501[(13)] = inst_29274);

(statearr_29501[(14)] = inst_29271);

(statearr_29501[(15)] = inst_29272);

(statearr_29501[(16)] = inst_29273);

return statearr_29501;
})();
var statearr_29502_31243 = state_29400__$1;
(statearr_29502_31243[(2)] = null);

(statearr_29502_31243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (11))){
var inst_29293 = (state_29400[(7)]);
var inst_29271 = (state_29400[(14)]);
var inst_29293__$1 = cljs.core.seq(inst_29271);
var state_29400__$1 = (function (){var statearr_29503 = state_29400;
(statearr_29503[(7)] = inst_29293__$1);

return statearr_29503;
})();
if(inst_29293__$1){
var statearr_29504_31244 = state_29400__$1;
(statearr_29504_31244[(1)] = (16));

} else {
var statearr_29505_31245 = state_29400__$1;
(statearr_29505_31245[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (9))){
var inst_29326 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29506_31250 = state_29400__$1;
(statearr_29506_31250[(2)] = inst_29326);

(statearr_29506_31250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (5))){
var inst_29269 = cljs.core.deref(cs);
var inst_29270 = cljs.core.seq(inst_29269);
var inst_29271 = inst_29270;
var inst_29272 = null;
var inst_29273 = (0);
var inst_29274 = (0);
var state_29400__$1 = (function (){var statearr_29507 = state_29400;
(statearr_29507[(13)] = inst_29274);

(statearr_29507[(14)] = inst_29271);

(statearr_29507[(15)] = inst_29272);

(statearr_29507[(16)] = inst_29273);

return statearr_29507;
})();
var statearr_29508_31251 = state_29400__$1;
(statearr_29508_31251[(2)] = null);

(statearr_29508_31251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (14))){
var state_29400__$1 = state_29400;
var statearr_29509_31254 = state_29400__$1;
(statearr_29509_31254[(2)] = null);

(statearr_29509_31254[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (45))){
var inst_29387 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29510_31255 = state_29400__$1;
(statearr_29510_31255[(2)] = inst_29387);

(statearr_29510_31255[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (26))){
var inst_29329 = (state_29400[(29)]);
var inst_29383 = (state_29400[(2)]);
var inst_29384 = cljs.core.seq(inst_29329);
var state_29400__$1 = (function (){var statearr_29511 = state_29400;
(statearr_29511[(31)] = inst_29383);

return statearr_29511;
})();
if(inst_29384){
var statearr_29512_31256 = state_29400__$1;
(statearr_29512_31256[(1)] = (42));

} else {
var statearr_29513_31257 = state_29400__$1;
(statearr_29513_31257[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (16))){
var inst_29293 = (state_29400[(7)]);
var inst_29295 = cljs.core.chunked_seq_QMARK_(inst_29293);
var state_29400__$1 = state_29400;
if(inst_29295){
var statearr_29514_31262 = state_29400__$1;
(statearr_29514_31262[(1)] = (19));

} else {
var statearr_29515_31263 = state_29400__$1;
(statearr_29515_31263[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (38))){
var inst_29376 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29516_31264 = state_29400__$1;
(statearr_29516_31264[(2)] = inst_29376);

(statearr_29516_31264[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (30))){
var state_29400__$1 = state_29400;
var statearr_29517_31265 = state_29400__$1;
(statearr_29517_31265[(2)] = null);

(statearr_29517_31265[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (10))){
var inst_29274 = (state_29400[(13)]);
var inst_29272 = (state_29400[(15)]);
var inst_29282 = cljs.core._nth(inst_29272,inst_29274);
var inst_29283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29282,(0),null);
var inst_29284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29282,(1),null);
var state_29400__$1 = (function (){var statearr_29520 = state_29400;
(statearr_29520[(26)] = inst_29283);

return statearr_29520;
})();
if(cljs.core.truth_(inst_29284)){
var statearr_29521_31268 = state_29400__$1;
(statearr_29521_31268[(1)] = (13));

} else {
var statearr_29522_31269 = state_29400__$1;
(statearr_29522_31269[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (18))){
var inst_29319 = (state_29400[(2)]);
var state_29400__$1 = state_29400;
var statearr_29523_31270 = state_29400__$1;
(statearr_29523_31270[(2)] = inst_29319);

(statearr_29523_31270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (42))){
var state_29400__$1 = state_29400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29400__$1,(45),dchan);
} else {
if((state_val_29401 === (37))){
var inst_29262 = (state_29400[(9)]);
var inst_29356 = (state_29400[(25)]);
var inst_29365 = (state_29400[(23)]);
var inst_29365__$1 = cljs.core.first(inst_29356);
var inst_29366 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29365__$1,inst_29262,done);
var state_29400__$1 = (function (){var statearr_29524 = state_29400;
(statearr_29524[(23)] = inst_29365__$1);

return statearr_29524;
})();
if(cljs.core.truth_(inst_29366)){
var statearr_29525_31275 = state_29400__$1;
(statearr_29525_31275[(1)] = (39));

} else {
var statearr_29526_31276 = state_29400__$1;
(statearr_29526_31276[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29401 === (8))){
var inst_29274 = (state_29400[(13)]);
var inst_29273 = (state_29400[(16)]);
var inst_29276 = (inst_29274 < inst_29273);
var inst_29277 = inst_29276;
var state_29400__$1 = state_29400;
if(cljs.core.truth_(inst_29277)){
var statearr_29527_31278 = state_29400__$1;
(statearr_29527_31278[(1)] = (10));

} else {
var statearr_29528_31281 = state_29400__$1;
(statearr_29528_31281[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28339__auto__ = null;
var cljs$core$async$mult_$_state_machine__28339__auto____0 = (function (){
var statearr_29533 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29533[(0)] = cljs$core$async$mult_$_state_machine__28339__auto__);

(statearr_29533[(1)] = (1));

return statearr_29533;
});
var cljs$core$async$mult_$_state_machine__28339__auto____1 = (function (state_29400){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29400);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29535){if((e29535 instanceof Object)){
var ex__28342__auto__ = e29535;
var statearr_29536_31283 = state_29400;
(statearr_29536_31283[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29535;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31287 = state_29400;
state_29400 = G__31287;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28339__auto__ = function(state_29400){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28339__auto____1.call(this,state_29400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28339__auto____0;
cljs$core$async$mult_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28339__auto____1;
return cljs$core$async$mult_$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29537 = f__28470__auto__();
(statearr_29537[(6)] = c__28469__auto___31169);

return statearr_29537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29540 = arguments.length;
switch (G__29540) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31291 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31291(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31296 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31296(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31297 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31297(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31299 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31299(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31301 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31301(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31302 = arguments.length;
var i__4737__auto___31303 = (0);
while(true){
if((i__4737__auto___31303 < len__4736__auto___31302)){
args__4742__auto__.push((arguments[i__4737__auto___31303]));

var G__31304 = (i__4737__auto___31303 + (1));
i__4737__auto___31303 = G__31304;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29553){
var map__29554 = p__29553;
var map__29554__$1 = (((((!((map__29554 == null))))?(((((map__29554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29554):map__29554);
var opts = map__29554__$1;
var statearr_29556_31305 = state;
(statearr_29556_31305[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29557_31306 = state;
(statearr_29557_31306[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_29558_31307 = state;
(statearr_29558_31307[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29549){
var G__29550 = cljs.core.first(seq29549);
var seq29549__$1 = cljs.core.next(seq29549);
var G__29551 = cljs.core.first(seq29549__$1);
var seq29549__$2 = cljs.core.next(seq29549__$1);
var G__29552 = cljs.core.first(seq29549__$2);
var seq29549__$3 = cljs.core.next(seq29549__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29550,G__29551,G__29552,seq29549__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29568 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29568 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29569){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29569 = meta29569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29570,meta29569__$1){
var self__ = this;
var _29570__$1 = this;
return (new cljs.core.async.t_cljs$core$async29568(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29569__$1));
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29570){
var self__ = this;
var _29570__$1 = this;
return self__.meta29569;
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29568.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29569","meta29569",2121250628,null)], null);
}));

(cljs.core.async.t_cljs$core$async29568.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29568");

(cljs.core.async.t_cljs$core$async29568.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29568");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29568.
 */
cljs.core.async.__GT_t_cljs$core$async29568 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29568(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29569){
return (new cljs.core.async.t_cljs$core$async29568(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29569));
});

}

return (new cljs.core.async.t_cljs$core$async29568(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28469__auto___31403 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29679){
var state_val_29680 = (state_29679[(1)]);
if((state_val_29680 === (7))){
var inst_29588 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
var statearr_29681_31405 = state_29679__$1;
(statearr_29681_31405[(2)] = inst_29588);

(statearr_29681_31405[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (20))){
var inst_29600 = (state_29679[(7)]);
var state_29679__$1 = state_29679;
var statearr_29682_31407 = state_29679__$1;
(statearr_29682_31407[(2)] = inst_29600);

(statearr_29682_31407[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (27))){
var state_29679__$1 = state_29679;
var statearr_29683_31409 = state_29679__$1;
(statearr_29683_31409[(2)] = null);

(statearr_29683_31409[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (1))){
var inst_29575 = (state_29679[(8)]);
var inst_29575__$1 = calc_state();
var inst_29577 = (inst_29575__$1 == null);
var inst_29578 = cljs.core.not(inst_29577);
var state_29679__$1 = (function (){var statearr_29688 = state_29679;
(statearr_29688[(8)] = inst_29575__$1);

return statearr_29688;
})();
if(inst_29578){
var statearr_29689_31412 = state_29679__$1;
(statearr_29689_31412[(1)] = (2));

} else {
var statearr_29690_31414 = state_29679__$1;
(statearr_29690_31414[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (24))){
var inst_29653 = (state_29679[(9)]);
var inst_29636 = (state_29679[(10)]);
var inst_29624 = (state_29679[(11)]);
var inst_29653__$1 = (inst_29624.cljs$core$IFn$_invoke$arity$1 ? inst_29624.cljs$core$IFn$_invoke$arity$1(inst_29636) : inst_29624.call(null,inst_29636));
var state_29679__$1 = (function (){var statearr_29698 = state_29679;
(statearr_29698[(9)] = inst_29653__$1);

return statearr_29698;
})();
if(cljs.core.truth_(inst_29653__$1)){
var statearr_29699_31416 = state_29679__$1;
(statearr_29699_31416[(1)] = (29));

} else {
var statearr_29700_31418 = state_29679__$1;
(statearr_29700_31418[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (4))){
var inst_29591 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29591)){
var statearr_29701_31419 = state_29679__$1;
(statearr_29701_31419[(1)] = (8));

} else {
var statearr_29702_31420 = state_29679__$1;
(statearr_29702_31420[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (15))){
var inst_29618 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29618)){
var statearr_29705_31423 = state_29679__$1;
(statearr_29705_31423[(1)] = (19));

} else {
var statearr_29706_31425 = state_29679__$1;
(statearr_29706_31425[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (21))){
var inst_29623 = (state_29679[(12)]);
var inst_29623__$1 = (state_29679[(2)]);
var inst_29624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29623__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29623__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29626 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29623__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29679__$1 = (function (){var statearr_29710 = state_29679;
(statearr_29710[(12)] = inst_29623__$1);

(statearr_29710[(11)] = inst_29624);

(statearr_29710[(13)] = inst_29625);

return statearr_29710;
})();
return cljs.core.async.ioc_alts_BANG_(state_29679__$1,(22),inst_29626);
} else {
if((state_val_29680 === (31))){
var inst_29661 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29661)){
var statearr_29711_31429 = state_29679__$1;
(statearr_29711_31429[(1)] = (32));

} else {
var statearr_29712_31430 = state_29679__$1;
(statearr_29712_31430[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (32))){
var inst_29632 = (state_29679[(14)]);
var state_29679__$1 = state_29679;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29679__$1,(35),out,inst_29632);
} else {
if((state_val_29680 === (33))){
var inst_29623 = (state_29679[(12)]);
var inst_29600 = inst_29623;
var state_29679__$1 = (function (){var statearr_29715 = state_29679;
(statearr_29715[(7)] = inst_29600);

return statearr_29715;
})();
var statearr_29717_31434 = state_29679__$1;
(statearr_29717_31434[(2)] = null);

(statearr_29717_31434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (13))){
var inst_29600 = (state_29679[(7)]);
var inst_29607 = inst_29600.cljs$lang$protocol_mask$partition0$;
var inst_29608 = (inst_29607 & (64));
var inst_29609 = inst_29600.cljs$core$ISeq$;
var inst_29610 = (cljs.core.PROTOCOL_SENTINEL === inst_29609);
var inst_29611 = ((inst_29608) || (inst_29610));
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29611)){
var statearr_29718_31439 = state_29679__$1;
(statearr_29718_31439[(1)] = (16));

} else {
var statearr_29719_31440 = state_29679__$1;
(statearr_29719_31440[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (22))){
var inst_29632 = (state_29679[(14)]);
var inst_29636 = (state_29679[(10)]);
var inst_29631 = (state_29679[(2)]);
var inst_29632__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29631,(0),null);
var inst_29636__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29631,(1),null);
var inst_29637 = (inst_29632__$1 == null);
var inst_29638 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29636__$1,change);
var inst_29639 = ((inst_29637) || (inst_29638));
var state_29679__$1 = (function (){var statearr_29726 = state_29679;
(statearr_29726[(14)] = inst_29632__$1);

(statearr_29726[(10)] = inst_29636__$1);

return statearr_29726;
})();
if(cljs.core.truth_(inst_29639)){
var statearr_29727_31443 = state_29679__$1;
(statearr_29727_31443[(1)] = (23));

} else {
var statearr_29728_31444 = state_29679__$1;
(statearr_29728_31444[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (36))){
var inst_29623 = (state_29679[(12)]);
var inst_29600 = inst_29623;
var state_29679__$1 = (function (){var statearr_29729 = state_29679;
(statearr_29729[(7)] = inst_29600);

return statearr_29729;
})();
var statearr_29730_31446 = state_29679__$1;
(statearr_29730_31446[(2)] = null);

(statearr_29730_31446[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (29))){
var inst_29653 = (state_29679[(9)]);
var state_29679__$1 = state_29679;
var statearr_29731_31452 = state_29679__$1;
(statearr_29731_31452[(2)] = inst_29653);

(statearr_29731_31452[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (6))){
var state_29679__$1 = state_29679;
var statearr_29732_31456 = state_29679__$1;
(statearr_29732_31456[(2)] = false);

(statearr_29732_31456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (28))){
var inst_29646 = (state_29679[(2)]);
var inst_29647 = calc_state();
var inst_29600 = inst_29647;
var state_29679__$1 = (function (){var statearr_29733 = state_29679;
(statearr_29733[(15)] = inst_29646);

(statearr_29733[(7)] = inst_29600);

return statearr_29733;
})();
var statearr_29734_31461 = state_29679__$1;
(statearr_29734_31461[(2)] = null);

(statearr_29734_31461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (25))){
var inst_29675 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
var statearr_29736_31470 = state_29679__$1;
(statearr_29736_31470[(2)] = inst_29675);

(statearr_29736_31470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (34))){
var inst_29673 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
var statearr_29737_31474 = state_29679__$1;
(statearr_29737_31474[(2)] = inst_29673);

(statearr_29737_31474[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (17))){
var state_29679__$1 = state_29679;
var statearr_29738_31475 = state_29679__$1;
(statearr_29738_31475[(2)] = false);

(statearr_29738_31475[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (3))){
var state_29679__$1 = state_29679;
var statearr_29739_31480 = state_29679__$1;
(statearr_29739_31480[(2)] = false);

(statearr_29739_31480[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (12))){
var inst_29677 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29679__$1,inst_29677);
} else {
if((state_val_29680 === (2))){
var inst_29575 = (state_29679[(8)]);
var inst_29580 = inst_29575.cljs$lang$protocol_mask$partition0$;
var inst_29581 = (inst_29580 & (64));
var inst_29582 = inst_29575.cljs$core$ISeq$;
var inst_29583 = (cljs.core.PROTOCOL_SENTINEL === inst_29582);
var inst_29584 = ((inst_29581) || (inst_29583));
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29584)){
var statearr_29740_31483 = state_29679__$1;
(statearr_29740_31483[(1)] = (5));

} else {
var statearr_29741_31484 = state_29679__$1;
(statearr_29741_31484[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (23))){
var inst_29632 = (state_29679[(14)]);
var inst_29641 = (inst_29632 == null);
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29641)){
var statearr_29742_31487 = state_29679__$1;
(statearr_29742_31487[(1)] = (26));

} else {
var statearr_29744_31488 = state_29679__$1;
(statearr_29744_31488[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (35))){
var inst_29664 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
if(cljs.core.truth_(inst_29664)){
var statearr_29748_31489 = state_29679__$1;
(statearr_29748_31489[(1)] = (36));

} else {
var statearr_29749_31490 = state_29679__$1;
(statearr_29749_31490[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (19))){
var inst_29600 = (state_29679[(7)]);
var inst_29620 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29600);
var state_29679__$1 = state_29679;
var statearr_29750_31492 = state_29679__$1;
(statearr_29750_31492[(2)] = inst_29620);

(statearr_29750_31492[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (11))){
var inst_29600 = (state_29679[(7)]);
var inst_29604 = (inst_29600 == null);
var inst_29605 = cljs.core.not(inst_29604);
var state_29679__$1 = state_29679;
if(inst_29605){
var statearr_29751_31493 = state_29679__$1;
(statearr_29751_31493[(1)] = (13));

} else {
var statearr_29752_31494 = state_29679__$1;
(statearr_29752_31494[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (9))){
var inst_29575 = (state_29679[(8)]);
var state_29679__$1 = state_29679;
var statearr_29756_31495 = state_29679__$1;
(statearr_29756_31495[(2)] = inst_29575);

(statearr_29756_31495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (5))){
var state_29679__$1 = state_29679;
var statearr_29757_31500 = state_29679__$1;
(statearr_29757_31500[(2)] = true);

(statearr_29757_31500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (14))){
var state_29679__$1 = state_29679;
var statearr_29758_31502 = state_29679__$1;
(statearr_29758_31502[(2)] = false);

(statearr_29758_31502[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (26))){
var inst_29636 = (state_29679[(10)]);
var inst_29643 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29636);
var state_29679__$1 = state_29679;
var statearr_29762_31504 = state_29679__$1;
(statearr_29762_31504[(2)] = inst_29643);

(statearr_29762_31504[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (16))){
var state_29679__$1 = state_29679;
var statearr_29767_31515 = state_29679__$1;
(statearr_29767_31515[(2)] = true);

(statearr_29767_31515[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (38))){
var inst_29669 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
var statearr_29774_31521 = state_29679__$1;
(statearr_29774_31521[(2)] = inst_29669);

(statearr_29774_31521[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (30))){
var inst_29636 = (state_29679[(10)]);
var inst_29624 = (state_29679[(11)]);
var inst_29625 = (state_29679[(13)]);
var inst_29656 = cljs.core.empty_QMARK_(inst_29624);
var inst_29657 = (inst_29625.cljs$core$IFn$_invoke$arity$1 ? inst_29625.cljs$core$IFn$_invoke$arity$1(inst_29636) : inst_29625.call(null,inst_29636));
var inst_29658 = cljs.core.not(inst_29657);
var inst_29659 = ((inst_29656) && (inst_29658));
var state_29679__$1 = state_29679;
var statearr_29778_31544 = state_29679__$1;
(statearr_29778_31544[(2)] = inst_29659);

(statearr_29778_31544[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (10))){
var inst_29575 = (state_29679[(8)]);
var inst_29596 = (state_29679[(2)]);
var inst_29597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29596,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29596,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29596,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29600 = inst_29575;
var state_29679__$1 = (function (){var statearr_29779 = state_29679;
(statearr_29779[(16)] = inst_29599);

(statearr_29779[(7)] = inst_29600);

(statearr_29779[(17)] = inst_29598);

(statearr_29779[(18)] = inst_29597);

return statearr_29779;
})();
var statearr_29780_31576 = state_29679__$1;
(statearr_29780_31576[(2)] = null);

(statearr_29780_31576[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (18))){
var inst_29615 = (state_29679[(2)]);
var state_29679__$1 = state_29679;
var statearr_29781_31579 = state_29679__$1;
(statearr_29781_31579[(2)] = inst_29615);

(statearr_29781_31579[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (37))){
var state_29679__$1 = state_29679;
var statearr_29782_31580 = state_29679__$1;
(statearr_29782_31580[(2)] = null);

(statearr_29782_31580[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29680 === (8))){
var inst_29575 = (state_29679[(8)]);
var inst_29593 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29575);
var state_29679__$1 = state_29679;
var statearr_29784_31581 = state_29679__$1;
(statearr_29784_31581[(2)] = inst_29593);

(statearr_29784_31581[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28339__auto__ = null;
var cljs$core$async$mix_$_state_machine__28339__auto____0 = (function (){
var statearr_29787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29787[(0)] = cljs$core$async$mix_$_state_machine__28339__auto__);

(statearr_29787[(1)] = (1));

return statearr_29787;
});
var cljs$core$async$mix_$_state_machine__28339__auto____1 = (function (state_29679){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29679);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29788){if((e29788 instanceof Object)){
var ex__28342__auto__ = e29788;
var statearr_29789_31589 = state_29679;
(statearr_29789_31589[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29679);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29788;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31590 = state_29679;
state_29679 = G__31590;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28339__auto__ = function(state_29679){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28339__auto____1.call(this,state_29679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28339__auto____0;
cljs$core$async$mix_$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28339__auto____1;
return cljs$core$async$mix_$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29792 = f__28470__auto__();
(statearr_29792[(6)] = c__28469__auto___31403);

return statearr_29792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_31598 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_31598(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_31605 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_31605(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_31609 = (function() {
var G__31610 = null;
var G__31610__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__31610__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__31610 = function(p,v){
switch(arguments.length){
case 1:
return G__31610__1.call(this,p);
case 2:
return G__31610__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31610.cljs$core$IFn$_invoke$arity$1 = G__31610__1;
G__31610.cljs$core$IFn$_invoke$arity$2 = G__31610__2;
return G__31610;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29800 = arguments.length;
switch (G__29800) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31609(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31609(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29804 = arguments.length;
switch (G__29804) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29802_SHARP_){
if(cljs.core.truth_((p1__29802_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29802_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29802_SHARP_.call(null,topic)))){
return p1__29802_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29802_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29812 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29812 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29813){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29813 = meta29813;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29814,meta29813__$1){
var self__ = this;
var _29814__$1 = this;
return (new cljs.core.async.t_cljs$core$async29812(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29813__$1));
}));

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29814){
var self__ = this;
var _29814__$1 = this;
return self__.meta29813;
}));

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29812.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29812.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29813","meta29813",-1173617856,null)], null);
}));

(cljs.core.async.t_cljs$core$async29812.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29812.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29812");

(cljs.core.async.t_cljs$core$async29812.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29812");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29812.
 */
cljs.core.async.__GT_t_cljs$core$async29812 = (function cljs$core$async$__GT_t_cljs$core$async29812(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29813){
return (new cljs.core.async.t_cljs$core$async29812(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29813));
});

}

return (new cljs.core.async.t_cljs$core$async29812(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28469__auto___31651 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_29886){
var state_val_29887 = (state_29886[(1)]);
if((state_val_29887 === (7))){
var inst_29882 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29888_31655 = state_29886__$1;
(statearr_29888_31655[(2)] = inst_29882);

(statearr_29888_31655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (20))){
var state_29886__$1 = state_29886;
var statearr_29890_31658 = state_29886__$1;
(statearr_29890_31658[(2)] = null);

(statearr_29890_31658[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (1))){
var state_29886__$1 = state_29886;
var statearr_29892_31660 = state_29886__$1;
(statearr_29892_31660[(2)] = null);

(statearr_29892_31660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (24))){
var inst_29865 = (state_29886[(7)]);
var inst_29874 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29865);
var state_29886__$1 = state_29886;
var statearr_29893_31664 = state_29886__$1;
(statearr_29893_31664[(2)] = inst_29874);

(statearr_29893_31664[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (4))){
var inst_29817 = (state_29886[(8)]);
var inst_29817__$1 = (state_29886[(2)]);
var inst_29818 = (inst_29817__$1 == null);
var state_29886__$1 = (function (){var statearr_29894 = state_29886;
(statearr_29894[(8)] = inst_29817__$1);

return statearr_29894;
})();
if(cljs.core.truth_(inst_29818)){
var statearr_29895_31666 = state_29886__$1;
(statearr_29895_31666[(1)] = (5));

} else {
var statearr_29896_31674 = state_29886__$1;
(statearr_29896_31674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (15))){
var inst_29859 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29897_31683 = state_29886__$1;
(statearr_29897_31683[(2)] = inst_29859);

(statearr_29897_31683[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (21))){
var inst_29879 = (state_29886[(2)]);
var state_29886__$1 = (function (){var statearr_29899 = state_29886;
(statearr_29899[(9)] = inst_29879);

return statearr_29899;
})();
var statearr_29900_31684 = state_29886__$1;
(statearr_29900_31684[(2)] = null);

(statearr_29900_31684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (13))){
var inst_29841 = (state_29886[(10)]);
var inst_29843 = cljs.core.chunked_seq_QMARK_(inst_29841);
var state_29886__$1 = state_29886;
if(inst_29843){
var statearr_29901_31687 = state_29886__$1;
(statearr_29901_31687[(1)] = (16));

} else {
var statearr_29902_31688 = state_29886__$1;
(statearr_29902_31688[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (22))){
var inst_29871 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
if(cljs.core.truth_(inst_29871)){
var statearr_29903_31690 = state_29886__$1;
(statearr_29903_31690[(1)] = (23));

} else {
var statearr_29904_31692 = state_29886__$1;
(statearr_29904_31692[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (6))){
var inst_29867 = (state_29886[(11)]);
var inst_29865 = (state_29886[(7)]);
var inst_29817 = (state_29886[(8)]);
var inst_29865__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29817) : topic_fn.call(null,inst_29817));
var inst_29866 = cljs.core.deref(mults);
var inst_29867__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29866,inst_29865__$1);
var state_29886__$1 = (function (){var statearr_29905 = state_29886;
(statearr_29905[(11)] = inst_29867__$1);

(statearr_29905[(7)] = inst_29865__$1);

return statearr_29905;
})();
if(cljs.core.truth_(inst_29867__$1)){
var statearr_29906_31696 = state_29886__$1;
(statearr_29906_31696[(1)] = (19));

} else {
var statearr_29907_31697 = state_29886__$1;
(statearr_29907_31697[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (25))){
var inst_29876 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29908_31698 = state_29886__$1;
(statearr_29908_31698[(2)] = inst_29876);

(statearr_29908_31698[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (17))){
var inst_29841 = (state_29886[(10)]);
var inst_29850 = cljs.core.first(inst_29841);
var inst_29851 = cljs.core.async.muxch_STAR_(inst_29850);
var inst_29852 = cljs.core.async.close_BANG_(inst_29851);
var inst_29853 = cljs.core.next(inst_29841);
var inst_29827 = inst_29853;
var inst_29828 = null;
var inst_29829 = (0);
var inst_29830 = (0);
var state_29886__$1 = (function (){var statearr_29909 = state_29886;
(statearr_29909[(12)] = inst_29827);

(statearr_29909[(13)] = inst_29829);

(statearr_29909[(14)] = inst_29852);

(statearr_29909[(15)] = inst_29828);

(statearr_29909[(16)] = inst_29830);

return statearr_29909;
})();
var statearr_29910_31703 = state_29886__$1;
(statearr_29910_31703[(2)] = null);

(statearr_29910_31703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (3))){
var inst_29884 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29886__$1,inst_29884);
} else {
if((state_val_29887 === (12))){
var inst_29861 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29912_31705 = state_29886__$1;
(statearr_29912_31705[(2)] = inst_29861);

(statearr_29912_31705[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (2))){
var state_29886__$1 = state_29886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29886__$1,(4),ch);
} else {
if((state_val_29887 === (23))){
var state_29886__$1 = state_29886;
var statearr_29913_31711 = state_29886__$1;
(statearr_29913_31711[(2)] = null);

(statearr_29913_31711[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (19))){
var inst_29867 = (state_29886[(11)]);
var inst_29817 = (state_29886[(8)]);
var inst_29869 = cljs.core.async.muxch_STAR_(inst_29867);
var state_29886__$1 = state_29886;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29886__$1,(22),inst_29869,inst_29817);
} else {
if((state_val_29887 === (11))){
var inst_29827 = (state_29886[(12)]);
var inst_29841 = (state_29886[(10)]);
var inst_29841__$1 = cljs.core.seq(inst_29827);
var state_29886__$1 = (function (){var statearr_29919 = state_29886;
(statearr_29919[(10)] = inst_29841__$1);

return statearr_29919;
})();
if(inst_29841__$1){
var statearr_29920_31723 = state_29886__$1;
(statearr_29920_31723[(1)] = (13));

} else {
var statearr_29921_31724 = state_29886__$1;
(statearr_29921_31724[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (9))){
var inst_29863 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29922_31725 = state_29886__$1;
(statearr_29922_31725[(2)] = inst_29863);

(statearr_29922_31725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (5))){
var inst_29824 = cljs.core.deref(mults);
var inst_29825 = cljs.core.vals(inst_29824);
var inst_29826 = cljs.core.seq(inst_29825);
var inst_29827 = inst_29826;
var inst_29828 = null;
var inst_29829 = (0);
var inst_29830 = (0);
var state_29886__$1 = (function (){var statearr_29927 = state_29886;
(statearr_29927[(12)] = inst_29827);

(statearr_29927[(13)] = inst_29829);

(statearr_29927[(15)] = inst_29828);

(statearr_29927[(16)] = inst_29830);

return statearr_29927;
})();
var statearr_29928_31729 = state_29886__$1;
(statearr_29928_31729[(2)] = null);

(statearr_29928_31729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (14))){
var state_29886__$1 = state_29886;
var statearr_29932_31734 = state_29886__$1;
(statearr_29932_31734[(2)] = null);

(statearr_29932_31734[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (16))){
var inst_29841 = (state_29886[(10)]);
var inst_29845 = cljs.core.chunk_first(inst_29841);
var inst_29846 = cljs.core.chunk_rest(inst_29841);
var inst_29847 = cljs.core.count(inst_29845);
var inst_29827 = inst_29846;
var inst_29828 = inst_29845;
var inst_29829 = inst_29847;
var inst_29830 = (0);
var state_29886__$1 = (function (){var statearr_29933 = state_29886;
(statearr_29933[(12)] = inst_29827);

(statearr_29933[(13)] = inst_29829);

(statearr_29933[(15)] = inst_29828);

(statearr_29933[(16)] = inst_29830);

return statearr_29933;
})();
var statearr_29937_31737 = state_29886__$1;
(statearr_29937_31737[(2)] = null);

(statearr_29937_31737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (10))){
var inst_29827 = (state_29886[(12)]);
var inst_29829 = (state_29886[(13)]);
var inst_29828 = (state_29886[(15)]);
var inst_29830 = (state_29886[(16)]);
var inst_29835 = cljs.core._nth(inst_29828,inst_29830);
var inst_29836 = cljs.core.async.muxch_STAR_(inst_29835);
var inst_29837 = cljs.core.async.close_BANG_(inst_29836);
var inst_29838 = (inst_29830 + (1));
var tmp29929 = inst_29827;
var tmp29930 = inst_29829;
var tmp29931 = inst_29828;
var inst_29827__$1 = tmp29929;
var inst_29828__$1 = tmp29931;
var inst_29829__$1 = tmp29930;
var inst_29830__$1 = inst_29838;
var state_29886__$1 = (function (){var statearr_29938 = state_29886;
(statearr_29938[(12)] = inst_29827__$1);

(statearr_29938[(17)] = inst_29837);

(statearr_29938[(13)] = inst_29829__$1);

(statearr_29938[(15)] = inst_29828__$1);

(statearr_29938[(16)] = inst_29830__$1);

return statearr_29938;
})();
var statearr_29939_31755 = state_29886__$1;
(statearr_29939_31755[(2)] = null);

(statearr_29939_31755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (18))){
var inst_29856 = (state_29886[(2)]);
var state_29886__$1 = state_29886;
var statearr_29943_31756 = state_29886__$1;
(statearr_29943_31756[(2)] = inst_29856);

(statearr_29943_31756[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29887 === (8))){
var inst_29829 = (state_29886[(13)]);
var inst_29830 = (state_29886[(16)]);
var inst_29832 = (inst_29830 < inst_29829);
var inst_29833 = inst_29832;
var state_29886__$1 = state_29886;
if(cljs.core.truth_(inst_29833)){
var statearr_29944_31764 = state_29886__$1;
(statearr_29944_31764[(1)] = (10));

} else {
var statearr_29945_31765 = state_29886__$1;
(statearr_29945_31765[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_29949 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29949[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_29949[(1)] = (1));

return statearr_29949;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_29886){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_29886);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e29950){if((e29950 instanceof Object)){
var ex__28342__auto__ = e29950;
var statearr_29951_31782 = state_29886;
(statearr_29951_31782[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29886);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29950;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31783 = state_29886;
state_29886 = G__31783;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_29886){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_29886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_29952 = f__28470__auto__();
(statearr_29952[(6)] = c__28469__auto___31651);

return statearr_29952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29960 = arguments.length;
switch (G__29960) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29966 = arguments.length;
switch (G__29966) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29972 = arguments.length;
switch (G__29972) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28469__auto___31807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30013){
var state_val_30014 = (state_30013[(1)]);
if((state_val_30014 === (7))){
var state_30013__$1 = state_30013;
var statearr_30015_31809 = state_30013__$1;
(statearr_30015_31809[(2)] = null);

(statearr_30015_31809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (1))){
var state_30013__$1 = state_30013;
var statearr_30016_31811 = state_30013__$1;
(statearr_30016_31811[(2)] = null);

(statearr_30016_31811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (4))){
var inst_29977 = (state_30013[(7)]);
var inst_29979 = (inst_29977 < cnt);
var state_30013__$1 = state_30013;
if(cljs.core.truth_(inst_29979)){
var statearr_30017_31814 = state_30013__$1;
(statearr_30017_31814[(1)] = (6));

} else {
var statearr_30019_31816 = state_30013__$1;
(statearr_30019_31816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (15))){
var inst_30009 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
var statearr_30022_31819 = state_30013__$1;
(statearr_30022_31819[(2)] = inst_30009);

(statearr_30022_31819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (13))){
var inst_30002 = cljs.core.async.close_BANG_(out);
var state_30013__$1 = state_30013;
var statearr_30023_31821 = state_30013__$1;
(statearr_30023_31821[(2)] = inst_30002);

(statearr_30023_31821[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (6))){
var state_30013__$1 = state_30013;
var statearr_30024_31824 = state_30013__$1;
(statearr_30024_31824[(2)] = null);

(statearr_30024_31824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (3))){
var inst_30011 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30013__$1,inst_30011);
} else {
if((state_val_30014 === (12))){
var inst_29999 = (state_30013[(8)]);
var inst_29999__$1 = (state_30013[(2)]);
var inst_30000 = cljs.core.some(cljs.core.nil_QMARK_,inst_29999__$1);
var state_30013__$1 = (function (){var statearr_30030 = state_30013;
(statearr_30030[(8)] = inst_29999__$1);

return statearr_30030;
})();
if(cljs.core.truth_(inst_30000)){
var statearr_30032_31827 = state_30013__$1;
(statearr_30032_31827[(1)] = (13));

} else {
var statearr_30033_31828 = state_30013__$1;
(statearr_30033_31828[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (2))){
var inst_29976 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29977 = (0);
var state_30013__$1 = (function (){var statearr_30034 = state_30013;
(statearr_30034[(9)] = inst_29976);

(statearr_30034[(7)] = inst_29977);

return statearr_30034;
})();
var statearr_30035_31830 = state_30013__$1;
(statearr_30035_31830[(2)] = null);

(statearr_30035_31830[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (11))){
var inst_29977 = (state_30013[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_30013,(10),Object,null,(9));
var inst_29986 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29977) : chs__$1.call(null,inst_29977));
var inst_29987 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29977) : done.call(null,inst_29977));
var inst_29988 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29986,inst_29987);
var state_30013__$1 = state_30013;
var statearr_30039_31832 = state_30013__$1;
(statearr_30039_31832[(2)] = inst_29988);


cljs.core.async.impl.ioc_helpers.process_exception(state_30013__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (9))){
var inst_29977 = (state_30013[(7)]);
var inst_29990 = (state_30013[(2)]);
var inst_29991 = (inst_29977 + (1));
var inst_29977__$1 = inst_29991;
var state_30013__$1 = (function (){var statearr_30040 = state_30013;
(statearr_30040[(7)] = inst_29977__$1);

(statearr_30040[(10)] = inst_29990);

return statearr_30040;
})();
var statearr_30041_31834 = state_30013__$1;
(statearr_30041_31834[(2)] = null);

(statearr_30041_31834[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (5))){
var inst_29997 = (state_30013[(2)]);
var state_30013__$1 = (function (){var statearr_30042 = state_30013;
(statearr_30042[(11)] = inst_29997);

return statearr_30042;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30013__$1,(12),dchan);
} else {
if((state_val_30014 === (14))){
var inst_29999 = (state_30013[(8)]);
var inst_30004 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29999);
var state_30013__$1 = state_30013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30013__$1,(16),out,inst_30004);
} else {
if((state_val_30014 === (16))){
var inst_30006 = (state_30013[(2)]);
var state_30013__$1 = (function (){var statearr_30043 = state_30013;
(statearr_30043[(12)] = inst_30006);

return statearr_30043;
})();
var statearr_30044_31835 = state_30013__$1;
(statearr_30044_31835[(2)] = null);

(statearr_30044_31835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (10))){
var inst_29981 = (state_30013[(2)]);
var inst_29982 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_30013__$1 = (function (){var statearr_30045 = state_30013;
(statearr_30045[(13)] = inst_29981);

return statearr_30045;
})();
var statearr_30046_31837 = state_30013__$1;
(statearr_30046_31837[(2)] = inst_29982);


cljs.core.async.impl.ioc_helpers.process_exception(state_30013__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30014 === (8))){
var inst_29995 = (state_30013[(2)]);
var state_30013__$1 = state_30013;
var statearr_30047_31838 = state_30013__$1;
(statearr_30047_31838[(2)] = inst_29995);

(statearr_30047_31838[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30048[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30048[(1)] = (1));

return statearr_30048;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30013){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30013);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30049){if((e30049 instanceof Object)){
var ex__28342__auto__ = e30049;
var statearr_30050_31840 = state_30013;
(statearr_30050_31840[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30013);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30049;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31841 = state_30013;
state_30013 = G__31841;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30051 = f__28470__auto__();
(statearr_30051[(6)] = c__28469__auto___31807);

return statearr_30051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__30054 = arguments.length;
switch (G__30054) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28469__auto___31845 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30090){
var state_val_30091 = (state_30090[(1)]);
if((state_val_30091 === (7))){
var inst_30070 = (state_30090[(7)]);
var inst_30069 = (state_30090[(8)]);
var inst_30069__$1 = (state_30090[(2)]);
var inst_30070__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30069__$1,(0),null);
var inst_30071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30069__$1,(1),null);
var inst_30072 = (inst_30070__$1 == null);
var state_30090__$1 = (function (){var statearr_30092 = state_30090;
(statearr_30092[(9)] = inst_30071);

(statearr_30092[(7)] = inst_30070__$1);

(statearr_30092[(8)] = inst_30069__$1);

return statearr_30092;
})();
if(cljs.core.truth_(inst_30072)){
var statearr_30093_31852 = state_30090__$1;
(statearr_30093_31852[(1)] = (8));

} else {
var statearr_30094_31854 = state_30090__$1;
(statearr_30094_31854[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (1))){
var inst_30059 = cljs.core.vec(chs);
var inst_30060 = inst_30059;
var state_30090__$1 = (function (){var statearr_30096 = state_30090;
(statearr_30096[(10)] = inst_30060);

return statearr_30096;
})();
var statearr_30097_31859 = state_30090__$1;
(statearr_30097_31859[(2)] = null);

(statearr_30097_31859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (4))){
var inst_30060 = (state_30090[(10)]);
var state_30090__$1 = state_30090;
return cljs.core.async.ioc_alts_BANG_(state_30090__$1,(7),inst_30060);
} else {
if((state_val_30091 === (6))){
var inst_30086 = (state_30090[(2)]);
var state_30090__$1 = state_30090;
var statearr_30098_31864 = state_30090__$1;
(statearr_30098_31864[(2)] = inst_30086);

(statearr_30098_31864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (3))){
var inst_30088 = (state_30090[(2)]);
var state_30090__$1 = state_30090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30090__$1,inst_30088);
} else {
if((state_val_30091 === (2))){
var inst_30060 = (state_30090[(10)]);
var inst_30062 = cljs.core.count(inst_30060);
var inst_30063 = (inst_30062 > (0));
var state_30090__$1 = state_30090;
if(cljs.core.truth_(inst_30063)){
var statearr_30100_31868 = state_30090__$1;
(statearr_30100_31868[(1)] = (4));

} else {
var statearr_30101_31870 = state_30090__$1;
(statearr_30101_31870[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (11))){
var inst_30060 = (state_30090[(10)]);
var inst_30079 = (state_30090[(2)]);
var tmp30099 = inst_30060;
var inst_30060__$1 = tmp30099;
var state_30090__$1 = (function (){var statearr_30102 = state_30090;
(statearr_30102[(10)] = inst_30060__$1);

(statearr_30102[(11)] = inst_30079);

return statearr_30102;
})();
var statearr_30103_31874 = state_30090__$1;
(statearr_30103_31874[(2)] = null);

(statearr_30103_31874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (9))){
var inst_30070 = (state_30090[(7)]);
var state_30090__$1 = state_30090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30090__$1,(11),out,inst_30070);
} else {
if((state_val_30091 === (5))){
var inst_30084 = cljs.core.async.close_BANG_(out);
var state_30090__$1 = state_30090;
var statearr_30104_31876 = state_30090__$1;
(statearr_30104_31876[(2)] = inst_30084);

(statearr_30104_31876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (10))){
var inst_30082 = (state_30090[(2)]);
var state_30090__$1 = state_30090;
var statearr_30105_31879 = state_30090__$1;
(statearr_30105_31879[(2)] = inst_30082);

(statearr_30105_31879[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30091 === (8))){
var inst_30060 = (state_30090[(10)]);
var inst_30071 = (state_30090[(9)]);
var inst_30070 = (state_30090[(7)]);
var inst_30069 = (state_30090[(8)]);
var inst_30074 = (function (){var cs = inst_30060;
var vec__30065 = inst_30069;
var v = inst_30070;
var c = inst_30071;
return (function (p1__30052_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__30052_SHARP_);
});
})();
var inst_30075 = cljs.core.filterv(inst_30074,inst_30060);
var inst_30060__$1 = inst_30075;
var state_30090__$1 = (function (){var statearr_30106 = state_30090;
(statearr_30106[(10)] = inst_30060__$1);

return statearr_30106;
})();
var statearr_30107_31885 = state_30090__$1;
(statearr_30107_31885[(2)] = null);

(statearr_30107_31885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30108 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30108[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30108[(1)] = (1));

return statearr_30108;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30090){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30090);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30109){if((e30109 instanceof Object)){
var ex__28342__auto__ = e30109;
var statearr_30110_31891 = state_30090;
(statearr_30110_31891[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30109;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31894 = state_30090;
state_30090 = G__31894;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30111 = f__28470__auto__();
(statearr_30111[(6)] = c__28469__auto___31845);

return statearr_30111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__30113 = arguments.length;
switch (G__30113) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28469__auto___31901 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30139){
var state_val_30140 = (state_30139[(1)]);
if((state_val_30140 === (7))){
var inst_30119 = (state_30139[(7)]);
var inst_30119__$1 = (state_30139[(2)]);
var inst_30120 = (inst_30119__$1 == null);
var inst_30122 = cljs.core.not(inst_30120);
var state_30139__$1 = (function (){var statearr_30142 = state_30139;
(statearr_30142[(7)] = inst_30119__$1);

return statearr_30142;
})();
if(inst_30122){
var statearr_30143_31904 = state_30139__$1;
(statearr_30143_31904[(1)] = (8));

} else {
var statearr_30144_31905 = state_30139__$1;
(statearr_30144_31905[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (1))){
var inst_30114 = (0);
var state_30139__$1 = (function (){var statearr_30145 = state_30139;
(statearr_30145[(8)] = inst_30114);

return statearr_30145;
})();
var statearr_30146_31908 = state_30139__$1;
(statearr_30146_31908[(2)] = null);

(statearr_30146_31908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (4))){
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30139__$1,(7),ch);
} else {
if((state_val_30140 === (6))){
var inst_30134 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
var statearr_30147_31910 = state_30139__$1;
(statearr_30147_31910[(2)] = inst_30134);

(statearr_30147_31910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (3))){
var inst_30136 = (state_30139[(2)]);
var inst_30137 = cljs.core.async.close_BANG_(out);
var state_30139__$1 = (function (){var statearr_30148 = state_30139;
(statearr_30148[(9)] = inst_30136);

return statearr_30148;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30139__$1,inst_30137);
} else {
if((state_val_30140 === (2))){
var inst_30114 = (state_30139[(8)]);
var inst_30116 = (inst_30114 < n);
var state_30139__$1 = state_30139;
if(cljs.core.truth_(inst_30116)){
var statearr_30151_31915 = state_30139__$1;
(statearr_30151_31915[(1)] = (4));

} else {
var statearr_30152_31916 = state_30139__$1;
(statearr_30152_31916[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (11))){
var inst_30114 = (state_30139[(8)]);
var inst_30126 = (state_30139[(2)]);
var inst_30127 = (inst_30114 + (1));
var inst_30114__$1 = inst_30127;
var state_30139__$1 = (function (){var statearr_30153 = state_30139;
(statearr_30153[(8)] = inst_30114__$1);

(statearr_30153[(10)] = inst_30126);

return statearr_30153;
})();
var statearr_30154_31919 = state_30139__$1;
(statearr_30154_31919[(2)] = null);

(statearr_30154_31919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (9))){
var state_30139__$1 = state_30139;
var statearr_30155_31920 = state_30139__$1;
(statearr_30155_31920[(2)] = null);

(statearr_30155_31920[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (5))){
var state_30139__$1 = state_30139;
var statearr_30156_31921 = state_30139__$1;
(statearr_30156_31921[(2)] = null);

(statearr_30156_31921[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (10))){
var inst_30131 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
var statearr_30157_31922 = state_30139__$1;
(statearr_30157_31922[(2)] = inst_30131);

(statearr_30157_31922[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (8))){
var inst_30119 = (state_30139[(7)]);
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30139__$1,(11),out,inst_30119);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30162 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30162[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30162[(1)] = (1));

return statearr_30162;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30139){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30139);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30163){if((e30163 instanceof Object)){
var ex__28342__auto__ = e30163;
var statearr_30164_31923 = state_30139;
(statearr_30164_31923[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30163;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31924 = state_30139;
state_30139 = G__31924;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30165 = f__28470__auto__();
(statearr_30165[(6)] = c__28469__auto___31901);

return statearr_30165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30169 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30169 = (function (f,ch,meta30170){
this.f = f;
this.ch = ch;
this.meta30170 = meta30170;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30171,meta30170__$1){
var self__ = this;
var _30171__$1 = this;
return (new cljs.core.async.t_cljs$core$async30169(self__.f,self__.ch,meta30170__$1));
}));

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30171){
var self__ = this;
var _30171__$1 = this;
return self__.meta30170;
}));

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30176 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30176 = (function (f,ch,meta30170,_,fn1,meta30177){
this.f = f;
this.ch = ch;
this.meta30170 = meta30170;
this._ = _;
this.fn1 = fn1;
this.meta30177 = meta30177;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30176.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30178,meta30177__$1){
var self__ = this;
var _30178__$1 = this;
return (new cljs.core.async.t_cljs$core$async30176(self__.f,self__.ch,self__.meta30170,self__._,self__.fn1,meta30177__$1));
}));

(cljs.core.async.t_cljs$core$async30176.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30178){
var self__ = this;
var _30178__$1 = this;
return self__.meta30177;
}));

(cljs.core.async.t_cljs$core$async30176.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30176.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30176.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30176.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30168_SHARP_){
var G__30179 = (((p1__30168_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30168_SHARP_) : self__.f.call(null,p1__30168_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30179) : f1.call(null,G__30179));
});
}));

(cljs.core.async.t_cljs$core$async30176.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30170","meta30170",-471289741,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30169","cljs.core.async/t_cljs$core$async30169",1744181508,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30177","meta30177",1298926778,null)], null);
}));

(cljs.core.async.t_cljs$core$async30176.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30176.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30176");

(cljs.core.async.t_cljs$core$async30176.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30176");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30176.
 */
cljs.core.async.__GT_t_cljs$core$async30176 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30176(f__$1,ch__$1,meta30170__$1,___$2,fn1__$1,meta30177){
return (new cljs.core.async.t_cljs$core$async30176(f__$1,ch__$1,meta30170__$1,___$2,fn1__$1,meta30177));
});

}

return (new cljs.core.async.t_cljs$core$async30176(self__.f,self__.ch,self__.meta30170,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30182 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30182) : self__.f.call(null,G__30182));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30169.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30169.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30170","meta30170",-471289741,null)], null);
}));

(cljs.core.async.t_cljs$core$async30169.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30169.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30169");

(cljs.core.async.t_cljs$core$async30169.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30169");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30169.
 */
cljs.core.async.__GT_t_cljs$core$async30169 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30169(f__$1,ch__$1,meta30170){
return (new cljs.core.async.t_cljs$core$async30169(f__$1,ch__$1,meta30170));
});

}

return (new cljs.core.async.t_cljs$core$async30169(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30184 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30184 = (function (f,ch,meta30185){
this.f = f;
this.ch = ch;
this.meta30185 = meta30185;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30186,meta30185__$1){
var self__ = this;
var _30186__$1 = this;
return (new cljs.core.async.t_cljs$core$async30184(self__.f,self__.ch,meta30185__$1));
}));

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30186){
var self__ = this;
var _30186__$1 = this;
return self__.meta30185;
}));

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30184.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30184.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30185","meta30185",1346383654,null)], null);
}));

(cljs.core.async.t_cljs$core$async30184.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30184.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30184");

(cljs.core.async.t_cljs$core$async30184.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30184");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30184.
 */
cljs.core.async.__GT_t_cljs$core$async30184 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30184(f__$1,ch__$1,meta30185){
return (new cljs.core.async.t_cljs$core$async30184(f__$1,ch__$1,meta30185));
});

}

return (new cljs.core.async.t_cljs$core$async30184(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30190 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30190 = (function (p,ch,meta30191){
this.p = p;
this.ch = ch;
this.meta30191 = meta30191;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30192,meta30191__$1){
var self__ = this;
var _30192__$1 = this;
return (new cljs.core.async.t_cljs$core$async30190(self__.p,self__.ch,meta30191__$1));
}));

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30192){
var self__ = this;
var _30192__$1 = this;
return self__.meta30191;
}));

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30190.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30190.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30191","meta30191",-181146146,null)], null);
}));

(cljs.core.async.t_cljs$core$async30190.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30190.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30190");

(cljs.core.async.t_cljs$core$async30190.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30190");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30190.
 */
cljs.core.async.__GT_t_cljs$core$async30190 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30190(p__$1,ch__$1,meta30191){
return (new cljs.core.async.t_cljs$core$async30190(p__$1,ch__$1,meta30191));
});

}

return (new cljs.core.async.t_cljs$core$async30190(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30201 = arguments.length;
switch (G__30201) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28469__auto___31926 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30228){
var state_val_30229 = (state_30228[(1)]);
if((state_val_30229 === (7))){
var inst_30224 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30231_31927 = state_30228__$1;
(statearr_30231_31927[(2)] = inst_30224);

(statearr_30231_31927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (1))){
var state_30228__$1 = state_30228;
var statearr_30232_31928 = state_30228__$1;
(statearr_30232_31928[(2)] = null);

(statearr_30232_31928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (4))){
var inst_30210 = (state_30228[(7)]);
var inst_30210__$1 = (state_30228[(2)]);
var inst_30211 = (inst_30210__$1 == null);
var state_30228__$1 = (function (){var statearr_30233 = state_30228;
(statearr_30233[(7)] = inst_30210__$1);

return statearr_30233;
})();
if(cljs.core.truth_(inst_30211)){
var statearr_30234_31929 = state_30228__$1;
(statearr_30234_31929[(1)] = (5));

} else {
var statearr_30235_31930 = state_30228__$1;
(statearr_30235_31930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (6))){
var inst_30210 = (state_30228[(7)]);
var inst_30215 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30210) : p.call(null,inst_30210));
var state_30228__$1 = state_30228;
if(cljs.core.truth_(inst_30215)){
var statearr_30236_31931 = state_30228__$1;
(statearr_30236_31931[(1)] = (8));

} else {
var statearr_30237_31932 = state_30228__$1;
(statearr_30237_31932[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (3))){
var inst_30226 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30228__$1,inst_30226);
} else {
if((state_val_30229 === (2))){
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30228__$1,(4),ch);
} else {
if((state_val_30229 === (11))){
var inst_30218 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30240_31933 = state_30228__$1;
(statearr_30240_31933[(2)] = inst_30218);

(statearr_30240_31933[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (9))){
var state_30228__$1 = state_30228;
var statearr_30241_31934 = state_30228__$1;
(statearr_30241_31934[(2)] = null);

(statearr_30241_31934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (5))){
var inst_30213 = cljs.core.async.close_BANG_(out);
var state_30228__$1 = state_30228;
var statearr_30242_31935 = state_30228__$1;
(statearr_30242_31935[(2)] = inst_30213);

(statearr_30242_31935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (10))){
var inst_30221 = (state_30228[(2)]);
var state_30228__$1 = (function (){var statearr_30243 = state_30228;
(statearr_30243[(8)] = inst_30221);

return statearr_30243;
})();
var statearr_30244_31936 = state_30228__$1;
(statearr_30244_31936[(2)] = null);

(statearr_30244_31936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (8))){
var inst_30210 = (state_30228[(7)]);
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30228__$1,(11),out,inst_30210);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30246 = [null,null,null,null,null,null,null,null,null];
(statearr_30246[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30246[(1)] = (1));

return statearr_30246;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30228){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30228);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30247){if((e30247 instanceof Object)){
var ex__28342__auto__ = e30247;
var statearr_30248_31937 = state_30228;
(statearr_30248_31937[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30228);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30247;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31938 = state_30228;
state_30228 = G__31938;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30253 = f__28470__auto__();
(statearr_30253[(6)] = c__28469__auto___31926);

return statearr_30253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30255 = arguments.length;
switch (G__30255) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30320){
var state_val_30321 = (state_30320[(1)]);
if((state_val_30321 === (7))){
var inst_30316 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30323_31940 = state_30320__$1;
(statearr_30323_31940[(2)] = inst_30316);

(statearr_30323_31940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (20))){
var inst_30286 = (state_30320[(7)]);
var inst_30297 = (state_30320[(2)]);
var inst_30298 = cljs.core.next(inst_30286);
var inst_30269 = inst_30298;
var inst_30270 = null;
var inst_30271 = (0);
var inst_30272 = (0);
var state_30320__$1 = (function (){var statearr_30324 = state_30320;
(statearr_30324[(8)] = inst_30297);

(statearr_30324[(9)] = inst_30269);

(statearr_30324[(10)] = inst_30272);

(statearr_30324[(11)] = inst_30271);

(statearr_30324[(12)] = inst_30270);

return statearr_30324;
})();
var statearr_30325_31941 = state_30320__$1;
(statearr_30325_31941[(2)] = null);

(statearr_30325_31941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (1))){
var state_30320__$1 = state_30320;
var statearr_30326_31942 = state_30320__$1;
(statearr_30326_31942[(2)] = null);

(statearr_30326_31942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (4))){
var inst_30258 = (state_30320[(13)]);
var inst_30258__$1 = (state_30320[(2)]);
var inst_30259 = (inst_30258__$1 == null);
var state_30320__$1 = (function (){var statearr_30327 = state_30320;
(statearr_30327[(13)] = inst_30258__$1);

return statearr_30327;
})();
if(cljs.core.truth_(inst_30259)){
var statearr_30328_31943 = state_30320__$1;
(statearr_30328_31943[(1)] = (5));

} else {
var statearr_30329_31944 = state_30320__$1;
(statearr_30329_31944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (15))){
var state_30320__$1 = state_30320;
var statearr_30333_31945 = state_30320__$1;
(statearr_30333_31945[(2)] = null);

(statearr_30333_31945[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (21))){
var state_30320__$1 = state_30320;
var statearr_30334_31946 = state_30320__$1;
(statearr_30334_31946[(2)] = null);

(statearr_30334_31946[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (13))){
var inst_30269 = (state_30320[(9)]);
var inst_30272 = (state_30320[(10)]);
var inst_30271 = (state_30320[(11)]);
var inst_30270 = (state_30320[(12)]);
var inst_30280 = (state_30320[(2)]);
var inst_30282 = (inst_30272 + (1));
var tmp30330 = inst_30269;
var tmp30331 = inst_30271;
var tmp30332 = inst_30270;
var inst_30269__$1 = tmp30330;
var inst_30270__$1 = tmp30332;
var inst_30271__$1 = tmp30331;
var inst_30272__$1 = inst_30282;
var state_30320__$1 = (function (){var statearr_30336 = state_30320;
(statearr_30336[(9)] = inst_30269__$1);

(statearr_30336[(10)] = inst_30272__$1);

(statearr_30336[(11)] = inst_30271__$1);

(statearr_30336[(12)] = inst_30270__$1);

(statearr_30336[(14)] = inst_30280);

return statearr_30336;
})();
var statearr_30337_31947 = state_30320__$1;
(statearr_30337_31947[(2)] = null);

(statearr_30337_31947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (22))){
var state_30320__$1 = state_30320;
var statearr_30338_31948 = state_30320__$1;
(statearr_30338_31948[(2)] = null);

(statearr_30338_31948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (6))){
var inst_30258 = (state_30320[(13)]);
var inst_30267 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30258) : f.call(null,inst_30258));
var inst_30268 = cljs.core.seq(inst_30267);
var inst_30269 = inst_30268;
var inst_30270 = null;
var inst_30271 = (0);
var inst_30272 = (0);
var state_30320__$1 = (function (){var statearr_30340 = state_30320;
(statearr_30340[(9)] = inst_30269);

(statearr_30340[(10)] = inst_30272);

(statearr_30340[(11)] = inst_30271);

(statearr_30340[(12)] = inst_30270);

return statearr_30340;
})();
var statearr_30341_31949 = state_30320__$1;
(statearr_30341_31949[(2)] = null);

(statearr_30341_31949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (17))){
var inst_30286 = (state_30320[(7)]);
var inst_30290 = cljs.core.chunk_first(inst_30286);
var inst_30291 = cljs.core.chunk_rest(inst_30286);
var inst_30292 = cljs.core.count(inst_30290);
var inst_30269 = inst_30291;
var inst_30270 = inst_30290;
var inst_30271 = inst_30292;
var inst_30272 = (0);
var state_30320__$1 = (function (){var statearr_30342 = state_30320;
(statearr_30342[(9)] = inst_30269);

(statearr_30342[(10)] = inst_30272);

(statearr_30342[(11)] = inst_30271);

(statearr_30342[(12)] = inst_30270);

return statearr_30342;
})();
var statearr_30343_31950 = state_30320__$1;
(statearr_30343_31950[(2)] = null);

(statearr_30343_31950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (3))){
var inst_30318 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30320__$1,inst_30318);
} else {
if((state_val_30321 === (12))){
var inst_30306 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30344_31951 = state_30320__$1;
(statearr_30344_31951[(2)] = inst_30306);

(statearr_30344_31951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (2))){
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30320__$1,(4),in$);
} else {
if((state_val_30321 === (23))){
var inst_30314 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30346_31952 = state_30320__$1;
(statearr_30346_31952[(2)] = inst_30314);

(statearr_30346_31952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (19))){
var inst_30301 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30347_31953 = state_30320__$1;
(statearr_30347_31953[(2)] = inst_30301);

(statearr_30347_31953[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (11))){
var inst_30269 = (state_30320[(9)]);
var inst_30286 = (state_30320[(7)]);
var inst_30286__$1 = cljs.core.seq(inst_30269);
var state_30320__$1 = (function (){var statearr_30348 = state_30320;
(statearr_30348[(7)] = inst_30286__$1);

return statearr_30348;
})();
if(inst_30286__$1){
var statearr_30349_31954 = state_30320__$1;
(statearr_30349_31954[(1)] = (14));

} else {
var statearr_30350_31955 = state_30320__$1;
(statearr_30350_31955[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (9))){
var inst_30308 = (state_30320[(2)]);
var inst_30309 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30320__$1 = (function (){var statearr_30351 = state_30320;
(statearr_30351[(15)] = inst_30308);

return statearr_30351;
})();
if(cljs.core.truth_(inst_30309)){
var statearr_30352_31956 = state_30320__$1;
(statearr_30352_31956[(1)] = (21));

} else {
var statearr_30353_31957 = state_30320__$1;
(statearr_30353_31957[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (5))){
var inst_30261 = cljs.core.async.close_BANG_(out);
var state_30320__$1 = state_30320;
var statearr_30354_31958 = state_30320__$1;
(statearr_30354_31958[(2)] = inst_30261);

(statearr_30354_31958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (14))){
var inst_30286 = (state_30320[(7)]);
var inst_30288 = cljs.core.chunked_seq_QMARK_(inst_30286);
var state_30320__$1 = state_30320;
if(inst_30288){
var statearr_30355_31959 = state_30320__$1;
(statearr_30355_31959[(1)] = (17));

} else {
var statearr_30356_31960 = state_30320__$1;
(statearr_30356_31960[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (16))){
var inst_30304 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30360_31961 = state_30320__$1;
(statearr_30360_31961[(2)] = inst_30304);

(statearr_30360_31961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (10))){
var inst_30272 = (state_30320[(10)]);
var inst_30270 = (state_30320[(12)]);
var inst_30277 = cljs.core._nth(inst_30270,inst_30272);
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30320__$1,(13),out,inst_30277);
} else {
if((state_val_30321 === (18))){
var inst_30286 = (state_30320[(7)]);
var inst_30295 = cljs.core.first(inst_30286);
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30320__$1,(20),out,inst_30295);
} else {
if((state_val_30321 === (8))){
var inst_30272 = (state_30320[(10)]);
var inst_30271 = (state_30320[(11)]);
var inst_30274 = (inst_30272 < inst_30271);
var inst_30275 = inst_30274;
var state_30320__$1 = state_30320;
if(cljs.core.truth_(inst_30275)){
var statearr_30364_31962 = state_30320__$1;
(statearr_30364_31962[(1)] = (10));

} else {
var statearr_30365_31963 = state_30320__$1;
(statearr_30365_31963[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28339__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28339__auto____0 = (function (){
var statearr_30367 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30367[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28339__auto__);

(statearr_30367[(1)] = (1));

return statearr_30367;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28339__auto____1 = (function (state_30320){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30320);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30368){if((e30368 instanceof Object)){
var ex__28342__auto__ = e30368;
var statearr_30369_31964 = state_30320;
(statearr_30369_31964[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30320);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30368;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31965 = state_30320;
state_30320 = G__31965;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28339__auto__ = function(state_30320){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28339__auto____1.call(this,state_30320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28339__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28339__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30370 = f__28470__auto__();
(statearr_30370[(6)] = c__28469__auto__);

return statearr_30370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));

return c__28469__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30378 = arguments.length;
switch (G__30378) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30380 = arguments.length;
switch (G__30380) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30383 = arguments.length;
switch (G__30383) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28469__auto___31969 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30413){
var state_val_30414 = (state_30413[(1)]);
if((state_val_30414 === (7))){
var inst_30408 = (state_30413[(2)]);
var state_30413__$1 = state_30413;
var statearr_30419_31970 = state_30413__$1;
(statearr_30419_31970[(2)] = inst_30408);

(statearr_30419_31970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (1))){
var inst_30389 = null;
var state_30413__$1 = (function (){var statearr_30423 = state_30413;
(statearr_30423[(7)] = inst_30389);

return statearr_30423;
})();
var statearr_30424_31971 = state_30413__$1;
(statearr_30424_31971[(2)] = null);

(statearr_30424_31971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (4))){
var inst_30392 = (state_30413[(8)]);
var inst_30392__$1 = (state_30413[(2)]);
var inst_30394 = (inst_30392__$1 == null);
var inst_30395 = cljs.core.not(inst_30394);
var state_30413__$1 = (function (){var statearr_30426 = state_30413;
(statearr_30426[(8)] = inst_30392__$1);

return statearr_30426;
})();
if(inst_30395){
var statearr_30427_31972 = state_30413__$1;
(statearr_30427_31972[(1)] = (5));

} else {
var statearr_30428_31973 = state_30413__$1;
(statearr_30428_31973[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (6))){
var state_30413__$1 = state_30413;
var statearr_30429_31974 = state_30413__$1;
(statearr_30429_31974[(2)] = null);

(statearr_30429_31974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (3))){
var inst_30410 = (state_30413[(2)]);
var inst_30411 = cljs.core.async.close_BANG_(out);
var state_30413__$1 = (function (){var statearr_30430 = state_30413;
(statearr_30430[(9)] = inst_30410);

return statearr_30430;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30413__$1,inst_30411);
} else {
if((state_val_30414 === (2))){
var state_30413__$1 = state_30413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30413__$1,(4),ch);
} else {
if((state_val_30414 === (11))){
var inst_30392 = (state_30413[(8)]);
var inst_30402 = (state_30413[(2)]);
var inst_30389 = inst_30392;
var state_30413__$1 = (function (){var statearr_30433 = state_30413;
(statearr_30433[(7)] = inst_30389);

(statearr_30433[(10)] = inst_30402);

return statearr_30433;
})();
var statearr_30434_31975 = state_30413__$1;
(statearr_30434_31975[(2)] = null);

(statearr_30434_31975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (9))){
var inst_30392 = (state_30413[(8)]);
var state_30413__$1 = state_30413;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30413__$1,(11),out,inst_30392);
} else {
if((state_val_30414 === (5))){
var inst_30392 = (state_30413[(8)]);
var inst_30389 = (state_30413[(7)]);
var inst_30397 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30392,inst_30389);
var state_30413__$1 = state_30413;
if(inst_30397){
var statearr_30436_31976 = state_30413__$1;
(statearr_30436_31976[(1)] = (8));

} else {
var statearr_30437_31977 = state_30413__$1;
(statearr_30437_31977[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (10))){
var inst_30405 = (state_30413[(2)]);
var state_30413__$1 = state_30413;
var statearr_30438_31978 = state_30413__$1;
(statearr_30438_31978[(2)] = inst_30405);

(statearr_30438_31978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30414 === (8))){
var inst_30389 = (state_30413[(7)]);
var tmp30435 = inst_30389;
var inst_30389__$1 = tmp30435;
var state_30413__$1 = (function (){var statearr_30439 = state_30413;
(statearr_30439[(7)] = inst_30389__$1);

return statearr_30439;
})();
var statearr_30440_31979 = state_30413__$1;
(statearr_30440_31979[(2)] = null);

(statearr_30440_31979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30441 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30441[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30441[(1)] = (1));

return statearr_30441;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30413){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30413);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30442){if((e30442 instanceof Object)){
var ex__28342__auto__ = e30442;
var statearr_30443_31980 = state_30413;
(statearr_30443_31980[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30413);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30442;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31981 = state_30413;
state_30413 = G__31981;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30413){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30444 = f__28470__auto__();
(statearr_30444[(6)] = c__28469__auto___31969);

return statearr_30444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30451 = arguments.length;
switch (G__30451) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28469__auto___31983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30489){
var state_val_30490 = (state_30489[(1)]);
if((state_val_30490 === (7))){
var inst_30485 = (state_30489[(2)]);
var state_30489__$1 = state_30489;
var statearr_30494_31984 = state_30489__$1;
(statearr_30494_31984[(2)] = inst_30485);

(statearr_30494_31984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (1))){
var inst_30452 = (new Array(n));
var inst_30453 = inst_30452;
var inst_30454 = (0);
var state_30489__$1 = (function (){var statearr_30495 = state_30489;
(statearr_30495[(7)] = inst_30453);

(statearr_30495[(8)] = inst_30454);

return statearr_30495;
})();
var statearr_30496_31985 = state_30489__$1;
(statearr_30496_31985[(2)] = null);

(statearr_30496_31985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (4))){
var inst_30457 = (state_30489[(9)]);
var inst_30457__$1 = (state_30489[(2)]);
var inst_30458 = (inst_30457__$1 == null);
var inst_30459 = cljs.core.not(inst_30458);
var state_30489__$1 = (function (){var statearr_30497 = state_30489;
(statearr_30497[(9)] = inst_30457__$1);

return statearr_30497;
})();
if(inst_30459){
var statearr_30498_31986 = state_30489__$1;
(statearr_30498_31986[(1)] = (5));

} else {
var statearr_30499_31987 = state_30489__$1;
(statearr_30499_31987[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (15))){
var inst_30479 = (state_30489[(2)]);
var state_30489__$1 = state_30489;
var statearr_30500_31988 = state_30489__$1;
(statearr_30500_31988[(2)] = inst_30479);

(statearr_30500_31988[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (13))){
var state_30489__$1 = state_30489;
var statearr_30502_31989 = state_30489__$1;
(statearr_30502_31989[(2)] = null);

(statearr_30502_31989[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (6))){
var inst_30454 = (state_30489[(8)]);
var inst_30475 = (inst_30454 > (0));
var state_30489__$1 = state_30489;
if(cljs.core.truth_(inst_30475)){
var statearr_30503_31990 = state_30489__$1;
(statearr_30503_31990[(1)] = (12));

} else {
var statearr_30504_31991 = state_30489__$1;
(statearr_30504_31991[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (3))){
var inst_30487 = (state_30489[(2)]);
var state_30489__$1 = state_30489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30489__$1,inst_30487);
} else {
if((state_val_30490 === (12))){
var inst_30453 = (state_30489[(7)]);
var inst_30477 = cljs.core.vec(inst_30453);
var state_30489__$1 = state_30489;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30489__$1,(15),out,inst_30477);
} else {
if((state_val_30490 === (2))){
var state_30489__$1 = state_30489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30489__$1,(4),ch);
} else {
if((state_val_30490 === (11))){
var inst_30469 = (state_30489[(2)]);
var inst_30470 = (new Array(n));
var inst_30453 = inst_30470;
var inst_30454 = (0);
var state_30489__$1 = (function (){var statearr_30505 = state_30489;
(statearr_30505[(7)] = inst_30453);

(statearr_30505[(8)] = inst_30454);

(statearr_30505[(10)] = inst_30469);

return statearr_30505;
})();
var statearr_30506_31992 = state_30489__$1;
(statearr_30506_31992[(2)] = null);

(statearr_30506_31992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (9))){
var inst_30453 = (state_30489[(7)]);
var inst_30467 = cljs.core.vec(inst_30453);
var state_30489__$1 = state_30489;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30489__$1,(11),out,inst_30467);
} else {
if((state_val_30490 === (5))){
var inst_30462 = (state_30489[(11)]);
var inst_30453 = (state_30489[(7)]);
var inst_30454 = (state_30489[(8)]);
var inst_30457 = (state_30489[(9)]);
var inst_30461 = (inst_30453[inst_30454] = inst_30457);
var inst_30462__$1 = (inst_30454 + (1));
var inst_30463 = (inst_30462__$1 < n);
var state_30489__$1 = (function (){var statearr_30510 = state_30489;
(statearr_30510[(12)] = inst_30461);

(statearr_30510[(11)] = inst_30462__$1);

return statearr_30510;
})();
if(cljs.core.truth_(inst_30463)){
var statearr_30511_31993 = state_30489__$1;
(statearr_30511_31993[(1)] = (8));

} else {
var statearr_30514_31994 = state_30489__$1;
(statearr_30514_31994[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (14))){
var inst_30482 = (state_30489[(2)]);
var inst_30483 = cljs.core.async.close_BANG_(out);
var state_30489__$1 = (function (){var statearr_30517 = state_30489;
(statearr_30517[(13)] = inst_30482);

return statearr_30517;
})();
var statearr_30519_31995 = state_30489__$1;
(statearr_30519_31995[(2)] = inst_30483);

(statearr_30519_31995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (10))){
var inst_30473 = (state_30489[(2)]);
var state_30489__$1 = state_30489;
var statearr_30521_31996 = state_30489__$1;
(statearr_30521_31996[(2)] = inst_30473);

(statearr_30521_31996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30490 === (8))){
var inst_30462 = (state_30489[(11)]);
var inst_30453 = (state_30489[(7)]);
var tmp30515 = inst_30453;
var inst_30453__$1 = tmp30515;
var inst_30454 = inst_30462;
var state_30489__$1 = (function (){var statearr_30523 = state_30489;
(statearr_30523[(7)] = inst_30453__$1);

(statearr_30523[(8)] = inst_30454);

return statearr_30523;
})();
var statearr_30526_31997 = state_30489__$1;
(statearr_30526_31997[(2)] = null);

(statearr_30526_31997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30527 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30527[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30527[(1)] = (1));

return statearr_30527;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30489){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30489);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30530){if((e30530 instanceof Object)){
var ex__28342__auto__ = e30530;
var statearr_30531_31998 = state_30489;
(statearr_30531_31998[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30489);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30530;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31999 = state_30489;
state_30489 = G__31999;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30489){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30532 = f__28470__auto__();
(statearr_30532[(6)] = c__28469__auto___31983);

return statearr_30532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30537 = arguments.length;
switch (G__30537) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28469__auto___32001 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28470__auto__ = (function (){var switch__28338__auto__ = (function (state_30579){
var state_val_30580 = (state_30579[(1)]);
if((state_val_30580 === (7))){
var inst_30575 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
var statearr_30581_32002 = state_30579__$1;
(statearr_30581_32002[(2)] = inst_30575);

(statearr_30581_32002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (1))){
var inst_30538 = [];
var inst_30539 = inst_30538;
var inst_30540 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30579__$1 = (function (){var statearr_30585 = state_30579;
(statearr_30585[(7)] = inst_30540);

(statearr_30585[(8)] = inst_30539);

return statearr_30585;
})();
var statearr_30586_32003 = state_30579__$1;
(statearr_30586_32003[(2)] = null);

(statearr_30586_32003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (4))){
var inst_30543 = (state_30579[(9)]);
var inst_30543__$1 = (state_30579[(2)]);
var inst_30544 = (inst_30543__$1 == null);
var inst_30545 = cljs.core.not(inst_30544);
var state_30579__$1 = (function (){var statearr_30588 = state_30579;
(statearr_30588[(9)] = inst_30543__$1);

return statearr_30588;
})();
if(inst_30545){
var statearr_30589_32004 = state_30579__$1;
(statearr_30589_32004[(1)] = (5));

} else {
var statearr_30590_32005 = state_30579__$1;
(statearr_30590_32005[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (15))){
var inst_30569 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
var statearr_30591_32006 = state_30579__$1;
(statearr_30591_32006[(2)] = inst_30569);

(statearr_30591_32006[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (13))){
var state_30579__$1 = state_30579;
var statearr_30592_32007 = state_30579__$1;
(statearr_30592_32007[(2)] = null);

(statearr_30592_32007[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (6))){
var inst_30539 = (state_30579[(8)]);
var inst_30564 = inst_30539.length;
var inst_30565 = (inst_30564 > (0));
var state_30579__$1 = state_30579;
if(cljs.core.truth_(inst_30565)){
var statearr_30593_32008 = state_30579__$1;
(statearr_30593_32008[(1)] = (12));

} else {
var statearr_30594_32009 = state_30579__$1;
(statearr_30594_32009[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (3))){
var inst_30577 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30579__$1,inst_30577);
} else {
if((state_val_30580 === (12))){
var inst_30539 = (state_30579[(8)]);
var inst_30567 = cljs.core.vec(inst_30539);
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30579__$1,(15),out,inst_30567);
} else {
if((state_val_30580 === (2))){
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30579__$1,(4),ch);
} else {
if((state_val_30580 === (11))){
var inst_30547 = (state_30579[(10)]);
var inst_30543 = (state_30579[(9)]);
var inst_30557 = (state_30579[(2)]);
var inst_30558 = [];
var inst_30559 = inst_30558.push(inst_30543);
var inst_30539 = inst_30558;
var inst_30540 = inst_30547;
var state_30579__$1 = (function (){var statearr_30595 = state_30579;
(statearr_30595[(11)] = inst_30557);

(statearr_30595[(7)] = inst_30540);

(statearr_30595[(12)] = inst_30559);

(statearr_30595[(8)] = inst_30539);

return statearr_30595;
})();
var statearr_30596_32010 = state_30579__$1;
(statearr_30596_32010[(2)] = null);

(statearr_30596_32010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (9))){
var inst_30539 = (state_30579[(8)]);
var inst_30555 = cljs.core.vec(inst_30539);
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30579__$1,(11),out,inst_30555);
} else {
if((state_val_30580 === (5))){
var inst_30547 = (state_30579[(10)]);
var inst_30540 = (state_30579[(7)]);
var inst_30543 = (state_30579[(9)]);
var inst_30547__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30543) : f.call(null,inst_30543));
var inst_30548 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30547__$1,inst_30540);
var inst_30549 = cljs.core.keyword_identical_QMARK_(inst_30540,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30550 = ((inst_30548) || (inst_30549));
var state_30579__$1 = (function (){var statearr_30597 = state_30579;
(statearr_30597[(10)] = inst_30547__$1);

return statearr_30597;
})();
if(cljs.core.truth_(inst_30550)){
var statearr_30598_32011 = state_30579__$1;
(statearr_30598_32011[(1)] = (8));

} else {
var statearr_30599_32012 = state_30579__$1;
(statearr_30599_32012[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (14))){
var inst_30572 = (state_30579[(2)]);
var inst_30573 = cljs.core.async.close_BANG_(out);
var state_30579__$1 = (function (){var statearr_30601 = state_30579;
(statearr_30601[(13)] = inst_30572);

return statearr_30601;
})();
var statearr_30602_32013 = state_30579__$1;
(statearr_30602_32013[(2)] = inst_30573);

(statearr_30602_32013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (10))){
var inst_30562 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
var statearr_30603_32014 = state_30579__$1;
(statearr_30603_32014[(2)] = inst_30562);

(statearr_30603_32014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (8))){
var inst_30547 = (state_30579[(10)]);
var inst_30539 = (state_30579[(8)]);
var inst_30543 = (state_30579[(9)]);
var inst_30552 = inst_30539.push(inst_30543);
var tmp30600 = inst_30539;
var inst_30539__$1 = tmp30600;
var inst_30540 = inst_30547;
var state_30579__$1 = (function (){var statearr_30604 = state_30579;
(statearr_30604[(7)] = inst_30540);

(statearr_30604[(14)] = inst_30552);

(statearr_30604[(8)] = inst_30539__$1);

return statearr_30604;
})();
var statearr_30605_32015 = state_30579__$1;
(statearr_30605_32015[(2)] = null);

(statearr_30605_32015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28339__auto__ = null;
var cljs$core$async$state_machine__28339__auto____0 = (function (){
var statearr_30612 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30612[(0)] = cljs$core$async$state_machine__28339__auto__);

(statearr_30612[(1)] = (1));

return statearr_30612;
});
var cljs$core$async$state_machine__28339__auto____1 = (function (state_30579){
while(true){
var ret_value__28340__auto__ = (function (){try{while(true){
var result__28341__auto__ = switch__28338__auto__(state_30579);
if(cljs.core.keyword_identical_QMARK_(result__28341__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28341__auto__;
}
break;
}
}catch (e30613){if((e30613 instanceof Object)){
var ex__28342__auto__ = e30613;
var statearr_30614_32016 = state_30579;
(statearr_30614_32016[(5)] = ex__28342__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30613;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28340__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32017 = state_30579;
state_30579 = G__32017;
continue;
} else {
return ret_value__28340__auto__;
}
break;
}
});
cljs$core$async$state_machine__28339__auto__ = function(state_30579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28339__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28339__auto____1.call(this,state_30579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28339__auto____0;
cljs$core$async$state_machine__28339__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28339__auto____1;
return cljs$core$async$state_machine__28339__auto__;
})()
})();
var state__28471__auto__ = (function (){var statearr_30615 = f__28470__auto__();
(statearr_30615[(6)] = c__28469__auto___32001);

return statearr_30615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28471__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
