goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_46690 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_46690(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_46696 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_46696(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__45684 = coll;
var G__45685 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__45684,G__45685) : shadow.dom.lazy_native_coll_seq.call(null,G__45684,G__45685));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__45753 = arguments.length;
switch (G__45753) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__45763 = arguments.length;
switch (G__45763) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__45769 = arguments.length;
switch (G__45769) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__45773 = arguments.length;
switch (G__45773) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__45799 = arguments.length;
switch (G__45799) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__45809 = arguments.length;
switch (G__45809) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e45821){if((e45821 instanceof Object)){
var e = e45821;
return console.log("didnt support attachEvent",el,e);
} else {
throw e45821;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__45832 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__45833 = null;
var count__45834 = (0);
var i__45835 = (0);
while(true){
if((i__45835 < count__45834)){
var el = chunk__45833.cljs$core$IIndexed$_nth$arity$2(null,i__45835);
var handler_46736__$1 = ((function (seq__45832,chunk__45833,count__45834,i__45835,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__45832,chunk__45833,count__45834,i__45835,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_46736__$1);


var G__46737 = seq__45832;
var G__46738 = chunk__45833;
var G__46739 = count__45834;
var G__46740 = (i__45835 + (1));
seq__45832 = G__46737;
chunk__45833 = G__46738;
count__45834 = G__46739;
i__45835 = G__46740;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45832);
if(temp__5720__auto__){
var seq__45832__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45832__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45832__$1);
var G__46741 = cljs.core.chunk_rest(seq__45832__$1);
var G__46742 = c__4556__auto__;
var G__46743 = cljs.core.count(c__4556__auto__);
var G__46744 = (0);
seq__45832 = G__46741;
chunk__45833 = G__46742;
count__45834 = G__46743;
i__45835 = G__46744;
continue;
} else {
var el = cljs.core.first(seq__45832__$1);
var handler_46745__$1 = ((function (seq__45832,chunk__45833,count__45834,i__45835,el,seq__45832__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__45832,chunk__45833,count__45834,i__45835,el,seq__45832__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_46745__$1);


var G__46746 = cljs.core.next(seq__45832__$1);
var G__46747 = null;
var G__46748 = (0);
var G__46749 = (0);
seq__45832 = G__46746;
chunk__45833 = G__46747;
count__45834 = G__46748;
i__45835 = G__46749;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__45852 = arguments.length;
switch (G__45852) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__45863 = cljs.core.seq(events);
var chunk__45864 = null;
var count__45865 = (0);
var i__45866 = (0);
while(true){
if((i__45866 < count__45865)){
var vec__45879 = chunk__45864.cljs$core$IIndexed$_nth$arity$2(null,i__45866);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45879,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45879,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__46751 = seq__45863;
var G__46752 = chunk__45864;
var G__46753 = count__45865;
var G__46754 = (i__45866 + (1));
seq__45863 = G__46751;
chunk__45864 = G__46752;
count__45865 = G__46753;
i__45866 = G__46754;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45863);
if(temp__5720__auto__){
var seq__45863__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45863__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45863__$1);
var G__46755 = cljs.core.chunk_rest(seq__45863__$1);
var G__46756 = c__4556__auto__;
var G__46757 = cljs.core.count(c__4556__auto__);
var G__46758 = (0);
seq__45863 = G__46755;
chunk__45864 = G__46756;
count__45865 = G__46757;
i__45866 = G__46758;
continue;
} else {
var vec__45883 = cljs.core.first(seq__45863__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45883,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45883,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__46759 = cljs.core.next(seq__45863__$1);
var G__46760 = null;
var G__46761 = (0);
var G__46762 = (0);
seq__45863 = G__46759;
chunk__45864 = G__46760;
count__45865 = G__46761;
i__45866 = G__46762;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__45890 = cljs.core.seq(styles);
var chunk__45891 = null;
var count__45892 = (0);
var i__45893 = (0);
while(true){
if((i__45893 < count__45892)){
var vec__45906 = chunk__45891.cljs$core$IIndexed$_nth$arity$2(null,i__45893);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45906,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45906,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__46765 = seq__45890;
var G__46766 = chunk__45891;
var G__46767 = count__45892;
var G__46768 = (i__45893 + (1));
seq__45890 = G__46765;
chunk__45891 = G__46766;
count__45892 = G__46767;
i__45893 = G__46768;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__45890);
if(temp__5720__auto__){
var seq__45890__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45890__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__45890__$1);
var G__46770 = cljs.core.chunk_rest(seq__45890__$1);
var G__46771 = c__4556__auto__;
var G__46772 = cljs.core.count(c__4556__auto__);
var G__46773 = (0);
seq__45890 = G__46770;
chunk__45891 = G__46771;
count__45892 = G__46772;
i__45893 = G__46773;
continue;
} else {
var vec__45910 = cljs.core.first(seq__45890__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45910,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45910,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__46774 = cljs.core.next(seq__45890__$1);
var G__46775 = null;
var G__46776 = (0);
var G__46777 = (0);
seq__45890 = G__46774;
chunk__45891 = G__46775;
count__45892 = G__46776;
i__45893 = G__46777;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__45919_46780 = key;
var G__45919_46781__$1 = (((G__45919_46780 instanceof cljs.core.Keyword))?G__45919_46780.fqn:null);
switch (G__45919_46781__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_46787 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_46787,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_46787,"aria-");
}
})())){
el.setAttribute(ks_46787,value);
} else {
(el[ks_46787] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__45949){
var map__45950 = p__45949;
var map__45950__$1 = (((((!((map__45950 == null))))?(((((map__45950.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45950.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45950):map__45950);
var props = map__45950__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45950__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__45955 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45955,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45955,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45955,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__45959 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__45959,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__45959;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__45963 = arguments.length;
switch (G__45963) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__45968){
var vec__45969 = p__45968;
var seq__45970 = cljs.core.seq(vec__45969);
var first__45971 = cljs.core.first(seq__45970);
var seq__45970__$1 = cljs.core.next(seq__45970);
var nn = first__45971;
var first__45971__$1 = cljs.core.first(seq__45970__$1);
var seq__45970__$2 = cljs.core.next(seq__45970__$1);
var np = first__45971__$1;
var nc = seq__45970__$2;
var node = vec__45969;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__45974 = nn;
var G__45975 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__45974,G__45975) : create_fn.call(null,G__45974,G__45975));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__45977 = nn;
var G__45978 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__45977,G__45978) : create_fn.call(null,G__45977,G__45978));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__45984 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45984,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45984,(1),null);
var seq__45991_46820 = cljs.core.seq(node_children);
var chunk__45992_46821 = null;
var count__45993_46822 = (0);
var i__45994_46823 = (0);
while(true){
if((i__45994_46823 < count__45993_46822)){
var child_struct_46824 = chunk__45992_46821.cljs$core$IIndexed$_nth$arity$2(null,i__45994_46823);
var children_46825 = shadow.dom.dom_node(child_struct_46824);
if(cljs.core.seq_QMARK_(children_46825)){
var seq__46035_46826 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_46825));
var chunk__46037_46827 = null;
var count__46038_46828 = (0);
var i__46039_46829 = (0);
while(true){
if((i__46039_46829 < count__46038_46828)){
var child_46830 = chunk__46037_46827.cljs$core$IIndexed$_nth$arity$2(null,i__46039_46829);
if(cljs.core.truth_(child_46830)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46830);


var G__46832 = seq__46035_46826;
var G__46833 = chunk__46037_46827;
var G__46834 = count__46038_46828;
var G__46835 = (i__46039_46829 + (1));
seq__46035_46826 = G__46832;
chunk__46037_46827 = G__46833;
count__46038_46828 = G__46834;
i__46039_46829 = G__46835;
continue;
} else {
var G__46837 = seq__46035_46826;
var G__46838 = chunk__46037_46827;
var G__46839 = count__46038_46828;
var G__46840 = (i__46039_46829 + (1));
seq__46035_46826 = G__46837;
chunk__46037_46827 = G__46838;
count__46038_46828 = G__46839;
i__46039_46829 = G__46840;
continue;
}
} else {
var temp__5720__auto___46841 = cljs.core.seq(seq__46035_46826);
if(temp__5720__auto___46841){
var seq__46035_46842__$1 = temp__5720__auto___46841;
if(cljs.core.chunked_seq_QMARK_(seq__46035_46842__$1)){
var c__4556__auto___46843 = cljs.core.chunk_first(seq__46035_46842__$1);
var G__46844 = cljs.core.chunk_rest(seq__46035_46842__$1);
var G__46845 = c__4556__auto___46843;
var G__46846 = cljs.core.count(c__4556__auto___46843);
var G__46847 = (0);
seq__46035_46826 = G__46844;
chunk__46037_46827 = G__46845;
count__46038_46828 = G__46846;
i__46039_46829 = G__46847;
continue;
} else {
var child_46848 = cljs.core.first(seq__46035_46842__$1);
if(cljs.core.truth_(child_46848)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46848);


var G__46849 = cljs.core.next(seq__46035_46842__$1);
var G__46850 = null;
var G__46851 = (0);
var G__46852 = (0);
seq__46035_46826 = G__46849;
chunk__46037_46827 = G__46850;
count__46038_46828 = G__46851;
i__46039_46829 = G__46852;
continue;
} else {
var G__46853 = cljs.core.next(seq__46035_46842__$1);
var G__46854 = null;
var G__46855 = (0);
var G__46856 = (0);
seq__46035_46826 = G__46853;
chunk__46037_46827 = G__46854;
count__46038_46828 = G__46855;
i__46039_46829 = G__46856;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_46825);
}


var G__46858 = seq__45991_46820;
var G__46859 = chunk__45992_46821;
var G__46860 = count__45993_46822;
var G__46861 = (i__45994_46823 + (1));
seq__45991_46820 = G__46858;
chunk__45992_46821 = G__46859;
count__45993_46822 = G__46860;
i__45994_46823 = G__46861;
continue;
} else {
var temp__5720__auto___46862 = cljs.core.seq(seq__45991_46820);
if(temp__5720__auto___46862){
var seq__45991_46863__$1 = temp__5720__auto___46862;
if(cljs.core.chunked_seq_QMARK_(seq__45991_46863__$1)){
var c__4556__auto___46864 = cljs.core.chunk_first(seq__45991_46863__$1);
var G__46865 = cljs.core.chunk_rest(seq__45991_46863__$1);
var G__46866 = c__4556__auto___46864;
var G__46867 = cljs.core.count(c__4556__auto___46864);
var G__46868 = (0);
seq__45991_46820 = G__46865;
chunk__45992_46821 = G__46866;
count__45993_46822 = G__46867;
i__45994_46823 = G__46868;
continue;
} else {
var child_struct_46869 = cljs.core.first(seq__45991_46863__$1);
var children_46871 = shadow.dom.dom_node(child_struct_46869);
if(cljs.core.seq_QMARK_(children_46871)){
var seq__46052_46874 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_46871));
var chunk__46054_46875 = null;
var count__46055_46876 = (0);
var i__46056_46877 = (0);
while(true){
if((i__46056_46877 < count__46055_46876)){
var child_46878 = chunk__46054_46875.cljs$core$IIndexed$_nth$arity$2(null,i__46056_46877);
if(cljs.core.truth_(child_46878)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46878);


var G__46879 = seq__46052_46874;
var G__46880 = chunk__46054_46875;
var G__46881 = count__46055_46876;
var G__46882 = (i__46056_46877 + (1));
seq__46052_46874 = G__46879;
chunk__46054_46875 = G__46880;
count__46055_46876 = G__46881;
i__46056_46877 = G__46882;
continue;
} else {
var G__46885 = seq__46052_46874;
var G__46886 = chunk__46054_46875;
var G__46887 = count__46055_46876;
var G__46888 = (i__46056_46877 + (1));
seq__46052_46874 = G__46885;
chunk__46054_46875 = G__46886;
count__46055_46876 = G__46887;
i__46056_46877 = G__46888;
continue;
}
} else {
var temp__5720__auto___46889__$1 = cljs.core.seq(seq__46052_46874);
if(temp__5720__auto___46889__$1){
var seq__46052_46892__$1 = temp__5720__auto___46889__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46052_46892__$1)){
var c__4556__auto___46894 = cljs.core.chunk_first(seq__46052_46892__$1);
var G__46895 = cljs.core.chunk_rest(seq__46052_46892__$1);
var G__46896 = c__4556__auto___46894;
var G__46897 = cljs.core.count(c__4556__auto___46894);
var G__46898 = (0);
seq__46052_46874 = G__46895;
chunk__46054_46875 = G__46896;
count__46055_46876 = G__46897;
i__46056_46877 = G__46898;
continue;
} else {
var child_46900 = cljs.core.first(seq__46052_46892__$1);
if(cljs.core.truth_(child_46900)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_46900);


var G__46903 = cljs.core.next(seq__46052_46892__$1);
var G__46904 = null;
var G__46905 = (0);
var G__46906 = (0);
seq__46052_46874 = G__46903;
chunk__46054_46875 = G__46904;
count__46055_46876 = G__46905;
i__46056_46877 = G__46906;
continue;
} else {
var G__46908 = cljs.core.next(seq__46052_46892__$1);
var G__46909 = null;
var G__46910 = (0);
var G__46911 = (0);
seq__46052_46874 = G__46908;
chunk__46054_46875 = G__46909;
count__46055_46876 = G__46910;
i__46056_46877 = G__46911;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_46871);
}


var G__46914 = cljs.core.next(seq__45991_46863__$1);
var G__46915 = null;
var G__46916 = (0);
var G__46917 = (0);
seq__45991_46820 = G__46914;
chunk__45992_46821 = G__46915;
count__45993_46822 = G__46916;
i__45994_46823 = G__46917;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46063 = cljs.core.seq(node);
var chunk__46064 = null;
var count__46065 = (0);
var i__46066 = (0);
while(true){
if((i__46066 < count__46065)){
var n = chunk__46064.cljs$core$IIndexed$_nth$arity$2(null,i__46066);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__46925 = seq__46063;
var G__46926 = chunk__46064;
var G__46927 = count__46065;
var G__46928 = (i__46066 + (1));
seq__46063 = G__46925;
chunk__46064 = G__46926;
count__46065 = G__46927;
i__46066 = G__46928;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46063);
if(temp__5720__auto__){
var seq__46063__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46063__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46063__$1);
var G__46929 = cljs.core.chunk_rest(seq__46063__$1);
var G__46930 = c__4556__auto__;
var G__46931 = cljs.core.count(c__4556__auto__);
var G__46932 = (0);
seq__46063 = G__46929;
chunk__46064 = G__46930;
count__46065 = G__46931;
i__46066 = G__46932;
continue;
} else {
var n = cljs.core.first(seq__46063__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__46936 = cljs.core.next(seq__46063__$1);
var G__46937 = null;
var G__46938 = (0);
var G__46939 = (0);
seq__46063 = G__46936;
chunk__46064 = G__46937;
count__46065 = G__46938;
i__46066 = G__46939;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46083 = arguments.length;
switch (G__46083) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46093 = arguments.length;
switch (G__46093) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46100 = arguments.length;
switch (G__46100) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___46964 = arguments.length;
var i__4737__auto___46966 = (0);
while(true){
if((i__4737__auto___46966 < len__4736__auto___46964)){
args__4742__auto__.push((arguments[i__4737__auto___46966]));

var G__46967 = (i__4737__auto___46966 + (1));
i__4737__auto___46966 = G__46967;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46115_46968 = cljs.core.seq(nodes);
var chunk__46116_46969 = null;
var count__46117_46970 = (0);
var i__46118_46971 = (0);
while(true){
if((i__46118_46971 < count__46117_46970)){
var node_46977 = chunk__46116_46969.cljs$core$IIndexed$_nth$arity$2(null,i__46118_46971);
fragment.appendChild(shadow.dom._to_dom(node_46977));


var G__46978 = seq__46115_46968;
var G__46979 = chunk__46116_46969;
var G__46980 = count__46117_46970;
var G__46981 = (i__46118_46971 + (1));
seq__46115_46968 = G__46978;
chunk__46116_46969 = G__46979;
count__46117_46970 = G__46980;
i__46118_46971 = G__46981;
continue;
} else {
var temp__5720__auto___46982 = cljs.core.seq(seq__46115_46968);
if(temp__5720__auto___46982){
var seq__46115_46984__$1 = temp__5720__auto___46982;
if(cljs.core.chunked_seq_QMARK_(seq__46115_46984__$1)){
var c__4556__auto___46986 = cljs.core.chunk_first(seq__46115_46984__$1);
var G__46987 = cljs.core.chunk_rest(seq__46115_46984__$1);
var G__46988 = c__4556__auto___46986;
var G__46989 = cljs.core.count(c__4556__auto___46986);
var G__46990 = (0);
seq__46115_46968 = G__46987;
chunk__46116_46969 = G__46988;
count__46117_46970 = G__46989;
i__46118_46971 = G__46990;
continue;
} else {
var node_46993 = cljs.core.first(seq__46115_46984__$1);
fragment.appendChild(shadow.dom._to_dom(node_46993));


var G__46994 = cljs.core.next(seq__46115_46984__$1);
var G__46995 = null;
var G__46996 = (0);
var G__46997 = (0);
seq__46115_46968 = G__46994;
chunk__46116_46969 = G__46995;
count__46117_46970 = G__46996;
i__46118_46971 = G__46997;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46110){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46110));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46131_47005 = cljs.core.seq(scripts);
var chunk__46132_47006 = null;
var count__46133_47007 = (0);
var i__46134_47008 = (0);
while(true){
if((i__46134_47008 < count__46133_47007)){
var vec__46144_47009 = chunk__46132_47006.cljs$core$IIndexed$_nth$arity$2(null,i__46134_47008);
var script_tag_47010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46144_47009,(0),null);
var script_body_47011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46144_47009,(1),null);
eval(script_body_47011);


var G__47012 = seq__46131_47005;
var G__47013 = chunk__46132_47006;
var G__47014 = count__46133_47007;
var G__47015 = (i__46134_47008 + (1));
seq__46131_47005 = G__47012;
chunk__46132_47006 = G__47013;
count__46133_47007 = G__47014;
i__46134_47008 = G__47015;
continue;
} else {
var temp__5720__auto___47016 = cljs.core.seq(seq__46131_47005);
if(temp__5720__auto___47016){
var seq__46131_47017__$1 = temp__5720__auto___47016;
if(cljs.core.chunked_seq_QMARK_(seq__46131_47017__$1)){
var c__4556__auto___47018 = cljs.core.chunk_first(seq__46131_47017__$1);
var G__47019 = cljs.core.chunk_rest(seq__46131_47017__$1);
var G__47020 = c__4556__auto___47018;
var G__47021 = cljs.core.count(c__4556__auto___47018);
var G__47022 = (0);
seq__46131_47005 = G__47019;
chunk__46132_47006 = G__47020;
count__46133_47007 = G__47021;
i__46134_47008 = G__47022;
continue;
} else {
var vec__46149_47023 = cljs.core.first(seq__46131_47017__$1);
var script_tag_47024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46149_47023,(0),null);
var script_body_47025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46149_47023,(1),null);
eval(script_body_47025);


var G__47026 = cljs.core.next(seq__46131_47017__$1);
var G__47027 = null;
var G__47028 = (0);
var G__47029 = (0);
seq__46131_47005 = G__47026;
chunk__46132_47006 = G__47027;
count__46133_47007 = G__47028;
i__46134_47008 = G__47029;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46154){
var vec__46156 = p__46154;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46156,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46156,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46170 = arguments.length;
switch (G__46170) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46192 = cljs.core.seq(style_keys);
var chunk__46193 = null;
var count__46194 = (0);
var i__46195 = (0);
while(true){
if((i__46195 < count__46194)){
var it = chunk__46193.cljs$core$IIndexed$_nth$arity$2(null,i__46195);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47050 = seq__46192;
var G__47051 = chunk__46193;
var G__47052 = count__46194;
var G__47053 = (i__46195 + (1));
seq__46192 = G__47050;
chunk__46193 = G__47051;
count__46194 = G__47052;
i__46195 = G__47053;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__46192);
if(temp__5720__auto__){
var seq__46192__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46192__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46192__$1);
var G__47055 = cljs.core.chunk_rest(seq__46192__$1);
var G__47056 = c__4556__auto__;
var G__47057 = cljs.core.count(c__4556__auto__);
var G__47058 = (0);
seq__46192 = G__47055;
chunk__46193 = G__47056;
count__46194 = G__47057;
i__46195 = G__47058;
continue;
} else {
var it = cljs.core.first(seq__46192__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47060 = cljs.core.next(seq__46192__$1);
var G__47061 = null;
var G__47062 = (0);
var G__47063 = (0);
seq__46192 = G__47060;
chunk__46193 = G__47061;
count__46194 = G__47062;
i__46195 = G__47063;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46200,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46206 = k46200;
var G__46206__$1 = (((G__46206 instanceof cljs.core.Keyword))?G__46206.fqn:null);
switch (G__46206__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46200,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46212){
var vec__46214 = p__46212;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46214,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46214,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46199){
var self__ = this;
var G__46199__$1 = this;
return (new cljs.core.RecordIter((0),G__46199__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46201,other46202){
var self__ = this;
var this46201__$1 = this;
return (((!((other46202 == null)))) && ((this46201__$1.constructor === other46202.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46201__$1.x,other46202.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46201__$1.y,other46202.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46201__$1.__extmap,other46202.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46199){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46228 = cljs.core.keyword_identical_QMARK_;
var expr__46229 = k__4388__auto__;
if(cljs.core.truth_((pred__46228.cljs$core$IFn$_invoke$arity$2 ? pred__46228.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46229) : pred__46228.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46229)))){
return (new shadow.dom.Coordinate(G__46199,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46228.cljs$core$IFn$_invoke$arity$2 ? pred__46228.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46229) : pred__46228.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46229)))){
return (new shadow.dom.Coordinate(self__.x,G__46199,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46199),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46199){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46199,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46204){
var extmap__4419__auto__ = (function (){var G__46234 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46204,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46204)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46234);
} else {
return G__46234;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46204),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46204),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k46248,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__46257 = k46248;
var G__46257__$1 = (((G__46257 instanceof cljs.core.Keyword))?G__46257.fqn:null);
switch (G__46257__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46248,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__46260){
var vec__46266 = p__46260;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46266,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46266,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46247){
var self__ = this;
var G__46247__$1 = this;
return (new cljs.core.RecordIter((0),G__46247__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46249,other46250){
var self__ = this;
var this46249__$1 = this;
return (((!((other46250 == null)))) && ((this46249__$1.constructor === other46250.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46249__$1.w,other46250.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46249__$1.h,other46250.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46249__$1.__extmap,other46250.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__46247){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__46311 = cljs.core.keyword_identical_QMARK_;
var expr__46312 = k__4388__auto__;
if(cljs.core.truth_((pred__46311.cljs$core$IFn$_invoke$arity$2 ? pred__46311.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__46312) : pred__46311.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__46312)))){
return (new shadow.dom.Size(G__46247,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46311.cljs$core$IFn$_invoke$arity$2 ? pred__46311.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__46312) : pred__46311.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__46312)))){
return (new shadow.dom.Size(self__.w,G__46247,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__46247),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__46247){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__46247,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__46251){
var extmap__4419__auto__ = (function (){var G__46333 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46251,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__46251)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__46333);
} else {
return G__46333;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__46251),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__46251),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47133 = (i + (1));
var G__47134 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__47133;
ret = G__47134;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__46361){
var vec__46362 = p__46361;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46362,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46362,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__46378 = arguments.length;
switch (G__46378) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47156 = ps;
var G__47157 = (i + (1));
el__$1 = G__47156;
i = G__47157;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__46421 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46421,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46421,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46421,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__46427_47170 = cljs.core.seq(props);
var chunk__46428_47171 = null;
var count__46429_47172 = (0);
var i__46430_47173 = (0);
while(true){
if((i__46430_47173 < count__46429_47172)){
var vec__46454_47174 = chunk__46428_47171.cljs$core$IIndexed$_nth$arity$2(null,i__46430_47173);
var k_47175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46454_47174,(0),null);
var v_47176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46454_47174,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_47175);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47175),v_47176);


var G__47180 = seq__46427_47170;
var G__47181 = chunk__46428_47171;
var G__47182 = count__46429_47172;
var G__47183 = (i__46430_47173 + (1));
seq__46427_47170 = G__47180;
chunk__46428_47171 = G__47181;
count__46429_47172 = G__47182;
i__46430_47173 = G__47183;
continue;
} else {
var temp__5720__auto___47184 = cljs.core.seq(seq__46427_47170);
if(temp__5720__auto___47184){
var seq__46427_47186__$1 = temp__5720__auto___47184;
if(cljs.core.chunked_seq_QMARK_(seq__46427_47186__$1)){
var c__4556__auto___47187 = cljs.core.chunk_first(seq__46427_47186__$1);
var G__47188 = cljs.core.chunk_rest(seq__46427_47186__$1);
var G__47189 = c__4556__auto___47187;
var G__47190 = cljs.core.count(c__4556__auto___47187);
var G__47191 = (0);
seq__46427_47170 = G__47188;
chunk__46428_47171 = G__47189;
count__46429_47172 = G__47190;
i__46430_47173 = G__47191;
continue;
} else {
var vec__46465_47192 = cljs.core.first(seq__46427_47186__$1);
var k_47193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46465_47192,(0),null);
var v_47194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46465_47192,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_47193);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47193),v_47194);


var G__47195 = cljs.core.next(seq__46427_47186__$1);
var G__47196 = null;
var G__47197 = (0);
var G__47198 = (0);
seq__46427_47170 = G__47195;
chunk__46428_47171 = G__47196;
count__46429_47172 = G__47197;
i__46430_47173 = G__47198;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__46479 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46479,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46479,(1),null);
var seq__46482_47206 = cljs.core.seq(node_children);
var chunk__46484_47207 = null;
var count__46485_47208 = (0);
var i__46486_47209 = (0);
while(true){
if((i__46486_47209 < count__46485_47208)){
var child_struct_47210 = chunk__46484_47207.cljs$core$IIndexed$_nth$arity$2(null,i__46486_47209);
if((!((child_struct_47210 == null)))){
if(typeof child_struct_47210 === 'string'){
var text_47211 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47211),child_struct_47210].join(''));
} else {
var children_47212 = shadow.dom.svg_node(child_struct_47210);
if(cljs.core.seq_QMARK_(children_47212)){
var seq__46548_47213 = cljs.core.seq(children_47212);
var chunk__46550_47214 = null;
var count__46551_47215 = (0);
var i__46552_47216 = (0);
while(true){
if((i__46552_47216 < count__46551_47215)){
var child_47217 = chunk__46550_47214.cljs$core$IIndexed$_nth$arity$2(null,i__46552_47216);
if(cljs.core.truth_(child_47217)){
node.appendChild(child_47217);


var G__47218 = seq__46548_47213;
var G__47219 = chunk__46550_47214;
var G__47220 = count__46551_47215;
var G__47221 = (i__46552_47216 + (1));
seq__46548_47213 = G__47218;
chunk__46550_47214 = G__47219;
count__46551_47215 = G__47220;
i__46552_47216 = G__47221;
continue;
} else {
var G__47222 = seq__46548_47213;
var G__47223 = chunk__46550_47214;
var G__47224 = count__46551_47215;
var G__47225 = (i__46552_47216 + (1));
seq__46548_47213 = G__47222;
chunk__46550_47214 = G__47223;
count__46551_47215 = G__47224;
i__46552_47216 = G__47225;
continue;
}
} else {
var temp__5720__auto___47226 = cljs.core.seq(seq__46548_47213);
if(temp__5720__auto___47226){
var seq__46548_47227__$1 = temp__5720__auto___47226;
if(cljs.core.chunked_seq_QMARK_(seq__46548_47227__$1)){
var c__4556__auto___47228 = cljs.core.chunk_first(seq__46548_47227__$1);
var G__47229 = cljs.core.chunk_rest(seq__46548_47227__$1);
var G__47230 = c__4556__auto___47228;
var G__47231 = cljs.core.count(c__4556__auto___47228);
var G__47232 = (0);
seq__46548_47213 = G__47229;
chunk__46550_47214 = G__47230;
count__46551_47215 = G__47231;
i__46552_47216 = G__47232;
continue;
} else {
var child_47233 = cljs.core.first(seq__46548_47227__$1);
if(cljs.core.truth_(child_47233)){
node.appendChild(child_47233);


var G__47236 = cljs.core.next(seq__46548_47227__$1);
var G__47237 = null;
var G__47238 = (0);
var G__47239 = (0);
seq__46548_47213 = G__47236;
chunk__46550_47214 = G__47237;
count__46551_47215 = G__47238;
i__46552_47216 = G__47239;
continue;
} else {
var G__47240 = cljs.core.next(seq__46548_47227__$1);
var G__47241 = null;
var G__47242 = (0);
var G__47243 = (0);
seq__46548_47213 = G__47240;
chunk__46550_47214 = G__47241;
count__46551_47215 = G__47242;
i__46552_47216 = G__47243;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47212);
}
}


var G__47244 = seq__46482_47206;
var G__47245 = chunk__46484_47207;
var G__47246 = count__46485_47208;
var G__47247 = (i__46486_47209 + (1));
seq__46482_47206 = G__47244;
chunk__46484_47207 = G__47245;
count__46485_47208 = G__47246;
i__46486_47209 = G__47247;
continue;
} else {
var G__47249 = seq__46482_47206;
var G__47250 = chunk__46484_47207;
var G__47251 = count__46485_47208;
var G__47252 = (i__46486_47209 + (1));
seq__46482_47206 = G__47249;
chunk__46484_47207 = G__47250;
count__46485_47208 = G__47251;
i__46486_47209 = G__47252;
continue;
}
} else {
var temp__5720__auto___47255 = cljs.core.seq(seq__46482_47206);
if(temp__5720__auto___47255){
var seq__46482_47256__$1 = temp__5720__auto___47255;
if(cljs.core.chunked_seq_QMARK_(seq__46482_47256__$1)){
var c__4556__auto___47257 = cljs.core.chunk_first(seq__46482_47256__$1);
var G__47258 = cljs.core.chunk_rest(seq__46482_47256__$1);
var G__47259 = c__4556__auto___47257;
var G__47260 = cljs.core.count(c__4556__auto___47257);
var G__47261 = (0);
seq__46482_47206 = G__47258;
chunk__46484_47207 = G__47259;
count__46485_47208 = G__47260;
i__46486_47209 = G__47261;
continue;
} else {
var child_struct_47262 = cljs.core.first(seq__46482_47256__$1);
if((!((child_struct_47262 == null)))){
if(typeof child_struct_47262 === 'string'){
var text_47263 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47263),child_struct_47262].join(''));
} else {
var children_47264 = shadow.dom.svg_node(child_struct_47262);
if(cljs.core.seq_QMARK_(children_47264)){
var seq__46577_47265 = cljs.core.seq(children_47264);
var chunk__46579_47266 = null;
var count__46580_47267 = (0);
var i__46581_47268 = (0);
while(true){
if((i__46581_47268 < count__46580_47267)){
var child_47269 = chunk__46579_47266.cljs$core$IIndexed$_nth$arity$2(null,i__46581_47268);
if(cljs.core.truth_(child_47269)){
node.appendChild(child_47269);


var G__47270 = seq__46577_47265;
var G__47271 = chunk__46579_47266;
var G__47272 = count__46580_47267;
var G__47273 = (i__46581_47268 + (1));
seq__46577_47265 = G__47270;
chunk__46579_47266 = G__47271;
count__46580_47267 = G__47272;
i__46581_47268 = G__47273;
continue;
} else {
var G__47274 = seq__46577_47265;
var G__47275 = chunk__46579_47266;
var G__47276 = count__46580_47267;
var G__47277 = (i__46581_47268 + (1));
seq__46577_47265 = G__47274;
chunk__46579_47266 = G__47275;
count__46580_47267 = G__47276;
i__46581_47268 = G__47277;
continue;
}
} else {
var temp__5720__auto___47278__$1 = cljs.core.seq(seq__46577_47265);
if(temp__5720__auto___47278__$1){
var seq__46577_47279__$1 = temp__5720__auto___47278__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46577_47279__$1)){
var c__4556__auto___47280 = cljs.core.chunk_first(seq__46577_47279__$1);
var G__47281 = cljs.core.chunk_rest(seq__46577_47279__$1);
var G__47282 = c__4556__auto___47280;
var G__47283 = cljs.core.count(c__4556__auto___47280);
var G__47284 = (0);
seq__46577_47265 = G__47281;
chunk__46579_47266 = G__47282;
count__46580_47267 = G__47283;
i__46581_47268 = G__47284;
continue;
} else {
var child_47286 = cljs.core.first(seq__46577_47279__$1);
if(cljs.core.truth_(child_47286)){
node.appendChild(child_47286);


var G__47288 = cljs.core.next(seq__46577_47279__$1);
var G__47289 = null;
var G__47290 = (0);
var G__47291 = (0);
seq__46577_47265 = G__47288;
chunk__46579_47266 = G__47289;
count__46580_47267 = G__47290;
i__46581_47268 = G__47291;
continue;
} else {
var G__47292 = cljs.core.next(seq__46577_47279__$1);
var G__47293 = null;
var G__47294 = (0);
var G__47295 = (0);
seq__46577_47265 = G__47292;
chunk__46579_47266 = G__47293;
count__46580_47267 = G__47294;
i__46581_47268 = G__47295;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47264);
}
}


var G__47296 = cljs.core.next(seq__46482_47256__$1);
var G__47297 = null;
var G__47298 = (0);
var G__47299 = (0);
seq__46482_47206 = G__47296;
chunk__46484_47207 = G__47297;
count__46485_47208 = G__47298;
i__46486_47209 = G__47299;
continue;
} else {
var G__47300 = cljs.core.next(seq__46482_47256__$1);
var G__47301 = null;
var G__47302 = (0);
var G__47303 = (0);
seq__46482_47206 = G__47300;
chunk__46484_47207 = G__47301;
count__46485_47208 = G__47302;
i__46486_47209 = G__47303;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47309 = arguments.length;
var i__4737__auto___47310 = (0);
while(true){
if((i__4737__auto___47310 < len__4736__auto___47309)){
args__4742__auto__.push((arguments[i__4737__auto___47310]));

var G__47311 = (i__4737__auto___47310 + (1));
i__4737__auto___47310 = G__47311;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq46632){
var G__46633 = cljs.core.first(seq46632);
var seq46632__$1 = cljs.core.next(seq46632);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46633,seq46632__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__46647 = arguments.length;
switch (G__46647) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__42872__auto___47317 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__42873__auto__ = (function (){var switch__42616__auto__ = (function (state_46660){
var state_val_46661 = (state_46660[(1)]);
if((state_val_46661 === (1))){
var state_46660__$1 = state_46660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46660__$1,(2),once_or_cleanup);
} else {
if((state_val_46661 === (2))){
var inst_46655 = (state_46660[(2)]);
var inst_46656 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_46660__$1 = (function (){var statearr_46668 = state_46660;
(statearr_46668[(7)] = inst_46655);

return statearr_46668;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46660__$1,inst_46656);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42617__auto__ = null;
var shadow$dom$state_machine__42617__auto____0 = (function (){
var statearr_46670 = [null,null,null,null,null,null,null,null];
(statearr_46670[(0)] = shadow$dom$state_machine__42617__auto__);

(statearr_46670[(1)] = (1));

return statearr_46670;
});
var shadow$dom$state_machine__42617__auto____1 = (function (state_46660){
while(true){
var ret_value__42618__auto__ = (function (){try{while(true){
var result__42619__auto__ = switch__42616__auto__(state_46660);
if(cljs.core.keyword_identical_QMARK_(result__42619__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42619__auto__;
}
break;
}
}catch (e46671){if((e46671 instanceof Object)){
var ex__42620__auto__ = e46671;
var statearr_46672_47322 = state_46660;
(statearr_46672_47322[(5)] = ex__42620__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_46660);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46671;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42618__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47323 = state_46660;
state_46660 = G__47323;
continue;
} else {
return ret_value__42618__auto__;
}
break;
}
});
shadow$dom$state_machine__42617__auto__ = function(state_46660){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42617__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42617__auto____1.call(this,state_46660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42617__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42617__auto____0;
shadow$dom$state_machine__42617__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42617__auto____1;
return shadow$dom$state_machine__42617__auto__;
})()
})();
var state__42874__auto__ = (function (){var statearr_46676 = f__42873__auto__();
(statearr_46676[(6)] = c__42872__auto___47317);

return statearr_46676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__42874__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
