goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28347 = arguments.length;
switch (G__28347) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28348 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28348 = (function (f,blockable,meta28349){
this.f = f;
this.blockable = blockable;
this.meta28349 = meta28349;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28348.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28350,meta28349__$1){
var self__ = this;
var _28350__$1 = this;
return (new cljs.core.async.t_cljs$core$async28348(self__.f,self__.blockable,meta28349__$1));
}));

(cljs.core.async.t_cljs$core$async28348.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28350){
var self__ = this;
var _28350__$1 = this;
return self__.meta28349;
}));

(cljs.core.async.t_cljs$core$async28348.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28348.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28348.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28348.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28348.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28349","meta28349",1351275565,null)], null);
}));

(cljs.core.async.t_cljs$core$async28348.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28348.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28348");

(cljs.core.async.t_cljs$core$async28348.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28348");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28348.
 */
cljs.core.async.__GT_t_cljs$core$async28348 = (function cljs$core$async$__GT_t_cljs$core$async28348(f__$1,blockable__$1,meta28349){
return (new cljs.core.async.t_cljs$core$async28348(f__$1,blockable__$1,meta28349));
});

}

return (new cljs.core.async.t_cljs$core$async28348(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28370 = arguments.length;
switch (G__28370) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28381 = arguments.length;
switch (G__28381) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28395 = arguments.length;
switch (G__28395) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30446 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30446) : fn1.call(null,val_30446));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30446) : fn1.call(null,val_30446));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28401 = arguments.length;
switch (G__28401) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30470 = n;
var x_30471 = (0);
while(true){
if((x_30471 < n__4613__auto___30470)){
(a[x_30471] = x_30471);

var G__30473 = (x_30471 + (1));
x_30471 = G__30473;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28410 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28410 = (function (flag,meta28411){
this.flag = flag;
this.meta28411 = meta28411;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28410.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28412,meta28411__$1){
var self__ = this;
var _28412__$1 = this;
return (new cljs.core.async.t_cljs$core$async28410(self__.flag,meta28411__$1));
}));

(cljs.core.async.t_cljs$core$async28410.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28412){
var self__ = this;
var _28412__$1 = this;
return self__.meta28411;
}));

(cljs.core.async.t_cljs$core$async28410.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28410.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28410.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28410.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28410.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28411","meta28411",-1257281328,null)], null);
}));

(cljs.core.async.t_cljs$core$async28410.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28410.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28410");

(cljs.core.async.t_cljs$core$async28410.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28410");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28410.
 */
cljs.core.async.__GT_t_cljs$core$async28410 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28410(flag__$1,meta28411){
return (new cljs.core.async.t_cljs$core$async28410(flag__$1,meta28411));
});

}

return (new cljs.core.async.t_cljs$core$async28410(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28417 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28417 = (function (flag,cb,meta28418){
this.flag = flag;
this.cb = cb;
this.meta28418 = meta28418;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28417.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28419,meta28418__$1){
var self__ = this;
var _28419__$1 = this;
return (new cljs.core.async.t_cljs$core$async28417(self__.flag,self__.cb,meta28418__$1));
}));

(cljs.core.async.t_cljs$core$async28417.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28419){
var self__ = this;
var _28419__$1 = this;
return self__.meta28418;
}));

(cljs.core.async.t_cljs$core$async28417.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28417.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28417.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28417.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28417.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28418","meta28418",2101960821,null)], null);
}));

(cljs.core.async.t_cljs$core$async28417.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28417.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28417");

(cljs.core.async.t_cljs$core$async28417.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28417");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28417.
 */
cljs.core.async.__GT_t_cljs$core$async28417 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28417(flag__$1,cb__$1,meta28418){
return (new cljs.core.async.t_cljs$core$async28417(flag__$1,cb__$1,meta28418));
});

}

return (new cljs.core.async.t_cljs$core$async28417(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28423_SHARP_){
var G__28425 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28423_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28425) : fret.call(null,G__28425));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28424_SHARP_){
var G__28426 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28424_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28426) : fret.call(null,G__28426));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30503 = (i + (1));
i = G__30503;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30504 = arguments.length;
var i__4737__auto___30505 = (0);
while(true){
if((i__4737__auto___30505 < len__4736__auto___30504)){
args__4742__auto__.push((arguments[i__4737__auto___30505]));

var G__30507 = (i__4737__auto___30505 + (1));
i__4737__auto___30505 = G__30507;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28434){
var map__28435 = p__28434;
var map__28435__$1 = (((((!((map__28435 == null))))?(((((map__28435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28435):map__28435);
var opts = map__28435__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28432){
var G__28433 = cljs.core.first(seq28432);
var seq28432__$1 = cljs.core.next(seq28432);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28433,seq28432__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28444 = arguments.length;
switch (G__28444) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28266__auto___30530 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28476){
var state_val_28478 = (state_28476[(1)]);
if((state_val_28478 === (7))){
var inst_28472 = (state_28476[(2)]);
var state_28476__$1 = state_28476;
var statearr_28480_30531 = state_28476__$1;
(statearr_28480_30531[(2)] = inst_28472);

(statearr_28480_30531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (1))){
var state_28476__$1 = state_28476;
var statearr_28481_30534 = state_28476__$1;
(statearr_28481_30534[(2)] = null);

(statearr_28481_30534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (4))){
var inst_28454 = (state_28476[(7)]);
var inst_28454__$1 = (state_28476[(2)]);
var inst_28455 = (inst_28454__$1 == null);
var state_28476__$1 = (function (){var statearr_28482 = state_28476;
(statearr_28482[(7)] = inst_28454__$1);

return statearr_28482;
})();
if(cljs.core.truth_(inst_28455)){
var statearr_28483_30539 = state_28476__$1;
(statearr_28483_30539[(1)] = (5));

} else {
var statearr_28484_30540 = state_28476__$1;
(statearr_28484_30540[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (13))){
var state_28476__$1 = state_28476;
var statearr_28487_30542 = state_28476__$1;
(statearr_28487_30542[(2)] = null);

(statearr_28487_30542[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (6))){
var inst_28454 = (state_28476[(7)]);
var state_28476__$1 = state_28476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28476__$1,(11),to,inst_28454);
} else {
if((state_val_28478 === (3))){
var inst_28474 = (state_28476[(2)]);
var state_28476__$1 = state_28476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28476__$1,inst_28474);
} else {
if((state_val_28478 === (12))){
var state_28476__$1 = state_28476;
var statearr_28488_30545 = state_28476__$1;
(statearr_28488_30545[(2)] = null);

(statearr_28488_30545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (2))){
var state_28476__$1 = state_28476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28476__$1,(4),from);
} else {
if((state_val_28478 === (11))){
var inst_28465 = (state_28476[(2)]);
var state_28476__$1 = state_28476;
if(cljs.core.truth_(inst_28465)){
var statearr_28489_30547 = state_28476__$1;
(statearr_28489_30547[(1)] = (12));

} else {
var statearr_28490_30549 = state_28476__$1;
(statearr_28490_30549[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (9))){
var state_28476__$1 = state_28476;
var statearr_28491_30553 = state_28476__$1;
(statearr_28491_30553[(2)] = null);

(statearr_28491_30553[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (5))){
var state_28476__$1 = state_28476;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28493_30557 = state_28476__$1;
(statearr_28493_30557[(1)] = (8));

} else {
var statearr_28495_30558 = state_28476__$1;
(statearr_28495_30558[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (14))){
var inst_28470 = (state_28476[(2)]);
var state_28476__$1 = state_28476;
var statearr_28496_30562 = state_28476__$1;
(statearr_28496_30562[(2)] = inst_28470);

(statearr_28496_30562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (10))){
var inst_28462 = (state_28476[(2)]);
var state_28476__$1 = state_28476;
var statearr_28504_30563 = state_28476__$1;
(statearr_28504_30563[(2)] = inst_28462);

(statearr_28504_30563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28478 === (8))){
var inst_28459 = cljs.core.async.close_BANG_(to);
var state_28476__$1 = state_28476;
var statearr_28505_30564 = state_28476__$1;
(statearr_28505_30564[(2)] = inst_28459);

(statearr_28505_30564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_28506 = [null,null,null,null,null,null,null,null];
(statearr_28506[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_28506[(1)] = (1));

return statearr_28506;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_28476){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28476);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28510){if((e28510 instanceof Object)){
var ex__28141__auto__ = e28510;
var statearr_28511_30566 = state_28476;
(statearr_28511_30566[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28476);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28510;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30572 = state_28476;
state_28476 = G__30572;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_28476){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_28476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28516 = f__28267__auto__();
(statearr_28516[(6)] = c__28266__auto___30530);

return statearr_28516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28521){
var vec__28522 = p__28521;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28522,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28522,(1),null);
var job = vec__28522;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28266__auto___30574 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28537){
var state_val_28538 = (state_28537[(1)]);
if((state_val_28538 === (1))){
var state_28537__$1 = state_28537;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28537__$1,(2),res,v);
} else {
if((state_val_28538 === (2))){
var inst_28533 = (state_28537[(2)]);
var inst_28535 = cljs.core.async.close_BANG_(res);
var state_28537__$1 = (function (){var statearr_28539 = state_28537;
(statearr_28539[(7)] = inst_28533);

return statearr_28539;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28537__$1,inst_28535);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28543 = [null,null,null,null,null,null,null,null];
(statearr_28543[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28543[(1)] = (1));

return statearr_28543;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28537){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28537);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28544){if((e28544 instanceof Object)){
var ex__28141__auto__ = e28544;
var statearr_28545_30579 = state_28537;
(statearr_28545_30579[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28537);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28544;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30584 = state_28537;
state_28537 = G__30584;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28537){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28546 = f__28267__auto__();
(statearr_28546[(6)] = c__28266__auto___30574);

return statearr_28546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28547){
var vec__28548 = p__28547;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28548,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28548,(1),null);
var job = vec__28548;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30587 = n;
var __30588 = (0);
while(true){
if((__30588 < n__4613__auto___30587)){
var G__28557_30589 = type;
var G__28557_30590__$1 = (((G__28557_30589 instanceof cljs.core.Keyword))?G__28557_30589.fqn:null);
switch (G__28557_30590__$1) {
case "compute":
var c__28266__auto___30592 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30588,c__28266__auto___30592,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async){
return (function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = ((function (__30588,c__28266__auto___30592,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async){
return (function (state_28570){
var state_val_28571 = (state_28570[(1)]);
if((state_val_28571 === (1))){
var state_28570__$1 = state_28570;
var statearr_28572_30593 = state_28570__$1;
(statearr_28572_30593[(2)] = null);

(statearr_28572_30593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28571 === (2))){
var state_28570__$1 = state_28570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28570__$1,(4),jobs);
} else {
if((state_val_28571 === (3))){
var inst_28568 = (state_28570[(2)]);
var state_28570__$1 = state_28570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28570__$1,inst_28568);
} else {
if((state_val_28571 === (4))){
var inst_28560 = (state_28570[(2)]);
var inst_28561 = process(inst_28560);
var state_28570__$1 = state_28570;
if(cljs.core.truth_(inst_28561)){
var statearr_28573_30594 = state_28570__$1;
(statearr_28573_30594[(1)] = (5));

} else {
var statearr_28574_30595 = state_28570__$1;
(statearr_28574_30595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28571 === (5))){
var state_28570__$1 = state_28570;
var statearr_28575_30596 = state_28570__$1;
(statearr_28575_30596[(2)] = null);

(statearr_28575_30596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28571 === (6))){
var state_28570__$1 = state_28570;
var statearr_28577_30597 = state_28570__$1;
(statearr_28577_30597[(2)] = null);

(statearr_28577_30597[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28571 === (7))){
var inst_28566 = (state_28570[(2)]);
var state_28570__$1 = state_28570;
var statearr_28578_30598 = state_28570__$1;
(statearr_28578_30598[(2)] = inst_28566);

(statearr_28578_30598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30588,c__28266__auto___30592,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async))
;
return ((function (__30588,switch__28137__auto__,c__28266__auto___30592,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28579 = [null,null,null,null,null,null,null];
(statearr_28579[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28579[(1)] = (1));

return statearr_28579;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28570){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28570);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28580){if((e28580 instanceof Object)){
var ex__28141__auto__ = e28580;
var statearr_28581_30604 = state_28570;
(statearr_28581_30604[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28570);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28580;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30605 = state_28570;
state_28570 = G__30605;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28570){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
;})(__30588,switch__28137__auto__,c__28266__auto___30592,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async))
})();
var state__28268__auto__ = (function (){var statearr_28582 = f__28267__auto__();
(statearr_28582[(6)] = c__28266__auto___30592);

return statearr_28582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
});})(__30588,c__28266__auto___30592,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async))
);


break;
case "async":
var c__28266__auto___30609 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30588,c__28266__auto___30609,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async){
return (function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = ((function (__30588,c__28266__auto___30609,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async){
return (function (state_28595){
var state_val_28596 = (state_28595[(1)]);
if((state_val_28596 === (1))){
var state_28595__$1 = state_28595;
var statearr_28597_30610 = state_28595__$1;
(statearr_28597_30610[(2)] = null);

(statearr_28597_30610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (2))){
var state_28595__$1 = state_28595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28595__$1,(4),jobs);
} else {
if((state_val_28596 === (3))){
var inst_28593 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28595__$1,inst_28593);
} else {
if((state_val_28596 === (4))){
var inst_28585 = (state_28595[(2)]);
var inst_28586 = async(inst_28585);
var state_28595__$1 = state_28595;
if(cljs.core.truth_(inst_28586)){
var statearr_28601_30611 = state_28595__$1;
(statearr_28601_30611[(1)] = (5));

} else {
var statearr_28602_30612 = state_28595__$1;
(statearr_28602_30612[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (5))){
var state_28595__$1 = state_28595;
var statearr_28603_30613 = state_28595__$1;
(statearr_28603_30613[(2)] = null);

(statearr_28603_30613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (6))){
var state_28595__$1 = state_28595;
var statearr_28607_30614 = state_28595__$1;
(statearr_28607_30614[(2)] = null);

(statearr_28607_30614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28596 === (7))){
var inst_28591 = (state_28595[(2)]);
var state_28595__$1 = state_28595;
var statearr_28608_30615 = state_28595__$1;
(statearr_28608_30615[(2)] = inst_28591);

(statearr_28608_30615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30588,c__28266__auto___30609,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async))
;
return ((function (__30588,switch__28137__auto__,c__28266__auto___30609,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28609 = [null,null,null,null,null,null,null];
(statearr_28609[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28609[(1)] = (1));

return statearr_28609;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28595){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28595);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28613){if((e28613 instanceof Object)){
var ex__28141__auto__ = e28613;
var statearr_28614_30618 = state_28595;
(statearr_28614_30618[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28613;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30620 = state_28595;
state_28595 = G__30620;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28595){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
;})(__30588,switch__28137__auto__,c__28266__auto___30609,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async))
})();
var state__28268__auto__ = (function (){var statearr_28615 = f__28267__auto__();
(statearr_28615[(6)] = c__28266__auto___30609);

return statearr_28615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
});})(__30588,c__28266__auto___30609,G__28557_30589,G__28557_30590__$1,n__4613__auto___30587,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28557_30590__$1)].join('')));

}

var G__30623 = (__30588 + (1));
__30588 = G__30623;
continue;
} else {
}
break;
}

var c__28266__auto___30627 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28641){
var state_val_28642 = (state_28641[(1)]);
if((state_val_28642 === (7))){
var inst_28637 = (state_28641[(2)]);
var state_28641__$1 = state_28641;
var statearr_28646_30630 = state_28641__$1;
(statearr_28646_30630[(2)] = inst_28637);

(statearr_28646_30630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28642 === (1))){
var state_28641__$1 = state_28641;
var statearr_28647_30632 = state_28641__$1;
(statearr_28647_30632[(2)] = null);

(statearr_28647_30632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28642 === (4))){
var inst_28619 = (state_28641[(7)]);
var inst_28619__$1 = (state_28641[(2)]);
var inst_28620 = (inst_28619__$1 == null);
var state_28641__$1 = (function (){var statearr_28648 = state_28641;
(statearr_28648[(7)] = inst_28619__$1);

return statearr_28648;
})();
if(cljs.core.truth_(inst_28620)){
var statearr_28649_30640 = state_28641__$1;
(statearr_28649_30640[(1)] = (5));

} else {
var statearr_28650_30641 = state_28641__$1;
(statearr_28650_30641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28642 === (6))){
var inst_28624 = (state_28641[(8)]);
var inst_28619 = (state_28641[(7)]);
var inst_28624__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28629 = [inst_28619,inst_28624__$1];
var inst_28630 = (new cljs.core.PersistentVector(null,2,(5),inst_28625,inst_28629,null));
var state_28641__$1 = (function (){var statearr_28651 = state_28641;
(statearr_28651[(8)] = inst_28624__$1);

return statearr_28651;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28641__$1,(8),jobs,inst_28630);
} else {
if((state_val_28642 === (3))){
var inst_28639 = (state_28641[(2)]);
var state_28641__$1 = state_28641;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28641__$1,inst_28639);
} else {
if((state_val_28642 === (2))){
var state_28641__$1 = state_28641;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28641__$1,(4),from);
} else {
if((state_val_28642 === (9))){
var inst_28634 = (state_28641[(2)]);
var state_28641__$1 = (function (){var statearr_28652 = state_28641;
(statearr_28652[(9)] = inst_28634);

return statearr_28652;
})();
var statearr_28653_30645 = state_28641__$1;
(statearr_28653_30645[(2)] = null);

(statearr_28653_30645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28642 === (5))){
var inst_28622 = cljs.core.async.close_BANG_(jobs);
var state_28641__$1 = state_28641;
var statearr_28660_30647 = state_28641__$1;
(statearr_28660_30647[(2)] = inst_28622);

(statearr_28660_30647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28642 === (8))){
var inst_28624 = (state_28641[(8)]);
var inst_28632 = (state_28641[(2)]);
var state_28641__$1 = (function (){var statearr_28666 = state_28641;
(statearr_28666[(10)] = inst_28632);

return statearr_28666;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28641__$1,(9),results,inst_28624);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28676 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28676[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28676[(1)] = (1));

return statearr_28676;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28641){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28641);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28681){if((e28681 instanceof Object)){
var ex__28141__auto__ = e28681;
var statearr_28682_30652 = state_28641;
(statearr_28682_30652[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28681;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30654 = state_28641;
state_28641 = G__30654;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28641){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28687 = f__28267__auto__();
(statearr_28687[(6)] = c__28266__auto___30627);

return statearr_28687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


var c__28266__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28726){
var state_val_28727 = (state_28726[(1)]);
if((state_val_28727 === (7))){
var inst_28722 = (state_28726[(2)]);
var state_28726__$1 = state_28726;
var statearr_28729_30657 = state_28726__$1;
(statearr_28729_30657[(2)] = inst_28722);

(statearr_28729_30657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (20))){
var state_28726__$1 = state_28726;
var statearr_28736_30660 = state_28726__$1;
(statearr_28736_30660[(2)] = null);

(statearr_28736_30660[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (1))){
var state_28726__$1 = state_28726;
var statearr_28737_30663 = state_28726__$1;
(statearr_28737_30663[(2)] = null);

(statearr_28737_30663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (4))){
var inst_28691 = (state_28726[(7)]);
var inst_28691__$1 = (state_28726[(2)]);
var inst_28692 = (inst_28691__$1 == null);
var state_28726__$1 = (function (){var statearr_28740 = state_28726;
(statearr_28740[(7)] = inst_28691__$1);

return statearr_28740;
})();
if(cljs.core.truth_(inst_28692)){
var statearr_28741_30669 = state_28726__$1;
(statearr_28741_30669[(1)] = (5));

} else {
var statearr_28745_30672 = state_28726__$1;
(statearr_28745_30672[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (15))){
var inst_28704 = (state_28726[(8)]);
var state_28726__$1 = state_28726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28726__$1,(18),to,inst_28704);
} else {
if((state_val_28727 === (21))){
var inst_28717 = (state_28726[(2)]);
var state_28726__$1 = state_28726;
var statearr_28746_30674 = state_28726__$1;
(statearr_28746_30674[(2)] = inst_28717);

(statearr_28746_30674[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (13))){
var inst_28719 = (state_28726[(2)]);
var state_28726__$1 = (function (){var statearr_28747 = state_28726;
(statearr_28747[(9)] = inst_28719);

return statearr_28747;
})();
var statearr_28748_30678 = state_28726__$1;
(statearr_28748_30678[(2)] = null);

(statearr_28748_30678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (6))){
var inst_28691 = (state_28726[(7)]);
var state_28726__$1 = state_28726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28726__$1,(11),inst_28691);
} else {
if((state_val_28727 === (17))){
var inst_28712 = (state_28726[(2)]);
var state_28726__$1 = state_28726;
if(cljs.core.truth_(inst_28712)){
var statearr_28749_30681 = state_28726__$1;
(statearr_28749_30681[(1)] = (19));

} else {
var statearr_28750_30685 = state_28726__$1;
(statearr_28750_30685[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (3))){
var inst_28724 = (state_28726[(2)]);
var state_28726__$1 = state_28726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28726__$1,inst_28724);
} else {
if((state_val_28727 === (12))){
var inst_28701 = (state_28726[(10)]);
var state_28726__$1 = state_28726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28726__$1,(14),inst_28701);
} else {
if((state_val_28727 === (2))){
var state_28726__$1 = state_28726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28726__$1,(4),results);
} else {
if((state_val_28727 === (19))){
var state_28726__$1 = state_28726;
var statearr_28755_30689 = state_28726__$1;
(statearr_28755_30689[(2)] = null);

(statearr_28755_30689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (11))){
var inst_28701 = (state_28726[(2)]);
var state_28726__$1 = (function (){var statearr_28761 = state_28726;
(statearr_28761[(10)] = inst_28701);

return statearr_28761;
})();
var statearr_28763_30694 = state_28726__$1;
(statearr_28763_30694[(2)] = null);

(statearr_28763_30694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (9))){
var state_28726__$1 = state_28726;
var statearr_28770_30695 = state_28726__$1;
(statearr_28770_30695[(2)] = null);

(statearr_28770_30695[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (5))){
var state_28726__$1 = state_28726;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28776_30700 = state_28726__$1;
(statearr_28776_30700[(1)] = (8));

} else {
var statearr_28777_30701 = state_28726__$1;
(statearr_28777_30701[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (14))){
var inst_28704 = (state_28726[(8)]);
var inst_28704__$1 = (state_28726[(2)]);
var inst_28705 = (inst_28704__$1 == null);
var inst_28706 = cljs.core.not(inst_28705);
var state_28726__$1 = (function (){var statearr_28778 = state_28726;
(statearr_28778[(8)] = inst_28704__$1);

return statearr_28778;
})();
if(inst_28706){
var statearr_28779_30709 = state_28726__$1;
(statearr_28779_30709[(1)] = (15));

} else {
var statearr_28780_30710 = state_28726__$1;
(statearr_28780_30710[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (16))){
var state_28726__$1 = state_28726;
var statearr_28781_30712 = state_28726__$1;
(statearr_28781_30712[(2)] = false);

(statearr_28781_30712[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (10))){
var inst_28698 = (state_28726[(2)]);
var state_28726__$1 = state_28726;
var statearr_28785_30715 = state_28726__$1;
(statearr_28785_30715[(2)] = inst_28698);

(statearr_28785_30715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (18))){
var inst_28709 = (state_28726[(2)]);
var state_28726__$1 = state_28726;
var statearr_28786_30718 = state_28726__$1;
(statearr_28786_30718[(2)] = inst_28709);

(statearr_28786_30718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28727 === (8))){
var inst_28695 = cljs.core.async.close_BANG_(to);
var state_28726__$1 = state_28726;
var statearr_28793_30721 = state_28726__$1;
(statearr_28793_30721[(2)] = inst_28695);

(statearr_28793_30721[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28805 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28805[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28805[(1)] = (1));

return statearr_28805;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28726){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28726);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28811){if((e28811 instanceof Object)){
var ex__28141__auto__ = e28811;
var statearr_28812_30730 = state_28726;
(statearr_28812_30730[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28726);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28811;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30740 = state_28726;
state_28726 = G__30740;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28726){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28814 = f__28267__auto__();
(statearr_28814[(6)] = c__28266__auto__);

return statearr_28814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));

return c__28266__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28827 = arguments.length;
switch (G__28827) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28844 = arguments.length;
switch (G__28844) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28848 = arguments.length;
switch (G__28848) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28266__auto___30831 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28875){
var state_val_28876 = (state_28875[(1)]);
if((state_val_28876 === (7))){
var inst_28870 = (state_28875[(2)]);
var state_28875__$1 = state_28875;
var statearr_28882_30836 = state_28875__$1;
(statearr_28882_30836[(2)] = inst_28870);

(statearr_28882_30836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (1))){
var state_28875__$1 = state_28875;
var statearr_28883_30839 = state_28875__$1;
(statearr_28883_30839[(2)] = null);

(statearr_28883_30839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (4))){
var inst_28851 = (state_28875[(7)]);
var inst_28851__$1 = (state_28875[(2)]);
var inst_28852 = (inst_28851__$1 == null);
var state_28875__$1 = (function (){var statearr_28888 = state_28875;
(statearr_28888[(7)] = inst_28851__$1);

return statearr_28888;
})();
if(cljs.core.truth_(inst_28852)){
var statearr_28889_30844 = state_28875__$1;
(statearr_28889_30844[(1)] = (5));

} else {
var statearr_28890_30845 = state_28875__$1;
(statearr_28890_30845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (13))){
var state_28875__$1 = state_28875;
var statearr_28895_30851 = state_28875__$1;
(statearr_28895_30851[(2)] = null);

(statearr_28895_30851[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (6))){
var inst_28851 = (state_28875[(7)]);
var inst_28857 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28851) : p.call(null,inst_28851));
var state_28875__$1 = state_28875;
if(cljs.core.truth_(inst_28857)){
var statearr_28896_30854 = state_28875__$1;
(statearr_28896_30854[(1)] = (9));

} else {
var statearr_28897_30856 = state_28875__$1;
(statearr_28897_30856[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (3))){
var inst_28872 = (state_28875[(2)]);
var state_28875__$1 = state_28875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28875__$1,inst_28872);
} else {
if((state_val_28876 === (12))){
var state_28875__$1 = state_28875;
var statearr_28903_30859 = state_28875__$1;
(statearr_28903_30859[(2)] = null);

(statearr_28903_30859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (2))){
var state_28875__$1 = state_28875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28875__$1,(4),ch);
} else {
if((state_val_28876 === (11))){
var inst_28851 = (state_28875[(7)]);
var inst_28861 = (state_28875[(2)]);
var state_28875__$1 = state_28875;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28875__$1,(8),inst_28861,inst_28851);
} else {
if((state_val_28876 === (9))){
var state_28875__$1 = state_28875;
var statearr_28905_30866 = state_28875__$1;
(statearr_28905_30866[(2)] = tc);

(statearr_28905_30866[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (5))){
var inst_28854 = cljs.core.async.close_BANG_(tc);
var inst_28855 = cljs.core.async.close_BANG_(fc);
var state_28875__$1 = (function (){var statearr_28906 = state_28875;
(statearr_28906[(8)] = inst_28854);

return statearr_28906;
})();
var statearr_28907_30871 = state_28875__$1;
(statearr_28907_30871[(2)] = inst_28855);

(statearr_28907_30871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (14))){
var inst_28868 = (state_28875[(2)]);
var state_28875__$1 = state_28875;
var statearr_28908_30875 = state_28875__$1;
(statearr_28908_30875[(2)] = inst_28868);

(statearr_28908_30875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (10))){
var state_28875__$1 = state_28875;
var statearr_28909_30879 = state_28875__$1;
(statearr_28909_30879[(2)] = fc);

(statearr_28909_30879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28876 === (8))){
var inst_28863 = (state_28875[(2)]);
var state_28875__$1 = state_28875;
if(cljs.core.truth_(inst_28863)){
var statearr_28910_30880 = state_28875__$1;
(statearr_28910_30880[(1)] = (12));

} else {
var statearr_28911_30882 = state_28875__$1;
(statearr_28911_30882[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_28912 = [null,null,null,null,null,null,null,null,null];
(statearr_28912[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_28912[(1)] = (1));

return statearr_28912;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_28875){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28875);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28913){if((e28913 instanceof Object)){
var ex__28141__auto__ = e28913;
var statearr_28914_30890 = state_28875;
(statearr_28914_30890[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28875);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28913;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30892 = state_28875;
state_28875 = G__30892;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_28875){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_28875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28915 = f__28267__auto__();
(statearr_28915[(6)] = c__28266__auto___30831);

return statearr_28915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28266__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28936){
var state_val_28937 = (state_28936[(1)]);
if((state_val_28937 === (7))){
var inst_28932 = (state_28936[(2)]);
var state_28936__$1 = state_28936;
var statearr_28942_30897 = state_28936__$1;
(statearr_28942_30897[(2)] = inst_28932);

(statearr_28942_30897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (1))){
var inst_28916 = init;
var state_28936__$1 = (function (){var statearr_28943 = state_28936;
(statearr_28943[(7)] = inst_28916);

return statearr_28943;
})();
var statearr_28945_30899 = state_28936__$1;
(statearr_28945_30899[(2)] = null);

(statearr_28945_30899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (4))){
var inst_28919 = (state_28936[(8)]);
var inst_28919__$1 = (state_28936[(2)]);
var inst_28920 = (inst_28919__$1 == null);
var state_28936__$1 = (function (){var statearr_28946 = state_28936;
(statearr_28946[(8)] = inst_28919__$1);

return statearr_28946;
})();
if(cljs.core.truth_(inst_28920)){
var statearr_28947_30902 = state_28936__$1;
(statearr_28947_30902[(1)] = (5));

} else {
var statearr_28951_30903 = state_28936__$1;
(statearr_28951_30903[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (6))){
var inst_28923 = (state_28936[(9)]);
var inst_28919 = (state_28936[(8)]);
var inst_28916 = (state_28936[(7)]);
var inst_28923__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_28916,inst_28919) : f.call(null,inst_28916,inst_28919));
var inst_28924 = cljs.core.reduced_QMARK_(inst_28923__$1);
var state_28936__$1 = (function (){var statearr_28955 = state_28936;
(statearr_28955[(9)] = inst_28923__$1);

return statearr_28955;
})();
if(inst_28924){
var statearr_28956_30911 = state_28936__$1;
(statearr_28956_30911[(1)] = (8));

} else {
var statearr_28957_30912 = state_28936__$1;
(statearr_28957_30912[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (3))){
var inst_28934 = (state_28936[(2)]);
var state_28936__$1 = state_28936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28936__$1,inst_28934);
} else {
if((state_val_28937 === (2))){
var state_28936__$1 = state_28936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28936__$1,(4),ch);
} else {
if((state_val_28937 === (9))){
var inst_28923 = (state_28936[(9)]);
var inst_28916 = inst_28923;
var state_28936__$1 = (function (){var statearr_28958 = state_28936;
(statearr_28958[(7)] = inst_28916);

return statearr_28958;
})();
var statearr_28959_30924 = state_28936__$1;
(statearr_28959_30924[(2)] = null);

(statearr_28959_30924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (5))){
var inst_28916 = (state_28936[(7)]);
var state_28936__$1 = state_28936;
var statearr_28960_30928 = state_28936__$1;
(statearr_28960_30928[(2)] = inst_28916);

(statearr_28960_30928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (10))){
var inst_28930 = (state_28936[(2)]);
var state_28936__$1 = state_28936;
var statearr_28961_30931 = state_28936__$1;
(statearr_28961_30931[(2)] = inst_28930);

(statearr_28961_30931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28937 === (8))){
var inst_28923 = (state_28936[(9)]);
var inst_28926 = cljs.core.deref(inst_28923);
var state_28936__$1 = state_28936;
var statearr_28962_30932 = state_28936__$1;
(statearr_28962_30932[(2)] = inst_28926);

(statearr_28962_30932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28138__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28138__auto____0 = (function (){
var statearr_28963 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28963[(0)] = cljs$core$async$reduce_$_state_machine__28138__auto__);

(statearr_28963[(1)] = (1));

return statearr_28963;
});
var cljs$core$async$reduce_$_state_machine__28138__auto____1 = (function (state_28936){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28936);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28964){if((e28964 instanceof Object)){
var ex__28141__auto__ = e28964;
var statearr_28965_30937 = state_28936;
(statearr_28965_30937[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28936);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28964;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30946 = state_28936;
state_28936 = G__30946;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28138__auto__ = function(state_28936){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28138__auto____1.call(this,state_28936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28138__auto____0;
cljs$core$async$reduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28138__auto____1;
return cljs$core$async$reduce_$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28966 = f__28267__auto__();
(statearr_28966[(6)] = c__28266__auto__);

return statearr_28966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));

return c__28266__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28266__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_28974){
var state_val_28975 = (state_28974[(1)]);
if((state_val_28975 === (1))){
var inst_28969 = cljs.core.async.reduce(f__$1,init,ch);
var state_28974__$1 = state_28974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28974__$1,(2),inst_28969);
} else {
if((state_val_28975 === (2))){
var inst_28971 = (state_28974[(2)]);
var inst_28972 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_28971) : f__$1.call(null,inst_28971));
var state_28974__$1 = state_28974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28974__$1,inst_28972);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28138__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28138__auto____0 = (function (){
var statearr_28981 = [null,null,null,null,null,null,null];
(statearr_28981[(0)] = cljs$core$async$transduce_$_state_machine__28138__auto__);

(statearr_28981[(1)] = (1));

return statearr_28981;
});
var cljs$core$async$transduce_$_state_machine__28138__auto____1 = (function (state_28974){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28974);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28983){if((e28983 instanceof Object)){
var ex__28141__auto__ = e28983;
var statearr_28984_30967 = state_28974;
(statearr_28984_30967[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28983;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30972 = state_28974;
state_28974 = G__30972;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28138__auto__ = function(state_28974){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28138__auto____1.call(this,state_28974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28138__auto____0;
cljs$core$async$transduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28138__auto____1;
return cljs$core$async$transduce_$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_28985 = f__28267__auto__();
(statearr_28985[(6)] = c__28266__auto__);

return statearr_28985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));

return c__28266__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__28990 = arguments.length;
switch (G__28990) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28266__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29015){
var state_val_29016 = (state_29015[(1)]);
if((state_val_29016 === (7))){
var inst_28997 = (state_29015[(2)]);
var state_29015__$1 = state_29015;
var statearr_29018_30986 = state_29015__$1;
(statearr_29018_30986[(2)] = inst_28997);

(statearr_29018_30986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (1))){
var inst_28991 = cljs.core.seq(coll);
var inst_28992 = inst_28991;
var state_29015__$1 = (function (){var statearr_29019 = state_29015;
(statearr_29019[(7)] = inst_28992);

return statearr_29019;
})();
var statearr_29020_30988 = state_29015__$1;
(statearr_29020_30988[(2)] = null);

(statearr_29020_30988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (4))){
var inst_28992 = (state_29015[(7)]);
var inst_28995 = cljs.core.first(inst_28992);
var state_29015__$1 = state_29015;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29015__$1,(7),ch,inst_28995);
} else {
if((state_val_29016 === (13))){
var inst_29009 = (state_29015[(2)]);
var state_29015__$1 = state_29015;
var statearr_29021_30994 = state_29015__$1;
(statearr_29021_30994[(2)] = inst_29009);

(statearr_29021_30994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (6))){
var inst_29000 = (state_29015[(2)]);
var state_29015__$1 = state_29015;
if(cljs.core.truth_(inst_29000)){
var statearr_29022_30998 = state_29015__$1;
(statearr_29022_30998[(1)] = (8));

} else {
var statearr_29023_31000 = state_29015__$1;
(statearr_29023_31000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (3))){
var inst_29013 = (state_29015[(2)]);
var state_29015__$1 = state_29015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29015__$1,inst_29013);
} else {
if((state_val_29016 === (12))){
var state_29015__$1 = state_29015;
var statearr_29024_31005 = state_29015__$1;
(statearr_29024_31005[(2)] = null);

(statearr_29024_31005[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (2))){
var inst_28992 = (state_29015[(7)]);
var state_29015__$1 = state_29015;
if(cljs.core.truth_(inst_28992)){
var statearr_29025_31008 = state_29015__$1;
(statearr_29025_31008[(1)] = (4));

} else {
var statearr_29026_31009 = state_29015__$1;
(statearr_29026_31009[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (11))){
var inst_29006 = cljs.core.async.close_BANG_(ch);
var state_29015__$1 = state_29015;
var statearr_29027_31012 = state_29015__$1;
(statearr_29027_31012[(2)] = inst_29006);

(statearr_29027_31012[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (9))){
var state_29015__$1 = state_29015;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29030_31013 = state_29015__$1;
(statearr_29030_31013[(1)] = (11));

} else {
var statearr_29032_31015 = state_29015__$1;
(statearr_29032_31015[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (5))){
var inst_28992 = (state_29015[(7)]);
var state_29015__$1 = state_29015;
var statearr_29033_31020 = state_29015__$1;
(statearr_29033_31020[(2)] = inst_28992);

(statearr_29033_31020[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (10))){
var inst_29011 = (state_29015[(2)]);
var state_29015__$1 = state_29015;
var statearr_29034_31022 = state_29015__$1;
(statearr_29034_31022[(2)] = inst_29011);

(statearr_29034_31022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29016 === (8))){
var inst_28992 = (state_29015[(7)]);
var inst_29002 = cljs.core.next(inst_28992);
var inst_28992__$1 = inst_29002;
var state_29015__$1 = (function (){var statearr_29035 = state_29015;
(statearr_29035[(7)] = inst_28992__$1);

return statearr_29035;
})();
var statearr_29036_31025 = state_29015__$1;
(statearr_29036_31025[(2)] = null);

(statearr_29036_31025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29037 = [null,null,null,null,null,null,null,null];
(statearr_29037[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29037[(1)] = (1));

return statearr_29037;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29015){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29015);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29038){if((e29038 instanceof Object)){
var ex__28141__auto__ = e29038;
var statearr_29039_31028 = state_29015;
(statearr_29039_31028[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29038;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31029 = state_29015;
state_29015 = G__31029;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29015){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29040 = f__28267__auto__();
(statearr_29040[(6)] = c__28266__auto__);

return statearr_29040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));

return c__28266__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31031 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31031(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31033 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31033(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31073 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31073(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31121 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31121(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29043 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29043 = (function (ch,cs,meta29044){
this.ch = ch;
this.cs = cs;
this.meta29044 = meta29044;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29045,meta29044__$1){
var self__ = this;
var _29045__$1 = this;
return (new cljs.core.async.t_cljs$core$async29043(self__.ch,self__.cs,meta29044__$1));
}));

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29045){
var self__ = this;
var _29045__$1 = this;
return self__.meta29044;
}));

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29043.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29043.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29044","meta29044",498835992,null)], null);
}));

(cljs.core.async.t_cljs$core$async29043.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29043.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29043");

(cljs.core.async.t_cljs$core$async29043.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29043");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29043.
 */
cljs.core.async.__GT_t_cljs$core$async29043 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29043(ch__$1,cs__$1,meta29044){
return (new cljs.core.async.t_cljs$core$async29043(ch__$1,cs__$1,meta29044));
});

}

return (new cljs.core.async.t_cljs$core$async29043(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28266__auto___31136 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29186){
var state_val_29187 = (state_29186[(1)]);
if((state_val_29187 === (7))){
var inst_29182 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29188_31137 = state_29186__$1;
(statearr_29188_31137[(2)] = inst_29182);

(statearr_29188_31137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (20))){
var inst_29081 = (state_29186[(7)]);
var inst_29093 = cljs.core.first(inst_29081);
var inst_29094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29093,(0),null);
var inst_29095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29093,(1),null);
var state_29186__$1 = (function (){var statearr_29189 = state_29186;
(statearr_29189[(8)] = inst_29094);

return statearr_29189;
})();
if(cljs.core.truth_(inst_29095)){
var statearr_29190_31141 = state_29186__$1;
(statearr_29190_31141[(1)] = (22));

} else {
var statearr_29191_31143 = state_29186__$1;
(statearr_29191_31143[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (27))){
var inst_29127 = (state_29186[(9)]);
var inst_29134 = (state_29186[(10)]);
var inst_29129 = (state_29186[(11)]);
var inst_29050 = (state_29186[(12)]);
var inst_29134__$1 = cljs.core._nth(inst_29127,inst_29129);
var inst_29135 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29134__$1,inst_29050,done);
var state_29186__$1 = (function (){var statearr_29192 = state_29186;
(statearr_29192[(10)] = inst_29134__$1);

return statearr_29192;
})();
if(cljs.core.truth_(inst_29135)){
var statearr_29193_31146 = state_29186__$1;
(statearr_29193_31146[(1)] = (30));

} else {
var statearr_29194_31148 = state_29186__$1;
(statearr_29194_31148[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (1))){
var state_29186__$1 = state_29186;
var statearr_29199_31150 = state_29186__$1;
(statearr_29199_31150[(2)] = null);

(statearr_29199_31150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (24))){
var inst_29081 = (state_29186[(7)]);
var inst_29100 = (state_29186[(2)]);
var inst_29102 = cljs.core.next(inst_29081);
var inst_29059 = inst_29102;
var inst_29060 = null;
var inst_29061 = (0);
var inst_29062 = (0);
var state_29186__$1 = (function (){var statearr_29200 = state_29186;
(statearr_29200[(13)] = inst_29062);

(statearr_29200[(14)] = inst_29060);

(statearr_29200[(15)] = inst_29100);

(statearr_29200[(16)] = inst_29061);

(statearr_29200[(17)] = inst_29059);

return statearr_29200;
})();
var statearr_29201_31154 = state_29186__$1;
(statearr_29201_31154[(2)] = null);

(statearr_29201_31154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (39))){
var state_29186__$1 = state_29186;
var statearr_29205_31155 = state_29186__$1;
(statearr_29205_31155[(2)] = null);

(statearr_29205_31155[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (4))){
var inst_29050 = (state_29186[(12)]);
var inst_29050__$1 = (state_29186[(2)]);
var inst_29051 = (inst_29050__$1 == null);
var state_29186__$1 = (function (){var statearr_29206 = state_29186;
(statearr_29206[(12)] = inst_29050__$1);

return statearr_29206;
})();
if(cljs.core.truth_(inst_29051)){
var statearr_29207_31159 = state_29186__$1;
(statearr_29207_31159[(1)] = (5));

} else {
var statearr_29208_31163 = state_29186__$1;
(statearr_29208_31163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (15))){
var inst_29062 = (state_29186[(13)]);
var inst_29060 = (state_29186[(14)]);
var inst_29061 = (state_29186[(16)]);
var inst_29059 = (state_29186[(17)]);
var inst_29077 = (state_29186[(2)]);
var inst_29078 = (inst_29062 + (1));
var tmp29202 = inst_29060;
var tmp29203 = inst_29061;
var tmp29204 = inst_29059;
var inst_29059__$1 = tmp29204;
var inst_29060__$1 = tmp29202;
var inst_29061__$1 = tmp29203;
var inst_29062__$1 = inst_29078;
var state_29186__$1 = (function (){var statearr_29209 = state_29186;
(statearr_29209[(13)] = inst_29062__$1);

(statearr_29209[(14)] = inst_29060__$1);

(statearr_29209[(16)] = inst_29061__$1);

(statearr_29209[(17)] = inst_29059__$1);

(statearr_29209[(18)] = inst_29077);

return statearr_29209;
})();
var statearr_29213_31167 = state_29186__$1;
(statearr_29213_31167[(2)] = null);

(statearr_29213_31167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (21))){
var inst_29105 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29217_31172 = state_29186__$1;
(statearr_29217_31172[(2)] = inst_29105);

(statearr_29217_31172[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (31))){
var inst_29134 = (state_29186[(10)]);
var inst_29138 = done(null);
var inst_29139 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29134);
var state_29186__$1 = (function (){var statearr_29218 = state_29186;
(statearr_29218[(19)] = inst_29138);

return statearr_29218;
})();
var statearr_29219_31178 = state_29186__$1;
(statearr_29219_31178[(2)] = inst_29139);

(statearr_29219_31178[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (32))){
var inst_29127 = (state_29186[(9)]);
var inst_29128 = (state_29186[(20)]);
var inst_29126 = (state_29186[(21)]);
var inst_29129 = (state_29186[(11)]);
var inst_29141 = (state_29186[(2)]);
var inst_29142 = (inst_29129 + (1));
var tmp29214 = inst_29127;
var tmp29215 = inst_29128;
var tmp29216 = inst_29126;
var inst_29126__$1 = tmp29216;
var inst_29127__$1 = tmp29214;
var inst_29128__$1 = tmp29215;
var inst_29129__$1 = inst_29142;
var state_29186__$1 = (function (){var statearr_29220 = state_29186;
(statearr_29220[(22)] = inst_29141);

(statearr_29220[(9)] = inst_29127__$1);

(statearr_29220[(20)] = inst_29128__$1);

(statearr_29220[(21)] = inst_29126__$1);

(statearr_29220[(11)] = inst_29129__$1);

return statearr_29220;
})();
var statearr_29221_31193 = state_29186__$1;
(statearr_29221_31193[(2)] = null);

(statearr_29221_31193[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (40))){
var inst_29154 = (state_29186[(23)]);
var inst_29158 = done(null);
var inst_29159 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29154);
var state_29186__$1 = (function (){var statearr_29225 = state_29186;
(statearr_29225[(24)] = inst_29158);

return statearr_29225;
})();
var statearr_29226_31199 = state_29186__$1;
(statearr_29226_31199[(2)] = inst_29159);

(statearr_29226_31199[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (33))){
var inst_29145 = (state_29186[(25)]);
var inst_29147 = cljs.core.chunked_seq_QMARK_(inst_29145);
var state_29186__$1 = state_29186;
if(inst_29147){
var statearr_29227_31200 = state_29186__$1;
(statearr_29227_31200[(1)] = (36));

} else {
var statearr_29228_31201 = state_29186__$1;
(statearr_29228_31201[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (13))){
var inst_29071 = (state_29186[(26)]);
var inst_29074 = cljs.core.async.close_BANG_(inst_29071);
var state_29186__$1 = state_29186;
var statearr_29229_31203 = state_29186__$1;
(statearr_29229_31203[(2)] = inst_29074);

(statearr_29229_31203[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (22))){
var inst_29094 = (state_29186[(8)]);
var inst_29097 = cljs.core.async.close_BANG_(inst_29094);
var state_29186__$1 = state_29186;
var statearr_29230_31204 = state_29186__$1;
(statearr_29230_31204[(2)] = inst_29097);

(statearr_29230_31204[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (36))){
var inst_29145 = (state_29186[(25)]);
var inst_29149 = cljs.core.chunk_first(inst_29145);
var inst_29150 = cljs.core.chunk_rest(inst_29145);
var inst_29151 = cljs.core.count(inst_29149);
var inst_29126 = inst_29150;
var inst_29127 = inst_29149;
var inst_29128 = inst_29151;
var inst_29129 = (0);
var state_29186__$1 = (function (){var statearr_29231 = state_29186;
(statearr_29231[(9)] = inst_29127);

(statearr_29231[(20)] = inst_29128);

(statearr_29231[(21)] = inst_29126);

(statearr_29231[(11)] = inst_29129);

return statearr_29231;
})();
var statearr_29232_31208 = state_29186__$1;
(statearr_29232_31208[(2)] = null);

(statearr_29232_31208[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (41))){
var inst_29145 = (state_29186[(25)]);
var inst_29161 = (state_29186[(2)]);
var inst_29162 = cljs.core.next(inst_29145);
var inst_29126 = inst_29162;
var inst_29127 = null;
var inst_29128 = (0);
var inst_29129 = (0);
var state_29186__$1 = (function (){var statearr_29234 = state_29186;
(statearr_29234[(9)] = inst_29127);

(statearr_29234[(27)] = inst_29161);

(statearr_29234[(20)] = inst_29128);

(statearr_29234[(21)] = inst_29126);

(statearr_29234[(11)] = inst_29129);

return statearr_29234;
})();
var statearr_29237_31210 = state_29186__$1;
(statearr_29237_31210[(2)] = null);

(statearr_29237_31210[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (43))){
var state_29186__$1 = state_29186;
var statearr_29238_31211 = state_29186__$1;
(statearr_29238_31211[(2)] = null);

(statearr_29238_31211[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (29))){
var inst_29170 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29239_31215 = state_29186__$1;
(statearr_29239_31215[(2)] = inst_29170);

(statearr_29239_31215[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (44))){
var inst_29179 = (state_29186[(2)]);
var state_29186__$1 = (function (){var statearr_29240 = state_29186;
(statearr_29240[(28)] = inst_29179);

return statearr_29240;
})();
var statearr_29250_31221 = state_29186__$1;
(statearr_29250_31221[(2)] = null);

(statearr_29250_31221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (6))){
var inst_29115 = (state_29186[(29)]);
var inst_29114 = cljs.core.deref(cs);
var inst_29115__$1 = cljs.core.keys(inst_29114);
var inst_29116 = cljs.core.count(inst_29115__$1);
var inst_29117 = cljs.core.reset_BANG_(dctr,inst_29116);
var inst_29125 = cljs.core.seq(inst_29115__$1);
var inst_29126 = inst_29125;
var inst_29127 = null;
var inst_29128 = (0);
var inst_29129 = (0);
var state_29186__$1 = (function (){var statearr_29251 = state_29186;
(statearr_29251[(9)] = inst_29127);

(statearr_29251[(20)] = inst_29128);

(statearr_29251[(29)] = inst_29115__$1);

(statearr_29251[(21)] = inst_29126);

(statearr_29251[(11)] = inst_29129);

(statearr_29251[(30)] = inst_29117);

return statearr_29251;
})();
var statearr_29252_31255 = state_29186__$1;
(statearr_29252_31255[(2)] = null);

(statearr_29252_31255[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (28))){
var inst_29126 = (state_29186[(21)]);
var inst_29145 = (state_29186[(25)]);
var inst_29145__$1 = cljs.core.seq(inst_29126);
var state_29186__$1 = (function (){var statearr_29253 = state_29186;
(statearr_29253[(25)] = inst_29145__$1);

return statearr_29253;
})();
if(inst_29145__$1){
var statearr_29254_31289 = state_29186__$1;
(statearr_29254_31289[(1)] = (33));

} else {
var statearr_29255_31290 = state_29186__$1;
(statearr_29255_31290[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (25))){
var inst_29128 = (state_29186[(20)]);
var inst_29129 = (state_29186[(11)]);
var inst_29131 = (inst_29129 < inst_29128);
var inst_29132 = inst_29131;
var state_29186__$1 = state_29186;
if(cljs.core.truth_(inst_29132)){
var statearr_29265_31293 = state_29186__$1;
(statearr_29265_31293[(1)] = (27));

} else {
var statearr_29266_31294 = state_29186__$1;
(statearr_29266_31294[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (34))){
var state_29186__$1 = state_29186;
var statearr_29267_31295 = state_29186__$1;
(statearr_29267_31295[(2)] = null);

(statearr_29267_31295[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (17))){
var state_29186__$1 = state_29186;
var statearr_29268_31297 = state_29186__$1;
(statearr_29268_31297[(2)] = null);

(statearr_29268_31297[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (3))){
var inst_29184 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29186__$1,inst_29184);
} else {
if((state_val_29187 === (12))){
var inst_29110 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29269_31300 = state_29186__$1;
(statearr_29269_31300[(2)] = inst_29110);

(statearr_29269_31300[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (2))){
var state_29186__$1 = state_29186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29186__$1,(4),ch);
} else {
if((state_val_29187 === (23))){
var state_29186__$1 = state_29186;
var statearr_29270_31302 = state_29186__$1;
(statearr_29270_31302[(2)] = null);

(statearr_29270_31302[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (35))){
var inst_29168 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29271_31307 = state_29186__$1;
(statearr_29271_31307[(2)] = inst_29168);

(statearr_29271_31307[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (19))){
var inst_29081 = (state_29186[(7)]);
var inst_29085 = cljs.core.chunk_first(inst_29081);
var inst_29086 = cljs.core.chunk_rest(inst_29081);
var inst_29087 = cljs.core.count(inst_29085);
var inst_29059 = inst_29086;
var inst_29060 = inst_29085;
var inst_29061 = inst_29087;
var inst_29062 = (0);
var state_29186__$1 = (function (){var statearr_29272 = state_29186;
(statearr_29272[(13)] = inst_29062);

(statearr_29272[(14)] = inst_29060);

(statearr_29272[(16)] = inst_29061);

(statearr_29272[(17)] = inst_29059);

return statearr_29272;
})();
var statearr_29273_31311 = state_29186__$1;
(statearr_29273_31311[(2)] = null);

(statearr_29273_31311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (11))){
var inst_29081 = (state_29186[(7)]);
var inst_29059 = (state_29186[(17)]);
var inst_29081__$1 = cljs.core.seq(inst_29059);
var state_29186__$1 = (function (){var statearr_29277 = state_29186;
(statearr_29277[(7)] = inst_29081__$1);

return statearr_29277;
})();
if(inst_29081__$1){
var statearr_29278_31316 = state_29186__$1;
(statearr_29278_31316[(1)] = (16));

} else {
var statearr_29279_31318 = state_29186__$1;
(statearr_29279_31318[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (9))){
var inst_29112 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29280_31320 = state_29186__$1;
(statearr_29280_31320[(2)] = inst_29112);

(statearr_29280_31320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (5))){
var inst_29057 = cljs.core.deref(cs);
var inst_29058 = cljs.core.seq(inst_29057);
var inst_29059 = inst_29058;
var inst_29060 = null;
var inst_29061 = (0);
var inst_29062 = (0);
var state_29186__$1 = (function (){var statearr_29281 = state_29186;
(statearr_29281[(13)] = inst_29062);

(statearr_29281[(14)] = inst_29060);

(statearr_29281[(16)] = inst_29061);

(statearr_29281[(17)] = inst_29059);

return statearr_29281;
})();
var statearr_29282_31323 = state_29186__$1;
(statearr_29282_31323[(2)] = null);

(statearr_29282_31323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (14))){
var state_29186__$1 = state_29186;
var statearr_29283_31324 = state_29186__$1;
(statearr_29283_31324[(2)] = null);

(statearr_29283_31324[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (45))){
var inst_29176 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29284_31329 = state_29186__$1;
(statearr_29284_31329[(2)] = inst_29176);

(statearr_29284_31329[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (26))){
var inst_29115 = (state_29186[(29)]);
var inst_29172 = (state_29186[(2)]);
var inst_29173 = cljs.core.seq(inst_29115);
var state_29186__$1 = (function (){var statearr_29288 = state_29186;
(statearr_29288[(31)] = inst_29172);

return statearr_29288;
})();
if(inst_29173){
var statearr_29289_31333 = state_29186__$1;
(statearr_29289_31333[(1)] = (42));

} else {
var statearr_29290_31334 = state_29186__$1;
(statearr_29290_31334[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (16))){
var inst_29081 = (state_29186[(7)]);
var inst_29083 = cljs.core.chunked_seq_QMARK_(inst_29081);
var state_29186__$1 = state_29186;
if(inst_29083){
var statearr_29291_31335 = state_29186__$1;
(statearr_29291_31335[(1)] = (19));

} else {
var statearr_29292_31337 = state_29186__$1;
(statearr_29292_31337[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (38))){
var inst_29165 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29293_31338 = state_29186__$1;
(statearr_29293_31338[(2)] = inst_29165);

(statearr_29293_31338[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (30))){
var state_29186__$1 = state_29186;
var statearr_29294_31341 = state_29186__$1;
(statearr_29294_31341[(2)] = null);

(statearr_29294_31341[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (10))){
var inst_29062 = (state_29186[(13)]);
var inst_29060 = (state_29186[(14)]);
var inst_29070 = cljs.core._nth(inst_29060,inst_29062);
var inst_29071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29070,(0),null);
var inst_29072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29070,(1),null);
var state_29186__$1 = (function (){var statearr_29295 = state_29186;
(statearr_29295[(26)] = inst_29071);

return statearr_29295;
})();
if(cljs.core.truth_(inst_29072)){
var statearr_29296_31347 = state_29186__$1;
(statearr_29296_31347[(1)] = (13));

} else {
var statearr_29297_31348 = state_29186__$1;
(statearr_29297_31348[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (18))){
var inst_29108 = (state_29186[(2)]);
var state_29186__$1 = state_29186;
var statearr_29298_31349 = state_29186__$1;
(statearr_29298_31349[(2)] = inst_29108);

(statearr_29298_31349[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (42))){
var state_29186__$1 = state_29186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29186__$1,(45),dchan);
} else {
if((state_val_29187 === (37))){
var inst_29154 = (state_29186[(23)]);
var inst_29050 = (state_29186[(12)]);
var inst_29145 = (state_29186[(25)]);
var inst_29154__$1 = cljs.core.first(inst_29145);
var inst_29155 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29154__$1,inst_29050,done);
var state_29186__$1 = (function (){var statearr_29302 = state_29186;
(statearr_29302[(23)] = inst_29154__$1);

return statearr_29302;
})();
if(cljs.core.truth_(inst_29155)){
var statearr_29303_31355 = state_29186__$1;
(statearr_29303_31355[(1)] = (39));

} else {
var statearr_29304_31357 = state_29186__$1;
(statearr_29304_31357[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29187 === (8))){
var inst_29062 = (state_29186[(13)]);
var inst_29061 = (state_29186[(16)]);
var inst_29064 = (inst_29062 < inst_29061);
var inst_29065 = inst_29064;
var state_29186__$1 = state_29186;
if(cljs.core.truth_(inst_29065)){
var statearr_29305_31359 = state_29186__$1;
(statearr_29305_31359[(1)] = (10));

} else {
var statearr_29309_31361 = state_29186__$1;
(statearr_29309_31361[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28138__auto__ = null;
var cljs$core$async$mult_$_state_machine__28138__auto____0 = (function (){
var statearr_29310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29310[(0)] = cljs$core$async$mult_$_state_machine__28138__auto__);

(statearr_29310[(1)] = (1));

return statearr_29310;
});
var cljs$core$async$mult_$_state_machine__28138__auto____1 = (function (state_29186){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29186);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29311){if((e29311 instanceof Object)){
var ex__28141__auto__ = e29311;
var statearr_29312_31370 = state_29186;
(statearr_29312_31370[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29186);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29311;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31372 = state_29186;
state_29186 = G__31372;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28138__auto__ = function(state_29186){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28138__auto____1.call(this,state_29186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28138__auto____0;
cljs$core$async$mult_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28138__auto____1;
return cljs$core$async$mult_$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29314 = f__28267__auto__();
(statearr_29314[(6)] = c__28266__auto___31136);

return statearr_29314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29319 = arguments.length;
switch (G__29319) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31382 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31382(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31401 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31401(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31407 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31407(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31413 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31413(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31416 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31416(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31420 = arguments.length;
var i__4737__auto___31422 = (0);
while(true){
if((i__4737__auto___31422 < len__4736__auto___31420)){
args__4742__auto__.push((arguments[i__4737__auto___31422]));

var G__31423 = (i__4737__auto___31422 + (1));
i__4737__auto___31422 = G__31423;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29338){
var map__29339 = p__29338;
var map__29339__$1 = (((((!((map__29339 == null))))?(((((map__29339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29339.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29339):map__29339);
var opts = map__29339__$1;
var statearr_29341_31440 = state;
(statearr_29341_31440[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29342_31441 = state;
(statearr_29342_31441[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_29343_31442 = state;
(statearr_29343_31442[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29332){
var G__29333 = cljs.core.first(seq29332);
var seq29332__$1 = cljs.core.next(seq29332);
var G__29334 = cljs.core.first(seq29332__$1);
var seq29332__$2 = cljs.core.next(seq29332__$1);
var G__29335 = cljs.core.first(seq29332__$2);
var seq29332__$3 = cljs.core.next(seq29332__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29333,G__29334,G__29335,seq29332__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29354 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29354 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29355){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29355 = meta29355;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29356,meta29355__$1){
var self__ = this;
var _29356__$1 = this;
return (new cljs.core.async.t_cljs$core$async29354(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29355__$1));
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29356){
var self__ = this;
var _29356__$1 = this;
return self__.meta29355;
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29354.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29354.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29355","meta29355",145953064,null)], null);
}));

(cljs.core.async.t_cljs$core$async29354.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29354.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29354");

(cljs.core.async.t_cljs$core$async29354.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29354");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29354.
 */
cljs.core.async.__GT_t_cljs$core$async29354 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29354(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29355){
return (new cljs.core.async.t_cljs$core$async29354(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29355));
});

}

return (new cljs.core.async.t_cljs$core$async29354(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28266__auto___31461 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29462){
var state_val_29463 = (state_29462[(1)]);
if((state_val_29463 === (7))){
var inst_29376 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
var statearr_29464_31462 = state_29462__$1;
(statearr_29464_31462[(2)] = inst_29376);

(statearr_29464_31462[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (20))){
var inst_29388 = (state_29462[(7)]);
var state_29462__$1 = state_29462;
var statearr_29465_31463 = state_29462__$1;
(statearr_29465_31463[(2)] = inst_29388);

(statearr_29465_31463[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (27))){
var state_29462__$1 = state_29462;
var statearr_29466_31464 = state_29462__$1;
(statearr_29466_31464[(2)] = null);

(statearr_29466_31464[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (1))){
var inst_29363 = (state_29462[(8)]);
var inst_29363__$1 = calc_state();
var inst_29365 = (inst_29363__$1 == null);
var inst_29366 = cljs.core.not(inst_29365);
var state_29462__$1 = (function (){var statearr_29467 = state_29462;
(statearr_29467[(8)] = inst_29363__$1);

return statearr_29467;
})();
if(inst_29366){
var statearr_29468_31468 = state_29462__$1;
(statearr_29468_31468[(1)] = (2));

} else {
var statearr_29469_31470 = state_29462__$1;
(statearr_29469_31470[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (24))){
var inst_29421 = (state_29462[(9)]);
var inst_29435 = (state_29462[(10)]);
var inst_29412 = (state_29462[(11)]);
var inst_29435__$1 = (inst_29412.cljs$core$IFn$_invoke$arity$1 ? inst_29412.cljs$core$IFn$_invoke$arity$1(inst_29421) : inst_29412.call(null,inst_29421));
var state_29462__$1 = (function (){var statearr_29470 = state_29462;
(statearr_29470[(10)] = inst_29435__$1);

return statearr_29470;
})();
if(cljs.core.truth_(inst_29435__$1)){
var statearr_29471_31472 = state_29462__$1;
(statearr_29471_31472[(1)] = (29));

} else {
var statearr_29472_31473 = state_29462__$1;
(statearr_29472_31473[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (4))){
var inst_29379 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29379)){
var statearr_29473_31483 = state_29462__$1;
(statearr_29473_31483[(1)] = (8));

} else {
var statearr_29474_31484 = state_29462__$1;
(statearr_29474_31484[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (15))){
var inst_29406 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29406)){
var statearr_29475_31492 = state_29462__$1;
(statearr_29475_31492[(1)] = (19));

} else {
var statearr_29476_31494 = state_29462__$1;
(statearr_29476_31494[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (21))){
var inst_29411 = (state_29462[(12)]);
var inst_29411__$1 = (state_29462[(2)]);
var inst_29412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29411__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29413 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29411__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29411__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29462__$1 = (function (){var statearr_29477 = state_29462;
(statearr_29477[(13)] = inst_29413);

(statearr_29477[(12)] = inst_29411__$1);

(statearr_29477[(11)] = inst_29412);

return statearr_29477;
})();
return cljs.core.async.ioc_alts_BANG_(state_29462__$1,(22),inst_29414);
} else {
if((state_val_29463 === (31))){
var inst_29443 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29443)){
var statearr_29478_31513 = state_29462__$1;
(statearr_29478_31513[(1)] = (32));

} else {
var statearr_29479_31515 = state_29462__$1;
(statearr_29479_31515[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (32))){
var inst_29420 = (state_29462[(14)]);
var state_29462__$1 = state_29462;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29462__$1,(35),out,inst_29420);
} else {
if((state_val_29463 === (33))){
var inst_29411 = (state_29462[(12)]);
var inst_29388 = inst_29411;
var state_29462__$1 = (function (){var statearr_29480 = state_29462;
(statearr_29480[(7)] = inst_29388);

return statearr_29480;
})();
var statearr_29482_31525 = state_29462__$1;
(statearr_29482_31525[(2)] = null);

(statearr_29482_31525[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (13))){
var inst_29388 = (state_29462[(7)]);
var inst_29395 = inst_29388.cljs$lang$protocol_mask$partition0$;
var inst_29396 = (inst_29395 & (64));
var inst_29397 = inst_29388.cljs$core$ISeq$;
var inst_29398 = (cljs.core.PROTOCOL_SENTINEL === inst_29397);
var inst_29399 = ((inst_29396) || (inst_29398));
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29399)){
var statearr_29484_31532 = state_29462__$1;
(statearr_29484_31532[(1)] = (16));

} else {
var statearr_29485_31533 = state_29462__$1;
(statearr_29485_31533[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (22))){
var inst_29420 = (state_29462[(14)]);
var inst_29421 = (state_29462[(9)]);
var inst_29419 = (state_29462[(2)]);
var inst_29420__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29419,(0),null);
var inst_29421__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29419,(1),null);
var inst_29422 = (inst_29420__$1 == null);
var inst_29423 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29421__$1,change);
var inst_29424 = ((inst_29422) || (inst_29423));
var state_29462__$1 = (function (){var statearr_29489 = state_29462;
(statearr_29489[(14)] = inst_29420__$1);

(statearr_29489[(9)] = inst_29421__$1);

return statearr_29489;
})();
if(cljs.core.truth_(inst_29424)){
var statearr_29490_31546 = state_29462__$1;
(statearr_29490_31546[(1)] = (23));

} else {
var statearr_29493_31547 = state_29462__$1;
(statearr_29493_31547[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (36))){
var inst_29411 = (state_29462[(12)]);
var inst_29388 = inst_29411;
var state_29462__$1 = (function (){var statearr_29494 = state_29462;
(statearr_29494[(7)] = inst_29388);

return statearr_29494;
})();
var statearr_29495_31549 = state_29462__$1;
(statearr_29495_31549[(2)] = null);

(statearr_29495_31549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (29))){
var inst_29435 = (state_29462[(10)]);
var state_29462__$1 = state_29462;
var statearr_29498_31552 = state_29462__$1;
(statearr_29498_31552[(2)] = inst_29435);

(statearr_29498_31552[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (6))){
var state_29462__$1 = state_29462;
var statearr_29499_31553 = state_29462__$1;
(statearr_29499_31553[(2)] = false);

(statearr_29499_31553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (28))){
var inst_29431 = (state_29462[(2)]);
var inst_29432 = calc_state();
var inst_29388 = inst_29432;
var state_29462__$1 = (function (){var statearr_29500 = state_29462;
(statearr_29500[(15)] = inst_29431);

(statearr_29500[(7)] = inst_29388);

return statearr_29500;
})();
var statearr_29502_31554 = state_29462__$1;
(statearr_29502_31554[(2)] = null);

(statearr_29502_31554[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (25))){
var inst_29458 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
var statearr_29503_31556 = state_29462__$1;
(statearr_29503_31556[(2)] = inst_29458);

(statearr_29503_31556[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (34))){
var inst_29456 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
var statearr_29504_31557 = state_29462__$1;
(statearr_29504_31557[(2)] = inst_29456);

(statearr_29504_31557[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (17))){
var state_29462__$1 = state_29462;
var statearr_29505_31558 = state_29462__$1;
(statearr_29505_31558[(2)] = false);

(statearr_29505_31558[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (3))){
var state_29462__$1 = state_29462;
var statearr_29506_31559 = state_29462__$1;
(statearr_29506_31559[(2)] = false);

(statearr_29506_31559[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (12))){
var inst_29460 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29462__$1,inst_29460);
} else {
if((state_val_29463 === (2))){
var inst_29363 = (state_29462[(8)]);
var inst_29368 = inst_29363.cljs$lang$protocol_mask$partition0$;
var inst_29369 = (inst_29368 & (64));
var inst_29370 = inst_29363.cljs$core$ISeq$;
var inst_29371 = (cljs.core.PROTOCOL_SENTINEL === inst_29370);
var inst_29372 = ((inst_29369) || (inst_29371));
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29372)){
var statearr_29507_31561 = state_29462__$1;
(statearr_29507_31561[(1)] = (5));

} else {
var statearr_29508_31562 = state_29462__$1;
(statearr_29508_31562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (23))){
var inst_29420 = (state_29462[(14)]);
var inst_29426 = (inst_29420 == null);
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29426)){
var statearr_29509_31564 = state_29462__$1;
(statearr_29509_31564[(1)] = (26));

} else {
var statearr_29510_31565 = state_29462__$1;
(statearr_29510_31565[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (35))){
var inst_29446 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
if(cljs.core.truth_(inst_29446)){
var statearr_29511_31567 = state_29462__$1;
(statearr_29511_31567[(1)] = (36));

} else {
var statearr_29512_31568 = state_29462__$1;
(statearr_29512_31568[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (19))){
var inst_29388 = (state_29462[(7)]);
var inst_29408 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29388);
var state_29462__$1 = state_29462;
var statearr_29513_31569 = state_29462__$1;
(statearr_29513_31569[(2)] = inst_29408);

(statearr_29513_31569[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (11))){
var inst_29388 = (state_29462[(7)]);
var inst_29392 = (inst_29388 == null);
var inst_29393 = cljs.core.not(inst_29392);
var state_29462__$1 = state_29462;
if(inst_29393){
var statearr_29514_31572 = state_29462__$1;
(statearr_29514_31572[(1)] = (13));

} else {
var statearr_29515_31573 = state_29462__$1;
(statearr_29515_31573[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (9))){
var inst_29363 = (state_29462[(8)]);
var state_29462__$1 = state_29462;
var statearr_29516_31575 = state_29462__$1;
(statearr_29516_31575[(2)] = inst_29363);

(statearr_29516_31575[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (5))){
var state_29462__$1 = state_29462;
var statearr_29517_31577 = state_29462__$1;
(statearr_29517_31577[(2)] = true);

(statearr_29517_31577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (14))){
var state_29462__$1 = state_29462;
var statearr_29518_31579 = state_29462__$1;
(statearr_29518_31579[(2)] = false);

(statearr_29518_31579[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (26))){
var inst_29421 = (state_29462[(9)]);
var inst_29428 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29421);
var state_29462__$1 = state_29462;
var statearr_29519_31582 = state_29462__$1;
(statearr_29519_31582[(2)] = inst_29428);

(statearr_29519_31582[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (16))){
var state_29462__$1 = state_29462;
var statearr_29523_31584 = state_29462__$1;
(statearr_29523_31584[(2)] = true);

(statearr_29523_31584[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (38))){
var inst_29451 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
var statearr_29527_31586 = state_29462__$1;
(statearr_29527_31586[(2)] = inst_29451);

(statearr_29527_31586[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (30))){
var inst_29413 = (state_29462[(13)]);
var inst_29421 = (state_29462[(9)]);
var inst_29412 = (state_29462[(11)]);
var inst_29438 = cljs.core.empty_QMARK_(inst_29412);
var inst_29439 = (inst_29413.cljs$core$IFn$_invoke$arity$1 ? inst_29413.cljs$core$IFn$_invoke$arity$1(inst_29421) : inst_29413.call(null,inst_29421));
var inst_29440 = cljs.core.not(inst_29439);
var inst_29441 = ((inst_29438) && (inst_29440));
var state_29462__$1 = state_29462;
var statearr_29528_31593 = state_29462__$1;
(statearr_29528_31593[(2)] = inst_29441);

(statearr_29528_31593[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (10))){
var inst_29363 = (state_29462[(8)]);
var inst_29384 = (state_29462[(2)]);
var inst_29385 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29384,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29384,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29384,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29388 = inst_29363;
var state_29462__$1 = (function (){var statearr_29529 = state_29462;
(statearr_29529[(16)] = inst_29387);

(statearr_29529[(17)] = inst_29386);

(statearr_29529[(7)] = inst_29388);

(statearr_29529[(18)] = inst_29385);

return statearr_29529;
})();
var statearr_29530_31596 = state_29462__$1;
(statearr_29530_31596[(2)] = null);

(statearr_29530_31596[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (18))){
var inst_29403 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
var statearr_29531_31599 = state_29462__$1;
(statearr_29531_31599[(2)] = inst_29403);

(statearr_29531_31599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (37))){
var state_29462__$1 = state_29462;
var statearr_29532_31600 = state_29462__$1;
(statearr_29532_31600[(2)] = null);

(statearr_29532_31600[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29463 === (8))){
var inst_29363 = (state_29462[(8)]);
var inst_29381 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29363);
var state_29462__$1 = state_29462;
var statearr_29533_31602 = state_29462__$1;
(statearr_29533_31602[(2)] = inst_29381);

(statearr_29533_31602[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28138__auto__ = null;
var cljs$core$async$mix_$_state_machine__28138__auto____0 = (function (){
var statearr_29538 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29538[(0)] = cljs$core$async$mix_$_state_machine__28138__auto__);

(statearr_29538[(1)] = (1));

return statearr_29538;
});
var cljs$core$async$mix_$_state_machine__28138__auto____1 = (function (state_29462){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29462);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29539){if((e29539 instanceof Object)){
var ex__28141__auto__ = e29539;
var statearr_29544_31606 = state_29462;
(statearr_29544_31606[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29462);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29539;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31607 = state_29462;
state_29462 = G__31607;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28138__auto__ = function(state_29462){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28138__auto____1.call(this,state_29462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28138__auto____0;
cljs$core$async$mix_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28138__auto____1;
return cljs$core$async$mix_$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29545 = f__28267__auto__();
(statearr_29545[(6)] = c__28266__auto___31461);

return statearr_29545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_31612 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_31612(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_31617 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_31617(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_31622 = (function() {
var G__31623 = null;
var G__31623__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__31623__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__31623 = function(p,v){
switch(arguments.length){
case 1:
return G__31623__1.call(this,p);
case 2:
return G__31623__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31623.cljs$core$IFn$_invoke$arity$1 = G__31623__1;
G__31623.cljs$core$IFn$_invoke$arity$2 = G__31623__2;
return G__31623;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29569 = arguments.length;
switch (G__29569) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31622(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31622(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29586 = arguments.length;
switch (G__29586) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29581_SHARP_){
if(cljs.core.truth_((p1__29581_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29581_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29581_SHARP_.call(null,topic)))){
return p1__29581_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29581_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29587 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29587 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29588){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29588 = meta29588;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29589,meta29588__$1){
var self__ = this;
var _29589__$1 = this;
return (new cljs.core.async.t_cljs$core$async29587(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29588__$1));
}));

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29589){
var self__ = this;
var _29589__$1 = this;
return self__.meta29588;
}));

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29587.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29587.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29588","meta29588",-1548304728,null)], null);
}));

(cljs.core.async.t_cljs$core$async29587.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29587.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29587");

(cljs.core.async.t_cljs$core$async29587.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29587");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29587.
 */
cljs.core.async.__GT_t_cljs$core$async29587 = (function cljs$core$async$__GT_t_cljs$core$async29587(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29588){
return (new cljs.core.async.t_cljs$core$async29587(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29588));
});

}

return (new cljs.core.async.t_cljs$core$async29587(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28266__auto___31641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29675){
var state_val_29676 = (state_29675[(1)]);
if((state_val_29676 === (7))){
var inst_29671 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29679_31643 = state_29675__$1;
(statearr_29679_31643[(2)] = inst_29671);

(statearr_29679_31643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (20))){
var state_29675__$1 = state_29675;
var statearr_29680_31644 = state_29675__$1;
(statearr_29680_31644[(2)] = null);

(statearr_29680_31644[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (1))){
var state_29675__$1 = state_29675;
var statearr_29681_31645 = state_29675__$1;
(statearr_29681_31645[(2)] = null);

(statearr_29681_31645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (24))){
var inst_29654 = (state_29675[(7)]);
var inst_29663 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29654);
var state_29675__$1 = state_29675;
var statearr_29682_31648 = state_29675__$1;
(statearr_29682_31648[(2)] = inst_29663);

(statearr_29682_31648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (4))){
var inst_29604 = (state_29675[(8)]);
var inst_29604__$1 = (state_29675[(2)]);
var inst_29605 = (inst_29604__$1 == null);
var state_29675__$1 = (function (){var statearr_29683 = state_29675;
(statearr_29683[(8)] = inst_29604__$1);

return statearr_29683;
})();
if(cljs.core.truth_(inst_29605)){
var statearr_29684_31649 = state_29675__$1;
(statearr_29684_31649[(1)] = (5));

} else {
var statearr_29685_31650 = state_29675__$1;
(statearr_29685_31650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (15))){
var inst_29648 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29686_31651 = state_29675__$1;
(statearr_29686_31651[(2)] = inst_29648);

(statearr_29686_31651[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (21))){
var inst_29668 = (state_29675[(2)]);
var state_29675__$1 = (function (){var statearr_29687 = state_29675;
(statearr_29687[(9)] = inst_29668);

return statearr_29687;
})();
var statearr_29688_31652 = state_29675__$1;
(statearr_29688_31652[(2)] = null);

(statearr_29688_31652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (13))){
var inst_29630 = (state_29675[(10)]);
var inst_29632 = cljs.core.chunked_seq_QMARK_(inst_29630);
var state_29675__$1 = state_29675;
if(inst_29632){
var statearr_29689_31653 = state_29675__$1;
(statearr_29689_31653[(1)] = (16));

} else {
var statearr_29690_31654 = state_29675__$1;
(statearr_29690_31654[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (22))){
var inst_29660 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
if(cljs.core.truth_(inst_29660)){
var statearr_29692_31655 = state_29675__$1;
(statearr_29692_31655[(1)] = (23));

} else {
var statearr_29693_31656 = state_29675__$1;
(statearr_29693_31656[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (6))){
var inst_29656 = (state_29675[(11)]);
var inst_29604 = (state_29675[(8)]);
var inst_29654 = (state_29675[(7)]);
var inst_29654__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29604) : topic_fn.call(null,inst_29604));
var inst_29655 = cljs.core.deref(mults);
var inst_29656__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29655,inst_29654__$1);
var state_29675__$1 = (function (){var statearr_29694 = state_29675;
(statearr_29694[(11)] = inst_29656__$1);

(statearr_29694[(7)] = inst_29654__$1);

return statearr_29694;
})();
if(cljs.core.truth_(inst_29656__$1)){
var statearr_29695_31657 = state_29675__$1;
(statearr_29695_31657[(1)] = (19));

} else {
var statearr_29696_31658 = state_29675__$1;
(statearr_29696_31658[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (25))){
var inst_29665 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29697_31659 = state_29675__$1;
(statearr_29697_31659[(2)] = inst_29665);

(statearr_29697_31659[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (17))){
var inst_29630 = (state_29675[(10)]);
var inst_29639 = cljs.core.first(inst_29630);
var inst_29640 = cljs.core.async.muxch_STAR_(inst_29639);
var inst_29641 = cljs.core.async.close_BANG_(inst_29640);
var inst_29642 = cljs.core.next(inst_29630);
var inst_29614 = inst_29642;
var inst_29615 = null;
var inst_29616 = (0);
var inst_29617 = (0);
var state_29675__$1 = (function (){var statearr_29698 = state_29675;
(statearr_29698[(12)] = inst_29615);

(statearr_29698[(13)] = inst_29614);

(statearr_29698[(14)] = inst_29617);

(statearr_29698[(15)] = inst_29641);

(statearr_29698[(16)] = inst_29616);

return statearr_29698;
})();
var statearr_29699_31660 = state_29675__$1;
(statearr_29699_31660[(2)] = null);

(statearr_29699_31660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (3))){
var inst_29673 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29675__$1,inst_29673);
} else {
if((state_val_29676 === (12))){
var inst_29650 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29700_31661 = state_29675__$1;
(statearr_29700_31661[(2)] = inst_29650);

(statearr_29700_31661[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (2))){
var state_29675__$1 = state_29675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29675__$1,(4),ch);
} else {
if((state_val_29676 === (23))){
var state_29675__$1 = state_29675;
var statearr_29705_31662 = state_29675__$1;
(statearr_29705_31662[(2)] = null);

(statearr_29705_31662[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (19))){
var inst_29656 = (state_29675[(11)]);
var inst_29604 = (state_29675[(8)]);
var inst_29658 = cljs.core.async.muxch_STAR_(inst_29656);
var state_29675__$1 = state_29675;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29675__$1,(22),inst_29658,inst_29604);
} else {
if((state_val_29676 === (11))){
var inst_29614 = (state_29675[(13)]);
var inst_29630 = (state_29675[(10)]);
var inst_29630__$1 = cljs.core.seq(inst_29614);
var state_29675__$1 = (function (){var statearr_29709 = state_29675;
(statearr_29709[(10)] = inst_29630__$1);

return statearr_29709;
})();
if(inst_29630__$1){
var statearr_29710_31663 = state_29675__$1;
(statearr_29710_31663[(1)] = (13));

} else {
var statearr_29711_31664 = state_29675__$1;
(statearr_29711_31664[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (9))){
var inst_29652 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29712_31665 = state_29675__$1;
(statearr_29712_31665[(2)] = inst_29652);

(statearr_29712_31665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (5))){
var inst_29611 = cljs.core.deref(mults);
var inst_29612 = cljs.core.vals(inst_29611);
var inst_29613 = cljs.core.seq(inst_29612);
var inst_29614 = inst_29613;
var inst_29615 = null;
var inst_29616 = (0);
var inst_29617 = (0);
var state_29675__$1 = (function (){var statearr_29713 = state_29675;
(statearr_29713[(12)] = inst_29615);

(statearr_29713[(13)] = inst_29614);

(statearr_29713[(14)] = inst_29617);

(statearr_29713[(16)] = inst_29616);

return statearr_29713;
})();
var statearr_29714_31666 = state_29675__$1;
(statearr_29714_31666[(2)] = null);

(statearr_29714_31666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (14))){
var state_29675__$1 = state_29675;
var statearr_29718_31667 = state_29675__$1;
(statearr_29718_31667[(2)] = null);

(statearr_29718_31667[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (16))){
var inst_29630 = (state_29675[(10)]);
var inst_29634 = cljs.core.chunk_first(inst_29630);
var inst_29635 = cljs.core.chunk_rest(inst_29630);
var inst_29636 = cljs.core.count(inst_29634);
var inst_29614 = inst_29635;
var inst_29615 = inst_29634;
var inst_29616 = inst_29636;
var inst_29617 = (0);
var state_29675__$1 = (function (){var statearr_29719 = state_29675;
(statearr_29719[(12)] = inst_29615);

(statearr_29719[(13)] = inst_29614);

(statearr_29719[(14)] = inst_29617);

(statearr_29719[(16)] = inst_29616);

return statearr_29719;
})();
var statearr_29720_31668 = state_29675__$1;
(statearr_29720_31668[(2)] = null);

(statearr_29720_31668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (10))){
var inst_29615 = (state_29675[(12)]);
var inst_29614 = (state_29675[(13)]);
var inst_29617 = (state_29675[(14)]);
var inst_29616 = (state_29675[(16)]);
var inst_29622 = cljs.core._nth(inst_29615,inst_29617);
var inst_29625 = cljs.core.async.muxch_STAR_(inst_29622);
var inst_29626 = cljs.core.async.close_BANG_(inst_29625);
var inst_29627 = (inst_29617 + (1));
var tmp29715 = inst_29615;
var tmp29716 = inst_29614;
var tmp29717 = inst_29616;
var inst_29614__$1 = tmp29716;
var inst_29615__$1 = tmp29715;
var inst_29616__$1 = tmp29717;
var inst_29617__$1 = inst_29627;
var state_29675__$1 = (function (){var statearr_29721 = state_29675;
(statearr_29721[(12)] = inst_29615__$1);

(statearr_29721[(13)] = inst_29614__$1);

(statearr_29721[(14)] = inst_29617__$1);

(statearr_29721[(16)] = inst_29616__$1);

(statearr_29721[(17)] = inst_29626);

return statearr_29721;
})();
var statearr_29722_31669 = state_29675__$1;
(statearr_29722_31669[(2)] = null);

(statearr_29722_31669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (18))){
var inst_29645 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29723_31670 = state_29675__$1;
(statearr_29723_31670[(2)] = inst_29645);

(statearr_29723_31670[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29676 === (8))){
var inst_29617 = (state_29675[(14)]);
var inst_29616 = (state_29675[(16)]);
var inst_29619 = (inst_29617 < inst_29616);
var inst_29620 = inst_29619;
var state_29675__$1 = state_29675;
if(cljs.core.truth_(inst_29620)){
var statearr_29724_31671 = state_29675__$1;
(statearr_29724_31671[(1)] = (10));

} else {
var statearr_29725_31672 = state_29675__$1;
(statearr_29725_31672[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29726 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29726[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29726[(1)] = (1));

return statearr_29726;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29675){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29675);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29727){if((e29727 instanceof Object)){
var ex__28141__auto__ = e29727;
var statearr_29728_31673 = state_29675;
(statearr_29728_31673[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29675);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29727;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31674 = state_29675;
state_29675 = G__31674;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29675){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29729 = f__28267__auto__();
(statearr_29729[(6)] = c__28266__auto___31641);

return statearr_29729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29731 = arguments.length;
switch (G__29731) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29735 = arguments.length;
switch (G__29735) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29738 = arguments.length;
switch (G__29738) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28266__auto___31678 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29778){
var state_val_29779 = (state_29778[(1)]);
if((state_val_29779 === (7))){
var state_29778__$1 = state_29778;
var statearr_29784_31679 = state_29778__$1;
(statearr_29784_31679[(2)] = null);

(statearr_29784_31679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (1))){
var state_29778__$1 = state_29778;
var statearr_29785_31680 = state_29778__$1;
(statearr_29785_31680[(2)] = null);

(statearr_29785_31680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (4))){
var inst_29741 = (state_29778[(7)]);
var inst_29743 = (inst_29741 < cnt);
var state_29778__$1 = state_29778;
if(cljs.core.truth_(inst_29743)){
var statearr_29786_31681 = state_29778__$1;
(statearr_29786_31681[(1)] = (6));

} else {
var statearr_29791_31682 = state_29778__$1;
(statearr_29791_31682[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (15))){
var inst_29774 = (state_29778[(2)]);
var state_29778__$1 = state_29778;
var statearr_29792_31683 = state_29778__$1;
(statearr_29792_31683[(2)] = inst_29774);

(statearr_29792_31683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (13))){
var inst_29767 = cljs.core.async.close_BANG_(out);
var state_29778__$1 = state_29778;
var statearr_29793_31684 = state_29778__$1;
(statearr_29793_31684[(2)] = inst_29767);

(statearr_29793_31684[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (6))){
var state_29778__$1 = state_29778;
var statearr_29794_31685 = state_29778__$1;
(statearr_29794_31685[(2)] = null);

(statearr_29794_31685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (3))){
var inst_29776 = (state_29778[(2)]);
var state_29778__$1 = state_29778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29778__$1,inst_29776);
} else {
if((state_val_29779 === (12))){
var inst_29764 = (state_29778[(8)]);
var inst_29764__$1 = (state_29778[(2)]);
var inst_29765 = cljs.core.some(cljs.core.nil_QMARK_,inst_29764__$1);
var state_29778__$1 = (function (){var statearr_29802 = state_29778;
(statearr_29802[(8)] = inst_29764__$1);

return statearr_29802;
})();
if(cljs.core.truth_(inst_29765)){
var statearr_29803_31686 = state_29778__$1;
(statearr_29803_31686[(1)] = (13));

} else {
var statearr_29805_31687 = state_29778__$1;
(statearr_29805_31687[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (2))){
var inst_29740 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29741 = (0);
var state_29778__$1 = (function (){var statearr_29808 = state_29778;
(statearr_29808[(7)] = inst_29741);

(statearr_29808[(9)] = inst_29740);

return statearr_29808;
})();
var statearr_29809_31688 = state_29778__$1;
(statearr_29809_31688[(2)] = null);

(statearr_29809_31688[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (11))){
var inst_29741 = (state_29778[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_29778,(10),Object,null,(9));
var inst_29750 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29741) : chs__$1.call(null,inst_29741));
var inst_29751 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29741) : done.call(null,inst_29741));
var inst_29752 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29750,inst_29751);
var state_29778__$1 = state_29778;
var statearr_29810_31689 = state_29778__$1;
(statearr_29810_31689[(2)] = inst_29752);


cljs.core.async.impl.ioc_helpers.process_exception(state_29778__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (9))){
var inst_29741 = (state_29778[(7)]);
var inst_29755 = (state_29778[(2)]);
var inst_29756 = (inst_29741 + (1));
var inst_29741__$1 = inst_29756;
var state_29778__$1 = (function (){var statearr_29811 = state_29778;
(statearr_29811[(7)] = inst_29741__$1);

(statearr_29811[(10)] = inst_29755);

return statearr_29811;
})();
var statearr_29812_31690 = state_29778__$1;
(statearr_29812_31690[(2)] = null);

(statearr_29812_31690[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (5))){
var inst_29762 = (state_29778[(2)]);
var state_29778__$1 = (function (){var statearr_29813 = state_29778;
(statearr_29813[(11)] = inst_29762);

return statearr_29813;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29778__$1,(12),dchan);
} else {
if((state_val_29779 === (14))){
var inst_29764 = (state_29778[(8)]);
var inst_29769 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29764);
var state_29778__$1 = state_29778;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29778__$1,(16),out,inst_29769);
} else {
if((state_val_29779 === (16))){
var inst_29771 = (state_29778[(2)]);
var state_29778__$1 = (function (){var statearr_29818 = state_29778;
(statearr_29818[(12)] = inst_29771);

return statearr_29818;
})();
var statearr_29819_31691 = state_29778__$1;
(statearr_29819_31691[(2)] = null);

(statearr_29819_31691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (10))){
var inst_29745 = (state_29778[(2)]);
var inst_29746 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29778__$1 = (function (){var statearr_29820 = state_29778;
(statearr_29820[(13)] = inst_29745);

return statearr_29820;
})();
var statearr_29821_31692 = state_29778__$1;
(statearr_29821_31692[(2)] = inst_29746);


cljs.core.async.impl.ioc_helpers.process_exception(state_29778__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29779 === (8))){
var inst_29760 = (state_29778[(2)]);
var state_29778__$1 = state_29778;
var statearr_29822_31693 = state_29778__$1;
(statearr_29822_31693[(2)] = inst_29760);

(statearr_29822_31693[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29824 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29824[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29824[(1)] = (1));

return statearr_29824;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29778){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29778);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29825){if((e29825 instanceof Object)){
var ex__28141__auto__ = e29825;
var statearr_29826_31694 = state_29778;
(statearr_29826_31694[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29825;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31695 = state_29778;
state_29778 = G__31695;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29831 = f__28267__auto__();
(statearr_29831[(6)] = c__28266__auto___31678);

return statearr_29831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29839 = arguments.length;
switch (G__29839) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28266__auto___31697 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29873){
var state_val_29874 = (state_29873[(1)]);
if((state_val_29874 === (7))){
var inst_29852 = (state_29873[(7)]);
var inst_29853 = (state_29873[(8)]);
var inst_29852__$1 = (state_29873[(2)]);
var inst_29853__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29852__$1,(0),null);
var inst_29854 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29852__$1,(1),null);
var inst_29855 = (inst_29853__$1 == null);
var state_29873__$1 = (function (){var statearr_29880 = state_29873;
(statearr_29880[(9)] = inst_29854);

(statearr_29880[(7)] = inst_29852__$1);

(statearr_29880[(8)] = inst_29853__$1);

return statearr_29880;
})();
if(cljs.core.truth_(inst_29855)){
var statearr_29882_31698 = state_29873__$1;
(statearr_29882_31698[(1)] = (8));

} else {
var statearr_29883_31699 = state_29873__$1;
(statearr_29883_31699[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (1))){
var inst_29842 = cljs.core.vec(chs);
var inst_29843 = inst_29842;
var state_29873__$1 = (function (){var statearr_29884 = state_29873;
(statearr_29884[(10)] = inst_29843);

return statearr_29884;
})();
var statearr_29885_31700 = state_29873__$1;
(statearr_29885_31700[(2)] = null);

(statearr_29885_31700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (4))){
var inst_29843 = (state_29873[(10)]);
var state_29873__$1 = state_29873;
return cljs.core.async.ioc_alts_BANG_(state_29873__$1,(7),inst_29843);
} else {
if((state_val_29874 === (6))){
var inst_29869 = (state_29873[(2)]);
var state_29873__$1 = state_29873;
var statearr_29889_31701 = state_29873__$1;
(statearr_29889_31701[(2)] = inst_29869);

(statearr_29889_31701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (3))){
var inst_29871 = (state_29873[(2)]);
var state_29873__$1 = state_29873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29873__$1,inst_29871);
} else {
if((state_val_29874 === (2))){
var inst_29843 = (state_29873[(10)]);
var inst_29845 = cljs.core.count(inst_29843);
var inst_29846 = (inst_29845 > (0));
var state_29873__$1 = state_29873;
if(cljs.core.truth_(inst_29846)){
var statearr_29896_31702 = state_29873__$1;
(statearr_29896_31702[(1)] = (4));

} else {
var statearr_29897_31703 = state_29873__$1;
(statearr_29897_31703[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (11))){
var inst_29843 = (state_29873[(10)]);
var inst_29862 = (state_29873[(2)]);
var tmp29892 = inst_29843;
var inst_29843__$1 = tmp29892;
var state_29873__$1 = (function (){var statearr_29902 = state_29873;
(statearr_29902[(11)] = inst_29862);

(statearr_29902[(10)] = inst_29843__$1);

return statearr_29902;
})();
var statearr_29903_31704 = state_29873__$1;
(statearr_29903_31704[(2)] = null);

(statearr_29903_31704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (9))){
var inst_29853 = (state_29873[(8)]);
var state_29873__$1 = state_29873;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29873__$1,(11),out,inst_29853);
} else {
if((state_val_29874 === (5))){
var inst_29867 = cljs.core.async.close_BANG_(out);
var state_29873__$1 = state_29873;
var statearr_29906_31705 = state_29873__$1;
(statearr_29906_31705[(2)] = inst_29867);

(statearr_29906_31705[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (10))){
var inst_29865 = (state_29873[(2)]);
var state_29873__$1 = state_29873;
var statearr_29907_31706 = state_29873__$1;
(statearr_29907_31706[(2)] = inst_29865);

(statearr_29907_31706[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29874 === (8))){
var inst_29854 = (state_29873[(9)]);
var inst_29843 = (state_29873[(10)]);
var inst_29852 = (state_29873[(7)]);
var inst_29853 = (state_29873[(8)]);
var inst_29857 = (function (){var cs = inst_29843;
var vec__29848 = inst_29852;
var v = inst_29853;
var c = inst_29854;
return (function (p1__29837_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29837_SHARP_);
});
})();
var inst_29858 = cljs.core.filterv(inst_29857,inst_29843);
var inst_29843__$1 = inst_29858;
var state_29873__$1 = (function (){var statearr_29912 = state_29873;
(statearr_29912[(10)] = inst_29843__$1);

return statearr_29912;
})();
var statearr_29913_31707 = state_29873__$1;
(statearr_29913_31707[(2)] = null);

(statearr_29913_31707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29918 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29918[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29918[(1)] = (1));

return statearr_29918;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29873){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29873);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29919){if((e29919 instanceof Object)){
var ex__28141__auto__ = e29919;
var statearr_29920_31708 = state_29873;
(statearr_29920_31708[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29919;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31709 = state_29873;
state_29873 = G__31709;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29873){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29921 = f__28267__auto__();
(statearr_29921[(6)] = c__28266__auto___31697);

return statearr_29921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__29925 = arguments.length;
switch (G__29925) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28266__auto___31711 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_29950){
var state_val_29951 = (state_29950[(1)]);
if((state_val_29951 === (7))){
var inst_29932 = (state_29950[(7)]);
var inst_29932__$1 = (state_29950[(2)]);
var inst_29933 = (inst_29932__$1 == null);
var inst_29934 = cljs.core.not(inst_29933);
var state_29950__$1 = (function (){var statearr_29954 = state_29950;
(statearr_29954[(7)] = inst_29932__$1);

return statearr_29954;
})();
if(inst_29934){
var statearr_29956_31712 = state_29950__$1;
(statearr_29956_31712[(1)] = (8));

} else {
var statearr_29957_31713 = state_29950__$1;
(statearr_29957_31713[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (1))){
var inst_29927 = (0);
var state_29950__$1 = (function (){var statearr_29958 = state_29950;
(statearr_29958[(8)] = inst_29927);

return statearr_29958;
})();
var statearr_29960_31714 = state_29950__$1;
(statearr_29960_31714[(2)] = null);

(statearr_29960_31714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (4))){
var state_29950__$1 = state_29950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29950__$1,(7),ch);
} else {
if((state_val_29951 === (6))){
var inst_29945 = (state_29950[(2)]);
var state_29950__$1 = state_29950;
var statearr_29962_31715 = state_29950__$1;
(statearr_29962_31715[(2)] = inst_29945);

(statearr_29962_31715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (3))){
var inst_29947 = (state_29950[(2)]);
var inst_29948 = cljs.core.async.close_BANG_(out);
var state_29950__$1 = (function (){var statearr_29963 = state_29950;
(statearr_29963[(9)] = inst_29947);

return statearr_29963;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29950__$1,inst_29948);
} else {
if((state_val_29951 === (2))){
var inst_29927 = (state_29950[(8)]);
var inst_29929 = (inst_29927 < n);
var state_29950__$1 = state_29950;
if(cljs.core.truth_(inst_29929)){
var statearr_29970_31716 = state_29950__$1;
(statearr_29970_31716[(1)] = (4));

} else {
var statearr_29971_31717 = state_29950__$1;
(statearr_29971_31717[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (11))){
var inst_29927 = (state_29950[(8)]);
var inst_29937 = (state_29950[(2)]);
var inst_29938 = (inst_29927 + (1));
var inst_29927__$1 = inst_29938;
var state_29950__$1 = (function (){var statearr_29972 = state_29950;
(statearr_29972[(8)] = inst_29927__$1);

(statearr_29972[(10)] = inst_29937);

return statearr_29972;
})();
var statearr_29973_31718 = state_29950__$1;
(statearr_29973_31718[(2)] = null);

(statearr_29973_31718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (9))){
var state_29950__$1 = state_29950;
var statearr_29974_31719 = state_29950__$1;
(statearr_29974_31719[(2)] = null);

(statearr_29974_31719[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (5))){
var state_29950__$1 = state_29950;
var statearr_29975_31720 = state_29950__$1;
(statearr_29975_31720[(2)] = null);

(statearr_29975_31720[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (10))){
var inst_29942 = (state_29950[(2)]);
var state_29950__$1 = state_29950;
var statearr_29976_31721 = state_29950__$1;
(statearr_29976_31721[(2)] = inst_29942);

(statearr_29976_31721[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29951 === (8))){
var inst_29932 = (state_29950[(7)]);
var state_29950__$1 = state_29950;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29950__$1,(11),out,inst_29932);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29978 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29978[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29978[(1)] = (1));

return statearr_29978;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29950){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29950);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29980){if((e29980 instanceof Object)){
var ex__28141__auto__ = e29980;
var statearr_29981_31722 = state_29950;
(statearr_29981_31722[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29950);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29980;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31723 = state_29950;
state_29950 = G__31723;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29950){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_29982 = f__28267__auto__();
(statearr_29982[(6)] = c__28266__auto___31711);

return statearr_29982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29985 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29985 = (function (f,ch,meta29986){
this.f = f;
this.ch = ch;
this.meta29986 = meta29986;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29987,meta29986__$1){
var self__ = this;
var _29987__$1 = this;
return (new cljs.core.async.t_cljs$core$async29985(self__.f,self__.ch,meta29986__$1));
}));

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29987){
var self__ = this;
var _29987__$1 = this;
return self__.meta29986;
}));

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29991 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29991 = (function (f,ch,meta29986,_,fn1,meta29992){
this.f = f;
this.ch = ch;
this.meta29986 = meta29986;
this._ = _;
this.fn1 = fn1;
this.meta29992 = meta29992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29993,meta29992__$1){
var self__ = this;
var _29993__$1 = this;
return (new cljs.core.async.t_cljs$core$async29991(self__.f,self__.ch,self__.meta29986,self__._,self__.fn1,meta29992__$1));
}));

(cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29993){
var self__ = this;
var _29993__$1 = this;
return self__.meta29992;
}));

(cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__29984_SHARP_){
var G__29994 = (((p1__29984_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__29984_SHARP_) : self__.f.call(null,p1__29984_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__29994) : f1.call(null,G__29994));
});
}));

(cljs.core.async.t_cljs$core$async29991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29986","meta29986",-956304759,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async29985","cljs.core.async/t_cljs$core$async29985",155405060,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta29992","meta29992",436769723,null)], null);
}));

(cljs.core.async.t_cljs$core$async29991.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29991.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29991");

(cljs.core.async.t_cljs$core$async29991.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29991");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29991.
 */
cljs.core.async.__GT_t_cljs$core$async29991 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29991(f__$1,ch__$1,meta29986__$1,___$2,fn1__$1,meta29992){
return (new cljs.core.async.t_cljs$core$async29991(f__$1,ch__$1,meta29986__$1,___$2,fn1__$1,meta29992));
});

}

return (new cljs.core.async.t_cljs$core$async29991(self__.f,self__.ch,self__.meta29986,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__29998 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__29998) : self__.f.call(null,G__29998));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29985.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async29985.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29986","meta29986",-956304759,null)], null);
}));

(cljs.core.async.t_cljs$core$async29985.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29985.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29985");

(cljs.core.async.t_cljs$core$async29985.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29985");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29985.
 */
cljs.core.async.__GT_t_cljs$core$async29985 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29985(f__$1,ch__$1,meta29986){
return (new cljs.core.async.t_cljs$core$async29985(f__$1,ch__$1,meta29986));
});

}

return (new cljs.core.async.t_cljs$core$async29985(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30000 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30000 = (function (f,ch,meta30001){
this.f = f;
this.ch = ch;
this.meta30001 = meta30001;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30002,meta30001__$1){
var self__ = this;
var _30002__$1 = this;
return (new cljs.core.async.t_cljs$core$async30000(self__.f,self__.ch,meta30001__$1));
}));

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30002){
var self__ = this;
var _30002__$1 = this;
return self__.meta30001;
}));

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30000.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30000.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30001","meta30001",1287873564,null)], null);
}));

(cljs.core.async.t_cljs$core$async30000.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30000.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30000");

(cljs.core.async.t_cljs$core$async30000.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30000");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30000.
 */
cljs.core.async.__GT_t_cljs$core$async30000 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30000(f__$1,ch__$1,meta30001){
return (new cljs.core.async.t_cljs$core$async30000(f__$1,ch__$1,meta30001));
});

}

return (new cljs.core.async.t_cljs$core$async30000(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30012 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30012 = (function (p,ch,meta30013){
this.p = p;
this.ch = ch;
this.meta30013 = meta30013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30014,meta30013__$1){
var self__ = this;
var _30014__$1 = this;
return (new cljs.core.async.t_cljs$core$async30012(self__.p,self__.ch,meta30013__$1));
}));

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30014){
var self__ = this;
var _30014__$1 = this;
return self__.meta30013;
}));

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30012.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30012.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30013","meta30013",-337525667,null)], null);
}));

(cljs.core.async.t_cljs$core$async30012.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30012.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30012");

(cljs.core.async.t_cljs$core$async30012.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30012");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30012.
 */
cljs.core.async.__GT_t_cljs$core$async30012 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30012(p__$1,ch__$1,meta30013){
return (new cljs.core.async.t_cljs$core$async30012(p__$1,ch__$1,meta30013));
});

}

return (new cljs.core.async.t_cljs$core$async30012(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30030 = arguments.length;
switch (G__30030) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28266__auto___31725 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_30051){
var state_val_30052 = (state_30051[(1)]);
if((state_val_30052 === (7))){
var inst_30047 = (state_30051[(2)]);
var state_30051__$1 = state_30051;
var statearr_30053_31726 = state_30051__$1;
(statearr_30053_31726[(2)] = inst_30047);

(statearr_30053_31726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (1))){
var state_30051__$1 = state_30051;
var statearr_30054_31727 = state_30051__$1;
(statearr_30054_31727[(2)] = null);

(statearr_30054_31727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (4))){
var inst_30033 = (state_30051[(7)]);
var inst_30033__$1 = (state_30051[(2)]);
var inst_30034 = (inst_30033__$1 == null);
var state_30051__$1 = (function (){var statearr_30055 = state_30051;
(statearr_30055[(7)] = inst_30033__$1);

return statearr_30055;
})();
if(cljs.core.truth_(inst_30034)){
var statearr_30058_31728 = state_30051__$1;
(statearr_30058_31728[(1)] = (5));

} else {
var statearr_30060_31729 = state_30051__$1;
(statearr_30060_31729[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (6))){
var inst_30033 = (state_30051[(7)]);
var inst_30038 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30033) : p.call(null,inst_30033));
var state_30051__$1 = state_30051;
if(cljs.core.truth_(inst_30038)){
var statearr_30061_31730 = state_30051__$1;
(statearr_30061_31730[(1)] = (8));

} else {
var statearr_30062_31731 = state_30051__$1;
(statearr_30062_31731[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (3))){
var inst_30049 = (state_30051[(2)]);
var state_30051__$1 = state_30051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30051__$1,inst_30049);
} else {
if((state_val_30052 === (2))){
var state_30051__$1 = state_30051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30051__$1,(4),ch);
} else {
if((state_val_30052 === (11))){
var inst_30041 = (state_30051[(2)]);
var state_30051__$1 = state_30051;
var statearr_30069_31732 = state_30051__$1;
(statearr_30069_31732[(2)] = inst_30041);

(statearr_30069_31732[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (9))){
var state_30051__$1 = state_30051;
var statearr_30070_31733 = state_30051__$1;
(statearr_30070_31733[(2)] = null);

(statearr_30070_31733[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (5))){
var inst_30036 = cljs.core.async.close_BANG_(out);
var state_30051__$1 = state_30051;
var statearr_30074_31734 = state_30051__$1;
(statearr_30074_31734[(2)] = inst_30036);

(statearr_30074_31734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (10))){
var inst_30044 = (state_30051[(2)]);
var state_30051__$1 = (function (){var statearr_30077 = state_30051;
(statearr_30077[(8)] = inst_30044);

return statearr_30077;
})();
var statearr_30078_31735 = state_30051__$1;
(statearr_30078_31735[(2)] = null);

(statearr_30078_31735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30052 === (8))){
var inst_30033 = (state_30051[(7)]);
var state_30051__$1 = state_30051;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30051__$1,(11),out,inst_30033);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30081 = [null,null,null,null,null,null,null,null,null];
(statearr_30081[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30081[(1)] = (1));

return statearr_30081;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30051){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30051);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30082){if((e30082 instanceof Object)){
var ex__28141__auto__ = e30082;
var statearr_30083_31736 = state_30051;
(statearr_30083_31736[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30082;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31737 = state_30051;
state_30051 = G__31737;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30051){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_30084 = f__28267__auto__();
(statearr_30084[(6)] = c__28266__auto___31725);

return statearr_30084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30090 = arguments.length;
switch (G__30090) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28266__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_30156){
var state_val_30157 = (state_30156[(1)]);
if((state_val_30157 === (7))){
var inst_30150 = (state_30156[(2)]);
var state_30156__$1 = state_30156;
var statearr_30163_31739 = state_30156__$1;
(statearr_30163_31739[(2)] = inst_30150);

(statearr_30163_31739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (20))){
var inst_30119 = (state_30156[(7)]);
var inst_30131 = (state_30156[(2)]);
var inst_30132 = cljs.core.next(inst_30119);
var inst_30105 = inst_30132;
var inst_30106 = null;
var inst_30107 = (0);
var inst_30108 = (0);
var state_30156__$1 = (function (){var statearr_30165 = state_30156;
(statearr_30165[(8)] = inst_30105);

(statearr_30165[(9)] = inst_30108);

(statearr_30165[(10)] = inst_30131);

(statearr_30165[(11)] = inst_30107);

(statearr_30165[(12)] = inst_30106);

return statearr_30165;
})();
var statearr_30168_31740 = state_30156__$1;
(statearr_30168_31740[(2)] = null);

(statearr_30168_31740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (1))){
var state_30156__$1 = state_30156;
var statearr_30170_31741 = state_30156__$1;
(statearr_30170_31741[(2)] = null);

(statearr_30170_31741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (4))){
var inst_30093 = (state_30156[(13)]);
var inst_30093__$1 = (state_30156[(2)]);
var inst_30095 = (inst_30093__$1 == null);
var state_30156__$1 = (function (){var statearr_30173 = state_30156;
(statearr_30173[(13)] = inst_30093__$1);

return statearr_30173;
})();
if(cljs.core.truth_(inst_30095)){
var statearr_30174_31742 = state_30156__$1;
(statearr_30174_31742[(1)] = (5));

} else {
var statearr_30175_31743 = state_30156__$1;
(statearr_30175_31743[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (15))){
var state_30156__$1 = state_30156;
var statearr_30179_31744 = state_30156__$1;
(statearr_30179_31744[(2)] = null);

(statearr_30179_31744[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (21))){
var state_30156__$1 = state_30156;
var statearr_30180_31745 = state_30156__$1;
(statearr_30180_31745[(2)] = null);

(statearr_30180_31745[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (13))){
var inst_30105 = (state_30156[(8)]);
var inst_30108 = (state_30156[(9)]);
var inst_30107 = (state_30156[(11)]);
var inst_30106 = (state_30156[(12)]);
var inst_30115 = (state_30156[(2)]);
var inst_30116 = (inst_30108 + (1));
var tmp30176 = inst_30105;
var tmp30177 = inst_30107;
var tmp30178 = inst_30106;
var inst_30105__$1 = tmp30176;
var inst_30106__$1 = tmp30178;
var inst_30107__$1 = tmp30177;
var inst_30108__$1 = inst_30116;
var state_30156__$1 = (function (){var statearr_30181 = state_30156;
(statearr_30181[(8)] = inst_30105__$1);

(statearr_30181[(9)] = inst_30108__$1);

(statearr_30181[(14)] = inst_30115);

(statearr_30181[(11)] = inst_30107__$1);

(statearr_30181[(12)] = inst_30106__$1);

return statearr_30181;
})();
var statearr_30182_31746 = state_30156__$1;
(statearr_30182_31746[(2)] = null);

(statearr_30182_31746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (22))){
var state_30156__$1 = state_30156;
var statearr_30183_31747 = state_30156__$1;
(statearr_30183_31747[(2)] = null);

(statearr_30183_31747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (6))){
var inst_30093 = (state_30156[(13)]);
var inst_30103 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30093) : f.call(null,inst_30093));
var inst_30104 = cljs.core.seq(inst_30103);
var inst_30105 = inst_30104;
var inst_30106 = null;
var inst_30107 = (0);
var inst_30108 = (0);
var state_30156__$1 = (function (){var statearr_30184 = state_30156;
(statearr_30184[(8)] = inst_30105);

(statearr_30184[(9)] = inst_30108);

(statearr_30184[(11)] = inst_30107);

(statearr_30184[(12)] = inst_30106);

return statearr_30184;
})();
var statearr_30185_31748 = state_30156__$1;
(statearr_30185_31748[(2)] = null);

(statearr_30185_31748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (17))){
var inst_30119 = (state_30156[(7)]);
var inst_30123 = cljs.core.chunk_first(inst_30119);
var inst_30124 = cljs.core.chunk_rest(inst_30119);
var inst_30126 = cljs.core.count(inst_30123);
var inst_30105 = inst_30124;
var inst_30106 = inst_30123;
var inst_30107 = inst_30126;
var inst_30108 = (0);
var state_30156__$1 = (function (){var statearr_30186 = state_30156;
(statearr_30186[(8)] = inst_30105);

(statearr_30186[(9)] = inst_30108);

(statearr_30186[(11)] = inst_30107);

(statearr_30186[(12)] = inst_30106);

return statearr_30186;
})();
var statearr_30187_31749 = state_30156__$1;
(statearr_30187_31749[(2)] = null);

(statearr_30187_31749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (3))){
var inst_30152 = (state_30156[(2)]);
var state_30156__$1 = state_30156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30156__$1,inst_30152);
} else {
if((state_val_30157 === (12))){
var inst_30140 = (state_30156[(2)]);
var state_30156__$1 = state_30156;
var statearr_30188_31750 = state_30156__$1;
(statearr_30188_31750[(2)] = inst_30140);

(statearr_30188_31750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (2))){
var state_30156__$1 = state_30156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30156__$1,(4),in$);
} else {
if((state_val_30157 === (23))){
var inst_30148 = (state_30156[(2)]);
var state_30156__$1 = state_30156;
var statearr_30189_31751 = state_30156__$1;
(statearr_30189_31751[(2)] = inst_30148);

(statearr_30189_31751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (19))){
var inst_30135 = (state_30156[(2)]);
var state_30156__$1 = state_30156;
var statearr_30190_31752 = state_30156__$1;
(statearr_30190_31752[(2)] = inst_30135);

(statearr_30190_31752[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (11))){
var inst_30105 = (state_30156[(8)]);
var inst_30119 = (state_30156[(7)]);
var inst_30119__$1 = cljs.core.seq(inst_30105);
var state_30156__$1 = (function (){var statearr_30191 = state_30156;
(statearr_30191[(7)] = inst_30119__$1);

return statearr_30191;
})();
if(inst_30119__$1){
var statearr_30192_31753 = state_30156__$1;
(statearr_30192_31753[(1)] = (14));

} else {
var statearr_30193_31754 = state_30156__$1;
(statearr_30193_31754[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (9))){
var inst_30142 = (state_30156[(2)]);
var inst_30143 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30156__$1 = (function (){var statearr_30194 = state_30156;
(statearr_30194[(15)] = inst_30142);

return statearr_30194;
})();
if(cljs.core.truth_(inst_30143)){
var statearr_30198_31755 = state_30156__$1;
(statearr_30198_31755[(1)] = (21));

} else {
var statearr_30199_31756 = state_30156__$1;
(statearr_30199_31756[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (5))){
var inst_30097 = cljs.core.async.close_BANG_(out);
var state_30156__$1 = state_30156;
var statearr_30200_31757 = state_30156__$1;
(statearr_30200_31757[(2)] = inst_30097);

(statearr_30200_31757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (14))){
var inst_30119 = (state_30156[(7)]);
var inst_30121 = cljs.core.chunked_seq_QMARK_(inst_30119);
var state_30156__$1 = state_30156;
if(inst_30121){
var statearr_30201_31758 = state_30156__$1;
(statearr_30201_31758[(1)] = (17));

} else {
var statearr_30202_31759 = state_30156__$1;
(statearr_30202_31759[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (16))){
var inst_30138 = (state_30156[(2)]);
var state_30156__$1 = state_30156;
var statearr_30203_31760 = state_30156__$1;
(statearr_30203_31760[(2)] = inst_30138);

(statearr_30203_31760[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30157 === (10))){
var inst_30108 = (state_30156[(9)]);
var inst_30106 = (state_30156[(12)]);
var inst_30113 = cljs.core._nth(inst_30106,inst_30108);
var state_30156__$1 = state_30156;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30156__$1,(13),out,inst_30113);
} else {
if((state_val_30157 === (18))){
var inst_30119 = (state_30156[(7)]);
var inst_30129 = cljs.core.first(inst_30119);
var state_30156__$1 = state_30156;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30156__$1,(20),out,inst_30129);
} else {
if((state_val_30157 === (8))){
var inst_30108 = (state_30156[(9)]);
var inst_30107 = (state_30156[(11)]);
var inst_30110 = (inst_30108 < inst_30107);
var inst_30111 = inst_30110;
var state_30156__$1 = state_30156;
if(cljs.core.truth_(inst_30111)){
var statearr_30204_31761 = state_30156__$1;
(statearr_30204_31761[(1)] = (10));

} else {
var statearr_30205_31762 = state_30156__$1;
(statearr_30205_31762[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_30206 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30206[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__);

(statearr_30206[(1)] = (1));

return statearr_30206;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____1 = (function (state_30156){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30156);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30207){if((e30207 instanceof Object)){
var ex__28141__auto__ = e30207;
var statearr_30208_31763 = state_30156;
(statearr_30208_31763[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30207;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31764 = state_30156;
state_30156 = G__31764;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__ = function(state_30156){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____1.call(this,state_30156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_30209 = f__28267__auto__();
(statearr_30209[(6)] = c__28266__auto__);

return statearr_30209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));

return c__28266__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30211 = arguments.length;
switch (G__30211) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30216 = arguments.length;
switch (G__30216) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30222 = arguments.length;
switch (G__30222) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28266__auto___31768 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_30247){
var state_val_30248 = (state_30247[(1)]);
if((state_val_30248 === (7))){
var inst_30242 = (state_30247[(2)]);
var state_30247__$1 = state_30247;
var statearr_30249_31769 = state_30247__$1;
(statearr_30249_31769[(2)] = inst_30242);

(statearr_30249_31769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (1))){
var inst_30224 = null;
var state_30247__$1 = (function (){var statearr_30250 = state_30247;
(statearr_30250[(7)] = inst_30224);

return statearr_30250;
})();
var statearr_30251_31770 = state_30247__$1;
(statearr_30251_31770[(2)] = null);

(statearr_30251_31770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (4))){
var inst_30227 = (state_30247[(8)]);
var inst_30227__$1 = (state_30247[(2)]);
var inst_30228 = (inst_30227__$1 == null);
var inst_30229 = cljs.core.not(inst_30228);
var state_30247__$1 = (function (){var statearr_30252 = state_30247;
(statearr_30252[(8)] = inst_30227__$1);

return statearr_30252;
})();
if(inst_30229){
var statearr_30253_31771 = state_30247__$1;
(statearr_30253_31771[(1)] = (5));

} else {
var statearr_30254_31772 = state_30247__$1;
(statearr_30254_31772[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (6))){
var state_30247__$1 = state_30247;
var statearr_30255_31773 = state_30247__$1;
(statearr_30255_31773[(2)] = null);

(statearr_30255_31773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (3))){
var inst_30244 = (state_30247[(2)]);
var inst_30245 = cljs.core.async.close_BANG_(out);
var state_30247__$1 = (function (){var statearr_30256 = state_30247;
(statearr_30256[(9)] = inst_30244);

return statearr_30256;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30247__$1,inst_30245);
} else {
if((state_val_30248 === (2))){
var state_30247__$1 = state_30247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30247__$1,(4),ch);
} else {
if((state_val_30248 === (11))){
var inst_30227 = (state_30247[(8)]);
var inst_30236 = (state_30247[(2)]);
var inst_30224 = inst_30227;
var state_30247__$1 = (function (){var statearr_30260 = state_30247;
(statearr_30260[(10)] = inst_30236);

(statearr_30260[(7)] = inst_30224);

return statearr_30260;
})();
var statearr_30262_31774 = state_30247__$1;
(statearr_30262_31774[(2)] = null);

(statearr_30262_31774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (9))){
var inst_30227 = (state_30247[(8)]);
var state_30247__$1 = state_30247;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30247__$1,(11),out,inst_30227);
} else {
if((state_val_30248 === (5))){
var inst_30227 = (state_30247[(8)]);
var inst_30224 = (state_30247[(7)]);
var inst_30231 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30227,inst_30224);
var state_30247__$1 = state_30247;
if(inst_30231){
var statearr_30264_31775 = state_30247__$1;
(statearr_30264_31775[(1)] = (8));

} else {
var statearr_30265_31776 = state_30247__$1;
(statearr_30265_31776[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (10))){
var inst_30239 = (state_30247[(2)]);
var state_30247__$1 = state_30247;
var statearr_30266_31777 = state_30247__$1;
(statearr_30266_31777[(2)] = inst_30239);

(statearr_30266_31777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30248 === (8))){
var inst_30224 = (state_30247[(7)]);
var tmp30263 = inst_30224;
var inst_30224__$1 = tmp30263;
var state_30247__$1 = (function (){var statearr_30267 = state_30247;
(statearr_30267[(7)] = inst_30224__$1);

return statearr_30267;
})();
var statearr_30268_31778 = state_30247__$1;
(statearr_30268_31778[(2)] = null);

(statearr_30268_31778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30269 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30269[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30269[(1)] = (1));

return statearr_30269;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30247){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30247);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30270){if((e30270 instanceof Object)){
var ex__28141__auto__ = e30270;
var statearr_30271_31779 = state_30247;
(statearr_30271_31779[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30270;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31780 = state_30247;
state_30247 = G__31780;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30247){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_30272 = f__28267__auto__();
(statearr_30272[(6)] = c__28266__auto___31768);

return statearr_30272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30274 = arguments.length;
switch (G__30274) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28266__auto___31782 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_30312){
var state_val_30313 = (state_30312[(1)]);
if((state_val_30313 === (7))){
var inst_30308 = (state_30312[(2)]);
var state_30312__$1 = state_30312;
var statearr_30320_31783 = state_30312__$1;
(statearr_30320_31783[(2)] = inst_30308);

(statearr_30320_31783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (1))){
var inst_30275 = (new Array(n));
var inst_30276 = inst_30275;
var inst_30277 = (0);
var state_30312__$1 = (function (){var statearr_30321 = state_30312;
(statearr_30321[(7)] = inst_30277);

(statearr_30321[(8)] = inst_30276);

return statearr_30321;
})();
var statearr_30322_31784 = state_30312__$1;
(statearr_30322_31784[(2)] = null);

(statearr_30322_31784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (4))){
var inst_30280 = (state_30312[(9)]);
var inst_30280__$1 = (state_30312[(2)]);
var inst_30281 = (inst_30280__$1 == null);
var inst_30282 = cljs.core.not(inst_30281);
var state_30312__$1 = (function (){var statearr_30323 = state_30312;
(statearr_30323[(9)] = inst_30280__$1);

return statearr_30323;
})();
if(inst_30282){
var statearr_30324_31785 = state_30312__$1;
(statearr_30324_31785[(1)] = (5));

} else {
var statearr_30325_31786 = state_30312__$1;
(statearr_30325_31786[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (15))){
var inst_30302 = (state_30312[(2)]);
var state_30312__$1 = state_30312;
var statearr_30326_31787 = state_30312__$1;
(statearr_30326_31787[(2)] = inst_30302);

(statearr_30326_31787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (13))){
var state_30312__$1 = state_30312;
var statearr_30327_31788 = state_30312__$1;
(statearr_30327_31788[(2)] = null);

(statearr_30327_31788[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (6))){
var inst_30277 = (state_30312[(7)]);
var inst_30298 = (inst_30277 > (0));
var state_30312__$1 = state_30312;
if(cljs.core.truth_(inst_30298)){
var statearr_30328_31789 = state_30312__$1;
(statearr_30328_31789[(1)] = (12));

} else {
var statearr_30329_31790 = state_30312__$1;
(statearr_30329_31790[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (3))){
var inst_30310 = (state_30312[(2)]);
var state_30312__$1 = state_30312;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30312__$1,inst_30310);
} else {
if((state_val_30313 === (12))){
var inst_30276 = (state_30312[(8)]);
var inst_30300 = cljs.core.vec(inst_30276);
var state_30312__$1 = state_30312;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30312__$1,(15),out,inst_30300);
} else {
if((state_val_30313 === (2))){
var state_30312__$1 = state_30312;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30312__$1,(4),ch);
} else {
if((state_val_30313 === (11))){
var inst_30292 = (state_30312[(2)]);
var inst_30293 = (new Array(n));
var inst_30276 = inst_30293;
var inst_30277 = (0);
var state_30312__$1 = (function (){var statearr_30330 = state_30312;
(statearr_30330[(7)] = inst_30277);

(statearr_30330[(8)] = inst_30276);

(statearr_30330[(10)] = inst_30292);

return statearr_30330;
})();
var statearr_30331_31791 = state_30312__$1;
(statearr_30331_31791[(2)] = null);

(statearr_30331_31791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (9))){
var inst_30276 = (state_30312[(8)]);
var inst_30290 = cljs.core.vec(inst_30276);
var state_30312__$1 = state_30312;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30312__$1,(11),out,inst_30290);
} else {
if((state_val_30313 === (5))){
var inst_30277 = (state_30312[(7)]);
var inst_30285 = (state_30312[(11)]);
var inst_30276 = (state_30312[(8)]);
var inst_30280 = (state_30312[(9)]);
var inst_30284 = (inst_30276[inst_30277] = inst_30280);
var inst_30285__$1 = (inst_30277 + (1));
var inst_30286 = (inst_30285__$1 < n);
var state_30312__$1 = (function (){var statearr_30332 = state_30312;
(statearr_30332[(11)] = inst_30285__$1);

(statearr_30332[(12)] = inst_30284);

return statearr_30332;
})();
if(cljs.core.truth_(inst_30286)){
var statearr_30333_31792 = state_30312__$1;
(statearr_30333_31792[(1)] = (8));

} else {
var statearr_30334_31793 = state_30312__$1;
(statearr_30334_31793[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (14))){
var inst_30305 = (state_30312[(2)]);
var inst_30306 = cljs.core.async.close_BANG_(out);
var state_30312__$1 = (function (){var statearr_30336 = state_30312;
(statearr_30336[(13)] = inst_30305);

return statearr_30336;
})();
var statearr_30337_31794 = state_30312__$1;
(statearr_30337_31794[(2)] = inst_30306);

(statearr_30337_31794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (10))){
var inst_30296 = (state_30312[(2)]);
var state_30312__$1 = state_30312;
var statearr_30338_31795 = state_30312__$1;
(statearr_30338_31795[(2)] = inst_30296);

(statearr_30338_31795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30313 === (8))){
var inst_30285 = (state_30312[(11)]);
var inst_30276 = (state_30312[(8)]);
var tmp30335 = inst_30276;
var inst_30276__$1 = tmp30335;
var inst_30277 = inst_30285;
var state_30312__$1 = (function (){var statearr_30339 = state_30312;
(statearr_30339[(7)] = inst_30277);

(statearr_30339[(8)] = inst_30276__$1);

return statearr_30339;
})();
var statearr_30340_31796 = state_30312__$1;
(statearr_30340_31796[(2)] = null);

(statearr_30340_31796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30341 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30341[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30341[(1)] = (1));

return statearr_30341;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30312){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30312);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30342){if((e30342 instanceof Object)){
var ex__28141__auto__ = e30342;
var statearr_30343_31797 = state_30312;
(statearr_30343_31797[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30342;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31798 = state_30312;
state_30312 = G__31798;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30312){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_30344 = f__28267__auto__();
(statearr_30344[(6)] = c__28266__auto___31782);

return statearr_30344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30347 = arguments.length;
switch (G__30347) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28266__auto___31800 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_30389){
var state_val_30390 = (state_30389[(1)]);
if((state_val_30390 === (7))){
var inst_30385 = (state_30389[(2)]);
var state_30389__$1 = state_30389;
var statearr_30391_31801 = state_30389__$1;
(statearr_30391_31801[(2)] = inst_30385);

(statearr_30391_31801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (1))){
var inst_30348 = [];
var inst_30349 = inst_30348;
var inst_30350 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30389__$1 = (function (){var statearr_30392 = state_30389;
(statearr_30392[(7)] = inst_30350);

(statearr_30392[(8)] = inst_30349);

return statearr_30392;
})();
var statearr_30393_31802 = state_30389__$1;
(statearr_30393_31802[(2)] = null);

(statearr_30393_31802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (4))){
var inst_30353 = (state_30389[(9)]);
var inst_30353__$1 = (state_30389[(2)]);
var inst_30354 = (inst_30353__$1 == null);
var inst_30355 = cljs.core.not(inst_30354);
var state_30389__$1 = (function (){var statearr_30394 = state_30389;
(statearr_30394[(9)] = inst_30353__$1);

return statearr_30394;
})();
if(inst_30355){
var statearr_30397_31803 = state_30389__$1;
(statearr_30397_31803[(1)] = (5));

} else {
var statearr_30398_31804 = state_30389__$1;
(statearr_30398_31804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (15))){
var inst_30379 = (state_30389[(2)]);
var state_30389__$1 = state_30389;
var statearr_30399_31805 = state_30389__$1;
(statearr_30399_31805[(2)] = inst_30379);

(statearr_30399_31805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (13))){
var state_30389__$1 = state_30389;
var statearr_30400_31806 = state_30389__$1;
(statearr_30400_31806[(2)] = null);

(statearr_30400_31806[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (6))){
var inst_30349 = (state_30389[(8)]);
var inst_30374 = inst_30349.length;
var inst_30375 = (inst_30374 > (0));
var state_30389__$1 = state_30389;
if(cljs.core.truth_(inst_30375)){
var statearr_30401_31807 = state_30389__$1;
(statearr_30401_31807[(1)] = (12));

} else {
var statearr_30402_31808 = state_30389__$1;
(statearr_30402_31808[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (3))){
var inst_30387 = (state_30389[(2)]);
var state_30389__$1 = state_30389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30389__$1,inst_30387);
} else {
if((state_val_30390 === (12))){
var inst_30349 = (state_30389[(8)]);
var inst_30377 = cljs.core.vec(inst_30349);
var state_30389__$1 = state_30389;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30389__$1,(15),out,inst_30377);
} else {
if((state_val_30390 === (2))){
var state_30389__$1 = state_30389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30389__$1,(4),ch);
} else {
if((state_val_30390 === (11))){
var inst_30357 = (state_30389[(10)]);
var inst_30353 = (state_30389[(9)]);
var inst_30367 = (state_30389[(2)]);
var inst_30368 = [];
var inst_30369 = inst_30368.push(inst_30353);
var inst_30349 = inst_30368;
var inst_30350 = inst_30357;
var state_30389__$1 = (function (){var statearr_30403 = state_30389;
(statearr_30403[(7)] = inst_30350);

(statearr_30403[(11)] = inst_30369);

(statearr_30403[(12)] = inst_30367);

(statearr_30403[(8)] = inst_30349);

return statearr_30403;
})();
var statearr_30404_31809 = state_30389__$1;
(statearr_30404_31809[(2)] = null);

(statearr_30404_31809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (9))){
var inst_30349 = (state_30389[(8)]);
var inst_30365 = cljs.core.vec(inst_30349);
var state_30389__$1 = state_30389;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30389__$1,(11),out,inst_30365);
} else {
if((state_val_30390 === (5))){
var inst_30357 = (state_30389[(10)]);
var inst_30353 = (state_30389[(9)]);
var inst_30350 = (state_30389[(7)]);
var inst_30357__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30353) : f.call(null,inst_30353));
var inst_30358 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30357__$1,inst_30350);
var inst_30359 = cljs.core.keyword_identical_QMARK_(inst_30350,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30360 = ((inst_30358) || (inst_30359));
var state_30389__$1 = (function (){var statearr_30405 = state_30389;
(statearr_30405[(10)] = inst_30357__$1);

return statearr_30405;
})();
if(cljs.core.truth_(inst_30360)){
var statearr_30406_31810 = state_30389__$1;
(statearr_30406_31810[(1)] = (8));

} else {
var statearr_30407_31811 = state_30389__$1;
(statearr_30407_31811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (14))){
var inst_30382 = (state_30389[(2)]);
var inst_30383 = cljs.core.async.close_BANG_(out);
var state_30389__$1 = (function (){var statearr_30409 = state_30389;
(statearr_30409[(13)] = inst_30382);

return statearr_30409;
})();
var statearr_30410_31812 = state_30389__$1;
(statearr_30410_31812[(2)] = inst_30383);

(statearr_30410_31812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (10))){
var inst_30372 = (state_30389[(2)]);
var state_30389__$1 = state_30389;
var statearr_30411_31813 = state_30389__$1;
(statearr_30411_31813[(2)] = inst_30372);

(statearr_30411_31813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30390 === (8))){
var inst_30357 = (state_30389[(10)]);
var inst_30353 = (state_30389[(9)]);
var inst_30349 = (state_30389[(8)]);
var inst_30362 = inst_30349.push(inst_30353);
var tmp30408 = inst_30349;
var inst_30349__$1 = tmp30408;
var inst_30350 = inst_30357;
var state_30389__$1 = (function (){var statearr_30412 = state_30389;
(statearr_30412[(14)] = inst_30362);

(statearr_30412[(7)] = inst_30350);

(statearr_30412[(8)] = inst_30349__$1);

return statearr_30412;
})();
var statearr_30413_31814 = state_30389__$1;
(statearr_30413_31814[(2)] = null);

(statearr_30413_31814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30414[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30414[(1)] = (1));

return statearr_30414;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30389){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30389);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30415){if((e30415 instanceof Object)){
var ex__28141__auto__ = e30415;
var statearr_30416_31815 = state_30389;
(statearr_30416_31815[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30389);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30415;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31816 = state_30389;
state_30389 = G__31816;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30389){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_30417 = f__28267__auto__();
(statearr_30417[(6)] = c__28266__auto___31800);

return statearr_30417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
