goog.provide('chord.client');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((((typeof require !== 'undefined'))?(function (){try{return require("ws");
}catch (e30679){var e = e30679;
return false;
}})():false))){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js(opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30913 = arguments.length;
var i__4737__auto___30914 = (0);
while(true){
if((i__4737__auto___30914 < len__4736__auto___30913)){
args__4742__auto__.push((arguments[i__4737__auto___30914]));

var G__30917 = (i__4737__auto___30914 + (1));
i__4737__auto___30914 = G__30917;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__30703){
var vec__30704 = p__30703;
var map__30707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30704,(0),null);
var map__30707__$1 = (((((!((map__30707 == null))))?(((((map__30707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30707):map__30707);
var opts = map__30707__$1;
var read_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30707__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws(ws_url,ws_opts);
var map__30711 = chord.format.wrap_format(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__4126__auto__ = read_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__4126__auto__ = write_ch;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
}
})()], null),opts);
var map__30711__$1 = (((((!((map__30711 == null))))?(((((map__30711.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30711.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30711):map__30711);
var read_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30711__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30711__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var close_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(web_socket.binaryType = "arraybuffer");

chord.channels.read_from_ws_BANG_(web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_(web_socket,write_ch__$1);

(web_socket.onopen = (function (p1__30687_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_ch,p1__30687_SHARP_);
}));

(web_socket.onclose = (function (p1__30688_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(close_ch,p1__30688_SHARP_);
}));

var ws_chan = chord.channels.bidi_ch.cljs$core$IFn$_invoke$arity$variadic(read_ch__$1,write_ch__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),(function (){
return web_socket.close();
})], null)], 0));
var initial_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__28266__auto___30947 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28267__auto__ = (function (){var switch__28137__auto__ = (function (state_30795){
var state_val_30796 = (state_30795[(1)]);
if((state_val_30796 === (7))){
var inst_30790 = (state_30795[(2)]);
var state_30795__$1 = state_30795;
var statearr_30801_30958 = state_30795__$1;
(statearr_30801_30958[(2)] = inst_30790);

(statearr_30801_30958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (20))){
var state_30795__$1 = state_30795;
var statearr_30805_30959 = state_30795__$1;
(statearr_30805_30959[(2)] = null);

(statearr_30805_30959[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (1))){
var inst_30724 = false;
var state_30795__$1 = (function (){var statearr_30811 = state_30795;
(statearr_30811[(7)] = inst_30724);

return statearr_30811;
})();
var statearr_30813_30962 = state_30795__$1;
(statearr_30813_30962[(2)] = null);

(statearr_30813_30962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (4))){
var inst_30741 = (state_30795[(8)]);
var inst_30738 = (state_30795[(9)]);
var inst_30738__$1 = (state_30795[(2)]);
var inst_30739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30738__$1,(0),null);
var inst_30741__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30738__$1,(1),null);
var inst_30742 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30741__$1,open_ch);
var state_30795__$1 = (function (){var statearr_30815 = state_30795;
(statearr_30815[(8)] = inst_30741__$1);

(statearr_30815[(10)] = inst_30739);

(statearr_30815[(9)] = inst_30738__$1);

return statearr_30815;
})();
if(inst_30742){
var statearr_30820_30968 = state_30795__$1;
(statearr_30820_30968[(1)] = (5));

} else {
var statearr_30825_30969 = state_30795__$1;
(statearr_30825_30969[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (15))){
var inst_30775 = (state_30795[(2)]);
var state_30795__$1 = state_30795;
var statearr_30826_30973 = state_30795__$1;
(statearr_30826_30973[(2)] = inst_30775);

(statearr_30826_30973[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (21))){
var inst_30786 = (state_30795[(2)]);
var state_30795__$1 = state_30795;
var statearr_30830_30974 = state_30795__$1;
(statearr_30830_30974[(2)] = inst_30786);

(statearr_30830_30974[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (13))){
var state_30795__$1 = state_30795;
var statearr_30832_30976 = state_30795__$1;
(statearr_30832_30976[(2)] = null);

(statearr_30832_30976[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (6))){
var inst_30741 = (state_30795[(8)]);
var inst_30757 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30741,close_ch);
var state_30795__$1 = state_30795;
if(inst_30757){
var statearr_30837_30981 = state_30795__$1;
(statearr_30837_30981[(1)] = (9));

} else {
var statearr_30838_30982 = state_30795__$1;
(statearr_30838_30982[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (17))){
var state_30795__$1 = state_30795;
var statearr_30843_30985 = state_30795__$1;
(statearr_30843_30985[(2)] = initial_ch);

(statearr_30843_30985[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (3))){
var inst_30792 = (state_30795[(2)]);
var state_30795__$1 = state_30795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30795__$1,inst_30792);
} else {
if((state_val_30796 === (12))){
var inst_30724 = (state_30795[(7)]);
var state_30795__$1 = state_30795;
if(cljs.core.truth_(inst_30724)){
var statearr_30847_30987 = state_30795__$1;
(statearr_30847_30987[(1)] = (16));

} else {
var statearr_30850_30990 = state_30795__$1;
(statearr_30850_30990[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (2))){
var inst_30734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30735 = [open_ch,close_ch];
var inst_30736 = (new cljs.core.PersistentVector(null,2,(5),inst_30734,inst_30735,null));
var state_30795__$1 = state_30795;
return cljs.core.async.ioc_alts_BANG_(state_30795__$1,(4),inst_30736);
} else {
if((state_val_30796 === (19))){
var inst_30739 = (state_30795[(10)]);
var state_30795__$1 = state_30795;
var statearr_30855_30995 = state_30795__$1;
(statearr_30855_30995[(2)] = inst_30739);

(statearr_30855_30995[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (11))){
var inst_30788 = (state_30795[(2)]);
var state_30795__$1 = state_30795;
var statearr_30857_30999 = state_30795__$1;
(statearr_30857_30999[(2)] = inst_30788);

(statearr_30857_30999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (9))){
var inst_30765 = (state_30795[(11)]);
var inst_30738 = (state_30795[(9)]);
var inst_30763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30738,(0),null);
var inst_30765__$1 = chord.client.close_event__GT_maybe_error(inst_30763);
var state_30795__$1 = (function (){var statearr_30861 = state_30795;
(statearr_30861[(11)] = inst_30765__$1);

return statearr_30861;
})();
if(cljs.core.truth_(inst_30765__$1)){
var statearr_30863_31006 = state_30795__$1;
(statearr_30863_31006[(1)] = (12));

} else {
var statearr_30864_31007 = state_30795__$1;
(statearr_30864_31007[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (5))){
var inst_30738 = (state_30795[(9)]);
var inst_30747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30738,(0),null);
var inst_30749 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_30750 = [ws_chan];
var inst_30751 = cljs.core.PersistentHashMap.fromArrays(inst_30749,inst_30750);
var state_30795__$1 = (function (){var statearr_30870 = state_30795;
(statearr_30870[(12)] = inst_30747);

return statearr_30870;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30795__$1,(8),initial_ch,inst_30751);
} else {
if((state_val_30796 === (14))){
var inst_30778 = (state_30795[(2)]);
var inst_30779 = cljs.core.async.close_BANG_(ws_chan);
var inst_30780 = cljs.core.async.close_BANG_(initial_ch);
var state_30795__$1 = (function (){var statearr_30873 = state_30795;
(statearr_30873[(13)] = inst_30778);

(statearr_30873[(14)] = inst_30779);

return statearr_30873;
})();
var statearr_30874_31019 = state_30795__$1;
(statearr_30874_31019[(2)] = inst_30780);

(statearr_30874_31019[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (16))){
var state_30795__$1 = state_30795;
var statearr_30878_31021 = state_30795__$1;
(statearr_30878_31021[(2)] = read_ch__$1);

(statearr_30878_31021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (10))){
var inst_30741 = (state_30795[(8)]);
var inst_30782 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30741,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_30795__$1 = state_30795;
if(inst_30782){
var statearr_30881_31023 = state_30795__$1;
(statearr_30881_31023[(1)] = (19));

} else {
var statearr_30883_31024 = state_30795__$1;
(statearr_30883_31024[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30796 === (18))){
var inst_30765 = (state_30795[(11)]);
var inst_30770 = (state_30795[(2)]);
var inst_30771 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30772 = [inst_30765];
var inst_30773 = cljs.core.PersistentHashMap.fromArrays(inst_30771,inst_30772);
var state_30795__$1 = state_30795;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30795__$1,(15),inst_30770,inst_30773);
} else {
if((state_val_30796 === (8))){
var inst_30753 = (state_30795[(2)]);
var inst_30754 = cljs.core.async.close_BANG_(initial_ch);
var inst_30724 = true;
var state_30795__$1 = (function (){var statearr_30889 = state_30795;
(statearr_30889[(15)] = inst_30753);

(statearr_30889[(16)] = inst_30754);

(statearr_30889[(7)] = inst_30724);

return statearr_30889;
})();
var statearr_30891_31027 = state_30795__$1;
(statearr_30891_31027[(2)] = null);

(statearr_30891_31027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var chord$client$state_machine__28138__auto__ = null;
var chord$client$state_machine__28138__auto____0 = (function (){
var statearr_30894 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30894[(0)] = chord$client$state_machine__28138__auto__);

(statearr_30894[(1)] = (1));

return statearr_30894;
});
var chord$client$state_machine__28138__auto____1 = (function (state_30795){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30795);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30895){if((e30895 instanceof Object)){
var ex__28141__auto__ = e30895;
var statearr_30896_31030 = state_30795;
(statearr_30896_31030[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30895;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31032 = state_30795;
state_30795 = G__31032;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
chord$client$state_machine__28138__auto__ = function(state_30795){
switch(arguments.length){
case 0:
return chord$client$state_machine__28138__auto____0.call(this);
case 1:
return chord$client$state_machine__28138__auto____1.call(this,state_30795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
chord$client$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__28138__auto____0;
chord$client$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__28138__auto____1;
return chord$client$state_machine__28138__auto__;
})()
})();
var state__28268__auto__ = (function (){var statearr_30898 = f__28267__auto__();
(statearr_30898[(6)] = c__28266__auto___30947);

return statearr_30898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28268__auto__);
}));


return initial_ch;
}));

(chord.client.ws_ch.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chord.client.ws_ch.cljs$lang$applyTo = (function (seq30692){
var G__30693 = cljs.core.first(seq30692);
var seq30692__$1 = cljs.core.next(seq30692);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30693,seq30692__$1);
}));


//# sourceMappingURL=chord.client.js.map
