goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28379 = arguments.length;
switch (G__28379) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28380 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28380 = (function (f,blockable,meta28381){
this.f = f;
this.blockable = blockable;
this.meta28381 = meta28381;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28380.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28382,meta28381__$1){
var self__ = this;
var _28382__$1 = this;
return (new cljs.core.async.t_cljs$core$async28380(self__.f,self__.blockable,meta28381__$1));
}));

(cljs.core.async.t_cljs$core$async28380.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28382){
var self__ = this;
var _28382__$1 = this;
return self__.meta28381;
}));

(cljs.core.async.t_cljs$core$async28380.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28380.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28380.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28380.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28380.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28381","meta28381",184671421,null)], null);
}));

(cljs.core.async.t_cljs$core$async28380.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28380.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28380");

(cljs.core.async.t_cljs$core$async28380.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28380");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28380.
 */
cljs.core.async.__GT_t_cljs$core$async28380 = (function cljs$core$async$__GT_t_cljs$core$async28380(f__$1,blockable__$1,meta28381){
return (new cljs.core.async.t_cljs$core$async28380(f__$1,blockable__$1,meta28381));
});

}

return (new cljs.core.async.t_cljs$core$async28380(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28401 = arguments.length;
switch (G__28401) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28406 = arguments.length;
switch (G__28406) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28410 = arguments.length;
switch (G__28410) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30461 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30461) : fn1.call(null,val_30461));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30461) : fn1.call(null,val_30461));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28414 = arguments.length;
switch (G__28414) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30501 = n;
var x_30502 = (0);
while(true){
if((x_30502 < n__4613__auto___30501)){
(a[x_30502] = x_30502);

var G__30503 = (x_30502 + (1));
x_30502 = G__30503;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28425 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28425 = (function (flag,meta28426){
this.flag = flag;
this.meta28426 = meta28426;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28425.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28427,meta28426__$1){
var self__ = this;
var _28427__$1 = this;
return (new cljs.core.async.t_cljs$core$async28425(self__.flag,meta28426__$1));
}));

(cljs.core.async.t_cljs$core$async28425.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28427){
var self__ = this;
var _28427__$1 = this;
return self__.meta28426;
}));

(cljs.core.async.t_cljs$core$async28425.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28425.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28425.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28425.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28425.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28426","meta28426",-1042776207,null)], null);
}));

(cljs.core.async.t_cljs$core$async28425.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28425.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28425");

(cljs.core.async.t_cljs$core$async28425.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28425");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28425.
 */
cljs.core.async.__GT_t_cljs$core$async28425 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28425(flag__$1,meta28426){
return (new cljs.core.async.t_cljs$core$async28425(flag__$1,meta28426));
});

}

return (new cljs.core.async.t_cljs$core$async28425(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28433 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28433 = (function (flag,cb,meta28434){
this.flag = flag;
this.cb = cb;
this.meta28434 = meta28434;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28433.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28435,meta28434__$1){
var self__ = this;
var _28435__$1 = this;
return (new cljs.core.async.t_cljs$core$async28433(self__.flag,self__.cb,meta28434__$1));
}));

(cljs.core.async.t_cljs$core$async28433.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28435){
var self__ = this;
var _28435__$1 = this;
return self__.meta28434;
}));

(cljs.core.async.t_cljs$core$async28433.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28433.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28433.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28433.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28433.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28434","meta28434",58064888,null)], null);
}));

(cljs.core.async.t_cljs$core$async28433.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28433.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28433");

(cljs.core.async.t_cljs$core$async28433.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28433");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28433.
 */
cljs.core.async.__GT_t_cljs$core$async28433 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28433(flag__$1,cb__$1,meta28434){
return (new cljs.core.async.t_cljs$core$async28433(flag__$1,cb__$1,meta28434));
});

}

return (new cljs.core.async.t_cljs$core$async28433(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28440_SHARP_){
var G__28446 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28440_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28446) : fret.call(null,G__28446));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28441_SHARP_){
var G__28447 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28441_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28447) : fret.call(null,G__28447));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30538 = (i + (1));
i = G__30538;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30556 = arguments.length;
var i__4737__auto___30559 = (0);
while(true){
if((i__4737__auto___30559 < len__4736__auto___30556)){
args__4742__auto__.push((arguments[i__4737__auto___30559]));

var G__30560 = (i__4737__auto___30559 + (1));
i__4737__auto___30559 = G__30560;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28451){
var map__28452 = p__28451;
var map__28452__$1 = (((((!((map__28452 == null))))?(((((map__28452.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28452.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28452):map__28452);
var opts = map__28452__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28448){
var G__28449 = cljs.core.first(seq28448);
var seq28448__$1 = cljs.core.next(seq28448);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28449,seq28448__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28462 = arguments.length;
switch (G__28462) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28279__auto___30572 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28495){
var state_val_28496 = (state_28495[(1)]);
if((state_val_28496 === (7))){
var inst_28490 = (state_28495[(2)]);
var state_28495__$1 = state_28495;
var statearr_28506_30574 = state_28495__$1;
(statearr_28506_30574[(2)] = inst_28490);

(statearr_28506_30574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (1))){
var state_28495__$1 = state_28495;
var statearr_28507_30576 = state_28495__$1;
(statearr_28507_30576[(2)] = null);

(statearr_28507_30576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (4))){
var inst_28473 = (state_28495[(7)]);
var inst_28473__$1 = (state_28495[(2)]);
var inst_28474 = (inst_28473__$1 == null);
var state_28495__$1 = (function (){var statearr_28514 = state_28495;
(statearr_28514[(7)] = inst_28473__$1);

return statearr_28514;
})();
if(cljs.core.truth_(inst_28474)){
var statearr_28518_30577 = state_28495__$1;
(statearr_28518_30577[(1)] = (5));

} else {
var statearr_28519_30578 = state_28495__$1;
(statearr_28519_30578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (13))){
var state_28495__$1 = state_28495;
var statearr_28526_30581 = state_28495__$1;
(statearr_28526_30581[(2)] = null);

(statearr_28526_30581[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (6))){
var inst_28473 = (state_28495[(7)]);
var state_28495__$1 = state_28495;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28495__$1,(11),to,inst_28473);
} else {
if((state_val_28496 === (3))){
var inst_28492 = (state_28495[(2)]);
var state_28495__$1 = state_28495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28495__$1,inst_28492);
} else {
if((state_val_28496 === (12))){
var state_28495__$1 = state_28495;
var statearr_28530_30587 = state_28495__$1;
(statearr_28530_30587[(2)] = null);

(statearr_28530_30587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (2))){
var state_28495__$1 = state_28495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28495__$1,(4),from);
} else {
if((state_val_28496 === (11))){
var inst_28483 = (state_28495[(2)]);
var state_28495__$1 = state_28495;
if(cljs.core.truth_(inst_28483)){
var statearr_28531_30588 = state_28495__$1;
(statearr_28531_30588[(1)] = (12));

} else {
var statearr_28532_30589 = state_28495__$1;
(statearr_28532_30589[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (9))){
var state_28495__$1 = state_28495;
var statearr_28537_30590 = state_28495__$1;
(statearr_28537_30590[(2)] = null);

(statearr_28537_30590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (5))){
var state_28495__$1 = state_28495;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28539_30591 = state_28495__$1;
(statearr_28539_30591[(1)] = (8));

} else {
var statearr_28540_30592 = state_28495__$1;
(statearr_28540_30592[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (14))){
var inst_28488 = (state_28495[(2)]);
var state_28495__$1 = state_28495;
var statearr_28541_30599 = state_28495__$1;
(statearr_28541_30599[(2)] = inst_28488);

(statearr_28541_30599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (10))){
var inst_28480 = (state_28495[(2)]);
var state_28495__$1 = state_28495;
var statearr_28545_30600 = state_28495__$1;
(statearr_28545_30600[(2)] = inst_28480);

(statearr_28545_30600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28496 === (8))){
var inst_28477 = cljs.core.async.close_BANG_(to);
var state_28495__$1 = state_28495;
var statearr_28546_30601 = state_28495__$1;
(statearr_28546_30601[(2)] = inst_28477);

(statearr_28546_30601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_28550 = [null,null,null,null,null,null,null,null];
(statearr_28550[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_28550[(1)] = (1));

return statearr_28550;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_28495){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28495);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28551){if((e28551 instanceof Object)){
var ex__28141__auto__ = e28551;
var statearr_28552_30606 = state_28495;
(statearr_28552_30606[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28495);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28551;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30608 = state_28495;
state_28495 = G__30608;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_28495){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_28495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28553 = f__28280__auto__();
(statearr_28553[(6)] = c__28279__auto___30572);

return statearr_28553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28554){
var vec__28555 = p__28554;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28555,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28555,(1),null);
var job = vec__28555;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28279__auto___30619 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28562){
var state_val_28563 = (state_28562[(1)]);
if((state_val_28563 === (1))){
var state_28562__$1 = state_28562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28562__$1,(2),res,v);
} else {
if((state_val_28563 === (2))){
var inst_28559 = (state_28562[(2)]);
var inst_28560 = cljs.core.async.close_BANG_(res);
var state_28562__$1 = (function (){var statearr_28565 = state_28562;
(statearr_28565[(7)] = inst_28559);

return statearr_28565;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28562__$1,inst_28560);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28567 = [null,null,null,null,null,null,null,null];
(statearr_28567[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28567[(1)] = (1));

return statearr_28567;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28562){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28562);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28571){if((e28571 instanceof Object)){
var ex__28141__auto__ = e28571;
var statearr_28572_30625 = state_28562;
(statearr_28572_30625[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28562);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28571;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30627 = state_28562;
state_28562 = G__30627;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28562){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28574 = f__28280__auto__();
(statearr_28574[(6)] = c__28279__auto___30619);

return statearr_28574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28575){
var vec__28576 = p__28575;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28576,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28576,(1),null);
var job = vec__28576;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30630 = n;
var __30631 = (0);
while(true){
if((__30631 < n__4613__auto___30630)){
var G__28579_30632 = type;
var G__28579_30633__$1 = (((G__28579_30632 instanceof cljs.core.Keyword))?G__28579_30632.fqn:null);
switch (G__28579_30633__$1) {
case "compute":
var c__28279__auto___30635 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30631,c__28279__auto___30635,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async){
return (function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = ((function (__30631,c__28279__auto___30635,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async){
return (function (state_28592){
var state_val_28593 = (state_28592[(1)]);
if((state_val_28593 === (1))){
var state_28592__$1 = state_28592;
var statearr_28600_30638 = state_28592__$1;
(statearr_28600_30638[(2)] = null);

(statearr_28600_30638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (2))){
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28592__$1,(4),jobs);
} else {
if((state_val_28593 === (3))){
var inst_28590 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28592__$1,inst_28590);
} else {
if((state_val_28593 === (4))){
var inst_28582 = (state_28592[(2)]);
var inst_28583 = process(inst_28582);
var state_28592__$1 = state_28592;
if(cljs.core.truth_(inst_28583)){
var statearr_28601_30643 = state_28592__$1;
(statearr_28601_30643[(1)] = (5));

} else {
var statearr_28602_30646 = state_28592__$1;
(statearr_28602_30646[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (5))){
var state_28592__$1 = state_28592;
var statearr_28603_30650 = state_28592__$1;
(statearr_28603_30650[(2)] = null);

(statearr_28603_30650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (6))){
var state_28592__$1 = state_28592;
var statearr_28604_30651 = state_28592__$1;
(statearr_28604_30651[(2)] = null);

(statearr_28604_30651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (7))){
var inst_28588 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
var statearr_28608_30653 = state_28592__$1;
(statearr_28608_30653[(2)] = inst_28588);

(statearr_28608_30653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30631,c__28279__auto___30635,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async))
;
return ((function (__30631,switch__28137__auto__,c__28279__auto___30635,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28609 = [null,null,null,null,null,null,null];
(statearr_28609[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28609[(1)] = (1));

return statearr_28609;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28592){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28592);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28610){if((e28610 instanceof Object)){
var ex__28141__auto__ = e28610;
var statearr_28611_30661 = state_28592;
(statearr_28611_30661[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28592);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28610;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30662 = state_28592;
state_28592 = G__30662;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28592){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
;})(__30631,switch__28137__auto__,c__28279__auto___30635,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async))
})();
var state__28281__auto__ = (function (){var statearr_28612 = f__28280__auto__();
(statearr_28612[(6)] = c__28279__auto___30635);

return statearr_28612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
});})(__30631,c__28279__auto___30635,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async))
);


break;
case "async":
var c__28279__auto___30671 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30631,c__28279__auto___30671,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async){
return (function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = ((function (__30631,c__28279__auto___30671,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async){
return (function (state_28625){
var state_val_28626 = (state_28625[(1)]);
if((state_val_28626 === (1))){
var state_28625__$1 = state_28625;
var statearr_28627_30694 = state_28625__$1;
(statearr_28627_30694[(2)] = null);

(statearr_28627_30694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28626 === (2))){
var state_28625__$1 = state_28625;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28625__$1,(4),jobs);
} else {
if((state_val_28626 === (3))){
var inst_28623 = (state_28625[(2)]);
var state_28625__$1 = state_28625;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28625__$1,inst_28623);
} else {
if((state_val_28626 === (4))){
var inst_28615 = (state_28625[(2)]);
var inst_28616 = async(inst_28615);
var state_28625__$1 = state_28625;
if(cljs.core.truth_(inst_28616)){
var statearr_28628_30740 = state_28625__$1;
(statearr_28628_30740[(1)] = (5));

} else {
var statearr_28629_30741 = state_28625__$1;
(statearr_28629_30741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28626 === (5))){
var state_28625__$1 = state_28625;
var statearr_28630_30744 = state_28625__$1;
(statearr_28630_30744[(2)] = null);

(statearr_28630_30744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28626 === (6))){
var state_28625__$1 = state_28625;
var statearr_28631_30749 = state_28625__$1;
(statearr_28631_30749[(2)] = null);

(statearr_28631_30749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28626 === (7))){
var inst_28621 = (state_28625[(2)]);
var state_28625__$1 = state_28625;
var statearr_28632_30753 = state_28625__$1;
(statearr_28632_30753[(2)] = inst_28621);

(statearr_28632_30753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30631,c__28279__auto___30671,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async))
;
return ((function (__30631,switch__28137__auto__,c__28279__auto___30671,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28634 = [null,null,null,null,null,null,null];
(statearr_28634[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28634[(1)] = (1));

return statearr_28634;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28625){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28625);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28635){if((e28635 instanceof Object)){
var ex__28141__auto__ = e28635;
var statearr_28636_30761 = state_28625;
(statearr_28636_30761[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28625);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30764 = state_28625;
state_28625 = G__30764;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28625){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
;})(__30631,switch__28137__auto__,c__28279__auto___30671,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async))
})();
var state__28281__auto__ = (function (){var statearr_28637 = f__28280__auto__();
(statearr_28637[(6)] = c__28279__auto___30671);

return statearr_28637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
});})(__30631,c__28279__auto___30671,G__28579_30632,G__28579_30633__$1,n__4613__auto___30630,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28579_30633__$1)].join('')));

}

var G__30768 = (__30631 + (1));
__30631 = G__30768;
continue;
} else {
}
break;
}

var c__28279__auto___30771 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28663){
var state_val_28664 = (state_28663[(1)]);
if((state_val_28664 === (7))){
var inst_28659 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
var statearr_28666_30773 = state_28663__$1;
(statearr_28666_30773[(2)] = inst_28659);

(statearr_28666_30773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (1))){
var state_28663__$1 = state_28663;
var statearr_28668_30777 = state_28663__$1;
(statearr_28668_30777[(2)] = null);

(statearr_28668_30777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (4))){
var inst_28643 = (state_28663[(7)]);
var inst_28643__$1 = (state_28663[(2)]);
var inst_28644 = (inst_28643__$1 == null);
var state_28663__$1 = (function (){var statearr_28669 = state_28663;
(statearr_28669[(7)] = inst_28643__$1);

return statearr_28669;
})();
if(cljs.core.truth_(inst_28644)){
var statearr_28670_30783 = state_28663__$1;
(statearr_28670_30783[(1)] = (5));

} else {
var statearr_28671_30784 = state_28663__$1;
(statearr_28671_30784[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (6))){
var inst_28648 = (state_28663[(8)]);
var inst_28643 = (state_28663[(7)]);
var inst_28648__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28651 = [inst_28643,inst_28648__$1];
var inst_28652 = (new cljs.core.PersistentVector(null,2,(5),inst_28650,inst_28651,null));
var state_28663__$1 = (function (){var statearr_28678 = state_28663;
(statearr_28678[(8)] = inst_28648__$1);

return statearr_28678;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28663__$1,(8),jobs,inst_28652);
} else {
if((state_val_28664 === (3))){
var inst_28661 = (state_28663[(2)]);
var state_28663__$1 = state_28663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28663__$1,inst_28661);
} else {
if((state_val_28664 === (2))){
var state_28663__$1 = state_28663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28663__$1,(4),from);
} else {
if((state_val_28664 === (9))){
var inst_28656 = (state_28663[(2)]);
var state_28663__$1 = (function (){var statearr_28694 = state_28663;
(statearr_28694[(9)] = inst_28656);

return statearr_28694;
})();
var statearr_28697_30799 = state_28663__$1;
(statearr_28697_30799[(2)] = null);

(statearr_28697_30799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (5))){
var inst_28646 = cljs.core.async.close_BANG_(jobs);
var state_28663__$1 = state_28663;
var statearr_28702_30802 = state_28663__$1;
(statearr_28702_30802[(2)] = inst_28646);

(statearr_28702_30802[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28664 === (8))){
var inst_28648 = (state_28663[(8)]);
var inst_28654 = (state_28663[(2)]);
var state_28663__$1 = (function (){var statearr_28703 = state_28663;
(statearr_28703[(10)] = inst_28654);

return statearr_28703;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28663__$1,(9),results,inst_28648);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28705 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28705[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28705[(1)] = (1));

return statearr_28705;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28663){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28663);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28706){if((e28706 instanceof Object)){
var ex__28141__auto__ = e28706;
var statearr_28707_30814 = state_28663;
(statearr_28707_30814[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28663);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28706;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30817 = state_28663;
state_28663 = G__30817;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28663){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28708 = f__28280__auto__();
(statearr_28708[(6)] = c__28279__auto___30771);

return statearr_28708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


var c__28279__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28747){
var state_val_28748 = (state_28747[(1)]);
if((state_val_28748 === (7))){
var inst_28743 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
var statearr_28751_30822 = state_28747__$1;
(statearr_28751_30822[(2)] = inst_28743);

(statearr_28751_30822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (20))){
var state_28747__$1 = state_28747;
var statearr_28752_30826 = state_28747__$1;
(statearr_28752_30826[(2)] = null);

(statearr_28752_30826[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (1))){
var state_28747__$1 = state_28747;
var statearr_28754_30828 = state_28747__$1;
(statearr_28754_30828[(2)] = null);

(statearr_28754_30828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (4))){
var inst_28711 = (state_28747[(7)]);
var inst_28711__$1 = (state_28747[(2)]);
var inst_28712 = (inst_28711__$1 == null);
var state_28747__$1 = (function (){var statearr_28755 = state_28747;
(statearr_28755[(7)] = inst_28711__$1);

return statearr_28755;
})();
if(cljs.core.truth_(inst_28712)){
var statearr_28757_30829 = state_28747__$1;
(statearr_28757_30829[(1)] = (5));

} else {
var statearr_28758_30830 = state_28747__$1;
(statearr_28758_30830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (15))){
var inst_28725 = (state_28747[(8)]);
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28747__$1,(18),to,inst_28725);
} else {
if((state_val_28748 === (21))){
var inst_28738 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
var statearr_28759_30833 = state_28747__$1;
(statearr_28759_30833[(2)] = inst_28738);

(statearr_28759_30833[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (13))){
var inst_28740 = (state_28747[(2)]);
var state_28747__$1 = (function (){var statearr_28760 = state_28747;
(statearr_28760[(9)] = inst_28740);

return statearr_28760;
})();
var statearr_28761_30836 = state_28747__$1;
(statearr_28761_30836[(2)] = null);

(statearr_28761_30836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (6))){
var inst_28711 = (state_28747[(7)]);
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28747__$1,(11),inst_28711);
} else {
if((state_val_28748 === (17))){
var inst_28733 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
if(cljs.core.truth_(inst_28733)){
var statearr_28772_30842 = state_28747__$1;
(statearr_28772_30842[(1)] = (19));

} else {
var statearr_28774_30845 = state_28747__$1;
(statearr_28774_30845[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (3))){
var inst_28745 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28747__$1,inst_28745);
} else {
if((state_val_28748 === (12))){
var inst_28722 = (state_28747[(10)]);
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28747__$1,(14),inst_28722);
} else {
if((state_val_28748 === (2))){
var state_28747__$1 = state_28747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28747__$1,(4),results);
} else {
if((state_val_28748 === (19))){
var state_28747__$1 = state_28747;
var statearr_28790_30847 = state_28747__$1;
(statearr_28790_30847[(2)] = null);

(statearr_28790_30847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (11))){
var inst_28722 = (state_28747[(2)]);
var state_28747__$1 = (function (){var statearr_28791 = state_28747;
(statearr_28791[(10)] = inst_28722);

return statearr_28791;
})();
var statearr_28792_30850 = state_28747__$1;
(statearr_28792_30850[(2)] = null);

(statearr_28792_30850[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (9))){
var state_28747__$1 = state_28747;
var statearr_28793_30852 = state_28747__$1;
(statearr_28793_30852[(2)] = null);

(statearr_28793_30852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (5))){
var state_28747__$1 = state_28747;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28794_30854 = state_28747__$1;
(statearr_28794_30854[(1)] = (8));

} else {
var statearr_28795_30856 = state_28747__$1;
(statearr_28795_30856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (14))){
var inst_28725 = (state_28747[(8)]);
var inst_28725__$1 = (state_28747[(2)]);
var inst_28726 = (inst_28725__$1 == null);
var inst_28727 = cljs.core.not(inst_28726);
var state_28747__$1 = (function (){var statearr_28801 = state_28747;
(statearr_28801[(8)] = inst_28725__$1);

return statearr_28801;
})();
if(inst_28727){
var statearr_28806_30860 = state_28747__$1;
(statearr_28806_30860[(1)] = (15));

} else {
var statearr_28807_30862 = state_28747__$1;
(statearr_28807_30862[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (16))){
var state_28747__$1 = state_28747;
var statearr_28815_30863 = state_28747__$1;
(statearr_28815_30863[(2)] = false);

(statearr_28815_30863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (10))){
var inst_28719 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
var statearr_28821_30866 = state_28747__$1;
(statearr_28821_30866[(2)] = inst_28719);

(statearr_28821_30866[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (18))){
var inst_28730 = (state_28747[(2)]);
var state_28747__$1 = state_28747;
var statearr_28822_30867 = state_28747__$1;
(statearr_28822_30867[(2)] = inst_28730);

(statearr_28822_30867[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28748 === (8))){
var inst_28716 = cljs.core.async.close_BANG_(to);
var state_28747__$1 = state_28747;
var statearr_28823_30871 = state_28747__$1;
(statearr_28823_30871[(2)] = inst_28716);

(statearr_28823_30871[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_28828 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28828[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__);

(statearr_28828[(1)] = (1));

return statearr_28828;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1 = (function (state_28747){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28747);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28834){if((e28834 instanceof Object)){
var ex__28141__auto__ = e28834;
var statearr_28837_30876 = state_28747;
(statearr_28837_30876[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28747);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28834;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30878 = state_28747;
state_28747 = G__30878;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__ = function(state_28747){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1.call(this,state_28747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28848 = f__28280__auto__();
(statearr_28848[(6)] = c__28279__auto__);

return statearr_28848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));

return c__28279__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28851 = arguments.length;
switch (G__28851) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28864 = arguments.length;
switch (G__28864) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28866 = arguments.length;
switch (G__28866) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28279__auto___30904 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28902){
var state_val_28903 = (state_28902[(1)]);
if((state_val_28903 === (7))){
var inst_28898 = (state_28902[(2)]);
var state_28902__$1 = state_28902;
var statearr_28912_30908 = state_28902__$1;
(statearr_28912_30908[(2)] = inst_28898);

(statearr_28912_30908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (1))){
var state_28902__$1 = state_28902;
var statearr_28915_30909 = state_28902__$1;
(statearr_28915_30909[(2)] = null);

(statearr_28915_30909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (4))){
var inst_28878 = (state_28902[(7)]);
var inst_28878__$1 = (state_28902[(2)]);
var inst_28879 = (inst_28878__$1 == null);
var state_28902__$1 = (function (){var statearr_28917 = state_28902;
(statearr_28917[(7)] = inst_28878__$1);

return statearr_28917;
})();
if(cljs.core.truth_(inst_28879)){
var statearr_28918_30910 = state_28902__$1;
(statearr_28918_30910[(1)] = (5));

} else {
var statearr_28919_30914 = state_28902__$1;
(statearr_28919_30914[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (13))){
var state_28902__$1 = state_28902;
var statearr_28920_30915 = state_28902__$1;
(statearr_28920_30915[(2)] = null);

(statearr_28920_30915[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (6))){
var inst_28878 = (state_28902[(7)]);
var inst_28884 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28878) : p.call(null,inst_28878));
var state_28902__$1 = state_28902;
if(cljs.core.truth_(inst_28884)){
var statearr_28921_30916 = state_28902__$1;
(statearr_28921_30916[(1)] = (9));

} else {
var statearr_28922_30917 = state_28902__$1;
(statearr_28922_30917[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (3))){
var inst_28900 = (state_28902[(2)]);
var state_28902__$1 = state_28902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28902__$1,inst_28900);
} else {
if((state_val_28903 === (12))){
var state_28902__$1 = state_28902;
var statearr_28923_30920 = state_28902__$1;
(statearr_28923_30920[(2)] = null);

(statearr_28923_30920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (2))){
var state_28902__$1 = state_28902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28902__$1,(4),ch);
} else {
if((state_val_28903 === (11))){
var inst_28878 = (state_28902[(7)]);
var inst_28888 = (state_28902[(2)]);
var state_28902__$1 = state_28902;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28902__$1,(8),inst_28888,inst_28878);
} else {
if((state_val_28903 === (9))){
var state_28902__$1 = state_28902;
var statearr_28927_30922 = state_28902__$1;
(statearr_28927_30922[(2)] = tc);

(statearr_28927_30922[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (5))){
var inst_28881 = cljs.core.async.close_BANG_(tc);
var inst_28882 = cljs.core.async.close_BANG_(fc);
var state_28902__$1 = (function (){var statearr_28928 = state_28902;
(statearr_28928[(8)] = inst_28881);

return statearr_28928;
})();
var statearr_28929_30925 = state_28902__$1;
(statearr_28929_30925[(2)] = inst_28882);

(statearr_28929_30925[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (14))){
var inst_28896 = (state_28902[(2)]);
var state_28902__$1 = state_28902;
var statearr_28930_30926 = state_28902__$1;
(statearr_28930_30926[(2)] = inst_28896);

(statearr_28930_30926[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (10))){
var state_28902__$1 = state_28902;
var statearr_28932_30927 = state_28902__$1;
(statearr_28932_30927[(2)] = fc);

(statearr_28932_30927[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28903 === (8))){
var inst_28890 = (state_28902[(2)]);
var state_28902__$1 = state_28902;
if(cljs.core.truth_(inst_28890)){
var statearr_28933_30929 = state_28902__$1;
(statearr_28933_30929[(1)] = (12));

} else {
var statearr_28934_30930 = state_28902__$1;
(statearr_28934_30930[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_28935 = [null,null,null,null,null,null,null,null,null];
(statearr_28935[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_28935[(1)] = (1));

return statearr_28935;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_28902){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28902);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28936){if((e28936 instanceof Object)){
var ex__28141__auto__ = e28936;
var statearr_28937_30933 = state_28902;
(statearr_28937_30933[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28902);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28936;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30935 = state_28902;
state_28902 = G__30935;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_28902){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_28902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28938 = f__28280__auto__();
(statearr_28938[(6)] = c__28279__auto___30904);

return statearr_28938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28279__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28962){
var state_val_28963 = (state_28962[(1)]);
if((state_val_28963 === (7))){
var inst_28957 = (state_28962[(2)]);
var state_28962__$1 = state_28962;
var statearr_28964_30939 = state_28962__$1;
(statearr_28964_30939[(2)] = inst_28957);

(statearr_28964_30939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (1))){
var inst_28939 = init;
var state_28962__$1 = (function (){var statearr_28965 = state_28962;
(statearr_28965[(7)] = inst_28939);

return statearr_28965;
})();
var statearr_28966_30941 = state_28962__$1;
(statearr_28966_30941[(2)] = null);

(statearr_28966_30941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (4))){
var inst_28942 = (state_28962[(8)]);
var inst_28942__$1 = (state_28962[(2)]);
var inst_28943 = (inst_28942__$1 == null);
var state_28962__$1 = (function (){var statearr_28967 = state_28962;
(statearr_28967[(8)] = inst_28942__$1);

return statearr_28967;
})();
if(cljs.core.truth_(inst_28943)){
var statearr_28968_30944 = state_28962__$1;
(statearr_28968_30944[(1)] = (5));

} else {
var statearr_28969_30945 = state_28962__$1;
(statearr_28969_30945[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (6))){
var inst_28939 = (state_28962[(7)]);
var inst_28947 = (state_28962[(9)]);
var inst_28942 = (state_28962[(8)]);
var inst_28947__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_28939,inst_28942) : f.call(null,inst_28939,inst_28942));
var inst_28948 = cljs.core.reduced_QMARK_(inst_28947__$1);
var state_28962__$1 = (function (){var statearr_28970 = state_28962;
(statearr_28970[(9)] = inst_28947__$1);

return statearr_28970;
})();
if(inst_28948){
var statearr_28971_30946 = state_28962__$1;
(statearr_28971_30946[(1)] = (8));

} else {
var statearr_28972_30949 = state_28962__$1;
(statearr_28972_30949[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (3))){
var inst_28960 = (state_28962[(2)]);
var state_28962__$1 = state_28962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28962__$1,inst_28960);
} else {
if((state_val_28963 === (2))){
var state_28962__$1 = state_28962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28962__$1,(4),ch);
} else {
if((state_val_28963 === (9))){
var inst_28947 = (state_28962[(9)]);
var inst_28939 = inst_28947;
var state_28962__$1 = (function (){var statearr_28973 = state_28962;
(statearr_28973[(7)] = inst_28939);

return statearr_28973;
})();
var statearr_28974_30954 = state_28962__$1;
(statearr_28974_30954[(2)] = null);

(statearr_28974_30954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (5))){
var inst_28939 = (state_28962[(7)]);
var state_28962__$1 = state_28962;
var statearr_28975_30956 = state_28962__$1;
(statearr_28975_30956[(2)] = inst_28939);

(statearr_28975_30956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (10))){
var inst_28955 = (state_28962[(2)]);
var state_28962__$1 = state_28962;
var statearr_28976_30957 = state_28962__$1;
(statearr_28976_30957[(2)] = inst_28955);

(statearr_28976_30957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28963 === (8))){
var inst_28947 = (state_28962[(9)]);
var inst_28951 = cljs.core.deref(inst_28947);
var state_28962__$1 = state_28962;
var statearr_28977_30958 = state_28962__$1;
(statearr_28977_30958[(2)] = inst_28951);

(statearr_28977_30958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28138__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28138__auto____0 = (function (){
var statearr_28978 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28978[(0)] = cljs$core$async$reduce_$_state_machine__28138__auto__);

(statearr_28978[(1)] = (1));

return statearr_28978;
});
var cljs$core$async$reduce_$_state_machine__28138__auto____1 = (function (state_28962){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28962);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28979){if((e28979 instanceof Object)){
var ex__28141__auto__ = e28979;
var statearr_28980_30960 = state_28962;
(statearr_28980_30960[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28962);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28979;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30961 = state_28962;
state_28962 = G__30961;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28138__auto__ = function(state_28962){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28138__auto____1.call(this,state_28962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28138__auto____0;
cljs$core$async$reduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28138__auto____1;
return cljs$core$async$reduce_$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28982 = f__28280__auto__();
(statearr_28982[(6)] = c__28279__auto__);

return statearr_28982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));

return c__28279__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28279__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_28989){
var state_val_28990 = (state_28989[(1)]);
if((state_val_28990 === (1))){
var inst_28984 = cljs.core.async.reduce(f__$1,init,ch);
var state_28989__$1 = state_28989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28989__$1,(2),inst_28984);
} else {
if((state_val_28990 === (2))){
var inst_28986 = (state_28989[(2)]);
var inst_28987 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_28986) : f__$1.call(null,inst_28986));
var state_28989__$1 = state_28989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28989__$1,inst_28987);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28138__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28138__auto____0 = (function (){
var statearr_28991 = [null,null,null,null,null,null,null];
(statearr_28991[(0)] = cljs$core$async$transduce_$_state_machine__28138__auto__);

(statearr_28991[(1)] = (1));

return statearr_28991;
});
var cljs$core$async$transduce_$_state_machine__28138__auto____1 = (function (state_28989){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_28989);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e28992){if((e28992 instanceof Object)){
var ex__28141__auto__ = e28992;
var statearr_28993_30964 = state_28989;
(statearr_28993_30964[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28992;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30967 = state_28989;
state_28989 = G__30967;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28138__auto__ = function(state_28989){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28138__auto____1.call(this,state_28989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28138__auto____0;
cljs$core$async$transduce_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28138__auto____1;
return cljs$core$async$transduce_$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_28994 = f__28280__auto__();
(statearr_28994[(6)] = c__28279__auto__);

return statearr_28994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));

return c__28279__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__28996 = arguments.length;
switch (G__28996) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28279__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29021){
var state_val_29022 = (state_29021[(1)]);
if((state_val_29022 === (7))){
var inst_29003 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
var statearr_29024_30975 = state_29021__$1;
(statearr_29024_30975[(2)] = inst_29003);

(statearr_29024_30975[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (1))){
var inst_28997 = cljs.core.seq(coll);
var inst_28998 = inst_28997;
var state_29021__$1 = (function (){var statearr_29025 = state_29021;
(statearr_29025[(7)] = inst_28998);

return statearr_29025;
})();
var statearr_29026_30976 = state_29021__$1;
(statearr_29026_30976[(2)] = null);

(statearr_29026_30976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (4))){
var inst_28998 = (state_29021[(7)]);
var inst_29001 = cljs.core.first(inst_28998);
var state_29021__$1 = state_29021;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29021__$1,(7),ch,inst_29001);
} else {
if((state_val_29022 === (13))){
var inst_29015 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
var statearr_29028_30979 = state_29021__$1;
(statearr_29028_30979[(2)] = inst_29015);

(statearr_29028_30979[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (6))){
var inst_29006 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
if(cljs.core.truth_(inst_29006)){
var statearr_29029_30980 = state_29021__$1;
(statearr_29029_30980[(1)] = (8));

} else {
var statearr_29030_30981 = state_29021__$1;
(statearr_29030_30981[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (3))){
var inst_29019 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29021__$1,inst_29019);
} else {
if((state_val_29022 === (12))){
var state_29021__$1 = state_29021;
var statearr_29031_30987 = state_29021__$1;
(statearr_29031_30987[(2)] = null);

(statearr_29031_30987[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (2))){
var inst_28998 = (state_29021[(7)]);
var state_29021__$1 = state_29021;
if(cljs.core.truth_(inst_28998)){
var statearr_29032_30988 = state_29021__$1;
(statearr_29032_30988[(1)] = (4));

} else {
var statearr_29033_30989 = state_29021__$1;
(statearr_29033_30989[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (11))){
var inst_29012 = cljs.core.async.close_BANG_(ch);
var state_29021__$1 = state_29021;
var statearr_29034_30990 = state_29021__$1;
(statearr_29034_30990[(2)] = inst_29012);

(statearr_29034_30990[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (9))){
var state_29021__$1 = state_29021;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29035_30993 = state_29021__$1;
(statearr_29035_30993[(1)] = (11));

} else {
var statearr_29037_30994 = state_29021__$1;
(statearr_29037_30994[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (5))){
var inst_28998 = (state_29021[(7)]);
var state_29021__$1 = state_29021;
var statearr_29041_30995 = state_29021__$1;
(statearr_29041_30995[(2)] = inst_28998);

(statearr_29041_30995[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (10))){
var inst_29017 = (state_29021[(2)]);
var state_29021__$1 = state_29021;
var statearr_29042_30996 = state_29021__$1;
(statearr_29042_30996[(2)] = inst_29017);

(statearr_29042_30996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29022 === (8))){
var inst_28998 = (state_29021[(7)]);
var inst_29008 = cljs.core.next(inst_28998);
var inst_28998__$1 = inst_29008;
var state_29021__$1 = (function (){var statearr_29043 = state_29021;
(statearr_29043[(7)] = inst_28998__$1);

return statearr_29043;
})();
var statearr_29044_31001 = state_29021__$1;
(statearr_29044_31001[(2)] = null);

(statearr_29044_31001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29045 = [null,null,null,null,null,null,null,null];
(statearr_29045[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29045[(1)] = (1));

return statearr_29045;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29021){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29021);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29046){if((e29046 instanceof Object)){
var ex__28141__auto__ = e29046;
var statearr_29047_31004 = state_29021;
(statearr_29047_31004[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29021);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29046;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31008 = state_29021;
state_29021 = G__31008;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29021){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_29048 = f__28280__auto__();
(statearr_29048[(6)] = c__28279__auto__);

return statearr_29048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));

return c__28279__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31013 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31013(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31028 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31028(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31046 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31046(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31057 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31057(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29059 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29059 = (function (ch,cs,meta29060){
this.ch = ch;
this.cs = cs;
this.meta29060 = meta29060;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29061,meta29060__$1){
var self__ = this;
var _29061__$1 = this;
return (new cljs.core.async.t_cljs$core$async29059(self__.ch,self__.cs,meta29060__$1));
}));

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29061){
var self__ = this;
var _29061__$1 = this;
return self__.meta29060;
}));

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29059.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29059.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29060","meta29060",1566943573,null)], null);
}));

(cljs.core.async.t_cljs$core$async29059.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29059.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29059");

(cljs.core.async.t_cljs$core$async29059.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29059");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29059.
 */
cljs.core.async.__GT_t_cljs$core$async29059 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29059(ch__$1,cs__$1,meta29060){
return (new cljs.core.async.t_cljs$core$async29059(ch__$1,cs__$1,meta29060));
});

}

return (new cljs.core.async.t_cljs$core$async29059(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28279__auto___31083 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29223){
var state_val_29224 = (state_29223[(1)]);
if((state_val_29224 === (7))){
var inst_29216 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29225_31088 = state_29223__$1;
(statearr_29225_31088[(2)] = inst_29216);

(statearr_29225_31088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (20))){
var inst_29116 = (state_29223[(7)]);
var inst_29128 = cljs.core.first(inst_29116);
var inst_29129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29128,(0),null);
var inst_29130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29128,(1),null);
var state_29223__$1 = (function (){var statearr_29226 = state_29223;
(statearr_29226[(8)] = inst_29129);

return statearr_29226;
})();
if(cljs.core.truth_(inst_29130)){
var statearr_29227_31089 = state_29223__$1;
(statearr_29227_31089[(1)] = (22));

} else {
var statearr_29228_31090 = state_29223__$1;
(statearr_29228_31090[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (27))){
var inst_29161 = (state_29223[(9)]);
var inst_29085 = (state_29223[(10)]);
var inst_29168 = (state_29223[(11)]);
var inst_29163 = (state_29223[(12)]);
var inst_29168__$1 = cljs.core._nth(inst_29161,inst_29163);
var inst_29169 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29168__$1,inst_29085,done);
var state_29223__$1 = (function (){var statearr_29229 = state_29223;
(statearr_29229[(11)] = inst_29168__$1);

return statearr_29229;
})();
if(cljs.core.truth_(inst_29169)){
var statearr_29230_31093 = state_29223__$1;
(statearr_29230_31093[(1)] = (30));

} else {
var statearr_29231_31094 = state_29223__$1;
(statearr_29231_31094[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (1))){
var state_29223__$1 = state_29223;
var statearr_29235_31095 = state_29223__$1;
(statearr_29235_31095[(2)] = null);

(statearr_29235_31095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (24))){
var inst_29116 = (state_29223[(7)]);
var inst_29135 = (state_29223[(2)]);
var inst_29136 = cljs.core.next(inst_29116);
var inst_29094 = inst_29136;
var inst_29095 = null;
var inst_29096 = (0);
var inst_29097 = (0);
var state_29223__$1 = (function (){var statearr_29236 = state_29223;
(statearr_29236[(13)] = inst_29094);

(statearr_29236[(14)] = inst_29096);

(statearr_29236[(15)] = inst_29135);

(statearr_29236[(16)] = inst_29095);

(statearr_29236[(17)] = inst_29097);

return statearr_29236;
})();
var statearr_29237_31100 = state_29223__$1;
(statearr_29237_31100[(2)] = null);

(statearr_29237_31100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (39))){
var state_29223__$1 = state_29223;
var statearr_29244_31101 = state_29223__$1;
(statearr_29244_31101[(2)] = null);

(statearr_29244_31101[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (4))){
var inst_29085 = (state_29223[(10)]);
var inst_29085__$1 = (state_29223[(2)]);
var inst_29086 = (inst_29085__$1 == null);
var state_29223__$1 = (function (){var statearr_29245 = state_29223;
(statearr_29245[(10)] = inst_29085__$1);

return statearr_29245;
})();
if(cljs.core.truth_(inst_29086)){
var statearr_29246_31104 = state_29223__$1;
(statearr_29246_31104[(1)] = (5));

} else {
var statearr_29247_31105 = state_29223__$1;
(statearr_29247_31105[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (15))){
var inst_29094 = (state_29223[(13)]);
var inst_29096 = (state_29223[(14)]);
var inst_29095 = (state_29223[(16)]);
var inst_29097 = (state_29223[(17)]);
var inst_29112 = (state_29223[(2)]);
var inst_29113 = (inst_29097 + (1));
var tmp29238 = inst_29094;
var tmp29239 = inst_29096;
var tmp29240 = inst_29095;
var inst_29094__$1 = tmp29238;
var inst_29095__$1 = tmp29240;
var inst_29096__$1 = tmp29239;
var inst_29097__$1 = inst_29113;
var state_29223__$1 = (function (){var statearr_29248 = state_29223;
(statearr_29248[(13)] = inst_29094__$1);

(statearr_29248[(18)] = inst_29112);

(statearr_29248[(14)] = inst_29096__$1);

(statearr_29248[(16)] = inst_29095__$1);

(statearr_29248[(17)] = inst_29097__$1);

return statearr_29248;
})();
var statearr_29250_31111 = state_29223__$1;
(statearr_29250_31111[(2)] = null);

(statearr_29250_31111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (21))){
var inst_29139 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29257_31115 = state_29223__$1;
(statearr_29257_31115[(2)] = inst_29139);

(statearr_29257_31115[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (31))){
var inst_29168 = (state_29223[(11)]);
var inst_29172 = done(null);
var inst_29173 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29168);
var state_29223__$1 = (function (){var statearr_29258 = state_29223;
(statearr_29258[(19)] = inst_29172);

return statearr_29258;
})();
var statearr_29259_31116 = state_29223__$1;
(statearr_29259_31116[(2)] = inst_29173);

(statearr_29259_31116[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (32))){
var inst_29161 = (state_29223[(9)]);
var inst_29162 = (state_29223[(20)]);
var inst_29160 = (state_29223[(21)]);
var inst_29163 = (state_29223[(12)]);
var inst_29175 = (state_29223[(2)]);
var inst_29176 = (inst_29163 + (1));
var tmp29254 = inst_29161;
var tmp29255 = inst_29162;
var tmp29256 = inst_29160;
var inst_29160__$1 = tmp29256;
var inst_29161__$1 = tmp29254;
var inst_29162__$1 = tmp29255;
var inst_29163__$1 = inst_29176;
var state_29223__$1 = (function (){var statearr_29261 = state_29223;
(statearr_29261[(9)] = inst_29161__$1);

(statearr_29261[(20)] = inst_29162__$1);

(statearr_29261[(21)] = inst_29160__$1);

(statearr_29261[(22)] = inst_29175);

(statearr_29261[(12)] = inst_29163__$1);

return statearr_29261;
})();
var statearr_29265_31118 = state_29223__$1;
(statearr_29265_31118[(2)] = null);

(statearr_29265_31118[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (40))){
var inst_29188 = (state_29223[(23)]);
var inst_29192 = done(null);
var inst_29193 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29188);
var state_29223__$1 = (function (){var statearr_29266 = state_29223;
(statearr_29266[(24)] = inst_29192);

return statearr_29266;
})();
var statearr_29267_31119 = state_29223__$1;
(statearr_29267_31119[(2)] = inst_29193);

(statearr_29267_31119[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (33))){
var inst_29179 = (state_29223[(25)]);
var inst_29181 = cljs.core.chunked_seq_QMARK_(inst_29179);
var state_29223__$1 = state_29223;
if(inst_29181){
var statearr_29268_31120 = state_29223__$1;
(statearr_29268_31120[(1)] = (36));

} else {
var statearr_29269_31121 = state_29223__$1;
(statearr_29269_31121[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (13))){
var inst_29106 = (state_29223[(26)]);
var inst_29109 = cljs.core.async.close_BANG_(inst_29106);
var state_29223__$1 = state_29223;
var statearr_29271_31122 = state_29223__$1;
(statearr_29271_31122[(2)] = inst_29109);

(statearr_29271_31122[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (22))){
var inst_29129 = (state_29223[(8)]);
var inst_29132 = cljs.core.async.close_BANG_(inst_29129);
var state_29223__$1 = state_29223;
var statearr_29272_31123 = state_29223__$1;
(statearr_29272_31123[(2)] = inst_29132);

(statearr_29272_31123[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (36))){
var inst_29179 = (state_29223[(25)]);
var inst_29183 = cljs.core.chunk_first(inst_29179);
var inst_29184 = cljs.core.chunk_rest(inst_29179);
var inst_29185 = cljs.core.count(inst_29183);
var inst_29160 = inst_29184;
var inst_29161 = inst_29183;
var inst_29162 = inst_29185;
var inst_29163 = (0);
var state_29223__$1 = (function (){var statearr_29273 = state_29223;
(statearr_29273[(9)] = inst_29161);

(statearr_29273[(20)] = inst_29162);

(statearr_29273[(21)] = inst_29160);

(statearr_29273[(12)] = inst_29163);

return statearr_29273;
})();
var statearr_29274_31124 = state_29223__$1;
(statearr_29274_31124[(2)] = null);

(statearr_29274_31124[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (41))){
var inst_29179 = (state_29223[(25)]);
var inst_29195 = (state_29223[(2)]);
var inst_29196 = cljs.core.next(inst_29179);
var inst_29160 = inst_29196;
var inst_29161 = null;
var inst_29162 = (0);
var inst_29163 = (0);
var state_29223__$1 = (function (){var statearr_29276 = state_29223;
(statearr_29276[(9)] = inst_29161);

(statearr_29276[(20)] = inst_29162);

(statearr_29276[(27)] = inst_29195);

(statearr_29276[(21)] = inst_29160);

(statearr_29276[(12)] = inst_29163);

return statearr_29276;
})();
var statearr_29280_31125 = state_29223__$1;
(statearr_29280_31125[(2)] = null);

(statearr_29280_31125[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (43))){
var state_29223__$1 = state_29223;
var statearr_29284_31139 = state_29223__$1;
(statearr_29284_31139[(2)] = null);

(statearr_29284_31139[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (29))){
var inst_29204 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29285_31146 = state_29223__$1;
(statearr_29285_31146[(2)] = inst_29204);

(statearr_29285_31146[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (44))){
var inst_29213 = (state_29223[(2)]);
var state_29223__$1 = (function (){var statearr_29286 = state_29223;
(statearr_29286[(28)] = inst_29213);

return statearr_29286;
})();
var statearr_29287_31166 = state_29223__$1;
(statearr_29287_31166[(2)] = null);

(statearr_29287_31166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (6))){
var inst_29149 = (state_29223[(29)]);
var inst_29148 = cljs.core.deref(cs);
var inst_29149__$1 = cljs.core.keys(inst_29148);
var inst_29150 = cljs.core.count(inst_29149__$1);
var inst_29151 = cljs.core.reset_BANG_(dctr,inst_29150);
var inst_29159 = cljs.core.seq(inst_29149__$1);
var inst_29160 = inst_29159;
var inst_29161 = null;
var inst_29162 = (0);
var inst_29163 = (0);
var state_29223__$1 = (function (){var statearr_29288 = state_29223;
(statearr_29288[(9)] = inst_29161);

(statearr_29288[(20)] = inst_29162);

(statearr_29288[(30)] = inst_29151);

(statearr_29288[(29)] = inst_29149__$1);

(statearr_29288[(21)] = inst_29160);

(statearr_29288[(12)] = inst_29163);

return statearr_29288;
})();
var statearr_29289_31182 = state_29223__$1;
(statearr_29289_31182[(2)] = null);

(statearr_29289_31182[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (28))){
var inst_29160 = (state_29223[(21)]);
var inst_29179 = (state_29223[(25)]);
var inst_29179__$1 = cljs.core.seq(inst_29160);
var state_29223__$1 = (function (){var statearr_29290 = state_29223;
(statearr_29290[(25)] = inst_29179__$1);

return statearr_29290;
})();
if(inst_29179__$1){
var statearr_29291_31193 = state_29223__$1;
(statearr_29291_31193[(1)] = (33));

} else {
var statearr_29292_31195 = state_29223__$1;
(statearr_29292_31195[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (25))){
var inst_29162 = (state_29223[(20)]);
var inst_29163 = (state_29223[(12)]);
var inst_29165 = (inst_29163 < inst_29162);
var inst_29166 = inst_29165;
var state_29223__$1 = state_29223;
if(cljs.core.truth_(inst_29166)){
var statearr_29293_31214 = state_29223__$1;
(statearr_29293_31214[(1)] = (27));

} else {
var statearr_29294_31216 = state_29223__$1;
(statearr_29294_31216[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (34))){
var state_29223__$1 = state_29223;
var statearr_29295_31218 = state_29223__$1;
(statearr_29295_31218[(2)] = null);

(statearr_29295_31218[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (17))){
var state_29223__$1 = state_29223;
var statearr_29296_31219 = state_29223__$1;
(statearr_29296_31219[(2)] = null);

(statearr_29296_31219[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (3))){
var inst_29218 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29223__$1,inst_29218);
} else {
if((state_val_29224 === (12))){
var inst_29144 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29297_31220 = state_29223__$1;
(statearr_29297_31220[(2)] = inst_29144);

(statearr_29297_31220[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (2))){
var state_29223__$1 = state_29223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29223__$1,(4),ch);
} else {
if((state_val_29224 === (23))){
var state_29223__$1 = state_29223;
var statearr_29298_31226 = state_29223__$1;
(statearr_29298_31226[(2)] = null);

(statearr_29298_31226[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (35))){
var inst_29202 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29299_31230 = state_29223__$1;
(statearr_29299_31230[(2)] = inst_29202);

(statearr_29299_31230[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (19))){
var inst_29116 = (state_29223[(7)]);
var inst_29120 = cljs.core.chunk_first(inst_29116);
var inst_29121 = cljs.core.chunk_rest(inst_29116);
var inst_29122 = cljs.core.count(inst_29120);
var inst_29094 = inst_29121;
var inst_29095 = inst_29120;
var inst_29096 = inst_29122;
var inst_29097 = (0);
var state_29223__$1 = (function (){var statearr_29300 = state_29223;
(statearr_29300[(13)] = inst_29094);

(statearr_29300[(14)] = inst_29096);

(statearr_29300[(16)] = inst_29095);

(statearr_29300[(17)] = inst_29097);

return statearr_29300;
})();
var statearr_29301_31233 = state_29223__$1;
(statearr_29301_31233[(2)] = null);

(statearr_29301_31233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (11))){
var inst_29116 = (state_29223[(7)]);
var inst_29094 = (state_29223[(13)]);
var inst_29116__$1 = cljs.core.seq(inst_29094);
var state_29223__$1 = (function (){var statearr_29304 = state_29223;
(statearr_29304[(7)] = inst_29116__$1);

return statearr_29304;
})();
if(inst_29116__$1){
var statearr_29305_31235 = state_29223__$1;
(statearr_29305_31235[(1)] = (16));

} else {
var statearr_29306_31236 = state_29223__$1;
(statearr_29306_31236[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (9))){
var inst_29146 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29307_31237 = state_29223__$1;
(statearr_29307_31237[(2)] = inst_29146);

(statearr_29307_31237[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (5))){
var inst_29092 = cljs.core.deref(cs);
var inst_29093 = cljs.core.seq(inst_29092);
var inst_29094 = inst_29093;
var inst_29095 = null;
var inst_29096 = (0);
var inst_29097 = (0);
var state_29223__$1 = (function (){var statearr_29308 = state_29223;
(statearr_29308[(13)] = inst_29094);

(statearr_29308[(14)] = inst_29096);

(statearr_29308[(16)] = inst_29095);

(statearr_29308[(17)] = inst_29097);

return statearr_29308;
})();
var statearr_29309_31239 = state_29223__$1;
(statearr_29309_31239[(2)] = null);

(statearr_29309_31239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (14))){
var state_29223__$1 = state_29223;
var statearr_29310_31241 = state_29223__$1;
(statearr_29310_31241[(2)] = null);

(statearr_29310_31241[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (45))){
var inst_29210 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29311_31243 = state_29223__$1;
(statearr_29311_31243[(2)] = inst_29210);

(statearr_29311_31243[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (26))){
var inst_29149 = (state_29223[(29)]);
var inst_29206 = (state_29223[(2)]);
var inst_29207 = cljs.core.seq(inst_29149);
var state_29223__$1 = (function (){var statearr_29312 = state_29223;
(statearr_29312[(31)] = inst_29206);

return statearr_29312;
})();
if(inst_29207){
var statearr_29313_31247 = state_29223__$1;
(statearr_29313_31247[(1)] = (42));

} else {
var statearr_29314_31248 = state_29223__$1;
(statearr_29314_31248[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (16))){
var inst_29116 = (state_29223[(7)]);
var inst_29118 = cljs.core.chunked_seq_QMARK_(inst_29116);
var state_29223__$1 = state_29223;
if(inst_29118){
var statearr_29320_31250 = state_29223__$1;
(statearr_29320_31250[(1)] = (19));

} else {
var statearr_29321_31251 = state_29223__$1;
(statearr_29321_31251[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (38))){
var inst_29199 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29322_31253 = state_29223__$1;
(statearr_29322_31253[(2)] = inst_29199);

(statearr_29322_31253[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (30))){
var state_29223__$1 = state_29223;
var statearr_29323_31256 = state_29223__$1;
(statearr_29323_31256[(2)] = null);

(statearr_29323_31256[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (10))){
var inst_29095 = (state_29223[(16)]);
var inst_29097 = (state_29223[(17)]);
var inst_29105 = cljs.core._nth(inst_29095,inst_29097);
var inst_29106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29105,(0),null);
var inst_29107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29105,(1),null);
var state_29223__$1 = (function (){var statearr_29325 = state_29223;
(statearr_29325[(26)] = inst_29106);

return statearr_29325;
})();
if(cljs.core.truth_(inst_29107)){
var statearr_29326_31259 = state_29223__$1;
(statearr_29326_31259[(1)] = (13));

} else {
var statearr_29327_31260 = state_29223__$1;
(statearr_29327_31260[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (18))){
var inst_29142 = (state_29223[(2)]);
var state_29223__$1 = state_29223;
var statearr_29329_31262 = state_29223__$1;
(statearr_29329_31262[(2)] = inst_29142);

(statearr_29329_31262[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (42))){
var state_29223__$1 = state_29223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29223__$1,(45),dchan);
} else {
if((state_val_29224 === (37))){
var inst_29188 = (state_29223[(23)]);
var inst_29085 = (state_29223[(10)]);
var inst_29179 = (state_29223[(25)]);
var inst_29188__$1 = cljs.core.first(inst_29179);
var inst_29189 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29188__$1,inst_29085,done);
var state_29223__$1 = (function (){var statearr_29333 = state_29223;
(statearr_29333[(23)] = inst_29188__$1);

return statearr_29333;
})();
if(cljs.core.truth_(inst_29189)){
var statearr_29334_31267 = state_29223__$1;
(statearr_29334_31267[(1)] = (39));

} else {
var statearr_29335_31271 = state_29223__$1;
(statearr_29335_31271[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29224 === (8))){
var inst_29096 = (state_29223[(14)]);
var inst_29097 = (state_29223[(17)]);
var inst_29099 = (inst_29097 < inst_29096);
var inst_29100 = inst_29099;
var state_29223__$1 = state_29223;
if(cljs.core.truth_(inst_29100)){
var statearr_29336_31273 = state_29223__$1;
(statearr_29336_31273[(1)] = (10));

} else {
var statearr_29337_31275 = state_29223__$1;
(statearr_29337_31275[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28138__auto__ = null;
var cljs$core$async$mult_$_state_machine__28138__auto____0 = (function (){
var statearr_29338 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29338[(0)] = cljs$core$async$mult_$_state_machine__28138__auto__);

(statearr_29338[(1)] = (1));

return statearr_29338;
});
var cljs$core$async$mult_$_state_machine__28138__auto____1 = (function (state_29223){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29223);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29339){if((e29339 instanceof Object)){
var ex__28141__auto__ = e29339;
var statearr_29340_31284 = state_29223;
(statearr_29340_31284[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29339;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31291 = state_29223;
state_29223 = G__31291;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28138__auto__ = function(state_29223){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28138__auto____1.call(this,state_29223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28138__auto____0;
cljs$core$async$mult_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28138__auto____1;
return cljs$core$async$mult_$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_29341 = f__28280__auto__();
(statearr_29341[(6)] = c__28279__auto___31083);

return statearr_29341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29343 = arguments.length;
switch (G__29343) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31308 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31308(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31310 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31310(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31314 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31314(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31316 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31316(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31325 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31325(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31355 = arguments.length;
var i__4737__auto___31359 = (0);
while(true){
if((i__4737__auto___31359 < len__4736__auto___31355)){
args__4742__auto__.push((arguments[i__4737__auto___31359]));

var G__31363 = (i__4737__auto___31359 + (1));
i__4737__auto___31359 = G__31363;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29362){
var map__29363 = p__29362;
var map__29363__$1 = (((((!((map__29363 == null))))?(((((map__29363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29363):map__29363);
var opts = map__29363__$1;
var statearr_29365_31397 = state;
(statearr_29365_31397[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29366_31398 = state;
(statearr_29366_31398[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_29367_31399 = state;
(statearr_29367_31399[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29358){
var G__29359 = cljs.core.first(seq29358);
var seq29358__$1 = cljs.core.next(seq29358);
var G__29360 = cljs.core.first(seq29358__$1);
var seq29358__$2 = cljs.core.next(seq29358__$1);
var G__29361 = cljs.core.first(seq29358__$2);
var seq29358__$3 = cljs.core.next(seq29358__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29359,G__29360,G__29361,seq29358__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29369 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29369 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29370){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29370 = meta29370;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29371,meta29370__$1){
var self__ = this;
var _29371__$1 = this;
return (new cljs.core.async.t_cljs$core$async29369(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29370__$1));
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29371){
var self__ = this;
var _29371__$1 = this;
return self__.meta29370;
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29369.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29369.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29370","meta29370",-94849514,null)], null);
}));

(cljs.core.async.t_cljs$core$async29369.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29369.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29369");

(cljs.core.async.t_cljs$core$async29369.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29369");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29369.
 */
cljs.core.async.__GT_t_cljs$core$async29369 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29369(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29370){
return (new cljs.core.async.t_cljs$core$async29369(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29370));
});

}

return (new cljs.core.async.t_cljs$core$async29369(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28279__auto___31433 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29502){
var state_val_29503 = (state_29502[(1)]);
if((state_val_29503 === (7))){
var inst_29405 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
var statearr_29504_31435 = state_29502__$1;
(statearr_29504_31435[(2)] = inst_29405);

(statearr_29504_31435[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (20))){
var inst_29420 = (state_29502[(7)]);
var state_29502__$1 = state_29502;
var statearr_29506_31437 = state_29502__$1;
(statearr_29506_31437[(2)] = inst_29420);

(statearr_29506_31437[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (27))){
var state_29502__$1 = state_29502;
var statearr_29513_31442 = state_29502__$1;
(statearr_29513_31442[(2)] = null);

(statearr_29513_31442[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (1))){
var inst_29391 = (state_29502[(8)]);
var inst_29391__$1 = calc_state();
var inst_29393 = (inst_29391__$1 == null);
var inst_29394 = cljs.core.not(inst_29393);
var state_29502__$1 = (function (){var statearr_29514 = state_29502;
(statearr_29514[(8)] = inst_29391__$1);

return statearr_29514;
})();
if(inst_29394){
var statearr_29515_31444 = state_29502__$1;
(statearr_29515_31444[(1)] = (2));

} else {
var statearr_29516_31446 = state_29502__$1;
(statearr_29516_31446[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (24))){
var inst_29457 = (state_29502[(9)]);
var inst_29448 = (state_29502[(10)]);
var inst_29471 = (state_29502[(11)]);
var inst_29471__$1 = (inst_29448.cljs$core$IFn$_invoke$arity$1 ? inst_29448.cljs$core$IFn$_invoke$arity$1(inst_29457) : inst_29448.call(null,inst_29457));
var state_29502__$1 = (function (){var statearr_29517 = state_29502;
(statearr_29517[(11)] = inst_29471__$1);

return statearr_29517;
})();
if(cljs.core.truth_(inst_29471__$1)){
var statearr_29518_31452 = state_29502__$1;
(statearr_29518_31452[(1)] = (29));

} else {
var statearr_29519_31453 = state_29502__$1;
(statearr_29519_31453[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (4))){
var inst_29408 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29408)){
var statearr_29521_31457 = state_29502__$1;
(statearr_29521_31457[(1)] = (8));

} else {
var statearr_29522_31458 = state_29502__$1;
(statearr_29522_31458[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (15))){
var inst_29442 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29442)){
var statearr_29523_31460 = state_29502__$1;
(statearr_29523_31460[(1)] = (19));

} else {
var statearr_29524_31461 = state_29502__$1;
(statearr_29524_31461[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (21))){
var inst_29447 = (state_29502[(12)]);
var inst_29447__$1 = (state_29502[(2)]);
var inst_29448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29447__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29447__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29447__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29502__$1 = (function (){var statearr_29525 = state_29502;
(statearr_29525[(13)] = inst_29449);

(statearr_29525[(12)] = inst_29447__$1);

(statearr_29525[(10)] = inst_29448);

return statearr_29525;
})();
return cljs.core.async.ioc_alts_BANG_(state_29502__$1,(22),inst_29450);
} else {
if((state_val_29503 === (31))){
var inst_29479 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29479)){
var statearr_29526_31468 = state_29502__$1;
(statearr_29526_31468[(1)] = (32));

} else {
var statearr_29527_31469 = state_29502__$1;
(statearr_29527_31469[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (32))){
var inst_29456 = (state_29502[(14)]);
var state_29502__$1 = state_29502;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29502__$1,(35),out,inst_29456);
} else {
if((state_val_29503 === (33))){
var inst_29447 = (state_29502[(12)]);
var inst_29420 = inst_29447;
var state_29502__$1 = (function (){var statearr_29529 = state_29502;
(statearr_29529[(7)] = inst_29420);

return statearr_29529;
})();
var statearr_29533_31473 = state_29502__$1;
(statearr_29533_31473[(2)] = null);

(statearr_29533_31473[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (13))){
var inst_29420 = (state_29502[(7)]);
var inst_29431 = inst_29420.cljs$lang$protocol_mask$partition0$;
var inst_29432 = (inst_29431 & (64));
var inst_29433 = inst_29420.cljs$core$ISeq$;
var inst_29434 = (cljs.core.PROTOCOL_SENTINEL === inst_29433);
var inst_29435 = ((inst_29432) || (inst_29434));
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29435)){
var statearr_29534_31478 = state_29502__$1;
(statearr_29534_31478[(1)] = (16));

} else {
var statearr_29535_31479 = state_29502__$1;
(statearr_29535_31479[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (22))){
var inst_29457 = (state_29502[(9)]);
var inst_29456 = (state_29502[(14)]);
var inst_29455 = (state_29502[(2)]);
var inst_29456__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29455,(0),null);
var inst_29457__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29455,(1),null);
var inst_29458 = (inst_29456__$1 == null);
var inst_29459 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29457__$1,change);
var inst_29460 = ((inst_29458) || (inst_29459));
var state_29502__$1 = (function (){var statearr_29536 = state_29502;
(statearr_29536[(9)] = inst_29457__$1);

(statearr_29536[(14)] = inst_29456__$1);

return statearr_29536;
})();
if(cljs.core.truth_(inst_29460)){
var statearr_29540_31497 = state_29502__$1;
(statearr_29540_31497[(1)] = (23));

} else {
var statearr_29541_31499 = state_29502__$1;
(statearr_29541_31499[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (36))){
var inst_29447 = (state_29502[(12)]);
var inst_29420 = inst_29447;
var state_29502__$1 = (function (){var statearr_29542 = state_29502;
(statearr_29542[(7)] = inst_29420);

return statearr_29542;
})();
var statearr_29543_31501 = state_29502__$1;
(statearr_29543_31501[(2)] = null);

(statearr_29543_31501[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (29))){
var inst_29471 = (state_29502[(11)]);
var state_29502__$1 = state_29502;
var statearr_29544_31502 = state_29502__$1;
(statearr_29544_31502[(2)] = inst_29471);

(statearr_29544_31502[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (6))){
var state_29502__$1 = state_29502;
var statearr_29548_31504 = state_29502__$1;
(statearr_29548_31504[(2)] = false);

(statearr_29548_31504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (28))){
var inst_29467 = (state_29502[(2)]);
var inst_29468 = calc_state();
var inst_29420 = inst_29468;
var state_29502__$1 = (function (){var statearr_29553 = state_29502;
(statearr_29553[(15)] = inst_29467);

(statearr_29553[(7)] = inst_29420);

return statearr_29553;
})();
var statearr_29555_31508 = state_29502__$1;
(statearr_29555_31508[(2)] = null);

(statearr_29555_31508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (25))){
var inst_29498 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
var statearr_29559_31510 = state_29502__$1;
(statearr_29559_31510[(2)] = inst_29498);

(statearr_29559_31510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (34))){
var inst_29496 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
var statearr_29560_31511 = state_29502__$1;
(statearr_29560_31511[(2)] = inst_29496);

(statearr_29560_31511[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (17))){
var state_29502__$1 = state_29502;
var statearr_29561_31513 = state_29502__$1;
(statearr_29561_31513[(2)] = false);

(statearr_29561_31513[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (3))){
var state_29502__$1 = state_29502;
var statearr_29562_31514 = state_29502__$1;
(statearr_29562_31514[(2)] = false);

(statearr_29562_31514[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (12))){
var inst_29500 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29502__$1,inst_29500);
} else {
if((state_val_29503 === (2))){
var inst_29391 = (state_29502[(8)]);
var inst_29396 = inst_29391.cljs$lang$protocol_mask$partition0$;
var inst_29397 = (inst_29396 & (64));
var inst_29398 = inst_29391.cljs$core$ISeq$;
var inst_29400 = (cljs.core.PROTOCOL_SENTINEL === inst_29398);
var inst_29401 = ((inst_29397) || (inst_29400));
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29401)){
var statearr_29563_31518 = state_29502__$1;
(statearr_29563_31518[(1)] = (5));

} else {
var statearr_29564_31519 = state_29502__$1;
(statearr_29564_31519[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (23))){
var inst_29456 = (state_29502[(14)]);
var inst_29462 = (inst_29456 == null);
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29462)){
var statearr_29565_31524 = state_29502__$1;
(statearr_29565_31524[(1)] = (26));

} else {
var statearr_29566_31530 = state_29502__$1;
(statearr_29566_31530[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (35))){
var inst_29482 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
if(cljs.core.truth_(inst_29482)){
var statearr_29567_31538 = state_29502__$1;
(statearr_29567_31538[(1)] = (36));

} else {
var statearr_29569_31539 = state_29502__$1;
(statearr_29569_31539[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (19))){
var inst_29420 = (state_29502[(7)]);
var inst_29444 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29420);
var state_29502__$1 = state_29502;
var statearr_29571_31540 = state_29502__$1;
(statearr_29571_31540[(2)] = inst_29444);

(statearr_29571_31540[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (11))){
var inst_29420 = (state_29502[(7)]);
var inst_29424 = (inst_29420 == null);
var inst_29425 = cljs.core.not(inst_29424);
var state_29502__$1 = state_29502;
if(inst_29425){
var statearr_29572_31541 = state_29502__$1;
(statearr_29572_31541[(1)] = (13));

} else {
var statearr_29575_31542 = state_29502__$1;
(statearr_29575_31542[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (9))){
var inst_29391 = (state_29502[(8)]);
var state_29502__$1 = state_29502;
var statearr_29576_31545 = state_29502__$1;
(statearr_29576_31545[(2)] = inst_29391);

(statearr_29576_31545[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (5))){
var state_29502__$1 = state_29502;
var statearr_29577_31547 = state_29502__$1;
(statearr_29577_31547[(2)] = true);

(statearr_29577_31547[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (14))){
var state_29502__$1 = state_29502;
var statearr_29578_31549 = state_29502__$1;
(statearr_29578_31549[(2)] = false);

(statearr_29578_31549[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (26))){
var inst_29457 = (state_29502[(9)]);
var inst_29464 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29457);
var state_29502__$1 = state_29502;
var statearr_29579_31551 = state_29502__$1;
(statearr_29579_31551[(2)] = inst_29464);

(statearr_29579_31551[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (16))){
var state_29502__$1 = state_29502;
var statearr_29580_31552 = state_29502__$1;
(statearr_29580_31552[(2)] = true);

(statearr_29580_31552[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (38))){
var inst_29492 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
var statearr_29583_31554 = state_29502__$1;
(statearr_29583_31554[(2)] = inst_29492);

(statearr_29583_31554[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (30))){
var inst_29449 = (state_29502[(13)]);
var inst_29457 = (state_29502[(9)]);
var inst_29448 = (state_29502[(10)]);
var inst_29474 = cljs.core.empty_QMARK_(inst_29448);
var inst_29475 = (inst_29449.cljs$core$IFn$_invoke$arity$1 ? inst_29449.cljs$core$IFn$_invoke$arity$1(inst_29457) : inst_29449.call(null,inst_29457));
var inst_29476 = cljs.core.not(inst_29475);
var inst_29477 = ((inst_29474) && (inst_29476));
var state_29502__$1 = state_29502;
var statearr_29584_31557 = state_29502__$1;
(statearr_29584_31557[(2)] = inst_29477);

(statearr_29584_31557[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (10))){
var inst_29391 = (state_29502[(8)]);
var inst_29413 = (state_29502[(2)]);
var inst_29414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29413,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29418 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29413,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29419 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29413,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29420 = inst_29391;
var state_29502__$1 = (function (){var statearr_29585 = state_29502;
(statearr_29585[(16)] = inst_29418);

(statearr_29585[(17)] = inst_29414);

(statearr_29585[(7)] = inst_29420);

(statearr_29585[(18)] = inst_29419);

return statearr_29585;
})();
var statearr_29586_31559 = state_29502__$1;
(statearr_29586_31559[(2)] = null);

(statearr_29586_31559[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (18))){
var inst_29439 = (state_29502[(2)]);
var state_29502__$1 = state_29502;
var statearr_29587_31560 = state_29502__$1;
(statearr_29587_31560[(2)] = inst_29439);

(statearr_29587_31560[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (37))){
var state_29502__$1 = state_29502;
var statearr_29590_31561 = state_29502__$1;
(statearr_29590_31561[(2)] = null);

(statearr_29590_31561[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29503 === (8))){
var inst_29391 = (state_29502[(8)]);
var inst_29410 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29391);
var state_29502__$1 = state_29502;
var statearr_29591_31562 = state_29502__$1;
(statearr_29591_31562[(2)] = inst_29410);

(statearr_29591_31562[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28138__auto__ = null;
var cljs$core$async$mix_$_state_machine__28138__auto____0 = (function (){
var statearr_29592 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29592[(0)] = cljs$core$async$mix_$_state_machine__28138__auto__);

(statearr_29592[(1)] = (1));

return statearr_29592;
});
var cljs$core$async$mix_$_state_machine__28138__auto____1 = (function (state_29502){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29502);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29593){if((e29593 instanceof Object)){
var ex__28141__auto__ = e29593;
var statearr_29594_31566 = state_29502;
(statearr_29594_31566[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29593;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31568 = state_29502;
state_29502 = G__31568;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28138__auto__ = function(state_29502){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28138__auto____1.call(this,state_29502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28138__auto____0;
cljs$core$async$mix_$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28138__auto____1;
return cljs$core$async$mix_$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_29597 = f__28280__auto__();
(statearr_29597[(6)] = c__28279__auto___31433);

return statearr_29597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_31571 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_31571(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_31577 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_31577(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_31582 = (function() {
var G__31583 = null;
var G__31583__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__31583__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__31583 = function(p,v){
switch(arguments.length){
case 1:
return G__31583__1.call(this,p);
case 2:
return G__31583__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31583.cljs$core$IFn$_invoke$arity$1 = G__31583__1;
G__31583.cljs$core$IFn$_invoke$arity$2 = G__31583__2;
return G__31583;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29608 = arguments.length;
switch (G__29608) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31582(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31582(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29611 = arguments.length;
switch (G__29611) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29609_SHARP_){
if(cljs.core.truth_((p1__29609_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29609_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29609_SHARP_.call(null,topic)))){
return p1__29609_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29609_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29614 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29614 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29615){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29615 = meta29615;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29616,meta29615__$1){
var self__ = this;
var _29616__$1 = this;
return (new cljs.core.async.t_cljs$core$async29614(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29615__$1));
}));

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29616){
var self__ = this;
var _29616__$1 = this;
return self__.meta29615;
}));

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29614.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29614.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29615","meta29615",904276632,null)], null);
}));

(cljs.core.async.t_cljs$core$async29614.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29614.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29614");

(cljs.core.async.t_cljs$core$async29614.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29614");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29614.
 */
cljs.core.async.__GT_t_cljs$core$async29614 = (function cljs$core$async$__GT_t_cljs$core$async29614(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29615){
return (new cljs.core.async.t_cljs$core$async29614(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29615));
});

}

return (new cljs.core.async.t_cljs$core$async29614(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28279__auto___31596 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29691){
var state_val_29692 = (state_29691[(1)]);
if((state_val_29692 === (7))){
var inst_29687 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
var statearr_29693_31598 = state_29691__$1;
(statearr_29693_31598[(2)] = inst_29687);

(statearr_29693_31598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (20))){
var state_29691__$1 = state_29691;
var statearr_29694_31601 = state_29691__$1;
(statearr_29694_31601[(2)] = null);

(statearr_29694_31601[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (1))){
var state_29691__$1 = state_29691;
var statearr_29695_31603 = state_29691__$1;
(statearr_29695_31603[(2)] = null);

(statearr_29695_31603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (24))){
var inst_29670 = (state_29691[(7)]);
var inst_29679 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29670);
var state_29691__$1 = state_29691;
var statearr_29696_31605 = state_29691__$1;
(statearr_29696_31605[(2)] = inst_29679);

(statearr_29696_31605[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (4))){
var inst_29622 = (state_29691[(8)]);
var inst_29622__$1 = (state_29691[(2)]);
var inst_29623 = (inst_29622__$1 == null);
var state_29691__$1 = (function (){var statearr_29698 = state_29691;
(statearr_29698[(8)] = inst_29622__$1);

return statearr_29698;
})();
if(cljs.core.truth_(inst_29623)){
var statearr_29699_31607 = state_29691__$1;
(statearr_29699_31607[(1)] = (5));

} else {
var statearr_29700_31609 = state_29691__$1;
(statearr_29700_31609[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (15))){
var inst_29664 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
var statearr_29701_31611 = state_29691__$1;
(statearr_29701_31611[(2)] = inst_29664);

(statearr_29701_31611[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (21))){
var inst_29684 = (state_29691[(2)]);
var state_29691__$1 = (function (){var statearr_29702 = state_29691;
(statearr_29702[(9)] = inst_29684);

return statearr_29702;
})();
var statearr_29703_31612 = state_29691__$1;
(statearr_29703_31612[(2)] = null);

(statearr_29703_31612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (13))){
var inst_29646 = (state_29691[(10)]);
var inst_29648 = cljs.core.chunked_seq_QMARK_(inst_29646);
var state_29691__$1 = state_29691;
if(inst_29648){
var statearr_29704_31615 = state_29691__$1;
(statearr_29704_31615[(1)] = (16));

} else {
var statearr_29705_31617 = state_29691__$1;
(statearr_29705_31617[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (22))){
var inst_29676 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
if(cljs.core.truth_(inst_29676)){
var statearr_29710_31618 = state_29691__$1;
(statearr_29710_31618[(1)] = (23));

} else {
var statearr_29711_31620 = state_29691__$1;
(statearr_29711_31620[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (6))){
var inst_29672 = (state_29691[(11)]);
var inst_29670 = (state_29691[(7)]);
var inst_29622 = (state_29691[(8)]);
var inst_29670__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29622) : topic_fn.call(null,inst_29622));
var inst_29671 = cljs.core.deref(mults);
var inst_29672__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29671,inst_29670__$1);
var state_29691__$1 = (function (){var statearr_29712 = state_29691;
(statearr_29712[(11)] = inst_29672__$1);

(statearr_29712[(7)] = inst_29670__$1);

return statearr_29712;
})();
if(cljs.core.truth_(inst_29672__$1)){
var statearr_29713_31623 = state_29691__$1;
(statearr_29713_31623[(1)] = (19));

} else {
var statearr_29714_31624 = state_29691__$1;
(statearr_29714_31624[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (25))){
var inst_29681 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
var statearr_29718_31626 = state_29691__$1;
(statearr_29718_31626[(2)] = inst_29681);

(statearr_29718_31626[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (17))){
var inst_29646 = (state_29691[(10)]);
var inst_29655 = cljs.core.first(inst_29646);
var inst_29656 = cljs.core.async.muxch_STAR_(inst_29655);
var inst_29657 = cljs.core.async.close_BANG_(inst_29656);
var inst_29658 = cljs.core.next(inst_29646);
var inst_29632 = inst_29658;
var inst_29633 = null;
var inst_29634 = (0);
var inst_29635 = (0);
var state_29691__$1 = (function (){var statearr_29719 = state_29691;
(statearr_29719[(12)] = inst_29632);

(statearr_29719[(13)] = inst_29635);

(statearr_29719[(14)] = inst_29657);

(statearr_29719[(15)] = inst_29633);

(statearr_29719[(16)] = inst_29634);

return statearr_29719;
})();
var statearr_29724_31629 = state_29691__$1;
(statearr_29724_31629[(2)] = null);

(statearr_29724_31629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (3))){
var inst_29689 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29691__$1,inst_29689);
} else {
if((state_val_29692 === (12))){
var inst_29666 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
var statearr_29725_31631 = state_29691__$1;
(statearr_29725_31631[(2)] = inst_29666);

(statearr_29725_31631[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (2))){
var state_29691__$1 = state_29691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29691__$1,(4),ch);
} else {
if((state_val_29692 === (23))){
var state_29691__$1 = state_29691;
var statearr_29729_31634 = state_29691__$1;
(statearr_29729_31634[(2)] = null);

(statearr_29729_31634[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (19))){
var inst_29672 = (state_29691[(11)]);
var inst_29622 = (state_29691[(8)]);
var inst_29674 = cljs.core.async.muxch_STAR_(inst_29672);
var state_29691__$1 = state_29691;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29691__$1,(22),inst_29674,inst_29622);
} else {
if((state_val_29692 === (11))){
var inst_29632 = (state_29691[(12)]);
var inst_29646 = (state_29691[(10)]);
var inst_29646__$1 = cljs.core.seq(inst_29632);
var state_29691__$1 = (function (){var statearr_29730 = state_29691;
(statearr_29730[(10)] = inst_29646__$1);

return statearr_29730;
})();
if(inst_29646__$1){
var statearr_29731_31637 = state_29691__$1;
(statearr_29731_31637[(1)] = (13));

} else {
var statearr_29732_31639 = state_29691__$1;
(statearr_29732_31639[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (9))){
var inst_29668 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
var statearr_29739_31641 = state_29691__$1;
(statearr_29739_31641[(2)] = inst_29668);

(statearr_29739_31641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (5))){
var inst_29629 = cljs.core.deref(mults);
var inst_29630 = cljs.core.vals(inst_29629);
var inst_29631 = cljs.core.seq(inst_29630);
var inst_29632 = inst_29631;
var inst_29633 = null;
var inst_29634 = (0);
var inst_29635 = (0);
var state_29691__$1 = (function (){var statearr_29741 = state_29691;
(statearr_29741[(12)] = inst_29632);

(statearr_29741[(13)] = inst_29635);

(statearr_29741[(15)] = inst_29633);

(statearr_29741[(16)] = inst_29634);

return statearr_29741;
})();
var statearr_29743_31644 = state_29691__$1;
(statearr_29743_31644[(2)] = null);

(statearr_29743_31644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (14))){
var state_29691__$1 = state_29691;
var statearr_29749_31647 = state_29691__$1;
(statearr_29749_31647[(2)] = null);

(statearr_29749_31647[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (16))){
var inst_29646 = (state_29691[(10)]);
var inst_29650 = cljs.core.chunk_first(inst_29646);
var inst_29651 = cljs.core.chunk_rest(inst_29646);
var inst_29652 = cljs.core.count(inst_29650);
var inst_29632 = inst_29651;
var inst_29633 = inst_29650;
var inst_29634 = inst_29652;
var inst_29635 = (0);
var state_29691__$1 = (function (){var statearr_29753 = state_29691;
(statearr_29753[(12)] = inst_29632);

(statearr_29753[(13)] = inst_29635);

(statearr_29753[(15)] = inst_29633);

(statearr_29753[(16)] = inst_29634);

return statearr_29753;
})();
var statearr_29754_31650 = state_29691__$1;
(statearr_29754_31650[(2)] = null);

(statearr_29754_31650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (10))){
var inst_29632 = (state_29691[(12)]);
var inst_29635 = (state_29691[(13)]);
var inst_29633 = (state_29691[(15)]);
var inst_29634 = (state_29691[(16)]);
var inst_29640 = cljs.core._nth(inst_29633,inst_29635);
var inst_29641 = cljs.core.async.muxch_STAR_(inst_29640);
var inst_29642 = cljs.core.async.close_BANG_(inst_29641);
var inst_29643 = (inst_29635 + (1));
var tmp29746 = inst_29632;
var tmp29747 = inst_29633;
var tmp29748 = inst_29634;
var inst_29632__$1 = tmp29746;
var inst_29633__$1 = tmp29747;
var inst_29634__$1 = tmp29748;
var inst_29635__$1 = inst_29643;
var state_29691__$1 = (function (){var statearr_29755 = state_29691;
(statearr_29755[(12)] = inst_29632__$1);

(statearr_29755[(17)] = inst_29642);

(statearr_29755[(13)] = inst_29635__$1);

(statearr_29755[(15)] = inst_29633__$1);

(statearr_29755[(16)] = inst_29634__$1);

return statearr_29755;
})();
var statearr_29756_31653 = state_29691__$1;
(statearr_29756_31653[(2)] = null);

(statearr_29756_31653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (18))){
var inst_29661 = (state_29691[(2)]);
var state_29691__$1 = state_29691;
var statearr_29757_31656 = state_29691__$1;
(statearr_29757_31656[(2)] = inst_29661);

(statearr_29757_31656[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29692 === (8))){
var inst_29635 = (state_29691[(13)]);
var inst_29634 = (state_29691[(16)]);
var inst_29637 = (inst_29635 < inst_29634);
var inst_29638 = inst_29637;
var state_29691__$1 = state_29691;
if(cljs.core.truth_(inst_29638)){
var statearr_29762_31657 = state_29691__$1;
(statearr_29762_31657[(1)] = (10));

} else {
var statearr_29763_31658 = state_29691__$1;
(statearr_29763_31658[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29765 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29765[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29765[(1)] = (1));

return statearr_29765;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29691){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29691);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29770){if((e29770 instanceof Object)){
var ex__28141__auto__ = e29770;
var statearr_29772_31662 = state_29691;
(statearr_29772_31662[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29770;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31664 = state_29691;
state_29691 = G__31664;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_29777 = f__28280__auto__();
(statearr_29777[(6)] = c__28279__auto___31596);

return statearr_29777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29784 = arguments.length;
switch (G__29784) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29789 = arguments.length;
switch (G__29789) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29791 = arguments.length;
switch (G__29791) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28279__auto___31675 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29838){
var state_val_29839 = (state_29838[(1)]);
if((state_val_29839 === (7))){
var state_29838__$1 = state_29838;
var statearr_29844_31677 = state_29838__$1;
(statearr_29844_31677[(2)] = null);

(statearr_29844_31677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (1))){
var state_29838__$1 = state_29838;
var statearr_29845_31679 = state_29838__$1;
(statearr_29845_31679[(2)] = null);

(statearr_29845_31679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (4))){
var inst_29802 = (state_29838[(7)]);
var inst_29804 = (inst_29802 < cnt);
var state_29838__$1 = state_29838;
if(cljs.core.truth_(inst_29804)){
var statearr_29846_31680 = state_29838__$1;
(statearr_29846_31680[(1)] = (6));

} else {
var statearr_29849_31681 = state_29838__$1;
(statearr_29849_31681[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (15))){
var inst_29834 = (state_29838[(2)]);
var state_29838__$1 = state_29838;
var statearr_29850_31682 = state_29838__$1;
(statearr_29850_31682[(2)] = inst_29834);

(statearr_29850_31682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (13))){
var inst_29827 = cljs.core.async.close_BANG_(out);
var state_29838__$1 = state_29838;
var statearr_29852_31683 = state_29838__$1;
(statearr_29852_31683[(2)] = inst_29827);

(statearr_29852_31683[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (6))){
var state_29838__$1 = state_29838;
var statearr_29853_31684 = state_29838__$1;
(statearr_29853_31684[(2)] = null);

(statearr_29853_31684[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (3))){
var inst_29836 = (state_29838[(2)]);
var state_29838__$1 = state_29838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29838__$1,inst_29836);
} else {
if((state_val_29839 === (12))){
var inst_29824 = (state_29838[(8)]);
var inst_29824__$1 = (state_29838[(2)]);
var inst_29825 = cljs.core.some(cljs.core.nil_QMARK_,inst_29824__$1);
var state_29838__$1 = (function (){var statearr_29860 = state_29838;
(statearr_29860[(8)] = inst_29824__$1);

return statearr_29860;
})();
if(cljs.core.truth_(inst_29825)){
var statearr_29861_31685 = state_29838__$1;
(statearr_29861_31685[(1)] = (13));

} else {
var statearr_29862_31686 = state_29838__$1;
(statearr_29862_31686[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (2))){
var inst_29800 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29802 = (0);
var state_29838__$1 = (function (){var statearr_29867 = state_29838;
(statearr_29867[(9)] = inst_29800);

(statearr_29867[(7)] = inst_29802);

return statearr_29867;
})();
var statearr_29868_31687 = state_29838__$1;
(statearr_29868_31687[(2)] = null);

(statearr_29868_31687[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (11))){
var inst_29802 = (state_29838[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_29838,(10),Object,null,(9));
var inst_29811 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29802) : chs__$1.call(null,inst_29802));
var inst_29812 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29802) : done.call(null,inst_29802));
var inst_29813 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29811,inst_29812);
var state_29838__$1 = state_29838;
var statearr_29869_31688 = state_29838__$1;
(statearr_29869_31688[(2)] = inst_29813);


cljs.core.async.impl.ioc_helpers.process_exception(state_29838__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (9))){
var inst_29802 = (state_29838[(7)]);
var inst_29815 = (state_29838[(2)]);
var inst_29816 = (inst_29802 + (1));
var inst_29802__$1 = inst_29816;
var state_29838__$1 = (function (){var statearr_29870 = state_29838;
(statearr_29870[(10)] = inst_29815);

(statearr_29870[(7)] = inst_29802__$1);

return statearr_29870;
})();
var statearr_29871_31689 = state_29838__$1;
(statearr_29871_31689[(2)] = null);

(statearr_29871_31689[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (5))){
var inst_29822 = (state_29838[(2)]);
var state_29838__$1 = (function (){var statearr_29872 = state_29838;
(statearr_29872[(11)] = inst_29822);

return statearr_29872;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29838__$1,(12),dchan);
} else {
if((state_val_29839 === (14))){
var inst_29824 = (state_29838[(8)]);
var inst_29829 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29824);
var state_29838__$1 = state_29838;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29838__$1,(16),out,inst_29829);
} else {
if((state_val_29839 === (16))){
var inst_29831 = (state_29838[(2)]);
var state_29838__$1 = (function (){var statearr_29875 = state_29838;
(statearr_29875[(12)] = inst_29831);

return statearr_29875;
})();
var statearr_29876_31690 = state_29838__$1;
(statearr_29876_31690[(2)] = null);

(statearr_29876_31690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (10))){
var inst_29806 = (state_29838[(2)]);
var inst_29807 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29838__$1 = (function (){var statearr_29881 = state_29838;
(statearr_29881[(13)] = inst_29806);

return statearr_29881;
})();
var statearr_29882_31691 = state_29838__$1;
(statearr_29882_31691[(2)] = inst_29807);


cljs.core.async.impl.ioc_helpers.process_exception(state_29838__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29839 === (8))){
var inst_29820 = (state_29838[(2)]);
var state_29838__$1 = state_29838;
var statearr_29883_31692 = state_29838__$1;
(statearr_29883_31692[(2)] = inst_29820);

(statearr_29883_31692[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29885 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29885[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29885[(1)] = (1));

return statearr_29885;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29838){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29838);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29886){if((e29886 instanceof Object)){
var ex__28141__auto__ = e29886;
var statearr_29887_31693 = state_29838;
(statearr_29887_31693[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29838);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29886;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31694 = state_29838;
state_29838 = G__31694;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29838){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_29888 = f__28280__auto__();
(statearr_29888[(6)] = c__28279__auto___31675);

return statearr_29888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29893 = arguments.length;
switch (G__29893) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28279__auto___31696 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29928){
var state_val_29930 = (state_29928[(1)]);
if((state_val_29930 === (7))){
var inst_29906 = (state_29928[(7)]);
var inst_29908 = (state_29928[(8)]);
var inst_29906__$1 = (state_29928[(2)]);
var inst_29908__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29906__$1,(0),null);
var inst_29909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29906__$1,(1),null);
var inst_29910 = (inst_29908__$1 == null);
var state_29928__$1 = (function (){var statearr_29933 = state_29928;
(statearr_29933[(9)] = inst_29909);

(statearr_29933[(7)] = inst_29906__$1);

(statearr_29933[(8)] = inst_29908__$1);

return statearr_29933;
})();
if(cljs.core.truth_(inst_29910)){
var statearr_29934_31697 = state_29928__$1;
(statearr_29934_31697[(1)] = (8));

} else {
var statearr_29935_31698 = state_29928__$1;
(statearr_29935_31698[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (1))){
var inst_29896 = cljs.core.vec(chs);
var inst_29897 = inst_29896;
var state_29928__$1 = (function (){var statearr_29936 = state_29928;
(statearr_29936[(10)] = inst_29897);

return statearr_29936;
})();
var statearr_29937_31699 = state_29928__$1;
(statearr_29937_31699[(2)] = null);

(statearr_29937_31699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (4))){
var inst_29897 = (state_29928[(10)]);
var state_29928__$1 = state_29928;
return cljs.core.async.ioc_alts_BANG_(state_29928__$1,(7),inst_29897);
} else {
if((state_val_29930 === (6))){
var inst_29924 = (state_29928[(2)]);
var state_29928__$1 = state_29928;
var statearr_29939_31700 = state_29928__$1;
(statearr_29939_31700[(2)] = inst_29924);

(statearr_29939_31700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (3))){
var inst_29926 = (state_29928[(2)]);
var state_29928__$1 = state_29928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29928__$1,inst_29926);
} else {
if((state_val_29930 === (2))){
var inst_29897 = (state_29928[(10)]);
var inst_29899 = cljs.core.count(inst_29897);
var inst_29900 = (inst_29899 > (0));
var state_29928__$1 = state_29928;
if(cljs.core.truth_(inst_29900)){
var statearr_29942_31701 = state_29928__$1;
(statearr_29942_31701[(1)] = (4));

} else {
var statearr_29943_31702 = state_29928__$1;
(statearr_29943_31702[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (11))){
var inst_29897 = (state_29928[(10)]);
var inst_29917 = (state_29928[(2)]);
var tmp29941 = inst_29897;
var inst_29897__$1 = tmp29941;
var state_29928__$1 = (function (){var statearr_29945 = state_29928;
(statearr_29945[(11)] = inst_29917);

(statearr_29945[(10)] = inst_29897__$1);

return statearr_29945;
})();
var statearr_29946_31703 = state_29928__$1;
(statearr_29946_31703[(2)] = null);

(statearr_29946_31703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (9))){
var inst_29908 = (state_29928[(8)]);
var state_29928__$1 = state_29928;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29928__$1,(11),out,inst_29908);
} else {
if((state_val_29930 === (5))){
var inst_29922 = cljs.core.async.close_BANG_(out);
var state_29928__$1 = state_29928;
var statearr_29949_31704 = state_29928__$1;
(statearr_29949_31704[(2)] = inst_29922);

(statearr_29949_31704[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (10))){
var inst_29920 = (state_29928[(2)]);
var state_29928__$1 = state_29928;
var statearr_29953_31705 = state_29928__$1;
(statearr_29953_31705[(2)] = inst_29920);

(statearr_29953_31705[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29930 === (8))){
var inst_29909 = (state_29928[(9)]);
var inst_29897 = (state_29928[(10)]);
var inst_29906 = (state_29928[(7)]);
var inst_29908 = (state_29928[(8)]);
var inst_29912 = (function (){var cs = inst_29897;
var vec__29902 = inst_29906;
var v = inst_29908;
var c = inst_29909;
return (function (p1__29890_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29890_SHARP_);
});
})();
var inst_29913 = cljs.core.filterv(inst_29912,inst_29897);
var inst_29897__$1 = inst_29913;
var state_29928__$1 = (function (){var statearr_29955 = state_29928;
(statearr_29955[(10)] = inst_29897__$1);

return statearr_29955;
})();
var statearr_29956_31706 = state_29928__$1;
(statearr_29956_31706[(2)] = null);

(statearr_29956_31706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_29957 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29957[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_29957[(1)] = (1));

return statearr_29957;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29928){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29928);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e29958){if((e29958 instanceof Object)){
var ex__28141__auto__ = e29958;
var statearr_29959_31707 = state_29928;
(statearr_29959_31707[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29928);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29958;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31708 = state_29928;
state_29928 = G__31708;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_29960 = f__28280__auto__();
(statearr_29960[(6)] = c__28279__auto___31696);

return statearr_29960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__29967 = arguments.length;
switch (G__29967) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28279__auto___31710 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_29996){
var state_val_29997 = (state_29996[(1)]);
if((state_val_29997 === (7))){
var inst_29976 = (state_29996[(7)]);
var inst_29976__$1 = (state_29996[(2)]);
var inst_29977 = (inst_29976__$1 == null);
var inst_29978 = cljs.core.not(inst_29977);
var state_29996__$1 = (function (){var statearr_29999 = state_29996;
(statearr_29999[(7)] = inst_29976__$1);

return statearr_29999;
})();
if(inst_29978){
var statearr_30000_31711 = state_29996__$1;
(statearr_30000_31711[(1)] = (8));

} else {
var statearr_30001_31712 = state_29996__$1;
(statearr_30001_31712[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (1))){
var inst_29971 = (0);
var state_29996__$1 = (function (){var statearr_30003 = state_29996;
(statearr_30003[(8)] = inst_29971);

return statearr_30003;
})();
var statearr_30004_31713 = state_29996__$1;
(statearr_30004_31713[(2)] = null);

(statearr_30004_31713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (4))){
var state_29996__$1 = state_29996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29996__$1,(7),ch);
} else {
if((state_val_29997 === (6))){
var inst_29989 = (state_29996[(2)]);
var state_29996__$1 = state_29996;
var statearr_30006_31714 = state_29996__$1;
(statearr_30006_31714[(2)] = inst_29989);

(statearr_30006_31714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (3))){
var inst_29991 = (state_29996[(2)]);
var inst_29992 = cljs.core.async.close_BANG_(out);
var state_29996__$1 = (function (){var statearr_30007 = state_29996;
(statearr_30007[(9)] = inst_29991);

return statearr_30007;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29996__$1,inst_29992);
} else {
if((state_val_29997 === (2))){
var inst_29971 = (state_29996[(8)]);
var inst_29973 = (inst_29971 < n);
var state_29996__$1 = state_29996;
if(cljs.core.truth_(inst_29973)){
var statearr_30011_31715 = state_29996__$1;
(statearr_30011_31715[(1)] = (4));

} else {
var statearr_30013_31716 = state_29996__$1;
(statearr_30013_31716[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (11))){
var inst_29971 = (state_29996[(8)]);
var inst_29981 = (state_29996[(2)]);
var inst_29982 = (inst_29971 + (1));
var inst_29971__$1 = inst_29982;
var state_29996__$1 = (function (){var statearr_30015 = state_29996;
(statearr_30015[(8)] = inst_29971__$1);

(statearr_30015[(10)] = inst_29981);

return statearr_30015;
})();
var statearr_30016_31717 = state_29996__$1;
(statearr_30016_31717[(2)] = null);

(statearr_30016_31717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (9))){
var state_29996__$1 = state_29996;
var statearr_30017_31718 = state_29996__$1;
(statearr_30017_31718[(2)] = null);

(statearr_30017_31718[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (5))){
var state_29996__$1 = state_29996;
var statearr_30018_31719 = state_29996__$1;
(statearr_30018_31719[(2)] = null);

(statearr_30018_31719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (10))){
var inst_29986 = (state_29996[(2)]);
var state_29996__$1 = state_29996;
var statearr_30019_31720 = state_29996__$1;
(statearr_30019_31720[(2)] = inst_29986);

(statearr_30019_31720[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29997 === (8))){
var inst_29976 = (state_29996[(7)]);
var state_29996__$1 = state_29996;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29996__$1,(11),out,inst_29976);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30020 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30020[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30020[(1)] = (1));

return statearr_30020;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_29996){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_29996);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30021){if((e30021 instanceof Object)){
var ex__28141__auto__ = e30021;
var statearr_30025_31721 = state_29996;
(statearr_30025_31721[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29996);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30021;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31722 = state_29996;
state_29996 = G__31722;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_29996){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_29996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30026 = f__28280__auto__();
(statearr_30026[(6)] = c__28279__auto___31710);

return statearr_30026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30032 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30032 = (function (f,ch,meta30033){
this.f = f;
this.ch = ch;
this.meta30033 = meta30033;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30034,meta30033__$1){
var self__ = this;
var _30034__$1 = this;
return (new cljs.core.async.t_cljs$core$async30032(self__.f,self__.ch,meta30033__$1));
}));

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30034){
var self__ = this;
var _30034__$1 = this;
return self__.meta30033;
}));

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30043 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30043 = (function (f,ch,meta30033,_,fn1,meta30044){
this.f = f;
this.ch = ch;
this.meta30033 = meta30033;
this._ = _;
this.fn1 = fn1;
this.meta30044 = meta30044;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30043.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30045,meta30044__$1){
var self__ = this;
var _30045__$1 = this;
return (new cljs.core.async.t_cljs$core$async30043(self__.f,self__.ch,self__.meta30033,self__._,self__.fn1,meta30044__$1));
}));

(cljs.core.async.t_cljs$core$async30043.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30045){
var self__ = this;
var _30045__$1 = this;
return self__.meta30044;
}));

(cljs.core.async.t_cljs$core$async30043.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30043.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30043.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30043.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30030_SHARP_){
var G__30046 = (((p1__30030_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30030_SHARP_) : self__.f.call(null,p1__30030_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30046) : f1.call(null,G__30046));
});
}));

(cljs.core.async.t_cljs$core$async30043.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30033","meta30033",-1844326898,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30032","cljs.core.async/t_cljs$core$async30032",-1616716111,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30044","meta30044",-770898027,null)], null);
}));

(cljs.core.async.t_cljs$core$async30043.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30043.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30043");

(cljs.core.async.t_cljs$core$async30043.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30043");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30043.
 */
cljs.core.async.__GT_t_cljs$core$async30043 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30043(f__$1,ch__$1,meta30033__$1,___$2,fn1__$1,meta30044){
return (new cljs.core.async.t_cljs$core$async30043(f__$1,ch__$1,meta30033__$1,___$2,fn1__$1,meta30044));
});

}

return (new cljs.core.async.t_cljs$core$async30043(self__.f,self__.ch,self__.meta30033,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30047 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30047) : self__.f.call(null,G__30047));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30032.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30032.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30033","meta30033",-1844326898,null)], null);
}));

(cljs.core.async.t_cljs$core$async30032.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30032.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30032");

(cljs.core.async.t_cljs$core$async30032.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30032");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30032.
 */
cljs.core.async.__GT_t_cljs$core$async30032 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30032(f__$1,ch__$1,meta30033){
return (new cljs.core.async.t_cljs$core$async30032(f__$1,ch__$1,meta30033));
});

}

return (new cljs.core.async.t_cljs$core$async30032(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30054 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30054 = (function (f,ch,meta30055){
this.f = f;
this.ch = ch;
this.meta30055 = meta30055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30056,meta30055__$1){
var self__ = this;
var _30056__$1 = this;
return (new cljs.core.async.t_cljs$core$async30054(self__.f,self__.ch,meta30055__$1));
}));

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30056){
var self__ = this;
var _30056__$1 = this;
return self__.meta30055;
}));

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30054.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30054.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30055","meta30055",-1357710379,null)], null);
}));

(cljs.core.async.t_cljs$core$async30054.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30054");

(cljs.core.async.t_cljs$core$async30054.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30054");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30054.
 */
cljs.core.async.__GT_t_cljs$core$async30054 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30054(f__$1,ch__$1,meta30055){
return (new cljs.core.async.t_cljs$core$async30054(f__$1,ch__$1,meta30055));
});

}

return (new cljs.core.async.t_cljs$core$async30054(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30067 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30067 = (function (p,ch,meta30068){
this.p = p;
this.ch = ch;
this.meta30068 = meta30068;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30069,meta30068__$1){
var self__ = this;
var _30069__$1 = this;
return (new cljs.core.async.t_cljs$core$async30067(self__.p,self__.ch,meta30068__$1));
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30069){
var self__ = this;
var _30069__$1 = this;
return self__.meta30068;
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30067.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30067.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30068","meta30068",-988911195,null)], null);
}));

(cljs.core.async.t_cljs$core$async30067.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30067.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30067");

(cljs.core.async.t_cljs$core$async30067.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30067");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30067.
 */
cljs.core.async.__GT_t_cljs$core$async30067 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30067(p__$1,ch__$1,meta30068){
return (new cljs.core.async.t_cljs$core$async30067(p__$1,ch__$1,meta30068));
});

}

return (new cljs.core.async.t_cljs$core$async30067(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30072 = arguments.length;
switch (G__30072) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28279__auto___31724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_30093){
var state_val_30094 = (state_30093[(1)]);
if((state_val_30094 === (7))){
var inst_30089 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
var statearr_30098_31725 = state_30093__$1;
(statearr_30098_31725[(2)] = inst_30089);

(statearr_30098_31725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (1))){
var state_30093__$1 = state_30093;
var statearr_30099_31726 = state_30093__$1;
(statearr_30099_31726[(2)] = null);

(statearr_30099_31726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (4))){
var inst_30075 = (state_30093[(7)]);
var inst_30075__$1 = (state_30093[(2)]);
var inst_30076 = (inst_30075__$1 == null);
var state_30093__$1 = (function (){var statearr_30100 = state_30093;
(statearr_30100[(7)] = inst_30075__$1);

return statearr_30100;
})();
if(cljs.core.truth_(inst_30076)){
var statearr_30101_31727 = state_30093__$1;
(statearr_30101_31727[(1)] = (5));

} else {
var statearr_30102_31728 = state_30093__$1;
(statearr_30102_31728[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (6))){
var inst_30075 = (state_30093[(7)]);
var inst_30080 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30075) : p.call(null,inst_30075));
var state_30093__$1 = state_30093;
if(cljs.core.truth_(inst_30080)){
var statearr_30103_31729 = state_30093__$1;
(statearr_30103_31729[(1)] = (8));

} else {
var statearr_30104_31730 = state_30093__$1;
(statearr_30104_31730[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (3))){
var inst_30091 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30093__$1,inst_30091);
} else {
if((state_val_30094 === (2))){
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30093__$1,(4),ch);
} else {
if((state_val_30094 === (11))){
var inst_30083 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
var statearr_30110_31731 = state_30093__$1;
(statearr_30110_31731[(2)] = inst_30083);

(statearr_30110_31731[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (9))){
var state_30093__$1 = state_30093;
var statearr_30111_31732 = state_30093__$1;
(statearr_30111_31732[(2)] = null);

(statearr_30111_31732[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (5))){
var inst_30078 = cljs.core.async.close_BANG_(out);
var state_30093__$1 = state_30093;
var statearr_30117_31733 = state_30093__$1;
(statearr_30117_31733[(2)] = inst_30078);

(statearr_30117_31733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (10))){
var inst_30086 = (state_30093[(2)]);
var state_30093__$1 = (function (){var statearr_30119 = state_30093;
(statearr_30119[(8)] = inst_30086);

return statearr_30119;
})();
var statearr_30120_31734 = state_30093__$1;
(statearr_30120_31734[(2)] = null);

(statearr_30120_31734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (8))){
var inst_30075 = (state_30093[(7)]);
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30093__$1,(11),out,inst_30075);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30123 = [null,null,null,null,null,null,null,null,null];
(statearr_30123[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30123[(1)] = (1));

return statearr_30123;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30093){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30093);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30124){if((e30124 instanceof Object)){
var ex__28141__auto__ = e30124;
var statearr_30125_31735 = state_30093;
(statearr_30125_31735[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30093);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30124;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31736 = state_30093;
state_30093 = G__31736;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30093){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30126 = f__28280__auto__();
(statearr_30126[(6)] = c__28279__auto___31724);

return statearr_30126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30128 = arguments.length;
switch (G__30128) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28279__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_30190){
var state_val_30191 = (state_30190[(1)]);
if((state_val_30191 === (7))){
var inst_30186 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30192_31738 = state_30190__$1;
(statearr_30192_31738[(2)] = inst_30186);

(statearr_30192_31738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (20))){
var inst_30156 = (state_30190[(7)]);
var inst_30167 = (state_30190[(2)]);
var inst_30168 = cljs.core.next(inst_30156);
var inst_30142 = inst_30168;
var inst_30143 = null;
var inst_30144 = (0);
var inst_30145 = (0);
var state_30190__$1 = (function (){var statearr_30193 = state_30190;
(statearr_30193[(8)] = inst_30142);

(statearr_30193[(9)] = inst_30145);

(statearr_30193[(10)] = inst_30144);

(statearr_30193[(11)] = inst_30143);

(statearr_30193[(12)] = inst_30167);

return statearr_30193;
})();
var statearr_30194_31739 = state_30190__$1;
(statearr_30194_31739[(2)] = null);

(statearr_30194_31739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (1))){
var state_30190__$1 = state_30190;
var statearr_30195_31740 = state_30190__$1;
(statearr_30195_31740[(2)] = null);

(statearr_30195_31740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (4))){
var inst_30131 = (state_30190[(13)]);
var inst_30131__$1 = (state_30190[(2)]);
var inst_30132 = (inst_30131__$1 == null);
var state_30190__$1 = (function (){var statearr_30196 = state_30190;
(statearr_30196[(13)] = inst_30131__$1);

return statearr_30196;
})();
if(cljs.core.truth_(inst_30132)){
var statearr_30197_31741 = state_30190__$1;
(statearr_30197_31741[(1)] = (5));

} else {
var statearr_30198_31742 = state_30190__$1;
(statearr_30198_31742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (15))){
var state_30190__$1 = state_30190;
var statearr_30202_31743 = state_30190__$1;
(statearr_30202_31743[(2)] = null);

(statearr_30202_31743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (21))){
var state_30190__$1 = state_30190;
var statearr_30203_31744 = state_30190__$1;
(statearr_30203_31744[(2)] = null);

(statearr_30203_31744[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (13))){
var inst_30142 = (state_30190[(8)]);
var inst_30145 = (state_30190[(9)]);
var inst_30144 = (state_30190[(10)]);
var inst_30143 = (state_30190[(11)]);
var inst_30152 = (state_30190[(2)]);
var inst_30153 = (inst_30145 + (1));
var tmp30199 = inst_30142;
var tmp30200 = inst_30144;
var tmp30201 = inst_30143;
var inst_30142__$1 = tmp30199;
var inst_30143__$1 = tmp30201;
var inst_30144__$1 = tmp30200;
var inst_30145__$1 = inst_30153;
var state_30190__$1 = (function (){var statearr_30204 = state_30190;
(statearr_30204[(8)] = inst_30142__$1);

(statearr_30204[(9)] = inst_30145__$1);

(statearr_30204[(10)] = inst_30144__$1);

(statearr_30204[(11)] = inst_30143__$1);

(statearr_30204[(14)] = inst_30152);

return statearr_30204;
})();
var statearr_30205_31745 = state_30190__$1;
(statearr_30205_31745[(2)] = null);

(statearr_30205_31745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (22))){
var state_30190__$1 = state_30190;
var statearr_30206_31746 = state_30190__$1;
(statearr_30206_31746[(2)] = null);

(statearr_30206_31746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (6))){
var inst_30131 = (state_30190[(13)]);
var inst_30140 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30131) : f.call(null,inst_30131));
var inst_30141 = cljs.core.seq(inst_30140);
var inst_30142 = inst_30141;
var inst_30143 = null;
var inst_30144 = (0);
var inst_30145 = (0);
var state_30190__$1 = (function (){var statearr_30207 = state_30190;
(statearr_30207[(8)] = inst_30142);

(statearr_30207[(9)] = inst_30145);

(statearr_30207[(10)] = inst_30144);

(statearr_30207[(11)] = inst_30143);

return statearr_30207;
})();
var statearr_30208_31747 = state_30190__$1;
(statearr_30208_31747[(2)] = null);

(statearr_30208_31747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (17))){
var inst_30156 = (state_30190[(7)]);
var inst_30160 = cljs.core.chunk_first(inst_30156);
var inst_30161 = cljs.core.chunk_rest(inst_30156);
var inst_30162 = cljs.core.count(inst_30160);
var inst_30142 = inst_30161;
var inst_30143 = inst_30160;
var inst_30144 = inst_30162;
var inst_30145 = (0);
var state_30190__$1 = (function (){var statearr_30209 = state_30190;
(statearr_30209[(8)] = inst_30142);

(statearr_30209[(9)] = inst_30145);

(statearr_30209[(10)] = inst_30144);

(statearr_30209[(11)] = inst_30143);

return statearr_30209;
})();
var statearr_30210_31748 = state_30190__$1;
(statearr_30210_31748[(2)] = null);

(statearr_30210_31748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (3))){
var inst_30188 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30190__$1,inst_30188);
} else {
if((state_val_30191 === (12))){
var inst_30176 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30211_31749 = state_30190__$1;
(statearr_30211_31749[(2)] = inst_30176);

(statearr_30211_31749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (2))){
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30190__$1,(4),in$);
} else {
if((state_val_30191 === (23))){
var inst_30184 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30212_31750 = state_30190__$1;
(statearr_30212_31750[(2)] = inst_30184);

(statearr_30212_31750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (19))){
var inst_30171 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30213_31751 = state_30190__$1;
(statearr_30213_31751[(2)] = inst_30171);

(statearr_30213_31751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (11))){
var inst_30156 = (state_30190[(7)]);
var inst_30142 = (state_30190[(8)]);
var inst_30156__$1 = cljs.core.seq(inst_30142);
var state_30190__$1 = (function (){var statearr_30214 = state_30190;
(statearr_30214[(7)] = inst_30156__$1);

return statearr_30214;
})();
if(inst_30156__$1){
var statearr_30215_31752 = state_30190__$1;
(statearr_30215_31752[(1)] = (14));

} else {
var statearr_30216_31753 = state_30190__$1;
(statearr_30216_31753[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (9))){
var inst_30178 = (state_30190[(2)]);
var inst_30179 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30190__$1 = (function (){var statearr_30217 = state_30190;
(statearr_30217[(15)] = inst_30178);

return statearr_30217;
})();
if(cljs.core.truth_(inst_30179)){
var statearr_30218_31754 = state_30190__$1;
(statearr_30218_31754[(1)] = (21));

} else {
var statearr_30219_31755 = state_30190__$1;
(statearr_30219_31755[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (5))){
var inst_30134 = cljs.core.async.close_BANG_(out);
var state_30190__$1 = state_30190;
var statearr_30220_31756 = state_30190__$1;
(statearr_30220_31756[(2)] = inst_30134);

(statearr_30220_31756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (14))){
var inst_30156 = (state_30190[(7)]);
var inst_30158 = cljs.core.chunked_seq_QMARK_(inst_30156);
var state_30190__$1 = state_30190;
if(inst_30158){
var statearr_30221_31757 = state_30190__$1;
(statearr_30221_31757[(1)] = (17));

} else {
var statearr_30222_31758 = state_30190__$1;
(statearr_30222_31758[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (16))){
var inst_30174 = (state_30190[(2)]);
var state_30190__$1 = state_30190;
var statearr_30223_31759 = state_30190__$1;
(statearr_30223_31759[(2)] = inst_30174);

(statearr_30223_31759[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30191 === (10))){
var inst_30145 = (state_30190[(9)]);
var inst_30143 = (state_30190[(11)]);
var inst_30150 = cljs.core._nth(inst_30143,inst_30145);
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30190__$1,(13),out,inst_30150);
} else {
if((state_val_30191 === (18))){
var inst_30156 = (state_30190[(7)]);
var inst_30165 = cljs.core.first(inst_30156);
var state_30190__$1 = state_30190;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30190__$1,(20),out,inst_30165);
} else {
if((state_val_30191 === (8))){
var inst_30145 = (state_30190[(9)]);
var inst_30144 = (state_30190[(10)]);
var inst_30147 = (inst_30145 < inst_30144);
var inst_30148 = inst_30147;
var state_30190__$1 = state_30190;
if(cljs.core.truth_(inst_30148)){
var statearr_30224_31760 = state_30190__$1;
(statearr_30224_31760[(1)] = (10));

} else {
var statearr_30225_31761 = state_30190__$1;
(statearr_30225_31761[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____0 = (function (){
var statearr_30226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30226[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__);

(statearr_30226[(1)] = (1));

return statearr_30226;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____1 = (function (state_30190){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30190);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30227){if((e30227 instanceof Object)){
var ex__28141__auto__ = e30227;
var statearr_30228_31762 = state_30190;
(statearr_30228_31762[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30227;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31763 = state_30190;
state_30190 = G__31763;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__ = function(state_30190){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____1.call(this,state_30190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28138__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30229 = f__28280__auto__();
(statearr_30229[(6)] = c__28279__auto__);

return statearr_30229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));

return c__28279__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30231 = arguments.length;
switch (G__30231) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30233 = arguments.length;
switch (G__30233) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30235 = arguments.length;
switch (G__30235) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28279__auto___31767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_30259){
var state_val_30260 = (state_30259[(1)]);
if((state_val_30260 === (7))){
var inst_30254 = (state_30259[(2)]);
var state_30259__$1 = state_30259;
var statearr_30261_31768 = state_30259__$1;
(statearr_30261_31768[(2)] = inst_30254);

(statearr_30261_31768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (1))){
var inst_30236 = null;
var state_30259__$1 = (function (){var statearr_30262 = state_30259;
(statearr_30262[(7)] = inst_30236);

return statearr_30262;
})();
var statearr_30263_31769 = state_30259__$1;
(statearr_30263_31769[(2)] = null);

(statearr_30263_31769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (4))){
var inst_30239 = (state_30259[(8)]);
var inst_30239__$1 = (state_30259[(2)]);
var inst_30240 = (inst_30239__$1 == null);
var inst_30241 = cljs.core.not(inst_30240);
var state_30259__$1 = (function (){var statearr_30264 = state_30259;
(statearr_30264[(8)] = inst_30239__$1);

return statearr_30264;
})();
if(inst_30241){
var statearr_30265_31770 = state_30259__$1;
(statearr_30265_31770[(1)] = (5));

} else {
var statearr_30266_31771 = state_30259__$1;
(statearr_30266_31771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (6))){
var state_30259__$1 = state_30259;
var statearr_30267_31772 = state_30259__$1;
(statearr_30267_31772[(2)] = null);

(statearr_30267_31772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (3))){
var inst_30256 = (state_30259[(2)]);
var inst_30257 = cljs.core.async.close_BANG_(out);
var state_30259__$1 = (function (){var statearr_30268 = state_30259;
(statearr_30268[(9)] = inst_30256);

return statearr_30268;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30259__$1,inst_30257);
} else {
if((state_val_30260 === (2))){
var state_30259__$1 = state_30259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30259__$1,(4),ch);
} else {
if((state_val_30260 === (11))){
var inst_30239 = (state_30259[(8)]);
var inst_30248 = (state_30259[(2)]);
var inst_30236 = inst_30239;
var state_30259__$1 = (function (){var statearr_30269 = state_30259;
(statearr_30269[(7)] = inst_30236);

(statearr_30269[(10)] = inst_30248);

return statearr_30269;
})();
var statearr_30270_31773 = state_30259__$1;
(statearr_30270_31773[(2)] = null);

(statearr_30270_31773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (9))){
var inst_30239 = (state_30259[(8)]);
var state_30259__$1 = state_30259;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30259__$1,(11),out,inst_30239);
} else {
if((state_val_30260 === (5))){
var inst_30236 = (state_30259[(7)]);
var inst_30239 = (state_30259[(8)]);
var inst_30243 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30239,inst_30236);
var state_30259__$1 = state_30259;
if(inst_30243){
var statearr_30272_31774 = state_30259__$1;
(statearr_30272_31774[(1)] = (8));

} else {
var statearr_30273_31775 = state_30259__$1;
(statearr_30273_31775[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (10))){
var inst_30251 = (state_30259[(2)]);
var state_30259__$1 = state_30259;
var statearr_30274_31776 = state_30259__$1;
(statearr_30274_31776[(2)] = inst_30251);

(statearr_30274_31776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30260 === (8))){
var inst_30236 = (state_30259[(7)]);
var tmp30271 = inst_30236;
var inst_30236__$1 = tmp30271;
var state_30259__$1 = (function (){var statearr_30275 = state_30259;
(statearr_30275[(7)] = inst_30236__$1);

return statearr_30275;
})();
var statearr_30276_31777 = state_30259__$1;
(statearr_30276_31777[(2)] = null);

(statearr_30276_31777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30277 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30277[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30277[(1)] = (1));

return statearr_30277;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30259){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30259);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30278){if((e30278 instanceof Object)){
var ex__28141__auto__ = e30278;
var statearr_30279_31778 = state_30259;
(statearr_30279_31778[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30259);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30278;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31779 = state_30259;
state_30259 = G__31779;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30259){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30280 = f__28280__auto__();
(statearr_30280[(6)] = c__28279__auto___31767);

return statearr_30280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30282 = arguments.length;
switch (G__30282) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28279__auto___31781 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_30320){
var state_val_30321 = (state_30320[(1)]);
if((state_val_30321 === (7))){
var inst_30316 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30322_31782 = state_30320__$1;
(statearr_30322_31782[(2)] = inst_30316);

(statearr_30322_31782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (1))){
var inst_30283 = (new Array(n));
var inst_30284 = inst_30283;
var inst_30285 = (0);
var state_30320__$1 = (function (){var statearr_30323 = state_30320;
(statearr_30323[(7)] = inst_30285);

(statearr_30323[(8)] = inst_30284);

return statearr_30323;
})();
var statearr_30324_31783 = state_30320__$1;
(statearr_30324_31783[(2)] = null);

(statearr_30324_31783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (4))){
var inst_30288 = (state_30320[(9)]);
var inst_30288__$1 = (state_30320[(2)]);
var inst_30289 = (inst_30288__$1 == null);
var inst_30290 = cljs.core.not(inst_30289);
var state_30320__$1 = (function (){var statearr_30325 = state_30320;
(statearr_30325[(9)] = inst_30288__$1);

return statearr_30325;
})();
if(inst_30290){
var statearr_30326_31784 = state_30320__$1;
(statearr_30326_31784[(1)] = (5));

} else {
var statearr_30327_31785 = state_30320__$1;
(statearr_30327_31785[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (15))){
var inst_30310 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30328_31786 = state_30320__$1;
(statearr_30328_31786[(2)] = inst_30310);

(statearr_30328_31786[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (13))){
var state_30320__$1 = state_30320;
var statearr_30329_31787 = state_30320__$1;
(statearr_30329_31787[(2)] = null);

(statearr_30329_31787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (6))){
var inst_30285 = (state_30320[(7)]);
var inst_30306 = (inst_30285 > (0));
var state_30320__$1 = state_30320;
if(cljs.core.truth_(inst_30306)){
var statearr_30330_31788 = state_30320__$1;
(statearr_30330_31788[(1)] = (12));

} else {
var statearr_30331_31789 = state_30320__$1;
(statearr_30331_31789[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (3))){
var inst_30318 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30320__$1,inst_30318);
} else {
if((state_val_30321 === (12))){
var inst_30284 = (state_30320[(8)]);
var inst_30308 = cljs.core.vec(inst_30284);
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30320__$1,(15),out,inst_30308);
} else {
if((state_val_30321 === (2))){
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30320__$1,(4),ch);
} else {
if((state_val_30321 === (11))){
var inst_30300 = (state_30320[(2)]);
var inst_30301 = (new Array(n));
var inst_30284 = inst_30301;
var inst_30285 = (0);
var state_30320__$1 = (function (){var statearr_30332 = state_30320;
(statearr_30332[(7)] = inst_30285);

(statearr_30332[(10)] = inst_30300);

(statearr_30332[(8)] = inst_30284);

return statearr_30332;
})();
var statearr_30333_31790 = state_30320__$1;
(statearr_30333_31790[(2)] = null);

(statearr_30333_31790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (9))){
var inst_30284 = (state_30320[(8)]);
var inst_30298 = cljs.core.vec(inst_30284);
var state_30320__$1 = state_30320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30320__$1,(11),out,inst_30298);
} else {
if((state_val_30321 === (5))){
var inst_30285 = (state_30320[(7)]);
var inst_30293 = (state_30320[(11)]);
var inst_30288 = (state_30320[(9)]);
var inst_30284 = (state_30320[(8)]);
var inst_30292 = (inst_30284[inst_30285] = inst_30288);
var inst_30293__$1 = (inst_30285 + (1));
var inst_30294 = (inst_30293__$1 < n);
var state_30320__$1 = (function (){var statearr_30334 = state_30320;
(statearr_30334[(11)] = inst_30293__$1);

(statearr_30334[(12)] = inst_30292);

return statearr_30334;
})();
if(cljs.core.truth_(inst_30294)){
var statearr_30335_31791 = state_30320__$1;
(statearr_30335_31791[(1)] = (8));

} else {
var statearr_30336_31792 = state_30320__$1;
(statearr_30336_31792[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (14))){
var inst_30313 = (state_30320[(2)]);
var inst_30314 = cljs.core.async.close_BANG_(out);
var state_30320__$1 = (function (){var statearr_30338 = state_30320;
(statearr_30338[(13)] = inst_30313);

return statearr_30338;
})();
var statearr_30339_31793 = state_30320__$1;
(statearr_30339_31793[(2)] = inst_30314);

(statearr_30339_31793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (10))){
var inst_30304 = (state_30320[(2)]);
var state_30320__$1 = state_30320;
var statearr_30340_31794 = state_30320__$1;
(statearr_30340_31794[(2)] = inst_30304);

(statearr_30340_31794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30321 === (8))){
var inst_30293 = (state_30320[(11)]);
var inst_30284 = (state_30320[(8)]);
var tmp30337 = inst_30284;
var inst_30284__$1 = tmp30337;
var inst_30285 = inst_30293;
var state_30320__$1 = (function (){var statearr_30341 = state_30320;
(statearr_30341[(7)] = inst_30285);

(statearr_30341[(8)] = inst_30284__$1);

return statearr_30341;
})();
var statearr_30342_31795 = state_30320__$1;
(statearr_30342_31795[(2)] = null);

(statearr_30342_31795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30343[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30343[(1)] = (1));

return statearr_30343;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30320){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30320);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30344){if((e30344 instanceof Object)){
var ex__28141__auto__ = e30344;
var statearr_30345_31796 = state_30320;
(statearr_30345_31796[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30320);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30344;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31797 = state_30320;
state_30320 = G__31797;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30320){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30346 = f__28280__auto__();
(statearr_30346[(6)] = c__28279__auto___31781);

return statearr_30346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30348 = arguments.length;
switch (G__30348) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28279__auto___31799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28280__auto__ = (function (){var switch__28137__auto__ = (function (state_30395){
var state_val_30396 = (state_30395[(1)]);
if((state_val_30396 === (7))){
var inst_30391 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30397_31800 = state_30395__$1;
(statearr_30397_31800[(2)] = inst_30391);

(statearr_30397_31800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (1))){
var inst_30354 = [];
var inst_30355 = inst_30354;
var inst_30356 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30395__$1 = (function (){var statearr_30398 = state_30395;
(statearr_30398[(7)] = inst_30356);

(statearr_30398[(8)] = inst_30355);

return statearr_30398;
})();
var statearr_30399_31801 = state_30395__$1;
(statearr_30399_31801[(2)] = null);

(statearr_30399_31801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (4))){
var inst_30359 = (state_30395[(9)]);
var inst_30359__$1 = (state_30395[(2)]);
var inst_30360 = (inst_30359__$1 == null);
var inst_30361 = cljs.core.not(inst_30360);
var state_30395__$1 = (function (){var statearr_30400 = state_30395;
(statearr_30400[(9)] = inst_30359__$1);

return statearr_30400;
})();
if(inst_30361){
var statearr_30401_31802 = state_30395__$1;
(statearr_30401_31802[(1)] = (5));

} else {
var statearr_30402_31803 = state_30395__$1;
(statearr_30402_31803[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (15))){
var inst_30385 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30403_31804 = state_30395__$1;
(statearr_30403_31804[(2)] = inst_30385);

(statearr_30403_31804[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (13))){
var state_30395__$1 = state_30395;
var statearr_30404_31805 = state_30395__$1;
(statearr_30404_31805[(2)] = null);

(statearr_30404_31805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (6))){
var inst_30355 = (state_30395[(8)]);
var inst_30380 = inst_30355.length;
var inst_30381 = (inst_30380 > (0));
var state_30395__$1 = state_30395;
if(cljs.core.truth_(inst_30381)){
var statearr_30405_31806 = state_30395__$1;
(statearr_30405_31806[(1)] = (12));

} else {
var statearr_30406_31807 = state_30395__$1;
(statearr_30406_31807[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (3))){
var inst_30393 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30395__$1,inst_30393);
} else {
if((state_val_30396 === (12))){
var inst_30355 = (state_30395[(8)]);
var inst_30383 = cljs.core.vec(inst_30355);
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30395__$1,(15),out,inst_30383);
} else {
if((state_val_30396 === (2))){
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30395__$1,(4),ch);
} else {
if((state_val_30396 === (11))){
var inst_30359 = (state_30395[(9)]);
var inst_30363 = (state_30395[(10)]);
var inst_30373 = (state_30395[(2)]);
var inst_30374 = [];
var inst_30375 = inst_30374.push(inst_30359);
var inst_30355 = inst_30374;
var inst_30356 = inst_30363;
var state_30395__$1 = (function (){var statearr_30407 = state_30395;
(statearr_30407[(7)] = inst_30356);

(statearr_30407[(11)] = inst_30375);

(statearr_30407[(8)] = inst_30355);

(statearr_30407[(12)] = inst_30373);

return statearr_30407;
})();
var statearr_30408_31808 = state_30395__$1;
(statearr_30408_31808[(2)] = null);

(statearr_30408_31808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (9))){
var inst_30355 = (state_30395[(8)]);
var inst_30371 = cljs.core.vec(inst_30355);
var state_30395__$1 = state_30395;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30395__$1,(11),out,inst_30371);
} else {
if((state_val_30396 === (5))){
var inst_30356 = (state_30395[(7)]);
var inst_30359 = (state_30395[(9)]);
var inst_30363 = (state_30395[(10)]);
var inst_30363__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30359) : f.call(null,inst_30359));
var inst_30364 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30363__$1,inst_30356);
var inst_30365 = cljs.core.keyword_identical_QMARK_(inst_30356,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30366 = ((inst_30364) || (inst_30365));
var state_30395__$1 = (function (){var statearr_30409 = state_30395;
(statearr_30409[(10)] = inst_30363__$1);

return statearr_30409;
})();
if(cljs.core.truth_(inst_30366)){
var statearr_30410_31809 = state_30395__$1;
(statearr_30410_31809[(1)] = (8));

} else {
var statearr_30411_31810 = state_30395__$1;
(statearr_30411_31810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (14))){
var inst_30388 = (state_30395[(2)]);
var inst_30389 = cljs.core.async.close_BANG_(out);
var state_30395__$1 = (function (){var statearr_30413 = state_30395;
(statearr_30413[(13)] = inst_30388);

return statearr_30413;
})();
var statearr_30414_31811 = state_30395__$1;
(statearr_30414_31811[(2)] = inst_30389);

(statearr_30414_31811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (10))){
var inst_30378 = (state_30395[(2)]);
var state_30395__$1 = state_30395;
var statearr_30415_31812 = state_30395__$1;
(statearr_30415_31812[(2)] = inst_30378);

(statearr_30415_31812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30396 === (8))){
var inst_30359 = (state_30395[(9)]);
var inst_30355 = (state_30395[(8)]);
var inst_30363 = (state_30395[(10)]);
var inst_30368 = inst_30355.push(inst_30359);
var tmp30412 = inst_30355;
var inst_30355__$1 = tmp30412;
var inst_30356 = inst_30363;
var state_30395__$1 = (function (){var statearr_30416 = state_30395;
(statearr_30416[(14)] = inst_30368);

(statearr_30416[(7)] = inst_30356);

(statearr_30416[(8)] = inst_30355__$1);

return statearr_30416;
})();
var statearr_30417_31813 = state_30395__$1;
(statearr_30417_31813[(2)] = null);

(statearr_30417_31813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28138__auto__ = null;
var cljs$core$async$state_machine__28138__auto____0 = (function (){
var statearr_30418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30418[(0)] = cljs$core$async$state_machine__28138__auto__);

(statearr_30418[(1)] = (1));

return statearr_30418;
});
var cljs$core$async$state_machine__28138__auto____1 = (function (state_30395){
while(true){
var ret_value__28139__auto__ = (function (){try{while(true){
var result__28140__auto__ = switch__28137__auto__(state_30395);
if(cljs.core.keyword_identical_QMARK_(result__28140__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28140__auto__;
}
break;
}
}catch (e30419){if((e30419 instanceof Object)){
var ex__28141__auto__ = e30419;
var statearr_30420_31814 = state_30395;
(statearr_30420_31814[(5)] = ex__28141__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30395);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30419;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28139__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31815 = state_30395;
state_30395 = G__31815;
continue;
} else {
return ret_value__28139__auto__;
}
break;
}
});
cljs$core$async$state_machine__28138__auto__ = function(state_30395){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28138__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28138__auto____1.call(this,state_30395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28138__auto____0;
cljs$core$async$state_machine__28138__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28138__auto____1;
return cljs$core$async$state_machine__28138__auto__;
})()
})();
var state__28281__auto__ = (function (){var statearr_30421 = f__28280__auto__();
(statearr_30421[(6)] = c__28279__auto___31799);

return statearr_30421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28281__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
